/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasColor;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.GeodeticUtil;
import nxm.sys.lib.Message;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.PredicateType;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;
import nxm.sys.lib.XmUtil;
import nxm.sys.libg.DPix;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GeometricUtil;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.IntersectingLine;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Pix;
import nxm.sys.libg.Point3D;
import nxm.sys.libg.PopUpHTML;
import nxm.sys.libg.RegionGroup;
import nxm.sys.libg.Symbol;
import nxm.sys.prim.plot;

public class LayerT5
extends Layer {
    public static final String selectionModes = "Pixel,GreatArc";
    public static final String fieldList = "Symbols,Labels,Elps,Cones,Connect";
    public static final String flagsList = "ConeFlagHoriz,ConeFlagVert,TimeScaleLabels,AutoScaleLabels,FillCones";
    public static final int NEAREST_BY_PIXELS = 1;
    public static final int NEAREST_BY_GREAT_ARC = 2;
    public static final int SYMBOLS = 1;
    public static final int LABELS = 2;
    public static final int ELLIPSES = 4;
    public static final int CONES = 8;
    public static final int CONNECT = 16;
    public static final int CONE_FLAG_HORIZ = 1;
    private PopUpHTML htmlPopup;
    private boolean isListFile = false;
    private boolean firstPassFindGraphRange = true;
    private boolean isGeodeticData = true;
    private boolean ignoreRange = false;
    public static final int CONE_FLAG_VERT = 2;
    public static final int SHOW_TIME_SCALE_LABELS = 4;
    public static final int AUTO_SCALE_LABELS = 8;
    public static final int FILL_CONES = 16;
    private static final String SPLIT_REGEX = "\\s*[,|]\\s*";
    private Point3D[] points = null;
    private boolean showClusters;
    private boolean formRegionGroups;
    RegionGroup[][] regionGroups = new RegionGroup[MPlot.LONGITUDE_RANGE / 20][MPlot.LATITUDE_RANGE / 20];
    private boolean doPosp;
    private boolean doVec;
    private boolean doCones;
    private boolean doEllipses;
    private boolean doPos;
    int numSpotsUsedInPointsArray = 0;
    private Stack<Integer> pointsNulled = new Stack();
    private int firstPoint = -1;
    private int maxPointsSize = -1;
    private int autoSelMode = 2;
    private double autoSelRange = 500000.0;
    private int autoSelEnable = 0;
    @Deprecated
    public int field = -1;
    @Deprecated
    public int select = -1;
    @Deprecated
    public double tlreg = 10.0;
    private String[] selectedKeys = null;
    private int bName = -1;
    private int bPos = -1;
    private int bPosp = -1;
    private int bCone = -1;
    private int bElps = -1;
    private int bFlag = -1;
    private int bConn = -1;
    private int bNote = -1;
    private int bHdg = -1;
    int bVec = -1;
    int bTime = -1;
    int bMeta = -1;
    int bColor = -1;
    int bSymbol = -1;
    private int bEllipsoid = -1;
    private int dVec = -1;
    private String fName = null;
    private String fNote = null;
    private String fCone = null;
    private String fMeta = null;
    private String fColor = null;
    private String fSymbol = null;
    private Transform transform = null;
    private boolean timeAxis = false;
    private int fontsize = 0;
    private Font font = null;
    Pix pix = null;
    private DataFile df = null;
    private int conic = 1;
    private int cdiv = 60;
    private double cangle = 1.0;
    private double crange = 0.0;
    private int eSlices = 3;
    private boolean leftLabels = false;
    private Color selectColor = Color.RED;
    private int flags = 9;
    private boolean initialized = false;
    private boolean toLLA = false;
    private boolean _labelZoom = false;
    private boolean _symbols = false;
    private boolean _labels = false;
    private boolean _connect = false;
    private boolean _connectAll = false;
    private boolean _selected = false;
    private Color _color = null;
    private boolean _showAll = false;
    private boolean minMaxSet = false;
    private double minLon = 0.0;
    private double maxLon = 0.0;
    private double minLat = 0.0;
    private double maxLat = 0.0;
    private double minAlt = 0.0;
    private double maxAlt = 0.0;
    private double vscale = 0.0;
    private boolean quickDraw = false;
    private Point3D timePoint = null;
    private char ellipseMajorFormat;
    private char ellipseMinorFormat;
    private char ellipseTiltFormat;
    private char ellipsoidMajorFormat;
    private char ellipsoidMinorFormat;
    private char ellipsoidMedianFormat;
    private char ellipsoidRotationXFormat;
    private char ellipsoidRotationYFormat;
    private char ellipsoidRotationZFormat;
    private char xFormat;
    private char yFormat;
    private char zFormat;
    private char nFormat;
    private char pospXFormat;
    private char pospYFormat;
    private char pospZFormat;
    private char coneAFormat;
    private char coneBFormat;
    private char coneAngleFormat;
    private char flagNoteFormat;
    private char timeFormat;
    private char metaFormat;
    private char colorFormat;
    private char symbolFormat;
    private int bEllipseMajor = -1;
    private int bEllipseMinor = -1;
    private int bEllipseTilt = -1;
    private int bEllipsoidMajor = -1;
    private int bEllipsoidMinor = -1;
    private int bEllipsoidMedian = -1;
    private int bEllipsoidRotationX = -1;
    private int bEllipsoidRotationY = -1;
    private int bEllipsoidRotationZ = -1;
    private int bPosX = -1;
    private int bPosY = -1;
    private int bPosZ = -1;
    private int bPospX = -1;
    private int bPospY = -1;
    private int bPospZ = -1;
    private int bConeA = -1;
    private int bConeB = -1;
    private int bConeAngle = -1;
    private int bFlagNote = -1;
    private int bTimeLF = -1;
    private int bMetaPos = -1;
    private int bColorPos = -1;
    private int bSymbolPos = -1;
    private char[] flagFormats = this.buildFormatsArray();
    private int[] bFlags = this.buildFlagBytePosArray();
    private String[] metadataFieldNames;
    private String[] fMetas;
    private int[] bMetas;
    private char[] metaFormats;
    private int[] bMetasPos;
    private Map<String, PredicateType> visibilityFilter;
    private Map<String, HighlightSetting> highlightSettingMap = new HashMap<String, HighlightSetting>();
    volatile boolean needFilteredPoints = false;
    ArrayList<Point3D> filteredPoints;
    static final double SLEEP_INTERVAL = 0.01;
    private boolean addNameFD;
    private boolean addPosFD;
    private boolean addPospFD;
    private boolean addElpsFD;
    private boolean addConeFD;
    private boolean addTimeFD;
    private boolean addNoteFD;
    private boolean addMetaFD;
    private double xRange = 1.0;
    private double yRange = 1.0;
    private double zRange = 1.0;
    private int numVisiblePoints = 0;
    int minimumClusterSize = 5;
    private double tDelta = 1.0;
    private double tlTime = 0.0;
    private boolean activeTimeWindow = false;
    public static final int INACTIVE = -1;
    public static final int WINDOW_OFF = 0;
    public static final int WINDOW_FIXED = 1;
    public static final int WINDOW_RELATIVE = 2;
    public static final int WINDOW_RELATIVE_POINT = 2;
    public static final int WINDOW_RELATIVE_CLOCK = 3;
    private double newestTimeReceived = 0.0;
    private double oldestTimeVisible = -1.0;
    private double newestTimeVisible = -1.0;
    private double relativeOldestTimeVisible = -1.0;
    private double relativeNewestTimeVisible = -1.0;
    private boolean relativeTimeWindow = false;
    private int relativeMode = 2;
    private boolean needsTimeOrder = false;
    private LinkedList<Integer> timeSortOfPtIndicies = null;
    private static boolean filePointsSizeSettable = true;
    private static final Time ZERO_TIME = new Time(0.0);
    private static final double PIXEL_MAX_RANGE = 625.0;
    private boolean sendSelectMessages = false;
    private boolean sendHighlightTotalMessages = false;
    private MessageHandler mwMsgHandler = null;
    private boolean colorFade = false;
    private int colorFadeFactor = 5;
    private int fadeColorR = 50;
    private int fadeColorG = 50;
    private int fadeColorB = 50;
    private static double xyPointXMargin = 0.0;
    private static double xyPointYMargin = 0.0;
    private boolean activePopup;
    Table popupLabels = new Table();
    private static boolean autoAdjustLineColor = false;

    public LayerT5() {
        this.symbolFormat = (char)32;
        this.colorFormat = (char)32;
        this.metaFormat = (char)32;
        this.timeFormat = (char)32;
        this.flagNoteFormat = (char)32;
        this.coneAngleFormat = (char)32;
        this.coneBFormat = (char)32;
        this.coneAFormat = (char)32;
        this.pospZFormat = (char)32;
        this.pospYFormat = (char)32;
        this.pospXFormat = (char)32;
        this.nFormat = (char)32;
        this.zFormat = (char)32;
        this.yFormat = (char)32;
        this.xFormat = (char)32;
        this.ellipsoidRotationZFormat = (char)32;
        this.ellipsoidRotationYFormat = (char)32;
        this.ellipsoidRotationXFormat = (char)32;
        this.ellipsoidMedianFormat = (char)32;
        this.ellipsoidMinorFormat = (char)32;
        this.ellipsoidMajorFormat = (char)32;
        this.ellipseTiltFormat = (char)32;
        this.ellipseMinorFormat = (char)32;
        this.ellipseMajorFormat = (char)32;
        this.name = "T5";
        this.enable &= 0xFFFFFFFB;
        this.line.setRadius(3);
        this.line.setSymbol("CROSS");
        this.line.getSymbol().setSize(4);
        this.line.setType(33);
        this.needRefresh = true;
        this.pix = new Pix(1, 0);
        this.zaxis = true;
    }

    public LayerT5(int size) {
        this();
        this.setSizeWithForceOpt(size, false);
    }

    public void setField(int value) {
        this.field = value;
        this.refresh();
    }

    public List<Point3D> getPointsAsList() {
        if (this.points == null) {
            return new ArrayList<Point3D>();
        }
        if (this.numSpotsUsedInPointsArray == this.points.length && this.pointsNulled.isEmpty()) {
            return Arrays.asList(this.points);
        }
        ArrayList<Point3D> pointsAsList = new ArrayList<Point3D>();
        for (int i = 0; i < this.numSpotsUsedInPointsArray; ++i) {
            if (this.points[i] == null) continue;
            pointsAsList.add(this.points[i]);
        }
        return pointsAsList;
    }

    @InternalUseOnly
    public double[] getArrayPoints(int dim) {
        int maxcoords;
        if (this.points == null) {
            return new double[0];
        }
        int actcoords = maxcoords = this.numSpotsUsedInPointsArray * dim;
        double[] coordstemp = new double[maxcoords];
        int i = 0;
        int c = 0;
        while (i < this.numSpotsUsedInPointsArray) {
            if (this.points[i] != null) {
                coordstemp[c] = this.points[i].posLon;
                coordstemp[c + 1] = this.points[i].posLat;
                if (dim == 3) {
                    coordstemp[c + 2] = this.points[i].posAlt;
                }
            } else {
                actcoords -= dim;
            }
            ++i;
            c += dim;
        }
        if (maxcoords == actcoords) {
            return coordstemp;
        }
        return Arrays.copyOf(coordstemp, actcoords);
    }

    public List<Point3D> getPointsMatchingFilter() {
        if (this.visibilityFilter == null && !this.activeTimeWindow) {
            return this.getPointsAsList();
        }
        if (!this.needFilteredPoints) {
            this.needFilteredPoints = true;
            this.refresh();
        }
        int whileCount = 0;
        while (this.needFilteredPoints) {
            Time.sleep(0.01);
            ++whileCount;
        }
        return this.filteredPoints;
    }

    public void setField(String value) {
        this.setField(Parser.mask(fieldList, value, this.field));
    }

    public String getField() {
        return Parser.mask2s(fieldList, this.field);
    }

    @Override
    public synchronized boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        if (this.typeClass != 5 && !(pf instanceof ListFile)) {
            return false;
        }
        String pipeSeparatedMetaNames = tab == null ? null : tab.getS("METADATAFIELDS");
        this.metadataFieldNames = pipeSeparatedMetaNames == null || pipeSeparatedMetaNames.isEmpty() ? null : tab.getS("METADATAFIELDS").split("\\|");
        String filterDataFields = tab == null ? null : tab.getS("FILTERDATAFIELDS");
        this.setFilterDataEntries(filterDataFields);
        if (pf instanceof DataFile) {
            this.df = (DataFile)pf;
            DataFile df = (DataFile)pf;
            this.tDelta = df.getDelta();
            this.tlTime = df.getTimeAt();
            int iPos = df.findRec("POS");
            int iPosp = df.findRec("POSP");
            int iCone = df.findRec("CONE");
            int iName = df.findRec("NAME");
            int iNote = df.findRec("NOTE");
            int iFlag = df.findRec("FLAG");
            int iElps = df.findRec("ELPS");
            int iConn = df.findRec("CONN");
            int iHdg = df.findRec("HDG");
            int iTime = df.findRec("TIME");
            int iMeta = df.findRec("METADATA");
            int iColor = df.findRec("COLOR");
            int iSymbol = df.findRec("SYMBOL");
            int iEllipsoid = df.findRec("ELLIPSOID");
            if (iEllipsoid == -1) {
                iEllipsoid = df.findRec("ELPSOID");
            }
            this.bPos = iPos >= 0 ? (int)df.getCompOffset(iPos) : -1;
            this.bPosp = iPosp >= 0 ? (int)df.getCompOffset(iPosp) : -1;
            this.bCone = iCone >= 0 ? (int)df.getCompOffset(iCone) : -1;
            this.bName = iName >= 0 ? (int)df.getCompOffset(iName) : -1;
            this.bNote = iNote >= 0 ? (int)df.getCompOffset(iNote) : -1;
            this.bFlag = iFlag >= 0 ? (int)df.getCompOffset(iFlag) : -1;
            this.bElps = iElps >= 0 ? (int)df.getCompOffset(iElps) : -1;
            this.bConn = iConn >= 0 ? (int)df.getCompOffset(iConn) : -1;
            this.bHdg = iHdg >= 0 ? (int)df.getCompOffset(iHdg) : -1;
            this.bTime = iTime >= 0 ? (int)df.getCompOffset(iTime) : -1;
            this.bMeta = iMeta >= 0 ? (int)df.getCompOffset(iMeta) : -1;
            this.bColor = iColor >= 0 ? (int)df.getCompOffset(iColor) : -1;
            this.bSymbol = iSymbol >= 0 ? (int)df.getCompOffset(iSymbol) : -1;
            this.bEllipsoid = iEllipsoid >= 0 ? (int)df.getCompOffset(iEllipsoid) : -1;
            this.fCone = df.getCompFormat(iCone);
            this.fName = df.getCompFormat(iName);
            this.fNote = df.getCompFormat(iNote);
            this.fMeta = df.getCompFormat(iMeta);
            this.fColor = df.getCompFormat(iColor);
            this.fSymbol = df.getCompFormat(iSymbol);
            this.setDFMultiFieldMetadata(df);
            if (df.isPipe()) {
                this.firstPoint = 0;
            }
        } else if (pf instanceof ListFile) {
            this.setupListFile((ListFile)((Object)pf), tab);
        }
        this.setSizeWithForceOpt((int)pf.getSize(), false);
        this.setData(pf.getDataBuffer(this.size));
        if (this.df != null) {
            this.transform = new Transform(this.df);
            this.toLLA = !this.df.getReferenceFrame().equals("NONE");
        }
        this.timeAxis = pf.getXUnits() == 1;
        this.quickDraw = MA != null ? MA.getState("/QUICKDRAW", this.quickDraw) : false;
        return true;
    }

    private void setFilterDataEntries(String fields) {
        boolean addAll;
        if (fields == null || fields.isEmpty()) {
            fields = "META";
        }
        if (addAll = "ALL".equals(fields = fields.toUpperCase().trim())) {
            this.addConeFD = true;
            this.addElpsFD = true;
            this.addPospFD = true;
            this.addPosFD = true;
            this.addNameFD = true;
            this.addMetaFD = true;
            this.addNoteFD = true;
            this.addTimeFD = true;
        } else {
            String[] fieldNames = fields == null || fields.isEmpty() ? null : fields.split("\\|");
            List fieldList = Arrays.asList(fieldNames);
            this.addNameFD = fieldList.contains("NAME");
            this.addPosFD = fieldList.contains("POS");
            this.addPospFD = fieldList.contains("POSP");
            this.addElpsFD = fieldList.contains("ELPS");
            this.addConeFD = fieldList.contains("CONE");
            this.addTimeFD = fieldList.contains("TIME");
            this.addNoteFD = fieldList.contains("NOTE");
            this.addMetaFD = fieldList.contains("META");
        }
    }

    private void setDFMultiFieldMetadata(DataFile df) {
        if (this.metadataFieldNames == null) {
            return;
        }
        this.bMetas = new int[this.metadataFieldNames.length];
        this.fMetas = new String[this.metadataFieldNames.length];
        int i = 0;
        for (String field : this.metadataFieldNames) {
            int index = df.findRec(field);
            this.bMetas[i] = index >= 0 ? (int)df.getCompOffset(index) : -1;
            this.fMetas[i] = df.getCompFormat(index);
            ++i;
        }
    }

    private void setupListFile(ListFile lf, Table tab) {
        List<String> metaNamesList;
        this.isListFile = true;
        if (tab == null) {
            tab = new Table();
        }
        String xRecName = tab.getS("X", "X");
        String yRecName = tab.getS("Y", "Y");
        String zRecName = tab.getS("Z", "Z");
        String nRecName = tab.getS("LABEL", "NAME");
        String ellipseMajorName = tab.getS("EMAJ", "EMAJ");
        String ellipseMinorName = tab.getS("EMIN", "EMIN");
        String ellipseTiltName = tab.getS("ETILT", "ETILT");
        String ellipsoidMajorName = tab.getS("ELLIPSOIDMAJ", "ELLIPSOIDMAJ");
        String ellipsoidMinorName = tab.getS("ELLIPSOIDMIN", "ELLIPSOIDMIN");
        String ellipsoidMedianName = tab.getS("ELLIPSOIDMED", "ELLIPSOIDMED");
        String ellipsoidRotationXName = tab.getS("ELLIPSOIDROTX", "ELLIPSOIDROTX");
        String ellipsoidRotationYName = tab.getS("ELLIPSOIDROTY", "ELLIPSOIDROTY");
        String ellipsoidRotationZName = tab.getS("ELLIPSOIDROTZ", "ELLIPSOIDROTZ");
        String[] flagRecNames = new String[8];
        for (int i = 0; i < flagRecNames.length; ++i) {
            String key = "F" + (i + 1);
            flagRecNames[i] = tab.getS(key, key);
        }
        String coneAName = tab.getS("CONEA", "CONEA");
        String coneBName = tab.getS("CONEB", "CONEB");
        String coneAngleName = tab.getS("CONEANGLE", "CONEANGLE");
        String pospXName = tab.getS("POSPX", "POSPX");
        String pospYName = tab.getS("POSPY", "POSPY");
        String pospZName = tab.getS("POSPZ", "POSPZ");
        String flagNoteName = tab.getS("NOTE", "NOTE");
        String timeName = tab.getS("TIMELF", "TIME");
        String metaName = tab.getS("METADATA", "METADATA");
        String colorName = tab.getS("COLOR", "COLOR");
        String symbolName = tab.getS("SYMBOL", "SYMBOL");
        int bSymbolPos = 0;
        int bColorPos = 0;
        int bMetaPos = 0;
        int bTimeLF = 0;
        int bFlagNote = 0;
        int bPospZ = 0;
        int bPospY = 0;
        int bPospX = 0;
        int bConeAngle = 0;
        int bConeB = 0;
        int bConeA = 0;
        int bEllipsoidRotationZ = 0;
        int bEllipsoidRotationY = 0;
        int bEllipsoidRotationX = 0;
        int bEllipsoidMedian = 0;
        int bEllipsoidMinor = 0;
        int bEllipsoidMajor = 0;
        int bEllipseTilt = 0;
        int bEllipseMinor = 0;
        int bEllipseMajor = 0;
        int bName = 0;
        int bPosZ = 0;
        int bPosY = 0;
        int bPosX = 0;
        int[] bFlags = new int[8];
        if (this.metadataFieldNames == null) {
            metaNamesList = null;
        } else {
            metaNamesList = Arrays.asList(this.metadataFieldNames);
            this.metaFormats = new char[this.metadataFieldNames.length];
            this.bMetasPos = new int[this.metadataFieldNames.length];
            Arrays.fill(this.metaFormats, ' ');
        }
        for (int i = 0; i < lf.getRecordDefCount(); ++i) {
            int j;
            Table recDef = lf.getRecordDef(i);
            String fmt = recDef.getS("FORMAT", "XA");
            if (xRecName.equals(recDef.getS("NAME"))) {
                this.xFormat = fmt.charAt(1);
                this.bPosX = recDef.getL("OFFSET", bPosX);
            } else if (yRecName.equals(recDef.getS("NAME"))) {
                this.yFormat = fmt.charAt(1);
                this.bPosY = recDef.getL("OFFSET", bPosY);
            } else if (zRecName.equals(recDef.getS("NAME"))) {
                this.zFormat = fmt.charAt(1);
                this.bPosZ = recDef.getL("OFFSET", bPosZ);
            } else if (nRecName.equals(recDef.getS("NAME"))) {
                this.nFormat = fmt.charAt(1);
                this.bName = recDef.getL("OFFSET", bName);
            } else if (ellipseMajorName.equals(recDef.getS("NAME"))) {
                this.ellipseMajorFormat = fmt.charAt(1);
                this.bEllipseMajor = recDef.getL("OFFSET", bEllipseMajor);
            } else if (ellipseMinorName.equals(recDef.getS("NAME"))) {
                this.ellipseMinorFormat = fmt.charAt(1);
                this.bEllipseMinor = recDef.getL("OFFSET", bEllipseMinor);
            } else if (ellipseTiltName.equals(recDef.getS("NAME"))) {
                this.ellipseTiltFormat = fmt.charAt(1);
                this.bEllipseTilt = recDef.getL("OFFSET", bEllipseTilt);
            } else if (ellipsoidMajorName.equals(recDef.getS("NAME"))) {
                this.ellipsoidMajorFormat = fmt.charAt(1);
                this.bEllipsoidMajor = recDef.getL("OFFSET", bEllipsoidMajor);
            } else if (ellipsoidMinorName.equals(recDef.getS("NAME"))) {
                this.ellipsoidMinorFormat = fmt.charAt(1);
                this.bEllipsoidMinor = recDef.getL("OFFSET", bEllipsoidMinor);
            } else if (ellipsoidMedianName.equals(recDef.getS("NAME"))) {
                this.ellipsoidMedianFormat = fmt.charAt(1);
                this.bEllipsoidMedian = recDef.getL("OFFSET", bEllipsoidMedian);
            } else if (ellipsoidRotationXName.equals(recDef.getS("NAME"))) {
                this.ellipsoidRotationXFormat = fmt.charAt(1);
                this.bEllipsoidRotationX = recDef.getL("OFFSET", bEllipsoidRotationX);
            } else if (ellipsoidRotationYName.equals(recDef.getS("NAME"))) {
                this.ellipsoidRotationYFormat = fmt.charAt(1);
                this.bEllipsoidRotationY = recDef.getL("OFFSET", bEllipsoidRotationY);
            } else if (ellipsoidRotationZName.equals(recDef.getS("NAME"))) {
                this.ellipsoidRotationZFormat = fmt.charAt(1);
                this.bEllipsoidRotationZ = recDef.getL("OFFSET", bEllipsoidRotationZ);
            } else if (coneAName.equals(recDef.getS("NAME"))) {
                this.coneAFormat = fmt.charAt(1);
                this.bConeA = recDef.getL("OFFSET", bConeA);
            } else if (coneBName.equals(recDef.getS("NAME"))) {
                this.coneBFormat = fmt.charAt(1);
                this.bConeB = recDef.getL("OFFSET", bConeB);
            } else if (coneAngleName.equals(recDef.getS("NAME"))) {
                this.coneAngleFormat = fmt.charAt(1);
                this.bConeAngle = recDef.getL("OFFSET", bConeAngle);
            } else if (pospXName.equals(recDef.getS("NAME"))) {
                this.pospXFormat = fmt.charAt(1);
                this.bPospX = recDef.getL("OFFSET", bPospX);
            } else if (pospYName.equals(recDef.getS("NAME"))) {
                this.pospYFormat = fmt.charAt(1);
                this.bPospY = recDef.getL("OFFSET", bPospY);
            } else if (pospZName.equals(recDef.getS("NAME"))) {
                this.pospZFormat = fmt.charAt(1);
                this.bPospZ = recDef.getL("OFFSET", bPospZ);
            } else if (timeName.equals(recDef.getS("NAME"))) {
                this.timeFormat = fmt.charAt(1);
                this.bTimeLF = recDef.getL("OFFSET", bTimeLF);
            } else if (metaName.equals(recDef.getS("NAME"))) {
                this.metaFormat = fmt.charAt(1);
                this.bMetaPos = recDef.getL("OFFSET", bMetaPos);
            } else if (colorName.equals(recDef.getS("NAME"))) {
                this.colorFormat = fmt.charAt(1);
                this.bColorPos = recDef.getL("OFFSET", bColorPos);
            } else if (flagNoteName.equals(recDef.getS("NAME"))) {
                this.flagNoteFormat = fmt.charAt(1);
                this.bFlagNote = recDef.getL("OFFSET", bFlagNote);
            } else if (symbolName.equals(recDef.getS("NAME"))) {
                this.symbolFormat = fmt.charAt(1);
                this.bSymbolPos = recDef.getL("OFFSET", bSymbolPos);
            } else {
                for (j = 0; j < flagRecNames.length; ++j) {
                    if (!flagRecNames[j].equals(recDef.getS("NAME"))) continue;
                    this.flagFormats[j] = fmt.charAt(1);
                    this.bFlags[j] = recDef.getL("OFFSET", bFlags[j]);
                }
            }
            if (metaNamesList != null && metaNamesList.contains(recDef.getS("NAME"))) {
                int index = metaNamesList.indexOf(recDef.getS("NAME"));
                this.metaFormats[index] = fmt.charAt(1);
                this.bMetasPos[index] = recDef.getL("OFFSET", this.bMetasPos[index]);
            }
            if (this.xFormat == ' ') {
                bPosX += Data.getBPA(fmt);
            }
            if (this.yFormat == ' ') {
                bPosY += Data.getBPA(fmt);
            }
            if (this.zFormat == ' ') {
                bPosZ += Data.getBPA(fmt);
            }
            if (this.nFormat == ' ') {
                bName += Data.getBPA(fmt);
            }
            if (this.ellipseMajorFormat == ' ') {
                bEllipseMajor += Data.getBPA(fmt);
            }
            if (this.ellipseMinorFormat == ' ') {
                bEllipseMinor += Data.getBPA(fmt);
            }
            if (this.ellipseTiltFormat == ' ') {
                bEllipseTilt += Data.getBPA(fmt);
            }
            if (this.ellipsoidMajorFormat == ' ') {
                bEllipsoidMajor += Data.getBPA(fmt);
            }
            if (this.ellipsoidMinorFormat == ' ') {
                bEllipsoidMinor += Data.getBPA(fmt);
            }
            if (this.ellipsoidMedianFormat == ' ') {
                bEllipsoidMedian += Data.getBPA(fmt);
            }
            if (this.ellipsoidRotationXFormat == ' ') {
                bEllipsoidRotationX += Data.getBPA(fmt);
            }
            if (this.ellipsoidRotationYFormat == ' ') {
                bEllipsoidRotationY += Data.getBPA(fmt);
            }
            if (this.ellipsoidRotationZFormat == ' ') {
                bEllipsoidRotationZ += Data.getBPA(fmt);
            }
            if (this.pospXFormat == ' ') {
                bPospX += Data.getBPA(fmt);
            }
            if (this.pospYFormat == ' ') {
                bPospY += Data.getBPA(fmt);
            }
            if (this.pospZFormat == ' ') {
                bPospZ += Data.getBPA(fmt);
            }
            if (this.coneAFormat == ' ') {
                bConeA += Data.getBPA(fmt);
            }
            if (this.coneBFormat == ' ') {
                bConeB += Data.getBPA(fmt);
            }
            if (this.coneAngleFormat == ' ') {
                bConeAngle += Data.getBPA(fmt);
            }
            if (this.flagNoteFormat == ' ') {
                bFlagNote += Data.getBPA(fmt);
            }
            for (j = 0; j < this.flagFormats.length; ++j) {
                if (this.flagFormats[j] != ' ') continue;
                int n = j;
                bFlags[n] = bFlags[n] + Data.getBPA(fmt);
            }
            if (this.timeFormat == ' ') {
                bTimeLF += Data.getBPA(fmt);
            }
            if (this.colorFormat == ' ') {
                bColorPos += Data.getBPA(fmt);
            }
            if (this.symbolFormat == ' ') {
                bSymbolPos += Data.getBPA(fmt);
            }
            if (this.metaFormat == ' ') {
                bMetaPos += Data.getBPA(fmt);
            }
            if (this.metadataFieldNames == null) continue;
            for (int mf = 0; mf < this.metadataFieldNames.length; ++mf) {
                if (this.metaFormats[mf] != ' ') continue;
                int n = mf;
                this.bMetasPos[n] = this.bMetasPos[n] + Data.getBPA(fmt);
            }
        }
        if (this.xFormat == ' ') {
            this.warning("LayerPoint Can not find subrecord '" + xRecName + "' in " + this);
        }
        if (this.yFormat == ' ') {
            this.warning("LayerPoint Can not find subrecord '" + yRecName + "' in " + this);
        }
        this.setXAxis(0.0, 1.0);
        this.setYAxis(0.0, 1.0);
    }

    public void setVName(String name) {
        int iVec = this.df.findRec(name);
        this.bVec = iVec >= 0 ? (int)this.df.getCompOffset(iVec) : -1;
        this.dVec = iVec >= 0 ? Data.getSPA(this.df.getCompFormat(iVec).charAt(0)) : 1;
    }

    public void setVScale(double scale) {
        this.vscale = scale;
    }

    @Override
    public synchronized void setSize(int size) {
        this.setSizeWithForceOpt(size, filePointsSizeSettable);
    }

    @InternalUseOnly
    public synchronized void setSizeWithForceOpt(int size, boolean forceFixedSize) {
        super.setSize(size);
        if (forceFixedSize && this.firstPoint == -1) {
            this.firstPoint = 0;
        }
        if (this.df == null && !this.isListFile) {
            this.initialized = true;
            if (this.points == null) {
                this.points = new Point3D[size];
            } else if (this.points.length != size) {
                this.points = Arrays.copyOf(this.points, size);
            }
        } else if (!this.initialized) {
            this.initialized = !this.isListFile && (size == 0 || this.df.isPipe());
            this.points = null;
        }
        this.colors = MColor.getColorMap(7, -1);
        this.line.setColor(this.colors[5]);
    }

    @ProvisionalUseOnly(value="Please let the NeXtMidas team know if you need original behavior")
    public void setFilePointsSizeSettable(String isSettable) {
        filePointsSizeSettable = isSettable.toLowerCase().startsWith("true");
    }

    public void setFilePointsSizeSettable(boolean isSettable) {
        filePointsSizeSettable = isSettable;
    }

    public void setMaxPointsSize(int maxPointsSize) {
        this.maxPointsSize = maxPointsSize;
    }

    @Override
    public synchronized void process() {
        super.process();
        if (this.time > 0.0 && !this.initialized) {
            this.initialized = true;
            this.matchTimePoint();
            return;
        }
        if (this.df == null && !this.isListFile) {
            this.initialized = true;
            return;
        }
        for (int i = 0; i < this.data.getSize(); ++i) {
            int boff = i * this.data.bpe;
            if (this.isListFile) {
                this.addPoint(this.getPointListFile(boff));
                continue;
            }
            this.addPoint(this.getPoint5000(boff, this.tlTime + this.tDelta * (double)i));
        }
        if (this.df != null) {
            this.tlTime = this.df.getTimeAt();
        }
        this.initialized = true;
    }

    Point3D getPoint5000(int boff, double time) {
        int len;
        int off;
        String symbolName;
        int off2;
        Point3D point = new Point3D(this);
        if (this.bPos != -1) {
            off2 = this.bPos + boff;
            double[] pos = new double[]{this.data.unpackD(off2), this.data.unpackD(off2 + 8), this.data.unpackD(off2 + 16)};
            if (this.toLLA) {
                this.transform.toLonLatAlt(pos, 1);
            }
            point.setPos(pos[2], pos[1], pos[0]);
        }
        if (this.bVec != -1) {
            off2 = this.bPos + boff;
            int voff = this.bVec + boff;
            double[] posp = new double[]{this.data.unpackD(off2 + 0), this.data.unpackD(off2 + 8), this.data.unpackD(off2 + 16)};
            int j = 3 - this.dVec;
            while (j < 3) {
                int n = j++;
                posp[n] = posp[n] + this.vscale * this.data.unpackD(voff);
                voff += 8;
            }
            if (this.toLLA) {
                this.transform.toLonLatAlt(posp, 1);
            }
            point.setPosp(posp[2], posp[1], posp[0]);
        }
        if (this.bPosp != -1) {
            off2 = this.bPosp + boff;
            double[] posp = new double[]{this.data.unpackD(off2), this.data.unpackD(off2 + 8), this.data.unpackD(off2 + 16)};
            if (this.toLLA) {
                this.transform.toLonLatAlt(posp, 1);
            }
            point.setPosp(posp[2], posp[1], posp[0]);
        }
        if (this.bCone != -1) {
            off2 = this.bCone + boff;
            if (this.fCone.charAt(0) == 'V') {
                point.setCone(this.data.unpackD(off2), this.data.unpackD(off2 + 8), this.data.unpackD(off2 + 16));
            } else {
                point.setCone(0.0, 0.0, this.data.unpackD(off2));
            }
        }
        if (this.bElps != -1) {
            off2 = this.bElps + boff;
            point.setElps(this.data.unpackD(off2), this.data.unpackD(off2 + 8), this.data.unpackD(off2 + 16));
        }
        if (this.bFlag != -1) {
            off2 = this.bFlag + boff;
            point.setFlagNameLen(this.data.unpackB(off2 + 0));
            point.setFlagNamePos(this.data.unpackB(off2 + 1));
            point.setFlagFgColor(this.data.unpackB(off2 + 2));
            point.setFlagBgColor(this.data.unpackB(off2 + 3));
            point.setFlagCone(this.data.unpackB(off2 + 4));
            point.setFlagInvert(this.data.unpackB(off2 + 5));
            point.setFlagSymCode(this.data.unpackB(off2 + 6));
            point.setFlagSymSize(this.data.unpackB(off2 + 7));
        }
        if (this.bConn != -1) {
            off2 = this.bConn + boff;
            point.setConn(this.data.unpackB(off2));
        }
        if (this.bHdg != -1) {
            off2 = this.bHdg + boff;
            point.setHdg(this.data.unpackF(off2));
        }
        if (this.bName != -1) {
            off2 = this.bName + boff;
            int len2 = Data.getBPA(this.fName);
            point.setName(this.data.unpackS(off2, len2));
        }
        if (this.bNote != -1) {
            off2 = this.bNote + boff;
            int len3 = Data.getBPA(this.fNote);
            point.setNote(this.data.unpackS(off2, len3));
        }
        if (this.bTime != -1) {
            off2 = this.bTime + boff;
            point.setTime(this.data.unpackD(off2));
        } else {
            point.setTime(time);
        }
        if (this.bColor != -1) {
            off2 = this.bColor + boff;
            int len4 = Data.getBPA(this.fColor);
            String colorValue = this.data.unpackS(off2, len4);
            colorValue = colorValue.replace("(", "").replace(")", "");
            point.setDirectColor(colorValue);
        }
        if (this.bMetas != null) {
            Table metaTable = new Table();
            for (int i = 0; i < this.bMetas.length; ++i) {
                if (this.bMetas[i] == -1) continue;
                int off3 = this.bMetas[i] + boff;
                Object value = this.unpackData(this.fMetas[i], this.data, off3);
                metaTable.put(this.metadataFieldNames[i], value);
            }
            point.setMetadata(metaTable);
        } else if (this.bMeta != -1) {
            off2 = this.bMeta + boff;
            int len5 = Data.getBPA(this.fMeta);
            point.setMetadata(this.data.unpackS(off2, len5));
        }
        if (this.bSymbol != -1 && !(symbolName = this.data.unpackS(off = this.bSymbol + boff, len = Data.getBPA(this.fSymbol))).isEmpty()) {
            point.setSymbol(symbolName);
        }
        if (this.bEllipsoid != -1) {
            off = this.bEllipsoid + boff;
            double[] ellipsoid = new double[]{this.data.unpackD(off), this.data.unpackD(off + 8), this.data.unpackD(off + 16), this.data.unpackD(off + 24), this.data.unpackD(off + 32), this.data.unpackD(off + 40)};
            point.setEllipsoid(ellipsoid[0], ellipsoid[1], ellipsoid[2], ellipsoid[3], ellipsoid[4], ellipsoid[5]);
        }
        return point;
    }

    private Object unpackData(String fmt, Data data, int off) {
        int type;
        int len;
        if (fmt == null) {
            fmt = "";
        }
        switch (fmt.length()) {
            case 1: {
                len = Data.getBPA("X" + fmt);
                type = fmt.charAt(0);
                break;
            }
            case 0: {
                len = Data.getBPA("XA");
                type = 65;
                break;
            }
            default: {
                len = Data.getBPA(fmt);
                type = fmt.charAt(1);
            }
        }
        switch (type) {
            case 70: {
                return Float.valueOf(data.unpackF(off));
            }
            case 68: {
                return data.unpackD(off);
            }
            case 88: {
                return data.unpackX(off);
            }
            case 76: {
                return data.unpackL(off);
            }
            case 73: {
                return data.unpackI(off);
            }
            case 66: {
                return data.unpackB(off);
            }
            case 78: {
                return data.getN(off);
            }
            case 80: {
                return data.getP(off);
            }
            case 65: {
                return data.unpackS(off, len);
            }
            case 90: {
                return data.unpackS(off, len);
            }
        }
        return data.unpackS(off, len);
    }

    Point3D getPointListFile(int boff) {
        String symbolName;
        int off;
        int off2;
        int off3;
        int off4;
        int off5;
        Point3D point = new Point3D(this);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.bPosX != -1) {
            off5 = this.bPosX + boff;
            x = Convert.data2d(this.data, off5, this.xFormat);
        }
        if (this.bPosY != -1) {
            off5 = this.bPosY + boff;
            y = Convert.data2d(this.data, off5, this.yFormat);
        }
        if (this.bPosZ != -1) {
            off5 = this.bPosZ + boff;
            z = Convert.data2d(this.data, off5, this.zFormat);
        }
        point.setPos(z, y, x);
        if (this.bName != -1) {
            off5 = this.bName + boff;
            point.setName(this.data.unpackS(off5, Data.getBPA("XA")));
        }
        byte[] flags = new byte[8];
        for (int i = 0; i < this.bFlags.length; ++i) {
            if (this.bFlags[i] != -1) {
                int off6 = this.bFlags[i] + boff;
                flags[i] = Convert.unpackB(this.data.buf, off6);
                continue;
            }
            flags[i] = 0;
        }
        point.setFlags((Object)flags);
        Double ellipseMajor = null;
        Double ellipseMinor = null;
        Double ellipseTilt = 0.0;
        if (this.bEllipseMajor != -1) {
            off4 = this.bEllipseMajor + boff;
            ellipseMajor = this.data.unpackD(off4);
        }
        if (this.bEllipseMinor != -1) {
            off4 = this.bEllipseMinor + boff;
            ellipseMinor = this.data.unpackD(off4);
        }
        if (this.bEllipseTilt != -1) {
            off4 = this.bEllipseTilt + boff;
            ellipseTilt = this.data.unpackD(off4);
        }
        if (ellipseMajor != null && ellipseMinor != null) {
            point.setElps(ellipseMajor, ellipseMinor, ellipseTilt);
        }
        Double ellipsoidMajor = null;
        Double ellipsoidMinor = null;
        Double ellipsoidMedian = null;
        Double ellipsoidRotationX = 0.0;
        Double ellipsoidRotationY = 0.0;
        Double ellipsoidRotationZ = 0.0;
        if (this.bEllipsoidMajor != -1) {
            off3 = this.bEllipsoidMajor + boff;
            ellipsoidMajor = this.data.unpackD(off3);
        }
        if (this.bEllipsoidMinor != -1) {
            off3 = this.bEllipsoidMinor + boff;
            ellipsoidMinor = this.data.unpackD(off3);
        }
        if (this.bEllipsoidMedian != -1) {
            off3 = this.bEllipsoidMedian + boff;
            ellipsoidMedian = this.data.unpackD(off3);
        }
        if (this.bEllipsoidRotationX != -1) {
            off3 = this.bEllipsoidRotationX + boff;
            ellipsoidRotationX = this.data.unpackD(off3);
        }
        if (this.bEllipsoidRotationY != -1) {
            off3 = this.bEllipsoidRotationY + boff;
            ellipsoidRotationY = this.data.unpackD(off3);
        }
        if (this.bEllipsoidRotationZ != -1) {
            off3 = this.bEllipsoidRotationZ + boff;
            ellipsoidRotationZ = this.data.unpackD(off3);
        }
        if (ellipsoidMajor != null && ellipsoidMinor != null && ellipsoidMedian != null) {
            point.setEllipsoid(ellipsoidMajor, ellipsoidMinor, ellipsoidMedian, ellipsoidRotationX, ellipsoidRotationY, ellipsoidRotationZ);
        }
        Double coneA = null;
        Double coneB = null;
        Double coneAngle = 0.0;
        if (this.bConeA != -1) {
            off2 = this.bConeA + boff;
            coneA = this.data.unpackD(off2);
        }
        if (this.bConeB != -1) {
            off2 = this.bConeB + boff;
            coneB = this.data.unpackD(off2);
        }
        if (this.bConeAngle != -1) {
            off2 = this.bConeAngle + boff;
            coneAngle = this.data.unpackD(off2);
        }
        if (coneA != null && coneB != null) {
            point.setCone(coneA, coneB, coneAngle);
        }
        Double pospX = null;
        Double pospY = null;
        Double pospZ = 0.0;
        if (this.bPospX != -1) {
            off = this.bPospX + boff;
            pospX = this.data.unpackD(off);
        }
        if (this.bPospY != -1) {
            off = this.bPospY + boff;
            pospY = this.data.unpackD(off);
        }
        if (this.bPospZ != -1) {
            off = this.bPospZ + boff;
            pospZ = this.data.unpackD(off);
        }
        if (pospX != null && pospY != null) {
            point.setPosp(pospZ, pospY, pospX);
        }
        if (this.bFlagNote != -1) {
            off = this.bFlagNote + boff;
            point.setNote(this.data.unpackS(off, Data.getBPA("XA")));
        }
        if (this.bTimeLF != -1) {
            off = this.bTimeLF + boff;
            point.setTime(this.data.unpackD(off));
        }
        if (this.bColorPos != -1) {
            off = this.bColorPos + boff;
            point.setDirectColor(this.data.unpackS(off, Data.getBPA("XA")));
        }
        if (this.bSymbolPos != -1 && !(symbolName = this.data.unpackS(off = this.bSymbolPos + boff, Data.getBPA("XA"))).isEmpty()) {
            point.setSymbol(symbolName);
        }
        if (this.bMetasPos != null) {
            Table metaTable = new Table();
            for (int i = 0; i < this.bMetasPos.length; ++i) {
                if (this.bMetasPos[i] == -1) continue;
                int off7 = this.bMetasPos[i] + boff;
                Object value = this.unpackData("" + this.metaFormats[i], this.data, off7);
                point.setMetadata(metaTable);
                metaTable.put(this.metadataFieldNames[i], value);
            }
            point.setMetadata(metaTable);
        } else if (this.bMetaPos != -1) {
            off = this.bMetaPos + boff;
            point.setMetadata(this.data.unpackS(off, Data.getBPA("XA")));
        }
        return point;
    }

    private void matchTimePoint() {
        Point3D point = new Point3D(this);
        boolean needFullRescale = false;
        double[] p = StateVector.getPosVelAccAtTime(this.df, this.time, this.data, this.toLLA);
        point.setPos(p[2], p[1], p[0]);
        if (this.timePoint != null) {
            if (this.MP.view != 15) {
                this.minMaxSet = false;
            } else {
                needFullRescale = true;
            }
        }
        this.timePoint = point;
        if (needFullRescale) {
            this.recalculateFullRange();
        } else {
            this.updateRange(point);
        }
        this.addPoint(point);
    }

    public void setConeAttr(Table attr) {
    }

    @Override
    public void setTime(double value) {
        if (this.df == null) {
            super.setTime(value);
        } else if (value > 8640000.0) {
            if (this.data != null) {
                this.setTimeCode(value);
            } else {
                this.warning("LayerT5.setTime(double) not intended for case where data is null - file:" + this.getFile());
                this.doSetTime(value);
            }
        } else {
            this.doSetTime(value);
        }
    }

    private void doSetTime(double value) {
        super.setTime(value);
        this.points = null;
        this.timeSortOfPtIndicies = null;
        if (this.initialized) {
            this.matchTimePoint();
        }
    }

    @Override
    public double getTime() {
        return super.getTime();
    }

    public boolean setTimeCode(double value) {
        if (this.df == null || this.data == null) {
            this.setTime(value);
            return false;
        }
        double start = this.df.getTimeCode();
        double end = start + this.df.getXDelta() * this.df.getSize();
        this.doSetTime(value - start);
        return value >= start && value <= end;
    }

    public double getTimeCode() {
        if (this.df == null || this.data == null) {
            return this.getTime();
        }
        return this.getTime() + this.df.getTimeCode();
    }

    public static void setXYPointXMargin(double xyPointXMargin) {
        LayerT5.xyPointXMargin = xyPointXMargin < 1.0 ? xyPointXMargin : xyPointXMargin / 100.0;
    }

    public static void setXYPointYMargin(double xyPointYMargin) {
        LayerT5.xyPointYMargin = xyPointYMargin < 1.0 ? xyPointYMargin : xyPointYMargin / 100.0;
    }

    private double getPointXMargin() {
        if (!this.isGeodeticData && this.MP.isStandardXYView()) {
            return xyPointXMargin;
        }
        return 0.0;
    }

    private double getPointYMargin() {
        if (!this.isGeodeticData && this.MP.isStandardXYView()) {
            return xyPointYMargin;
        }
        return 0.0;
    }

    private void rangeMatchPoint(Point3D point) {
        this.x1 = point.minLon * (1.0 - this.getPointXMargin());
        this.x2 = point.maxLon * (1.0 + this.getPointXMargin());
        this.y1 = point.minLat * (1.0 - this.getPointYMargin());
        this.y2 = point.maxLat * (1.0 + this.getPointYMargin());
        this.z1 = point.minAlt;
        this.z2 = point.maxAlt;
    }

    void updateRange(Point3D point) {
        double oldXRange = this.xRange;
        double oldYRange = this.yRange;
        double oldZRange = this.zRange;
        if (!this.minMaxSet) {
            this.minLon = point.minLon * (1.0 - this.getPointXMargin());
            this.maxLon = point.maxLon * (1.0 + this.getPointXMargin());
            this.minLat = point.minLat * (1.0 - this.getPointYMargin());
            this.maxLat = point.maxLat * (1.0 + this.getPointYMargin());
            this.minAlt = point.minAlt;
            this.maxAlt = point.maxAlt;
            this.minMaxSet = true;
        } else {
            this.minLon = Math.min(this.minLon, point.minLon * (1.0 - this.getPointXMargin()));
            this.maxLon = Math.max(this.maxLon, point.maxLon * (1.0 + this.getPointXMargin()));
            this.minLat = Math.min(this.minLat, point.minLat * (1.0 - this.getPointYMargin()));
            this.maxLat = Math.max(this.maxLat, point.maxLat * (1.0 + this.getPointYMargin()));
            this.minAlt = Math.min(this.minAlt, point.minAlt);
            this.maxAlt = Math.max(this.maxAlt, point.maxAlt);
        }
        this.xRange = Math.max(this.xRange, point.xRangeMax);
        this.yRange = Math.max(this.yRange, point.yRangeMax);
        this.zRange = Math.max(this.zRange, point.zRangeMax);
        if (this.MP != null && !this.ignoreRange) {
            if ((oldXRange != this.xRange || oldYRange != this.yRange || oldZRange != this.zRange) & this.MP.view != 14) {
                if (this.MP.view == 11) {
                    this.minLon = Math.max(this.minLon, (double)MPlot.LONGITUDE_DEFAULT_MIN);
                    this.maxLon = Math.min(this.maxLon, (double)MPlot.LONGITUDE_DEFAULT_MAX);
                    this.minLat = Math.max(this.minLat, (double)MPlot.LATITUDE_DEFAULT_MIN);
                    this.maxLat = Math.min(this.maxLat, (double)MPlot.LATITUDE_DEFAULT_MAX);
                }
                this.MP.findRange();
            } else if (!this.MP.isMapView()) {
                this.MP.findRange();
            }
        }
    }

    @Override
    public void findRange() {
        if (this.ignoreRange) {
            this.x1 = this.MP.rx1;
            this.x2 = this.MP.rx2;
            this.y1 = this.MP.ry1;
            this.y2 = this.MP.ry2;
            return;
        }
        if (this.MP.view != 15) {
            if (this.minMaxSet && this.MP.isMapView()) {
                this.x1 = this.minLon;
                this.x2 = this.maxLon;
                this.y1 = this.minLat;
                this.y2 = this.maxLat;
                this.z1 = this.minAlt;
                this.z2 = this.maxAlt;
                this.a1 = this.y1;
                this.a2 = this.y2;
            } else {
                this.x1 = Math.min(this.x1, this.minLon);
                this.x2 = Math.max(this.x2, this.maxLon);
                this.y1 = Math.min(this.y1, this.minLat);
                this.y2 = Math.max(this.y2, this.maxLat);
                this.z1 = Math.min(this.z1, this.minAlt);
                this.z2 = Math.max(this.z2, this.maxAlt);
                this.a1 = this.y1;
                this.a2 = this.y2;
            }
        } else {
            this.findGraphRange();
        }
    }

    private void findGraphRange() {
        if (this.firstPassFindGraphRange || this.x2 < this.xRange) {
            this.x1 = -this.xRange * threeDGraphMarginFactor;
            this.x2 = this.xRange * threeDGraphMarginFactor;
        }
        if (this.firstPassFindGraphRange || this.y2 < this.yRange) {
            this.y1 = -this.yRange * threeDGraphMarginFactor;
            this.y2 = this.yRange * threeDGraphMarginFactor;
        }
        if (this.firstPassFindGraphRange || this.z2 < this.zRange) {
            this.z1 = -this.zRange * threeDGraphMarginFactor;
            this.z2 = this.zRange * threeDGraphMarginFactor;
            this.a1 = this.z1;
            this.a2 = this.z2;
        }
        this.firstPassFindGraphRange = false;
    }

    public void setSelectColor(Object value) {
        if (value instanceof String && value.toString().length() == 0) {
            return;
        }
        if (value instanceof String && "NONE".equalsIgnoreCase((String)value)) {
            this.setSelectColor(null);
        } else {
            Color c = MColor.getColor(value);
            this.setSelectColor(c);
        }
    }

    public void setSelectColor(Color c) {
        if (this.selectColor == null || c == null || !this.selectColor.equals(c)) {
            this.selectColor = c;
            this.refresh();
        }
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    @Override
    public synchronized void draw(int flag) {
        boolean drawClusters;
        if (!this.initialized || this.size == 0 && this.pf == null) {
            return;
        }
        if (this.MP.gc == null) {
            return;
        }
        if (this.showClusters) {
            this.setClusterFontSizes();
        }
        super.draw(flag);
        Line lin = this.line.copy();
        this.setDrawingConfig(lin);
        if (!this._showAll) {
            this._showAll = this.minLat >= this.MP.ry1 && this.maxLat <= this.MP.ry2 && this.minLon >= this.MP.rx1 && this.maxLon <= this.MP.rx2;
        }
        Font f = null;
        if (this.fontsize > 0 && this._symbols) {
            f = this.MP.gc.getFont();
            this.MP.gc.setFont(this.font);
        }
        this.MP.gc.setColor(lin.getColor());
        this.pix.flags |= 0x10;
        double zoom = this.MP.getZoomLevelAsDecimal();
        boolean bl = drawClusters = this.showClusters && zoom > 0.005 && !this._connect && this.MP.isLatLonView();
        if (drawClusters) {
            int zoomLevel = RegionGroup.getZoomLevel(zoom);
            if (zoomLevel < 5) {
                this.drawCluster(lin, zoomLevel);
            } else {
                drawClusters = false;
            }
        }
        if (!drawClusters) {
            int j;
            int iStart;
            Map<String, PredicateType> _visibilityFilter;
            Point3D point = null;
            Point3D last = null;
            int tempPointCount = 0;
            if (this.relativeTimeWindow) {
                double mostRecentPtTime;
                double d = mostRecentPtTime = this.relativeMode == 2 ? this.getLatestPointTime() : Time.current();
                if (this.relativeOldestTimeVisible != -1.0) {
                    this.oldestTimeVisible = mostRecentPtTime - this.relativeOldestTimeVisible;
                }
                if (this.relativeNewestTimeVisible != -1.0) {
                    this.newestTimeVisible = mostRecentPtTime - this.relativeNewestTimeVisible;
                }
            }
            boolean visibilityMetaAction = (_visibilityFilter = this.visibilityFilter) != null;
            Map<String, HighlightSetting> _highlightSettingMap = this.highlightSettingMap;
            boolean highlightMetaAction = !_highlightSettingMap.isEmpty();
            boolean _needFilteredPoints = this.needFilteredPoints;
            ArrayList<Point3D> _filteredPoints = _needFilteredPoints ? new ArrayList<Point3D>() : this.filteredPoints;
            int i = iStart = this.hasWrapped() ? this.firstPoint : 0;
            for (j = 0; j < this.numSpotsUsedInPointsArray; ++j) {
                point = this.getVisiblePoint(i, this.doPosp || this.doVec, this.doCones, this.doEllipses);
                if (point != null) {
                    boolean passVisibilityFilter;
                    boolean inTimeWindow = this.activeTimeWindow ? this.isInTimeWindow(point) : true;
                    boolean bl2 = passVisibilityFilter = _visibilityFilter != null ? this.passVisibilityFilter(point, _visibilityFilter) : true;
                    if (inTimeWindow && (!visibilityMetaAction || passVisibilityFilter)) {
                        if (point.coneSet) {
                            if (this.isConeCenterVisible(point)) {
                                ++tempPointCount;
                            }
                        } else if (this.isPointVisible(i)) {
                            ++tempPointCount;
                        }
                        Color color = point.highlightColor = highlightMetaAction ? this.assignHighlightColor(_highlightSettingMap, point) : null;
                        if (point.highlightColor == null) {
                            point.visibleHighlight = false;
                            this.drawPoint(lin, point, last, i);
                        } else {
                            point.visibleHighlight = true;
                        }
                        if (_needFilteredPoints && passVisibilityFilter) {
                            _filteredPoints.add(point);
                        }
                    }
                } else if (this.points[i] != null) {
                    this.points[i].highlightColor = highlightMetaAction ? this.assignHighlightColor(_highlightSettingMap, this.points[i]) : null;
                    this.points[i].visibleHighlight = false;
                }
                last = point != null && point.isHidden() ? null : point;
                i = (i + 1) % this.numSpotsUsedInPointsArray;
            }
            if (highlightMetaAction) {
                last = null;
                i = iStart;
                for (j = 0; j < this.numSpotsUsedInPointsArray; ++j) {
                    point = this.points[i];
                    point.prep(this.doPosp || this.doVec);
                    if (point != null && point.visibleHighlight) {
                        this.drawPoint(lin, point, last, i);
                        last = point.isHidden() ? null : point;
                    } else {
                        last = null;
                    }
                    i = (i + 1) % this.numSpotsUsedInPointsArray;
                }
                this.updateHighlightCountStatus(_highlightSettingMap);
            }
            this.numVisiblePoints = tempPointCount;
            if (_needFilteredPoints) {
                this.filteredPoints = _filteredPoints;
                this.needFilteredPoints = false;
            }
        }
        if (f != null) {
            this.MP.gc.setFont(f);
        }
        this.MP.gc.setColor(this.colors[0]);
    }

    private Color assignHighlightColor(Map<String, HighlightSetting> _highlightSettingMap, Point3D point) {
        for (String key : _highlightSettingMap.keySet()) {
            HighlightSetting highlightSetting = _highlightSettingMap.get(key);
            Map highlightFilter = highlightSetting.getHighlightFilter();
            boolean isHighlighted = this.passHighlightFilter(point, highlightFilter);
            if (!isHighlighted) continue;
            if (point.hit(this.MP.rx1, this.MP.rx2, this.MP.ry1, this.MP.ry2)) {
                highlightSetting.incrementRunningVisibleTotal();
            }
            highlightSetting.incrementRunningTotal();
            return highlightSetting.getHighlightColor();
        }
        return null;
    }

    @InternalUseOnly
    public void putHighlightSetting(String name, Map<String, PredicateType> mapPT, String color) {
        HighlightSetting highlightSetting = new HighlightSetting(mapPT, color);
        this.highlightSettingMap.put(name, highlightSetting);
        this.refresh();
    }

    @InternalUseOnly
    public void putHighlightSetting(String name, Map<String, PredicateType> mapPT, String color, boolean trackFade) {
        this.putHighlightSetting(name, mapPT, color);
    }

    @InternalUseOnly
    public void putHighlightSetting(String name, Map<String, PredicateType> mapPT, Color color) {
        HighlightSetting highlightSetting = new HighlightSetting(mapPT, color);
        this.highlightSettingMap.put(name, highlightSetting);
        this.refresh();
    }

    @InternalUseOnly
    public void putHighlightSetting(String name, Map<String, PredicateType> mapPT, Color color, boolean trackFade) {
        this.putHighlightSetting(name, mapPT, color);
    }

    @InternalUseOnly
    public void removeHighlightSetting(String name) {
        if (!this.highlightSettingMap.isEmpty()) {
            this.highlightSettingMap.remove(name);
            this.refresh();
        }
    }

    @InternalUseOnly
    public void clearHighlightSettings() {
        if (!this.highlightSettingMap.isEmpty()) {
            this.highlightSettingMap.clear();
            this.refresh();
        }
    }

    @InternalUseOnly
    public HighlightSetting getHighlightSetting(String name) {
        return this.highlightSettingMap.get(name);
    }

    @InternalUseOnly
    public Map<String, HighlightSetting> getHighlightSettingsMap() {
        return this.highlightSettingMap;
    }

    private void updateHighlightCountStatus(Map<String, HighlightSetting> _highlightSettingMap) {
        for (String key : _highlightSettingMap.keySet()) {
            boolean visibleTotalUpdated;
            HighlightSetting highlightSetting = _highlightSettingMap.get(key);
            int currentTotal = highlightSetting.getRunningTotal();
            int previousTotal = highlightSetting.getNumHighlighted();
            int currentVisibleTotal = highlightSetting.getRunningVisibleTotal();
            int previousVisibleTotal = highlightSetting.getNumVisibleHighlighted();
            highlightSetting.setNumHighlighted(currentTotal);
            highlightSetting.clearRunningTotal();
            highlightSetting.setNumVisibleHighlighted(currentVisibleTotal);
            highlightSetting.clearRunningVisibleTotal();
            boolean totalUpdated = currentTotal != previousTotal;
            boolean bl = visibleTotalUpdated = currentVisibleTotal != previousVisibleTotal;
            if (!this.sendHighlightTotalMessages || !totalUpdated && !visibleTotalUpdated) continue;
            if (this.mwMsgHandler == null) {
                this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
            }
            if (this.mwMsgHandler == null) continue;
            if (totalUpdated) {
                this.mwMsgHandler.processMessage(new Message("HIGHLIGHT_TOTAL", currentTotal, key, this.mwMsgHandler, this.MP.mh));
            }
            if (!visibleTotalUpdated) continue;
            this.mwMsgHandler.processMessage(new Message("HIGHLIGHT_VISIBLE_TOTAL", currentVisibleTotal, key, this.mwMsgHandler, this.MP.mh));
        }
    }

    private Color getFadedColor(Color color, int indexPt) {
        int grayFactor = this.computeNumPtsBehind(indexPt) / this.colorFadeFactor;
        int red = Math.max(color.getRed() - grayFactor, this.fadeColorR);
        int green = Math.max(color.getGreen() - grayFactor, this.fadeColorG);
        int blue = Math.max(color.getBlue() - grayFactor, this.fadeColorB);
        return new Color(red, green, blue);
    }

    private int computeNumPtsBehind(int indexPt) {
        boolean wrappingPoints;
        boolean bl = wrappingPoints = this.firstPoint != -1 && this.numSpotsUsedInPointsArray == this.points.length && this.points.length >= this.maxPointsSize;
        int numPtsBehind = !wrappingPoints ? this.numSpotsUsedInPointsArray - indexPt - 1 : (indexPt < this.firstPoint ? this.firstPoint - indexPt - 1 : this.firstPoint + (this.numSpotsUsedInPointsArray - indexPt));
        return numPtsBehind;
    }

    private boolean isInTimeWindow(Point3D point) {
        if (this.oldestTimeVisible != -1.0 && point.time < this.oldestTimeVisible) {
            return false;
        }
        return this.newestTimeVisible == -1.0 || !(point.time > this.newestTimeVisible);
    }

    private boolean passVisibilityFilter(Point3D point, Map<String, PredicateType> _visibilityFilter) {
        for (String key : _visibilityFilter.keySet()) {
            boolean passTest = PredicateType.passesFilter(_visibilityFilter, key, point.filterDataTable.get(key));
            if (passTest) continue;
            return false;
        }
        return true;
    }

    private boolean passHighlightFilter(Point3D point, Map<String, PredicateType> _highlightFilter) {
        for (String key : _highlightFilter.keySet()) {
            boolean passTest = PredicateType.passesFilter(_highlightFilter, key, point.filterDataTable.get(key));
            if (passTest) continue;
            return false;
        }
        return true;
    }

    private boolean isConeCenterVisible(Point3D point) {
        double x = point.getPosLon();
        double y = point.getPosLat();
        if (x < this.MP.rx1) {
            return false;
        }
        if (x > this.MP.rx2) {
            return false;
        }
        if (y < this.MP.ry1) {
            return false;
        }
        return !(y > this.MP.ry2);
    }

    void setDrawingConfig(Line lin) {
        boolean coneFile = false;
        boolean elpsFile = false;
        this.doPos = false;
        this.doEllipses = false;
        this.doCones = false;
        this.doVec = false;
        this.doPosp = false;
        if (this.isListFile) {
            coneFile = this.conic != 0 && this.bPosX != -1 && this.bPospX != -1;
            this.doPosp = this.bPospX != -1 && this.bPospY != -1;
            elpsFile = this.bEllipseMajor != -1 && this.bEllipseMinor != -1 && this.bPosX != -1;
            this.doPos = this.bPosX != -1 && this.bPosY != -1;
        } else {
            coneFile = this.conic != 0 && this.bPos != -1 && this.bPosp != -1;
            elpsFile = this.bElps != -1 && this.bPos != -1;
            this.doVec = this.bVec != -1;
            this.doPosp = this.bPosp != -1;
            this.doPos = this.bPos != -1 && this.bVec == -1;
        }
        this.doCones = this.showField(8) && coneFile;
        this.doEllipses = this.showField(4) && elpsFile;
        double vreg = this.MP.view == 13 || this.MP.view == 10 ? 50.0 * Math.min(this.MP.rx2 - this.MP.rx1, this.MP.ry2 - this.MP.ry1) : Math.min(this.MP.rx2 - this.MP.rx1, this.MP.ry2 - this.MP.ry1);
        this._labels = this.showField(2) && this.bName != -1 && (this.enable & 2) != 0;
        this._labelZoom = vreg < this.tlreg;
        this._symbols = this.showField(1) && lin.isTypeSet(32);
        this._connect = this.showField(16) && this.bConn != -1;
        this._connectAll = this.timeAxis && (this.flags & 4) == 0;
        this._showAll = !this.MP.is2D || this._connect || this._connectAll || this.doCones;
    }

    void drawPoint(Line lin, Point3D point, Point3D last, int index) {
        int saveType = lin.getTypeInt();
        Color saveColor = this.MP.gc.getColor();
        if (point != null && !point.isHidden()) {
            boolean ptSymbol;
            point.prep(this.doPosp);
            this._selected = this.select == point.indexInPointsObject;
            this._color = saveColor;
            if (this.bFlag != -1 || this.bFlags[2] != -1) {
                this._color = this.colors[Math.min(point.flagFgColor, this.colors.length - 1)];
            } else if (point.flagFgColor > 0) {
                this._color = this.colors[Math.min(point.flagFgColor, this.colors.length - 1)];
            } else if (point.directColor != null) {
                this._color = point.directColor;
            }
            if (point.highlightColor != null) {
                this._color = point.highlightColor;
            } else if (this.colorFade && !this.showClusters) {
                this._color = this.getFadedColor(this._color, index);
            }
            if (this._selected && this.selectColor != null) {
                this._color = this.selectColor;
            }
            boolean ptEllipsoid = point.ellipsoidSet;
            boolean bl = ptSymbol = point.symbol != null;
            if (!ptEllipsoid && !ptSymbol && this.doVec && last != null && Math.abs(point._ixPos - last._ixPos) < 5 && Math.abs(point._iyPos - last._iyPos) < 5) {
                return;
            }
            this.MP.gc.setColor(this._color);
            lin.setColor(this._color);
            lin.setType(1);
            if (this.doPos) {
                this.drawPosSymbolLabel(lin, point, last);
            }
            if (!ptSymbol && ptEllipsoid) {
                this.drawEllipsoid(lin, point);
            }
            if (!ptSymbol && !ptEllipsoid) {
                if (this.doVec) {
                    this.drawVec(lin, point);
                }
                if (this.doCones) {
                    this.drawCone(lin, point);
                }
                if (this.doEllipses) {
                    this.drawEllipse(lin, point);
                }
            }
        }
        if (last != null) {
            last.done();
        }
        last = point != null && point.isHidden() ? null : point;
        this.MP.gc.setColor(saveColor);
        lin.setColor(saveColor);
        lin.setType(saveType);
        if (last != null) {
            last.done();
        }
    }

    private void drawCluster(Line lin, int zoomLevel) {
        ArrayList<LayerT5> layerT5s = new ArrayList<LayerT5>();
        layerT5s.add(this);
        RegionGroup.drawGrouping(lin, zoomLevel, layerT5s, this.MP);
    }

    private void drawPosSymbolLabel(Line lin, Point3D point, Point3D last) {
        boolean lbl;
        if (this.MP.gc == null) {
            return;
        }
        int ix = point._ixPos;
        int iy = point._iyPos;
        boolean pointIsSymbol = point.symbol != null;
        Symbol symbol = pointIsSymbol ? point.symbol : lin.getSymbol();
        float prevSymAng = lin.getSymbolHeading();
        String name = point.name;
        boolean sym = true;
        boolean conn = this._connect && point.conn || this._connectAll;
        boolean noAuto = (this.flags & 8) == 0;
        boolean bl = lbl = noAuto || this._selected || this._labelZoom;
        if (this.bFlag != -1 || this.bFlags[0] != -1) {
            lbl = true;
            sym = true;
            if (!pointIsSymbol && this._symbols) {
                String symbolName = XmUtil.getXmSymbolName(point.flagSymCode);
                byte symbolSize = point.flagSymSize;
                if (symbolName == null) {
                    this.warn("Invalid symbol ID (" + point.flagSymCode + ") for plot (" + name + ") using default.");
                } else if (symbolSize <= 0 || symbolName.equals("NULL")) {
                    sym = false;
                } else {
                    symbol = Symbol.get(symbolName, point.flagSymSize);
                }
            }
            if (this._labels) {
                byte nameLength = point.flagNameLen;
                if (nameLength == 0) {
                    lbl = false;
                } else if (name.length() > nameLength) {
                    if (nameLength > 0 && nameLength <= name.length()) {
                        name = name.substring(0, nameLength);
                    } else {
                        this.warn("Invalid name length (" + nameLength + ") for plot (" + name + ").");
                    }
                }
            }
        }
        if (conn && last != null && (!this.MP.is2D || Math.abs(point.posLon - last.posLon) < 180.0)) {
            if (this.MP.view == 14) {
                int dim;
                double[] linePoints;
                if (this.MP.is2D) {
                    linePoints = new double[]{last.minLon, last.minLat, point.minLon, point.minLat};
                    dim = 2;
                } else {
                    linePoints = new double[]{last.minLon, last.minLat, last.posAlt, point.minLon, point.minLat, point.posAlt};
                    dim = 3;
                }
                this.MP.drawLine(linePoints, 0, dim, 2, this.line, 16, this.MP.gc, true);
            } else {
                int thisy;
                int thisx;
                int lasty;
                int lastx;
                if (this.MP.mxx > MPlot.HIGH_ZOOM_MXX) {
                    int dim;
                    double[] thisPoint;
                    double[] lastPoint;
                    DPix dPix1 = new DPix(1, 16);
                    DPix dPix2 = new DPix(1, 16);
                    if (this.MP.is2D) {
                        lastPoint = new double[]{last.posLon, last.posLat};
                        thisPoint = new double[]{point.posLon, point.posLat};
                        dim = 2;
                    } else {
                        lastPoint = new double[]{last.posLon, last.posLat, last.posAlt};
                        thisPoint = new double[]{point.posLon, point.posLat, point.posAlt};
                        dim = 3;
                    }
                    this.MP.viewer.rwc2dpix(lastPoint, 0, dim, 1, dPix1);
                    this.MP.viewer.rwc2dpix(thisPoint, 0, dim, 1, dPix2);
                    IntersectingLine visibleLine = GeometricUtil.adjustToVisibleLine(new Line2D.Double(dPix1.x[0], dPix1.y[0], dPix2.x[0], dPix2.y[0]), new Point2D.Double(this.MP.ix1, this.MP.iy1), new Point2D.Double(this.MP.ix2, this.MP.iy2));
                    if (visibleLine == null) {
                        lastx = last._ixPos;
                        lasty = last._iyPos;
                        thisx = ix;
                        thisy = iy;
                    } else {
                        Line2D.Double line = visibleLine.getLine();
                        lastx = (int)line.getX1();
                        lasty = (int)line.getY1();
                        thisx = (int)line.getX2();
                        thisy = (int)line.getY2();
                    }
                } else {
                    lastx = last._ixPos;
                    lasty = last._iyPos;
                    thisx = ix;
                    thisy = iy;
                }
                this.MP.gc.drawLine(lastx, lasty, thisx, thisy);
            }
        }
        if (noAuto || this.bFlag != -1 || this.bFlags[0] != -1 || ix >= this.MP.ix1 && ix <= this.MP.ix2 && iy >= this.MP.iy1 && iy <= this.MP.iy2) {
            if (this._symbols && sym && symbol != null) {
                if (pointIsSymbol) {
                    lin.setSymbolHeading(point.symbol.getHeading());
                } else if (this.bHdg != -1) {
                    lin.setSymbolHeading(point.hdg);
                }
                symbol.draw(ix, iy, this.MP.gc);
            }
            if (this._labels && lbl) {
                if (this._selected) {
                    name = this.getSelectedText();
                }
                int xoff = this.getLabelxoffset(lin.getRadius(), name);
                if (name.indexOf(10) < 0) {
                    this.MP.gc.drawString(name, ix + xoff, iy + lin.getRadius());
                } else {
                    String[] lines = name.split("\n");
                    int lineHeight = this.MP.gc.getFontMetrics().getHeight();
                    for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                        int delta = lineHeight * lineNum;
                        this.MP.gc.drawString(lines[lineNum], ix + xoff, iy + lin.getRadius() + delta);
                    }
                }
            }
        }
        lin.setSymbolHeading(prevSymAng);
    }

    private void drawEllipse(Line lin, Point3D point) {
        if (this.bFlag == -1 || point.flagCone != 0) {
            double rad = Math.max(point.elpsSemiMajor, point.elpsSemiMinor);
            double dy = rad * 8.983152841195214E-6 * this.MP.myy;
            double dx = rad * 8.983152841195214E-6 * this.MP.mxx;
            int r = lin.getSymbol().getSize();
            if (!this._symbols || dx > (double)r || dy > (double)r) {
                if ((this.flags & 0x10) != 0) {
                    lin.setType(8);
                    lin.setColor(new Color(0x70FFFFFF & this._color.getRGB(), true));
                    this.MP.drawEllipse(point.posLon, point.posLat, point.posAlt, point.elpsSemiMajor, point.elpsSemiMinor, 90.0 - point.elpsTilt, -1, lin, true);
                    lin.setType(1);
                }
                lin.setColor(this._color);
                this.MP.drawEllipse(point.posLon, point.posLat, point.posAlt, point.elpsSemiMajor, point.elpsSemiMinor, 90.0 - point.elpsTilt, -1, lin, true);
            }
        }
    }

    private void drawEllipsoid(Line lin, Point3D point) {
        double[] semis;
        int cs;
        lin.setColor(this._color);
        double[][][] wireCage = GeodeticUtil.computeXYZEllipsoidCrossSections(point.ellipsoidSemiMajor, point.ellipsoidSemiMinor, point.ellipsoidSemiMedian, this.eSlices);
        double[][] xCage = wireCage[0];
        double[][] yCage = wireCage[1];
        double[][] zCage = wireCage[2];
        double[][] zyxRotationTMatrix = GeodeticUtil.getZYXRotationTMatrix(Math.toRadians(point.ellipsoidRotationZ), Math.toRadians(point.ellipsoidRotationY), Math.toRadians(point.ellipsoidRotationX));
        Position pos = new Position();
        if (this.isGeodeticData) {
            pos.setGeo(point.posAlt, point.posLat, point.posLon);
        } else {
            pos.setCar(point.posLon, point.posLat, point.posAlt);
        }
        for (cs = 0; cs < xCage.length; ++cs) {
            semis = xCage[cs];
            this.MP.drawEllipsoidSliceXYZ(pos, this.isGeodeticData, semis, MPlot.ellipseAxis.X, zyxRotationTMatrix, -1, lin, this.MP.gc, true);
        }
        for (cs = 0; cs < yCage.length; ++cs) {
            semis = yCage[cs];
            this.MP.drawEllipsoidSliceXYZ(pos, this.isGeodeticData, semis, MPlot.ellipseAxis.Y, zyxRotationTMatrix, -1, lin, this.MP.gc, true);
        }
        for (cs = 0; cs < zCage.length; ++cs) {
            semis = zCage[cs];
            this.MP.drawEllipsoidSliceXYZ(pos, this.isGeodeticData, semis, MPlot.ellipseAxis.Z, zyxRotationTMatrix, -1, lin, this.MP.gc, true);
        }
    }

    private void drawCone(Line lin, Point3D point) {
        Position qPos;
        boolean drawHoriz = (this.flags & 1) != 0;
        boolean drawVert = (this.flags & 2) != 0;
        int hLineType = 1;
        int vLineType = drawHoriz && drawVert ? 2 : 1;
        Position pPos = this.bFlag != -1 || this.bFlags[0] != -1 ? point.getPosp() : point.getPos();
        Position position = qPos = this.bFlag == -1 && this.bFlags[0] == -1 ? point.getPosp() : point.getPos();
        if (this.bCone != -1 || this.bConeA != -1) {
            this.cangle = point.coneAngle;
        }
        if (this.bFlag == -1 || this.bFlags[0] == -1 || point.flagCone != 0) {
            if ((this.flags & 0x10) != 0) {
                lin.setType(8);
                lin.setColor(new Color(0x70FFFFFF & this._color.getRGB(), true));
                if (drawVert) {
                    this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 0, true);
                }
                if (drawHoriz) {
                    this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 1, true);
                }
                lin.setColor(this._color);
            }
            if (drawVert) {
                lin.setType(vLineType);
                this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 0, true);
            }
            if (drawHoriz) {
                lin.setType(hLineType);
                if (!Transform.getCompareConeCode()) {
                    this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 1, true);
                } else {
                    lin.setColor(7);
                    boolean origValueLecacy = Transform.getUseLegacyConeCode();
                    boolean origValueSpherical = Transform.getUseSphericalConeCode();
                    Transform.setUseLegacyConeCode(true);
                    if (Transform.isOnCompareList(Transform.CONE_LEGACY)) {
                        this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 1, true);
                    }
                    lin.setColor(3);
                    Transform.setUseSphericalConeCode(true);
                    if (Transform.isOnCompareList(Transform.CONE_SPHERE)) {
                        this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 1, true);
                    }
                    lin.setColor(4);
                    Transform.setUseSphericalConeCode(false);
                    if (Transform.isOnCompareList(Transform.CONE_DEFAULT)) {
                        this.MP.drawCone(pPos, qPos, this.conic, this.cdiv, this.cangle, this.crange, lin, 1, true);
                    }
                    lin.setColor(this._color);
                    Transform.setUseSphericalConeCode(origValueSpherical);
                    Transform.setUseLegacyConeCode(origValueLecacy);
                }
            }
            lin.setType(1);
        }
    }

    private void drawVec(Line lin, Point3D point) {
        this.MP.gc.drawLine(point._ixPos, point._iyPos, point._ixPosp, point._iyPosp);
    }

    private int getLabelxoffset(int radius, String label) {
        if (this.MP.gc == null) {
            return -1;
        }
        int xoff = 2 + radius;
        if (this.getLeft()) {
            FontMetrics fm = this.MP.gc.getFontMetrics();
            xoff = -1 * (fm.bytesWidth(label.getBytes(), 0, label.length()) + xoff);
        }
        return xoff;
    }

    public int getConic() {
        return this.conic;
    }

    public int getConeDiv() {
        return this.cdiv;
    }

    public double getConeAngle() {
        return this.cangle;
    }

    public double getConeRange() {
        return this.crange;
    }

    public void setConic(int value) {
        if (this.conic != value) {
            this.conic = value;
            this.refresh();
        }
    }

    public void setConeDiv(int value) {
        if (this.cdiv != value) {
            this.cdiv = value;
            this.refresh();
        }
    }

    public void setConeAngle(double value) {
        if (this.cangle != value) {
            this.cangle = value;
            this.refresh();
        }
    }

    public void setConeRange(double value) {
        if (this.crange != value) {
            this.crange = value;
            this.refresh();
        }
    }

    public void setEllipsoidSlices(int slicesEachAxis) {
        int slices = 1;
        if (slicesEachAxis > 1) {
            int halfNumber = slicesEachAxis / 2;
            slices = halfNumber * 2 + 1;
        }
        this.eSlices = slices;
    }

    public double getTLReg() {
        return this.tlreg;
    }

    public void setTLReg(double value) {
        if (this.tlreg != value) {
            this.tlreg = value;
            this.refresh();
        }
    }

    public boolean getLeft() {
        return this.leftLabels;
    }

    public void setLeft(int value) {
        this.leftLabels = value == 1;
        this.refresh();
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontSize(int value) {
        this.fontsize = value;
        if (this.fontsize > 0) {
            this.font = this.MP.newFont(this.MP.font, "", -1, this.fontsize);
        }
    }

    @Deprecated
    public void select(Position pos) {
        double[] pp = new double[]{pos.x, pos.y, pos.z};
        this.select(pp);
    }

    @Deprecated
    public void select(double[] pos) {
        this.setSelectedIndex(this.getNearestByPixels(pos, 625.0));
    }

    @Deprecated
    public void select(int offset) {
        this.setSelectedIndex(offset);
    }

    @Deprecated
    public int select() {
        return this.getSelectedIndex();
    }

    public Table selectNearest(String mode, Position position) {
        this.setSelectedIndex(this.getNearest(mode, position));
        return this.getSelected();
    }

    public Table selectNearest(String mode, Position position, double range) {
        this.setSelectedIndex(this.getNearest(mode, position, range));
        return this.getSelected();
    }

    public Table selectNearest(int mode, Position position) throws IllegalArgumentException {
        this.setSelectedIndex(this.getNearest(mode, position));
        return this.getSelected();
    }

    public Table selectNearest(int mode, Position position, double range) throws IllegalArgumentException {
        this.setSelectedIndex(this.getNearest(mode, position, range));
        return this.getSelected();
    }

    public void setSelectedIndex(int index) {
        if (this.select != index) {
            Table previousSelectionInfo = this.getSelected();
            this.select = index;
            if (this.select == -1 && this.activePopup) {
                this.closeCurrentPopup();
            }
            this.refresh();
            if (this.sendSelectMessages) {
                if (this.mwMsgHandler == null) {
                    this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
                }
                if (this.mwMsgHandler != null) {
                    if (previousSelectionInfo != null) {
                        this.mwMsgHandler.processMessage(new Message("DESELECT", 0, previousSelectionInfo, this.mwMsgHandler, this.MP.mh));
                    }
                    if (this.select != -1) {
                        this.mwMsgHandler.processMessage(new Message("SELECT", 0, this.getSelected(), this.mwMsgHandler, this.MP.mh));
                    }
                }
            }
        }
    }

    public int getSelectedIndex() {
        return this.select < 0 ? -1 : this.select;
    }

    public Table getSelected() {
        return this.select < 0 ? null : this.getPoint(this.select);
    }

    public void setSelectionKeys(String keys) {
        this.selectedKeys = keys == null ? null : keys.trim().toUpperCase().split(SPLIT_REGEX);
    }

    public String getSelectedText() {
        return this.getSelectedText(this.selectedKeys);
    }

    private String getSelectedText(String[] keys) {
        Table table = this.getSelected();
        StringBuffer str = new StringBuffer();
        if (table != null) {
            if (keys == null) {
                str.append(table.get("NAME"));
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    Object value = table.get(keys[i]);
                    if (value == null) continue;
                    if (value instanceof Position) {
                        Position pos = (Position)value;
                        if (pos.referenceFrame == 1) {
                            value = Convert.deg2dmsUnicode(pos.getLon(), "EW") + " " + Convert.deg2dmsUnicode(pos.getLat(), "NS") + " " + (float)pos.getAlt() + "m";
                        }
                    }
                    if (str.length() > 0) {
                        str.append("\n");
                    }
                    str.append(StringUtil.padRight(keys[i], 4));
                    str.append(" = ");
                    str.append(value);
                }
            }
        }
        return str.toString();
    }

    public int getNearest(String mode, Position position) throws IllegalArgumentException {
        return this.getNearest(Parser.find(selectionModes, mode, -1), position);
    }

    int[] getNearestPosition(Point point) {
        int _select = this.getNearestPixelIndex(point.x, point.y, 625.0);
        if (_select < 0) {
            return null;
        }
        int[] pos = new int[2];
        Point3D pnt = this.getPointAt(_select);
        pnt.prep(false);
        pos[0] = pnt.distFromCurrentPix;
        pos[1] = _select;
        return pos;
    }

    public int getNearest(String mode, Position position, double range) {
        return this.getNearest(Parser.find(selectionModes, mode, -1), position, range);
    }

    public int getNearest(int mode, Position position) throws IllegalArgumentException {
        switch (mode) {
            case 1: {
                return this.getNearest(mode, position, 625.0);
            }
            case 2: {
                return this.getNearest(mode, position, -1.0);
            }
        }
        return this.getNearest(mode, position, -1.0);
    }

    public int getNearest(int mode, Position position, double range) throws IllegalArgumentException {
        switch (mode) {
            case 1: {
                return this.getNearestByPixels(position, range);
            }
            case 2: {
                return this.getNearestByGreatArc(position, range);
            }
        }
        throw new IllegalArgumentException("LayerT5: Unknown selection mode (" + mode + ").");
    }

    private int getNearestByPixels(Position pos, double range) {
        double[] pp = new double[3];
        if (pos.referenceFrame == 1) {
            pp[0] = pos.x;
            pp[1] = pos.y;
            pp[2] = pos.z;
        } else {
            pp[0] = pos.x;
            pp[1] = pos.y;
            pp[2] = pos.z;
        }
        return this.getNearestByPixels(pp, range);
    }

    private int getNearestByPixels(double[] pos, double range) {
        if (this.bPos != -1 || this.bPosX != -1) {
            MPoint ppos = new MPoint();
            this.MP.viewer.rwc2pix(pos, ppos);
            return this.getNearestPixelIndex(ppos.x, ppos.y, range);
        }
        return -1;
    }

    private int getNearestPixelIndex(int x, int y, double range) {
        if (this.points == null) {
            return -1;
        }
        int _select = -1;
        int mdist = (int)Math.ceil(range);
        int i = this.hasWrapped() ? this.firstPoint : 0;
        for (int j = 0; j < this.numSpotsUsedInPointsArray; ++j) {
            Point3D point = this.points[i];
            if (point != null && !point.isHidden() && (this.visibilityFilter == null || this.passVisibilityFilter(point, this.visibilityFilter))) {
                int dy;
                int dx;
                int dist;
                point.getPosPix(this.pix);
                int ix = this.pix.x[0];
                int iy = this.pix.y[0];
                if (ix >= this.MP.ix1 && ix <= this.MP.ix2 && iy >= this.MP.iy1 && iy <= this.MP.iy2 && (dist = (dx = ix - x) * dx + (dy = iy - y) * dy) <= mdist && (dist < mdist || _select == -1 || point.highlightColor != null || this.points[_select].highlightColor == null)) {
                    _select = i;
                    point.distFromCurrentPix = mdist = dist;
                }
            }
            i = (i + 1) % this.numSpotsUsedInPointsArray;
        }
        return _select;
    }

    private int getNearestByGreatArc(Position pos, double range) {
        int _select = -1;
        if (this.bPos == -1 && this.bPosX == -1) {
            this.warn("Can not select by great arc, no POS component found.");
        } else {
            if (pos.referenceFrame == 0) {
                pos.car2geo();
            }
            Position point = new Position(1);
            double lastDist = range < 0.0 ? Double.MAX_VALUE : range;
            int i = this.hasWrapped() ? this.firstPoint : 0;
            for (int j = 0; j < this.numSpotsUsedInPointsArray; ++j) {
                Point3D pnt = this.points[i];
                if (pnt != null && !pnt.isHidden() && (this.visibilityFilter == null || this.passVisibilityFilter(pnt, this.visibilityFilter))) {
                    point.lon = pnt.posLon;
                    point.lat = pnt.posLat;
                    point.alt = pnt.posAlt;
                    point.referenceFrame = 1;
                    double dist = Transform.greatArc(pos, point);
                    pos.car2geo();
                    if (dist <= lastDist) {
                        _select = i;
                        lastDist = dist;
                    }
                }
                i = (i + 1) % this.numSpotsUsedInPointsArray;
            }
        }
        return _select;
    }

    private boolean hasWrapped() {
        return this.firstPoint != -1 && this.points != null && this.numSpotsUsedInPointsArray == this.points.length && this.points.length >= this.maxPointsSize;
    }

    private Point3D getPointAt(int index) {
        return this.points[index];
    }

    int getNumVisiblePoints() {
        if (this.showClusters) {
            return 0;
        }
        return this.numVisiblePoints;
    }

    private Point3D getVisiblePoint(int index, boolean posp, boolean cones, boolean ellipses) {
        if (this.points == null || this.points.length == 0) {
            return null;
        }
        Point3D point = this.points[index];
        if (point == null) {
            return null;
        }
        if (this.quickDraw && this.MP.is2D) {
            if (!point.hit(this.MP.rx1, this.MP.rx2, this.MP.ry1, this.MP.ry2)) {
                point.in2DViewRange = false;
                return null;
            }
            point.in2DViewRange = true;
        } else if (!this.isPointVisible(index)) {
            point.in2DViewRange = false;
            if (!(this.isPointVisible(index + 1) || this.isPointVisible(index - 1) || this.isLineVisibleToFromPoint(index))) {
                return null;
            }
        } else {
            point.in2DViewRange = this.MP.is2D && (!point.coneSet || this.isConeCenterVisible(point));
        }
        point.prep(posp);
        return point;
    }

    private boolean isPointVisible(int index) {
        if (index < 0 || index > this.points.length - 1) {
            return false;
        }
        Point3D point = this.points[index];
        if (point == null) {
            return false;
        }
        return !this.MP.is2D || point.hit(this.MP.rx1, this.MP.rx2, this.MP.ry1, this.MP.ry2);
    }

    private boolean isLineVisibleToFromPoint(int index) {
        boolean visNext = false;
        boolean visLast = false;
        if (index < 0) {
            return false;
        }
        Point3D point = this.points[index];
        if (point == null) {
            return false;
        }
        Point3D next = null;
        if (index + 1 < this.points.length) {
            next = this.points[index + 1];
        }
        if (next != null) {
            visNext = true;
            if (point.maxLon < this.MP.rx1 && next.maxLon < this.MP.rx1 || point.minLon > this.MP.rx2 && next.minLon > this.MP.rx2 || point.maxLat < this.MP.ry1 && next.maxLat < this.MP.ry1 || point.minLat > this.MP.ry2 && next.minLat > this.MP.ry2) {
                visNext = false;
            }
        }
        Point3D last = null;
        if (index - 1 >= 0) {
            last = this.points[index - 1];
        }
        if (last != null) {
            visLast = true;
            if (point.maxLon < this.MP.rx1 && last.maxLon < this.MP.rx1 || point.minLon > this.MP.rx2 && last.minLon > this.MP.rx2 || point.maxLat < this.MP.ry1 && last.maxLat < this.MP.ry1 || point.minLat > this.MP.ry2 && last.minLat > this.MP.ry2) {
                visLast = false;
            }
        }
        return visNext || visLast;
    }

    @Deprecated
    protected final String getPointName(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : tbl.getS("NAME");
    }

    @Deprecated
    protected final String getPointNote(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : tbl.getS("NOTE");
    }

    @Deprecated
    protected final float[] getPointHeading(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (float[])tbl.getKey("HDG");
    }

    @Deprecated
    protected final double[] getPointPos(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (double[])tbl.getKey("POS");
    }

    @Deprecated
    protected final double[] getAllPointPos() {
        double[] allPos = new double[3 * this.numSpotsUsedInPointsArray];
        int i = 0;
        for (int j = 0; j < allPos.length; j += 3) {
            System.arraycopy(this.getPointPos(i), 0, allPos, j, 3);
            ++i;
        }
        return allPos;
    }

    @Deprecated
    protected final double[] getAllPointPosp() {
        double[] allPos = new double[3 * this.numSpotsUsedInPointsArray];
        int i = 0;
        for (int j = 0; j < allPos.length; j += 3) {
            System.arraycopy(this.getPointPosp(i), 0, allPos, j, 3);
            ++i;
        }
        return allPos;
    }

    @Deprecated
    protected final double[] getPointPosp(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (double[])tbl.getKey("POSP");
    }

    @Deprecated
    protected final double[] getPointElps(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (double[])tbl.getKey("ELPS");
    }

    @Deprecated
    protected final double[] getPointCone(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (double[])tbl.getKey("CONE");
    }

    @Deprecated
    protected final byte[] getPointFlag(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (byte[])tbl.getKey("FLAG");
    }

    @Deprecated
    protected final byte getPointFlag(int index, int id) {
        byte[] flags = this.getPointFlag(index);
        return flags == null ? (byte)0 : flags[id];
    }

    @Deprecated
    protected final byte[] getPointConn(int index) {
        Table tbl = this.getPoint(index);
        return tbl == null ? null : (byte[])tbl.getKey("CONN");
    }

    @Deprecated
    protected int getPointCount() {
        return this.numSpotsUsedInPointsArray;
    }

    public int countPointsInRange(double x1, double x2, double y1, double y2) {
        if (y1 == y2) {
            return 0;
        }
        if (x1 == x2) {
            return 0;
        }
        double xmin = Math.min(x1, x2);
        double xmax = Math.max(x1, x2);
        double ymin = Math.min(y1, y2);
        double ymax = Math.max(y1, y2);
        int indexX1 = RegionGroup.getXIndex(xmin);
        int indexX2 = RegionGroup.getXIndex(xmax);
        int indexY1 = RegionGroup.getYIndex(ymin);
        int indexY2 = RegionGroup.getYIndex(ymax);
        double startXRWC = this.getRwcFromIndex(indexX1, 0, true);
        double endXRWC = this.getRwcFromIndex(indexX2, 0, false);
        double startYRWC = this.getRwcFromIndex(indexY1, 1, true);
        double endYRWC = this.getRwcFromIndex(indexY2, 1, false);
        int pntCount = 0;
        if (xmin >= startXRWC && xmax <= endXRWC && ymin >= startYRWC && ymax <= endYRWC) {
            for (int i = indexX1; i <= indexX2; ++i) {
                for (int j = indexY1; j <= indexY2; ++j) {
                    if (this.regionGroups[i][j] == null) continue;
                    RegionGroup cg = this.regionGroups[i][j];
                    if (cg.minX >= xmin && cg.maxX <= xmax && cg.minY >= ymin && cg.maxY <= ymax) {
                        pntCount += this.regionGroups[i][j].getNumPtsInRegionGroup();
                        continue;
                    }
                    pntCount += cg.countPointsInRange(xmin, xmax, ymin, ymax);
                }
            }
        }
        return pntCount;
    }

    double getRwcFromIndex(int val, int xOrY, boolean start) {
        int addToComplete = 0;
        if (xOrY == 0) {
            if (!start) {
                addToComplete = 20;
            }
            return val * 20 - MPlot.LONGITUDE_RANGE / 2 + addToComplete;
        }
        if (!start) {
            addToComplete = 20;
        }
        return val * 20 - MPlot.LATITUDE_RANGE / 2 + addToComplete;
    }

    public Table getPoint(int index) {
        Table tbl = null;
        if (index >= 0 && index < this.numSpotsUsedInPointsArray && this.points[index] != null) {
            tbl = this.points[index].toTable();
        }
        return tbl;
    }

    public void setPoint(int index, Table table) {
        if (this.numSpotsUsedInPointsArray == 0) {
            this.updatePointsComponents(table);
        } else {
            this.validatePointComponents(table, false);
        }
        Point3D point = new Point3D(table, this);
        if (index < 0) {
            index = this.numSpotsUsedInPointsArray;
        }
        if (index >= this.numSpotsUsedInPointsArray) {
            while (index + 1 < this.numSpotsUsedInPointsArray) {
                this.addPoint(null, true);
            }
            this.addPoint(point, true);
            this.setSizeWithForceOpt(this.points.length, false);
        } else {
            this.points[index] = point;
        }
        if (this.MP != null && !this.MP.isMapView() && this.MP.view != 15 && this.numSpotsUsedInPointsArray == 1) {
            this.rangeMatchPoint(point);
            this.minMaxSet = false;
            this.updateRange(point);
            this.minMaxSet = false;
            this.MP.useRange();
        } else if (this.MP != null && !this.MP.isMapView()) {
            this.updateRange(point);
            this.MP.useRange();
        }
        this.refresh();
    }

    public void mergePoint(int index, Table table) {
        boolean mergingWithExistingPt;
        boolean bl = mergingWithExistingPt = index < this.numSpotsUsedInPointsArray;
        if (this.numSpotsUsedInPointsArray == 0) {
            this.updatePointsComponents(table);
        } else if (this.numSpotsUsedInPointsArray > 0) {
            this.validatePointComponents(table, mergingWithExistingPt);
        }
        if ((this.debugMask & 1) != 0) {
            System.out.println("******** LayerT5.mergePoint********: index=" + index + ", #pts=" + this.numSpotsUsedInPointsArray);
        }
        if (index < 0) {
            index = this.numSpotsUsedInPointsArray;
        }
        if (!mergingWithExistingPt) {
            Point3D point = new Point3D(table, this);
            while (index + 1 < this.numSpotsUsedInPointsArray) {
                this.addPoint(null, true);
            }
            this.addPoint(point, true);
            this.setSizeWithForceOpt(this.points.length, false);
        } else if (this.points[index] == null) {
            this.points[index] = new Point3D(table, this);
        } else {
            this.points[index].fromTable(table);
        }
        this.refresh();
    }

    public void mergeAllPoints(Table table) {
        if (this.numSpotsUsedInPointsArray > 0) {
            this.validatePointComponents(table, true);
        }
        if ((this.debugMask & 1) != 0) {
            System.out.println("******LayerT5.mergeAllPoints********: #pts=" + this.numSpotsUsedInPointsArray);
        }
        for (int index = 0; index < this.numSpotsUsedInPointsArray; ++index) {
            if (this.points[index] == null) {
                this.points[index] = new Point3D(table, this);
                continue;
            }
            this.points[index].fromTable(table);
        }
        this.refresh();
    }

    private void updatePointsComponents(Table table) {
        if (this.bName == -1 && table.containsKey("NAME")) {
            this.bName = -2;
        }
        if (this.bPos == -1 && table.containsKey("POS")) {
            this.bPos = -2;
        }
        if (this.bPosp == -1 && table.containsKey("POSP")) {
            this.bPosp = -2;
        }
        if (this.bFlag == -1 && table.containsKey("FLAG")) {
            this.bFlag = -2;
        }
        if (this.bNote == -1 && table.containsKey("NOTE")) {
            this.bNote = -2;
        }
        if (this.bElps == -1 && table.containsKey("ELPS")) {
            this.bElps = -2;
        }
        if (this.bConn == -1 && table.containsKey("CONN")) {
            this.bConn = -2;
        }
        if (this.bHdg == -1 && table.containsKey("HDG")) {
            this.bHdg = -2;
        }
    }

    private void validatePointComponents(Table table, boolean isMerge) {
        boolean missingComponents;
        if (table == null) {
            return;
        }
        StringBuilder additionalKeys = new StringBuilder();
        StringBuilder missingKeys = new StringBuilder();
        boolean ptHasName = table.containsKey("NAME");
        boolean ptHasPos = table.containsKey("POS");
        boolean ptHasPosp = table.containsKey("POSP");
        boolean ptHasFlag = table.containsKey("FLAG");
        boolean ptHasNote = table.containsKey("NOTE");
        boolean ptHasElps = table.containsKey("ELPS");
        boolean ptHasConn = table.containsKey("CONN");
        boolean ptHasHdg = table.containsKey("HDG");
        if (this.bName == -1 && ptHasName) {
            additionalKeys.append(" \"NAME\"");
        }
        if (this.bPos == -1 && ptHasPos) {
            additionalKeys.append(" \"POS\"");
        }
        if (this.bPosp == -1 && ptHasPosp) {
            additionalKeys.append(" \"POSP\"");
        }
        if (this.bFlag == -1 && ptHasFlag) {
            additionalKeys.append(" \"FLAG\"");
        }
        if (this.bNote == -1 && ptHasNote) {
            additionalKeys.append(" \"NOTE\"");
        }
        if (this.bElps == -1 && ptHasElps) {
            additionalKeys.append(" \"ELPS\"");
        }
        if (this.bConn == -1 && ptHasConn) {
            additionalKeys.append(" \"CONN\"");
        }
        if (this.bHdg == -1 && ptHasHdg) {
            additionalKeys.append(" \"HDG\"");
        }
        if (!isMerge) {
            if (this.bName != -1 && !ptHasName) {
                missingKeys.append(" \"NAME\"");
            }
            if (this.bPos != -1 && !ptHasPos) {
                missingKeys.append(" \"POS\"");
            }
            if (this.bPosp != -1 && !ptHasPosp) {
                missingKeys.append(" \"POSP\"");
            }
            if (this.bFlag != -1 && !ptHasFlag) {
                missingKeys.append(" \"FLAG\"");
            }
            if (this.bNote != -1 && !ptHasNote) {
                missingKeys.append(" \"NOTE\"");
            }
            if (this.bElps != -1 && !ptHasElps) {
                missingKeys.append(" \"ELPS\"");
            }
            if (this.bConn != -1 && !ptHasConn) {
                missingKeys.append(" \"CONN\"");
            }
            if (this.bHdg != -1 && !ptHasHdg) {
                missingKeys.append(" \"HDG\"");
            }
        }
        boolean invalidExtraComponents = additionalKeys.length() != 0;
        boolean bl = missingComponents = missingKeys.length() != 0;
        if (invalidExtraComponents || missingComponents) {
            StringBuilder sb = new StringBuilder();
            sb.append("LayerT5: Invalid new/updated Point with table: ").append(table);
            sb.append("\n New/updated Point MUST match existing Point Components so that they are homogeneous.");
            if (invalidExtraComponents) {
                sb.append("\n - new/updated Point contains these invalid additional Type 5000 Components: ").append((CharSequence)additionalKeys);
            }
            if (missingComponents) {
                sb.append("\n - new/replaced Point is missing these Type 5000 Components: ").append((CharSequence)missingKeys);
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public synchronized void deletePoint(int index) {
        if (this.points[index] == null) {
            return;
        }
        if (index < 0 && index >= this.numSpotsUsedInPointsArray) {
            return;
        }
        this.removePointFromRegion(this.points[index]);
        if (this.select == index) {
            this.setSelectedIndex(-1);
        }
        this.points[index] = null;
        this.pointsNulled.push(index);
        if (this.MP != null && this.MP.view == 15 && this.isPointMaxRange(this.points[index])) {
            this.recalculateFullRange();
        }
        this.refresh();
    }

    @Override
    public synchronized boolean clear() {
        if (this.numSpotsUsedInPointsArray == 0 || this.pointsNulled.size() == this.points.length) {
            return false;
        }
        this.setSelectedIndex(-1);
        this.points = new Point3D[this.size];
        this.pointsNulled = new Stack();
        if (this.needsTimeOrder) {
            this.timeSortOfPtIndicies = new LinkedList();
        }
        this.numSpotsUsedInPointsArray = 0;
        this.firstPoint = Math.min(0, this.firstPoint);
        this.regionGroups = new RegionGroup[MPlot.LONGITUDE_RANGE / 20][MPlot.LATITUDE_RANGE / 20];
        if (this.MP != null && this.MP.view == 15) {
            this.recalculateFullRange();
        }
        return true;
    }

    @InternalUseOnly
    public synchronized void deletePoints(int indexFirst, int indexLast) {
        boolean updateRange = false;
        if (indexFirst == 0 && indexLast == -1) {
            this.clear();
        } else {
            if (indexFirst > this.numSpotsUsedInPointsArray) {
                this.warning("LayerT5.deletePoints indexFirst=" + indexFirst + " larger than the number of points, skipping the deletetion of points.");
                return;
            }
            if (indexLast == -1) {
                indexLast = this.numSpotsUsedInPointsArray - 1;
            }
            if (indexLast < indexFirst) {
                this.warning("LayerT5.deletePoints indexLast:" + indexLast + " < indexFirst:" + indexFirst);
                return;
            }
            if (indexFirst < 0) {
                this.warning("LayerT5.deletePoints indexFirst=" + indexFirst + " < 0 setting value to 0");
                indexFirst = 0;
            }
            if (indexLast >= this.numSpotsUsedInPointsArray) {
                this.warning("LayerT5.deletePoints indexLast=" + indexLast + " beyond point range, setting value to index of last point:" + (this.numSpotsUsedInPointsArray - 1));
                indexLast = this.numSpotsUsedInPointsArray - 1;
            }
            for (int index = indexFirst; index <= indexLast; ++index) {
                if (this.points[index] == null) continue;
                if (this.select == index) {
                    this.setSelectedIndex(-1);
                }
                boolean bl = updateRange = this.MP != null && this.MP.view == 15 && (updateRange || this.isPointMaxRange(this.points[index]));
                if (this.formRegionGroups) {
                    this.removePointFromRegion(this.points[index]);
                }
                this.points[index] = null;
                this.pointsNulled.push(index);
            }
        }
        if (updateRange) {
            this.recalculateFullRange();
        }
        this.refresh();
    }

    @InternalUseOnly
    public void copyPoint(int indexOrig, int indexForCopy) {
        if (indexOrig < 0 || indexOrig >= this.numSpotsUsedInPointsArray) {
            throw new MidasException("LayerT5.copyPoint invalid index of original:" + indexOrig + " valid range 0 - " + (this.numSpotsUsedInPointsArray - 1));
        }
        if (indexForCopy == -1) {
            this.addPoint(new Point3D(this.points[indexOrig].toTable(), this), true);
        } else if (indexForCopy >= 0 && indexForCopy < this.numSpotsUsedInPointsArray) {
            this.points[indexForCopy] = this.points[indexOrig] != null ? new Point3D(this.points[indexOrig].toTable(), this) : null;
        } else if (indexForCopy >= this.numSpotsUsedInPointsArray) {
            while (indexForCopy + 1 < this.numSpotsUsedInPointsArray) {
                this.addPoint(null, true);
            }
            this.addPoint(new Point3D(this.points[indexOrig].toTable(), this), true);
            this.setSizeWithForceOpt(this.points.length, false);
        }
    }

    @InternalUseOnly
    public int getPercentMatchingFilter() {
        if (this.visibilityFilter != null && this.filteredPoints != null) {
            return 100 * this.filteredPoints.size() / this.numSpotsUsedInPointsArray;
        }
        return 100;
    }

    private int addPoint(Point3D pnt) {
        return this.addPoint(pnt, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized int addPoint(Point3D pnt, boolean addToEnd) {
        boolean pointsFull;
        pnt.setFilterDataTable(this.addNameFD, this.addPosFD, this.addPospFD, this.addElpsFD, this.addConeFD, this.addTimeFD, this.addNoteFD, this.addMetaFD);
        if (pnt.time > this.newestTimeReceived) {
            this.newestTimeReceived = pnt.time;
        }
        int index = -1;
        boolean pointsIntialized = this.points != null && this.points.length != 0;
        boolean bl = pointsFull = pointsIntialized && this.numSpotsUsedInPointsArray == this.points.length;
        if (!pointsIntialized) {
            if (this.size < 1) {
                this.warning("LayerT5: Got size < 1");
                this.size = 1;
            }
            this.points = new Point3D[this.size];
            this.numSpotsUsedInPointsArray = 1;
            index = 0;
            this.firstPoint = this.firstPoint == -1 ? -1 : 0;
            pnt.indexInPointsObject = index;
            this.points[index] = pnt;
            if (this.needsTimeOrder) {
                this.timeSortOfPtIndicies = new LinkedList();
                this.timeSortOfPtIndicies.add(index);
            }
            if (!this.formRegionGroups) return index;
            this.addPointToRegion(pnt);
            return index;
        }
        if (this.firstPoint == -1 || pointsFull && this.points.length < this.maxPointsSize) {
            if (!addToEnd && this.pointsNulled.size() > 0) {
                index = this.pointsNulled.pop();
            } else {
                if (this.numSpotsUsedInPointsArray + 1 >= this.points.length) {
                    int doubleSize = this.points.length * 2;
                    int newLength = this.firstPoint == -1 ? doubleSize : Math.min(this.maxPointsSize, doubleSize);
                    Point3D[] array = new Point3D[newLength];
                    System.arraycopy(this.points, 0, array, 0, this.points.length);
                    this.points = array;
                }
                index = this.numSpotsUsedInPointsArray++;
            }
        } else if (pointsFull) {
            if (this.pointsNulled.size() > 0) {
                index = this.pointsNulled.pop();
            } else if (!this.needsTimeOrder) {
                this.removePointFromRegion(this.points[this.firstPoint]);
                index = this.firstPoint;
                if (this.select == index) {
                    this.setSelectedIndex(-1);
                }
                this.firstPoint = (this.firstPoint + 1) % this.points.length;
            } else {
                if (!(pnt.time > this.points[this.timeSortOfPtIndicies.peekFirst().intValue()].time)) return -1;
                index = this.removeOldestPoint();
                if (this.select == index) {
                    this.setSelectedIndex(-1);
                }
                this.pointsNulled.remove((Object)index);
            }
        } else {
            index = this.numSpotsUsedInPointsArray++;
        }
        pnt.indexInPointsObject = index;
        this.points[index] = pnt;
        if (this.needsTimeOrder) {
            this.insertPointIdxInTimeArray(index);
        }
        this.updateRange(pnt);
        if (!this.formRegionGroups) return index;
        this.addPointToRegion(pnt);
        return index;
    }

    private int removeOldestPoint() {
        int idxRemoved = this.timeSortOfPtIndicies.removeFirst();
        this.deletePoint(idxRemoved);
        return idxRemoved;
    }

    private void insertPointIdxInTimeArray(int index) {
        double pntTime = this.points[index].time;
        if (this.timeSortOfPtIndicies.size() > 1) {
            double timeFirst = this.points[this.timeSortOfPtIndicies.peekFirst().intValue()].time;
            double timeLast = this.points[this.timeSortOfPtIndicies.peekLast().intValue()].time;
            if (pntTime <= timeFirst) {
                this.timeSortOfPtIndicies.addFirst(index);
            } else if (pntTime >= timeLast) {
                this.timeSortOfPtIndicies.addLast(index);
            } else {
                int insertionIndex = this.findInsertionIndex(index, timeFirst, timeLast);
                this.timeSortOfPtIndicies.add(insertionIndex, index);
            }
        } else if (this.timeSortOfPtIndicies.size() == 1) {
            double timeFirst = this.points[this.timeSortOfPtIndicies.peekFirst().intValue()].time;
            if (pntTime < timeFirst) {
                this.timeSortOfPtIndicies.addFirst(index);
            } else {
                this.timeSortOfPtIndicies.addLast(index);
            }
        } else {
            this.timeSortOfPtIndicies.addFirst(index);
        }
    }

    @InternalUseOnly
    public int findInsertionIndex(int pointIdx, double timeOldest, double timeNewest) {
        double pntTime = this.points[pointIdx].time;
        if (pntTime - timeOldest > pntTime - timeNewest) {
            Iterator<Integer> iterDown = this.timeSortOfPtIndicies.descendingIterator();
            while (iterDown.hasNext()) {
                int thisIndex = iterDown.next();
                double thisTime = this.points[thisIndex].time;
                if (!(pntTime > thisTime)) continue;
                return thisIndex;
            }
        } else {
            ListIterator iterUp = this.timeSortOfPtIndicies.listIterator();
            while (iterUp.hasNext()) {
                int thisIndex = (Integer)iterUp.next();
                double thisTime = this.points[thisIndex].time;
                if (!(pntTime < thisTime)) continue;
                return thisIndex;
            }
        }
        return -1;
    }

    public void setFlags(int value) {
        if (this.flags != value) {
            this.flags = value;
            this.refresh();
        }
    }

    public void setFlags(String value) {
        this.setFlags(Parser.mask(flagsList, value, this.flags));
    }

    public String getFlags() {
        return Parser.mask2s(flagsList, this.flags);
    }

    private void warn(String msg) {
        this.warning("LayerT5: " + msg);
    }

    private boolean showField(int flag) {
        return (this.field & flag) != 0;
    }

    @Override
    public void configure() {
        new GMenu(this.MP, "Layer.cfg", "Rename,Delete,Enable,Scale,Line,Symbol,Surface,Feature,Color,Colors,ColorMap,Query,Effects,AutoSelect", 0, 0, this);
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("LAYER.CFG") && ((String)msg.data).equals("AUTOSELECT")) {
            new GMenu(this.MP, "AutoSelect.Options", "Enable,SelectionMode,SelectionRange", 0, 0, this);
        } else if (msg.name.equals("AUTOSELECT.OPTIONS")) {
            String text = (String)msg.data;
            if (text.equals("ENABLE")) {
                new GMenu(this.MP, "AutoSelect.Enable", "Click,Motion,Drag", this.autoSelEnable, 1024, this);
            } else if (text.equals("SELECTIONMODE")) {
                new GMenu(this.MP, "AutoSelect.SelectionMode", selectionModes, this.autoSelMode, 0, this);
            } else if (text.equals("SELECTIONRANGE")) {
                new GPrompt(this.MP, "AutoSelect.SelectionRange", Double.toString(this.autoSelRange), 0, (MessageHandler)this);
            }
        } else if (msg.name.equals("AUTOSELECT.ENABLE")) {
            this.autoSelEnable = msg.info;
        } else if (msg.name.equals("AUTOSELECT.SELECTIONMODE")) {
            this.autoSelMode = msg.info;
        } else if (msg.name.equals("AUTOSELECT.SELECTIONRANGE")) {
            this.autoSelRange = Convert.o2d(msg.data);
        } else {
            return super.processMessage(msg);
        }
        return 1;
    }

    public void setAutoSelectEnable(String enable) {
        this.autoSelEnable = Parser.mask("Click,Motion,Drag", enable, this.autoSelEnable);
    }

    public String getAutoSelectEnable() {
        return Parser.mask2s("Click,Motion,Drag", this.autoSelEnable);
    }

    public void setAutoSelectMode(String mode) {
        this.autoSelMode = Parser.find(selectionModes, mode, this.autoSelMode, 0, 1);
    }

    public String getAutoSelectMode() {
        return Parser.get(selectionModes, this.autoSelMode);
    }

    public void setAutoSelectRange(double range) {
        this.autoSelRange = range;
    }

    public double getAutoSelectRange() {
        return this.autoSelRange;
    }

    public void setDataType(String dataType) {
        this.isGeodeticData = !dataType.toLowerCase().startsWith("xyz");
    }

    @InternalUseOnly
    public void setPopupLabels(String strTbl) {
        this.popupLabels = strTbl == null || strTbl.isEmpty() ? new Table() : new Table(strTbl);
    }

    @Override
    public void processMouseMessage(Message msg, int type) {
        if (!this.isVisible()) {
            return;
        }
        if ((this.autoSelEnable & type) != 0) {
            if (this.autoSelMode == 1 || this.maxAlt != 0.0 || this.minAlt != 0.0) {
                if (!(msg.quals instanceof Table)) {
                    return;
                }
                Table quals = (Table)msg.quals;
                if (!(quals.get("ORIG_MSG_DATA") instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)quals.get("ORIG_MSG_DATA");
                Point point = me.getPoint();
                this.setSelectedIndex(this.getNearestPixelIndex(point.x, point.y, 625.0));
            } else {
                Position pos = (Position)msg.getData();
                this.selectNearest(this.autoSelMode, pos, this.autoSelRange);
            }
            if (GraphicsUtil.isCtrlLMB(msg)) {
                this.drawPopup(this.getSelectedIndex());
            }
        }
    }

    void drawPopup(int index) {
        if (index < 0) {
            return;
        }
        if (this.activePopup) {
            this.closeCurrentPopup();
        }
        this.htmlPopup = new PopUpHTML(this.points[index].toPopupTable(), this.MP);
        this.activePopup = true;
    }

    void closeCurrentPopup() {
        if (this.htmlPopup != null) {
            this.htmlPopup.close();
        }
        this.activePopup = false;
    }

    private void recalculateFullRange() {
        this.zRange = 0.0;
        this.yRange = 0.0;
        this.xRange = 0.0;
        for (int i = 0; i < this.points.length; ++i) {
            Point3D pnt = this.points[i];
            if (pnt == null) continue;
            this.xRange = pnt.xRangeMax > this.xRange ? pnt.xRangeMax : this.xRange;
            this.yRange = pnt.yRangeMax > this.yRange ? pnt.yRangeMax : this.yRange;
            this.zRange = pnt.zRangeMax > this.zRange ? pnt.zRangeMax : this.zRange;
        }
    }

    private boolean isPointMaxRange(Point3D pnt) {
        if (pnt == null) {
            return false;
        }
        return Math.abs(pnt.xRangeMax) == this.xRange || Math.abs(pnt.yRangeMax) == this.yRange || Math.abs(pnt.zRangeMax) == this.zRange;
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    @Override
    public void findFullRange(PlotFile pf) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
    }

    @InternalUseOnly(value="Used by LayerT5Test")
    public int getPointsNulledSize() {
        return this.pointsNulled.size();
    }

    @InternalUseOnly(value="Used by LayerT5Test")
    public int getPointsSize() {
        return this.numSpotsUsedInPointsArray;
    }

    @InternalUseOnly
    public int getPointsLength() {
        return this.points.length;
    }

    @InternalUseOnly(value="Used by LayerT5Test")
    public int peekAtNextNulledIndex() {
        return this.pointsNulled.peek();
    }

    public static Layer getLayer() {
        return new LayerT5();
    }

    public void setX(String x) {
    }

    public void setY(String y) {
    }

    public void setZ(String z) {
    }

    public void setTimeLF(String time) {
    }

    @InternalUseOnly
    public void setMetaPos(String metadata) {
    }

    @InternalUseOnly
    public void setMetadataFields(String metadataFields) {
    }

    public void setMetadataFieldNames(String[] metadataFieldNames) {
        this.metadataFieldNames = metadataFieldNames;
    }

    @InternalUseOnly
    public void setFilterDataFields(String filterDataFields) {
    }

    public void setSelectMessages(String sendSelectMessages) {
        this.setSelectMessages(sendSelectMessages.toLowerCase().startsWith("t"));
    }

    public void setSelectMessages(boolean sendSelectMessages) {
        this.sendSelectMessages = sendSelectMessages;
    }

    public void setHighlightTotalMessages(boolean sendHighlightTotalMessages) {
        this.sendHighlightTotalMessages = this.sendSelectMessages;
    }

    public void setHighlightTotalMessages(String sendHighlightTotalMessages) {
        this.setHighlightTotalMessages(sendHighlightTotalMessages.toLowerCase().startsWith("t"));
    }

    @Override
    public void setEnable(int value) {
        boolean layerHidden;
        if ((this.enable & 1) == 0 != (layerHidden = (value & 1) == 0)) {
            if (this.mwMsgHandler == null) {
                this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
            }
            if (this.select != -1) {
                if (layerHidden) {
                    if (this.activePopup && this.htmlPopup != null) {
                        this.closeCurrentPopup();
                        this.activePopup = true;
                    }
                    if (this.mwMsgHandler != null) {
                        this.mwMsgHandler.processMessage(new Message("DESELECT", 0, this.getSelected(), this.mwMsgHandler, this.MP.mh));
                    }
                } else {
                    if (this.activePopup) {
                        this.drawPopup(this.getSelectedIndex());
                    }
                    if (this.mwMsgHandler != null) {
                        this.mwMsgHandler.processMessage(new Message("SELECT", 0, this.getSelected(), this.mwMsgHandler, this.MP.mh));
                    }
                }
            }
            this.clearVisibleHighlightTotals();
        }
        super.setEnable(value);
    }

    private void clearVisibleHighlightTotals() {
        for (String key : this.highlightSettingMap.keySet()) {
            boolean visibleTotalUpdated;
            HighlightSetting highlightSetting = this.highlightSettingMap.get(key);
            int visibleTotal = highlightSetting.getNumVisibleHighlighted();
            highlightSetting.setNumVisibleHighlighted(0);
            highlightSetting.clearRunningVisibleTotal();
            boolean bl = visibleTotalUpdated = visibleTotal != 0;
            if (!this.sendHighlightTotalMessages || !visibleTotalUpdated) continue;
            if (this.mwMsgHandler == null) {
                this.mwMsgHandler = ((plot)this.MP.mh).getMessageHandler();
            }
            if (this.mwMsgHandler == null || !visibleTotalUpdated) continue;
            this.mwMsgHandler.processMessage(new Message("HIGHLIGHT_VISIBLE_TOTAL", 0, key, this.mwMsgHandler, this.MP.mh));
        }
    }

    private char[] buildFormatsArray() {
        char[] arr = new char[8];
        Arrays.fill(arr, ' ');
        return arr;
    }

    private int[] buildFlagBytePosArray() {
        int[] arr = new int[8];
        Arrays.fill(arr, -1);
        return arr;
    }

    boolean isGeodeticData() {
        return this.isGeodeticData;
    }

    @Override
    public void clearNeedRefresh() {
        super.clearNeedRefresh();
        this.numVisiblePoints = 0;
    }

    int getAutoSelEnable() {
        return this.autoSelEnable;
    }

    @Override
    public void close() {
        this.setSelectedIndex(-1);
        super.close();
    }

    @Override
    public void setColor(String value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[this.colors.length - 1] = this.line.getColor();
        }
    }

    @Override
    public void setColor(int value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[this.colors.length - 1] = this.line.getColor();
        }
    }

    @Override
    public void setColor(Color value) {
        super.setColor(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.colors[this.colors.length - 1] = this.line.getColor();
        }
    }

    public static void setAutoAdjustLineColor(boolean matchColormap) {
        autoAdjustLineColor = matchColormap;
    }

    public static boolean getAutoAdjustLineColor() {
        return autoAdjustLineColor;
    }

    @Override
    public void setColors(String value) {
        this.setColorMap(value);
    }

    @Override
    public void setColorMap(String value) {
        super.setColorMap(value);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.line.setColor(this.colors[this.colors.length - 1]);
        }
    }

    @Override
    public void setColorMap(int value) {
        this.setColorMap(value, -1);
    }

    @Override
    public void setColorMap(int value, int ncolors) {
        super.setColorMap(value, ncolors);
        if (autoAdjustLineColor && this.colors != null && this.colors.length > 1) {
            this.line.setColor(this.colors[this.colors.length - 1]);
        }
    }

    @Override
    public void setColorMap(Color[] colors) {
        super.setColorMap(colors);
        if (autoAdjustLineColor && colors != null && colors.length > 1) {
            this.line.setColor(colors[colors.length - 1]);
        }
    }

    public void setTimeWindow(double timeOldest, int mode) {
        this.setTimeWindow(timeOldest, -1.0, mode);
        this.oldestTimeVisible = timeOldest < 0.0 ? -1.0 : timeOldest;
    }

    public void setTimeWindow(double timeOldest, double timeNewest, int mode) {
        if (mode == 0) {
            this.turnOffTimeWindow();
        } else if ((mode & 2) != 0) {
            this.setRelativeTimeWindow(timeOldest, timeNewest, mode);
        } else {
            this.setFixedTimeWindow(timeOldest, timeNewest);
        }
    }

    public void turnOffTimeWindow() {
        this.relativeTimeWindow = false;
        this.activeTimeWindow = false;
        this.newestTimeVisible = -1.0;
        this.oldestTimeVisible = -1.0;
        this.oldestTimeVisible = -1.0;
        this.relativeOldestTimeVisible = -1.0;
        if (this.df == null || !this.df.isPipe()) {
            this.refresh();
        }
    }

    private void setFixedTimeWindow(double timeOldest, double timeNewest) {
        this.oldestTimeVisible = timeOldest < 0.0 ? -1.0 : timeOldest;
        this.newestTimeVisible = timeNewest < 0.0 ? -1.0 : Math.max(timeNewest, timeOldest);
        this.relativeNewestTimeVisible = -1.0;
        this.relativeOldestTimeVisible = -1.0;
        this.activeTimeWindow = this.oldestTimeVisible != -1.0 || this.newestTimeVisible != -1.0;
        this.relativeTimeWindow = false;
        if (this.df == null || !this.df.isPipe()) {
            this.refresh();
        }
    }

    private void setRelativeTimeWindow(double relativeTimeOldest, double relativeTimeNewest, int mode) {
        this.relativeOldestTimeVisible = relativeTimeOldest < 0.0 ? -1.0 : relativeTimeOldest;
        double d = this.relativeNewestTimeVisible = relativeTimeNewest < 0.0 ? -1.0 : Math.max(relativeTimeNewest, relativeTimeOldest);
        if (this.relativeOldestTimeVisible == -1.0) {
            this.oldestTimeVisible = -1.0;
        }
        if (this.relativeNewestTimeVisible == -1.0) {
            this.newestTimeVisible = -1.0;
        }
        this.activeTimeWindow = this.relativeOldestTimeVisible != -1.0 || this.relativeNewestTimeVisible != -1.0;
        this.relativeTimeWindow = true;
        this.relativeMode = mode;
        if (this.df == null || !this.df.isPipe()) {
            this.refresh();
        }
    }

    public void setNeedsTimeOrder(boolean inOrder) {
        this.needsTimeOrder = inOrder;
    }

    public void setNeedsTimeOrder(String inOrder) {
        this.setNeedsTimeOrder(!inOrder.toLowerCase().startsWith("f"));
    }

    public void setTimeOrder(String inOrder) {
        this.setNeedsTimeOrder(inOrder);
    }

    public double getLatestPointTime() {
        if (this.timeSortOfPtIndicies != null && !this.timeSortOfPtIndicies.isEmpty()) {
            return this.points[this.timeSortOfPtIndicies.peekLast().intValue()].time;
        }
        return this.newestTimeReceived;
    }

    public void setColorFade(boolean doColorFade) {
        this.colorFade = doColorFade;
    }

    public void setColorFadeFactor(int fadeFactor) {
        this.colorFadeFactor = fadeFactor;
    }

    public void setFadeColor(Color fadeColor) {
        this.fadeColorR = fadeColor.getRed();
        this.fadeColorG = fadeColor.getGreen();
        this.fadeColorB = fadeColor.getBlue();
    }

    public void setFadeColor(Object fadeColor) {
        this.setFadeColor(MidasColor.getColor(fadeColor, new Color(this.fadeColorR, this.fadeColorG, this.fadeColorB)));
    }

    public void setVisibilityFilter(Map<String, PredicateType> visibilityFilter) {
        this.visibilityFilter = visibilityFilter;
        this.refresh();
    }

    public void nullVisibilityFilter() {
        this.setVisibilityFilter(null);
    }

    public void setIgnoreRange(boolean ignoreRange) {
        this.ignoreRange = ignoreRange;
    }

    private void addPointToRegion(Point3D pnt) {
        int indexY;
        if (pnt == null) {
            return;
        }
        int indexX = RegionGroup.getXIndex(pnt.getPosLon());
        if (this.regionGroups[indexX][indexY = RegionGroup.getYIndex(pnt.getPosLat())] == null) {
            this.regionGroups[indexX][indexY] = new RegionGroup(indexX, indexY, this);
        }
        pnt.indexInRegion = this.regionGroups[indexX][indexY].addPoint(pnt);
        pnt.xIndexInRegionsArray = indexX;
        pnt.yIndexInRegionsArray = indexY;
    }

    private void removePointFromRegion(Point3D pnt) {
        if (pnt == null) {
            return;
        }
        if (pnt.xIndexInRegionsArray == -1 || pnt.yIndexInRegionsArray == -1) {
            return;
        }
        this.regionGroups[pnt.xIndexInRegionsArray][pnt.yIndexInRegionsArray].removePoint(pnt);
    }

    public boolean isShowClusters() {
        return this.showClusters;
    }

    public void setShowClusters(boolean showClusters) {
        if (showClusters && !this.formRegionGroups) {
            this.setFormRegions(true);
        }
        this.showClusters = showClusters;
        this.refresh();
    }

    public void setFormRegions(boolean formRegion) {
        if (this.formRegionGroups != formRegion) {
            this.formRegionGroups = formRegion;
            if (formRegion) {
                if (this.points == null) {
                    return;
                }
                for (Point3D thisPoint : this.points) {
                    this.addPointToRegion(thisPoint);
                }
            } else {
                this.regionGroups = new RegionGroup[MPlot.LONGITUDE_RANGE / 20][MPlot.LATITUDE_RANGE / 20];
            }
        }
    }

    public void setMinimumClusterSize(int minimumClusterSize) {
        this.minimumClusterSize = minimumClusterSize;
    }

    RegionGroup[][] getRegionGroups() {
        return this.regionGroups;
    }

    private static class HighlightSetting {
        private Map<String, PredicateType> highlightFilter;
        private Color highlightColor;
        private int numHighlighted = 0;
        private int numVisibleHighlighted = 0;
        private int runningTotalHighlighted = 0;
        private int runningVisibleTotalHighlighted = 0;

        private HighlightSetting(Map<String, PredicateType> highlightFilter, String highlightColor) {
            this(highlightFilter, MidasColor.getColor(highlightColor));
        }

        private HighlightSetting(Map<String, PredicateType> highlightFilter, String highlightColor, boolean colorFade) {
            this(highlightFilter, MidasColor.getColor(highlightColor));
        }

        private HighlightSetting(Map<String, PredicateType> highlightFilter, Color highlightColor) {
            this.highlightFilter = highlightFilter;
            this.highlightColor = highlightColor;
        }

        private HighlightSetting(Map<String, PredicateType> highlightFilter, Color highlightColor, boolean colorFade) {
            this(highlightFilter, highlightColor);
        }

        private Map<String, PredicateType> getHighlightFilter() {
            return this.highlightFilter;
        }

        private Color getHighlightColor() {
            return this.highlightColor;
        }

        private void incrementRunningTotal() {
            ++this.runningTotalHighlighted;
        }

        private void clearRunningTotal() {
            this.runningTotalHighlighted = 0;
        }

        private int getRunningTotal() {
            return this.runningTotalHighlighted;
        }

        private void setNumHighlighted(int numHighlighted) {
            this.numHighlighted = numHighlighted;
        }

        private int getNumHighlighted() {
            return this.numHighlighted;
        }

        private void incrementRunningVisibleTotal() {
            ++this.runningVisibleTotalHighlighted;
        }

        private void clearRunningVisibleTotal() {
            this.runningVisibleTotalHighlighted = 0;
        }

        private int getRunningVisibleTotal() {
            return this.runningVisibleTotalHighlighted;
        }

        private void setNumVisibleHighlighted(int numVisibleHighlighted) {
            this.numVisibleHighlighted = numVisibleHighlighted;
        }

        private int getNumVisibleHighlighted() {
            return this.numVisibleHighlighted;
        }
    }
}

