/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.text.DecimalFormat;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.Pix;

public class LayerGrid
extends Layer {
    private int dim;
    private float[] fbuf;
    private DecimalFormat df = new DecimalFormat("#.##");

    public LayerGrid() {
        this.setColorMap(9, -1);
        this.name = "GRID";
    }

    @Override
    public void update() {
        if (this.MP.view == this.MP.viewLast) {
            return;
        }
        this.ndata = 0;
        if (this.MP.view == 10) {
            int nn;
            int ic;
            int n;
            double rmax = Math.max(Math.abs(this.MP.ory1), Math.abs(this.MP.ory2));
            this.fbuf = new float[2056];
            for (n = 30; n <= 90; n += 30) {
                ic = 2;
                double r = rmax * (double)n / 90.0;
                this.set2D(73, ic);
                this.set2D(-180.0, r);
                this.set2D(180.0, r);
                for (nn = -180; nn <= 180; nn += 5) {
                    this.set2D((double)nn, r);
                }
            }
            for (n = -180; n <= 180; n += 30) {
                ic = n == 0 ? 1 : 2;
                this.set2D(19, ic);
                this.set2D(n, 0);
                this.set2D(n, 90);
                for (nn = 0; nn <= 90; nn += 5) {
                    this.set2D((double)n, rmax * (double)nn / 90.0);
                }
            }
            this.dim = 2;
        } else if (this.MP.view == 11 || this.MP.view == 12 || this.MP.view == 13 || this.MP.view == 14) {
            int nn;
            int ic;
            int n;
            this.fbuf = new float[8368];
            for (n = -75; n <= 75; n += 15) {
                ic = n == 0 ? 1 : 2;
                this.set2D(181, ic);
                this.set2D(-180, n);
                this.set2D(180, n);
                for (nn = -180; nn <= 180; nn += 2) {
                    this.set2D(nn, n);
                }
            }
            for (n = -180; n <= 165; n += 15) {
                ic = n == 0 ? 1 : 2;
                this.set2D(87, ic);
                this.set2D(n, -85);
                this.set2D(n, 85);
                this.set2D(n, -85);
                for (nn = -84; nn <= 84; nn += 2) {
                    this.set2D(n, nn);
                }
                this.set2D(n, 85);
            }
            this.dim = 2;
        } else if (this.MP.view == 9) {
            int n;
            int np = 5;
            int np2 = np * 2;
            this.fbuf = new float[3 * (3 + np2 + 1) * 3];
            double xc = 0.0;
            double xd = 1.0 / (double)np;
            double yc = 0.0;
            double yd = 1.0 / (double)np;
            double zc = 0.0;
            double zd = 1.0 / (double)np;
            int ic = 1;
            this.set3D(np2 + 1, ic, 0);
            this.set3D(xc, yc, zc);
            this.set3D(xc + (double)np * xd, yc, zc);
            for (n = -np; n <= np; ++n) {
                this.set3D(xc + (double)n * xd, yc, zc);
            }
            this.set3D(np2 + 1, ic, 0);
            this.set3D(xc, yc, zc);
            this.set3D(xc, yc + (double)np * yd, zc);
            for (n = -np; n <= np; ++n) {
                this.set3D(xc, yc + (double)n * yd, zc);
            }
            this.set3D(np2 + 1, ic, 0);
            this.set3D(xc, yc, zc);
            this.set3D(xc, yc, zc + (double)np * zd);
            for (n = -np; n <= np; ++n) {
                this.set3D(xc, yc, zc + (double)n * zd);
            }
            ic = 2;
            this.dim = 3;
        } else if (this.MP.view == 15) {
            ++this.ndata;
        }
    }

    private void set2D(int x, int y) {
        this.fbuf[this.ndata++] = x;
        this.fbuf[this.ndata++] = y;
    }

    private void set2D(double x, double y) {
        this.fbuf[this.ndata++] = (float)x;
        this.fbuf[this.ndata++] = (float)y;
    }

    private void set3D(int x, int y, int z) {
        this.fbuf[this.ndata++] = x;
        this.fbuf[this.ndata++] = y;
        this.fbuf[this.ndata++] = z;
    }

    private void set3D(double x, double y, double z) {
        this.fbuf[this.ndata++] = (float)x;
        this.fbuf[this.ndata++] = (float)y;
        this.fbuf[this.ndata++] = (float)z;
    }

    @Override
    public void findRange() {
        super.findRange();
        if (this.MP.view == 11 || this.MP.view == 12 || this.MP.view == 13) {
            this.x1 = -180.0;
            this.x2 = 180.0;
            this.y1 = -90.0;
            this.y2 = 90.0;
            this.a1 = this.y1;
            this.a2 = this.y2;
        }
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        if (this.MP.view == 15) {
            this.draw3DGraphGrid();
            return;
        }
        if (this.ndata <= 0) {
            return;
        }
        Line lin = this.line.copy();
        int dim = this.dim;
        int ndata = this.ndata;
        float[] fbufRef = this.fbuf;
        int fbufLen = fbufRef.length;
        Color[] colors = this.colors;
        int colorsLen = colors.length;
        int j = 0;
        while (j < ndata && j + 2 < fbufLen) {
            int k;
            block16: {
                int ncol;
                int npts;
                block14: {
                    block15: {
                        block13: {
                            npts = (int)fbufRef[j++];
                            ncol = (int)fbufRef[j++];
                            if (dim > 2) {
                                j += dim - 2;
                            }
                            if ((k = j + (2 + npts) * dim) < 0) {
                                this.warning("LayerGrid.draw invalid next j of " + k + ": current j=" + j + " npts=" + npts + " dim=" + dim + " fbufLen=" + fbufLen + " ndata=" + this.data);
                                break;
                            }
                            if (this.MP.view != 13 && this.MP.view != 9 && this.MP.view != 10) break block13;
                            j += 2 * dim;
                            break block14;
                        }
                        if (this.MP.view != 14) break block15;
                        if (j < fbufLen && (double)fbufRef[j++] >= this.MP.rx2 || j < fbufLen && (double)fbufRef[j++] >= this.MP.ry2 || j < fbufLen && (double)fbufRef[j] <= this.MP.orx1 && (double)(fbufRef[j] + 360.0f) >= this.MP.orx2) break block16;
                        if (++j >= fbufLen) break block14;
                        int n = j++;
                        if (!((double)fbufRef[n] <= this.MP.ry1)) break block14;
                        break block16;
                    }
                    if (j < fbufLen && (double)fbufRef[j++] >= this.MP.rx2 || j < fbufLen && (double)fbufRef[j++] >= this.MP.ry2 || j < fbufLen && (double)fbufRef[j++] <= this.MP.rx1 || j < fbufLen && (double)fbufRef[j++] <= this.MP.ry1) break block16;
                }
                if (j >= fbufLen) break;
                if (ncol < colorsLen && ncol > 0) {
                    lin.setColor(colors[ncol]);
                } else {
                    this.warning("LayerGrid.draw color number " + ncol + " is Out Of Range, using previous color " + lin.getColor());
                }
                if (this.MP.view == 9) {
                    this.MP.pix.setFlag(8);
                }
                this.MP.drawLine(fbufRef, j, dim, npts, lin);
                if (this.MP.view == 9) {
                    this.MP.pix.clrFlag(8);
                }
            }
            j = k;
        }
    }

    private void draw3DGraphGrid() {
        double[] centerPoints = new double[]{this.MP.view3D.xcenter, this.MP.view3D.ycenter, this.MP.view3D.zcenter, this.MP.view3D.xcenter, this.MP.view3D.ycenter, this.MP.view3D.zcenter};
        double[] ranges = new double[]{Math.abs(this.MP.orx1 - this.MP.orx2) / 2.0, Math.abs(this.MP.ory1 - this.MP.ory2) / 2.0, Math.abs(this.MP.orz1 - this.MP.orz2) / 2.0};
        int numberOfLines = 5;
        Line lin = this.line.copy();
        Color origC = lin.getColor();
        lin.setColor(Color.gray);
        this.drawXYGrid(centerPoints, ranges[0], ranges[1], ranges[2], numberOfLines, lin, origC);
        this.drawYZGrid(centerPoints, ranges[0], ranges[1], ranges[2], numberOfLines, lin, origC);
        this.drawXZGrid(centerPoints, ranges[0], ranges[1], ranges[2], numberOfLines, lin, origC);
        this.MP.gc.setColor(origC);
    }

    private void drawXZGrid(double[] centerPoints, double xRange, double yRange, double zRange, int numberOfLines, Line lin, Color orig) {
        Pix pixCenter = new Pix(1, 0);
        this.MP.viewer.rwc2pix(centerPoints, 0, 3, 2, pixCenter);
        double xShift = xRange / (double)numberOfLines;
        double zShift = zRange / (double)numberOfLines;
        double yRangeAlt = 0.0;
        if (this.MP.view3D.needAltXZGrid()) {
            yRangeAlt = yRange;
        }
        Pix pixToDraw = new Pix(2, 0);
        for (int i = 0; i <= numberOfLines; ++i) {
            this.MP.setColor(Color.GRAY);
            double[] arr = new double[6];
            arr[0] = xRange;
            arr[1] = yRangeAlt;
            arr[2] = zShift * (double)i;
            arr[4] = yRangeAlt;
            arr[5] = zShift * (double)i;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            arr = new double[6];
            arr[0] = xShift * (double)i;
            arr[1] = yRangeAlt;
            arr[2] = zRange;
            arr[3] = xShift * (double)i;
            arr[4] = yRangeAlt;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            this.MP.setColor(orig);
            arr[0] = xRange + xShift;
            if (this.MP.view3D.needAltYZGrid()) {
                arr[0] = 0.0 - xShift;
            }
            arr[1] = yRangeAlt;
            arr[2] = zShift * (double)i;
            arr[4] = yRangeAlt;
            this.MP.viewer.rwc2pix(arr, 0, this.dim, 2, pixToDraw);
            this.MP.gc.drawString(this.df.format(zShift * (double)i), pixToDraw.x[0], pixToDraw.y[0]);
        }
        double[] arr = new double[6];
        arr[0] = xRange + xShift * 2.0;
        if (this.MP.view3D.needAltYZGrid()) {
            arr[0] = 0.0 - xShift * 3.0;
        }
        arr[1] = this.MP.view3D.needAltXZGrid() ? yRange : 0.0;
        arr[2] = zShift * (double)((numberOfLines + 1) / 2);
        this.MP.viewer.rwc2pix(arr, 0, this.dim, 2, pixToDraw);
        String zLabel = this.MP.getZAxisLabel().contentEquals("None (U)") ? "Z" : this.MP.getZAxisLabel();
        int textAdjustment = (zLabel.length() - 1) * this.MP.tw;
        this.MP.gc.drawString(zLabel, pixToDraw.x[0] - textAdjustment, pixToDraw.y[0]);
    }

    private void drawYZGrid(double[] centerPoints, double xRange, double yRange, double zRange, int numberOfLines, Line lin, Color orig) {
        Pix pixCenter = new Pix(1, 0);
        this.MP.viewer.rwc2pix(centerPoints, 0, 3, 2, pixCenter);
        double xShift = xRange / (double)numberOfLines;
        double yShift = yRange / (double)numberOfLines;
        double zShift = zRange / (double)numberOfLines;
        double zRangeAlt = 0.0;
        double xRangeAlt = 0.0;
        if (this.MP.view3D.needAltXYGrid()) {
            double d = zRangeAlt = this.MP.view3D.needAltXZGrid() ? 0.0 : zRange;
        }
        if (this.MP.view3D.needAltYZGrid()) {
            xRangeAlt = xRange;
        }
        Pix pixToDraw = new Pix(2, 0);
        for (int i = 0; i <= numberOfLines; ++i) {
            this.MP.setColor(Color.GRAY);
            double[] arr = new double[6];
            arr[0] = xRangeAlt;
            arr[1] = yShift * (double)i;
            arr[2] = zRange;
            arr[3] = xRangeAlt;
            arr[4] = yShift * (double)i;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            arr = new double[6];
            arr[0] = xRangeAlt;
            arr[1] = yRange;
            arr[2] = zShift * (double)i;
            arr[3] = xRangeAlt;
            arr[5] = zShift * (double)i;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            this.MP.setColor(orig);
            arr[0] = xRange + xShift;
            if (this.MP.view3D.needAltYZGrid()) {
                arr[0] = 0.0 - xShift;
            }
            arr[1] = yShift * (double)i;
            arr[2] = zRangeAlt;
            if (this.MP.view3D.needAltXYGrid() && this.MP.view3D.needAltXZGrid()) {
                arr[2] = zRange;
            }
            this.MP.viewer.rwc2pix(arr, 0, this.dim, 2, pixToDraw);
            this.MP.gc.drawString(this.df.format(yShift * (double)i), pixToDraw.x[0], pixToDraw.y[0]);
        }
        double[] arr = new double[6];
        arr[0] = xRange + xShift * 2.0;
        if (this.MP.view3D.needAltYZGrid()) {
            arr[0] = 0.0 - xShift * 2.0;
        }
        arr[1] = yShift * (double)((numberOfLines + 1) / 2);
        arr[2] = zRangeAlt;
        if (this.MP.view3D.needAltXYGrid() && this.MP.view3D.needAltXZGrid()) {
            arr[2] = zRange;
        }
        this.MP.viewer.rwc2pix(arr, 0, this.dim, 2, pixToDraw);
        String yLabel = this.MP.getYAxisLabel().contentEquals("None (U)") ? "Y" : this.MP.getYAxisLabel();
        int textAdjustment = (yLabel.length() - 1) * this.MP.tw;
        this.MP.gc.drawString(yLabel, pixToDraw.x[0] - textAdjustment, pixToDraw.y[0]);
    }

    private void drawXYGrid(double[] centerPoints, double xRange, double yRange, double zRange, int numberOfLines, Line lin, Color orig) {
        Pix pixCenter = new Pix(1, 0);
        this.MP.viewer.rwc2pix(centerPoints, 0, 3, 2, pixCenter);
        double xShift = xRange / (double)numberOfLines;
        double yShift = yRange / (double)numberOfLines;
        double zRangeAlt = 0.0;
        double labelShift = yShift * 2.0;
        if (this.MP.view3D.needAltXYGrid()) {
            zRangeAlt = zRange;
        }
        Pix pixToDraw = new Pix(2, 0);
        for (int i = 0; i <= numberOfLines; ++i) {
            this.MP.setColor(Color.GRAY);
            double[] arr = new double[6];
            arr[0] = xShift * (double)i;
            arr[1] = yRange;
            arr[2] = zRangeAlt;
            arr[5] = zRangeAlt;
            arr[3] = xShift * (double)i;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            arr = new double[6];
            arr[0] = xRange;
            arr[1] = yShift * (double)i;
            arr[2] = zRangeAlt;
            arr[4] = yShift * (double)i;
            arr[5] = zRangeAlt;
            this.MP.viewer.rwc2pix(arr, 0, 3, 2, pixToDraw);
            this.MP.drawPixels(pixToDraw.x, pixToDraw.y, 2, lin);
            this.MP.setColor(orig);
            arr[0] = xShift * (double)i;
            arr[1] = this.MP.view3D.needAltXZGrid() ? 0.0 - yShift * 1.5 : yRange + yShift;
            arr[2] = zRangeAlt;
            this.MP.viewer.rwc2pix(arr, 0, this.dim, 2, pixToDraw);
            this.MP.gc.drawString(this.df.format(xShift * (double)i), pixToDraw.x[0], pixToDraw.y[0]);
        }
        double[] arr = new double[6];
        arr[0] = xShift * (double)((numberOfLines + 1) / 2);
        arr[1] = this.MP.view3D.needAltXZGrid() ? 0.0 - labelShift : yRange + labelShift;
        arr[2] = zRangeAlt;
        this.MP.viewer.rwc2pix(arr, 0, this.dim, 1, pixToDraw);
        String xLabel = this.MP.getXAxisLabel().contentEquals("None (U)") ? "X" : this.MP.getXAxisLabel();
        this.MP.gc.drawString(xLabel, pixToDraw.x[0], pixToDraw.y[0]);
    }
}

