/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Message;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Feature;
import nxm.sys.libg.FeatureGroup;
import nxm.sys.libg.FeatureGroupMap;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.LayerT5;
import nxm.sys.libg.Line;
import nxm.sys.libg.RegionGroup;

public final class LayerDrawable
extends Layer {
    private final List<Drawable> drawables = new CopyOnWriteArrayList<Drawable>();
    private final List<Drawable> unmodifiableDrawables = Collections.unmodifiableList(this.drawables);
    private final List<LayerT5> layerT5Drawables = new CopyOnWriteArrayList<LayerT5>();
    private boolean listLayers = false;
    private LayerT5 nearestParentOfSelectedPoint;
    private int numVisiblePoints = 0;
    private boolean activeRelativeToPtTimeWindow = false;
    private double oldestRelativeTime = -1.0;
    private double newestRelativeTime = -1.0;
    private boolean layerWithDrawableData = false;
    private boolean showClusters;

    @Override
    public int getData(int mode) {
        if (this.drawables.isEmpty()) {
            return 0;
        }
        this.layerWithDrawableData = false;
        int stat = 3;
        for (Drawable d : this.drawables) {
            int tmpStat;
            if (d instanceof Feature) {
                stat = 0;
            }
            if (!(d instanceof Layer) || (tmpStat = ((Layer)d).getData(mode)) < 0) continue;
            if (tmpStat > 0) {
                this.layerWithDrawableData = true;
            }
            if (tmpStat >= stat) continue;
            stat = tmpStat;
        }
        return stat;
    }

    public boolean hasLayerWithDrawableData() {
        return this.layerWithDrawableData;
    }

    @Override
    public void findRange() {
        boolean first = true;
        for (Drawable d : this.drawables) {
            if (!d.isEnabled(0)) continue;
            d.findRange();
            if (first) {
                this.setRange(d);
            } else {
                this.addRange(d);
            }
            first = false;
        }
        if (first) {
            this.MP.getBaseLayer().findRange();
            this.setRange(this.MP.getBaseLayer());
        }
        if (this.x1 == this.x2) {
            double dx = Math.abs(this.MP.getBaseLayer().getX2() - this.MP.getBaseLayer().getX1());
            if (dx == 0.0) {
                dx = 1.0;
            }
            this.x1 -= dx / 100.0;
            this.x2 += dx / 100.0;
        }
        if (this.y1 == this.y2) {
            double dy = Math.abs(this.MP.getBaseLayer().getY2() - this.MP.getBaseLayer().getY1());
            if (dy == 0.0) {
                dy = 1.0;
            }
            this.y1 -= dy / 100.0;
            this.y2 += dy / 100.0;
        }
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    private void setRange(Drawable d) {
        this.x1 = d.getXMin();
        this.x2 = d.getXMax();
        this.y1 = d.getYMin();
        this.y2 = d.getYMax();
        this.z1 = d.getZMin();
        this.z2 = d.getZMax();
    }

    private void addRange(Drawable d) {
        this.x1 = Math.min(this.x1, d.getXMin());
        this.x2 = Math.max(this.x2, d.getXMax());
        this.y1 = Math.min(this.y1, d.getYMin());
        this.y2 = Math.max(this.y2, d.getYMax());
        this.z1 = Math.min(this.z1, d.getZMin());
        this.z2 = Math.max(this.z2, d.getZMax());
    }

    @Override
    public void draw(int flag) {
        this.clearNeedRefresh();
        if (this.activeRelativeToPtTimeWindow) {
            this.updateRelativeToPtTimeWindow();
        }
        ArrayList<LayerT5> layers = new ArrayList<LayerT5>();
        Line lin = null;
        int zoomLevel = RegionGroup.getZoomLevel(this.MP.getZoomLevelAsDecimal());
        boolean drawClusters = this.showClusters && this.MP.isLatLonView() && zoomLevel < 5;
        for (Drawable d : this.drawables) {
            if (drawClusters && d instanceof LayerT5) {
                lin = this.setupDrawableForRegionGroups((LayerT5)d, layers, lin);
                continue;
            }
            this.MP.doDraw(d, flag, 9);
        }
        if (drawClusters && layers.size() > 0) {
            RegionGroup.drawGrouping(lin, zoomLevel, layers, this.MP);
        }
        this.updateVisiblePoints();
    }

    private Line setupDrawableForRegionGroups(LayerT5 t5, List<LayerT5> layers, Line lin) {
        t5.clearNeedRefresh();
        if (t5.isVisible()) {
            if (lin == null) {
                lin = t5.line.copy();
            }
            this.MP.gc.setColor(lin.getColor());
            t5.isReset = false;
            t5.setClusterFontSizes();
            t5.setDrawingConfig(lin);
            layers.add(t5);
        }
        return lin;
    }

    private void updateVisiblePoints() {
        int tempTotalVisiblePnts = 0;
        if (this.showClusters) {
            this.numVisiblePoints = -1;
            return;
        }
        for (LayerT5 t5 : this.layerT5Drawables) {
            if (t5.isShowClusters()) {
                this.numVisiblePoints = -1;
                return;
            }
            tempTotalVisiblePnts += t5.getNumVisiblePoints();
        }
        this.numVisiblePoints = tempTotalVisiblePnts;
    }

    public int getNumVisiblePoints() {
        return this.numVisiblePoints;
    }

    @Override
    public boolean getNeedRefresh() {
        if (super.getNeedRefresh()) {
            return true;
        }
        for (Drawable d : this.drawables) {
            if (!d.getNeedRefresh()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getNeedsRescale() {
        if (super.getNeedsRescale()) {
            return true;
        }
        for (Drawable d : this.drawables) {
            if (!(d instanceof Layer) || !((Layer)d).getNeedsRescale()) continue;
            return true;
        }
        return false;
    }

    public void addDrawable(Drawable d) {
        this.drawables.add(d);
        if (d instanceof LayerT5) {
            this.layerT5Drawables.add((LayerT5)d);
            if (this.showClusters) {
                ((LayerT5)d).setFormRegions(true);
            }
        } else if (d instanceof Feature) {
            Feature drawableFeat = (Feature)d;
            this.layFeatures.add(drawableFeat.name, drawableFeat);
            if (drawableFeat.hasGroup()) {
                if (this.featureGroups == null) {
                    this.featureGroups = new FeatureGroupMap();
                }
                if (this.featureGroups.get(drawableFeat.getGroup()) != null) {
                    this.featureGroups.addFeatureToGroup(drawableFeat, (FeatureGroup)this.featureGroups.get(drawableFeat.getGroup()));
                } else {
                    this.featureGroups.addFeatureToGroup(drawableFeat, new FeatureGroup(drawableFeat));
                }
            }
        }
        if (d.getXMax() > this.x2 || d.getYMax() > this.y2 || d.getZMax() > this.z2) {
            if (!this.MP.getZoomKeep()) {
                this.MP.rescale(true);
            } else if (!this.MP.isMapView()) {
                this.MP.findRange();
            }
        }
        this.needRefresh = true;
    }

    public Drawable getDrawable(String name) {
        name = name.toUpperCase();
        for (Drawable d : this.drawables) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    public boolean removeDrawable(String name) {
        return name.equals("*") ? this.clearAllDrawables() : this.removeDrawable(this.getDrawable(name));
    }

    @Override
    public boolean clear() {
        for (Drawable drawable : this.drawables) {
            if (drawable instanceof Layer) {
                ((Layer)drawable).clear();
                continue;
            }
            if (!(drawable instanceof Feature)) continue;
            this.drawables.remove(drawable);
        }
        return true;
    }

    public boolean clearAllDrawables() {
        if (this.drawables.isEmpty()) {
            return false;
        }
        this.drawables.clear();
        this.layerT5Drawables.clear();
        this.layFeatures.clear();
        this.needRefresh = true;
        return true;
    }

    public boolean removeDrawable(Drawable d) {
        if (d == null) {
            return false;
        }
        boolean anyRemoved = this.drawables.remove(d);
        if (d instanceof Layer) {
            if (d instanceof LayerT5) {
                this.layerT5Drawables.remove((LayerT5)d);
            }
            Layer lay = (Layer)d;
            lay.close();
            if (lay.pf != null) {
                lay.pf.close();
            }
        } else if (d instanceof Feature) {
            this.layFeatures.remove(((Feature)d).name);
        }
        this.needRefresh = anyRemoved;
        return anyRemoved;
    }

    public boolean removeDrawable(int index) {
        Drawable removedDrawable = this.drawables.remove(index);
        return this.removeDrawable(removedDrawable);
    }

    public Table getDrawables(String type, boolean nameOnly) {
        int itype;
        String dtype = type.toUpperCase();
        if (dtype.startsWith("FEAT")) {
            itype = 1;
        } else if (dtype.startsWith("LAY")) {
            itype = 2;
        } else if (dtype.equals("ALL")) {
            itype = 3;
        } else {
            throw new IllegalArgumentException("Invalid type '" + type + "', expected FEATURES, LAYERS, or ALL.");
        }
        Table t = new Table();
        int featIndex = 0;
        int layIndex = 0;
        for (Drawable d : this.drawables) {
            String key = null;
            if ((itype & 1) != 0 && d instanceof Feature) {
                key = "FEAT_" + featIndex++;
            }
            if ((itype & 2) != 0 && d instanceof Layer) {
                key = "LAY_" + layIndex++;
            }
            if (key == null) continue;
            if (nameOnly) {
                t.put(key, (Object)d.getName());
                continue;
            }
            t.put(key, (Object)d);
        }
        return t;
    }

    @Deprecated
    public Drawable[] getDrawables() {
        return this.drawables.toArray(new Drawable[this.drawables.size()]);
    }

    List<Drawable> getDrawablesInstance() {
        return this.drawables;
    }

    public List<Drawable> getAllDrawables() {
        return this.unmodifiableDrawables;
    }

    public Layer getLayer(String name) {
        for (Drawable d : this.drawables) {
            if (!(d instanceof Layer) || !d.getName().equalsIgnoreCase(name)) continue;
            return (Layer)d;
        }
        return null;
    }

    public int countPointsInRange(double x1, double x2, double y1, double y2) {
        if (y1 == y2) {
            return 0;
        }
        if (x1 == x2) {
            return 0;
        }
        int tempNumPoints = 0;
        for (LayerT5 t5 : this.layerT5Drawables) {
            if (!t5.isVisible()) continue;
            tempNumPoints += t5.countPointsInRange(x1, x2, y1, y2);
        }
        return tempNumPoints;
    }

    public List<Drawable> getDrawablesAt(Position pos) {
        ArrayList<Drawable> matches = new ArrayList<Drawable>(8);
        for (Drawable d : this.drawables) {
            if (!this.MP.doDraw(d, 0, 0) || !d.isAtPosition(pos, -1, -1)) continue;
            matches.add(d);
        }
        return matches;
    }

    public boolean isListLayers() {
        return this.listLayers;
    }

    public void setListLayers(boolean listLayers) {
        this.listLayers = listLayers;
    }

    @Override
    public void processMouseMessage(Message msg, int type) {
        if (type != 1) {
            return;
        }
        if (this.nearestParentOfSelectedPoint != null) {
            this.nearestParentOfSelectedPoint.setSelectedIndex(-1);
            this.nearestParentOfSelectedPoint = null;
        }
        int indexInParent = -1;
        int minDist = Integer.MAX_VALUE;
        for (LayerT5 t5 : this.layerT5Drawables) {
            MouseEvent me;
            Point pos;
            int[] nearest;
            if (!t5.isVisible()) continue;
            Table quals = null;
            if (msg.quals instanceof Table) {
                quals = (Table)msg.quals;
            }
            if ((t5.getAutoSelEnable() & type) == 0 || quals == null) continue;
            t5.setSelectedIndex(-1);
            Object obj = quals.get("ORIG_MSG_DATA");
            if (!(obj instanceof MouseEvent) || (nearest = t5.getNearestPosition(pos = (me = (MouseEvent)obj).getPoint())) == null || nearest[0] >= minDist || nearest[1] < 0) continue;
            this.nearestParentOfSelectedPoint = t5;
            indexInParent = nearest[1];
            minDist = nearest[0];
        }
        if (this.nearestParentOfSelectedPoint != null && indexInParent > -1) {
            this.nearestParentOfSelectedPoint.setSelectedIndex(indexInParent);
            if (GraphicsUtil.isCtrlLMB(msg)) {
                this.nearestParentOfSelectedPoint.drawPopup(indexInParent);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        for (Drawable d : this.drawables) {
            if (!(d instanceof Layer)) continue;
            Layer lay = (Layer)d;
            lay.close();
            if (lay.pf == null) continue;
            lay.pf.close();
        }
    }

    public double getLatestPointTime() {
        double timeLatestPoint = 0.0;
        for (LayerT5 t5 : this.layerT5Drawables) {
            double thisLayerLatestTime;
            if (!t5.isVisible() || !((thisLayerLatestTime = t5.getLatestPointTime()) > timeLatestPoint)) continue;
            timeLatestPoint = thisLayerLatestTime;
        }
        return timeLatestPoint;
    }

    public void setTimeWindow(double timeOldest, int mode) {
        this.setTimeWindow(timeOldest, -1.0, mode);
    }

    public void setTimeWindow(double timeOldest, double timeNewest, int mode) {
        if (mode != 2) {
            for (LayerT5 t5 : this.layerT5Drawables) {
                t5.setTimeWindow(timeOldest, timeNewest, mode);
            }
            this.activeRelativeToPtTimeWindow = false;
            this.newestRelativeTime = -1.0;
            this.oldestRelativeTime = -1.0;
        } else {
            this.activeRelativeToPtTimeWindow = true;
            this.oldestRelativeTime = timeOldest;
            this.newestRelativeTime = timeNewest;
            this.updateRelativeToPtTimeWindow();
        }
    }

    private void updateRelativeToPtTimeWindow() {
        double referenceTime = this.getLatestPointTime();
        double oldest = this.oldestRelativeTime == -1.0 ? -1.0 : referenceTime - this.oldestRelativeTime;
        double newest = this.newestRelativeTime == -1.0 ? -1.0 : referenceTime - this.newestRelativeTime;
        for (LayerT5 t5 : this.layerT5Drawables) {
            t5.setTimeWindow(oldest, newest, 1);
        }
    }

    public void turnOffTimeWindow() {
        this.activeRelativeToPtTimeWindow = false;
        this.newestRelativeTime = -1.0;
        this.oldestRelativeTime = -1.0;
        for (LayerT5 t5 : this.layerT5Drawables) {
            t5.turnOffTimeWindow();
        }
    }

    @InternalUseOnly
    public void setShowClusters(boolean showClusters) {
        this.showClusters = showClusters;
        for (LayerT5 t5 : this.layerT5Drawables) {
            if (showClusters) {
                t5.setFormRegions(true);
            }
            t5.setShowClusters(showClusters);
        }
        this.refresh();
    }
}

