/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Table;
import nxm.sys.libg.Feature;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPoint;
import nxm.sys.prim.plot;

public class Layer1D
extends Layer {
    @InternalUseOnly
    protected float[] fbuf;
    protected boolean xIsTime;

    public Layer1D() {
        super("1D");
    }

    @Override
    protected void init(plot p, String layerName, int layerIndex, Layer oldLayer) {
        super.init(p, layerName, layerIndex, oldLayer);
        this.getLine().setColor(layerIndex);
        switch (p.getPlotTypeID()) {
            case 6: {
                this.getLine().setType(4);
                break;
            }
            case 5: {
                this.getLine().setType(2);
                break;
            }
            case 2: {
                this.warning("Cannot Raster 1D files, use file{fs=size} to set frame size.");
            }
        }
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        if (this.typeClass == 1) {
            int ts = (int)Math.min(pf.getSize(), 1.0E7);
            int fs = MA.getL("/FS", Math.min(ts, 32768));
            this.setFrame(fs);
            int lps = MA.getL("/LPS", 1);
            this.setSize(lps);
            this.setData(pf.getDataBuffer(fs * lps));
            this.isPaged = !this.realtime && fs * lps < ts;
            this.xIsTime = pf.getXUnits() == 1;
            this.setTimeAlign(MA.getState("/TIMEALIGN", false));
        } else if (this.typeClass == 2) {
            this.ncolors = MA.getL("NC", 32);
            this.cmap = MA.getSelectionIndex("CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", 6);
            this.colors = MColor.getColorMap(this.cmap, this.ncolors);
            this.setFrame(pf.getXFrame());
            int lps = MA.getL("/LPS", 1);
            if (lps == -1) {
                lps = (int)pf.getSize();
            }
            this.setSize(lps);
            this.setData(pf.getDataBuffer(lps));
            this.isPaged = false;
            this.setYUnits(0);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.ndata = this.data.size * this.data.ape;
        this.fbuf = this.data2fa(this.data, this.ndata, this.fbuf, 0, this.MP.mode);
    }

    @Override
    public void findRange() {
        int spa;
        if (this.frame == 0) {
            this.frame = this.ndata;
        }
        this.x1 = this.xstart;
        this.x2 = this.xstart + (double)(this.frame - 1) * this.xdelta;
        if (this.x1 > this.x2) {
            double t = this.x1;
            this.x1 = this.x2;
            this.x2 = t;
        }
        this.y1 = 0.0;
        this.y2 = 1.0;
        if (this.fbuf == null || this.fbuf.length == 0) {
            return;
        }
        int n = spa = this.pf != null ? this.pf.getMode() : 1;
        if (this.MP.mode == 6) {
            this.x1 = this.x2 = (double)this.fbuf[0];
            this.y1 = this.y2 = (double)this.fbuf[1];
            if (spa < 2) {
                spa = 2;
            }
            for (int ii = 2; ii < this.ndata * spa - 1 && ii < this.fbuf.length; ii += spa) {
                if ((double)this.fbuf[ii] > this.x2) {
                    this.x2 = this.fbuf[ii];
                }
                if ((double)this.fbuf[ii] < this.x1) {
                    this.x1 = this.fbuf[ii];
                }
                if ((double)this.fbuf[ii + 1] > this.y2) {
                    this.y2 = this.fbuf[ii + 1];
                }
                if (!((double)this.fbuf[ii + 1] < this.y1)) continue;
                this.y1 = this.fbuf[ii + 1];
            }
        } else {
            this.y1 = this.y2 = (double)this.fbuf[0];
            int elements = this.MP.mode == 5 ? this.ndata * spa : this.ndata;
            for (int i = 1; i < elements && i < this.fbuf.length; ++i) {
                if ((double)this.fbuf[i] > this.y2) {
                    this.y2 = this.fbuf[i];
                }
                if (!((double)this.fbuf[i] < this.y1)) continue;
                this.y1 = this.fbuf[i];
            }
        }
        this.autoScale4FindRange(this.y1, this.y2);
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    @Override
    public void findFullRange(PlotFile pf) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
        if (pf != null && !this.realtime) {
            this.fx1 = pf.getXStart();
            this.fx2 = this.typeClass == 2 ? this.fx1 + (double)(pf.getXFrame() - 1) * pf.getXDelta() : this.fx1 + (pf.getSize() - 1.0) * pf.getXDelta();
            if (this.fx1 > this.fx2) {
                double t = this.fx1;
                this.fx1 = this.fx2;
                this.fx2 = t;
            }
        }
    }

    @Override
    public void draw(int flag) {
        int i12;
        super.draw(flag);
        if (this.ndata <= 0) {
            return;
        }
        int i1 = 0;
        int i2 = this.ndata;
        double startPos = this.xstart;
        if (this.typeClass == 1 && this.pf instanceof DataFile && this.pf.getUnits() == 1 && this.isTimeAlign()) {
            double startTime = this.pf.getTimeAt(this.xstart);
            Layer lay = this.MP.getBaseLayer();
            if (lay != null && lay != this && lay.pf instanceof DataFile && this.pf instanceof DataFile && startTime > this.MP.rx1) {
                DataFile df = (DataFile)this.pf;
                startPos = ((DataFile)lay.pf).getIndex(startTime, 1, 3) * df.getXDelta();
            }
        }
        if (this.size > 0) {
            i2 = Math.min(this.frame, this.ndata);
        }
        if (this.MP.view < 9 && this.MP.mode != 6) {
            if (this.xstart < this.MP.rx1) {
                i1 = Math.max(0, (int)((this.MP.rx1 - this.xstart) / this.xdelta));
            }
            if (this.xstart + (double)this.ndata * this.xdelta > this.MP.rx2) {
                i2 = Math.min(i2, (int)((this.MP.rx2 - this.xstart) / this.xdelta) + 2);
            }
        }
        if ((i12 = i2 - i1) <= 0) {
            return;
        }
        Line lin = this.line.copy();
        int spa = this.data.spa;
        if (this.size <= 1) {
            if (this.MP.mode == 6) {
                this.MP.drawLine(this.fbuf, i1 * spa, spa, i12, lin);
            } else if (this.MP.mode == 5 && spa > 1) {
                Color color1 = lin.getColor();
                int s = 0;
                while (s < spa) {
                    this.MP.drawLine(this.fbuf, i1 * spa + s, spa, i12, lin, startPos, this.xdelta);
                    lin.setColor(++s < spa ? lin.getColor().darker() : color1);
                }
            } else {
                this.MP.drawLine(this.fbuf, i1, 1, i12, lin, startPos, this.xdelta);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                lin.setColor(this.colors[i % this.ncolors + 1]);
                if (this.MP.mode == 6) {
                    this.MP.drawLine(this.fbuf, (i1 + i * this.frame) * 2, 2, i12, lin);
                    continue;
                }
                this.MP.drawLine(this.fbuf, i1 + i * this.frame, 1, i12, lin, startPos - (double)i * this.xdelta * (double)this.frame, this.xdelta);
            }
        }
        if (this.feature != null) {
            this.feature.draw(flag);
        }
    }

    @Override
    @InternalUseOnly
    public int drawDataSegment(Line lin, double start, double end) {
        if (this.ndata <= 0 || this.MP == null) {
            return 0;
        }
        int i1 = Math.max(0, (int)((start - this.xstart) / this.xdelta + 0.5));
        int i2 = Math.min(this.ndata, (int)((end - this.xstart) / this.xdelta + 0.5));
        int npts = i2 - i1;
        this.MP.drawLine(this.fbuf, i1, 1, npts, lin, this.xstart, this.xdelta);
        return npts;
    }

    @Override
    public void setSize(int value) {
        super.setSize(value);
        if (this.size > 1) {
            this.setColorMap(-1, value);
        }
    }

    @Override
    public double getPosAtTime(double time) {
        if (this.pf instanceof DataFile) {
            DataFile df = (DataFile)this.pf;
            double delta = df.getDelta();
            double index = df.getIndexAt(time);
            return index * delta;
        }
        return super.getPosAtTime(time);
    }

    @Override
    public double getTime(int px, int py) {
        double yMaxVal;
        if (this.MP.xvy && (py < this.MP.iy1 || py > this.MP.iy2) || px < this.MP.ix1 || px > this.MP.ix2) {
            return 0.0;
        }
        boolean invert = this.MP.view == 8 || this.MP.view == 6 || this.MP.view == 4 || this.MP.view == 3;
        double delta = this.pf.getDelta();
        double xMinVal = this.MP.rx1 < this.MP.orx1 ? this.MP.orx1 : this.MP.rx1;
        double xMaxVal = this.MP.rx2 > this.MP.orx2 ? this.MP.orx2 : this.MP.rx2;
        double yMinVal = this.MP.ry1 < this.MP.ory1 ? this.MP.ory1 : this.MP.ry1;
        double d = yMaxVal = this.MP.ry2 > this.MP.ory2 ? this.MP.ory2 : this.MP.ry2;
        int pos = this.MP.xvy ? (invert ? py : this.MP.pos.h - py) : (invert ? this.MP.pos.w - px : px);
        double[] rwc = new double[2];
        MPoint pix = new MPoint();
        rwc[0] = xMinVal;
        rwc[1] = yMinVal;
        this.MP.viewer.rwc2pix(rwc, pix);
        int startPixel = this.MP.xvy ? (invert ? pix.y : this.MP.pos.h - pix.y) : (invert ? this.MP.pos.w - pix.x : pix.x);
        rwc[0] = xMaxVal;
        rwc[1] = yMaxVal;
        this.MP.viewer.rwc2pix(rwc, pix);
        int endPixel = this.MP.xvy ? (invert ? pix.y : this.MP.pos.h - pix.y) : (invert ? this.MP.pos.w - pix.x : pix.x);
        if (pos < startPixel || pos > endPixel) {
            return 0.0;
        }
        double viewableIndex = (xMaxVal - xMinVal) / delta + 1.0;
        double startIndex = this.realtime ? this.pf.seek() : (xMinVal - this.MP.orx1) / delta;
        double relMousePos = ((double)pos - (double)startPixel) / (double)(endPixel - startPixel);
        double index = startIndex + relMousePos * viewableIndex;
        return this.pf.getTimeAt(index);
    }

    @Override
    public double getNearestYValue(int i) {
        if (this.fbuf == null) {
            return 0.0;
        }
        return this.fbuf[i];
    }

    @Override
    public boolean clear() {
        this.ndata = 0;
        return true;
    }

    public boolean getXIsTime() {
        return this.xIsTime;
    }

    @Override
    public Feature getFeature() {
        if (this.feature != null) {
            return super.getFeature();
        }
        this.feature = super.getFeature();
        this.feature.setType(2);
        return this.feature;
    }
}

