/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import nxm.sys.lib.Parser;

public abstract class LargeJTable
extends JTable {
    private static final boolean DEBUG_SCROLL_BAR = false;
    protected static final int CELL_ACTION_SELECT = 1;
    protected static final int CELL_ACTION_ROW = 2;
    protected static final int CELL_ACTION_COL = 3;
    protected static final int CELL_ACTION_NONE = 4;
    protected static final int ROW_ACTION_SELECT = 1;
    protected static final int ROW_ACTION_NONE = 2;
    protected static final int COL_ACTION_SELECT = 1;
    protected static final int COL_ACTION_SORT = 2;
    protected static final int COL_ACTION_NONE = 3;
    protected static final String cellClickActionList = "Select,Row,Col,None";
    protected static final String rowClickActionList = "Select,None";
    protected static final String colClickActionList = "Select,Sort,None";
    protected static final String CELL_ACTION_DEFAULT_STR = "SELECT";
    protected static final String ROW_ACTION_DEFAULT_STR = "SELECT";
    protected static final String COL_ACTION_DEFAULT_STR = "SORT";
    protected int cellAction = 1;
    protected int rowAction = 1;
    protected int colAction = 2;
    private boolean autoSelect = true;
    private RowHeader rowHeader = new RowHeader(this);
    private LargeTableSelectionModel tableSelModel = new LargeTableSelectionModel(this);
    private long topRow = 0L;
    private VertScrollBar vertScrollBar = new VertScrollBar(this);

    public LargeJTable() {
        this(null);
    }

    public LargeJTable(TableModel tblModel) {
        this(tblModel, null);
    }

    public LargeJTable(TableModel tblModel, TableColumnModel colModel) {
        this(tblModel, colModel, null);
    }

    public LargeJTable(TableModel tblModel, TableColumnModel colModel, LargeListSelectionModel selModel) {
        super(tblModel, colModel, null);
        if (selModel == null) {
            this.setSelectionModel(this.tableSelModel.getRowSelModel());
        }
    }

    public boolean getAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean autoselect) {
        this.autoSelect = autoselect;
    }

    public void setCellClickAction(String str) {
        if (str == null) {
            str = "SELECT";
        } else if (str.equalsIgnoreCase("COLUMN")) {
            str = "COL";
        }
        this.cellAction = Parser.find(cellClickActionList, str, this.cellAction, 0, 1);
    }

    public void setRowClickAction(String str) {
        if (str == null) {
            str = "SELECT";
        }
        this.rowAction = Parser.find(rowClickActionList, str, this.rowAction, 0, 1);
    }

    public void setColClickAction(String str) {
        if (str == null) {
            str = COL_ACTION_DEFAULT_STR;
        }
        this.colAction = Parser.find(colClickActionList, str, this.colAction, 0, 1);
    }

    public String getCellClickAction() {
        return Parser.get(cellClickActionList, this.cellAction);
    }

    public final boolean isCellClickActionSelect() {
        return this.getCellSelectionAllowed();
    }

    public boolean isCellClickActionRow() {
        return this.cellAction == 2;
    }

    public boolean isCellClickActionCol() {
        return this.cellAction == 3;
    }

    public String getRowClickAction() {
        return Parser.get(rowClickActionList, this.rowAction);
    }

    public String getColClickAction() {
        return Parser.get(colClickActionList, this.colAction);
    }

    public void setCellSelectionAllowed(boolean allowed) {
        if (allowed) {
            this.setCellClickAction("SELECT");
        } else {
            this.setCellClickAction("NONE");
        }
        this.setAutoSelect(allowed);
    }

    public boolean getCellSelectionAllowed() {
        return this.cellAction == 1;
    }

    @Override
    public void setRowSelectionAllowed(boolean allowed) {
        if (allowed) {
            this.setRowClickAction("SELECT");
        } else {
            this.setRowClickAction("NONE");
        }
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this.rowAction == 1;
    }

    @Override
    public void setColumnSelectionAllowed(boolean allowed) {
        if (allowed) {
            this.setColClickAction("SELECT");
        } else {
            this.setColClickAction("NONE");
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.colAction == 1;
    }

    @Override
    protected ListSelectionModel createDefaultSelectionModel() {
        if (this.tableSelModel == null) {
            this.tableSelModel = new LargeTableSelectionModel(this);
        }
        return this.tableSelModel.getRowSelModel();
    }

    public void setTableSelectionModel(LargeTableSelectionModel selModel) {
        this.tableSelModel = selModel;
        this.setSelectionModel(selModel.getRowSelModel());
    }

    public LargeTableSelectionModel getTableSelectionModel() {
        return this.tableSelModel;
    }

    @Override
    public void resizeAndRepaint() {
        super.resizeAndRepaint();
        if (this.rowHeader != null) {
            this.rowHeader.repaint();
        }
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public int getModelRowIndex(int viewIndex) {
        return viewIndex;
    }

    public long getRealRowIndex(int modelIndex) {
        return (long)modelIndex + this.getTopRowIndex();
    }

    public int getModelRowIndex(long realIndex) {
        return (int)(realIndex - this.getTopRowIndex());
    }

    public int getViewRowIndex(int modelIndex) {
        return modelIndex;
    }

    public int getModelColIndex(int viewIndex) {
        return this.convertColumnIndexToModel(viewIndex);
    }

    public long getRealColIndex(int modelIndex) {
        return modelIndex;
    }

    public int getModelColIndex(long realIndex) {
        return (int)realIndex;
    }

    public int getViewColIndex(int viewIndex) {
        return this.convertColumnIndexToView(viewIndex);
    }

    public long getTopRowIndex() {
        return this.topRow;
    }

    public void setTopRowIndex(long index) {
        boolean GAP = false;
        long newTopRow = Math.max(0L, Math.min(this.getNumberOfRows() - (long)this.getNumberOfVisibleRows() + 0L, index));
        if (this.topRow != newTopRow) {
            this.topRow = newTopRow;
            this.revalidate();
            this.repaint();
            this.rowHeader.repaint();
            this.vertScrollBar.revalidate();
        }
    }

    protected abstract long getNumberOfRows();

    protected int getNumberOfVisibleRows() {
        Dimension viewSize = null;
        viewSize = this.getScrollPane() != null && this.getScrollPane().getViewport() != null ? this.getScrollPane().getViewport().getExtentSize() : this.getSize();
        return viewSize.height / this.getRowHeight();
    }

    public void showCell(long row, long column) {
        int col = this.getViewColIndex(this.getModelColIndex(column));
        this.setTopRowIndex(row);
        this.scrollRectToVisible(this.getCellRect(0, col, true));
    }

    protected String getRowID(long row) {
        if (row < 0L) {
            row = this.getNumberOfRows();
        }
        return String.valueOf(row);
    }

    protected String getColID(long col) {
        String str = null;
        if (col < 0L) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                String name = this.getColumnName(i);
                if (name.length() <= str.length()) continue;
                str = name;
            }
        } else {
            str = this.getColumnName(this.getModelColIndex(col));
        }
        return str;
    }

    public boolean isCellSelected(long row, long col) {
        return this.tableSelModel.isCellSelected(row, col);
    }

    public void setRowSelectionInterval(long start, long end) {
        this.tableSelModel.getRowSelModel().setSelectionInterval(start, end);
    }

    public void addRowSelectionInterval(long start, long end) {
        this.tableSelModel.getRowSelModel().addSelectionInterval(start, end);
    }

    public void changeSelection(long start, long end, boolean toggle, boolean extend) {
        this.tableSelModel.changeSelection(start, end, toggle, extend);
    }

    @Override
    public boolean editCellAt(int row, int col) {
        return super.editCellAt(row, col);
    }

    @Override
    public boolean editCellAt(int row, int col, EventObject e) {
        return super.editCellAt(row, col, e);
    }

    public boolean editCellAt(long row, long column) {
        this.showCell(row, column);
        return super.editCellAt(this.getModelRowIndex(row), this.getModelColIndex(column));
    }

    public boolean editCellAt(long row, long column, EventObject e) {
        this.showCell(row, column);
        return this.editCellAt(this.getModelRowIndex(row), this.getModelColIndex(column), e);
    }

    protected LargeListSelectionModel getLargeSelectionModel() {
        ListSelectionModel model = super.getSelectionModel();
        if (!(model instanceof LargeListSelectionModel)) {
            throw new RuntimeException(this.getClass().getName() + ": invalid selection model found.");
        }
        return (LargeListSelectionModel)model;
    }

    public void setRowLabelsVisible(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollPane scrollPane = LargeJTable.this.getScrollPane();
                if (scrollPane != null) {
                    if (visible) {
                        scrollPane.setRowHeaderView(LargeJTable.this.getRowHeader());
                    } else {
                        scrollPane.setRowHeaderView(null);
                    }
                }
            }
        });
    }

    public void setColLabelsVisible(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollPane scrollPane = LargeJTable.this.getScrollPane();
                if (scrollPane != null) {
                    if (visible) {
                        scrollPane.setColumnHeaderView(LargeJTable.this.getTableHeader());
                    } else {
                        scrollPane.setColumnHeaderView(null);
                    }
                }
            }
        });
    }

    protected JScrollPane getScrollPane() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            parent = parent.getParent();
        }
        return parent instanceof JScrollPane ? (JScrollPane)parent : null;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.rowHeader != null) {
            this.rowHeader.setRowHeight(rowHeight);
        }
    }

    protected RowHeader getRowHeader() {
        return this.rowHeader;
    }

    protected VertScrollBar getVertScrollBar() {
        return this.vertScrollBar;
    }

    protected int getTextWidth() {
        return this.getFontMetrics(this.getFont()).charWidth('0');
    }

    @Override
    public final void setRowSelectionInterval(int start, int end) {
        this.setRowSelectionInterval(this.getRealRowIndex(start), this.getRealColIndex(end));
    }

    @Override
    public final void addRowSelectionInterval(int start, int end) {
        this.addRowSelectionInterval(this.getRealRowIndex(start), this.getRealColIndex(end));
    }

    @Override
    public final void changeSelection(int start, int end, boolean toggle, boolean extend) {
        this.changeSelection(this.getRealRowIndex(start), this.getRealColIndex(end), toggle, extend);
    }

    @Override
    public boolean isCellSelected(int row, int col) {
        return this.tableSelModel.isCellSelected(this.getRealRowIndex(row), this.getRealColIndex(col));
    }

    @Override
    public final ListSelectionModel getSelectionModel() {
        return this.getLargeSelectionModel();
    }

    @Override
    public void clearSelection() {
        this.tableSelModel.clearSelection(false);
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (!(newModel instanceof LargeListSelectionModel)) {
            throw new IllegalArgumentException(this.getClass().getName() + ": invalid selection model found.");
        }
        super.setSelectionModel(newModel);
    }

    public LargeTableModel getLargeTableModel() {
        TableModel model = super.getModel();
        return model instanceof LargeTableModel ? (LargeTableModel)model : null;
    }

    protected long[] getRowsVisible(long top, long btm) {
        if (top < 0L) {
            top = 0L;
        }
        if (btm < 0L) {
            btm = this.getNumberOfRows();
        }
        long min = this.getTopRowIndex();
        long max = min + (long)this.getNumberOfVisibleRows();
        long[] range = null;
        if (top <= max && btm >= min) {
            range = new long[]{Math.max(top, min), Math.min(btm, max)};
        }
        return range;
    }

    protected int[] getModelRowsVisible(long top, long btm) {
        long[] range = this.getRowsVisible(top, btm);
        int[] rows = null;
        if (range != null) {
            rows = new int[]{this.getModelRowIndex(range[0]), this.getModelRowIndex(range[1])};
        }
        return rows;
    }

    abstract long getColumnIndex(String var1);

    public static class SelectionListener {
    }

    private static class VertScrollBarModel
    extends DefaultBoundedRangeModel {
        private static final int MIN_VALUE = 1;
        private static final int MAX_VALUE = 10001;
        private static final int UNIT_INC = 10000000;
        private static final int BLOCK_INC = 100000000;
        private static final double BLOCK_OVERLAP = 0.8;
        private static final int MIN_EXTENT = 0;
        private static final int MAX_EXTENT = 10000;
        private final VertScrollBar scrollBar;
        private final LargeJTable table;

        public VertScrollBarModel(VertScrollBar scrollBar, LargeJTable table) {
            super(1, 0, 1, 10001);
            this.scrollBar = scrollBar;
            this.table = table;
        }

        @Override
        public int getExtent() {
            int pos = this.getRelativePos(this.table.getNumberOfVisibleRows(), 0);
            return pos;
        }

        @Override
        public int getValue() {
            int pos = this.getRelativePos(this.table.getTopRowIndex(), 1);
            return pos;
        }

        @Override
        public void setMinimum(int min) {
        }

        @Override
        public void setMaximum(int max) {
        }

        @Override
        public void setExtent(int vis) {
        }

        @Override
        public void setValue(int val) {
            this.setRangeProperties(val, this.getExtent(), 1, 10001, this.getValueIsAdjusting());
        }

        @Override
        public void setRangeProperties(int val, int ext, int min, int max, boolean adj) {
            this.updateValue(val);
            super.setRangeProperties(this.getValue(), this.getExtent(), 1, 10001, adj);
            this.scrollBar.revalidate();
            this.scrollBar.repaint();
        }

        @Override
        public void setValueIsAdjusting(boolean flag) {
            super.setRangeProperties(this.getValue(), this.getExtent(), 1, 10001, flag);
            this.scrollBar.revalidate();
            this.scrollBar.repaint();
        }

        private void updateValue(int value) {
            double totalRows = this.table.getNumberOfRows();
            double topRow = this.table.getTopRowIndex();
            double size = (double)this.table.getNumberOfVisibleRows() * 0.8;
            double pos = ((double)value - 1.0) / 10000.0 * totalRows;
            double row = 0.0;
            boolean ignore = false;
            String type = null;
            if (value >= 100000000) {
                type = "BLOCK_INC";
                row = topRow + size;
            } else if (value >= 10000000) {
                type = "UNIT_INC";
                row = topRow + 1.0;
            } else if (value >= 1) {
                type = "TRACK";
                row = pos;
            } else if (value == 0) {
                type = "IGNORE";
                row = topRow;
                ignore = true;
            } else if (value >= -10000000) {
                type = "UNIT_DEC";
                row = topRow - 1.0;
            } else {
                type = "BLOCK_DEC";
                row = topRow - size;
            }
            row = Math.round(row);
            if (!ignore) {
                this.table.setTopRowIndex((long)row);
            }
        }

        private int getRelativePos(long row, int def) {
            double totalRows = this.table.getNumberOfRows();
            int pos = def;
            if (totalRows > 0.0) {
                pos = (int)((double)row / totalRows * 10001.0);
            }
            return pos;
        }
    }

    protected static class VertScrollBar
    extends JScrollBar {
        public VertScrollBar(LargeJTable table) {
            super(1);
            this.setModel(new VertScrollBarModel(this, table));
            this.setUnitIncrement(0);
            this.setBlockIncrement(0);
        }

        @Override
        public int getUnitIncrement() {
            return 10000000;
        }

        @Override
        public int getBlockIncrement() {
            return 100000000;
        }

        @Override
        public void setUnitIncrement(int inc) {
            super.setUnitIncrement(this.getUnitIncrement());
        }

        @Override
        public void setBlockIncrement(int inc) {
            super.setBlockIncrement(this.getBlockIncrement());
        }

        @Override
        public void setValue(int value) {
            super.setValue(value);
            this.revalidate();
            this.repaint();
        }
    }

    protected static class RowSelection
    implements Comparable<Object> {
        private long index;
        private BitSet set;

        public RowSelection(long index) {
            this(index, null);
        }

        public RowSelection(long index, BitSet set) {
            this.index = index;
            this.set = set;
        }

        public long getIndex() {
            return this.index;
        }

        public BitSet getColSet() {
            return this.set;
        }

        public void setIndex(long row) {
            this.index = row;
        }

        public void setColSet(BitSet cs) {
            this.set = cs;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.index ^ this.index >>> 32);
            result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowSelection other = (RowSelection)obj;
            if (this.index != other.index) {
                return false;
            }
            return !(this.set == null ? other.set != null : !this.set.equals(other.set));
        }

        @Override
        public int compareTo(Object obj) {
            long diff = 0L;
            diff = obj instanceof Number ? this.getIndex() - ((Number)obj).longValue() : this.getIndex() - ((RowSelection)obj).getIndex();
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, diff));
        }

        public String toString() {
            String str = null;
            str = this.getColSet() == null ? "SelectRow(row=" + this.getIndex() + ", cells=ALL)" : "SelectRow(row=" + this.getIndex() + ", cells=" + this.getColSet() + ")";
            return str;
        }
    }

    private static class TableColSelectionModel
    extends TableRowSelectionModel {
        public TableColSelectionModel(LargeTableSelectionModel tsm, LargeJTable table) {
            super(tsm, table);
        }

        @Override
        public void setSelectionInterval(long start, long end) {
            this.tsm.changeColSelection(start, end, -1, true);
        }

        @Override
        public void addSelectionInterval(long start, long end) {
            this.tsm.changeColSelection(start, end, -2, true);
        }

        @Override
        public void removeSelectionInterval(long start, long end) {
            this.tsm.changeColSelection(start, end, -3, true);
        }

        @Override
        public void clearSelection() {
            this.tsm.changeColSelection(-1L, -1L, 5, true);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.tsm.isColSelectionEmpty();
        }

        @Override
        public boolean isSelectedIndex(long index) {
            return this.tsm.isColSelected(index);
        }

        @Override
        public long getFirstSelectionIndex() {
            return this.tsm.getFirstColSelected();
        }

        @Override
        public long getLastSelectionIndex() {
            return this.tsm.getLastColSelected();
        }

        @Override
        public long getSelectionAnchor() {
            return this.tsm.getColAnchor();
        }

        @Override
        public long getSelectionLead() {
            return this.tsm.getColLead();
        }

        @Override
        public void setSelectionAnchor(long index) {
            this.tsm.setColAnchor(index);
        }

        @Override
        public void setSelectionLead(long index) {
            this.tsm.setColLead(index);
        }

        @Override
        public void insertIndexInterval(long index, long length, boolean before) {
        }

        @Override
        public void removeIndexInterval(long index0, long index1) {
        }

        @Override
        protected long getOffset() {
            return 0L;
        }
    }

    private static class TableRowSelectionModel
    extends DefaultListSelectionModel
    implements LargeListSelectionModel {
        protected final LargeTableSelectionModel tsm;
        protected final LargeJTable table;

        public TableRowSelectionModel(LargeTableSelectionModel tsm, LargeJTable table) {
            this.tsm = tsm;
            this.table = table;
            this.setSelectionMode(2);
        }

        @Override
        public void setSelectionInterval(long start, long end) {
            this.tsm.changeRowSelection(start, end, -1, true);
        }

        @Override
        public void addSelectionInterval(long start, long end) {
            this.tsm.changeRowSelection(start, end, -2, true);
        }

        @Override
        public void removeSelectionInterval(long start, long end) {
            this.tsm.changeRowSelection(start, end, -3, true);
        }

        @Override
        public void clearSelection() {
            this.tsm.changeRowSelection(-1L, -1L, 5, true);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.tsm.isRowSelectionEmpty();
        }

        @Override
        public boolean isSelectedIndex(long index) {
            return this.tsm.isRowSelected(index);
        }

        @Override
        public long getFirstSelectionIndex() {
            return this.tsm.getFirstRowSelected();
        }

        @Override
        public long getLastSelectionIndex() {
            return this.tsm.getLastRowSelected();
        }

        @Override
        public long getSelectionAnchor() {
            return this.tsm.getRowAnchor();
        }

        @Override
        public long getSelectionLead() {
            return this.tsm.getRowLead();
        }

        @Override
        public void setSelectionAnchor(long index) {
            this.tsm.setRowAnchor(index);
        }

        @Override
        public void setSelectionLead(long index) {
            this.tsm.setRowLead(index);
        }

        @Override
        public void insertIndexInterval(long index, long length, boolean before) {
        }

        @Override
        public void removeIndexInterval(long index0, long index1) {
        }

        protected long getOffset() {
            return this.table.getTopRowIndex();
        }

        @Override
        public final boolean isSelectedIndex(int i) {
            return this.isSelectedIndex(this.getOffset() + (long)i);
        }

        @Override
        public final int getAnchorSelectionIndex() {
            return (int)(this.getSelectionAnchor() - this.getOffset());
        }

        @Override
        public final int getLeadSelectionIndex() {
            return (int)(this.getSelectionLead() - this.getOffset());
        }

        @Override
        public final void setLeadSelectionIndex(int i) {
            this.setSelectionLead(this.getOffset() + (long)i);
        }

        @Override
        public final void setAnchorSelectionIndex(int i) {
            this.setSelectionAnchor(this.getOffset() + (long)i);
        }

        @Override
        public final void insertIndexInterval(int index, int length, boolean before) {
            this.insertIndexInterval(this.getOffset() + (long)index, (long)length, before);
        }

        @Override
        public final void setSelectionInterval(int index0, int index1) {
            this.setSelectionInterval(this.getOffset() + (long)index0, this.getOffset() + (long)index1);
        }

        @Override
        public final void addSelectionInterval(int index0, int index1) {
            this.addSelectionInterval((long)index0 + this.getOffset(), (long)index1 + this.getOffset());
        }

        @Override
        public final void removeIndexInterval(int index0, int index1) {
            this.removeIndexInterval((long)index0 + this.getOffset(), (long)index1 + this.getOffset());
        }

        @Override
        public final void removeSelectionInterval(int index0, int index1) {
            this.removeSelectionInterval((long)index0 + this.getOffset(), (long)index1 + this.getOffset());
        }

        @Override
        public final int getMaxSelectionIndex() {
            return (int)Math.min(Integer.MAX_VALUE, this.getLastSelectionIndex());
        }

        @Override
        public final int getMinSelectionIndex() {
            return (int)Math.min(0L, this.getFirstSelectionIndex());
        }

        public void fireSelectionChange(long first, long last, boolean isAdj) {
            int start = (int)(first - this.getOffset());
            int end = (int)(last - this.getOffset());
            this.fireValueChanged(start, end, isAdj);
        }
    }

    public static class LargeTableSelectionModel {
        private long rowAnchor = -1L;
        private long rowLead = -1L;
        private long colAnchor = -1L;
        private long colLead = -1L;
        private final Vector<RowSelection> rowSet = new Vector();
        private final BitSet colSet = new BitSet();
        private final TableRowSelectionModel rowSelModel;
        private final TableColSelectionModel colSelModel;
        private final LargeJTable table;
        protected static final int ANCHOR = 1;
        protected static final int CLICK = 2;
        protected static final int CTRL_CLICK = 3;
        protected static final int SHIFT_CLICK = 4;
        protected static final int DESELECT = 5;
        protected static final int SET = -1;
        protected static final int ADD = -2;
        protected static final int REMOVE = -3;
        public static final String selectionList = "Anchor,Click,ShiftClick,CtrlClick,Deselect";

        protected LargeTableSelectionModel(LargeJTable table) {
            this.table = table;
            this.rowSelModel = new TableRowSelectionModel(this, table);
            this.colSelModel = new TableColSelectionModel(this, table);
        }

        public LargeListSelectionModel getRowSelModel() {
            return this.rowSelModel;
        }

        public LargeListSelectionModel getColSelModel() {
            return this.colSelModel;
        }

        protected LargeJTable getTable() {
            return this.table;
        }

        protected LargeTableModel getLargeTableModel() {
            return this.getTable().getLargeTableModel();
        }

        public String toString() {
            StringBuilder str = new StringBuilder(128);
            str.append(this.getClass().getName());
            str.append(": SelectColumns(");
            str.append(this.colSet);
            str.append("),");
            for (RowSelection rowsel : this.rowSet) {
                str.append(" ");
                str.append(rowsel);
            }
            return str.toString();
        }

        protected RowSelection[] getCurrentSelection() {
            return this.rowSet.toArray(new RowSelection[0]);
        }

        public final boolean isRowSelected(long row) {
            return this.isCellSelected(row, -1L);
        }

        public final boolean isColSelected(long col) {
            return this.isCellSelected(-1L, col);
        }

        public boolean isCellSelected(long row, long col) {
            boolean selected = false;
            if (row < 0L) {
                selected = this.colSet.get((int)col);
            } else {
                RowSelection rowSelection = this.getRowSel(row);
                if (rowSelection != null) {
                    boolean bl = selected = rowSelection.getColSet() == null;
                    if (!selected && col >= 0L) {
                        selected = this.colSet.get((int)col) || rowSelection.getColSet().get((int)col);
                    }
                }
            }
            return selected;
        }

        protected void fireCellSelectionChange(long row, long col) {
            this.fireRowSelectionChange(row, row, col);
        }

        protected final void fireRowSelectionChange(long row) {
            this.fireRowSelectionChange(row, row, -1L);
        }

        protected final void fireRowSelectionChange(long start, long end) {
            this.fireRowSelectionChange(start, end, -1L);
        }

        protected void fireRowSelectionChange(long start, long end, long col) {
            this.rowSelModel.fireSelectionChange(start, end, false);
        }

        protected final void fireRowSelectionChange(long start, long end, BitSet set) {
            if (set == null) {
                this.fireRowSelectionChange(start, end);
            } else {
                int col = set.nextSetBit(0);
                while (col >= 0) {
                    this.fireRowSelectionChange(start, end, col);
                    col = set.nextSetBit(col + 1);
                }
            }
        }

        protected final void fireColSelectionChange(long col) {
            this.colSelModel.fireSelectionChange(col, col, false);
        }

        protected void fireColSelectionChange(long start, long end) {
            this.colSelModel.fireSelectionChange(start, end, false);
        }

        public final void clearSelection(boolean msg) {
            this.changeCellSelection(-1L, -1L, 5, msg);
        }

        protected void doClearSelection(boolean msg) {
            this.doClearRowSelection(msg);
            this.doClearColSelection(msg);
        }

        protected void doClearRowSelection(boolean msg) {
            if (!this.rowSet.isEmpty()) {
                long firstRow = this.getFirstRowSelected();
                long lastRow = this.getLastRowSelected();
                this.rowSet.clear();
                this.fireRowSelectionChange(firstRow, lastRow);
            }
        }

        protected void doClearColSelection(boolean msg) {
            if (!this.colSet.isEmpty()) {
                long firstCol = this.getFirstColSelected();
                long lastCol = this.getLastColSelected();
                this.colSet.clear();
                this.fireColSelectionChange(firstCol, lastCol);
            }
        }

        public final void changeSelection(long row, long col, boolean toggle, boolean extend) {
            int mode = this.rowSelModel.getSelectionMode();
            int type = 0;
            type = mode == 0 ? 2 : (mode == 1 ? (extend ? 4 : 2) : (toggle ? (extend ? 1 : 3) : (extend ? 4 : 2)));
            this.changeCellSelection(row, col, type, true);
        }

        protected void changeCellSelection(long row, long col, int type, boolean msg) {
            if (this.table.autoSelect || !msg) {
                switch (type) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.doClearSelection(msg);
                        this.doAddCellSelection(row, row, col, col, msg);
                        break;
                    }
                    case 4: {
                        this.doExtendCellSelection(row, col, msg);
                        break;
                    }
                    case 3: {
                        this.doToggleCellSelection(row, col, msg);
                    }
                }
            }
            if (type == 5) {
                this.doClearSelection(msg);
            }
            if (type != 4 && type != 5) {
                this.setRowAnchor(row);
                this.setRowLead(row);
                this.setColAnchor(col);
                this.setColLead(col);
            }
        }

        protected void changeRowSelection(long start, long end, int type, boolean msg) {
            switch (type) {
                case -1: {
                    this.doClearSelection(msg);
                }
                case -2: {
                    this.doAddRowSelection(start, end, null, msg);
                    break;
                }
                case -3: {
                    this.doRemoveRowSelection(start, end, null, msg);
                    break;
                }
                case 5: {
                    this.doClearSelection(msg);
                }
            }
        }

        protected void changeColSelection(long start, long end, int type, boolean msg) {
            switch (type) {
                case -1: {
                    this.doClearSelection(msg);
                }
                case -2: {
                    this.doAddColSelection(start, end, msg);
                    break;
                }
                case -3: {
                    this.doRemoveColSelection(start, end, msg);
                    break;
                }
                case 5: {
                    this.doClearSelection(msg);
                }
            }
        }

        protected void doExtendCellSelection(long row, long col, boolean msg) {
            if (this.getRowAnchor() < 0L) {
                this.setRowAnchor(row);
            }
            if (this.getColAnchor() < 0L) {
                this.setColAnchor(col);
            }
            long rowStart = Math.min(this.getRowAnchor(), row);
            long rowEnd = Math.max(this.getRowAnchor(), row);
            long colStart = Math.min(this.getColAnchor(), col);
            long colEnd = Math.max(this.getColAnchor(), col);
            this.doClearSelection(msg);
            this.doAddCellSelection(rowStart, rowEnd, colStart, colEnd, msg);
        }

        protected void doToggleCellSelection(long row, long col, boolean msg) {
            if (this.isCellSelected(row, col)) {
                this.doRemoveCellSelection(row, row, col, col, msg);
            } else {
                this.doAddCellSelection(row, row, col, col, msg);
            }
        }

        public void doAddCellSelection(long rowStart, long rowEnd, long colStart, long colEnd, boolean msg) {
            boolean ignore = false;
            if (rowStart < 0L) {
                ignore = this.table.colAction != 1;
            } else if (colStart < 0L) {
                ignore = this.table.rowAction != 1;
            } else if (this.table.cellAction == 2) {
                colStart = -1L;
                colEnd = -1L;
            } else if (this.table.cellAction == 3) {
                rowStart = -1L;
                rowEnd = -1L;
            } else if (this.table.cellAction != 1) {
                ignore = true;
            }
            if (!ignore) {
                BitSet set = null;
                if (colStart >= 0L && colEnd >= colStart) {
                    set = new BitSet((int)colEnd);
                    set.set((int)colStart, (int)colEnd + 1);
                }
                if (rowStart == -1L && rowEnd == -1L && this.table != null) {
                    rowStart = 0L;
                    rowEnd = this.table.getNumberOfRows() - 1L;
                }
                this.doAddRowSelection(rowStart, rowEnd, set, msg);
            }
        }

        protected void doAddRowSelection(long start, long end, BitSet set, boolean msg) {
            for (long row = start; row <= end; ++row) {
                RowSelection rowSel = this.getRowSel(row);
                if (rowSel == null) {
                    this.rowSet.add(this.getRowSelIndex(row), new RowSelection(row, set));
                    continue;
                }
                if (set == null || rowSel.getColSet() == null) {
                    rowSel.setColSet(null);
                    continue;
                }
                rowSel.getColSet().or(set);
            }
            this.fireRowSelectionChange(start, end, set);
        }

        public void doAddColSelection(long start, long end, boolean msg) {
            this.colSet.set((int)start, (int)end + 1);
            this.fireColSelectionChange(start, end);
        }

        public void doRemoveCellSelection(long rowStart, long rowEnd, long colStart, long colEnd, boolean msg) {
            if (colStart < 0L) {
                this.doRemoveRowSelection(rowStart, rowEnd, null, msg);
            } else {
                BitSet set = new BitSet();
                set.set((int)colStart, (int)colEnd + 1);
                this.doRemoveRowSelection(rowStart, rowEnd, set, msg);
            }
        }

        public void doRemoveRowSelection(long start, long end, BitSet set, boolean msg) {
            for (long row = start; row <= end; ++row) {
                RowSelection rowSel = this.getRowSel(row);
                if (rowSel == null) continue;
                if (set == null) {
                    this.rowSet.remove(this.getRowSelIndex(row));
                    continue;
                }
                if (rowSel.getColSet() == null) continue;
                if (set.equals(rowSel.getColSet())) {
                    this.rowSet.remove(this.getRowSelIndex(row));
                    continue;
                }
                rowSel.getColSet().andNot(set);
            }
            this.fireRowSelectionChange(start, end, set);
        }

        public void doRemoveColSelection(long start, long end, boolean msg) {
            this.colSet.clear((int)start, (int)end);
            this.fireColSelectionChange(start, end);
        }

        public long getFirstRowSelected() {
            return this.rowSet.isEmpty() ? -1L : this.rowSet.get(0).getIndex();
        }

        public long getFirstColSelected() {
            return this.colSet.nextSetBit(0);
        }

        public long getLastRowSelected() {
            return this.rowSet.isEmpty() ? -1L : this.rowSet.get(this.rowSet.size() - 1).getIndex();
        }

        public long getLastColSelected() {
            int last = -1;
            if (!this.colSet.isEmpty()) {
                int i = this.colSet.nextSetBit(0);
                while (i >= 0) {
                    last = i;
                    i = this.colSet.nextSetBit(i + 1);
                }
            }
            return last;
        }

        public boolean isRowSelectionEmpty() {
            return this.rowSet.isEmpty();
        }

        public boolean isColSelectionEmpty() {
            return this.colSet.isEmpty();
        }

        private RowSelection getRowSel(long row) {
            int index = this.getRowSelIndex(row);
            RowSelection rowSel = null;
            if (index < this.rowSet.size() && (rowSel = this.rowSet.get(index)).getIndex() != row) {
                rowSel = null;
            }
            return rowSel;
        }

        private int getRowSelIndex(long row) {
            int index = 0;
            if (this.rowSet.size() > 0 && row >= 0L && (index = Collections.binarySearch(this.rowSet, row)) < 0) {
                index = -index - 1;
            }
            return index;
        }

        private final void setAnchor(long row, long col) {
            this.setRowAnchor(row);
            this.setColAnchor(col);
        }

        private final void setLead(long row, long col) {
            this.setRowLead(row);
            this.setColLead(col);
        }

        public long getRowAnchor() {
            return this.rowAnchor;
        }

        public long getRowLead() {
            return this.rowLead;
        }

        public long getColAnchor() {
            return this.colAnchor;
        }

        public long getColLead() {
            return this.colLead;
        }

        public void setRowAnchor(long index) {
            this.rowAnchor = index;
        }

        public void setRowLead(long index) {
            this.rowLead = index;
        }

        public void setColAnchor(long index) {
            this.colAnchor = index;
        }

        public void setColLead(long index) {
            this.colLead = index;
        }
    }

    public static class RowHeader
    extends JTable {
        private final LargeJTable table;
        private long lastRow = -1L;
        private int cellWidth = -1;

        private RowHeader(LargeJTable table) {
            this.table = table;
            RowHeaderModel model = new RowHeaderModel(table, this);
            this.setModel(model);
            this.setSelectionModel(table.getSelectionModel());
            this.setDefaultRenderer(String.class, model);
        }

        @Override
        public boolean isRowSelected(int row) {
            return this.table.isRowSelected(row);
        }

        @Override
        public int getRowHeight(int row) {
            return this.table.getRowHeight(row);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(this.getCellWidth(true), this.table.getHeight());
        }

        @Override
        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            this.table.changeSelection(row, -1, toggle, extend);
        }

        @Override
        public void processMouseEvent(MouseEvent me) {
            if (me.getButton() == 3) {
                this.table.clearSelection();
            }
            super.processMouseEvent(me);
        }

        @Override
        public void processKeyEvent(KeyEvent ke) {
            this.table.processKeyEvent(ke);
        }

        private int getCellWidth(boolean update) {
            if (update || this.cellWidth < 0) {
                int PAD = 2;
                int charWidth = this.table.getTextWidth();
                int strLength = this.table.getRowID(this.table.getNumberOfRows() - 1L).length() + 2;
                int newWidth = strLength * charWidth;
                if (newWidth != this.cellWidth) {
                    this.table.getLargeTableModel().fireStructureChanged();
                    this.cellWidth = newWidth;
                }
            }
            return this.cellWidth;
        }

        public RowHeaderModel getRowHeaderModel() {
            return (RowHeaderModel)this.getModel();
        }

        protected static class RowHeaderModel
        extends AbstractTableModel
        implements TableCellRenderer,
        TableModelListener {
            private final RowHeader rowHeader;
            private final LargeJTable table;

            public RowHeaderModel(LargeJTable table, RowHeader header) {
                this.table = table;
                this.rowHeader = header;
            }

            @Override
            public void fireTableRowsUpdated(int top, int btm) {
                super.fireTableRowsUpdated(top, btm);
            }

            @Override
            public void fireTableRowsInserted(int top, int btm) {
                super.fireTableRowsInserted(top, btm);
            }

            @Override
            public void fireTableRowsDeleted(int top, int btm) {
                super.fireTableRowsDeleted(top, btm);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return this.table.getRowCount();
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return String.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return this.table.getRowID(this.table.getRealRowIndex(row));
            }

            @Override
            public void tableChanged(TableModelEvent evt) {
                this.fireTableChanged(evt);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object val, boolean selected, boolean focus, int row, int col) {
                TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
                int height = this.table.getRowHeight(row);
                int width = this.rowHeader.getCellWidth(false);
                Component comp = renderer.getTableCellRendererComponent(table, val, selected, focus, row, col);
                ((JComponent)comp).setPreferredSize(new Dimension(width, height));
                return comp;
            }
        }
    }

    public static interface LargeTableCellRenderer
    extends TableCellRenderer {
        public Component getTableCellRendererComponent(LargeJTable var1, Object var2, boolean var3, boolean var4, long var5, long var7);
    }

    public static interface LargeTableCellEditor
    extends TableCellEditor {
        public Component getTableCellEditorComponent(LargeJTable var1, Object var2, boolean var3, long var4, long var6);
    }

    public static class LargeListSelectionEvent
    extends ListSelectionEvent {
        private final long firstRow;
        private final long lastRow;

        public LargeListSelectionEvent(Object source, long firstRow, long lastRow, boolean isAdjusting) {
            super(source, (int)Math.min(Integer.MAX_VALUE, firstRow), (int)Math.min(Integer.MAX_VALUE, lastRow), isAdjusting);
            this.firstRow = firstRow;
            this.lastRow = lastRow;
        }

        public long getFirstRow() {
            return this.firstRow;
        }

        public long getLastRow() {
            return this.lastRow;
        }

        @Override
        public int getFirstIndex() {
            return super.getFirstIndex();
        }

        @Override
        public int getLastIndex() {
            return super.getLastIndex();
        }
    }

    public static interface LargeListSelectionModel
    extends ListSelectionModel {
        public void setSelectionInterval(long var1, long var3);

        public void addSelectionInterval(long var1, long var3);

        public void removeSelectionInterval(long var1, long var3);

        public long getFirstSelectionIndex();

        public long getLastSelectionIndex();

        public boolean isSelectedIndex(long var1);

        public long getSelectionAnchor();

        public void setSelectionAnchor(long var1);

        public long getSelectionLead();

        public void setSelectionLead(long var1);

        public void insertIndexInterval(long var1, long var3, boolean var5);

        public void removeIndexInterval(long var1, long var3);
    }

    public static interface LargeTableModel
    extends TableModel {
        public boolean isCellEditable(long var1, long var3);

        public Object getValueAt(long var1, long var3);

        public void setValueAt(Object var1, long var2, long var4);

        public void fireNeedsRedraw(long var1, long var3);

        public void fireRowsInserted(long var1, long var3);

        public void fireRowsDeleted(long var1, long var3);

        public void fireStructureChanged();
    }
}

