/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.ImageFile;
import nxm.sys.lib.Message;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.MColor;
import nxm.sys.libg.Theme;

public final class GraphicsUtil {
    private static final ClipboardManager CLIPBOARD_OWNER = new ClipboardManager();

    private GraphicsUtil() {
    }

    public static boolean checkIfNeedLegacyPaint(Object clazz) {
        if (Theme.getOption(8192)) {
            try {
                Class<?> implementingClassPaintComponent = clazz.getClass().getMethod("paintComponent", Graphics.class).getDeclaringClass();
                Class<?> implementingClassPaint = clazz.getClass().getMethod("paint", new Class[0]).getDeclaringClass();
                return !implementingClassPaint.equals(implementingClassPaintComponent) && implementingClassPaintComponent.isAssignableFrom(implementingClassPaint);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return false;
            }
        }
        return false;
    }

    static Toolkit getDefaultToolkit() {
        try {
            return Toolkit.getDefaultToolkit();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void invokeLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void invokeAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Shell.printStackTrace("Interrupted", e);
            }
        }
    }

    public static void beep() {
        Shell.beep();
    }

    public static boolean toSystemClipboard(String str) {
        return GraphicsUtil.toClipboard(str, GraphicsUtil.getDefaultToolkit().getSystemClipboard());
    }

    public static boolean toSystemSelection(String str) {
        return GraphicsUtil.toClipboard(str, GraphicsUtil.getDefaultToolkit().getSystemSelection());
    }

    public static String fromSystemClipboard() {
        return GraphicsUtil.fromClipboard(GraphicsUtil.getDefaultToolkit().getSystemClipboard());
    }

    public static String fromSystemSelection() {
        return GraphicsUtil.fromClipboard(GraphicsUtil.getDefaultToolkit().getSystemSelection());
    }

    private static boolean toClipboard(String str, Clipboard clipboard) {
        boolean status = false;
        try {
            if (clipboard != null) {
                clipboard.setContents(new StringSelection(str), CLIPBOARD_OWNER);
                status = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return status;
    }

    private static String fromClipboard(Clipboard clipboard) {
        String str = null;
        try {
            Transferable xfer;
            if (clipboard != null && (xfer = clipboard.getContents(null)) != null && xfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                str = (String)xfer.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return str;
    }

    public static final Object getThreadSafeInstance(Object obj, Class<?> api) {
        Class[] asArray = new Class[]{api};
        return GraphicsUtil.getThreadSafeInstance(obj, asArray);
    }

    public static final Object getThreadSafeInstance(Object obj, Class<?>[] api) {
        AwtInvocationProxy handler = new AwtInvocationProxy(obj);
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), api, (InvocationHandler)handler);
    }

    private static final Object invoke(Object obj, Method method, Object[] args) {
        Object value = null;
        try {
            if (EventQueue.isDispatchThread()) {
                value = method.invoke(obj, args);
            } else {
                boolean isVoid = method.getReturnType() == Void.TYPE;
                SwingTask task = new SwingTask(obj, method, args, isVoid);
                if (isVoid) {
                    EventQueue.invokeLater(task);
                } else {
                    EventQueue.invokeAndWait(task);
                    value = task.getValue();
                }
            }
        }
        catch (Throwable t) {
            throw GraphicsUtil.toRuntimeException(t);
        }
        return value;
    }

    private static final RuntimeException toRuntimeException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        RuntimeException exception = null;
        if (throwable instanceof RuntimeException) {
            exception = (RuntimeException)throwable;
        } else {
            String msg = throwable.getClass().getName() + ": " + throwable.getMessage();
            exception = new RuntimeException(msg, throwable);
            exception.setStackTrace(new StackTraceElement[0]);
        }
        return exception;
    }

    public static void createImageFile(DataFile df, Color[] colors, String format, ImageFile file, boolean cthru) {
        GraphicsUtil.createImageFile(df, colors, -1.7976931348623157E308, Double.MAX_VALUE, format, file, -1, -1, -1, false, "MAG", false);
    }

    public static void createImageFile(DataFile df, Color[] colors, double minVal, double maxVal, String format, ImageFile file, boolean cthru, int cnt, int brt, int alpha, boolean grayscale) {
        GraphicsUtil.createImageFile(df, colors, minVal, maxVal, format, file, cnt, brt, alpha, grayscale, "MAG", false);
    }

    public static void createImageFile(DataFile df, Color[] colors, double minVal, double maxVal, String format, ImageFile file, int cnt, int brt, int alpha, boolean grayscale, String cxMode, boolean terrain) {
        float min = Float.MAX_VALUE;
        float max = -min;
        double scaled = 0.0;
        int ncolors = colors.length - 1;
        String defFormat = "png";
        df.open();
        boolean positiveXDelta = df.getXDelta() > 0.0;
        boolean positiveYDelta = df.getYDelta() > 0.0;
        int width = df.getFrameSize();
        int height = (int)df.getNumberOfRows();
        int imageType = format.equalsIgnoreCase("JPG") ? 1 : 2;
        BufferedImage bi = new BufferedImage(width, height, imageType);
        int[] rgb = new int[height * width];
        float[] buff = new float[height * width];
        int index = 0;
        float adjVal = 0.0f;
        float scaleFactor = 1.0f;
        Data data = null;
        float value = 0.0f;
        if (cnt == -1) {
            cnt = 50;
        }
        if (brt == -1) {
            brt = 50;
        }
        float[] fbuf = new float[width];
        int h = 0;
        int rowNum = 1;
        while (h < height) {
            data = df.getData(h);
            if (df.getFormatMode() == 67) {
                GraphicsUtil.convertComplexData(data, cxMode);
            }
            Convert.bb2ja(data.buf, 0, data.type, fbuf, 0, (byte)70, width);
            for (int w = 0; w < width; ++w) {
                value = fbuf[w];
                if ((double)value < minVal) {
                    fbuf[w] = (float)minVal;
                } else if ((double)value > maxVal) {
                    fbuf[w] = (float)maxVal;
                }
                if (value < min) {
                    min = value;
                    continue;
                }
                if (!(value > max)) continue;
                max = value;
            }
            if (positiveXDelta && !positiveYDelta) {
                index = (rowNum - 1) * width;
            } else if (positiveXDelta && positiveYDelta) {
                index = width * height - width * rowNum;
            } else if (!positiveXDelta && positiveYDelta) {
                index = width * height - (rowNum - 1) * width;
            } else if (!positiveXDelta && !positiveYDelta) {
                index = (rowNum - 1) * width + width;
            }
            for (int r = 0; r < fbuf.length; ++r) {
                if (positiveXDelta) {
                    buff[index++] = fbuf[r];
                    continue;
                }
                buff[--index] = fbuf[r];
            }
            ++h;
            ++rowNum;
        }
        scaled = 0.0;
        if (terrain) {
            adjVal = Math.min(min, -max);
            scaleFactor = (float)ncolors / (-2.0f * adjVal);
        } else {
            adjVal = min;
            scaleFactor = (float)ncolors / (max - min);
        }
        for (int i = 0; i < buff.length; ++i) {
            double d;
            scaled = (buff[i] - adjVal) * scaleFactor;
            if (scaled < 0.0) {
                scaled = 0.0;
            }
            scaled += 1.0;
            if (d > (double)ncolors) {
                scaled = ncolors;
            }
            buff[i] = colors[(int)scaled].getRGB();
            rgb[i] = MColor.adjustColor((int)buff[i], cnt, brt, alpha, grayscale);
        }
        bi.setRGB(0, 0, width, height, rgb, 0, width);
        try {
            file.open(2);
            OutputStream os = file.io.getOutputStream();
            boolean boo = ImageIO.write((RenderedImage)bi, format, os);
            if (!boo) {
                Shell.warning("GraphicsUtil: Unable to create appropriate image writer from format given, using " + defFormat + ".");
                ImageIO.write((RenderedImage)bi, defFormat, os);
            }
            os.close();
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        df.close();
    }

    private static void convertComplexData(Data data, String cxmode) {
        if (cxmode == null) {
            DataOp.mag(data, data, -1, 18);
        } else if (cxmode.equalsIgnoreCase("PHASE")) {
            DataOp.phase(data, data, -1, 18);
        } else if (cxmode.equalsIgnoreCase("REAL")) {
            DataOp.real(data, data, -1, 18);
        } else if (cxmode.equalsIgnoreCase("IMAG")) {
            DataOp.imag(data, data, -1, 18);
        } else if (cxmode.equalsIgnoreCase("10LOG")) {
            DataOp.dblogb(data, data, -1, 18);
        } else if (cxmode.equalsIgnoreCase("20LOG")) {
            DataOp.dblogb2(data, data, -1, 18);
        } else {
            DataOp.mag(data, data, -1, 18);
        }
    }

    public static BufferedImage rotateImage(BufferedImage image, double angle) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage result = gc.createCompatibleImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public static int getNumScreens(boolean virtuals) {
        int numScreens = 0;
        if (!Theme.isHeadless()) {
            try {
                GraphicsDevice[] screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (virtuals) {
                    numScreens = screens.length;
                } else {
                    for (GraphicsDevice gd : screens) {
                        GraphicsConfiguration[] gconfs = gd.getConfigurations();
                        int maxx = 0;
                        int maxy = 0;
                        for (GraphicsConfiguration gconf : gconfs) {
                            Rectangle virtualBounds = gconf.getBounds();
                            if (virtualBounds.x != 0) {
                                maxx = virtualBounds.x;
                            }
                            if (virtualBounds.y == 0) continue;
                            maxy = virtualBounds.y;
                        }
                        if (maxx != 0 || maxy != 0) continue;
                        ++numScreens;
                    }
                }
            }
            catch (Exception e) {
                Shell.warning("Unable to determine the number of screens");
            }
        }
        return numScreens;
    }

    static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static void fitFrameToScreen(JFrame frame) {
        Dimension window = frame.getToolkit().getScreenSize();
        int x = frame.getSize().width > window.width ? window.width : frame.getSize().width;
        int y = frame.getSize().width > window.height ? window.height : frame.getSize().height;
        frame.setPreferredSize(new Dimension(x, y));
        frame.pack();
    }

    static boolean isCtrlLMB(Message msg) {
        Object temp;
        Table quals = null;
        if (msg.quals instanceof Table) {
            quals = (Table)msg.quals;
        }
        if (quals != null && (temp = quals.getO("ORIG_MSG_DATA")) != null && temp instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)temp;
            int onmask = 128;
            if ((me.getModifiersEx() & onmask) == onmask && me.getButton() == 1) {
                return true;
            }
        }
        return false;
    }

    @InternalUseOnly
    public static boolean isCtrl(Message msg) {
        Object temp;
        Table quals = null;
        if (msg.quals instanceof Table) {
            quals = (Table)msg.quals;
        }
        if (quals != null && (temp = quals.getO("ORIG_MSG_DATA")) != null && temp instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)temp;
            int onmask = 128;
            if ((me.getModifiersEx() & onmask) == onmask) {
                return true;
            }
        }
        return false;
    }

    private static final class SwingTask
    implements Runnable {
        private final Object obj;
        private final Method method;
        private final Object[] args;
        private final boolean showError;
        private Object value = null;
        private Throwable throwable = null;

        public SwingTask(Object obj, Method method, Object[] args, boolean showError) {
            this.obj = obj;
            this.method = method;
            this.args = args;
            this.showError = showError;
        }

        @Override
        public void run() {
            try {
                this.value = this.method.invoke(this.obj, this.args);
            }
            catch (Throwable t) {
                if (this.showError) {
                    Shell.getSharedMidasContext().printStackTrace("Error running " + this, t);
                }
                this.throwable = t;
            }
        }

        public Object getValue() throws Throwable {
            if (this.throwable != null) {
                throw this.throwable;
            }
            return this.value;
        }

        public String toString() {
            String argStr = this.args == null ? "" : StringUtil.join(this.args);
            String toCall = this.obj.getClass().getName() + "." + this.method.getName() + "(" + argStr + ")";
            return "GraphicsUtil.SwingTask: calling " + toCall + " in Swing/AWT event dispatch thread";
        }
    }

    private static final class AwtInvocationProxy
    implements InvocationHandler {
        private final Object obj;

        public AwtInvocationProxy(Object obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return GraphicsUtil.invoke(this.obj, method, args);
        }
    }

    private static class ClipboardManager
    implements ClipboardOwner {
        private ClipboardManager() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

