/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Position;
import nxm.sys.libg.IntersectingLine;
import nxm.sys.libm.Tolerance;

public class GeometricUtil {
    @InternalUseOnly
    public static int DEFAULT_MARGIN;
    private static int viewBoxMargin;

    @Deprecated
    public GeometricUtil() {
    }

    @InternalUseOnly
    public static LineSegmentGroup[] polygonRectangleIntersect(double[] polyXCords, double[] polyYCords, int npts, int off, Rectangle2D.Double rectangle) {
        int maxIndex;
        LineSegmentGroup[] intersectShapes = null;
        Rectangle2D.Double polygonBoundingBox = GeometricUtil.calculateBounds(polyXCords, polyYCords, npts, off);
        boolean potentialOverlap = polygonBoundingBox.intersects(rectangle);
        if (!potentialOverlap) {
            return intersectShapes;
        }
        if (npts == 1 && rectangle.contains(polyXCords[off], polyXCords[off])) {
            return new LineSegmentGroup[]{new LineSegmentGroup(new int[]{(int)polyXCords[off]}, new int[]{(int)polyYCords[off]}, IntersectingLine.IntersectLocation.ENCLOSED, IntersectingLine.IntersectLocation.ENCLOSED)};
        }
        ArrayList xPixels = new ArrayList();
        ArrayList yPixels = new ArrayList();
        ArrayList<IntersectingLine.IntersectLocation> entries = new ArrayList<IntersectingLine.IntersectLocation>();
        ArrayList<IntersectingLine.IntersectLocation> exits = new ArrayList<IntersectingLine.IntersectLocation>();
        IntersectingLine visibleSegment = null;
        Line2D.Double originalSegment = null;
        int lineSegmentGrp = 0;
        int lastIndex = maxIndex = Math.min(off + npts, Math.min(polyXCords.length, polyYCords.length)) - 1;
        boolean startNewSegmentGroup = true;
        int x2LastVisSegment = 0;
        int y2LastVisSegment = 0;
        boolean haveLastVisSegment = false;
        boolean lastPointWasEnclosed = false;
        Point2D.Double visibleBoxMinXY = new Point2D.Double(rectangle.getX(), rectangle.getY());
        Point2D.Double visibleBoxMaxXY = new Point2D.Double(rectangle.getX() + rectangle.width, rectangle.getY() + rectangle.getHeight());
        if (rectangle.contains(polyXCords[off], polyYCords[off])) {
            xPixels.add(new ArrayList());
            yPixels.add(new ArrayList());
            startNewSegmentGroup = false;
            lastPointWasEnclosed = true;
            if (Tolerance.equalsWithTolerance(polyXCords[off], polyXCords[lastIndex], 1.0E-15) && Tolerance.equalsWithTolerance(polyYCords[off], polyYCords[lastIndex], 1.0E-15)) {
                --lastIndex;
            }
            while (rectangle.contains(polyXCords[lastIndex], polyYCords[lastIndex]) && lastIndex > off) {
                ((ArrayList)xPixels.get(lineSegmentGrp)).add(0, (int)polyXCords[lastIndex]);
                ((ArrayList)yPixels.get(lineSegmentGrp)).add(0, (int)polyYCords[lastIndex]);
                --lastIndex;
            }
            if (lastIndex > off) {
                originalSegment = lastIndex == maxIndex ? new Line2D.Double(polyXCords[maxIndex], polyYCords[maxIndex], polyXCords[off], polyYCords[off]) : new Line2D.Double(polyXCords[lastIndex], polyYCords[lastIndex], polyXCords[lastIndex + 1], polyYCords[lastIndex + 1]);
                visibleSegment = GeometricUtil.adjustToVisibleLine(originalSegment, visibleBoxMinXY, visibleBoxMaxXY);
                ((ArrayList)xPixels.get(lineSegmentGrp)).add(0, (int)visibleSegment.line.x1);
                ((ArrayList)yPixels.get(lineSegmentGrp)).add(0, (int)visibleSegment.line.y1);
                entries.add(visibleSegment.locations[0]);
            }
        }
        for (int i = off; i < lastIndex; ++i) {
            originalSegment = new Line2D.Double(polyXCords[i], polyYCords[i], polyXCords[i + 1], polyYCords[i + 1]);
            visibleSegment = GeometricUtil.adjustToVisibleLine(originalSegment, visibleBoxMinXY, visibleBoxMaxXY);
            if (visibleSegment != null) {
                if (startNewSegmentGroup) {
                    xPixels.add(new ArrayList());
                    yPixels.add(new ArrayList());
                    entries.add(visibleSegment.locations[0]);
                    startNewSegmentGroup = false;
                }
                ((ArrayList)xPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.x1);
                ((ArrayList)yPixels.get(lineSegmentGrp)).add((int)visibleSegment.line.y1);
                x2LastVisSegment = (int)visibleSegment.line.x2;
                y2LastVisSegment = (int)visibleSegment.line.y2;
                haveLastVisSegment = true;
                boolean bl = lastPointWasEnclosed = visibleSegment.getLocations()[1] == IntersectingLine.IntersectLocation.ENCLOSED;
            }
            if (startNewSegmentGroup || !haveLastVisSegment || lastPointWasEnclosed) continue;
            ((ArrayList)xPixels.get(lineSegmentGrp)).add(x2LastVisSegment);
            ((ArrayList)yPixels.get(lineSegmentGrp)).add(y2LastVisSegment);
            exits.add(visibleSegment.locations[1]);
            ++lineSegmentGrp;
            startNewSegmentGroup = true;
        }
        LineSegmentGroup[] lineSegmentGroups = null;
        if (xPixels.size() > 0) {
            lineSegmentGroups = new LineSegmentGroup[xPixels.size()];
            for (int pixGrp = 0; pixGrp < xPixels.size(); ++pixGrp) {
                ArrayList xPixGrp = (ArrayList)xPixels.get(pixGrp);
                ArrayList yPixGrp = (ArrayList)yPixels.get(pixGrp);
                lineSegmentGroups[pixGrp] = new LineSegmentGroup(((ArrayList)xPixels.get(pixGrp)).size(), ((ArrayList)yPixels.get(pixGrp)).size());
                for (int i = 0; i < lineSegmentGroups[pixGrp].xcoords.length; ++i) {
                    lineSegmentGroups[pixGrp].xcoords[i] = (Integer)xPixGrp.get(i);
                    lineSegmentGroups[pixGrp].ycoords[i] = (Integer)yPixGrp.get(i);
                    lineSegmentGroups[pixGrp].entry = (IntersectingLine.IntersectLocation)((Object)entries.get(pixGrp));
                    lineSegmentGroups[pixGrp].exit = (IntersectingLine.IntersectLocation)((Object)exits.get(pixGrp));
                }
            }
        }
        return lineSegmentGroups;
    }

    @InternalUseOnly
    public static LineSegmentGroup[] allOrNone(double[] polyXCords, double[] polyYCords, int npts, int off, Rectangle2D.Double rectangle) {
        LineSegmentGroup[] lineSegmentGroups = null;
        if (GeometricUtil.insidePolygon(rectangle.getX(), rectangle.getY(), polyXCords, polyYCords, npts, off)) {
            lineSegmentGroups = new LineSegmentGroup[1];
            LineSegmentGroup lsg = new LineSegmentGroup(5, 5);
            int xMin = (int)(rectangle.getX() - (double)viewBoxMargin);
            int yMin = (int)(rectangle.getY() - (double)viewBoxMargin);
            int xMax = (int)(rectangle.getX() + rectangle.getWidth() + (double)viewBoxMargin);
            int yMax = (int)(rectangle.getY() + rectangle.getHeight() + (double)viewBoxMargin);
            lsg.xcoords[0] = xMin;
            lsg.ycoords[0] = yMin;
            lsg.xcoords[1] = xMin;
            lsg.ycoords[1] = yMax;
            lsg.xcoords[2] = xMax;
            lsg.ycoords[2] = yMax;
            lsg.xcoords[3] = xMax;
            lsg.ycoords[3] = yMin;
            lsg.xcoords[4] = xMin;
            lsg.ycoords[4] = yMin;
            lineSegmentGroups[0] = lsg;
        }
        return lineSegmentGroups;
    }

    static IntersectingLine adjustToVisibleLine(Line2D.Double line, Point2D visibleBoxMinXY, Point2D visibleBoxMaxXY) {
        double yAxisDistanceLinePt2ToBoxBoundary;
        double yAxisDistanceLinePt1ToBoxBoundary;
        double xAxisDistanceLinePt2ToBoxBoundary;
        double xAxisDistanceLinePt1ToBoxBoundary;
        Point2D.Double possibleIntersect;
        if (!(Double.isFinite(line.x1) && Double.isFinite(line.x2) && Double.isFinite(line.y1) && Double.isFinite(line.y2))) {
            return null;
        }
        IntersectingLine visibleLine = null;
        Point2D.Double firstIntersect = null;
        Point2D.Double secondIntersect = null;
        IntersectingLine.IntersectLocation firstIntersectLoc = null;
        IntersectingLine.IntersectLocation secondIntersectLoc = null;
        double visibleX1 = visibleBoxMinXY.getX();
        double visibleY1 = visibleBoxMinXY.getY();
        double visibleX2 = visibleBoxMaxXY.getX();
        double visibleY2 = visibleBoxMaxXY.getY();
        if (line.getX2() < visibleX1 && line.getX1() < visibleX1) {
            return visibleLine;
        }
        if (line.getX2() > visibleX2 && line.getX1() > visibleX2) {
            return visibleLine;
        }
        if (line.getY2() < visibleY1 && line.getY1() < visibleY1) {
            return visibleLine;
        }
        if (line.getY2() > visibleY2 && line.getY1() > visibleY2) {
            return visibleLine;
        }
        if (line.getX1() > visibleX1 && line.getX1() < visibleX2 && line.getY1() > visibleY1 && line.getY1() < visibleY2) {
            firstIntersect = new Point2D.Double(line.getX1(), line.getY1());
            firstIntersectLoc = IntersectingLine.IntersectLocation.ENCLOSED;
        }
        if (line.getX2() > visibleX1 && line.getX2() < visibleX2 && line.getY2() > visibleY1 && line.getY2() < visibleY2) {
            secondIntersect = new Point2D.Double(line.getX2(), line.getY2());
            secondIntersectLoc = IntersectingLine.IntersectLocation.ENCLOSED;
            if (firstIntersect != null) {
                return new IntersectingLine(firstIntersect, firstIntersectLoc, secondIntersect, secondIntersectLoc);
            }
        }
        if ((possibleIntersect = GeometricUtil.getIntersectionBD(line, xAxisDistanceLinePt1ToBoxBoundary = line.getX1() - visibleX1, xAxisDistanceLinePt2ToBoxBoundary = line.getX2() - visibleX1)) != null && possibleIntersect.y >= visibleBoxMinXY.getY() && possibleIntersect.y <= visibleBoxMaxXY.getY()) {
            if (secondIntersect != null || firstIntersect == null & xAxisDistanceLinePt1ToBoxBoundary >= 0.0) {
                firstIntersect = possibleIntersect;
                firstIntersectLoc = IntersectingLine.IntersectLocation.X1_BORDER;
            } else {
                secondIntersect = possibleIntersect;
                secondIntersectLoc = IntersectingLine.IntersectLocation.X1_BORDER;
            }
            if (firstIntersect != null && secondIntersect != null) {
                return new IntersectingLine(firstIntersect, firstIntersectLoc, secondIntersect, secondIntersectLoc);
            }
        }
        if ((possibleIntersect = GeometricUtil.getIntersectionBD(line, yAxisDistanceLinePt1ToBoxBoundary = line.getY1() - visibleY1, yAxisDistanceLinePt2ToBoxBoundary = line.getY2() - visibleY1)) != null && possibleIntersect.x >= visibleBoxMinXY.getX() && possibleIntersect.x <= visibleBoxMaxXY.getX()) {
            if (secondIntersect != null || firstIntersect == null & yAxisDistanceLinePt1ToBoxBoundary >= 0.0) {
                firstIntersect = possibleIntersect;
                firstIntersectLoc = IntersectingLine.IntersectLocation.Y1_BORDER;
            } else {
                secondIntersect = possibleIntersect;
                secondIntersectLoc = IntersectingLine.IntersectLocation.Y1_BORDER;
            }
            if (firstIntersect != null && secondIntersect != null) {
                return new IntersectingLine(firstIntersect, firstIntersectLoc, secondIntersect, secondIntersectLoc);
            }
        }
        if ((possibleIntersect = GeometricUtil.getIntersectionBD(line, xAxisDistanceLinePt1ToBoxBoundary = line.getX1() - visibleX2, xAxisDistanceLinePt2ToBoxBoundary = line.getX2() - visibleX2)) != null && possibleIntersect.y >= visibleBoxMinXY.getY() && possibleIntersect.y <= visibleBoxMaxXY.getY()) {
            if (secondIntersect != null || firstIntersect == null & xAxisDistanceLinePt1ToBoxBoundary <= 0.0) {
                firstIntersect = possibleIntersect;
                firstIntersectLoc = IntersectingLine.IntersectLocation.X2_BORDER;
            } else {
                secondIntersect = possibleIntersect;
                secondIntersectLoc = IntersectingLine.IntersectLocation.X2_BORDER;
            }
            if (firstIntersect != null && secondIntersect != null) {
                return new IntersectingLine(firstIntersect, firstIntersectLoc, secondIntersect, secondIntersectLoc);
            }
        }
        if ((possibleIntersect = GeometricUtil.getIntersectionBD(line, line.getY1() - visibleY2, line.getY2() - visibleY2)) != null && possibleIntersect.x >= visibleBoxMinXY.getX() && possibleIntersect.x <= visibleBoxMaxXY.getX()) {
            if (secondIntersect != null || firstIntersect == null & yAxisDistanceLinePt1ToBoxBoundary <= 0.0) {
                firstIntersect = possibleIntersect;
                firstIntersectLoc = IntersectingLine.IntersectLocation.Y2_BORDER;
            } else {
                secondIntersect = possibleIntersect;
                secondIntersectLoc = IntersectingLine.IntersectLocation.Y2_BORDER;
            }
            if (firstIntersect != null && secondIntersect != null) {
                return new IntersectingLine(firstIntersect, firstIntersectLoc, secondIntersect, secondIntersectLoc);
            }
        }
        return visibleLine;
    }

    private static Point2D.Double getIntersectionBD(Line2D.Double line, double axisDistanceLinePt1ToBoxBoundary, double axisDistanceLinePt2ToBoxBoundary) {
        if (axisDistanceLinePt1ToBoxBoundary * axisDistanceLinePt2ToBoxBoundary >= 0.0) {
            return null;
        }
        if (axisDistanceLinePt1ToBoxBoundary == axisDistanceLinePt2ToBoxBoundary) {
            return null;
        }
        BigDecimal lineX1BD = new BigDecimal(line.x1);
        BigDecimal lineY1BD = new BigDecimal(line.y1);
        BigDecimal p2MinusP1XBD = new BigDecimal(line.x2).subtract(lineX1BD);
        BigDecimal p2MinusP1YBD = new BigDecimal(line.y2).subtract(lineY1BD);
        MathContext mc = new MathContext(64, RoundingMode.HALF_UP);
        BigDecimal mutFactorBD = new BigDecimal(-axisDistanceLinePt1ToBoxBoundary).divide(new BigDecimal(axisDistanceLinePt2ToBoxBoundary - axisDistanceLinePt1ToBoxBoundary), mc);
        BigDecimal distIntersectFromP1XBD = mutFactorBD.multiply(p2MinusP1XBD);
        BigDecimal distIntersectFromP1YBD = mutFactorBD.multiply(p2MinusP1YBD);
        double intersectX = lineX1BD.add(distIntersectFromP1XBD).doubleValue();
        double intersectY = lineY1BD.add(distIntersectFromP1YBD).doubleValue();
        return new Point2D.Double(intersectX, intersectY);
    }

    @InternalUseOnly
    public static int[][] connectTheDots(int[] visibleX, int[] visibleY, IntersectingLine.IntersectLocation firstIntersectLoc, IntersectingLine.IntersectLocation secondIntersectLoc, Rectangle2D.Double viewBox, double[] fullPolygonX, double[] fullPolygonY, int npts, int off) {
        IntersectingLine.Corner testCorner;
        if (firstIntersectLoc == secondIntersectLoc && firstIntersectLoc == null) {
            return GeometricUtil.formVisibleShape(visibleX, visibleY, null, viewBox);
        }
        double[] xyPolygon = new double[npts * 2];
        int xIdx = 0;
        for (int i = 0; i < npts; ++i) {
            xyPolygon[xIdx] = fullPolygonX[i];
            xyPolygon[xIdx + 1] = fullPolygonY[i];
            xIdx += 2;
        }
        Position testPosition = new Position();
        double exitX = visibleX[visibleX.length - 1];
        double exitY = visibleY[visibleY.length - 1];
        if (viewBox.getMinX() != (double)visibleX[0] || viewBox.getMinY() != (double)visibleY[0] || viewBox.getMinX() != exitX || viewBox.getMinY() != exitY) {
            testPosition.setCar(viewBox.getMinX(), viewBox.getMinY(), 0.0);
            testCorner = IntersectingLine.Corner.X1_Y1_CORNER;
        } else if (viewBox.getMinX() != (double)visibleX[0] || viewBox.getMinY() != (double)visibleY[0] || viewBox.getMinX() != exitX || viewBox.getMinY() != exitY) {
            testPosition.setCar(viewBox.getMinX(), viewBox.getMinY(), 0.0);
            testCorner = IntersectingLine.Corner.X1_Y2_CORNER;
        } else {
            testPosition.setCar(viewBox.getMinX(), viewBox.getMinY(), 0.0);
            testCorner = IntersectingLine.Corner.X2_Y1_CORNER;
        }
        boolean inside = GeometricUtil.insidePolygon(testPosition.x, testPosition.y, fullPolygonX, fullPolygonY, npts, off);
        IntersectingLine.Corner[] cornersToAdd = firstIntersectLoc == secondIntersectLoc ? GeometricUtil.getCornersNeededSameIntersectLoc(secondIntersectLoc, visibleX[0], visibleY[0], visibleX[visibleX.length - 1], visibleY[visibleY.length - 1], inside) : GeometricUtil.getCornersNeededDiffIntersectLoc(firstIntersectLoc, secondIntersectLoc, testCorner, inside);
        int[][] visibleShape = GeometricUtil.formVisibleShape(visibleX, visibleY, cornersToAdd, viewBox);
        return visibleShape;
    }

    private static int[][] formVisibleShape(int[] visibleX, int[] visibleY, IntersectingLine.Corner[] cornersToAdd, Rectangle2D.Double viewBox) {
        int marginMinX = (int)viewBox.getMinX() - viewBoxMargin;
        int marginMinY = (int)viewBox.getMinY() - viewBoxMargin;
        int marginMaxX = (int)viewBox.getMaxX() + viewBoxMargin;
        int marginMaxY = (int)viewBox.getMaxY() + viewBoxMargin;
        int origLength = visibleX.length;
        int newLength = cornersToAdd == null ? origLength + 1 : origLength + cornersToAdd.length + 1;
        int[][] connectedShapePts = new int[][]{Arrays.copyOf(visibleX, newLength), Arrays.copyOf(visibleY, newLength)};
        connectedShapePts[0][newLength - 1] = visibleX[0];
        connectedShapePts[1][newLength - 1] = visibleY[0];
        if (cornersToAdd == null) {
            return connectedShapePts;
        }
        block6: for (int i = 0; i < cornersToAdd.length; ++i) {
            switch (cornersToAdd[i]) {
                case X1_Y1_CORNER: {
                    connectedShapePts[0][origLength + i] = marginMinX;
                    connectedShapePts[1][origLength + i] = marginMinY;
                    continue block6;
                }
                case X1_Y2_CORNER: {
                    connectedShapePts[0][origLength + i] = marginMinX;
                    connectedShapePts[1][origLength + i] = marginMaxY;
                    continue block6;
                }
                case X2_Y1_CORNER: {
                    connectedShapePts[0][origLength + i] = marginMaxX;
                    connectedShapePts[1][origLength + i] = marginMinY;
                    continue block6;
                }
                case X2_Y2_CORNER: {
                    connectedShapePts[0][origLength + i] = marginMaxX;
                    connectedShapePts[1][origLength + i] = marginMaxY;
                }
            }
        }
        return connectedShapePts;
    }

    static IntersectingLine.Corner[] getCornersNeededDiffIntersectLoc(IntersectingLine.IntersectLocation entry, IntersectingLine.IntersectLocation exit, IntersectingLine.Corner testCorner, boolean inside) {
        boolean x2BorderIntersect;
        boolean y1BorderIntersect = entry == IntersectingLine.IntersectLocation.Y1_BORDER || exit == IntersectingLine.IntersectLocation.Y1_BORDER;
        boolean y2BorderIntersect = entry == IntersectingLine.IntersectLocation.Y2_BORDER || exit == IntersectingLine.IntersectLocation.Y2_BORDER;
        boolean x1BorderIntersect = entry == IntersectingLine.IntersectLocation.X1_BORDER || exit == IntersectingLine.IntersectLocation.X1_BORDER;
        boolean bl = x2BorderIntersect = entry == IntersectingLine.IntersectLocation.X2_BORDER || exit == IntersectingLine.IntersectLocation.X2_BORDER;
        if (y1BorderIntersect && y2BorderIntersect) {
            if (inside) {
                if (exit == IntersectingLine.IntersectLocation.Y2_BORDER) {
                    return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
                }
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.Y2_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X2_Y1_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X2_Y2_CORNER};
        }
        if (x1BorderIntersect && x2BorderIntersect) {
            boolean needY1CornerValues;
            boolean bl2 = needY1CornerValues = inside && testCorner == IntersectingLine.Corner.X1_Y1_CORNER || !inside && testCorner == IntersectingLine.Corner.X1_Y2_CORNER;
            if (needY1CornerValues) {
                if (exit == IntersectingLine.IntersectLocation.X2_BORDER) {
                    return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
                }
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y1_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.X2_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER};
        }
        if (x1BorderIntersect && y1BorderIntersect) {
            boolean needX1Y1Corner;
            boolean bl3 = needX1Y1Corner = inside && testCorner == IntersectingLine.Corner.X1_Y1_CORNER || !inside && testCorner == IntersectingLine.Corner.X1_Y2_CORNER;
            if (needX1Y1Corner) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.Y1_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X2_Y1_CORNER};
        }
        if (x1BorderIntersect && y2BorderIntersect) {
            boolean needX1Y1Corner;
            boolean bl4 = needX1Y1Corner = inside && testCorner == IntersectingLine.Corner.X1_Y1_CORNER || !inside && testCorner == IntersectingLine.Corner.X1_Y2_CORNER;
            if (!needX1Y1Corner) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.Y2_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X2_Y2_CORNER};
        }
        if (x2BorderIntersect && y1BorderIntersect) {
            if (!inside) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.X2_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER};
        }
        if (x2BorderIntersect && y2BorderIntersect) {
            if (!inside) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER};
            }
            if (exit == IntersectingLine.IntersectLocation.X2_BORDER) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y1_CORNER};
        }
        throw new IllegalArgumentException("This method must be called with 2 distinct intersect locations");
    }

    static IntersectingLine.Corner[] getCornersNeededSameIntersectLoc(IntersectingLine.IntersectLocation entryExit, double entryX, double entryY, double exitX, double exitY, boolean inside) {
        if (!inside) {
            return null;
        }
        if (entryExit == IntersectingLine.IntersectLocation.X1_BORDER) {
            if (exitY > entryY) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
        }
        if (entryExit == IntersectingLine.IntersectLocation.X2_BORDER) {
            if (exitY < entryY) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y1_CORNER};
        }
        if (entryExit == IntersectingLine.IntersectLocation.Y1_BORDER) {
            if (exitX < entryX) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER};
        }
        if (entryExit == IntersectingLine.IntersectLocation.Y2_BORDER) {
            if (exitX > entryX) {
                return new IntersectingLine.Corner[]{IntersectingLine.Corner.X2_Y2_CORNER, IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
            }
            return new IntersectingLine.Corner[]{IntersectingLine.Corner.X1_Y2_CORNER, IntersectingLine.Corner.X1_Y1_CORNER, IntersectingLine.Corner.X2_Y1_CORNER, IntersectingLine.Corner.X1_Y2_CORNER};
        }
        throw new IllegalArgumentException("This method must be called with a valid intersect location");
    }

    /*
     * Unable to fully structure code
     */
    static boolean insidePolygon(double x, double y, double[] xpoints, double[] ypoints, int npoints, int off) {
        if (npoints <= 2) {
            return false;
        }
        hits = 0;
        lastx = xpoints[npoints + off - 1];
        lasty = ypoints[npoints + off - 1];
        for (i = off; i < npoints + off; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = xpoints[i];
                                cury = ypoints[i];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < cury || y >= lasty) break block8;
                        if (!(x < leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl34
                }
                if (y < lasty || y >= cury) break block8;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl34:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    @InternalUseOnly
    public static boolean boxIntersect(int[] box1, int[] box2) {
        return box1[0] <= box2[2] && box1[1] <= box2[3] && box1[2] >= box2[0] && box1[3] >= box2[1];
    }

    @InternalUseOnly
    public static boolean boxIntersect(double[] box1, double[] box2) {
        return !(box1[0] > box2[2] || box1[1] > box2[3] || box1[2] < box2[0] || box1[3] < box2[1]);
    }

    @InternalUseOnly
    public static boolean xIntersect(double[] box1, double[] xvals) {
        return !(box1[0] > xvals[1]) && !(box1[2] < xvals[0]);
    }

    static Rectangle2D.Double calculateBounds(double[] xpoints, double[] ypoints, int npoints, int offset) {
        double boundsMinX = Double.MAX_VALUE;
        double boundsMinY = Double.MAX_VALUE;
        double boundsMaxX = Double.MIN_VALUE;
        double boundsMaxY = Double.MIN_VALUE;
        for (int i = offset; i < npoints; ++i) {
            double x = xpoints[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            double y = ypoints[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        return new Rectangle2D.Double(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    @InternalUseOnly
    public static void setViewBoxMargin(int viewBoxMargin) {
        GeometricUtil.viewBoxMargin = viewBoxMargin;
    }

    static {
        viewBoxMargin = DEFAULT_MARGIN = 10;
    }

    @InternalUseOnly
    public static class LineSegmentGroup {
        int[] xcoords;
        int[] ycoords;
        IntersectingLine.IntersectLocation entry;
        IntersectingLine.IntersectLocation exit;

        LineSegmentGroup(int[] xcoords, int[] ycoords, IntersectingLine.IntersectLocation entry, IntersectingLine.IntersectLocation exit) {
            this.xcoords = xcoords;
            this.ycoords = ycoords;
            this.entry = entry;
            this.exit = exit;
        }

        LineSegmentGroup(int xcoordsSize, int ycoordsSize) {
            this.xcoords = new int[xcoordsSize];
            this.ycoords = new int[ycoordsSize];
        }

        @InternalUseOnly
        public int[] getXcoords() {
            return this.xcoords;
        }

        @InternalUseOnly
        public int[] getYcoords() {
            return this.ycoords;
        }

        IntersectingLine.IntersectLocation getEntry() {
            return this.entry;
        }

        IntersectingLine.IntersectLocation getExit() {
            return this.exit;
        }
    }
}

