/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JTextField;
import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.libg.BeanWidget;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GLabel;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidgetModSwap;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.HelpKeyListener;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MFrame;
import nxm.sys.libg.MJPanel;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;
import nxm.sys.libg.WidgetPanel;

public class GWidget
extends GWidgetModSwap
implements BeanWidget,
MessageHandler,
IDable {
    public static final int CHANGED_BY_USER_INPUT = 0;
    @Deprecated
    public static final int CHANGED_BY_CLICK = 0;
    public static final int CHANGED_BY_POLL = -1;
    public static final int CHANGED_BY_MSG = -2;
    public static final int DEF_ACTION_TYPE = -2;
    public int actionType = -2;
    public boolean userAction = false;
    @Deprecated
    public boolean doubleBuffer = false;
    public static String flagsList = "Permanent,Sticky,Fixed,NoEdit,NoMsg,InLine,VBox,VBoxMO";
    public static final int PERM = 1;
    public static final int STICKY = 2;
    public static final int FIX = 4;
    public static final int NOEDIT = 8;
    public static final int NOMSG = 16;
    public static final int INLINE = 32;
    public static final int VBOX = 64;
    public static final int VBOXMO = 128;
    public static final int TITLE = 0x10000000;
    public static final int MONITOR = 0x20000000;
    public static final int CONCAT = 0x40000000;
    public static final int HEADLESS = Integer.MIN_VALUE;
    public static final int flagsRequiringRefresh = -536870944;
    public static final int DEFBW = 4;
    public int zone;
    public int fixWidth;
    public int fixHeight;
    public int fixLineHeight;
    public int compression;
    public int tw;
    public int th;
    public int ta;
    public int bw;
    public double rx;
    public double ry;
    public boolean rMoved = false;
    public boolean pDetach = false;
    public GLabel pGroup;
    protected int pw;
    protected int ph;
    protected int titlew;
    protected int titleh;
    public String label;
    public String group;
    public String units;
    protected String monitorName;
    protected Midas M;
    private boolean show = true;
    public int flags = 0;
    public MBox bbox;
    public int callback;
    private Object from;
    private String tipText;
    public boolean isWidgetThatNeedsLegacyPaint;
    public Object pane;
    protected boolean enabled = true;
    protected final int SB_BORDER = 2;
    public static final Color DEF_DISABLED_COLOR = Color.gray;
    protected Color disabledColor = DEF_DISABLED_COLOR;
    public static final String DISABLE_LIST = "gvalue, glabel, gmenu, gprompt";
    private boolean haveLocalTheme = false;
    private boolean scrollNoMove = false;
    private volatile boolean inPaintComponent = false;
    String flagslist = null;

    public GWidget() {
    }

    public GWidget(String name, Object parent, String title, int flags, MessageHandler mh) {
        super(name, mh, parent);
        this.doSetup(parent, title, flags);
        this.isWidgetThatNeedsLegacyPaint = GraphicsUtil.checkIfNeedLegacyPaint(this);
    }

    @Override
    public void setupBean(String name, Object parent, String title, int flags, MessageHandler mh, Table argTable) {
        this.isPopup = parent instanceof MWindow;
        this.useSwing = Theme.getOption(4);
        this.useSwing &= Theme.getOption(this.isPopup ? 128 : 64);
        if (Theme.getOption(16)) {
            this.useSwing = true;
        }
        this.status = -2;
        this.hkl = new HelpKeyListener(this);
        if (this.useSwing) {
            MJPanel mpanel = new MJPanel();
            mpanel.setMWindow(this);
            this.panel = mpanel;
        } else {
            MPanel mpanel = new MPanel();
            mpanel.setMWindow(this);
            this.panel = mpanel;
        }
        this.title = name;
        this.name = name;
        this.mh = mh;
        this.doSetup(parent, title, flags);
        this.isWidgetThatNeedsLegacyPaint = GraphicsUtil.checkIfNeedLegacyPaint(this);
    }

    private void doSetup(Object parent, String title, int flags) {
        this.parent = parent;
        this.title = title;
        this.label = title.toUpperCase().trim();
        if (parent instanceof MWindow) {
            this.MW = (MWindow)parent;
        }
        if (parent instanceof GDialog && !this.label.endsWith(".CFG")) {
            flags |= 0x25;
        }
        this.flags = flags;
        this.setHeadless(this.is(Integer.MIN_VALUE));
        this.tipText = "";
    }

    public Theme getWidgetTheme() {
        return this.theme;
    }

    public void setWidgetTheme(Object themeObj) {
        if (themeObj == null) {
            return;
        }
        boolean doRefresh = true;
        if (!this.haveLocalTheme) {
            this.theme = (Theme)this.theme.copy();
            this.haveLocalTheme = true;
        }
        if (themeObj instanceof Theme) {
            this.theme = (Theme)themeObj;
        } else if (themeObj instanceof Table) {
            this.setWidgetThemeFromTable((Table)themeObj);
            doRefresh = false;
        } else if (themeObj instanceof String) {
            String themeName = (String)themeObj;
            if (!themeName.isEmpty()) {
                this.theme.setByName(themeName);
            } else {
                Shell.warning("Invalid widget theme name given " + themeObj);
                return;
            }
        }
        this.theme.adjustThemeColorVisibilityIssues(this.M, true);
        if (doRefresh) {
            this.refresh();
        }
    }

    public void setWidgetThemeFromTable(Table themeTable) {
        if (themeTable != null && themeTable.getSize() > 0) {
            Table.Iterator ti = themeTable.iterator();
            while (ti.getNext()) {
                String sval;
                Object val = ti.value;
                if (!(val instanceof String) || !(sval = (String)val).startsWith("_THEME_")) continue;
                String comp = sval.substring(7);
                try {
                    int rgb = this.theme.getColor(comp).getRGB();
                    themeTable.put(ti.key, rgb);
                }
                catch (Exception e) {
                    Shell.warning("Invalid Theme component name. Name must be in: " + Theme.getComponentList());
                }
            }
            this.theme.createTheme(themeTable);
        } else {
            Shell.warning("Invalid widget theme table given " + themeTable);
        }
        this.refresh();
    }

    @Override
    public void open() {
        super.open();
        if (this.fm == null) {
            this.tw = 10;
            this.th = 20;
            this.ta = 10;
        } else {
            this.tw = this.fm.stringWidth("0");
            this.th = this.fm.getHeight();
            this.ta = this.fm.getAscent();
        }
        this.setTitle(this.title);
        this.th = Math.min(this.th, this.tw * 2 + 2);
        this.ta = Math.min(this.ta, this.tw * 2 - 2);
        this.bw = this.is(32) ? 0 : 2;
        this.addListeners();
    }

    public void open(String name, int pw, int ph) {
        this.open();
        this.name = name;
        this.pw = pw;
        this.ph = ph;
        this.setup();
    }

    protected int stringWidth(String str) {
        if (this.fm == null) {
            return this.tw * str.length();
        }
        return this.fm.stringWidth(str);
    }

    @Override
    public void setup() {
        this.bw = this.is(32) ? 0 : 4;
        if (this.is(0x10000000)) {
            this.titleh = this.th + this.ta;
            this.bw = 4;
        } else {
            this.titleh = 0;
        }
        this.pos.w = this.bw + this.pw + this.bw;
        this.pos.h = this.bw + this.titleh + this.ph + this.bw;
        this.layout();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        String name = this.getClass().getSimpleName().toLowerCase();
        if (DISABLE_LIST.indexOf(name) < 0) {
            this.M.warning("Cannot disable widget of type " + this.getClass().getSimpleName() + ". Can only disable widgets in list [" + DISABLE_LIST + "]");
            return;
        }
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.refresh();
        }
    }

    public void toggleEnabled() {
        this.setEnabled(!this.enabled);
    }

    public void setDisabledColor(Color c) {
        if (c == null) {
            return;
        }
        this.disabledColor = c;
    }

    public void setDisabledColor(String color) {
        if (color == null) {
            return;
        }
        this.setDisabledColor(MColor.getColor(color));
    }

    @Override
    public void resize(int mode) {
        if (this.MW != null) {
            this.place(this.pos, this.MW.pos);
        }
        if (mode > 0) {
            this.setBounds(this.pos);
        }
        this.pw = this.pos.w - this.bw - this.bw;
        this.ph = this.pos.h - this.bw - this.bw - this.titleh;
    }

    protected void setTextClip(Graphics gc, Container panel2, String text, int startX) {
        int maxTextPos;
        int totalTextWidth = this.stringWidth(text) + startX;
        if (totalTextWidth > (maxTextPos = panel2.getLocation().x + panel2.getWidth())) {
            gc.setClip(0, 0, maxTextPos - 6, panel2.getHeight());
        }
    }

    @Override
    @Deprecated
    public void paint() {
        if (!this.inPaintComponent) {
            this.refresh();
        }
    }

    @Deprecated
    protected void setColor(Color color) {
        this.setColor(this.g, color);
    }

    protected void setColor(Graphics g, Color color) {
        g.setColor(this.enabled ? color : this.disabledColor);
    }

    public boolean hasLocalTheme() {
        return this.haveLocalTheme;
    }

    @Override
    @InternalUseOnly
    public void paintComponent(Graphics g) {
        if (this.isWidgetThatNeedsLegacyPaint) {
            this.inPaintComponent = true;
            this.paint();
            this.inPaintComponent = false;
        }
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(this.panel.getBackground());
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        this.setGraphics(g);
    }

    protected Graphics getOffscreen(Image offscreen, Rectangle clipBounds) {
        Graphics offgc = offscreen.getGraphics();
        offgc.setColor(this.panel.getBackground());
        offgc.fillRect(0, 0, clipBounds.width, clipBounds.height);
        offgc.setColor(this.panel.getForeground());
        offgc.translate(-clipBounds.x, -clipBounds.y);
        return offgc;
    }

    protected void shadowbox(Graphics g, int x, int y, int w, int h, int inlineMode, int normalMode) {
        int bf = this.is(32) ? inlineMode : normalMode;
        this.shadowbox(g, x, y, w, h, bf);
    }

    @Deprecated
    protected void drawDiamond(int ax, int ay, int aw, int am) {
        this.drawDiamond(this.g, ax, ay, aw, am);
    }

    protected void drawDiamond(Graphics g, int ax, int ay, int aw, int am) {
        if (aw <= 0) {
            aw = this.tw * 2 / 3;
        }
        this.shadowarrow(g, ax, ay, aw, 'b');
        if ((am & 1) != 0) {
            this.shadowarrow(g, ax, ay, aw, 'u');
        }
        if ((am & 2) != 0) {
            this.shadowarrow(g, ax, ay, aw, 'd');
        }
        if ((am & 4) != 0) {
            this.shadowarrow(g, ax, ay, aw, 'l');
        }
        if ((am & 8) != 0) {
            this.shadowarrow(g, ax, ay, aw, this instanceof GMenu ? (char)'m' : 'r');
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((this.eventFilter & 1) != 0) {
            return;
        }
        if (this.is(8) && e.getButton() == 1) {
            return;
        }
        this.userAction = true;
        super.mouseClicked(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if ((this.eventFilter & 2) != 0) {
            return;
        }
        if (this.is(8)) {
            return;
        }
        this.userAction = true;
        super.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((this.eventFilter & 2) != 0) {
            return;
        }
        if (this.is(8)) {
            return;
        }
        this.userAction = true;
        super.keyReleased(e);
    }

    public void configure() {
        if (this.title.equals("GMenu.cfg")) {
            System.out.println("Configure of configure menu not allowed");
            return;
        }
        String mtitle = this.name == null ? "GWidget.cfg" : this.name + ".cfg";
        new GMenu(this.parent, mtitle, this.flagsList(), this.flags, 1024, this);
    }

    @Override
    public void addTo(Object entry) {
        this.addTo(entry, true);
    }

    public void addTo(Object entry, boolean top) {
        if (top && entry instanceof GDialog && !this.label.endsWith(".CFG")) {
            ((GDialog)entry).addWidget(this);
        } else if (entry != null) {
            super.addTo(entry);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setFlags(String mask) {
        this.setFlags(Parser.mask(this.flagsList(), mask, this.flags));
    }

    public void setFlag(int mask, boolean value) {
        this.setFlags(value ? this.flags | mask : this.flags & ~mask);
    }

    public void setFlags(int flags) {
        int mask = flags ^ this.flags;
        this.flags = flags;
        if ((mask & 0xDFFFFFE0) != 0) {
            this.setup();
            this.refresh();
        }
    }

    public boolean getFlag(int mask) {
        return this.is(mask);
    }

    public String getFlags() {
        return Parser.mask2s(this.flagsList(), this.flags);
    }

    protected String flagsList() {
        if (this.flagslist == null) {
            this.flagslist = KeyObject.getKey(this, "flagsList").toString();
        }
        if (this.flagslist == null) {
            this.flagslist = flagsList;
        }
        return this.flagslist;
    }

    public void setGroup(String group2) {
        this.group = group2 == null || group2.length() == 0 ? null : group2.toUpperCase();
    }

    public String getGroup() {
        return this.group;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    public void setValue(String value) {
    }

    public Object getValue() {
        return null;
    }

    public void setAction(String value) {
        this.setActionType();
        this.setValue(value);
    }

    public void setActionType() {
        if (this.userAction) {
            this.actionType = 0;
            this.userAction = false;
        } else {
            this.actionType = -2;
        }
    }

    public void setActionType(int type) {
        if (type == 0 || type == -1 || type == -2) {
            this.actionType = type;
        } else {
            Shell.warning("Invalid action type = " + this.actionType);
        }
    }

    public int getActionType() {
        return this.actionType;
    }

    public String getActionTypeString() {
        return this.getActionTypeString(this.actionType);
    }

    public String getActionTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHANGED_BY_USER_INPUT";
            }
            case -2: {
                return "CHANGED_BY_MSG";
            }
            case -1: {
                return "CHANGED_BY_POLL";
            }
        }
        return null;
    }

    public String toString() {
        return "GWidget";
    }

    public String toList(String value, String list3) {
        String ucvalue = "," + value.toUpperCase() + ",";
        String uclist = "," + list3.toUpperCase() + ",";
        int i = uclist.indexOf(ucvalue);
        int lv = value.length();
        String s = this.title != null && this.title.length() > 0 ? this.title + "=[" : (this.label != null && this.label.length() > 0 ? this.label + "=[" : "[");
        s = list3.length() == 0 ? s + value : (i < 0 ? s + "<" + value + ">," + list3 : (i == 0 ? s + "<" + value + ">" + list3.substring(lv) : s + list3.substring(0, i) + "<" + value + ">" + list3.substring(i + lv)));
        s = this.units != null ? s + "] " + this.units : s + "]";
        return s;
    }

    public String getReadOut() {
        String l;
        String s = this.getClass().getName();
        int i = s.lastIndexOf(46);
        s = s.substring(i + 1);
        s = s + " " + this.label + "=" + this.getValueString();
        if (this.units != null) {
            s = s + " " + this.units;
        }
        if ((l = this.getLegend()) != null && !this.is(8)) {
            return s + " " + l;
        }
        return s;
    }

    private String setReadOut(String text) {
        return this.getReadOut() + " " + text;
    }

    public String getValueString() {
        if (this.getValue() == null) {
            return "";
        }
        return this.getValue().toString();
    }

    public String getLegend() {
        return null;
    }

    @Override
    public boolean setToolTipText(String text) {
        this.tipText = text;
        boolean swingComp = super.setToolTipText(text);
        if (!swingComp) {
            this.formatReadOut(1);
        }
        return swingComp;
    }

    @Override
    public String getToolTipText() {
        return this.tipText;
    }

    public void formatReadOut(int mode) {
        if (mode > 0) {
            this.setAltTitle(this.setReadOut(this.tipText));
        }
        if (mode < 0) {
            this.setAltTitle(null);
        }
    }

    @Deprecated
    public void setShow(int show) {
        this.setShow(show > 0);
    }

    public void setShow(boolean show) {
        if (show != this.show) {
            this.show = show;
            if (this.wp != null) {
                this.wp.layoutWidget(this);
            }
        }
    }

    public boolean isShow() {
        return this.show;
    }

    public void fixHeight(int value) {
        if (this.fixHeight == value) {
            return;
        }
        this.fixHeight = value;
        this.setup();
    }

    public void fixLineHeight(int value) {
        if (this.fixLineHeight == value) {
            return;
        }
        this.fixLineHeight = value;
        this.setup();
    }

    public void fixWidth(int value) {
        if (this.fixWidth == value) {
            return;
        }
        this.fixWidth = value;
        this.setup();
    }

    public void setCompression(int value) {
        if (this.compression == value) {
            return;
        }
        this.compression = value;
        this.setup();
    }

    public void setMonitor(String name) {
        if (name != null && name.length() > 0) {
            this.monitorName = name;
            this.flags |= 0x20000000;
        } else {
            this.flags &= 0xDFFFFFFF;
            this.monitorName = null;
        }
    }

    public WidgetPanel getGWidgetPanel() {
        if (this.wp instanceof WidgetPanel) {
            return (WidgetPanel)this.wp;
        }
        return null;
    }

    public void layout() {
        if (this.status == 1) {
            this.setBounds(this.pos);
        }
        if (this.wp != null) {
            this.wp.layoutWidget(this);
        }
        this.refresh();
    }

    public void setMidas(Midas midas) {
        this.M = midas;
    }

    public boolean poll() {
        return false;
    }

    protected boolean is(int mask) {
        if (!(this.enabled || mask != 16 && mask != 8)) {
            return true;
        }
        return (this.flags & mask) != 0;
    }

    @Override
    public int process(String name, int info, Object data) {
        if ("PAINT".equals(name)) {
            if (this.status == -2) {
                if (this.parent instanceof MFrame) {
                    this.panel.requestFocus();
                }
                this.status = 1;
            }
            this.paintComponent((Graphics)data);
        }
        if (this.status == -3) {
            return 1;
        }
        if (this.processEventMessage(name, info, data) > 0) {
            return 1;
        }
        switch (name) {
            default: {
                return -1;
            }
            case "REFRESH": {
                if ((this.eventFilter & 0x10) == 0) {
                    this.refresh();
                }
                return 1;
            }
            case "RESIZE": {
                if ((this.eventFilter & 0x10) == 0) {
                    this.resize(0);
                }
                return 1;
            }
            case "POINTER": {
                return 1;
            }
            case "BUTTON": {
                return 1;
            }
            case "DRAG": {
                return 1;
            }
            case "FOCUS": {
                return 1;
            }
            case "DRAGBOX": 
        }
        if (!this.is(4) && (this.eventFilter & 8) == 0 && !this.scrollNoMove) {
            this.pos.x += this.box.w;
            this.pos.y += this.box.h;
            this.setBounds(this.pos);
            this.rMoved = true;
            this.layout();
        } else {
            this.scrollNoMove = false;
        }
        this.button = 0;
        return 1;
    }

    protected int sendWidgetMessage(String name, int info, Object data) {
        return this.sendWidgetMessage(name, info, data, null);
    }

    protected int sendWidgetMessage(String name, int info, Object data, Table addToQuals) {
        if (this.is(16)) {
            return 0;
        }
        if (this.userAction) {
            this.setActionType();
        }
        MessageHandler wmh = this;
        if (this.from != null) {
            wmh = (MessageHandler)this.from;
        } else if (this.MW != null) {
            wmh = this.MW.mh;
        }
        Table quals = new Table();
        if (addToQuals != null) {
            quals.putAll((Map)addToQuals);
        }
        quals.put("ACTIONTYPE", this.actionType);
        quals.put("ACTIONTYPESTRING", (Object)this.getActionTypeString(this.actionType));
        this.actionType = -2;
        return this.mh == null ? 0 : this.mh.processMessage(new Message(name, info, data, this.mh, wmh, quals));
    }

    protected int processEventMessage(String name, int info, Object data) {
        return -1;
    }

    @Override
    @Deprecated
    public void rubberbox(int mode) {
        this.gwRubberbox(this.g, mode);
    }

    private void gwRubberbox(Graphics g, int mode) {
        if (mode == 0) {
            this.gwRubberbox(g, -1);
        }
        if (mode >= 0) {
            this.rbox.setBounds(this.box);
        }
        int x = this.rbox.w;
        int y = this.rbox.h;
        int w = this.pos.w - 1;
        int h = this.pos.h - 1;
        if (this.MW != null) {
            x += this.pos.x;
            y += this.pos.y;
        }
        g.setXORMode(this.theme.getBackground());
        g.drawRect(x, y, w, h);
        g.setXORMode(this.theme.getForeground());
        g.drawRect(x + 1, y + 1, w - 2, h - 2);
        g.setPaintMode();
        if (mode < 0) {
            this.rbox.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public Object setKey(String key, Object value) {
        switch (key) {
            case "V": {
                this.setValue(Convert.o2s(value));
                break;
            }
            case "VALUE": {
                this.setValue(Convert.o2s(value));
                break;
            }
            case "ACTION": {
                this.setAction(Convert.o2s(value));
                break;
            }
            case "POS": {
                this.setBounds((MBox)value);
                break;
            }
            case "PARENT": {
                this.addTo(value);
                break;
            }
            case "TITLE": {
                this.setTitle(Convert.o2s(value));
                break;
            }
            case "SHOW": {
                this.setShow(Convert.o2z(value));
                break;
            }
            case "REFRESH": {
                this.process("REFRESH", 0);
                break;
            }
            default: {
                return null;
            }
        }
        return value;
    }

    @Override
    public Object getKey(String key) {
        switch (key) {
            case "V": {
                return this.getValue();
            }
            case "VALUE": {
                return this.getValue();
            }
            case "POS": {
                return this.pos;
            }
            case "PARENT": {
                return this.parent;
            }
            case "THEME": {
                return this.theme;
            }
            case "TITLE": {
                return this.title;
            }
        }
        return null;
    }

    @Override
    public int processMessage(Message msg) {
        return 0;
    }

    @Override
    public String getID() {
        return "MAIN";
    }

    @Override
    public void close() {
        this.formatReadOut(-1);
        super.close();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.titlew = this.stringWidth(title);
        this.refresh();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.compression != 0) {
            this.pos.w = w;
            this.pos.h = h;
            this.setLocation(x, y);
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    protected void setValueBox(int x, int y, int w, int h) {
        if (this.bbox == null) {
            this.bbox = new MBox();
        }
        this.bbox.setBounds(x, y, w + 1, h + 1);
    }

    @Deprecated
    protected void drawValueBox(int mode) {
        this.drawValueBox(this.g, mode);
    }

    protected void drawValueBox(Graphics g, int mode) {
        int draw = 0;
        if (this.bbox == null || this.is(8)) {
            return;
        }
        if (this.is(64)) {
            if (mode == 1) {
                draw = 1;
            }
        } else if (this.is(128)) {
            if (mode == 1 && this.pactive) {
                draw = 1;
            }
            if (Math.abs(mode) == 9) {
                draw = -1;
            }
        }
        if (draw < 0) {
            g.setXORMode(this.theme.getWidgetBackground());
        }
        if (draw != 0) {
            g.setColor(this.theme.getWidgetTopShade());
            g.drawRect(this.bbox.x, this.bbox.y, this.bbox.w - 1, this.bbox.h - 1);
        }
        if (draw < 0) {
            g.setPaintMode();
        }
        if (draw != 0) {
            g.setColor(this.theme.getWidgetForeground());
        }
    }

    public void refreshValue() {
        this.refresh(this.bbox);
    }

    public void placeTextInput(MBox bc, JTextField texti) {
        if (bc == null || texti == null) {
            return;
        }
        boolean inline = this.is(32);
        int x = bc.x + (inline ? 2 : 3);
        int y = inline ? 2 : 0;
        int w = this.pos.w - bc.x - (inline ? 6 : 6);
        int h = this.pos.h + -(inline ? 4 : 0);
        texti.setBounds(x, y, w, h);
    }

    public boolean isStretchable() {
        return false;
    }

    @Override
    protected Table getHelpData() {
        Table data = new Table();
        data.put("NAME", (Object)this.label);
        data.put("VALUE", this.getValue());
        return data;
    }

    public void setCorner(String corner) {
        if (StringUtil.isNull(corner) || this.MW == null) {
            return;
        }
        this.setCorner(this.MW, corner);
    }

    protected void setCorner(MWindow winBound, String corner) {
        MBox newPos = new MBox(winBound.pos.x, winBound.pos.y, this.pos.w, this.pos.h);
        if (winBound.MW == null) {
            newPos.x = 0;
            newPos.y = 0;
        }
        switch (corner = corner.trim().toUpperCase()) {
            case "TL": 
            case "TOPLEFT": {
                break;
            }
            case "TR": 
            case "TOPRIGHT": {
                newPos.x = newPos.x + winBound.pos.w - this.pos.w;
                break;
            }
            case "BL": 
            case "BOTTOMLEFT": {
                newPos.y = newPos.y + winBound.pos.h - this.pos.h;
                break;
            }
            case "BR": 
            case "BOTTOMRIGHT": {
                newPos.x = newPos.x + winBound.pos.w - this.pos.w;
                newPos.y = newPos.y + winBound.pos.h - this.pos.h;
                break;
            }
            default: {
                Shell.warning("GWidget: Unknown corner (" + corner + ")");
            }
        }
        this.setBounds(newPos);
    }

    public void setFrom(Object from) {
        this.from = from;
    }

    void setScrollNoMove(boolean scrollNoMove) {
        this.scrollNoMove = scrollNoMove;
    }
}

