/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.ReflectUtil;
import nxm.sys.libg.GPrimitiveModSwap;
import nxm.sys.libg.MWindow;

public class GPrimitive
extends GPrimitiveModSwap {
    private static final Class<?> LEGACY_LIB_GPRIMITIVE_CLASS;
    private static final Method LEGACY_LIB_GPRIMITIVE_GET_MWINDOW;
    private static final Method LEGACY_LIB_GPRIMITIVE_GET_GRAPHICS_CONTAINER;

    @InternalUseOnly
    public static boolean isInstance(Object obj) {
        if (LEGACY_LIB_GPRIMITIVE_CLASS == null) {
            return obj instanceof GPrimitive;
        }
        return LEGACY_LIB_GPRIMITIVE_CLASS.isInstance(obj);
    }

    @InternalUseOnly
    public static MWindow getMWindowViaReflection(Object obj) {
        if (LEGACY_LIB_GPRIMITIVE_GET_MWINDOW != null) {
            try {
                return (MWindow)LEGACY_LIB_GPRIMITIVE_GET_MWINDOW.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        if (obj instanceof GPrimitive) {
            return ((GPrimitive)obj).getMWindow();
        }
        return null;
    }

    @InternalUseOnly
    public static Container getGraphicsContainerViaReflection(Object obj) {
        if (LEGACY_LIB_GPRIMITIVE_GET_MWINDOW != null) {
            try {
                return (Container)LEGACY_LIB_GPRIMITIVE_GET_GRAPHICS_CONTAINER.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        if (obj instanceof GPrimitive) {
            return ((GPrimitive)obj).getGraphicsContainer();
        }
        return null;
    }

    static {
        Class<?> libGPrimitiveClass;
        try {
            libGPrimitiveClass = Class.forName("nxm.sys.lib.GPrimitive");
        }
        catch (ClassNotFoundException e) {
            libGPrimitiveClass = null;
        }
        if (libGPrimitiveClass != null) {
            LEGACY_LIB_GPRIMITIVE_CLASS = libGPrimitiveClass;
            LEGACY_LIB_GPRIMITIVE_GET_MWINDOW = ReflectUtil.getMethodOfClass(LEGACY_LIB_GPRIMITIVE_CLASS, "getMWindow", new Class[0]);
            LEGACY_LIB_GPRIMITIVE_GET_GRAPHICS_CONTAINER = ReflectUtil.getMethodOfClass(LEGACY_LIB_GPRIMITIVE_CLASS, "getGraphicsContainer", new Class[0]);
        } else {
            LEGACY_LIB_GPRIMITIVE_CLASS = null;
            LEGACY_LIB_GPRIMITIVE_GET_MWINDOW = null;
            LEGACY_LIB_GPRIMITIVE_GET_GRAPHICS_CONTAINER = null;
        }
    }
}

