/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Parser;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MJText;
import nxm.sys.libg.Theme;

public class GList
extends GWidget
implements ActionListener {
    public static final String flagsList = GWidget.flagsList + "," + "Multiple,Fifo,Tree,Columns,NoSelect,NoHilite,BackLite,Input,Text,Wrap,Color,Banner,AddPlus,Logger";
    public static final int MULT = 256;
    public static final int FIFO = 512;
    public static final int TREE = 1024;
    public static final int COLS = 2048;
    public static final int NOSEL = 4096;
    public static final int NOHIL = 8192;
    public static final int MOMENT = 16384;
    public static final int INPUT = 32768;
    public static final int COLOR = 65536;
    public static final int BANNER = 131072;
    public MJText list;
    int selected = -1;

    public GList(Object parent, String name, String items, int aw, int ah, int flags, MessageHandler mh) {
        super("GList", parent, name, flags, mh);
        this.open(name, aw, ah, items);
        this.addTo(parent);
    }

    public GList(Object parent, String name, String[] items, int aw, int ah, int flags, MessageHandler mh) {
        super("GList", parent, name, flags, mh);
        this.open(name, aw, ah, null);
        this.addItems(items);
        this.addTo(parent);
    }

    public void open(String name, int aw, int ah, String text) {
        this.open();
        super.open(name, aw * this.tw, ah * this.th + this.ta);
        this.setupList(aw, ah, text);
    }

    public void setupList(int aw, int ah, String text) {
        this.list = new MJText(256, aw, ah, 12, this.theme, this.flags >> 8);
        this.list.setMWindow(this);
        if (text != null) {
            Parser p = new Parser(text);
            while (p.more()) {
                this.list.add(p.next());
            }
        }
        this.list.addActionListener(this);
        this.panel.add(this.list);
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.pw = this.pos.w - this.bw - this.bw;
        this.ph = this.pos.h - this.titleh;
        if (this.list != null) {
            this.list.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        }
    }

    @Override
    public void setValue(String value) {
        this.list.add(value);
    }

    @Override
    public Object getValue() {
        return this.list.getSelectedItem();
    }

    public String[] getValues() {
        return this.list.getSelectedItems();
    }

    @Override
    public void setTheme(Theme theme) {
        super.setTheme(theme);
        this.list.setTheme(theme);
    }

    public void addItem(String item) {
        this.list.add(item);
    }

    public void addItems(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.list.add(items[i]);
        }
    }

    public void removeItems() {
        this.list.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        int item = e.getModifiers();
        if (action.equals("SELECT") && item >= 0 && !this.is(16)) {
            String text = this.list.getLine(item);
            this.sendWidgetMessage(this.label, item, text);
        }
    }

    @Override
    public boolean isStretchable() {
        return true;
    }
}

