/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import nxm.sys.inc.Drawable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.Layer;
import nxm.sys.libg.LayerDrawable;
import nxm.sys.libg.Line;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Symbol;

public final class GLegend
extends GMenu {
    private MPlot mplot;
    private Entry[] entries;
    private int nentries;
    private int altwidth = 20;
    private int altheight = 12;
    public static final String flagsList = GMenu.flagsList + ",Symbol,ReOrder";
    public static final int SYMBOL = 0x10000000;
    public static final int REORDER = 0x20000000;

    GLegend(Object parent, String name, MPlot mplot, int flags, MessageHandler mh) {
        super("GLegend", parent, name, flags | 2 | 0x400, mh);
        this.open(name, mplot);
        this.addTo(parent);
    }

    @Override
    public void setCorner(String corner) {
        if (StringUtil.isNull(corner) || this.mplot == null) {
            return;
        }
        this.setCorner(this.mplot, corner);
    }

    public void open(String name, MPlot mplot) {
        this.mplot = mplot;
        this.updateEntries();
        this.setAltSize(this.altwidth, this.altheight);
        this.open(name);
        this.setItems(this.entries, this.nentries);
        this.resize(1);
    }

    protected void setCorner(MPlot plot2, String corner) {
        MBox newPos = new MBox(plot2.panel.getLocation().x, plot2.panel.getLocation().y, this.pos.w, this.pos.h);
        if (plot2.MW == null) {
            newPos.x = 0;
            newPos.y = 0;
        }
        switch (corner = corner.trim().toUpperCase()) {
            case "TL": 
            case "TOPLEFT": {
                break;
            }
            case "TR": 
            case "TOPRIGHT": {
                newPos.x = newPos.x + plot2.pos.w - this.pos.w;
                break;
            }
            case "BL": 
            case "BOTTOMLEFT": {
                newPos.y = newPos.y + plot2.pos.h - this.pos.h;
                break;
            }
            case "BR": 
            case "BOTTOMRIGHT": {
                newPos.x = newPos.x + plot2.pos.w - this.pos.w;
                newPos.y = newPos.y + plot2.pos.h - this.pos.h;
                break;
            }
            default: {
                Shell.warning("GWidget: Unknown corner (" + corner + ")");
            }
        }
        this.setBounds(newPos);
    }

    private void updateEntries() {
        int i;
        int nlayers = this.mplot.layers.getSize();
        if (this.entries == null || this.entries.length < nlayers) {
            this.entries = new Entry[nlayers];
        }
        this.nentries = 0;
        for (i = 0; i < nlayers; ++i) {
            Layer lay = (Layer)this.mplot.layers.get(i);
            if (lay instanceof LayerDrawable && ((LayerDrawable)lay).isListLayers()) {
                LayerDrawable layerDrawables = (LayerDrawable)lay;
                List<Drawable> drawables = layerDrawables.getDrawablesInstance();
                for (Drawable drawable : drawables) {
                    if (!(drawable instanceof Layer)) continue;
                    this.addLayerToList((Layer)drawable);
                }
                continue;
            }
            this.addLayerToList(lay);
        }
        for (i = this.nentries; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
    }

    private void addLayerToList(Layer lay) {
        int num;
        Entry ent = lay.getLegendEntry();
        Entry[] sent = lay.getLegendSubEntries();
        int n = num = sent == null ? 1 : sent.length + 1;
        if (this.nentries + num > this.entries.length) {
            Entry[] temp = new Entry[this.nentries + num + 8];
            System.arraycopy(this.entries, 0, temp, 0, this.nentries);
            this.entries = temp;
        }
        this.entries[this.nentries++] = ent;
        if (sent != null) {
            System.arraycopy(sent, 0, this.entries, this.nentries, sent.length);
            this.nentries += sent.length;
        }
    }

    @Override
    public void select(int i, int button) {
        if (button == 3) {
            this.close();
        } else {
            this.entries[i - 1].toggle();
            this.refresh();
        }
    }

    @Override
    public void selectAlt(int i, int button) {
        if (button == 3) {
            this.close();
        } else {
            this.entries[i - 1].configure();
            this.refresh();
        }
    }

    @Override
    boolean isToggled(int i) {
        return this.entries[i - 1].isEnabled();
    }

    @Override
    int getIndent(int i) {
        return this.entries[i - 1].getIndent();
    }

    @Override
    @Deprecated
    protected void refreshItemAlt(int i, MBox pos) {
        this.refreshItemAlt(this.g, i, pos);
    }

    @Override
    protected void refreshItemAlt(Graphics g, int i, MBox pos) {
        Entry ent = this.entries[i - 1];
        Color[] colors = ent.getCMap();
        Line line = ent.getLine().copy();
        int x1 = pos.x;
        int x2 = x1 + pos.w;
        int x = (x1 + x2) / 2;
        int y1 = pos.y;
        int y = y1 + pos.h / 2;
        if (colors == null || colors.length - 1 <= 1) {
            this.drawLegendLine(x, y, x1, x2, line, ent.getColor(), g);
        } else {
            int ncolors = colors.length - 1;
            double scale = 2.0;
            if (ncolors < pos.h / 2) {
                y1 += (pos.h - 2 * (ncolors - 1)) / 2;
            } else {
                scale = (double)pos.h / (double)(ncolors - 1);
            }
            for (int c = 0; c < ncolors; ++c) {
                this.drawLegendLine(x, y1 + (int)((double)c * scale), x1, x2, line, colors[c + 1], g);
            }
        }
        g.setColor(this.theme.cwfg);
    }

    protected void drawLegendLine(int x, int y, int x1, int x2, Line lin, Color c, Graphics g) {
        g.setColor(c);
        Symbol sym = lin.getSymbol();
        int type = lin.getTypeInt();
        if ((type & 1) != 0) {
            g.drawLine(x1, y, x2, y);
        }
        if ((type & 0x20) != 0 && sym != null) {
            sym.draw(x, y, g, 3);
        }
    }

    @Override
    public String getLegend() {
        return "(LM=Toggle,MM=Configure,RM=Exit)";
    }

    void update() {
        this.updateEntries();
        this.setItems(this.entries, this.nentries);
        this.refresh();
    }

    public static class SubEntry
    extends Entry {
        private final String name;
        private final int indent;
        private final Line line;
        private final Color color;
        private final Color[] cmap;
        private final boolean enabled;

        public SubEntry(Layer layer, String name, int indent, Line line, Color color, Color[] cmap, boolean enabled) {
            super(layer);
            this.name = name;
            this.indent = indent;
            this.line = line;
            this.color = color;
            this.cmap = cmap;
            this.enabled = enabled;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getIndent() {
            return this.indent;
        }

        @Override
        public Line getLine() {
            return this.line != null ? this.line : super.getLine();
        }

        @Override
        public Color getColor() {
            return this.color != null ? this.color : super.getColor();
        }

        @Override
        public Color[] getCMap() {
            return this.cmap;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled && super.isEnabled();
        }
    }

    public static class Entry {
        private final Layer layer;

        public Entry(Layer layer) {
            this.layer = layer;
        }

        public final Layer getLayer() {
            return this.layer;
        }

        public String getName() {
            return this.layer.getName();
        }

        public int getIndent() {
            return 0;
        }

        public Line getLine() {
            return this.layer.getLine();
        }

        public Color getColor() {
            return this.layer.getLine().getColor();
        }

        public Color[] getCMap() {
            return this.layer.colors;
        }

        public boolean isEnabled() {
            return (this.layer.enable & 1) != 0;
        }

        public String toString() {
            return this.getName();
        }

        public void toggle() {
            this.layer.toggle();
        }

        public void configure() {
            this.layer.configure();
        }
    }
}

