/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GList;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.MPlot;

public class GFiles
extends GDialog {
    Midas M;
    String raux;
    GPrompt nfilt;
    GPrompt fname;
    GList nlist;
    GMenu amenu;
    GMenu omenu;
    String auxList;
    String selectName;
    int auxMask;
    int optMask;
    public static final String optList = "Path,AuxID,Qual,Ext,SingleAux,HideOpts";
    public static final int O_PATH = 4096;
    public static final int O_APID = 8192;
    public static final int O_QUAL = 16384;
    public static final int O_EXT = 32768;
    public static final int SINGLE_AUX = 65536;
    public static final int HIDE_OPTS = 131072;
    public static final String flagsList = GPrompt.flagsList + ",," + "Path,AuxID,Qual,Ext,SingleAux,HideOpts";

    public GFiles(Object parent, String name, String seed, String filt, String raux, Midas M, int aw, int ah, int flags, MessageHandler mh) {
        super(null, name, -(aw == 0 ? 50 : aw), -(ah == 0 ? 15 : ah), ((flags & 0x20000) != 0 ? "" : "Cfg,") + "Apply,Submit,Cancel", "Cfg,Apply", flags, mh);
        if (parent instanceof MPlot) {
            ++((MPlot)parent).popupCount;
        }
        this.open(name, seed, filt, raux, M);
        this.addTo(parent);
    }

    public void open(String name, String seed, String filt, String raux, Midas M) {
        this.M = M;
        if (seed == null) {
            seed = "";
        }
        if (filt == null) {
            filt = "*.tmp|prm";
        }
        if (raux == null) {
            raux = M.results.getString("AUX.WRITE");
        }
        this.raux = raux;
        this.formAuxList();
        int sflags = 128;
        int oflags = sflags | 0x2000 | 0x20000 | 0x800 | 0x400;
        int aflags = sflags | 0x100;
        if (!this.is(65536)) {
            aflags |= 0x100000;
        }
        this.fname = new GPrompt(this, "File ", seed, sflags, (MessageHandler)this);
        this.nfilt = new GPrompt(this, "Filter", filt, sflags, (MessageHandler)this);
        this.amenu = new GMenu(this, "AuxList", this.auxList, this.auxMask, aflags, this);
        this.nlist = new GList((Object)this, "Names", "FileList", 40, 10, 2048, (MessageHandler)this);
        this.formNameList();
    }

    private void formAuxList() {
        this.auxList = null;
        this.auxMask = 0;
        int auxIndex = 0;
        String rauxm = "|" + this.raux + "|";
        String nrauxm = "|READ|WRITE|HOMEPATH|";
        Table t = this.M.results.getTable("AUX");
        Table.Iterator ti = t.iterator();
        while (ti.getNext()) {
            String aux = ti.key;
            String auxm = "|" + aux + "|";
            if (nrauxm.indexOf(auxm) >= 0) continue;
            if (rauxm.indexOf(auxm) >= 0) {
                this.auxMask |= 1 << auxIndex;
            }
            this.auxList = this.auxList == null ? aux : this.auxList + "," + aux;
            ++auxIndex;
        }
        if (this.amenu != null) {
            this.amenu.setItems(this.auxList);
            this.amenu.setValue(this.auxMask);
        }
    }

    public void formNameList() {
        this.nlist.removeItems();
        String filter = (String)this.nfilt.getValue();
        int ip = filter.indexOf(46);
        String root = filter;
        String ext = "tmp|prm";
        if (ip >= 0) {
            root = filter.substring(0, ip);
            ext = filter.substring(ip + 1);
        }
        String toAux = "";
        for (int j = 0; j < this.amenu.getItemCount(); ++j) {
            String uext;
            if ((this.auxMask >> j & 1) == 0) continue;
            String aux = this.amenu.getItem(j + 1);
            toAux = toAux.equals("") ? aux : toAux + "|" + aux;
            String path = this.M.io.getAuxPath(aux);
            String[] files = this.M.io.listFiles(path, root, uext = aux.equals("RAM") ? "" : ext);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                this.nlist.addItem(aux + "/" + files[i]);
            }
        }
        this.raux = toAux;
    }

    @Override
    public Object getValue() {
        return this.fname.getValue();
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("DIALOG")) {
            String action = (String)msg.data;
            if (action.equals("SUBMIT") || action.equals("APPLY")) {
                String val = this.is(16384) || this.is(65536) ? this.addWriteAux() : this.getValueString();
                this.sendWidgetMessage(this.label, 0, val);
            } else if (action.equals("VIEW")) {
                String name = this.parseName(4096);
                if (name != null && name.length() > 0) {
                    Shell.runCommand(this.M, "VIEW/BG," + name);
                }
            } else if (action.equals("CFG")) {
                new GMenu(this.parent, "GFiles.cfg", optList, this.flags >> 8, 1024, this);
            }
            if (!this.is(1) && this.isCloseButton(action)) {
                this.close();
            }
        } else if (msg.name.equals("GFILES.CFG")) {
            this.setOptions(msg.info);
        } else if (msg.name.equals("AUXLIST")) {
            this.auxMask = this.is(65536) ? Parser.mask(this.auxList, Parser.get(this.auxList, msg.info), 0) : msg.info;
            this.formNameList();
        } else if (msg.name.equals("FILTER")) {
            this.formNameList();
        } else if (msg.name.equals("NAMES")) {
            this.selectName = (String)msg.data;
            this.parseName();
        }
        return 0;
    }

    private void setOptions(int mask) {
        this.flags = (mask & 0xF) << 8 | this.flags & 0xF0FF;
        if (this.is(4096)) {
            this.flags &= 0xFFFF9FFF;
        }
        if (this.is(8192)) {
            this.flags &= 0xFFFFAFFF;
        }
        if (this.is(16384)) {
            this.flags &= 0xFFFFCFFF;
        }
        if (this.selectName != null) {
            this.parseName();
        }
    }

    private void parseName() {
        this.fname.setValue(this.parseName(this.flags));
    }

    private String parseName(int mask) {
        String pname = this.selectName;
        int j = pname.indexOf("/");
        String aux = pname.substring(0, j);
        String name = pname.substring(j + 1);
        int k = name.indexOf(".");
        if ((mask & 0x8000) == 0 && k > 0) {
            name = name.substring(0, k);
        }
        pname = name;
        if ((mask & 0x4000) != 0) {
            pname = name + "{AUX=" + aux + "}";
        }
        if ((mask & 0x2000) != 0) {
            pname = aux + "/" + name;
        }
        if ((mask & 0x1000) != 0) {
            pname = this.M.io.getAuxPath(aux) + name;
        }
        return pname;
    }

    private String addWriteAux() {
        String base = this.getValueString();
        if (base.contains("AUX=")) {
            return base;
        }
        return base + "{AUX=" + this.raux + "}";
    }

    public String getFilter() {
        return "" + this.nfilt.getValue();
    }

    public String getAuxList() {
        return this.raux;
    }
}

