/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Table;
import nxm.sys.libg.Feature;

public class FeatureGroup {
    private Map<String, Feature> features = new ConcurrentHashMap<String, Feature>();

    public FeatureGroup() {
    }

    public FeatureGroup(Feature feature) {
        this();
        this.features.put(feature.name, feature);
    }

    public void addFeature(Feature feature) {
        this.features.put(feature.name, feature);
    }

    public void removeFeature(Feature feature) {
        this.features.remove(feature.name);
    }

    public void removeFeature(String name) {
        this.features.remove(name);
    }

    public void moveAllFeaturesToNewGroup(String newGroup) {
        this.features.forEach((k, v) -> v.setGroup(newGroup));
    }

    public int getSize() {
        return this.features.size();
    }

    public void setLine(Table tbl) {
        this.features.forEach((k, v) -> v.setLine(tbl));
    }

    public void setFeatureAttributes(Table tbl) {
        this.features.forEach((k, v) -> v.fromTable(tbl));
    }

    @InternalUseOnly
    public Map<String, Feature> getFeatures() {
        return this.features;
    }
}

