/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class ZipFile
extends BaseFile
implements ListFile {
    private static final ZipEntry[] EMPTY_ZIPENTRY_ARRAY = new ZipEntry[0];
    ZipEntry[] zipEntries = null;
    java.util.zip.ZipFile zipFile = null;

    public ZipFile() {
    }

    @Deprecated
    public ZipFile(Object ref, Object filename) {
        this.init(Convert.ref2Midas(ref), filename);
    }

    public ZipFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String getMimeType() {
        return "application/zip";
    }

    @Override
    @Deprecated
    public void init(Object ref, Object filename) {
        this.init(Convert.ref2Midas(ref), filename);
    }

    @Override
    public void init(MidasReference ref, Object filename) {
        super.init(ref, filename);
        this.zipEntries = null;
    }

    @Override
    protected void setInternals() {
        super.setInternals();
        try {
            this.zipEntries = this.readZipFile();
        }
        catch (Exception e) {
            this.zipFile = null;
        }
        if (this.zipEntries == null) {
            try {
                this.zipEntries = this.readZipInputStream();
            }
            catch (Exception e) {
                if ((this.flags & 0x20) == 0) {
                    throw new MidasException("ZipFile: Unable to read from " + this.getName(), e);
                }
                this.M.printStackTrace("ZipFile: Unable to read from " + this.getName(), e);
            }
        }
    }

    ZipEntry[] readZipFile() throws IOException {
        String fname = FileUtil.toLocalFileName(this.getURL());
        return fname == null ? null : this.readZipFile(new java.util.zip.ZipFile(fname));
    }

    ZipEntry[] readZipInputStream() throws IOException {
        return this.readZipInputStream(new ZipInputStream(this.io.getInputStream()));
    }

    ZipEntry[] readZipFile(java.util.zip.ZipFile zip) throws IOException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        this.zipFile = zip;
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            entries.add(e.nextElement());
        }
        return entries.toArray(EMPTY_ZIPENTRY_ARRAY);
    }

    ZipEntry[] readZipInputStream(ZipInputStream in) throws IOException {
        ZipEntry entry;
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        while ((entry = in.getNextEntry()) != null) {
            entries.add(entry);
        }
        in.close();
        return entries.toArray(EMPTY_ZIPENTRY_ARRAY);
    }

    @Override
    public Object[] getEntries() {
        return this.zipEntries;
    }

    @Override
    public String toString() {
        String str = "ZipFile ";
        if (this.io != null) {
            str = str + this.io.getTypeString();
        }
        str = str + " Resource";
        return str;
    }

    @Override
    public String listHeader() {
        String list3 = "ZipFile   :  " + this.getURL() + "\nEntries   :  " + this.getNumEntries() + "\nBytes     :  " + this.getSize() + "\n";
        return list3;
    }

    public int getNumEntries() {
        return this.zipEntries.length;
    }

    @Override
    public String listElements(double start, int elements, String format, int flags) {
        String str = null;
        if (start >= 0.0 && start < (double)this.zipEntries.length) {
            str = this.zipEntries[(int)start].getName() + "\n";
        }
        return str;
    }

    @Override
    public int listElementsPerLine(int lineWidth, String form, int flags) {
        return 1;
    }

    void notEditable() {
        throw new UnsupportedOperationException("ZipFile is not editable.");
    }

    @Override
    public double getNumberOfRows() {
        return this.getNumEntries();
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public int setData(double d, Table t) {
        this.notEditable();
        return 0;
    }

    @Override
    public void setData(double d, String s, Object o) {
        this.notEditable();
    }

    @Override
    public void insertData(double d, Object o) {
        this.notEditable();
    }

    @Override
    public void removeData(double d) {
        this.notEditable();
    }

    @Override
    public void removeData(double d, long c) {
        this.notEditable();
    }

    @Override
    public void setRecordDefs(Table t) {
        this.notEditable();
    }

    @Override
    public Table getDataTable(double offset) {
        String method;
        if (offset < 0.0) {
            return null;
        }
        if (offset >= (double)this.zipEntries.length) {
            return null;
        }
        Table t = new Table();
        ZipEntry e = this.zipEntries[(int)offset];
        double time = 6.31152E8 + (double)e.getTime() / 1000.0;
        switch (e.getMethod()) {
            case 0: {
                method = "STORED";
                break;
            }
            case 8: {
                method = "DEFLATED";
                break;
            }
            default: {
                method = "UNKNOWN";
            }
        }
        String comment = e.getComment();
        if (comment == null) {
            comment = "";
        }
        t.put("NAME", (Object)e.getName());
        t.put("COMMENT", (Object)comment);
        t.put("TIME", time);
        t.put("DIRECTORY", e.isDirectory());
        t.put("COMP_SIZE", e.getCompressedSize());
        t.put("COMP_METHOD", (Object)method);
        t.put("CRC", e.getCrc());
        return t;
    }

    @Override
    public int getRecordDefCount() {
        return 7;
    }

    @Override
    public Table getRecordDef(int i) {
        Table t = new Table();
        switch (i) {
            case 0: {
                t.put("NAME", (Object)"NAME");
                break;
            }
            case 1: {
                t.put("NAME", (Object)"COMMENT");
                break;
            }
            case 2: {
                t.put("NAME", (Object)"TIME");
                t.put("FORMAT", (Object)"SD");
                break;
            }
            case 3: {
                t.put("NAME", (Object)"DIRECTORY");
                t.put("FORMAT", (Object)"SZ");
                break;
            }
            case 4: {
                t.put("NAME", (Object)"COMP_SIZE");
                t.put("FORMAT", (Object)"SX");
                break;
            }
            case 5: {
                t.put("NAME", (Object)"COMP_METHOD");
                break;
            }
            case 6: {
                t.put("NAME", (Object)"CRC");
                t.put("FORMAT", (Object)"SX");
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("Invalid record definition i=" + i);
            }
        }
        return t;
    }

    @Override
    public Table getRecordDefs() {
        Table t = new Table();
        for (int i = 0; i < this.getRecordDefCount(); ++i) {
            t.put(Integer.toString(i), (Object)this.getRecordDef(i));
        }
        return t;
    }

    public static void createZipFile(Midas midas, FileName zipFile, String[] names, FileName[] files, boolean verbose) {
        try {
            FileOutputStream dest = new FileOutputStream(zipFile.toString());
            BufferedOutputStream bos = new BufferedOutputStream(dest);
            ZipOutputStream out = new ZipOutputStream(bos);
            ZipFile.createZipFile(midas, out, names, files, false, verbose);
        }
        catch (Exception e) {
            throw new MidasException("ZipFile: Error unable to create zip file", e);
        }
    }

    static void createZipFile(Midas midas, ZipOutputStream out, String[] names, FileName[] files, boolean jar, boolean verbose) throws IOException {
        byte[] buffer = new byte[BaseFile.BUFFER_SIZE];
        if (names == null) {
            throw new MidasException("Names array is null");
        }
        if (files == null) {
            throw new MidasException("Files array is null");
        }
        if (names.length != files.length) {
            throw new MidasException("Names given do not match files given (names.length=" + names.length + " files.length=" + files.length + ").");
        }
        for (int i = 0; i < names.length; ++i) {
            String compRatio;
            String name = names[i];
            boolean done = false;
            if (name.startsWith(File.separator)) {
                name = name.substring(1);
            }
            ZipEntry entry = jar ? new JarEntry(name) : new ZipEntry(name);
            out.putNextEntry(entry);
            if (!name.endsWith("/") && files[i] != null) {
                FileInputStream fis = new FileInputStream(files[i].getFullName());
                BufferedInputStream in = new BufferedInputStream(fis, buffer.length);
                while (!done) {
                    int bytesRead = in.read(buffer, 0, buffer.length);
                    if (bytesRead == 0) {
                        Time.sleep(midas.pause);
                        continue;
                    }
                    if (bytesRead < 0) {
                        done = true;
                        continue;
                    }
                    out.write(buffer, 0, bytesRead);
                }
                in.close();
                fis.close();
            }
            out.closeEntry();
            if (!verbose) continue;
            if (entry.getSize() == 0L) {
                compRatio = "(deflated 100%)";
            } else {
                float cr = (1.0f - (float)entry.getCompressedSize() / (float)entry.getSize()) * 100.0f;
                compRatio = "(deflated " + (int)cr + "%)";
            }
            midas.info(StringUtil.padRight("  adding: " + name + " " + compRatio, 40));
        }
        out.close();
    }
}

