/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.Table;

public class Vehicle {
    private final EventListenerList listeners = new EventListenerList();
    private final TableListener tblListener = new TableListener();
    protected final Object ref;
    protected final String className;
    protected final Location location;
    protected final Site site;
    protected final Table pointPosTbl;
    protected final Table attributes;

    public Vehicle(Object ref) {
        this("Vehicle", ref);
    }

    protected Vehicle(String className, Object ref) {
        this.className = className;
        this.ref = ref != null ? ref : Shell.getSharedMidasContext();
        this.location = this.createLocation();
        this.site = this.createSite();
        this.pointPosTbl = new Table();
        this.attributes = new Table();
        this.attributes.addListener(this.tblListener);
    }

    protected Location createLocation() {
        return new LocationImpl(this);
    }

    protected Site createSite() {
        return new SiteImpl(this);
    }

    public Vehicle(Object ref, Table tbl) {
        this(ref);
        this.setValues(tbl);
    }

    protected PointingPos createPointingPos(String name) {
        return new PointingPosImpl(this, name);
    }

    public void setValues(Table tbl) {
        if (tbl != null) {
            Table pts = tbl.getTable("POINTS");
            Table attr = tbl.getTable("ATTRIBUTES");
            if (tbl.containsKey("LOCATION")) {
                this.getLocation().setValues(tbl.getTable("LOCATION"));
            }
            if (tbl.containsKey("SITE")) {
                this.getSite().setValues(tbl.getTable("SITE"));
            }
            if (tbl.containsKey("TIME")) {
                this.setTime(tbl.getD("TIME"));
            }
            if (pts != null) {
                String[] keys = pts.getKeys();
                for (int i = 0; i < keys.length; ++i) {
                    this.usePointingPos(keys[i]).setValues(pts.getTable(keys[i]));
                }
            }
            if (attr != null) {
                this.attributes.merge(attr);
            }
        }
    }

    public Table toTable() {
        Table tbl = new Table();
        Table pointPos = new Table();
        tbl.put("LOCATION", (Object)this.location.toTable());
        tbl.put("SITE", (Object)this.site.toTable());
        tbl.put("POINTINGPOS", (Object)pointPos);
        tbl.put("ATTRIBUTES", (Object)this.getAttributes());
        tbl.put("TIME", this.getTime());
        String[] keys = this.getPointingPosNames();
        for (int i = 0; i < keys.length; ++i) {
            pointPos.put(keys[i], (Object)this.getPointingPos(keys[i]).toTable());
        }
        return tbl;
    }

    public String toString() {
        return this.className + ": " + this.toTable();
    }

    public double getTime() {
        return this.getLocation().getTime();
    }

    public void setTime(double time) {
        if (time != this.getTime()) {
            this.getLocation().setTime(time);
            this.updateAll();
            this.refresh();
        }
    }

    public Table getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object val) {
        if (val == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, val);
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public Site getSite() {
        return this.site;
    }

    public String[] getPointingPosNames() {
        return this.pointPosTbl.getKeys();
    }

    public PointingPos getPointingPos(String name) {
        return (PointingPos)this.pointPosTbl.get(name);
    }

    public PointingPos usePointingPos(String name) {
        PointingPos point = this.getPointingPos(name);
        if (point == null) {
            point = this.createPointingPos(name);
            this.pointPosTbl.put(name, (Object)point);
            this.refresh();
        }
        return point;
    }

    public void removePointingPos(String name) {
        PointingPos old = this.getPointingPos(name);
        if (old != null) {
            this.pointPosTbl.remove(name);
            this.refresh();
        }
    }

    public void removeAllPointingPos() {
        if (!this.pointPosTbl.isEmpty()) {
            this.pointPosTbl.clear();
            this.refresh();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = null;
        Object[] list3 = this.listeners.getListenerList();
        for (int i = list3.length - 2; i >= 0; i -= 2) {
            if (list3[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)list3[i + 1]).stateChanged(event);
        }
    }

    protected void refresh() {
        this.fireChangeEvent();
    }

    protected void update(Location point) {
        point.setTime(this.getTime());
    }

    protected void updateAll() {
        this.update(this.getLocation());
        this.update(this.getSite());
        String[] keys = this.getPointingPosNames();
        for (int i = 0; i < keys.length; ++i) {
            this.update(this.getPointingPos(keys[i]));
        }
    }

    private static Position toPosition(Object val) {
        if (val instanceof Position) {
            return (Position)val;
        }
        return Position.fromGeo(Convert.o2t(val));
    }

    protected static void put(Table tbl, String key, Object obj) {
        if (obj != null) {
            tbl.put(key, obj);
        }
    }

    private static String toString(Position pos) {
        return pos == null ? null : "{ALT=" + pos.getAlt() + ",LAT=" + pos.getLat() + ",LON=" + pos.getLon() + "}";
    }

    static Table toTable(Location location) {
        Table tbl = new Table();
        String label = location.getLabel();
        Position pos = location.getPos();
        if (label != null) {
            tbl.put("LABEL", (Object)label);
        }
        if (pos != null) {
            tbl.put("POS", (Object)Vehicle.toString(pos));
        }
        tbl.put("ATTRIBUTES", (Object)location.getAttributes());
        if (location instanceof Site) {
            Site site = (Site)location;
            tbl.put("FLINK", site.getLinkFreq());
        }
        if (location instanceof PointingPos) {
            PointingPos ppos = (PointingPos)location;
            tbl.put("CANGLE", ppos.getConeAngle());
            tbl.put("RADIUS", ppos.getRadius());
        }
        return tbl;
    }

    static void setValues(Location location, Table tbl) {
        if (tbl != null) {
            Table attr = tbl.getTable("ATTRIBUTES");
            if (tbl.containsKey("POS")) {
                location.setPos(Vehicle.toPosition(tbl.getO("POS")));
            }
            if (tbl.containsKey("SV")) {
                location.setStateVector(tbl.getS("SV"));
            }
            if (tbl.containsKey("LABEL")) {
                location.setLabel(tbl.getS("LABEL"));
            }
            if (tbl.containsKey("RADIUS")) {
                location.setRadius(tbl.getD("RADIUS"));
            }
            if (attr != null) {
                location.getAttributes().merge(attr);
            }
            if (location instanceof Site) {
                Site site = (Site)location;
                if (tbl.containsKey("FLINK")) {
                    site.setLinkFreq(tbl.getD("FLINK"));
                }
            }
            if (location instanceof PointingPos) {
                PointingPos ppos = (PointingPos)location;
                if (tbl.containsKey("CANGLE")) {
                    ppos.setConeAngle(tbl.getD("CANGLE"));
                }
            }
        }
    }

    public static class PointingPosImpl
    extends LocationImpl
    implements PointingPos {
        protected double cangle;
        protected double[][] footprint;

        PointingPosImpl(Vehicle veh, String label) {
            this("PointingPos", veh, label);
        }

        protected PointingPosImpl(String className, Vehicle veh, String label) {
            super(className, veh, label);
        }

        @Override
        public double getConeAngle() {
            return this.cangle;
        }

        @Override
        public void setConeAngle(double value) {
            if (value != this.cangle) {
                this.cangle = value;
                this.refresh();
            }
        }

        @Override
        public double[][] getFootprint() {
            return this.footprint;
        }

        @Override
        public void setFootprint(double[][] fp) {
            if (fp != this.footprint) {
                this.footprint = fp;
                this.refresh();
            }
        }
    }

    public static class SiteImpl
    extends LocationImpl
    implements Site {
        protected double linkFreq;

        SiteImpl(Vehicle veh) {
            super("Site", veh, "SITE");
        }

        protected SiteImpl(String className, Vehicle veh) {
            super(className, veh, "SITE");
        }

        @Override
        public double getLinkFreq() {
            return this.linkFreq;
        }

        @Override
        public void setLinkFreq(double freq) {
            if (freq != this.linkFreq) {
                this.linkFreq = freq;
                this.refresh();
            }
        }
    }

    public static class LocationImpl
    implements Location {
        protected final String className;
        protected final Vehicle vehicle;
        protected final Table attributes;
        protected String label;
        protected Position pos;
        protected double radius;

        LocationImpl(Vehicle veh) {
            this("Location", veh, "LOCATION");
        }

        protected LocationImpl(Vehicle veh, String label) {
            this("Location", veh, label);
        }

        protected LocationImpl(String className, Vehicle veh, String label) {
            this.className = className;
            this.vehicle = veh;
            this.label = label;
            this.attributes = new Table();
            this.pos = new Position(1);
            this.attributes.addListener(veh.tblListener);
        }

        protected final Vehicle getVehicle() {
            return this.vehicle;
        }

        protected void refresh() {
            this.getVehicle().refresh();
        }

        public String toString() {
            return this.className + ": " + this.toTable();
        }

        @Override
        public void setValues(Table tbl) {
            Vehicle.setValues(this, tbl);
        }

        @Override
        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        @Override
        public Table toTable() {
            return Vehicle.toTable(this);
        }

        @Override
        public double getTime() {
            return this.pos == null ? Double.NaN : this.pos.getTime();
        }

        @Override
        public Position getPos() {
            return this.pos;
        }

        @Override
        public Table getAttributes() {
            return this.attributes;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public double getRadius() {
            return this.radius;
        }

        @Override
        public void setAttribute(String key, Object val) {
            if (val == null) {
                this.attributes.remove(key);
            } else {
                this.attributes.put(key, val);
            }
        }

        @Override
        public final void setPos(Table tbl) {
            this.setPos(Position.fromGeo(tbl));
        }

        @Override
        public final void setStateVector(StateVector sv) {
            this.setPos(sv);
        }

        @Override
        public final void setStateVector(String fname) {
            StateVector sv = new StateVector(this.vehicle.ref, (Object)fname);
            this.setStateVector(sv);
        }

        @Override
        public final void setPos(double alt, double lat, double lon) {
            this.setPos(Position.fromGeo(alt, lat, lon));
        }

        @Override
        public void setPos(Position p) {
            if (p != null && !this.equal(p, this.pos)) {
                this.pos = p;
                this.getVehicle().update(this);
                this.refresh();
            }
        }

        @Override
        public void setRadius(double value) {
            if (value != this.radius) {
                this.radius = value;
                this.refresh();
            }
        }

        @Override
        public void setTime(double time) {
            if (this.pos != null && time != this.getTime()) {
                this.pos.setTime(time);
                this.refresh();
            }
        }

        @Override
        public void setLabel(String lbl) {
            if (!this.equal(this.label, lbl)) {
                this.label = lbl;
                this.refresh();
            }
        }

        protected boolean equal(Object a, Object b) {
            return a == b || a != null && b != null && a.equals(b);
        }
    }

    public static interface PointingPos
    extends Location {
        @Override
        public Table toTable();

        @Override
        public void setValues(Table var1);

        public double getConeAngle();

        public void setConeAngle(double var1);

        public double[][] getFootprint();

        public void setFootprint(double[][] var1);
    }

    public static interface Site
    extends Location {
        @Override
        public Table toTable();

        public double getLinkFreq();

        public void setLinkFreq(double var1);
    }

    public static interface Location {
        public Table toTable();

        public void setValues(Table var1);

        public Position getPos();

        public void setPos(Position var1);

        public void setPos(Table var1);

        public void setPos(double var1, double var3, double var5);

        public void setStateVector(StateVector var1);

        public void setStateVector(String var1);

        public double getTime();

        public void setTime(double var1);

        public Table getAttributes();

        public Object getAttribute(String var1);

        public void setAttribute(String var1, Object var2);

        public String getLabel();

        public void setLabel(String var1);

        public double getRadius();

        public void setRadius(double var1);
    }

    private class TableListener
    implements Table.Listener {
        private TableListener() {
        }

        @Override
        public boolean putAction(String key, Object value) {
            Vehicle.this.refresh();
            return false;
        }

        @Override
        public boolean getAction(String key, Object value) {
            return false;
        }
    }
}

