/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.logging.Level;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.LogUtilities;

@InternalUseOnly
public class TuneAdjust {
    private double[] sbts;
    private double[] jtimes;
    private double ftif;
    private double xstartIF;
    private volatile boolean tuneAdjustAvailable = false;
    private double vrf;
    private double fnom;
    private double fs;
    private static double LO_CORRECTION_DEFAULT = 1.0;

    public TuneAdjust(Keywords kwds, double xstart, double ystart) {
        Double dNull = null;
        Double fsValue = kwds.getD("FS", dNull);
        Double vrfValue = kwds.getD("VRF", dNull);
        Double fnomValue = kwds.getD("FNOM", dNull);
        Double sbtFirstValue = kwds.getD("SBT_1", dNull);
        Double sbtOnlyValue = kwds.getD("SBT", dNull);
        boolean haveSBTSeries = sbtFirstValue != null;
        boolean haveSBTSingle = sbtOnlyValue != null;
        boolean haveNeeded = this.checkIfHaveNeededKeywords(fsValue, vrfValue, fnomValue, haveSBTSeries || haveSBTSingle);
        if (!haveNeeded) {
            return;
        }
        if (!haveSBTSeries) {
            this.jtimes = new double[1];
            this.sbts = new double[1];
            this.jtimes[0] = ystart;
            this.sbts[0] = sbtOnlyValue;
        } else {
            int numEntries = TuneAdjust.getNumSBTEntries(kwds);
            this.jtimes = new double[numEntries];
            this.sbts = new double[numEntries];
            int popEntries = this.populateJtimesSbts(kwds, sbtFirstValue);
            if (popEntries < numEntries) {
                this.resizeDueToMissingEntries(popEntries);
            }
        }
        double loCorrection = kwds.getD("LO_CORRECTION", LO_CORRECTION_DEFAULT);
        this.vrf = vrfValue * loCorrection;
        this.fnom = fnomValue;
        double rfOffset = this.vrf - this.fnom;
        this.ftif = this.sbts[0] - rfOffset;
        this.fs = fsValue;
        double halfRealRange = this.fs / 4.0;
        if (xstart <= halfRealRange) {
            this.xstartIF = xstart;
        } else {
            boolean complexIQ = xstart < rfOffset - halfRealRange;
            this.xstartIF = complexIQ ? -this.fs / 2.0 : 0.0;
        }
        this.tuneAdjustAvailable = true;
    }

    public Double getRF(double currentTime, double freqIF) {
        int iSBT;
        int srchIdx = Arrays.binarySearch(this.jtimes, currentTime);
        int n = iSBT = srchIdx >= 0 ? srchIdx : -(srchIdx + 1) - 1;
        if (iSBT < 0) {
            return null;
        }
        double currSBT = this.sbts[iSBT];
        double currRF = freqIF + currSBT - this.ftif;
        return currRF;
    }

    public double getXStartIF() {
        return this.xstartIF;
    }

    public boolean isTuneAdjustAvailable() {
        return this.tuneAdjustAvailable;
    }

    private int populateJtimesSbts(Keywords kwds, Double firstSBT) {
        int i = 0;
        int k = 1;
        Double currentSBT = firstSBT;
        Double dNull = null;
        do {
            this.sbts[i] = currentSBT;
            Double currentJTime = kwds.getD("JTIME_" + k, dNull);
            if (currentJTime != null) {
                this.jtimes[i] = currentJTime;
                ++i;
                continue;
            }
            LogUtilities.log(TuneAdjust.class, Level.WARNING, "Tune Adjustments: Missing JTIME_" + i + " entry - skipping this tune adjustment");
        } while ((currentSBT = kwds.getD("SBT_" + ++k, dNull)) != null);
        return i;
    }

    private void resizeDueToMissingEntries(int popEntries) {
        this.sbts = Arrays.copyOf(this.sbts, popEntries);
        this.jtimes = Arrays.copyOf(this.jtimes, popEntries);
        LogUtilities.log(TuneAdjust.class, Level.WARNING, "Tune Adjustments: only " + popEntries + " in effect");
    }

    private boolean checkIfHaveNeededKeywords(Double fsValue, Double vrfValue, Double fnomValue, boolean haveSBT) {
        if (fsValue == null || vrfValue == null || fnomValue == null || !haveSBT) {
            StringBuilder missingWarning = new StringBuilder("Ignoring Tune Adjustments, as the following required keywords are missing:");
            if (fsValue == null) {
                missingWarning.append(" FS,");
            }
            if (vrfValue == null) {
                missingWarning.append(" VRF,");
            }
            if (fnomValue == null) {
                missingWarning.append(" FNOM,");
            }
            if (fnomValue == null) {
                missingWarning.append(" SBT,");
            }
            missingWarning.deleteCharAt(missingWarning.length());
            LogUtilities.log(TuneAdjust.class, Level.WARNING, missingWarning.toString());
            return false;
        }
        return true;
    }

    private static int getNumSBTEntries(Keywords kwds) {
        String origScope = kwds.getScope();
        String[] sbtKeys = kwds.getKeys("EXT", "SBT_");
        kwds.setScope(origScope);
        return sbtKeys.length;
    }

    public String toString() {
        if (!this.tuneAdjustAvailable) {
            return "TuneAdjust not avilable - could not load required keywords";
        }
        String toString = "TuneAdjust IF XStart:" + this.xstartIF + " FTIF:" + this.ftif + " SBTs:" + Arrays.toString(this.sbts) + " JTIMEs:" + Arrays.toString(this.jtimes);
        return toString;
    }
}

