/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import nxm.sys.inc.Constants;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.TMatrix;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.Vector3D;

public class Transform
implements Constants {
    private static final double KNOTS2MS = 0.5144444444444445;
    private static final double GFORCE2MS2 = 9.80665;
    public static final String referenceFrameList = "None,ECR,ECI,TOP,TOPO";
    public static final int NONE = 1;
    public static final int ECR = 2;
    public static final int ECI = 3;
    public static final int TOP = 4;
    public static final int TOPO = 5;
    public static final String dataModeList = "Pos,PosVel,PosVelAcc";
    public static final int POS = 1;
    public static final int POSVEL = 2;
    public static final int POSVELACC = 3;
    private static final Transform Transform_ECR_CARTESIAN = new Transform(2, 2);
    private static final Transform Transform_ECR_GEODETIC = new Transform(2, 6);
    private int referenceFrame = 1;
    private int coordinateSystem = 2;
    private int unitsPos = 5;
    private int unitsVel = 6;
    private int unitsAcc = 7;
    private final Time epoch = new Time();
    private double lat;
    private double lon;
    private double alt;
    private double azim;
    private double elev;
    private double roll;
    private static final double INVERSE_SQRT_2 = 1.0 / Math.sqrt(2.0);
    private static final double INVERSE_EER = 1.567855942887398E-7;
    private static final double EARTH_EQUATORIAL_RADIUS_SQUARED = 4.0680631590769E13;
    private static final double EARTH_ECCENTRICITY_SQUARED = 0.0066943799901414;
    private static final double POLAR_FLATTENING_FACTOR = Math.sqrt(0.9933056200098586);
    private static final double INVERSE_POLAR_FLATENING_FACTOR = 1.0 / POLAR_FLATTENING_FACTOR;
    private static final double EARTH_EQUATORIAL_RADIUS_PLUS = 6388137.0;
    private static boolean useLegacyConeCode = false;
    private static boolean useSphericalConeCode = false;
    private static boolean compareConeCode = false;
    @InternalUseOnly
    public static int CONE_DEFAULT = 1;
    @InternalUseOnly
    public static int CONE_LEGACY = 2;
    @InternalUseOnly
    public static int CONE_SPHERE = 4;
    static String compareConeList = "Default,Legacy,Sphere";
    static int coneCodeComparisons = 3;
    private static boolean horizonAltDebug = false;

    public Transform(int refFrame, int coordSys) {
        this.referenceFrame = refFrame;
        this.coordinateSystem = coordSys;
    }

    public Transform() {
        this(1, 1);
    }

    public Transform(DataFile df) {
        this();
        this.fromDataFile(df);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Transform)) {
            return false;
        }
        Transform that = (Transform)obj;
        return this.referenceFrame == that.referenceFrame && this.coordinateSystem == that.coordinateSystem && this.unitsPos == that.unitsPos && this.unitsVel == that.unitsVel && this.unitsAcc == that.unitsAcc && this.epoch.equals(that.epoch) && this.lat == that.lat && this.lon == that.lon && this.alt == that.alt && this.azim == that.azim && this.elev == that.elev && this.roll == that.roll;
    }

    public int hashCode() {
        return this.referenceFrame ^ this.coordinateSystem << 4 ^ this.unitsPos << 8 ^ this.unitsVel << 16 ^ this.unitsAcc << 24 ^ this.epoch.hashCode() ^ Double.valueOf(this.lat).hashCode() ^ Double.valueOf(this.lon).hashCode() ^ Double.valueOf(this.alt).hashCode() ^ Double.valueOf(this.azim).hashCode() ^ Double.valueOf(this.elev).hashCode() ^ Double.valueOf(this.roll).hashCode();
    }

    public String toString() {
        String str = "Transform Ref=" + this.getReferenceFrame() + " CoordSys=" + this.getCoordinateSystem() + " PosUnits=" + this.getPosUnits() + " VelUnits=" + this.getVelUnits() + " AccUnits=" + this.getAccUnits();
        switch (this.referenceFrame) {
            case 4: {
                str = str + " alt=" + this.alt + " lat=" + this.lat + " lon=" + this.lon;
            }
        }
        return str;
    }

    public String getReferenceFrame() {
        return Parser.get(referenceFrameList, this.referenceFrame);
    }

    public String getCoordinateSystem() {
        return Parser.get("Scalar,Cartesian,Spherical,Cylindric,Ellipsoid,Geodetic,,,,Matrix", this.coordinateSystem);
    }

    public String getPosUnits() {
        return DataFile.getUnitsVarName(this.unitsPos);
    }

    public String getVelUnits() {
        return DataFile.getUnitsVarName(this.unitsVel);
    }

    public String getAccUnits() {
        return DataFile.getUnitsVarName(this.unitsAcc);
    }

    public boolean fromDataFile(DataFile df) {
        String frame = df.getReferenceFrame();
        this.referenceFrame = frame.startsWith("ECR") ? 2 : (frame.startsWith("ECI") ? 3 : (frame.startsWith("TOPO") ? 5 : (frame.startsWith("TOP") ? 4 : 1)));
        this.alt = df.getQuadword(1);
        this.lat = df.getQuadword(2);
        this.lon = df.getQuadword(3);
        this.azim = df.getQuadword(4);
        this.elev = df.getQuadword(5);
        this.roll = df.getQuadword(6);
        this.epoch.fromQuadwords(df);
        this.unitsPos = df.getUnits() != 0 ? df.getUnits() : 5;
        this.unitsVel = 6;
        this.unitsAcc = 7;
        int iPos = df.findRec("POS");
        int iVel = df.findRec("VEL");
        int iAcc = df.findRec("ACC");
        if (iPos >= 0) {
            this.coordinateSystem = df.getCompType(iPos);
            this.unitsPos = df.getCompUnits(iPos);
        }
        if (iVel >= 0) {
            this.unitsVel = df.getCompUnits(iVel);
        }
        if (iAcc >= 0) {
            this.unitsAcc = df.getCompUnits(iAcc);
        }
        if (this.referenceFrame == 1 && frame.isEmpty() && this.coordinateSystem == 6 && iPos >= 0 && iVel < 0 && iAcc < 0) {
            this.referenceFrame = 2;
        }
        return this.referenceFrame != 1;
    }

    public void toDataFile(DataFile df) {
        if (df.getTypeCodeClass() != 5) {
            throw new MidasException("Expected a Type 5000 file.");
        }
        if (this.referenceFrame == 3) {
            df.setReferenceFrame("ECI");
            df.setQuadword(1, 0.0);
            df.setQuadword(2, 0.0);
            df.setQuadword(3, 0.0);
            df.setQuadword(4, 0.0);
            df.setQuadword(5, 0.0);
            df.setQuadword(6, 0.0);
            df.setQuadword(7, 0.0);
            df.setQuadword(8, 0.0);
            df.setQuadword(9, this.epoch.getYear());
            df.setQuadword(10, this.epoch.getSoY());
            df.setQuadword(11, this.epoch.getGHA());
        } else if (this.referenceFrame == 2) {
            df.setReferenceFrame("ECR");
            df.setQuadword(1, 0.0);
            df.setQuadword(2, 0.0);
            df.setQuadword(3, 0.0);
            df.setQuadword(4, 0.0);
            df.setQuadword(5, 0.0);
            df.setQuadword(6, 0.0);
            df.setQuadword(7, 0.0);
            df.setQuadword(8, 0.0);
            df.setQuadword(9, 0.0);
            df.setQuadword(10, 0.0);
            df.setQuadword(11, 0.0);
        } else if (this.referenceFrame == 4 || this.referenceFrame == 5) {
            if (this.referenceFrame == 4) {
                df.setReferenceFrame("TOP");
            } else {
                df.setReferenceFrame("TOPOCENT");
            }
            df.setQuadword(1, this.alt);
            df.setQuadword(2, this.lat);
            df.setQuadword(3, this.lon);
            df.setQuadword(4, this.azim);
            df.setQuadword(5, this.elev);
            df.setQuadword(6, this.roll);
            df.setQuadword(7, 0.0);
            df.setQuadword(8, 0.0);
            df.setQuadword(9, 0.0);
            df.setQuadword(10, 0.0);
            df.setQuadword(11, 0.0);
        } else {
            throw new MidasException("Unknown reference frame: " + this.referenceFrame);
        }
    }

    public static Transform toTransform(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Transform) {
            return (Transform)obj;
        }
        if (obj instanceof DataFile) {
            return new Transform((DataFile)obj);
        }
        if (obj instanceof Number) {
            switch (((Number)obj).intValue()) {
                case 1: {
                    return new Transform(1, 2);
                }
                case 2: {
                    return new Transform(2, 2);
                }
                case 3: {
                    return new Transform(3, 2);
                }
                case 4: {
                    return new Transform(4, 2);
                }
                case 5: {
                    return new Transform(5, 2);
                }
            }
        } else if (!(obj instanceof Tablizable)) {
            if ("NONE".equals(obj = obj.toString())) {
                return new Transform(1, 2);
            }
            if ("ECR".equals(obj)) {
                return new Transform(2, 2);
            }
            if ("ECI".equals(obj)) {
                return new Transform(3, 2);
            }
            if ("TOP".equals(obj)) {
                return new Transform(4, 2);
            }
            if ("TOPOCENT".equals(obj)) {
                return new Transform(5, 2);
            }
        }
        throw new IllegalArgumentException("Could not convert " + obj + " to Transform");
    }

    public final void setTOP(double alt, double lat, double lon) {
        this.setTOP(alt, lat, lon, 0.0, 0.0, 0.0);
    }

    public void setTOP(double alt, double lat, double lon, double azim, double elev, double roll) {
        this.referenceFrame = 4;
        this.coordinateSystem = 2;
        this.alt = alt;
        this.lat = lat;
        this.lon = lon;
        this.azim = azim;
        this.elev = elev;
        this.roll = roll;
    }

    public void setECR() {
        this.referenceFrame = 2;
        this.coordinateSystem = 2;
    }

    public void setECI(Time epoch) {
        this.referenceFrame = 3;
        this.coordinateSystem = 2;
        this.setEpoch(epoch);
    }

    public void setEpoch(Time epoch) {
        this.epoch.fromTime(epoch);
    }

    public static void geo2car(Position p) {
        double f1 = 0.99664718933526;
        double f2 = 0.006694379990126406;
        double rlat = Math.atan(Math.tan(p.lat * (Math.PI / 180)) * f1 * f1);
        double rlon = p.lon * (Math.PI / 180);
        double slat = Math.sin(rlat);
        double clat = Math.cos(rlat);
        double slon = Math.sin(rlon);
        double clon = Math.cos(rlon);
        p.r = 6378137.0 * f1 / Math.sqrt(1.0 - f2 * clat * clat) + p.alt;
        p.x = p.r * clat * clon;
        p.y = p.r * clat * slon;
        p.z = p.r * slat;
        if (p instanceof StateVector) {
            StateVector sv = (StateVector)p;
            double[] v = new double[]{sv.x, sv.y, sv.z, sv.ve, sv.vn, sv.vu, sv.ae, sv.an, sv.au};
            Transform t = new Transform();
            t.setTOP(p.alt, p.lat, p.lon);
            Transform.top2ecef(v, 3, 1, t);
            sv.vx = v[3];
            sv.vy = v[4];
            sv.vz = v[5];
            sv.ax = v[6];
            sv.ay = v[7];
            sv.az = v[8];
        }
    }

    public static void car2geo(Position p) {
        double f1 = 0.99664718933526;
        double f2 = 0.006694379990126406;
        p.r = Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        double a = Math.asin(p.z / p.r);
        double ca = Math.cos(a);
        p.alt = p.r - 6378137.0 * f1 / Math.sqrt(1.0 - f2 * ca * ca);
        p.lat = 57.29577951308232 * Math.atan(Math.tan(a) / (f1 * f1));
        p.lon = 57.29577951308232 * Math.atan2(p.y, p.x);
        if (p instanceof StateVector) {
            StateVector sv = (StateVector)p;
            double[] v = new double[]{sv.x, sv.y, sv.z, sv.vx, sv.vy, sv.vz, sv.ax, sv.ay, sv.az};
            Transform t = new Transform();
            t.setTOP(p.alt, p.lat, p.lon);
            Transform.ecef2top(v, 3, 1, t);
            sv.ve = v[3];
            sv.vn = v[4];
            sv.vu = v[5];
            sv.ae = v[6];
            sv.an = v[7];
            sv.au = v[8];
        }
    }

    public static double greatArc(Position p, Position q) {
        Transform.geo2car(p);
        Transform.geo2car(q);
        double r = 0.0;
        double r2 = p.r * q.r;
        if (r2 > 1.0E-20) {
            r = (p.x * q.x + p.y * q.y + p.z * q.z) / r2;
        }
        r = Math.min(1.0, Math.max(-1.0, r));
        r = Math.acos(r) * 6378137.0;
        return r;
    }

    public static void sph2car(double[] v, int mpva, int nrec) {
        int isk = 3 * mpva;
        int i = 0;
        int n = 0;
        while (n < nrec) {
            double r = v[i + 0];
            double a = v[i + 1] * (Math.PI / 180);
            double b = v[i + 2] * (Math.PI / 180);
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            double cb = Math.cos(b);
            double sb = Math.sin(b);
            v[i + 0] = r * cb * ca;
            v[i + 1] = r * cb * sa;
            v[i + 2] = r * sb;
            if (mpva > 1) {
                double rr = v[i + 3];
                double aa = v[i + 4] * (Math.PI / 180);
                double bb = v[i + 5] * (Math.PI / 180);
                double ri = rr / r;
                v[i + 3] = v[i + 0] * ri - v[i + 2] * bb * ca - v[i + 1] * aa;
                v[i + 4] = v[i + 1] * ri - v[i + 2] * bb * sa + v[i + 0] * aa;
                v[i + 5] = v[i + 2] * ri + r * bb * cb;
                if (mpva > 2) {
                    double rrr = v[i + 6];
                    double aaa = v[i + 7] * (Math.PI / 180);
                    double bbb = v[i + 8] * (Math.PI / 180);
                    double rri = rrr / r;
                    v[i + 6] = (v[i + 3] - v[i + 0] * ri) * ri + v[i + 0] * rri - (v[i + 5] * bb + v[i + 2] * bbb) * ca + v[i + 2] * bb * aa * sa - v[i + 1] * aaa - v[i + 4] * aa;
                    v[i + 7] = (v[i + 4] - v[i + 1] * ri) * ri + v[i + 1] * rri - (v[i + 5] * bb + v[i + 2] * bbb) * sa - v[i + 2] * bb * aa * ca - v[i + 0] * aaa + v[i + 3] * aa;
                    v[i + 8] = (v[i + 5] - v[i + 2] * ri) * ri + v[i + 1] * rri + (rr * bb + r * bbb) * ca + v[i + 2] * bb * bb;
                }
            }
            ++n;
            i += isk;
        }
    }

    public static void geo2car(double[] v, int mpva, int nrec) {
        double ee = 0.0066943799901414;
        int isk = 3 * mpva;
        int i = 0;
        int n = 0;
        while (n < nrec) {
            double r = v[i + 0];
            double a = v[i + 1] * (Math.PI / 180);
            double b = v[i + 2] * (Math.PI / 180);
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            double cb = Math.cos(b);
            double sb = Math.sin(b);
            double t = 6378137.0 / Math.sqrt(1.0 - ee * sa * sa);
            v[i + 0] = (r + t) * cb * ca;
            v[i + 1] = (r + t) * ca * sb;
            v[i + 2] = (r + (1.0 - ee) * t) * sa;
            if (mpva <= 1) {
                // empty if block
            }
            ++n;
            i += isk;
        }
    }

    public static double[] lonlat2car(double[] v, int ioff, int npts) {
        double[] car = new double[npts * 3];
        double ee = 0.0066943799901414;
        int i = ioff;
        int j = 0;
        int n = 0;
        while (n < npts) {
            double r = 0.0;
            double a = v[i + 1] * (Math.PI / 180);
            double b = v[i] * (Math.PI / 180);
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            double cb = Math.cos(b);
            double sb = Math.sin(b);
            double t = 6378137.0 / Math.sqrt(1.0 - ee * sa * sa);
            car[j++] = (r + t) * cb * ca;
            car[j++] = (r + t) * ca * sb;
            car[j++] = (r + (1.0 - ee) * t) * sa;
            ++n;
            i += 2;
        }
        return car;
    }

    public static void cyl2car(double[] v, int mpva, int nrec) {
        Shell.warning("Transform.cyl2car is not yet coded");
    }

    public static void ell2car(double[] v, int mpva, int nrec) {
        Shell.warning("Transform.ell2car is not yet coded");
    }

    public static void ecr2eci(double[] v, int mpva, int nrec, double[] gha) {
        Transform.eci2ecef(v, mpva, nrec, gha, false);
    }

    public static void ecef2eci(double[] v, int mpva, int nrec, double[] gha) {
        Transform.eci2ecef(v, mpva, nrec, gha, false);
    }

    public static void eci2top(double[] v, int mpva, int nrec, Transform from, Transform to, double[] gha) {
        Transform.eci2ecef(v, mpva, nrec, gha);
        Transform.ecef2top(v, mpva, nrec, to);
    }

    public static void eci2ecr(double[] v, int mpva, int nrec, double[] gha) {
        Transform.eci2ecef(v, mpva, nrec, gha, true);
    }

    public static void eci2ecef(double[] v, int mpva, int nrec, double[] gha) {
        Transform.eci2ecef(v, mpva, nrec, gha, true);
    }

    static void eci2ecef(double[] v, int mpva, int nrec, double[] gha, boolean toECEF) {
        int dir = toECEF ? 1 : -1;
        int isk = 3 * mpva;
        double eav = (double)dir * 7.2921158553E-5;
        double eavt = eav + eav;
        double eav2 = eav * eav;
        int i = 0;
        int n = 0;
        while (n < nrec) {
            double sa = Math.sin(gha[n]);
            double ca = Math.cos(gha[n]);
            if (dir < 0) {
                sa = -sa;
            }
            double x = v[i + 0];
            double y = v[i + 1];
            v[i + 0] = ca * x + sa * y;
            v[i + 1] = -sa * x + ca * y;
            if (mpva > 1) {
                double xx = v[i + 3];
                double yy = v[i + 4];
                v[i + 3] = ca * xx + sa * yy + eav * (-sa * x + ca * y);
                v[i + 4] = -sa * xx + ca * yy + eav * (-ca * x - sa * y);
                if (mpva > 2) {
                    double xxx = v[i + 6];
                    double yyy = v[i + 7];
                    v[i + 6] = ca * xxx + sa * yyy + eavt * (-sa * xx + ca * yy) + eav2 * (-ca * x - sa * y);
                    v[i + 7] = -sa * xxx + ca * yyy + eavt * (-ca * xx - sa * yy) + eav2 * (sa * x - ca * y);
                }
            }
            ++n;
            i += isk;
        }
    }

    public static void top2eci(double[] v, int mpva, int nrec, Transform from, Transform to, double[] gha) {
        Transform.top2ecef(v, mpva, nrec, from);
        Transform.ecr2eci(v, mpva, nrec, gha);
    }

    public static void top2ecef(double[] v, int mpva, int nrec, Transform from) {
        TMatrix tm = Transform.top2ecrTMatrix(from);
        Transform.matrixVectorMultiply(tm, v, mpva, nrec);
    }

    public static void top2ecr(double[] v, int mpva, int nrec, Transform from) {
        Transform.top2ecef(v, mpva, nrec, from);
    }

    public static void top2top(double[] v, int mpva, int nrec, Transform from, Transform to) {
        TMatrix tm = Transform.top2ecrTMatrix(from);
        TMatrix tn = Transform.top2ecrTMatrix(to);
        tn.transpose();
        tn.multiply(tm);
        Transform.matrixVectorMultiply(tn, v, mpva, nrec);
    }

    public static void ecef2top(double[] v, int mpva, int nrec, Transform to) {
        TMatrix tm = Transform.top2ecrTMatrix(to);
        tm.transpose();
        Transform.matrixVectorMultiply(tm, v, mpva, nrec);
    }

    public static void ecr2top(double[] v, int mpva, int nrec, Transform to) {
        Transform.ecef2top(v, mpva, nrec, to);
    }

    public static void car2sph(double[] v, int mpva, int nrec) {
        int isk = 3 * mpva;
        int i = 0;
        int n = 0;
        while (n < nrec) {
            if (v[i] != 0.0 || v[i + 1] != 0.0 || v[i + 2] != 0.0) {
                double x = v[i + 0];
                double y = v[i + 1];
                double z = v[i + 2];
                double r = Math.sqrt(x * x + y * y + z * z);
                double ri = 1.0 / r;
                v[i + 0] = r;
                v[i + 1] = Math.atan2(y, x) * 57.29577951308232;
                v[i + 2] = Math.asin(z * ri) * 57.29577951308232;
                if (mpva > 1) {
                    double xx = v[i + 3];
                    double yy = v[i + 4];
                    double zz = v[i + 5];
                    double si2 = Math.sqrt(x * x + y * y);
                    double si = Math.sqrt(si2);
                    v[i + 3] = (x * xx + y * yy + z * zz) * ri;
                    v[i + 4] = (x * yy - xx * y) * si2 * 57.29577951308232;
                    v[i + 5] = (zz - z * v[i + 3] * ri) * si * 57.29577951308232;
                    if (mpva > 2) {
                        double xxx = v[i + 6];
                        double yyy = v[i + 7];
                        double zzz = v[i + 8];
                        v[i + 6] = (xx * xx + yy * yy + zz * zz + x * xxx + y * yyy + z * zzz - v[i + 3] * v[i + 3]) * ri;
                        v[i + 7] = ((x * yyy - xxx * y) * 57.29577951308232 - 2.0 * v[i + 4] * (x * xx + y * yy)) * si2;
                        v[i + 8] = (zzz - zz * v[i + 3] * ri - z * (v[i + 6] * ri - v[i + 3] * ri * (v[i + 3] * ri))) * si * 57.29577951308232 - v[i + 5] * (x * xx + y * yy) * si2;
                    }
                }
            }
            ++n;
            i += isk;
        }
    }

    @Deprecated
    public static void fsu2fsu(double[] v, int mpva, int nrec, Transform from, Transform to) {
        Shell.warning("Transform.fsu2fsu is not yet coded");
    }

    public static void fsu2fsu(double[] v, int mpva, Transform from, Transform to, Time epoch) {
        Transform.fsu2fsu(v, mpva, 1, from, to, null, epoch);
    }

    public static void fsu2fsu(double[] v, int mpva, int nrec, Transform from, Transform to, double[] gha) {
        Transform.fsu2fsu(v, mpva, nrec, from, to, gha, null);
    }

    private static void fsu2fsu(double[] v, int mpva, int nrec, Transform from, Transform to, double[] gha, Time epoch) {
        if (from == null || to == null || from.equals(to)) {
            return;
        }
        int fromRef = from.referenceFrame;
        int toRef = to.referenceFrame;
        switch (mpva) {
            case 3: {
                Transform.fixUnits(v, mpva, nrec, 6, from.unitsAcc, true);
            }
            case 2: {
                Transform.fixUnits(v, mpva, nrec, 3, from.unitsVel, true);
            }
            case 1: {
                Transform.fixUnits(v, mpva, nrec, 0, from.unitsPos, true);
            }
        }
        switch (from.coordinateSystem) {
            case 2: {
                break;
            }
            case 3: {
                Transform.sph2car(v, mpva, nrec);
                fromRef = 2;
                break;
            }
            case 6: {
                Transform.geo2car(v, mpva, nrec);
                fromRef = 2;
                break;
            }
            default: {
                throw new MidasException("Unsupported conversion " + from.getCoordinateSystem() + " to CARTESIAN to " + to.getCoordinateSystem());
            }
        }
        switch (to.coordinateSystem) {
            case 2: {
                break;
            }
            case 3: {
                toRef = 2;
                break;
            }
            case 6: {
                toRef = 2;
                break;
            }
            default: {
                throw new MidasException("Unsupported conversion " + from.getCoordinateSystem() + " to CARTESIAN to " + to.getCoordinateSystem());
            }
        }
        if (fromRef != toRef || fromRef == 4 || fromRef == 5) {
            if (gha == null && epoch != null) {
                gha = new double[]{epoch.getGHA()};
            }
            switch (fromRef + toRef * 100) {
                case 302: {
                    Transform.ecr2eci(v, mpva, nrec, gha);
                    break;
                }
                case 402: {
                    Transform.ecef2top(v, mpva, nrec, to);
                    break;
                }
                case 502: {
                    Transform.ecef2top(v, mpva, nrec, to);
                    break;
                }
                case 203: {
                    Transform.eci2ecr(v, mpva, nrec, gha);
                    break;
                }
                case 403: {
                    Transform.eci2top(v, mpva, nrec, from, to, gha);
                    break;
                }
                case 503: {
                    Transform.eci2top(v, mpva, nrec, from, to, gha);
                    break;
                }
                case 204: {
                    Transform.top2ecef(v, mpva, nrec, from);
                    break;
                }
                case 304: {
                    Transform.top2eci(v, mpva, nrec, from, to, gha);
                    break;
                }
                case 404: {
                    Transform.top2top(v, mpva, nrec, from, to);
                    break;
                }
                case 504: {
                    Transform.top2top(v, mpva, nrec, from, to);
                    break;
                }
                case 205: {
                    Transform.top2ecef(v, mpva, nrec, from);
                    break;
                }
                case 305: {
                    Transform.top2eci(v, mpva, nrec, from, to, gha);
                    break;
                }
                case 405: {
                    Transform.top2top(v, mpva, nrec, from, to);
                    break;
                }
                case 505: {
                    Transform.top2top(v, mpva, nrec, from, to);
                    break;
                }
                default: {
                    throw new MidasException("Unsupported conversion " + from.getReferenceFrame() + " to " + to.getReferenceFrame());
                }
            }
        }
        switch (to.coordinateSystem) {
            case 3: {
                Transform.car2sph(v, mpva, nrec);
                break;
            }
            case 4: {
                Transform.car2cyl(v, mpva, nrec);
                break;
            }
            case 5: {
                Transform.car2ell(v, mpva, nrec);
                break;
            }
            case 6: {
                Transform.car2geo(v, mpva, nrec);
            }
        }
        switch (mpva) {
            case 3: {
                Transform.fixUnits(v, mpva, nrec, 6, to.unitsAcc, false);
            }
            case 2: {
                Transform.fixUnits(v, mpva, nrec, 3, to.unitsVel, false);
            }
            case 1: {
                Transform.fixUnits(v, mpva, nrec, 0, to.unitsPos, false);
            }
        }
    }

    @InternalUseOnly
    public static void fsu2fsu(Table tbl, Transform from, Transform to, Double gha) {
        double[] dArray;
        double[] pos;
        double[] vel;
        int mpva = 3;
        double[] acc = Convert.o2da(tbl.get("ACC"));
        if (acc == null) {
            mpva = 2;
        }
        if ((vel = Convert.o2da(tbl.get("VEL"))) == null) {
            mpva = 1;
        }
        if ((pos = Convert.o2da(tbl.get("POS"))) == null) {
            return;
        }
        if (gha == null) {
            dArray = null;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = gha;
        }
        double[] _gha = dArray;
        double[] v = new double[9];
        switch (mpva) {
            case 3: {
                System.arraycopy(acc, 0, v, 6, 3);
            }
            case 2: {
                System.arraycopy(vel, 0, v, 3, 3);
            }
            case 1: {
                System.arraycopy(pos, 0, v, 0, 3);
            }
        }
        Transform.fsu2fsu(v, mpva, 1, from, to, _gha);
        switch (mpva) {
            case 3: {
                System.arraycopy(v, 6, acc, 0, 3);
                tbl.put("ACC", (Object)acc);
            }
            case 2: {
                System.arraycopy(v, 3, vel, 0, 3);
                tbl.put("VEL", (Object)vel);
            }
            case 1: {
                System.arraycopy(v, 0, pos, 0, 3);
                tbl.put("POS", (Object)pos);
            }
        }
    }

    private static void fixUnits(double[] v, int mpva, int nrec, int off, int units, boolean toSI) {
        double mult = 0.0;
        switch (units) {
            case 5: {
                return;
            }
            case 40: {
                mult = 0.3048;
                break;
            }
            case 41: {
                mult = 1852.0;
                break;
            }
            case 6: {
                return;
            }
            case 42: {
                mult = 0.3048;
                break;
            }
            case 43: {
                mult = 1852.0;
                break;
            }
            case 44: {
                mult = 0.5144444444444445;
                break;
            }
            case 7: {
                return;
            }
            case 45: {
                mult = 0.3048;
                break;
            }
            case 46: {
                mult = 1852.0;
                break;
            }
            case 47: {
                mult = 0.5144444444444445;
                break;
            }
            case 48: {
                mult = 9.80665;
                break;
            }
            case 63: {
                return;
            }
            case 62: {
                mult = 0.3048;
            }
        }
        if (mult == 0.0) {
            String name = DataFile.getUnitsVarName(units);
            if (toSI) {
                throw new MidasException("Can not convert " + name + " to SI units");
            }
            throw new MidasException("Can not convert SI units to " + name);
        }
        if (!toSI) {
            mult = 1.0 / mult;
        }
        for (int i = 0; i < nrec; ++i) {
            int n = off++;
            v[n] = v[n] * mult;
            int n2 = off++;
            v[n2] = v[n2] * mult;
            int n3 = off++;
            v[n3] = v[n3] * mult;
            off += (mpva - 1) * 3;
        }
    }

    public int toLonLatAlt(double[] v, int nrec) {
        if (this.referenceFrame == 4 || this.referenceFrame == 5) {
            Transform.top2ecef(v, 1, nrec, this);
        }
        if (this.coordinateSystem == 2) {
            Transform.car2geo(v, 1, nrec);
        }
        Transform.all2lla(v, nrec);
        return nrec;
    }

    public int fromLonLatAlt(double[] v, int nrec) {
        Transform.lla2all(v, nrec);
        Transform.fsu2fsu(v, 1, nrec, Transform_ECR_GEODETIC, this, null, null);
        return nrec;
    }

    public static int all2lla(double[] v, int nrec) {
        int n = 0;
        int i = 0;
        while (n < nrec) {
            double tmp = v[i + 0];
            v[i + 0] = v[i + 2];
            v[i + 2] = tmp;
            ++n;
            i += 3;
        }
        return nrec;
    }

    private static int lla2all(double[] v, int nrec) {
        return Transform.all2lla(v, nrec);
    }

    public static int clipAtEarth(double[] v, int ioff, int nrec, double[] vo, int mode) {
        double xe = 6378137.0;
        double ye = 6378137.0;
        double ze = xe * Math.sqrt(0.9933056200098586);
        double xei = 1.0 / xe;
        double yei = 1.0 / ye;
        double zei = 1.0 / ze;
        double xo = xei * vo[0];
        double yo = yei * vo[1];
        double zo = zei * vo[2];
        int n = 0;
        int i = ioff;
        while (n < nrec) {
            double xd = xei * v[i + 0] - xo;
            double yd = yei * v[i + 1] - yo;
            double zd = zei * v[i + 2] - zo;
            double pdd = xd * xd + yd * yd + zd * zd;
            double pod = xo * xd + yo * yd + zo * zd;
            double poo = xo * xo + yo * yo + zo * zo;
            double qA = pdd;
            if (!(qA < 1.0E-30)) {
                double p;
                double qSR;
                double qB = 2.0 * pod;
                double qR = qB / (qA * 2.0);
                double qC = poo - 1.0;
                double qS = qC / qA;
                if (qR * qR > qS) {
                    qSR = Math.sqrt(qR * qR - qS);
                    p = -qR - qSR;
                    if (mode == 1 || p > 0.0 && p < 1.0) {
                        v[i + 0] = (xo + p * xd) * xe;
                        v[i + 1] = (yo + p * yd) * ye;
                        v[i + 2] = (zo + p * zd) * ze;
                    }
                } else if (mode == 1) {
                    qB = 2.0 * pod * (poo - 1.0);
                    qA = pod * pod - pdd;
                    qR = qB / (qA * 2.0);
                    qC = poo * (poo - 1.0);
                    qS = qC / qA;
                    qSR = qR * qR - qS;
                    qSR = qSR > 0.0 ? Math.sqrt(qSR) : 0.0;
                    p = qR > 0.0 ? -qR + qSR : -qR - qSR;
                    v[i + 0] = (xo + p * xd) * xe;
                    v[i + 1] = (yo + p * yd) * ye;
                    v[i + 2] = (zo + p * zd) * ze;
                }
            }
            ++n;
            i += 3;
        }
        return nrec;
    }

    public static int clipAtEarth(double[] v, int ioff, int nrec, double[] vo, int mode, boolean trimToGeoSurface, Position viewer, double angle) {
        boolean legacyOnlyMode = Transform.getUseLegacyConeCode();
        boolean preciseHorizonExtension = !legacyOnlyMode && !Transform.getUseSphericalConeCode();
        double[] viewerXYZ = null;
        double distViewer2CenterEarth = 0.0;
        double[] vcHat = null;
        double horizonDistanceSpherical = 0.0;
        if (!legacyOnlyMode) {
            double[] dArray = new double[]{viewer.getX(), viewer.getY(), viewer.getZ()};
            viewerXYZ = dArray;
            double distViewer2CenterEarthSquared = Vector3D.dotProduct(viewerXYZ, viewerXYZ);
            double distFromEarthSurface = distViewer2CenterEarthSquared - 4.0680631590769E13;
            if (distFromEarthSurface > 0.0) {
                distViewer2CenterEarth = Math.sqrt(distViewer2CenterEarthSquared);
                vcHat = Vector3D.norm(viewerXYZ, distViewer2CenterEarth);
                horizonDistanceSpherical = Math.sqrt(distFromEarthSurface);
            } else {
                preciseHorizonExtension = false;
                legacyOnlyMode = true;
            }
        }
        double xe = 6378137.0;
        double ye = 6378137.0;
        double ze = xe * Math.sqrt(0.9933056200098586);
        double xei = 1.0 / xe;
        double yei = 1.0 / ye;
        double zei = 1.0 / ze;
        double xo = xei * vo[0];
        double yo = yei * vo[1];
        double zo = zei * vo[2];
        double poo = xo * xo + yo * yo + zo * zo;
        int n = 0;
        int i = ioff;
        while (n < nrec) {
            double xd = xei * v[i + 0] - xo;
            double yd = yei * v[i + 1] - yo;
            double zd = zei * v[i + 2] - zo;
            double pdd = xd * xd + yd * yd + zd * zd;
            double pod = xo * xd + yo * yd + zo * zd;
            double qA = pdd;
            if (!(qA < 1.0E-30)) {
                double p;
                double qSR;
                double qB = 2.0 * pod;
                double qR = qB / (qA * 2.0);
                double qC = poo - 1.0;
                double qS = qC / qA;
                if (qR * qR > qS) {
                    qSR = Math.sqrt(qR * qR - qS);
                    p = -qR - qSR;
                    if (mode == 1 || p > 0.0 && p < 1.0) {
                        v[i + 0] = (xo + p * xd) * xe;
                        v[i + 1] = (yo + p * yd) * ye;
                        v[i + 2] = (zo + p * zd) * ze;
                    }
                } else if (mode == 1) {
                    double[] pt2Clip;
                    double[] extendedPoint;
                    boolean pointHasBeenExtended = false;
                    if (preciseHorizonExtension && (extendedPoint = Transform.oblateEarthConeToHorizon(vcHat, distViewer2CenterEarth, viewerXYZ, pt2Clip = new double[]{v[i + 0], v[i + 1], v[i + 2]}, trimToGeoSurface)) != null) {
                        v[i + 0] = extendedPoint[0];
                        v[i + 1] = extendedPoint[1];
                        v[i + 2] = extendedPoint[2];
                        pointHasBeenExtended = true;
                    }
                    if (!pointHasBeenExtended) {
                        qB = 2.0 * pod * (poo - 1.0);
                        qA = pod * pod - pdd;
                        qR = qB / (qA * 2.0);
                        qC = poo * (poo - 1.0);
                        qS = qC / qA;
                        qSR = qR * qR - qS;
                        qSR = qSR > 0.0 ? Math.sqrt(qSR) : 0.0;
                        p = qR > 0.0 ? -qR + qSR : -qR - qSR;
                        double clippedX = (xo + p * xd) * xe;
                        double clippedY = (yo + p * yd) * ye;
                        double clippedZ = (zo + p * zd) * ze;
                        double newRadius = Math.sqrt(clippedX * clippedX + clippedY * clippedY + clippedZ * clippedZ);
                        if (legacyOnlyMode || newRadius <= 6388137.0) {
                            v[i + 0] = (xo + p * xd) * xe;
                            v[i + 1] = (yo + p * yd) * ye;
                            v[i + 2] = (zo + p * zd) * ze;
                        } else {
                            double[] pt2Clip2 = new double[]{v[i + 0], v[i + 1], v[i + 2]};
                            double[] geosurfacePoint = Transform.sphericalEarthConeToHorizon(vcHat, 1.0 / distViewer2CenterEarth, viewerXYZ, pt2Clip2, horizonDistanceSpherical, trimToGeoSurface);
                            v[i + 0] = geosurfacePoint[0];
                            v[i + 1] = geosurfacePoint[1];
                            v[i + 2] = geosurfacePoint[2];
                        }
                    }
                }
            }
            ++n;
            i += 3;
        }
        return nrec;
    }

    @InternalUseOnly(value="Prototype version - use at your own risk")
    public static double[] hzn2AltHzn(double[] hznPts, int ioff, int npts, Position vo, double alt) {
        if (horizonAltDebug) {
            System.out.println("Using more traditional ray intersect sphere math hzn2AltHzn method alttitude=" + alt);
        }
        double[] hznAtAltPts = new double[npts * 3];
        double xe = 6378137.0 + alt;
        double ye = 6378137.0 + alt;
        double ze = xe * Math.sqrt(0.9933056200098586) + alt;
        double xei = 1.0 / xe;
        double yei = 1.0 / ye;
        double zei = 1.0 / ze;
        double xo = xei * vo.x;
        double yo = yei * vo.y;
        double zo = zei * vo.z;
        double[] viewerVec = new double[]{xo, yo, zo};
        int n = 0;
        int i = ioff;
        while (n < npts) {
            double poo;
            double qC;
            double xd = xei * hznPts[i + 0] - xo;
            double yd = yei * hznPts[i + 1] - yo;
            double zd = zei * hznPts[i + 2] - zo;
            double[] scaledHzn = new double[]{xei * hznPts[i + 0], yei * hznPts[i + 1], zei * hznPts[i + 2]};
            double[] h2oVec = new double[]{xd, yd, zd};
            double h2oMag = Vector3D.mag(h2oVec);
            double[] h2oUnitVec = Vector3D.norm(h2oVec);
            double pod = Vector3D.dotProduct(h2oUnitVec, viewerVec);
            double qB = 2.0 * pod;
            double qR = qB / 2.0;
            if (qR * qR > (qC = (poo = Vector3D.dotProduct(viewerVec, viewerVec)) - 1.0)) {
                double qSR = Math.sqrt(qR * qR - qC);
                double p1 = -qR - qSR;
                double p2 = -qR + qSR;
                if (horizonAltDebug) {
                    System.out.println("p1:" + p1 + " p2:" + p2 + " h2oMag:" + h2oMag);
                }
                if (p1 + 0.001 < h2oMag) {
                    double pnow = ioff == 0 ? p2 : p2;
                    hznAtAltPts[i + 0] = (xo + pnow * h2oUnitVec[0]) * xe;
                    hznAtAltPts[i + 1] = (yo + pnow * h2oUnitVec[1]) * ye;
                    hznAtAltPts[i + 2] = (zo + pnow * h2oUnitVec[2]) * ze;
                    if (horizonAltDebug) {
                        System.out.println("scaledHorizon:" + Arrays.toString(scaledHzn));
                        System.out.println("scaledHorizonAtAlt x=" + (xo + p2 * h2oUnitVec[0]) + " y=" + (yo + p2 * h2oUnitVec[1]) + " z=" + (zo + p2 * h2oUnitVec[2]));
                        Position hznPos = new Position();
                        hznPos.setCar(hznPts[i + 0], hznPts[i + 1], hznPts[i + 2]);
                        Position hznAtAlt = new Position();
                        hznAtAlt.setCar(hznAtAltPts[i + 0], hznAtAltPts[i + 1], hznAtAltPts[i + 2]);
                        System.out.println("Position hzn:" + hznPos.toString(1));
                        System.out.println("Position hznAtAlt:" + hznAtAlt.toString(1));
                    }
                }
            } else {
                hznAtAltPts[i + 0] = hznPts[i + 0];
                hznAtAltPts[i + 1] = hznPts[i + 1];
                hznAtAltPts[i + 2] = hznPts[i + 2];
            }
            ++n;
            i += 3;
        }
        return hznAtAltPts;
    }

    @InternalUseOnly(value="Prototype version - use at your own risk")
    public static double[] horizon2HorizonAtAlt(double[] horizonPtsECEF, int ioff, int npts, double alt, Position observer) {
        if (horizonAltDebug) {
            System.out.println("Using more visual math horizon2HorizonAtAlt method altitude=" + alt);
        }
        double[] horizonAtAlt = new double[npts * 3];
        double xOfAlt = 6378137.0 + alt;
        double yOfAlt = 6378137.0 + alt;
        double zOfAlt = 6378137.0 * Math.sqrt(0.9933056200098586) + alt;
        double xOfAltInv = 1.0 / xOfAlt;
        double yOfAltInv = 1.0 / yOfAlt;
        double zOfAltInv = 1.0 / zOfAlt;
        double xo = xOfAltInv * observer.x;
        double yo = yOfAltInv * observer.y;
        double zo = zOfAltInv * observer.z;
        double[] ob2ctrVec = new double[]{-xo, -yo, -zo};
        double ob2Ctr2 = xo * xo + yo * yo + zo * zo;
        int i = ioff;
        for (int n = 0; n < npts; ++n) {
            double pDotOb2HznVector;
            double xh = xOfAltInv * horizonPtsECEF[i + 0];
            double yh = yOfAltInv * horizonPtsECEF[i + 1];
            double zh = zOfAltInv * horizonPtsECEF[i + 2];
            double[] scaledHznPts = new double[]{xh, yh, zh};
            double xdOb2Hzn = xh - xo;
            double ydOb2Hzn = yh - yo;
            double zdOb2Hzn = zh - zo;
            double[] dOb2Hzn = new double[]{xdOb2Hzn, ydOb2Hzn, zdOb2Hzn};
            double ob2HzDist = Vector3D.mag(dOb2Hzn);
            double[] direction = Vector3D.norm(dOb2Hzn);
            if (horizonAltDebug) {
                System.out.println(" ---- point " + n + " ---------------------");
                System.out.println("xo:" + xo + " xh:" + xh + " yo:" + yo + " yh:" + yh + " zo:" + zo + " zh:" + zh + " observer.z:" + observer.z + " observer.alt:" + observer.alt);
                System.out.println("ob2HzDist:" + ob2HzDist);
                System.out.println("direction unit vector:" + Arrays.toString(direction));
            }
            if ((pDotOb2HznVector = xdOb2Hzn * xdOb2Hzn + ydOb2Hzn * ydOb2Hzn + zdOb2Hzn * zdOb2Hzn) < 1.0E-30) {
                if (horizonAltDebug) {
                    System.out.println("1 intersect -> use original horizon pt");
                }
                horizonAtAlt[i] = horizonPtsECEF[i + 0];
                horizonAtAlt[i + 1] = horizonPtsECEF[i + 1];
                horizonAtAlt[i + 2] = horizonPtsECEF[i + 2];
            }
            double tc = Vector3D.dotProduct(ob2ctrVec, direction);
            double o2h = Vector3D.dotProduct(dOb2Hzn, direction);
            double d = Math.sqrt(Math.abs(ob2Ctr2 - tc * tc));
            if (horizonAltDebug) {
                System.out.println("tc:" + tc + " ob2Ctr:" + Math.sqrt(ob2Ctr2) + " ob2Ctr2:" + ob2Ctr2 + " - tc*tc:" + tc * tc);
                System.out.println("o2h:" + o2h);
                System.out.println("d:" + d + " d*d:" + d * d);
            }
            if (d < 1.0) {
                double t1c = Math.sqrt(1.0 - d * d);
                double t2 = tc + t1c;
                double[] o2p2 = new double[]{direction[0] * t2, direction[1] * t2, direction[2] * t2};
                double[] p2 = new double[]{xo + o2p2[0], yo + o2p2[1], zo + o2p2[2]};
                horizonAtAlt[i] = p2[0] * xOfAlt;
                horizonAtAlt[i + 1] = p2[1] * yOfAlt;
                horizonAtAlt[i + 2] = p2[2] * zOfAlt;
                if (horizonAltDebug) {
                    double t1 = tc - t1c;
                    double[] o2p1 = new double[]{direction[0] * t1, direction[1] * t1, direction[2] * t1};
                    double[] p1 = new double[]{xo + o2p1[0], yo + o2p1[1], zo + o2p1[2]};
                    System.out.println("t1c:" + t1c + " t2:" + t2 + " t1:" + t1);
                    System.out.println("o2p2:" + Arrays.toString(o2p2));
                    System.out.println("direction:" + Arrays.toString(direction));
                    System.out.println("p1:" + Arrays.toString(p1));
                    System.out.println("scaledHznPts:" + Arrays.toString(scaledHznPts));
                    System.out.println("scaledHznAtAlt p2:" + Arrays.toString(p2));
                    Position hznPos = new Position();
                    hznPos.setCar(horizonPtsECEF[i + 0], horizonPtsECEF[i + 1], horizonPtsECEF[i + 2]);
                    Position hznAtAlt = new Position();
                    hznAtAlt.setCar(horizonAtAlt[i + 0], horizonAtAlt[i + 1], horizonAtAlt[i + 2]);
                    System.out.println("Position hzn:" + hznPos.toString(1));
                    System.out.println("Position hznAtAlt:" + hznAtAlt.toString(1));
                }
            } else {
                horizonAtAlt[i] = horizonPtsECEF[i + 0];
                horizonAtAlt[i + 1] = horizonPtsECEF[i + 1];
                horizonAtAlt[i + 2] = horizonPtsECEF[i + 2];
            }
            i += 3;
        }
        return horizonAtAlt;
    }

    private static double[] sphericalEarthConeToHorizon(double[] vcHat, double invDistViewer2Center, double[] viewerXYZ, double[] pt2Extend, double distanceHorizonSpherical, boolean trimToGeosurface) {
        double[] vectorViewer2Result;
        double[] zhat = Vector3D.norm(Vector3D.crossProduct(pt2Extend, vcHat));
        double[] yhat = Vector3D.crossProduct(zhat, vcHat);
        double[] xhatXdistH = Vector3D.multByScalar(vcHat, distanceHorizonSpherical);
        double[] yhatXeer = Vector3D.multByScalar(yhat, 6378137.0);
        double[] vectorViewer2Pt2Extend = Vector3D.multByScalar(Vector3D.add(xhatXdistH, yhatXeer), invDistViewer2Center);
        if (trimToGeosurface) {
            vectorViewer2Result = Vector3D.multByScalar(vectorViewer2Pt2Extend, -distanceHorizonSpherical);
        } else {
            double[] phatNorm = Vector3D.norm(Vector3D.subtract(pt2Extend, viewerXYZ));
            double distViewer2Result = distanceHorizonSpherical / Vector3D.dotProduct(vectorViewer2Pt2Extend, phatNorm);
            vectorViewer2Result = Vector3D.multByScalar(phatNorm, -distViewer2Result);
        }
        double[] result = Vector3D.add(viewerXYZ, vectorViewer2Result);
        return result;
    }

    private static double[] oblateEarthConeToHorizon(double[] vcHat, double rmag, double[] viewerXYZ, double[] pt2Extend, boolean trimToGeosurface) {
        double sin_o;
        double cos_o;
        double[] vNormPlaneCP = Vector3D.crossProduct(pt2Extend, vcHat);
        double vNormCPMag = Vector3D.mag(vNormPlaneCP);
        if (vNormCPMag < 1.0E-10) {
            return null;
        }
        double[] ncpHat = Vector3D.multByScalar(vNormPlaneCP, 1.0 / vNormCPMag);
        double[] cpHat = Vector3D.crossProduct(ncpHat, vcHat);
        double[] vcHat_scaled = Vector3D.multByScalar(vcHat, 1.567855942887398E-7);
        vcHat_scaled[2] = vcHat_scaled[2] * INVERSE_POLAR_FLATENING_FACTOR;
        double[] cpHat_scaled = Vector3D.multByScalar(cpHat, 1.567855942887398E-7);
        cpHat_scaled[2] = cpHat_scaled[2] * INVERSE_POLAR_FLATENING_FACTOR;
        double num = 2.0 * Vector3D.dotProduct(vcHat_scaled, cpHat_scaled);
        double den = Vector3D.dotProduct(vcHat_scaled, vcHat_scaled) - Vector3D.dotProduct(cpHat_scaled, cpHat_scaled);
        if (num == 0.0) {
            cos_o = 1.0;
            sin_o = 0.0;
        } else if (den == 0.0) {
            cos_o = sin_o = INVERSE_SQRT_2;
        } else {
            double omega = 0.5 * Math.atan(num / den);
            cos_o = Math.cos(omega);
            sin_o = Math.sin(omega);
        }
        double[] vcHat_rot = Vector3D.add(Vector3D.multByScalar(vcHat, cos_o), Vector3D.multByScalar(cpHat, sin_o));
        double[] cpHat_rot = Vector3D.add(Vector3D.multByScalar(vcHat, -sin_o), Vector3D.multByScalar(cpHat, cos_o));
        double[] vcHat_rot_scaled = Vector3D.multByScalar(vcHat_rot, 1.567855942887398E-7);
        vcHat_rot_scaled[2] = vcHat_rot_scaled[2] * INVERSE_POLAR_FLATENING_FACTOR;
        double[] cpHat_rot_scaled = Vector3D.multByScalar(cpHat_rot, 1.567855942887398E-7);
        cpHat_rot_scaled[2] = cpHat_rot_scaled[2] * INVERSE_POLAR_FLATENING_FACTOR;
        double semimajorSquared = 1.0 / Vector3D.dotProduct(vcHat_rot_scaled, vcHat_rot_scaled);
        double semiminorSquared = 1.0 / Vector3D.dotProduct(cpHat_rot_scaled, cpHat_rot_scaled);
        double x_radius = rmag * cos_o;
        double y_radius = rmag * sin_o;
        double xRadSquared_semimajorSquared = x_radius * x_radius - semimajorSquared;
        double m = (x_radius * y_radius - Math.sqrt(semimajorSquared * y_radius * y_radius + semiminorSquared * xRadSquared_semimajorSquared)) / xRadSquared_semimajorSquared;
        double cInverse = 1.0 / Math.sqrt(semimajorSquared * m * m + semiminorSquared);
        double point_x = -semimajorSquared * m * cInverse;
        double point_y = -semiminorSquared * cInverse;
        double[] geosurface = Vector3D.add(Vector3D.multByScalar(vcHat_rot, point_x), Vector3D.multByScalar(cpHat_rot, point_y));
        if (trimToGeosurface) {
            return geosurface;
        }
        double[] vpHat = Vector3D.norm(Vector3D.subtract(pt2Extend, viewerXYZ));
        double[] vhHat = Vector3D.subtract(geosurface, viewerXYZ);
        double horizonDistance = Vector3D.mag(vhHat);
        vhHat = Vector3D.multByScalar(vhHat, 1.0 / horizonDistance);
        double distance2HorizonPt = horizonDistance / Vector3D.dotProduct(vhHat, vpHat);
        double[] offSurfaceHorizonPoint = Vector3D.add(Vector3D.multByScalar(vpHat, distance2HorizonPt), viewerXYZ);
        return offSurfaceHorizonPoint;
    }

    public static void car2geo(double[] v, int mpva, int nrec) {
        double ee = 0.0066943799901414;
        double ee1 = 1.0 - ee;
        double ee1i = 1.0 / ee1;
        double eer = 6378137.0;
        int isk = 3 * mpva;
        int i = 0;
        int n = 0;
        while (n < nrec) {
            double x = v[i + 0];
            double y = v[i + 1];
            double z = v[i + 2];
            if (x == 0.0 && y == 0.0) {
                v[i + 0] = Math.abs(z) - eer * Math.sqrt(ee1);
                v[i + 1] = z < 0.0 ? -90.0 : 90.0;
                v[i + 2] = 0.0;
            } else {
                double dh;
                double da;
                double r = Math.sqrt(x * x + y * y + z * z);
                double b = Math.sqrt(x * x + y * y);
                double c = Math.asin(z / r);
                double a = Math.atan(Math.tan(c) * ee1i);
                double sa = Math.sin(a);
                double h = r - eer / Math.sqrt(1.0 + ee * sa * sa * ee1i);
                do {
                    sa = Math.sin(a);
                    double ca = Math.cos(a);
                    double t = 1.0 / Math.sqrt(1.0 - ee * sa * sa);
                    double f1 = (h + eer * t) * ca - b;
                    double f2 = (h + eer * ee1 * t) * sa - z;
                    da = (-f1 * sa + f2 * ca) / (h + eer * ee1 * t * t * t);
                    dh = f1 * ca + f2 * sa;
                    a -= da;
                    h -= dh;
                } while (da > 1.0E-4 || dh > 1.0E-4);
                v[i + 0] = h;
                v[i + 1] = 57.29577951308232 * a;
                v[i + 2] = 57.29577951308232 * Math.atan2(y, x);
                if (mpva <= 1) {
                    // empty if block
                }
            }
            ++n;
            i += isk;
        }
    }

    public static void car2cyl(double[] v, int mpva, int nrec) {
        Shell.warning("Transform.car2cyl is not yet coded");
    }

    public static void car2ell(double[] v, int mpva, int nrec) {
        Shell.warning("Transform.car2ell is not yet coded");
    }

    public static double[] ecefGeo2ecefCarAzEq(double[] ecefGeo) {
        int LENGTH = ecefGeo.length / 3 * 3;
        double[] ecrCarAzEq = new double[LENGTH];
        int ii = 0;
        while (ii < LENGTH) {
            double dist = Math.toRadians(90.0 - ecefGeo[ii + 1]);
            double azim = Math.toRadians(ecefGeo[ii + 2]);
            ecrCarAzEq[ii++] = 6356752.3142 * dist * Math.cos(azim);
            ecrCarAzEq[ii++] = 6356752.3142 * dist * Math.sin(azim);
            ecrCarAzEq[ii++] = 6356752.3142;
        }
        return ecrCarAzEq;
    }

    public static double[] ecrGeo2ecrCarAzEq(double[] ecrGeo) {
        return Transform.ecefGeo2ecefCarAzEq(ecrGeo);
    }

    public static TMatrix ecefCarAlt2ecefCarTMatrix(double lat, double lon) {
        TMatrix tm = new TMatrix();
        tm.a11 = -Math.sin(Math.toRadians(lon));
        tm.a21 = Math.cos(Math.toRadians(lon));
        tm.a31 = 0.0;
        tm.a32 = Math.cos(Math.toRadians(lat));
        tm.a33 = Math.sin(Math.toRadians(lat));
        tm.a12 = -tm.a21 * tm.a33;
        tm.a13 = tm.a21 * tm.a32;
        tm.a22 = tm.a11 * tm.a33;
        tm.a23 = -tm.a11 * tm.a32;
        return tm;
    }

    public static TMatrix ecrCarAlt2ecrCarTMatrix(double lat, double lon) {
        return Transform.ecefCarAlt2ecefCarTMatrix(lat, lon);
    }

    public static TMatrix ecefCar2ecefCarAltTMatrix(double lat, double lon) {
        TMatrix tm = new TMatrix();
        tm.a11 = -Math.sin(Math.toRadians(lon));
        tm.a12 = Math.cos(Math.toRadians(lon));
        tm.a13 = 0.0;
        tm.a23 = Math.cos(Math.toRadians(lat));
        tm.a33 = Math.sin(Math.toRadians(lat));
        tm.a21 = -tm.a12 * tm.a33;
        tm.a22 = tm.a11 * tm.a33;
        tm.a31 = tm.a12 * tm.a23;
        tm.a32 = -tm.a11 * tm.a23;
        return tm;
    }

    public static TMatrix ecrCar2ecrCarAltTMatrix(double lat, double lon) {
        return Transform.ecefCar2ecefCarAltTMatrix(lat, lon);
    }

    public static double[] ecefGeo2ecefGeo(TMatrix tm, double[] ecefGeo) {
        int LENGTH = ecefGeo.length / 3 * 3;
        double[] eg_ = new double[LENGTH];
        int i = 0;
        while (i < LENGTH) {
            double alt = ecefGeo[i];
            double lat = Math.toRadians(ecefGeo[i + 1]);
            double lon = Math.toRadians(ecefGeo[i + 2]);
            double clat = Math.cos(lat);
            double x = Math.cos(lon) * clat;
            double y = Math.sin(lon) * clat;
            double z = Math.sin(lat);
            double x_ = x * tm.a11 + y * tm.a12 + z * tm.a13;
            double y_ = x * tm.a21 + y * tm.a22 + z * tm.a23;
            double z_ = x * tm.a31 + y * tm.a32 + z * tm.a33;
            eg_[i++] = alt;
            if (z_ >= 1.0) {
                eg_[i++] = 90.0;
                eg_[i++] = 0.0;
                continue;
            }
            if (z_ <= -1.0) {
                eg_[i++] = -90.0;
                eg_[i++] = 0.0;
                continue;
            }
            if (x_ == 0.0 && y_ == 0.0) {
                eg_[i++] = z_ > 0.0 ? 90.0 : -90.0;
                eg_[i++] = 0.0;
                continue;
            }
            eg_[i++] = Math.toDegrees(Math.asin(z_));
            eg_[i++] = Math.toDegrees(Math.atan2(y_, x_));
        }
        return eg_;
    }

    public static double[] ecrGeo2ecrGeo(TMatrix tm, double[] ecrGeo) {
        return Transform.ecefGeo2ecefGeo(tm, ecrGeo);
    }

    private static TMatrix top2ecrTMatrix(Transform t) {
        double slat = Math.sin(t.lat * (Math.PI / 180));
        double clat = Math.cos(t.lat * (Math.PI / 180));
        double slon = Math.sin(t.lon * (Math.PI / 180));
        double clon = Math.cos(t.lon * (Math.PI / 180));
        double t1 = 0.0066943799901414;
        double t2 = 6378137.0 / Math.sqrt(1.0 - t1 * slat * slat);
        double x = (t.alt + t2) * clat * clon;
        double y = (t.alt + t2) * clat * slon;
        double z = (t.alt + (1.0 - t1) * t2) * slat;
        TMatrix tm = new TMatrix();
        tm.rotate(t.roll, 3);
        tm.rotate(t.elev, 2);
        tm.rotate(t.azim, 1);
        tm.rotate(90.0 - t.lat, 3);
        tm.rotate(90.0 + t.lon, 1);
        tm.offset(x, y, z);
        return tm;
    }

    private static void matrixVectorMultiply(TMatrix tm, double[] v, int mpva, int nrec) {
        switch (mpva) {
            case 0: {
                Transform.matrixVectorMultA(tm, v, 0, 3, nrec);
                break;
            }
            case 1: {
                Transform.matrixVectorMultAB(tm, v, 0, 3, nrec);
                break;
            }
            case 2: {
                Transform.matrixVectorMultAB(tm, v, 0, 6, nrec);
                Transform.matrixVectorMultA(tm, v, 3, 6, nrec);
                break;
            }
            case 3: {
                Transform.matrixVectorMultAB(tm, v, 0, 9, nrec);
                Transform.matrixVectorMultA(tm, v, 3, 9, nrec);
                Transform.matrixVectorMultA(tm, v, 6, 9, nrec);
            }
        }
    }

    private static void matrixVectorMultA(TMatrix tm, double[] v, int ioff, int isk, int nrec) {
        int i = ioff;
        for (int n = 0; n < nrec; ++n) {
            double x = v[i + 0];
            double y = v[i + 1];
            double z = v[i + 2];
            v[i + 0] = x * tm.a11 + y * tm.a12 + z * tm.a13;
            v[i + 1] = x * tm.a21 + y * tm.a22 + z * tm.a23;
            v[i + 2] = x * tm.a31 + y * tm.a32 + z * tm.a33;
            i += isk;
        }
    }

    private static void matrixVectorMultAB(TMatrix tm, double[] v, int ioff, int isk, int nrec) {
        int i = ioff;
        for (int n = 0; n < nrec; ++n) {
            double x = v[i + 0];
            double y = v[i + 1];
            double z = v[i + 2];
            v[i + 0] = x * tm.a11 + y * tm.a12 + z * tm.a13 + tm.b1;
            v[i + 1] = x * tm.a21 + y * tm.a22 + z * tm.a23 + tm.b2;
            v[i + 2] = x * tm.a31 + y * tm.a32 + z * tm.a33 + tm.b3;
            i += isk;
        }
    }

    @InternalUseOnly
    public static void setUseSphericalConeCode(boolean useSphereConeCode) {
        useSphericalConeCode = useSphereConeCode;
        if (useSphereConeCode) {
            useLegacyConeCode = false;
        }
    }

    @InternalUseOnly
    public static boolean getUseSphericalConeCode() {
        return useSphericalConeCode;
    }

    public static void setUseLegacyConeCode(boolean useLegacyConeCode) {
        Transform.useLegacyConeCode = useLegacyConeCode;
        if (useLegacyConeCode) {
            useSphericalConeCode = false;
        }
    }

    public static boolean getUseLegacyConeCode() {
        return useLegacyConeCode;
    }

    @InternalUseOnly
    public static void setCompareConeCode(boolean compare2) {
        compareConeCode = compare2;
    }

    @InternalUseOnly
    public static boolean getCompareConeCode() {
        return compareConeCode;
    }

    @InternalUseOnly
    public static void setCompareConeList(String value) {
        Transform.setCompareConeList(Parser.mask(compareConeList, value, coneCodeComparisons));
    }

    @InternalUseOnly
    public static void setCompareConeList(int value) {
        coneCodeComparisons = value;
    }

    @InternalUseOnly
    public static String getCompareConeList() {
        return Parser.mask2s(compareConeList, coneCodeComparisons);
    }

    @InternalUseOnly
    public static boolean isOnCompareList(int codeCode) {
        return (codeCode & coneCodeComparisons) != 0;
    }

    @InternalUseOnly
    public static void setHorizonAltDebug(boolean enabled) {
        horizonAltDebug = enabled;
    }
}

