/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class TimeLine {
    public static final int DEF_ALLOC = 128;
    @InternalUseOnly
    public static final int DEF_HIGH_PRECISION_ALLOC = -4096;
    public static final double DEF_TOLERANCE = 0.1;
    @InternalUseOnly
    public static final double MICROSECOND_TOLERANCE = 1.0E-6;
    @InternalUseOnly
    public static final double QUARTER_NANOSECOND_TOLERANCE = 2.5E-10;
    @InternalUseOnly
    public static final int GROW_AS_NEEDED = -1;
    @InternalUseOnly
    public static final double TC_GROW_TO_RATIO = 0.25;
    public static final String TIMELINE_KEYWORD_REGEX = "T((C((SAMPLE_[0-9]+)|(_((FRAC|WHOLE)_[0-9]+))))|(IME(LINE|(TAG\\.(OFFSET|(TIME(|\\.UNITS))))|(_(DELTA|EPOCH|OFFSET|TICKS)))))";
    public static final Pattern TIMELINE_KEYWORD_PATTERN = Pattern.compile("T((C((SAMPLE_[0-9]+)|(_((FRAC|WHOLE)_[0-9]+))))|(IME(LINE|(TAG\\.(OFFSET|(TIME(|\\.UNITS))))|(_(DELTA|EPOCH|OFFSET|TICKS)))))");
    @InternalUseOnly
    public static final int DEF_MAX_ALLOC = 1000000;
    private int current = -1;
    private int alloc;
    private int size = 0;
    private double[] offsets;
    private Time[] times;
    private double dt;
    private double tolr;
    private boolean interp;
    private boolean editingEnabled;
    private boolean timelineHasWrapped = false;
    private static int usecPrecisionAllocDefault = 128;
    private static int highPrecisionAllocDefault = -4096;
    private static final int DP_WARN = 9;
    Format format = Format.MICROSECOND_PRECISION;

    public TimeLine(double delta) {
        this(usecPrecisionAllocDefault, delta, 0.1);
    }

    public TimeLine(int tll, double delta, double tlt) {
        this.setAlloc(tll);
        this.setDelta(delta);
        this.setTolerance(tlt);
        this.setEditingEnabled(false);
    }

    private void addTimeOffset(Time time, double offset) {
        ++this.current;
        ++this.size;
        this.times[this.current] = time;
        this.offsets[this.current] = offset;
    }

    public boolean getUseInterpolation() {
        return this.interp;
    }

    public void setUseInterpolation(boolean interp) {
        this.interp = interp;
    }

    public double getDelta() {
        return this.dt;
    }

    public void setDelta(double delta) {
        if (Double.isInfinite(delta) || Double.isNaN(delta) || delta == 0.0) {
            throw new IllegalArgumentException("Invalid TimeLine delta (sec/byte) = " + delta);
        }
        this.dt = delta;
    }

    public double getTolerance() {
        return this.tolr;
    }

    public void setTolerance(double tolerance) {
        this.tolr = tolerance;
    }

    public int getSize() {
        return this.size;
    }

    public int getAlloc() {
        return this.alloc;
    }

    public void setAlloc(int newSize) {
        if (newSize == -1) {
            this.alloc = newSize;
            this.realloc(Math.max(128, this.size));
        } else if (newSize < -128) {
            this.alloc = newSize;
            this.realloc(Math.max(128, Math.max((int)((double)(-newSize) * 0.25), this.size)));
        } else if (newSize < 1) {
            this.alloc = 1;
            this.realloc(1);
            Shell.getSharedMidasContext().deprecate("TimeLine: Since NeXtMidas 2.5.0: Use of alloc=" + this.alloc + " is deprecated. Use alloc > 0; or alloc=-1 for auto.");
        } else {
            this.alloc = newSize;
            this.realloc(this.alloc);
        }
    }

    @InternalUseOnly
    public static void setUsecPrecisionAllocDefault(int allocDefault) {
        usecPrecisionAllocDefault = TimeLine.getValidDefault(allocDefault);
    }

    private static int getValidDefault(int allocDef) {
        if (allocDef == -1) {
            return allocDef;
        }
        if (allocDef < -128) {
            return allocDef;
        }
        if (allocDef < 1) {
            return 1;
        }
        return allocDef;
    }

    @InternalUseOnly
    public static int getUsecPrecisionAllocDefault() {
        return usecPrecisionAllocDefault;
    }

    @InternalUseOnly
    public static void setHighPrecisionAllocDefault(int allocDefault) {
        highPrecisionAllocDefault = TimeLine.getValidDefault(allocDefault);
    }

    @InternalUseOnly
    public static int getHighPrecisionAllocDefault() {
        return highPrecisionAllocDefault;
    }

    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    public void setEditingEnabled(boolean enabled) {
        this.editingEnabled = enabled;
    }

    private void realloc(int toAlloc) {
        double[] oldOffsets = this.offsets;
        Time[] oldTimes = this.times;
        if (oldOffsets == null) {
            this.offsets = new double[toAlloc];
            this.times = new Time[toAlloc];
        } else if (oldOffsets.length != toAlloc) {
            boolean noWrap;
            this.offsets = new double[toAlloc];
            this.times = new Time[toAlloc];
            boolean bl = noWrap = this.size < oldOffsets.length || this.current == oldOffsets.length;
            if (noWrap && this.offsets.length > oldOffsets.length) {
                System.arraycopy(oldOffsets, 0, this.offsets, 0, oldOffsets.length);
                System.arraycopy(oldTimes, 0, this.times, 0, oldOffsets.length);
            } else {
                int start = 0;
                if (oldOffsets.length > this.offsets.length) {
                    start = this.offsets.length - oldOffsets.length;
                }
                int i = 1;
                int j = start;
                while (i <= oldOffsets.length) {
                    int index = (this.current + i) % oldOffsets.length;
                    if (j >= 0) {
                        this.offsets[j] = oldOffsets[index];
                        this.times[j] = oldTimes[index];
                    }
                    ++i;
                    ++j;
                }
            }
        }
        this.current = this.size - 1;
    }

    public boolean setTimeAt(double offset, double time) {
        return this.setTimeAt(offset, new Time(time), NotifyInvalidEntry.EXCEPTION);
    }

    public boolean setTimeAt(double offset, Time time) {
        return this.setTimeAt(offset, time, NotifyInvalidEntry.EXCEPTION);
    }

    public boolean setTimeAt(double index, double dbpe, double time) {
        return this.setTimeAt(index, dbpe, new Time(time), NotifyInvalidEntry.EXCEPTION);
    }

    public boolean setTimeAt(double index, double dbpe, Time time) {
        return this.setTimeAt(index, dbpe, time, NotifyInvalidEntry.EXCEPTION);
    }

    @InternalUseOnly
    public boolean setTimeAt(double index, double dbpe, Time time, NotifyInvalidEntry notifyLevel) {
        return this.setTimeAt(index * dbpe, time, notifyLevel);
    }

    private boolean setTimeAt(double offset, Time time, NotifyInvalidEntry notifyLevel) {
        if (time == null || time.getSec() <= 0.0) {
            return false;
        }
        int i = this.current;
        if (i >= 0) {
            if (offset == this.offsets[i]) {
                --i;
            } else {
                double terr = time.diff(this.times[i]) - (offset - this.offsets[i]) * this.dt;
                if (Math.abs(terr) <= this.tolr) {
                    return false;
                }
                boolean disableErrorMsg = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
                String errorCondition = null;
                if (offset < this.offsets[i] && (i != 0 || this.editingEnabled)) {
                    if (this.editingEnabled) {
                        return this.insertEntry(offset, time, notifyLevel);
                    }
                    if (!disableErrorMsg) {
                        String notification = "";
                        if (Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.DoublePropagateTimelineKeywordsInPipe)) {
                            notification = "\n\t- It is recommended to turn off the CoreIO option DoublePropagateTimelineKeywordsInPipe";
                        }
                        errorCondition = "ERROR: Adding in a missed TimeLine entry with an earlier offset is currently disabled - Offset - Current:" + offset + " Previous:" + this.offsets[i] + "\n         Time- Current:" + time.toString(9) + " Previous:" + this.times[i].toString(9) + "    Index - " + i + "  thread name:" + Thread.currentThread().getName() + notification;
                        this.reportInvalidEntry(errorCondition, notifyLevel);
                    }
                } else if (offset > this.offsets[i] && time.diff(this.times[i]) < 0.0) {
                    if (!disableErrorMsg) {
                        errorCondition = "ERROR: Invalid TimeLine entry that is at later offset, but is back in time - Offset - Current:" + offset + " Previous:" + this.offsets[i] + "\n         Time- Current:" + time.toString(9) + " Previous:" + this.times[i].toString(9) + "    Index - " + i + "  thread name:" + Thread.currentThread().getName();
                        this.reportInvalidEntry(errorCondition, notifyLevel);
                    }
                } else if (terr < -1.0E7) {
                    if (!disableErrorMsg) {
                        errorCondition = "Skipping probably invalid timeline entry (offset:" + offset + " time:" + time + "), which is more than 4 months back in time with respect to expected time. - Offset - Current:" + offset + " Previous:" + this.offsets[i] + "\n         Time- Current:" + time.toString(9) + " Previous:" + this.times[i].toString(9) + "    Index - " + i + "  thread name:" + Thread.currentThread().getName();
                        this.reportInvalidEntry(errorCondition, notifyLevel);
                    }
                    return false;
                }
            }
        }
        if (++i == this.offsets.length) {
            if (this.alloc == -1 && this.offsets.length < 1000000) {
                int newLength = Math.min(this.offsets.length * 2, 1000000);
                this.realloc(newLength);
            } else if (this.alloc <= -128 && this.offsets.length < -this.alloc) {
                int newLength = Math.min(this.offsets.length * 2, -this.alloc);
                this.realloc(newLength);
            } else {
                boolean disableErrorMsg = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
                this.timelineHasWrapped = true;
                if (!this.timelineHasWrapped && !disableErrorMsg && notifyLevel != NotifyInvalidEntry.NONE) {
                    Shell.warning("This TimeLine buffer is full - wrapping entries (alloc=" + this.alloc + " i=" + i + " thread name:" + Thread.currentThread().getName() + ")");
                }
                i = 0;
            }
        }
        this.offsets[i] = offset;
        if (this.times[i] == null) {
            this.times[i] = new Time(time);
        } else {
            this.times[i].fromTime(time);
        }
        this.size = Math.max(i + 1, this.size);
        this.current = i;
        return true;
    }

    private boolean insertEntry(double offset, Time time, NotifyInvalidEntry notifyLevel) {
        int time2Idx;
        int insertionPt;
        String errorCondition = null;
        boolean disableErrorMsg = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
        boolean haveWrapped = this.current < this.size - 1;
        int minOffsetIdx = haveWrapped ? this.current + 1 : 0;
        int maxOffsetIdx = this.current;
        if (offset >= this.offsets[maxOffsetIdx]) {
            throw new IllegalArgumentException("offset [" + offset + "] >= greatest offset in buffer " + this.offsets[maxOffsetIdx]);
        }
        if (offset <= this.offsets[minOffsetIdx]) {
            if (!disableErrorMsg) {
                errorCondition = "Invalid Insertion: where offset <= minimum offset in buffer: (offset:" + offset + " time:" + time + ") where minimum offset is " + this.offsets[minOffsetIdx];
                this.reportInvalidEntry(errorCondition, notifyLevel);
            }
            return false;
        }
        int minSearch = 0;
        int maxSearch = this.current;
        if (haveWrapped && offset <= this.offsets[this.size - 1]) {
            minSearch = this.current;
            maxSearch = this.size;
        }
        int insertIdx = (insertionPt = Arrays.binarySearch(this.offsets, minSearch, maxSearch, offset)) < 0 ? Math.abs(insertionPt) - 1 : insertionPt;
        boolean overwriting = insertIdx == insertionPt;
        int time1Idx = insertIdx == 0 ? this.size - 1 : insertIdx - 1;
        int n = time2Idx = overwriting ? insertIdx + 1 : insertIdx;
        if (time.compareTo(this.times[time1Idx]) <= 0 || time.compareTo(this.times[time2Idx]) >= 0) {
            if (!disableErrorMsg) {
                errorCondition = "Invalid Insertion: time is out of range - not adding entry at index " + insertIdx + " for  (offset:" + offset + " time:" + time + ")";
                this.reportInvalidEntry(errorCondition, notifyLevel);
            }
            return false;
        }
        if (overwriting) {
            this.times[insertIdx] = time;
        } else {
            boolean atEndBuffer;
            boolean bl = atEndBuffer = this.current == this.offsets.length - 1;
            if (!haveWrapped && atEndBuffer) {
                int newLength;
                if (this.alloc == -1 && this.offsets.length < 1000000) {
                    newLength = Math.min(this.offsets.length * 2, 1000000);
                    this.realloc(newLength);
                } else if (this.alloc < -128 && this.offsets.length < this.alloc) {
                    newLength = Math.min(this.offsets.length * 2, this.alloc);
                    this.realloc(newLength);
                } else {
                    if (!disableErrorMsg) {
                        errorCondition = "Invalid Insertion: timeline full and is currently an unwrapped valid timeline - please increase size to insert entry (offset:" + offset + " time:" + time + ") at index:" + insertIdx;
                        this.reportInvalidEntry(errorCondition, notifyLevel);
                    }
                    return false;
                }
            }
            boolean insertAtIdxBelowCurrent = insertIdx <= this.current;
            ++this.current;
            if (insertAtIdxBelowCurrent) {
                if (!haveWrapped) {
                    ++this.size;
                }
                this.timelineInsertShiftRight(offset, time, insertIdx, this.current);
            } else {
                double savedOffset = this.offsets[this.size - 1];
                Time savedTime = this.times[this.size - 1];
                this.timelineInsertShiftRight(offset, time, insertIdx, this.offsets.length - 1);
                this.timelineInsertShiftRight(savedOffset, savedTime, 0, this.current);
            }
        }
        return true;
    }

    private void timelineInsertShiftRight(double offset, Time time, int insertIdx, int lastIdx) {
        for (int idx = lastIdx; idx > insertIdx; --idx) {
            this.offsets[idx] = this.offsets[idx - 1];
            this.times[idx] = this.times[idx - 1];
        }
        this.offsets[insertIdx] = offset;
        this.times[insertIdx] = time;
    }

    private void reportInvalidEntry(String errorCondition, NotifyInvalidEntry notifyLevel) {
        if (errorCondition != null) {
            switch (notifyLevel) {
                case WARNING: {
                    Shell.warning(errorCondition);
                    break;
                }
                case EXCEPTION: {
                    throw new MidasException(errorCondition);
                }
            }
        }
    }

    public Time getTimeAt(double offset, Time time) {
        int i;
        if (time == null) {
            time = new Time();
        }
        if ((i = this.current) < 0) {
            return time.fromJ1950x(0.0, 0.0);
        }
        double iOffset = this.offsets[i];
        if (offset >= iOffset) {
            time.fromTime(this.times[i]);
            return time.addSec((offset - iOffset) * this.dt);
        }
        for (int j = 0; j < this.size; ++j) {
            int k = i--;
            if (i < 0) {
                i = this.size - 1;
            }
            if (!(offset >= (iOffset = this.offsets[i]))) continue;
            time.fromTime(this.times[i]);
            if (this.interp && j != 0) {
                double add = this.times[k].diff(time) * (offset - iOffset) / (this.offsets[k] - iOffset);
                return time.addSec(add);
            }
            return time.addSec((offset - iOffset) * this.dt);
        }
        return time.fromJ1950x(0.0, 0.0);
    }

    public double getTimeAt(double offset) {
        return this.getTimeAt(offset, new Time()).getSec();
    }

    public double getOffsetAt(double time) {
        return this.getOffsetAt(new Time(time));
    }

    public double getOffsetAt(Time time) {
        int i = this.current;
        if (i < 0) {
            return 0.0;
        }
        double tdiff = time.diff(this.times[i]);
        if (tdiff >= 0.0) {
            return Math.floor(this.offsets[i] + tdiff / this.dt);
        }
        for (int j = 0; j < this.size; ++j) {
            int k = i--;
            if (i < 0) {
                i = this.size - 1;
            }
            if (!((tdiff = time.diff(this.times[i])) >= 0.0) || !(tdiff < 1.0E7)) continue;
            if (this.interp && k != this.current) {
                return Math.floor((this.offsets[k] - this.offsets[i]) * tdiff / this.times[k].diff(this.times[i]) + this.offsets[i]);
            }
            return Math.floor(this.offsets[i] + tdiff / this.dt);
        }
        return 0.0;
    }

    public void purge(double toOffset) {
        int i;
        if (toOffset <= 0.0) {
            return;
        }
        for (i = this.current; i > 0 && this.offsets[i] > toOffset; --i) {
        }
        if (i == 0) {
            return;
        }
        this.size = this.current + 1 - i;
        for (int j = 0; j < this.size; ++j) {
            this.offsets[j] = this.offsets[j + i];
            this.times[j] = this.times[j + i];
        }
    }

    @InternalUseOnly
    public Data toData() {
        int j = 0;
        Data data = new Data("SD", this.size * 2 + 2);
        data.setD(j++, this.dt);
        data.setD(j++, this.tolr);
        int oldest = this.timelineHasWrapped ? (this.current + 1) % this.offsets.length : 0;
        int numEntries = this.timelineHasWrapped ? this.offsets.length : this.current + 1;
        int i = oldest;
        for (int n = 1; n <= numEntries; ++n) {
            data.setD(j++, this.offsets[i]);
            data.setD(j++, this.times[i].getSec());
            i = (i + 1) % this.offsets.length;
        }
        return data;
    }

    @InternalUseOnly
    Map<String, Object> toPlatinumKeywords(Time timeEpoch, double timeDelta, double dbpe) throws IllegalStateException {
        if (this.current < 0) {
            throw new IllegalStateException("TimeLine is empty");
        }
        Time wsecTimeEpoch = new Time(timeEpoch.getWSec());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int units = timeDelta == 0.0 ? 1 : 32;
        Data offsetData = new Data("SX", this.size);
        Data timeData = new Data(units == 32 ? "SX" : "SD", this.size);
        int oldest = this.timelineHasWrapped ? (this.current + 1) % this.offsets.length : 0;
        int numEntries = this.timelineHasWrapped ? this.offsets.length : this.current + 1;
        int i = oldest;
        for (int j = 0; j < numEntries; ++j) {
            long elemOffset = (long)(this.offsets[i] / dbpe);
            offsetData.setX(j, elemOffset);
            if (units == 32) {
                timeData.setNumber(i, this.times[i].toTimeTicks(wsecTimeEpoch, timeDelta));
            } else if (units == 1) {
                timeData.setNumber(i, this.times[i].diff(wsecTimeEpoch));
            }
            i = (i + 1) % this.offsets.length;
        }
        map.put("TIMETAG.OFFSET", offsetData);
        map.put("TIMETAG.TIME", timeData);
        map.put("TIMETAG.TIME.UNITS", units);
        map.put("TIME_EPOCH", wsecTimeEpoch.toString(10, 0));
        if (units == 32) {
            map.put("TIME_DELTA", timeDelta);
            map.put("TIME_TICKS", 1.0 / timeDelta);
        }
        return map;
    }

    @InternalUseOnly
    static TimeLine fromPlatinumKeywords(Keywords keywords, double dfDelta, double dbpe) {
        Time timeEpoch;
        Object _timeData = keywords.get("TIMETAG.TIME");
        Object _offsetData = keywords.get("TIMETAG.OFFSET");
        Object _timeEpoch = keywords.get("TIME_EPOCH");
        Double timeDelta = keywords.getD("TIME_DELTA", null);
        Integer unitsKW = keywords.getUnitsFor("TIMETAG.TIME", null);
        if (_timeEpoch == null || !(_timeEpoch instanceof String)) {
            return null;
        }
        if (_timeData == null || !(_timeData instanceof Data)) {
            return null;
        }
        if (_offsetData == null || !(_offsetData instanceof Data)) {
            return null;
        }
        int units = timeDelta == null ? 1 : 32;
        double tolerance = timeDelta == null ? dfDelta : timeDelta;
        Data offsetData = (Data)_offsetData;
        Data timeData = (Data)_timeData;
        try {
            timeEpoch = Time.toTime(_timeEpoch, 10);
        }
        catch (Exception ex) {
            Shell.printStackTrace("Invalid value in TIME_EPOCH keyword [" + _timeEpoch + "]!", ex);
            return null;
        }
        if (unitsKW != null && unitsKW != units) {
            Shell.warning("Mismatch time units: TIMETAG.TIME.UNIT(S)=" + unitsKW + ", using time units=" + units + " derived from TIME_DELTA keyword");
        }
        if (offsetData.size != timeData.size) {
            Shell.warning("TIMETAG.OFFSET[" + offsetData.size + "] and TIMETAG.TIME[" + timeData.size + "] MUST have same number of entries (size)");
            return null;
        }
        if (timeData.getSize() > 0 && dbpe <= 0.0) {
            throw new MidasException("TimeLine.fromPlatinumKeywords dpbe needs to be positive when data elements exist- was:" + dbpe);
        }
        TimeLine timeline = new TimeLine(timeData.getSize(), dfDelta / dbpe, tolerance);
        for (int ii = 0; ii < timeData.getSize(); ++ii) {
            Number td = timeData.getNumber(ii);
            Time time = units == 32 ? new Time(td.longValue(), timeEpoch, timeDelta) : new Time(timeEpoch).addSec(td.doubleValue());
            double offset = offsetData.getNumber(ii).doubleValue() * dbpe;
            timeline.addTimeOffset(time, offset);
            boolean disableErrorMsg = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
            if (ii <= 0 || !(time.diff(timeline.times[ii - 1]) < 0.0) || disableErrorMsg) continue;
            double prevOffset = offsetData.getNumber(ii).doubleValue() * dbpe;
            Shell.warning("ERROR: Invalid TimeLine entry that occurs later in the timeline, but is back in time - Offset - Current:" + offset + " Previous:" + prevOffset + "\n         Time- Current:" + time.toString(9) + " Previous:" + timeline.times[ii - 1].toString(9) + "    Index - " + ii);
        }
        timeline.format = Format.PLATINUM_HIGH_PRECISION;
        return timeline;
    }

    @InternalUseOnly
    Map<String, Object> toBlueTCKeywords(double dbpe) throws IllegalStateException {
        if (this.current < 0) {
            throw new IllegalStateException("TimeLine is empty");
        }
        if (dbpe <= 0.0) {
            throw new MidasException("TimeLine.toBlueTCKeywords dpbe needs to be positive - was:" + dbpe);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>((this.current + 1) * 3);
        int oldest = this.timelineHasWrapped ? (this.current + 1) % this.offsets.length : 0;
        int numEntries = this.timelineHasWrapped ? this.offsets.length : this.current + 1;
        int i = oldest;
        for (int j = 1; j <= numEntries; ++j) {
            map.put("TCSAMPLE_" + j, this.offsets[i] / dbpe + 1.0);
            map.put("TC_WHOLE_" + j, this.times[i].getWSec());
            map.put("TC_FRAC_" + j, this.times[i].getFSec());
            i = (i + 1) % this.offsets.length;
        }
        return map;
    }

    @InternalUseOnly
    static TimeLine fromBlueTCKeywords(Keywords kw, Time dfTimecode, double dfDelta, double dbpe) {
        Double offset;
        boolean enableOffset0AutoCorrect;
        if (dbpe <= 0.0) {
            return null;
        }
        double tolerance = 2.5E-10;
        int numTCEntries = TimeLine.getNumTCEntries(kw);
        if (numTCEntries < 128) {
            numTCEntries = highPrecisionAllocDefault;
        }
        TimeLine timeline = new TimeLine(numTCEntries, dfDelta / dbpe, tolerance);
        CoreIO coreIO = Shell.getMidasContext().io;
        boolean bl = enableOffset0AutoCorrect = !coreIO.isOptionSet(CoreIO.IOOptions.DisableTimeLineAutoCorrectNoOffset0Entry) && !coreIO.isOptionSet(CoreIO.IOOptions.SameTimelineKeywords);
        if (enableOffset0AutoCorrect) {
            timeline.setTimeAt(0.0, dbpe, dfTimecode);
        }
        boolean any = false;
        int i = 1;
        while ((offset = kw.getD("TCSAMPLE_" + i, null)) != null) {
            Double wsec = kw.getD("TC_WHOLE_" + i, null);
            Double fsec = kw.getD("TC_FRAC_" + i, null);
            if (wsec == null) {
                throw new MidasException("Invalid BLUE TC keywords, missing TC_WHOLE_" + i);
            }
            if (fsec == null) {
                throw new MidasException("Invalid BLUE TC keywords, missing TC_FRAC_" + i);
            }
            any = true;
            timeline.setTimeAt(offset - 1.0, dbpe, new Time(wsec, fsec), NotifyInvalidEntry.WARNING);
            ++i;
        }
        timeline.format = Format.BLUE_HIGH_PRECISION;
        return any ? timeline : null;
    }

    @InternalUseOnly
    public void fromData(Data data, Time startingTime) {
        boolean enableOffset0AutoCorrect;
        int j = 0;
        this.size = Math.min((data.size * data.spa - 2) / 2, this.alloc);
        this.dt = data.getD(j++);
        this.tolr = data.getD(j++);
        this.current = -1;
        double tmax = 0.0;
        double lastTime = 0.0;
        int initIdx = 0;
        CoreIO coreIO = Shell.getMidasContext().io;
        boolean bl = enableOffset0AutoCorrect = !coreIO.isOptionSet(CoreIO.IOOptions.DisableTimeLineAutoCorrectNoOffset0Entry) && !coreIO.isOptionSet(CoreIO.IOOptions.SameTimelineKeywords);
        if (enableOffset0AutoCorrect && data.getD(j) != 0.0 && startingTime.getSec() > 0.0) {
            if (this.offsets.length == this.size) {
                this.offsets = new double[this.size + 1];
                this.times = new Time[this.size + 1];
            }
            this.offsets[0] = 0.0;
            this.times[0] = startingTime;
            lastTime = startingTime.getSec();
            initIdx = 1;
            this.size += initIdx;
        }
        for (int i = 0 + initIdx; i < this.size; ++i) {
            this.offsets[i] = data.getD(j++);
            double time = data.getD(j++);
            this.times[i] = new Time(time);
            boolean disableErrorMsg = Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.SuppressInvalidTimeLineEntryErrors);
            if (time < lastTime && !disableErrorMsg) {
                Shell.warning("ERROR: Invalid TimeLine entry that occurs later in the timeline, but is back in time - Offset - Current:" + this.offsets[i] + " Previous:" + this.offsets[i - 1] + "\n         Time- Current:" + this.times[i].toString(9) + " Previous:" + this.times[i - 1].toString(9) + "    Index - " + i);
            }
            lastTime = time;
            if (!(time > tmax)) continue;
            tmax = time;
            this.current = i;
        }
        this.format = Format.MICROSECOND_PRECISION;
    }

    @InternalUseOnly
    static boolean dataObjectTimelineStartsWithFirstElement(Data data) {
        int positionFirstOffset = 2;
        return data.getD(positionFirstOffset) == 0.0;
    }

    @InternalUseOnly
    public String list() {
        return this.list(3);
    }

    @InternalUseOnly
    public String list(int decimalPlaces) {
        StringBuilder s = new StringBuilder(80 + this.size * (56 + decimalPlaces));
        s.append("TimeLine Size=").append(this.size);
        s.append(" Alloc=").append(this.alloc);
        s.append(" Delta=").append(this.dt).append(" (sec/byte)");
        s.append(" Tolr=").append(this.tolr).append(" (sec)\n");
        for (int i = 0; i < this.size; ++i) {
            s.append("Index=").append(i).append(" Off=").append(this.offsets[i]);
            s.append(" Time=").append(this.times[i].toString(1, decimalPlaces));
            if (i == 0 && this.offsets[0] != 0.0) {
                s.append(" <-- Does not start at beginning of file!");
            }
            s.append("\n");
        }
        if (this.size == this.offsets.length && this.offsets[0] != 0.0) {
            s.append("WARN: TimeLine is full, some entries may have been discarded. It is likely that\n");
            s.append("WARN: the Delta and Tolerance values do not match the observed data rate.\n");
        }
        return s.toString();
    }

    public String toString() {
        Time tmin;
        int decimalPlaces = 3;
        StringBuilder sb = new StringBuilder("TimeLine Size=" + this.size + " Alloc=" + this.alloc + " Delta=" + this.dt + "(sec/byte) Tolr=" + this.tolr + " (sec)");
        if (this.size == 0) {
            return sb.toString();
        }
        Time tmax = tmin = this.times[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.times[i].compareTo(tmax) > 0) {
                tmax = this.times[i];
            }
            if (this.times[i].compareTo(tmin) >= 0) continue;
            tmin = this.times[i];
        }
        sb.append("\n From=").append(tmin.toString(1, decimalPlaces));
        sb.append("\n To  =").append(tmax.toString(1, decimalPlaces));
        return sb.toString();
    }

    @InternalUseOnly(value="since initial version")
    public Table toTable(int decimalPlaces, double bpe) {
        Table timelineTbl = new Table();
        for (int i = 0; i < this.size; ++i) {
            String offset = String.valueOf((int)(this.offsets[i] / bpe));
            timelineTbl.put(offset, (Object)this.times[i].toString(decimalPlaces));
        }
        return timelineTbl;
    }

    @InternalUseOnly(value="since initial version")
    public Time[] getTimes() {
        return Arrays.copyOf(this.times, this.times.length);
    }

    @InternalUseOnly(value="since initial version")
    public double[] getOffsets() {
        return Arrays.copyOf(this.offsets, this.offsets.length);
    }

    public static int getNumTCEntries(Keywords kw) {
        String origScope = kw.getScope();
        Keywords.Iterator iter = kw.iterator("EXT");
        String last = "TCSAMPLE_0";
        int numEntries = 0;
        try {
            while (iter.hasNext()) {
                Keywords.Key k = iter.next();
                String name = k.name;
                if (!name.startsWith("TCSAMPLE_")) continue;
                last = name;
            }
            String lastEntry = last.substring(9);
            numEntries = Integer.valueOf(lastEntry);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        kw.setScope(origScope);
        return numEntries;
    }

    static enum Format {
        MICROSECOND_PRECISION,
        PLATINUM_HIGH_PRECISION,
        BLUE_HIGH_PRECISION;

    }

    @InternalUseOnly
    public static enum NotifyInvalidEntry {
        NONE,
        WARNING,
        EXCEPTION;

    }
}

