/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasThread;

public class TcpResource
extends IOResource
implements Runnable {
    public static final int UNTANGLE = 1;
    public static final int CLOSED = -1;
    public static final int REOPEN = -2;
    private DataInputStream sis;
    private DataOutputStream sos;
    private Socket socketToMe;
    private String host;
    private int port;

    @Override
    public boolean exists() {
        return this.dir < 0;
    }

    @Override
    public void setURL(String str) {
        super.setURL(str);
        if (str.startsWith("stp://")) {
            str = str.substring(6);
        } else if (str.startsWith("stp:/")) {
            str = str.substring(5);
        } else if (str.startsWith("stp:")) {
            str = str.substring(4);
        } else if (str.startsWith("http://")) {
            str = str.substring(7);
        }
        int i = str.indexOf(":");
        this.host = str.substring(0, i);
        this.port = Convert.s2l(str.substring(i + 1));
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        try {
            if (this.dir > 0) {
                ServerSocket server = new ServerSocket(this.port);
                Socket socket = server.accept();
                this.sos = new DataOutputStream(socket.getOutputStream());
            } else if (this.dir <= 0) {
                Socket socket = new Socket(this.host, this.port);
                this.sis = new DataInputStream(socket.getInputStream());
                this.sos = new DataOutputStream(socket.getOutputStream());
            }
            this.isOpen = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        try {
            if (this.sis != null) {
                this.sis.close();
            }
            if (this.sos != null) {
                this.sos.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean seek(long offset) {
        return offset == this.offset;
    }

    @Override
    public long avail() {
        if (this.sis == null) {
            return 0L;
        }
        try {
            return this.sis.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            try {
                status = this.sis.read(buf, off, bytes);
            }
            catch (IOException e) {
                status = -1;
            }
            if (status <= 0) break;
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status < 0 && bytes == 0) {
            return status;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        try {
            this.sos.write(buf, boff, bytes);
        }
        catch (IOException e) {
            return -1;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    public Socket[] connectSockets(String host, int port, int nsock, int timeout, int flags) {
        this.host = host;
        this.port = port;
        Socket[] socks = new Socket[nsock];
        try {
            for (int i = 0; i < nsock; ++i) {
                MidasThread thread = new MidasThread(this.M, (Runnable)this);
                thread.start();
                thread.join(timeout);
                if (thread.isAlive()) {
                    thread.interrupt();
                    Thread.sleep(500L);
                    return null;
                }
                socks[i] = this.socketToMe;
            }
            if (nsock == 2 && (flags & 1) != 0) {
                byte[] bufi = new byte[16];
                byte[] bufo = new byte[16];
                socks[0].getInputStream().read(bufi);
                socks[1].getInputStream().read(bufo);
                if ((char)bufi[0] != 'S') {
                    Socket stmp = socks[0];
                    socks[0] = socks[1];
                    socks[1] = stmp;
                }
            }
            return socks;
        }
        catch (Exception e) {
            throw new MidasException("Connect Sockets", e);
        }
    }

    @Override
    public void run() {
        try {
            this.socketToMe = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            throw new MidasException("Socket connect", e);
        }
    }
}

