/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;

public class StringUtil
implements AsciiMap {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private static final SortedSet<String> EMPTY_SET = Collections.emptySortedSet();
    public static final Pattern COMMA_REGEX = Pattern.compile(",");
    public static final Pattern COMMA_OR_WHITESPACE_REGEX = Pattern.compile("[,\\s]+");
    public static final Pattern SEPATORS_REGEX = Pattern.compile("[,|\\s]+");
    public static final Pattern WHITESPACE_REGEX = Pattern.compile("\\s+");
    public static final Pattern TABLE_AND_XML_TAG_NAME_REGEX = Pattern.compile("^[A-Z][0-9A-Z_]*");
    public static final Pattern TABLE_AND_XML_TAG_NAME_STRIP_INVALID_REGEX = Pattern.compile("[^0-9A-Z_]");
    private static final Pattern LTRIM_REGEX = Pattern.compile("^\\s+");
    private static final Pattern RTRIM_REGEX = Pattern.compile("\\s+$");
    private static final Pattern HEX_VAL_REGEX = Pattern.compile("\\p{XDigit}+");
    private static final Pattern INTEGER_REGEX = Pattern.compile("[-]?\\p{Digit}+");
    private static final Pattern FLOAT1_REGEX = Pattern.compile("[-]?\\p{Digit}+([.]\\p{Digit}*)?([eE][-+]?\\p{Digit}+)?");
    private static final Pattern FLOAT2_REGEX = Pattern.compile("[-]?[.]\\p{Digit}+([eE][-+]?\\p{Digit}+)?");
    private static final Pattern AMP_REGEX = Pattern.compile("&");
    private static final Pattern LT_REGEX = Pattern.compile("<");
    private static final Pattern GT_REGEX = Pattern.compile(">");
    private static final Pattern QUOTE_REGEX = Pattern.compile("\"");
    private static final Pattern HTML2SPACES_REGEX = Pattern.compile("(?i)<dd>|&nbsp;|\t");
    private static final Pattern HTML2NEWLINE_REGEX = Pattern.compile("(?i)\\s*\n|<dt>|<br */?>|<tr>");
    private static final Pattern HTML_TAGS_REGEX = Pattern.compile("<[\\p{Alpha}/!][^>]*>");
    private static final Pattern HTML_LT_REGEX = Pattern.compile("(?i)&lt;");
    private static final Pattern HTML_GT_REGEX = Pattern.compile("(?i)&gt;");
    private static final Pattern HTML_AMP_REGEX = Pattern.compile("(?i)&amp;");
    private static final Pattern HTML_QUOTE_REGEX = Pattern.compile("(?i)&quot;");
    private static final Pattern HTML_COPY_REGEX = Pattern.compile("(?i)&copy;");
    private static final Pattern HTML_REG_REGEX = Pattern.compile("(?i)&reg;");
    private static final Pattern HTML_TRADE_REGEX = Pattern.compile("(?i)&trade;");
    public static final char ESCAPE_CHAR = '\\';
    public static final int NO_ERROR = 1;
    public static final Comparator<Object> NAME_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object _a, Object _b) {
            int lenB;
            int lenA;
            String b;
            if (_a == _b) {
                return 0;
            }
            if (_a == null) {
                return -1;
            }
            if (_b == null) {
                return 1;
            }
            String a = _a.toString();
            if (a.equals(b = _b.toString())) {
                return 0;
            }
            while ((lenA = a.length()) > 0 && (lenB = b.length()) > 0) {
                int intB;
                int countA;
                int countB = 0;
                for (countA = 0; countA < lenA && !StringUtil.isDigit09(a.charAt(countA)); ++countA) {
                }
                while (countB < lenB && !StringUtil.isDigit09(b.charAt(countB))) {
                    ++countB;
                }
                if (countA > 0 || countB > 0) {
                    String strB;
                    String strA = a.substring(0, countA);
                    int comp = strA.compareTo(strB = b.substring(0, countB));
                    if (comp != 0) {
                        return comp;
                    }
                    a = a.substring(countA);
                    lenA = a.length();
                    b = b.substring(countB);
                    lenB = b.length();
                }
                countB = 0;
                for (countA = 0; countA < lenA && StringUtil.isDigit09(a.charAt(countA)); ++countA) {
                }
                while (countB < lenB && StringUtil.isDigit09(b.charAt(countB))) {
                    ++countB;
                }
                if (countA <= 0 && countB <= 0) continue;
                if (countA == 0) {
                    return -1;
                }
                if (countB == 0) {
                    return 1;
                }
                int intA = Integer.parseInt(a.substring(0, countA));
                if (intA != (intB = Integer.parseInt(b.substring(0, countB)))) {
                    return Integer.compare(intA, intB);
                }
                a = a.substring(countA);
                b = b.substring(countB);
            }
            return a.compareTo(b);
        }
    };
    static final Comparator<Map.Entry<?, ?>> KEY_COMPARATOR = new Comparator<Map.Entry<?, ?>>(){

        @Override
        public int compare(Map.Entry<?, ?> a, Map.Entry<?, ?> b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return NAME_COMPARATOR.compare(a.getKey(), b.getKey());
        }
    };
    private static final String[] ENTITY_NAMES = new String[]{"AElig", "Aacute", "Acirc", "Agrave", "Alpha", "Aring", "Atilde", "Auml", "Beta", "Ccedil", "Chi", "Dagger", "Delta", "ETH", "Eacute", "Ecirc", "Egrave", "Epsilon", "Eta", "Euml", "Gamma", "Iacute", "Icirc", "Igrave", "Iota", "Iuml", "Kappa", "Lambda", "Mu", "Ntilde", "Nu", "OElig", "Oacute", "Ocirc", "Ograve", "Omega", "Omicron", "Oslash", "Otilde", "Ouml", "Phi", "Pi", "Prime", "Psi", "Rho", "Scaron", "Sigma", "THORN", "Tau", "Theta", "Uacute", "Ucirc", "Ugrave", "Upsilon", "Uuml", "Xi", "Yacute", "Yuml", "Zeta", "aacute", "acirc", "acute", "aelig", "agrave", "alefsym", "alpha", "amp", "and", "ang", "aring", "asymp", "atilde", "auml", "bdquo", "beta", "brvbar", "bull", "cap", "ccedil", "cedil", "cent", "chi", "circ", "clubs", "cong", "copy", "crarr", "cup", "curren", "dArr", "dagger", "darr", "deg", "delta", "diams", "divide", "eacute", "ecirc", "egrave", "empty", "emsp", "ensp", "epsilon", "equiv", "eta", "eth", "euml", "euro", "exist", "fnof", "forall", "frac12", "frac14", "frac34", "frasl", "gamma", "ge", "gt", "hArr", "harr", "hearts", "hellip", "iacute", "icirc", "iexcl", "igrave", "image", "infin", "int", "iota", "iquest", "isin", "iuml", "kappa", "lArr", "lambda", "lang", "laquo", "larr", "lceil", "ldquo", "le", "lfloor", "lowast", "loz", "lrm", "lsaquo", "lsquo", "lt", "macr", "mdash", "micro", "middot", "minus", "mu", "nabla", "nbsp", "ndash", "ne", "ni", "not", "notin", "nsub", "ntilde", "nu", "oacute", "ocirc", "oelig", "ograve", "oline", "omega", "omicron", "oplus", "or", "ordf", "ordm", "oslash", "otilde", "otimes", "ouml", "para", "part", "permil", "perp", "phi", "pi", "piv", "plusmn", "pound", "prime", "prod", "prop", "psi", "quot", "rArr", "radic", "rang", "raquo", "rarr", "rceil", "rdquo", "real", "reg", "rfloor", "rho", "rlm", "rsaquo", "rsquo", "sbquo", "scaron", "sdot", "sect", "shy", "sigma", "sigmaf", "sim", "spades", "sub", "sube", "sum", "sup", "sup1", "sup2", "sup3", "supe", "szlig", "tau", "there4", "theta", "thetasym", "thinsp", "thorn", "tilde", "times", "trade", "uArr", "uacute", "uarr", "ucirc", "ugrave", "uml", "upsih", "upsilon", "uuml", "weierp", "xi", "yacute", "yen", "yuml", "zeta", "zwj", "zwnj"};
    private static final char[] ENTITY_VALUES = new char[]{'\u00c6', '\u00c1', '\u00c2', '\u00c0', '\u0391', '\u00c5', '\u00c3', '\u00c4', '\u0392', '\u00c7', '\u03a7', '\u2021', '\u0394', '\u00d0', '\u00c9', '\u00ca', '\u00c8', '\u0395', '\u0397', '\u00cb', '\u0393', '\u00cd', '\u00ce', '\u00cc', '\u0399', '\u00cf', '\u039a', '\u039b', '\u039c', '\u00d1', '\u039d', '\u0152', '\u00d3', '\u00d4', '\u00d2', '\u03a9', '\u039f', '\u00d8', '\u00d5', '\u00d6', '\u03a6', '\u03a0', '\u2033', '\u03a8', '\u03a1', '\u0160', '\u03a3', '\u00de', '\u03a4', '\u0398', '\u00da', '\u00db', '\u00d9', '\u03a5', '\u00dc', '\u039e', '\u00dd', '\u0178', '\u0396', '\u00e1', '\u00e2', '\u00b4', '\u00e6', '\u00e0', '\u2135', '\u03b1', '&', '\u2227', '\u2220', '\u00e5', '\u2248', '\u00e3', '\u00e4', '\u201e', '\u03b2', '\u00a6', '\u2022', '\u2229', '\u00e7', '\u00b8', '\u00a2', '\u03c7', '\u02c6', '\u2663', '\u2245', '\u00a9', '\u21b5', '\u222a', '\u00a4', '\u21d3', '\u2020', '\u2193', '\u00b0', '\u03b4', '\u2666', '\u00f7', '\u00e9', '\u00ea', '\u00e8', '\u2205', '\u2003', '\u2002', '\u03b5', '\u2261', '\u03b7', '\u00f0', '\u00eb', '\u20ac', '\u2203', '\u0192', '\u2200', '\u00bd', '\u00bc', '\u00be', '\u2044', '\u03b3', '\u2265', '>', '\u21d4', '\u2194', '\u2665', '\u2026', '\u00ed', '\u00ee', '\u00a1', '\u00ec', '\u2111', '\u221e', '\u222b', '\u03b9', '\u00bf', '\u2208', '\u00ef', '\u03ba', '\u21d0', '\u03bb', '\u2329', '\u00ab', '\u2190', '\u2308', '\u201c', '\u2264', '\u230a', '\u2217', '\u25ca', '\u200e', '\u2039', '\u2018', '<', '\u00af', '\u2014', '\u00b5', '\u00b7', '\u2212', '\u03bc', '\u2207', '\u00a0', '\u2013', '\u2260', '\u220b', '\u00ac', '\u2209', '\u2284', '\u00f1', '\u03bd', '\u00f3', '\u00f4', '\u0153', '\u00f2', '\u203e', '\u03c9', '\u03bf', '\u2295', '\u2228', '\u00aa', '\u00ba', '\u00f8', '\u00f5', '\u2297', '\u00f6', '\u00b6', '\u2202', '\u2030', '\u22a5', '\u03c6', '\u03c0', '\u03d6', '\u00b1', '\u00a3', '\u2032', '\u220f', '\u221d', '\u03c8', '\"', '\u21d2', '\u221a', '\u232a', '\u00bb', '\u2192', '\u2309', '\u201d', '\u211c', '\u00ae', '\u230b', '\u03c1', '\u200f', '\u203a', '\u2019', '\u201a', '\u0161', '\u22c5', '\u00a7', '\u00ad', '\u03c3', '\u03c2', '\u223c', '\u2660', '\u2282', '\u2286', '\u2211', '\u2283', '\u00b9', '\u00b2', '\u00b3', '\u2287', '\u00df', '\u03c4', '\u2234', '\u03b8', '\u03d1', '\u2009', '\u00fe', '\u02dc', '\u00d7', '\u2122', '\u21d1', '\u00fa', '\u2191', '\u00fb', '\u00f9', '\u00a8', '\u03d2', '\u03c5', '\u00fc', '\u2118', '\u03be', '\u00fd', '\u00a5', '\u00ff', '\u03b6', '\u200d', '\u200c'};

    private StringUtil() {
    }

    private static boolean isDigit09(char c) {
        return c >= '0' && c <= '9';
    }

    public static int getClosingFensePos(String str, String fences, int begPos) throws IllegalArgumentException {
        char closeChar;
        if (fences == null || fences.length() != 2) {
            throw new IllegalArgumentException("StringUtil.getClosingFensePos(...) expects a two character string for parameter fences, given \"" + fences + "\".");
        }
        if (str == null || str.length() < begPos + 1) {
            return -1;
        }
        char openChar = fences.charAt(0);
        if (openChar == (closeChar = fences.charAt(1))) {
            return str.indexOf(closeChar, begPos + 1);
        }
        int level = 1;
        for (int pos = begPos + 1; level > 0 && pos < str.length(); ++pos) {
            if (str.charAt(pos) == openChar) {
                ++level;
            }
            if (str.charAt(pos) == closeChar) {
                --level;
            }
            if (level != 0) continue;
            return pos;
        }
        return -1;
    }

    public static int getOpeningFensePos(String str, String fences, int endPos) throws IllegalArgumentException {
        char closeChar;
        if (fences == null || fences.length() != 2) {
            throw new IllegalArgumentException("StringUtil.getOpeningFensePos(...) expects a two character string for parameter fences, given \"" + fences + "\".");
        }
        if (str == null || endPos < 1) {
            return -1;
        }
        char openChar = fences.charAt(0);
        if (openChar == (closeChar = fences.charAt(1))) {
            return str.lastIndexOf(openChar, endPos - 1);
        }
        int level = 1;
        for (int pos = endPos - 1; level > 0 && pos >= 0; --pos) {
            if (str.charAt(pos) == openChar) {
                --level;
            }
            if (str.charAt(pos) == closeChar) {
                ++level;
            }
            if (level != 0) continue;
            return pos;
        }
        return -1;
    }

    public static String join(Object[] list3) {
        return StringUtil.join(list3, ", ");
    }

    public static String join(Object[] list3, String delim) {
        if (list3 == null) {
            return null;
        }
        if (list3.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(200);
        for (int ii = 0; ii < list3.length - 1; ++ii) {
            sb.append(list3[ii]);
            sb.append(delim);
        }
        sb.append(list3[list3.length - 1]);
        return sb.toString();
    }

    public static String toColumns(Object[] objArray, int maxWidth) {
        if (objArray == null) {
            objArray = EMPTY_STRING_ARRAY;
        }
        String[] strs = new String[objArray.length];
        for (int ii = 0; ii < strs.length; ++ii) {
            strs[ii] = "" + objArray[ii];
        }
        return StringUtil.toColumns(strs, maxWidth);
    }

    public static String toColumns(String[] strArray, int maxWidth) {
        return StringUtil.toColumns(strArray, maxWidth, "  ", "\n");
    }

    public static String toColumns(String[] strArray, int maxWidth, String spacer, String eol) {
        if (strArray == null) {
            strArray = EMPTY_STRING_ARRAY;
        }
        int maxEleLength = 0;
        for (String str : strArray) {
            maxEleLength = Math.max(maxEleLength, str.length());
        }
        int columns = maxWidth / (maxEleLength + spacer.length());
        StringBuilder output = new StringBuilder(maxWidth);
        int index = 0;
        int col = 0;
        while (index < strArray.length) {
            if (col > columns) {
                output.append(eol);
                col = 0;
                continue;
            }
            if (col != 0) {
                output.append(spacer);
            }
            if (col == columns) {
                output.append(strArray[index]);
            } else {
                output.append(StringUtil.padRight(strArray[index], maxEleLength));
            }
            ++col;
            ++index;
        }
        return output.toString();
    }

    public static String trim(String string, String start, String end) {
        int i;
        int i1 = 0;
        int i2 = string.length();
        if (start.length() > 0 && (i = string.indexOf(start)) >= 0) {
            i1 = i + start.length();
        }
        if (end.length() > 0 && (i = string.indexOf(end, i1)) >= 0) {
            i2 = i;
        }
        return string.substring(i1, i2);
    }

    public static Object trimIfString(Object obj) {
        if (obj instanceof StringBuffer) {
            String trimmed;
            String str = obj.toString();
            if (!str.equals(trimmed = str.trim())) {
                obj = new StringBuffer(trimmed);
            }
        } else if (obj instanceof StringBuilder) {
            String trimmed;
            String str = obj.toString();
            if (!str.equals(trimmed = str.trim())) {
                obj = new StringBuilder(trimmed);
            }
        } else if (obj instanceof String) {
            obj = ((String)obj).trim();
        }
        return obj;
    }

    public static String ltrim(String str) {
        return LTRIM_REGEX.matcher(str).replaceAll("");
    }

    public static String rtrim(String str) {
        return RTRIM_REGEX.matcher(str).replaceAll("");
    }

    public static String between(String inString, int imin, int imax) {
        if (imin < 0) {
            imin = inString.length() + imin;
        }
        if (imax < 0) {
            imax = inString.length() + imax;
        }
        if (imax < imin) {
            int tmp = imin;
            imin = imax;
            imax = tmp;
        }
        ++imax;
        if (imin < 0) {
            imin = 0;
        }
        if (imin > inString.length()) {
            imin = inString.length();
        }
        if (imax < 0) {
            imax = 0;
        }
        if (imax > inString.length()) {
            imax = inString.length();
        }
        return inString.substring(imin, imax);
    }

    public static String substring(String inString, int imin, int imax) {
        String outString = null;
        int len = inString.length();
        if (imin > imax) {
            int temp = imax;
            imax = imin;
            imin = temp;
        }
        if (imin < 0) {
            if (imax > len) {
                imax = len;
            } else if (imax < len) {
                ++imax;
            }
            imin = Math.max(0, imax + imin - 1);
        } else if (imin < len) {
            imax = Math.min(len, imax + 1);
        }
        try {
            outString = inString.substring(imin, imax);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outString;
    }

    public static String stripQuotes(String string) {
        if (string == null) {
            return string;
        }
        int ls = string.length();
        if (ls == 0 || string.charAt(0) != '\"') {
            return string;
        }
        if (string.charAt(ls - 1) != '\"') {
            return string.substring(1, ls);
        }
        return string.substring(1, ls - 1);
    }

    public static String padLeft(String str, int newlen) {
        return StringUtil.padLeft(str, newlen, ' ');
    }

    public static String padLeft(String str, int newlen, char padChar) {
        StringBuilder buffer = new StringBuilder(newlen);
        for (int ii = str.length(); ii < newlen; ++ii) {
            buffer.append(padChar);
        }
        return buffer.append(str).toString();
    }

    public static String padRight(String str, int newlen) {
        return StringUtil.padRight(str, newlen, ' ');
    }

    public static String padRight(String str, int newlen, char padChar) {
        int len = str.length();
        if (newlen <= len) {
            return str;
        }
        return StringUtil.padRight(new StringBuilder(newlen), str, newlen, padChar).toString();
    }

    public static StringBuilder padRight(StringBuilder destSB, String str, int padLen, char padChar) {
        destSB.append(str);
        for (int ii = str.length(); ii < padLen; ++ii) {
            destSB.append(padChar);
        }
        return destSB;
    }

    public static String padBoth(String str, int width, char padChar) {
        int ii;
        int addLeft = (width - str.length()) / 2;
        int addRight = width - str.length() - addLeft;
        StringBuilder buffer = new StringBuilder(width);
        for (ii = 0; ii < addLeft; ++ii) {
            buffer.append(padChar);
        }
        buffer.append(str);
        for (ii = 0; ii < addRight; ++ii) {
            buffer.append(padChar);
        }
        return buffer.toString();
    }

    public static String padBoth(String str, int newlen) {
        return StringUtil.padBoth(str, newlen, ' ');
    }

    public static boolean isWhitespace(String str) {
        return str.trim().length() == 0;
    }

    @Deprecated
    public static String getHTMLFor(String text) {
        String result = text;
        result = AMP_REGEX.matcher(result).replaceAll("&amp;");
        result = LT_REGEX.matcher(result).replaceAll("&lt;");
        result = GT_REGEX.matcher(result).replaceAll("&gt;");
        result = QUOTE_REGEX.matcher(result).replaceAll("&quot;");
        return result;
    }

    public static boolean isNull(String str) {
        return str == null || str.equalsIgnoreCase("NULL");
    }

    public static boolean isEmpty(CharSequence seq) {
        return seq == null || seq.length() == 0;
    }

    @InternalUseOnly
    public static boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return StringUtil.isEmpty(str) || StringUtil.isNull(str);
    }

    public static String convertNullsToEmpty(String str) {
        return StringUtil.isNull(str) ? "" : str;
    }

    public static Object convertNullsToEmpty(Object obj) {
        return obj == null || StringUtil.isNull(obj.toString()) ? "" : obj;
    }

    public static String getKeyValue(String inString, String tag) {
        return StringUtil.getKeyValue(inString, tag, null);
    }

    public static String getKeyValue(String inString, String tag, String delim) {
        int iTag;
        String value = null;
        if (delim == null || delim.length() <= 0) {
            delim = "=";
        }
        if ((iTag = inString.indexOf(tag + delim)) >= 0) {
            String subStr = inString.substring(iTag);
            int iDelim = subStr.indexOf(delim);
            subStr = subStr.substring(iDelim + delim.length() - 1);
            char[] charArray = new char[subStr.length()];
            subStr.getChars(0, subStr.length(), charArray, 0);
            int iWhiteSpace = subStr.length();
            for (int ii = 0; ii < charArray.length; ++ii) {
                if (!Character.isWhitespace(charArray[ii])) continue;
                iWhiteSpace = ii;
                break;
            }
            value = subStr.substring(1, iWhiteSpace);
        }
        return value;
    }

    public static String textToRegex(String text) {
        StringBuilder regex = new StringBuilder(text.length() + 5);
        block5: for (int ii = 0; ii < text.length(); ++ii) {
            switch (text.charAt(ii)) {
                case '\\': {
                    regex.append("\\\\");
                    continue block5;
                }
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    regex.append('\\');
                    regex.append(text.charAt(ii));
                    continue block5;
                }
                case '!': 
                case '$': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '|': {
                    regex.append('[');
                    regex.append(text.charAt(ii));
                    regex.append(']');
                    continue block5;
                }
                default: {
                    regex.append(text.charAt(ii));
                }
            }
        }
        return regex.toString();
    }

    public static String wildcardsToRegex(String text) {
        Pattern star = Pattern.compile("\\[[*]\\]");
        Pattern quest = Pattern.compile("\\[[?]\\]");
        String regex = StringUtil.textToRegex(text);
        regex = star.matcher(regex).replaceAll(".*");
        regex = quest.matcher(regex).replaceAll(".");
        return regex;
    }

    public static String textToReplacement(String text) {
        StringBuilder match = new StringBuilder(text.length() + 4);
        block4: for (int ii = 0; ii < text.length(); ++ii) {
            switch (text.charAt(ii)) {
                case '$': {
                    match.append("\\$");
                    continue block4;
                }
                case '\\': {
                    match.append("\\\\");
                    continue block4;
                }
                default: {
                    match.append(text.charAt(ii));
                }
            }
        }
        return match.toString();
    }

    public static String replaceAll(String string, String pattern, String replacement) {
        return string.replaceAll(StringUtil.textToRegex(pattern), StringUtil.textToReplacement(replacement));
    }

    public static String replaceFirst(String string, String pattern, String replacement) {
        return string.replaceFirst(StringUtil.textToRegex(pattern), StringUtil.textToReplacement(replacement));
    }

    public static String[] split(String val, String delim) {
        if (val == null || delim == null) {
            return null;
        }
        ArrayList<String> list3 = new ArrayList<String>(16);
        StringBuilder tmpStr = new StringBuilder(val.length());
        for (int ii = 0; ii < val.length(); ++ii) {
            char vc = val.charAt(ii);
            if (delim.indexOf(vc) == -1) {
                tmpStr.append(vc);
                continue;
            }
            list3.add(tmpStr.toString());
            tmpStr.setLength(0);
        }
        if (tmpStr.length() > 0) {
            list3.add(tmpStr.toString());
        }
        return list3.toArray(EMPTY_STRING_ARRAY);
    }

    public static String[] cleanSplit(String val, String delim) {
        String[] split2 = StringUtil.split(val, delim);
        if (split2 != null) {
            ArrayList<String> clean = new ArrayList<String>(split2.length);
            for (String str : split2) {
                if (str.length() <= 0) continue;
                clean.add(str);
            }
            return clean.toArray(new String[clean.size()]);
        }
        return null;
    }

    public static String[] split(String str) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] results = SEPATORS_REGEX.split(str);
        return results;
    }

    public static String[] cleanSplit(String str) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] results = StringUtil.split(str);
        ArrayList<String> cleanlist = new ArrayList<String>(results.length);
        for (String s : results) {
            if (s == null || s.length() <= 0) continue;
            cleanlist.add(s);
        }
        if (cleanlist.size() < results.length) {
            return cleanlist.toArray(EMPTY_STRING_ARRAY);
        }
        return results;
    }

    public static String getParsedElement(String string, int index, boolean clean) {
        Parser p = new Parser(string, clean);
        return p.get(index);
    }

    public static String getParsedElement(String string, int index, char delim, boolean clean) {
        Parser p = new Parser(string, clean);
        p.setDelimiter(delim);
        return p.get(index);
    }

    public static int getParsedElementIndex(String string, String element, boolean clean) {
        Parser p = new Parser(string, clean);
        String itemToCheck = clean ? element.toUpperCase() : element;
        int ii = 1;
        while (p.more()) {
            if (itemToCheck.equals(p.get(ii))) {
                return ii - 1;
            }
            ++ii;
        }
        return -1;
    }

    public static String[] parseString(String string, int elements, boolean clean) {
        return new Parser(string, clean).getArray(elements);
    }

    public static String[] parseString(String string, int elements, char delim, boolean clean) {
        Parser p = new Parser(string, clean);
        p.setDelimiter(delim);
        return p.getArray(elements);
    }

    public static String[] parseString(String string, boolean clean) {
        Parser p = new Parser(string, clean);
        return p.getArray(0);
    }

    public static String cleanString(String string) {
        return new Parser(string, true).getAll();
    }

    public static boolean isWildcardString(String str) {
        String WILDCARD_CHARACTERS = "*?#";
        if (str != null) {
            for (int ii = 0; ii < WILDCARD_CHARACTERS.length(); ++ii) {
                if (str.indexOf(WILDCARD_CHARACTERS.charAt(ii)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWildcardMatch(String pattern, String string) {
        return string.matches(StringUtil.wildcardsToRegex(pattern));
    }

    public static boolean isTrue(String str) {
        return str == null ? false : "|Y|YES|T|TRUE|ON|1|PASS|SUCCESS|ABSC|ABS|AB|".contains("|" + str.toUpperCase() + "|");
    }

    public static boolean isFalse(String str) {
        return str == null ? false : "|N|NO|F|FALSE|OFF|0|FAIL|INDEX|IND|IN|".contains("|" + str.toUpperCase() + "|");
    }

    public static boolean isNumber(String str) {
        return StringUtil.isFloat(str) || StringUtil.isHexInteger(str);
    }

    public static boolean isInteger(String str) {
        return StringUtil.matchesRegex(INTEGER_REGEX, str);
    }

    public static boolean isHexInteger(String str) {
        if (str == null) {
            return false;
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return StringUtil.matchesRegex(HEX_VAL_REGEX, str.substring(2));
        }
        return false;
    }

    public static boolean isFloat(String str) {
        return StringUtil.isInteger(str) || StringUtil.matchesRegex(FLOAT1_REGEX, str) || StringUtil.matchesRegex(FLOAT2_REGEX, str) || StringUtil.isNaN(str) || StringUtil.isInf(str);
    }

    public static boolean isNaN(String str) {
        return "NaN".equalsIgnoreCase(str);
    }

    public static boolean isInf(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.charAt(0) == '-' && StringUtil.isInf(str.substring(1)) || str.equalsIgnoreCase("Inf") || str.equalsIgnoreCase("Infinity") || str.length() == 1 && str.charAt(0) == '\u221e';
    }

    private static boolean matchesRegex(Pattern regex, String str) {
        return str != null && regex.matcher(str).matches();
    }

    public static int compareVersions(String first, String second) {
        String[] firstNums = first.toUpperCase().split("[.]");
        String[] secondNums = second.toUpperCase().split("[.]");
        int numDigitsCompare = Math.min(firstNums.length, secondNums.length);
        try {
            for (int ii = 0; ii < numDigitsCompare; ++ii) {
                int secondVal;
                int firstVal;
                if (firstNums[ii].equals("X") || secondNums[ii].equals("X") || (firstVal = Integer.parseInt(firstNums[ii])) == (secondVal = Integer.parseInt(secondNums[ii]))) continue;
                return firstVal - secondVal;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version number; given '" + first + "' and '" + second + "'.");
        }
        return firstNums.length - secondNums.length;
    }

    public static String toAsciiString(String str) {
        return StringUtil.toAsciiString(str, '?');
    }

    public static String toAsciiString(String str, char sub) {
        char[] chars = str.toCharArray();
        boolean allAscii = true;
        for (int ii = 0; ii < chars.length; ++ii) {
            if (chars[ii] <= '\u007f') continue;
            allAscii = false;
            chars[ii] = sub;
        }
        return allAscii ? str : new String(chars);
    }

    public static String toString(Object obj) {
        StringBuffer strBuf = new StringBuffer(40);
        return StringUtil.addToStringBuffer(strBuf, obj).toString();
    }

    public static StringBuffer addToStringBuffer(StringBuffer strBuf, Object obj) {
        int flagsPlusDisableEscape = Table.getDefaultFlagsInt() | 0x100;
        Table.toStringBuffer(obj, strBuf, flagsPlusDisableEscape);
        return strBuf;
    }

    public static String decodePercentEncoding(String str) {
        if (str == null) {
            return null;
        }
        boolean any = false;
        int max = str.length();
        int len = 0;
        byte[] chars = new byte[max];
        for (int ii = 0; ii < max; ++ii) {
            char c = str.charAt(ii);
            if (c == '%') {
                if (ii + 2 >= max) {
                    throw new IllegalArgumentException("Illegal URL escape sequence in '" + str + "' at position " + ii);
                }
                chars[len++] = (byte)Integer.parseInt(str.substring(ii + 1, ii + 3), 16);
                any = true;
                ii += 2;
                continue;
            }
            chars[len++] = (byte)c;
        }
        return any ? new String(chars, 0, len) : str;
    }

    public static String encodePercentEncoding(String str) {
        if (str == null) {
            return null;
        }
        try {
            str = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MidasException("Unable to percent-encode str: " + str, e);
        }
        return str;
    }

    public static String getAcronym(String str) {
        String returnValue = null;
        if (str != null) {
            StringBuilder acronym = new StringBuilder(8);
            for (int ii = 0; ii < str.length(); ++ii) {
                if (!Character.isUpperCase(str.charAt(ii))) continue;
                acronym.append(str.charAt(ii));
            }
            returnValue = acronym.toString();
        }
        return returnValue;
    }

    public static String getIpAddressString(int addr) {
        byte[] octets = new byte[]{(byte)(addr >> 24 & 0xFF), (byte)(addr >> 16 & 0xFF), (byte)(addr >> 8 & 0xFF), (byte)(addr & 0xFF)};
        return StringUtil.getIpAddressString(octets);
    }

    public static String getIpAddressString(byte[] octets) {
        InetAddress inet = null;
        if (octets == null) {
            throw new MidasException("StringUtil.getIpAddressString: Given octets=null.");
        }
        try {
            inet = InetAddress.getByAddress(octets);
        }
        catch (UnknownHostException e) {
            throw new MidasException("StringUtil.getIpAddressString: Illegal number of octets specified for IP address. Expected 4 octets (IPv4) or 16 octets (IPv6), given " + octets.length + " octets.", e);
        }
        return inet.getHostAddress();
    }

    public static int getIpv4AddressNumber(String addr) {
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw new MidasException("StringUtil.getIpv4AddressNumber: Unknown host '" + addr + "'", e);
        }
        byte[] octets = inet.getAddress();
        if (octets.length != 4) {
            throw new MidasException("StringUtil.getIpv4AddressNumber: Host '" + addr + "' does not map to a valid IPv4 address.");
        }
        return (octets[0] & 0xFF) << 24 | (octets[1] & 0xFF) << 16 | (octets[2] & 0xFF) << 8 | octets[3] & 0xFF;
    }

    public static String html2Text(String html) {
        String results = html;
        results = HTML2SPACES_REGEX.matcher(results).replaceAll(" ");
        results = HTML2NEWLINE_REGEX.matcher(results).replaceAll("\n");
        results = HTML_TAGS_REGEX.matcher(results).replaceAll("");
        results = HTML_LT_REGEX.matcher(results).replaceAll("<");
        results = HTML_GT_REGEX.matcher(results).replaceAll(">");
        results = HTML_AMP_REGEX.matcher(results).replaceAll("&");
        results = HTML_QUOTE_REGEX.matcher(results).replaceAll("\"");
        results = HTML_COPY_REGEX.matcher(results).replaceAll("[Copyright]");
        results = HTML_REG_REGEX.matcher(results).replaceAll("[Registered]");
        results = HTML_TRADE_REGEX.matcher(results).replaceAll("[Trademark]");
        return results;
    }

    public static String toHTML(CharSequence str) {
        if (str == null) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len * 2);
        block6: for (int ii = 0; ii < len; ++ii) {
            char ch = str.charAt(ii);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String fromHTML(String str) {
        int index = str.indexOf(38, 0);
        while (index >= 0) {
            int end = str.indexOf(59, index);
            if (end >= index + 2) {
                int num;
                if (str.charAt(index + 1) == '#') {
                    num = Convert.s2l(str.substring(index + 2, end));
                    str = str.substring(0, index) + (char)num + str.substring(end + 1);
                } else {
                    num = Arrays.binarySearch(ENTITY_NAMES, str.substring(index + 1, end));
                    if (num >= 0) {
                        str = str.substring(0, index) + ENTITY_VALUES[num] + str.substring(end + 1);
                    }
                }
            }
            index = str.indexOf(38, index + 1);
        }
        return str;
    }

    public static String insertEscapeChar(String str, String stringToInsert, char charToEscape) {
        if (stringToInsert == null || stringToInsert.isEmpty()) {
            stringToInsert = Character.toString('\\');
        }
        StringBuilder strBuilder = new StringBuilder(str);
        byte[] inbytes = str.getBytes();
        int offset = 0;
        for (int index = 0; index < inbytes.length; ++index) {
            if ((char)inbytes[index] != charToEscape) continue;
            strBuilder.insert(index + offset, stringToInsert);
            offset += stringToInsert.length();
        }
        return strBuilder.toString();
    }

    public static Format synchronizedFormat(Format form) {
        if (form == null) {
            throw new NullPointerException("Can not wrap null format.");
        }
        return new SynchronizedFormat(form);
    }

    public static String unescapeString(CharSequence input) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        StringBuilder outBuf = new StringBuilder(len);
        StringBuilder unicodeBuf = new StringBuilder(4);
        StringBuilder hexBuf = new StringBuilder(2);
        boolean hadSlash = false;
        boolean inUnicode = false;
        boolean inHex = false;
        block17: for (int ii = 0; ii < len; ++ii) {
            int value;
            char ch = input.charAt(ii);
            if (inUnicode) {
                unicodeBuf.append(ch);
                if (unicodeBuf.length() != 4) continue;
                try {
                    value = Integer.parseInt(unicodeBuf.toString(), 16);
                    outBuf.append((char)value);
                    unicodeBuf.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new MidasException("Invalid Unicode escape sequence specified (4 hex digits): " + unicodeBuf, nfe);
                }
            }
            if (inHex) {
                hexBuf.append(ch);
                if (hexBuf.length() != 2) continue;
                try {
                    value = Short.parseShort(hexBuf.toString(), 16);
                    outBuf.append((char)value);
                    hexBuf.setLength(0);
                    inHex = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new MidasException("Invalid Hex escape sequence specified (2 hex digits): " + hexBuf, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\"': {
                        outBuf.append('\"');
                        continue block17;
                    }
                    case 'n': {
                        outBuf.append('\n');
                        continue block17;
                    }
                    case '\\': {
                        outBuf.append('\\');
                        continue block17;
                    }
                    case 'r': {
                        outBuf.append('\r');
                        continue block17;
                    }
                    case 't': {
                        outBuf.append('\t');
                        continue block17;
                    }
                    case '\'': {
                        outBuf.append('\'');
                        continue block17;
                    }
                    case 'f': {
                        outBuf.append('\f');
                        continue block17;
                    }
                    case 'b': {
                        outBuf.append('\b');
                        continue block17;
                    }
                    case '0': {
                        outBuf.append('\u0000');
                        continue block17;
                    }
                    case 'u': {
                        inUnicode = true;
                        continue block17;
                    }
                    case 'x': {
                        inHex = true;
                        continue block17;
                    }
                    default: {
                        throw new MidasException("Invalid escape sequence specified: \\" + ch + " input=[" + input + "]");
                    }
                }
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            outBuf.append(ch);
        }
        if (inUnicode) {
            throw new MidasException("Invalid Unicode escape sequence specified (4 hex digits): " + unicodeBuf);
        }
        if (inHex) {
            throw new MidasException("Invalid Hex escape sequence specified (2 hex digits): " + hexBuf);
        }
        if (hadSlash) {
            throw new MidasException("Invalid escape sequence specified (single backslash): \\");
        }
        return outBuf.toString();
    }

    public static String escapeString(CharSequence input) {
        return StringUtil.escapeString(input, false);
    }

    public static String escapeString(CharSequence input, boolean escapeSingleQuotes) {
        if (input == null) {
            return null;
        }
        StringBuilder outBuf = new StringBuilder(input.length());
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (c == '\'' && escapeSingleQuotes) {
                outBuf.append('\\').append(c);
                continue;
            }
            if (c == '\"' || c == '\\' || c == '\t' || c == '\n' | c == '\r' || c == '\f' || c == '\b') {
                outBuf.append('\\');
                switch (c) {
                    case '\"': {
                        outBuf.append(c);
                        break;
                    }
                    case '\\': {
                        outBuf.append(c);
                        break;
                    }
                    case '\t': {
                        outBuf.append('t');
                        break;
                    }
                    case '\b': {
                        outBuf.append('b');
                        break;
                    }
                    case '\f': {
                        outBuf.append('f');
                        break;
                    }
                    case '\n': {
                        outBuf.append('n');
                        break;
                    }
                    case '\r': {
                        outBuf.append('r');
                        break;
                    }
                }
                continue;
            }
            if (c < ' ' || c > '~') {
                outBuf.append('\\');
                outBuf.append('u');
                short cint = (short)c;
                String hexC = Integer.toHexString(cint);
                switch (hexC.length()) {
                    case 1: {
                        hexC = "000" + hexC;
                        break;
                    }
                    case 2: {
                        hexC = "00" + hexC;
                        break;
                    }
                    case 3: {
                        hexC = "0" + hexC;
                        break;
                    }
                }
                outBuf.append(hexC);
                continue;
            }
            outBuf.append(c);
        }
        return outBuf.toString();
    }

    @InternalUseOnly
    public static StringBuilder toStringBuilder(Map<?, ?> map, String prependStr, String appendStr, String equalsStr) {
        StringBuilder sb = new StringBuilder(128);
        Iterator<Map.Entry<?, ?>> entries = map.entrySet().iterator();
        if (equalsStr == null) {
            equalsStr = " = ";
        }
        while (entries.hasNext()) {
            Map.Entry<?, ?> entry = entries.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (prependStr != null) {
                sb.append(prependStr);
            }
            sb.append(key).append(equalsStr).append(value);
            if (appendStr == null) continue;
            sb.append('\n');
        }
        return sb;
    }

    @InternalUseOnly
    public static StringBuilder toStringBuilder(Object[] array, String prependStr, String appendStr, boolean numberize) {
        StringBuilder sb = new StringBuilder(128);
        int ii = 0;
        for (Object value : array) {
            if (prependStr != null) {
                sb.append(prependStr);
            }
            if (numberize) {
                sb.append(++ii).append(". ");
            }
            sb.append(value);
            if (appendStr == null) continue;
            sb.append(appendStr);
        }
        return sb;
    }

    private static int validVariableLength(String str, int index) {
        int size = str.length();
        for (int ii = index; ii < size; ++ii) {
            char c = str.charAt(ii);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.') continue;
            if (ii == index) {
                return 0;
            }
            return ii - index;
        }
        return size - index;
    }

    public static String expandVariables(String text, Map<String, String> valueMap, int flags) {
        int iDollar;
        int textLen;
        if (text == null) {
            return text;
        }
        int j = textLen = text.length();
        while ((iDollar = text.lastIndexOf(36, j)) >= 0) {
            block11: {
                String obj;
                String tmp;
                int k;
                block14: {
                    block12: {
                        block13: {
                            block10: {
                                if (iDollar <= 1 || text.charAt(iDollar - 1) != '$') break block10;
                                text = text.substring(0, --iDollar) + text.substring(iDollar + 1);
                                break block11;
                            }
                            if (text.charAt(iDollar + 1) != '{') break block12;
                            k = text.indexOf(125, iDollar);
                            if (k >= iDollar + 1) break block13;
                            if ((flags & 1) == 0) {
                                throw new MidasException("Syntax Error: Can not expand $ variable: Missing closing '}' in \"" + text + "\" at char index " + iDollar);
                            }
                            break block11;
                        }
                        tmp = text.substring(iDollar + 2, k);
                        obj = valueMap.get(tmp);
                        ++k;
                        break block14;
                    }
                    j = StringUtil.validVariableLength(text, iDollar + 1);
                    if (j < 1) break block11;
                    k = iDollar + j + 1;
                    tmp = text.substring(iDollar + 1, k);
                    obj = valueMap.get(tmp);
                }
                if (obj != null) {
                    tmp = obj.toString();
                    if (k < textLen) {
                        tmp = tmp + text.substring(k);
                    }
                    if (iDollar == 0) {
                        return tmp;
                    }
                    text = text.substring(0, iDollar) + tmp;
                    textLen = text.length();
                }
            }
            j = iDollar - 1;
        }
        return text;
    }

    public static String toTitleCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        boolean anyChanges = false;
        boolean fixNext = true;
        char[] chars = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            char c = chars[i];
            if (Character.isSurrogate(c)) {
                return StringUtil._toTitleCaseCP(s);
            }
            if (Character.isWhitespace(c)) {
                fixNext = true;
                continue;
            }
            if (!fixNext) continue;
            chars[i] = Character.toTitleCase(c);
            anyChanges = true;
            fixNext = false;
        }
        return anyChanges ? new String(chars) : s;
    }

    private static String _toTitleCaseCP(String s) {
        boolean fixNext = true;
        int[] chars = s.codePoints().toArray();
        for (int i = 0; i < s.length(); ++i) {
            int c = chars[i];
            if (Character.isWhitespace(c)) {
                fixNext = true;
                continue;
            }
            if (!fixNext) continue;
            chars[i] = Character.toTitleCase(c);
            fixNext = false;
        }
        return new String(chars, 0, chars.length);
    }

    public static List<String> asStrList(Object obj) {
        if (obj == null) {
            return EMPTY_LIST;
        }
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            if (c.isEmpty()) {
                return EMPTY_LIST;
            }
            if (c instanceof List && c.stream().allMatch(v -> v == null || v instanceof String)) {
                return (List)obj;
            }
            ArrayList<String> list3 = new ArrayList<String>(c.size());
            c.forEach(v -> list3.add(v.toString()));
            return list3;
        }
        String str = obj.toString().trim();
        if (str.startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1).trim();
        }
        return str.isEmpty() ? EMPTY_LIST : Arrays.asList(str.split(",[ ]*"));
    }

    public static SortedSet<String> asStrSet(Object obj) {
        List<String> list3 = StringUtil.asStrList(obj);
        return list3 == EMPTY_LIST ? EMPTY_SET : new TreeSet<String>(list3);
    }

    public static String getWordByString(String inString, String subString) {
        Parser p = new Parser(inString);
        String outString = null;
        for (int i = 1; i <= p.elements(); ++i) {
            String word = p.get(i);
            if (word.indexOf(subString) < 0) continue;
            outString = word;
        }
        return outString;
    }

    public static String getWordByElement(String inString, int elemNum, String delimString) {
        String outString = null;
        if (delimString == null || delimString.length() == 0) {
            delimString = ",";
        }
        String[] strArray = inString.split(StringUtil.textToRegex(delimString));
        if (elemNum > 0 && elemNum - 1 < strArray.length) {
            outString = strArray[elemNum - 1];
        }
        return outString;
    }

    public static String subs(String string, String p1, String p2, boolean all) {
        if (all) {
            return StringUtil.replaceAll(string, p1, p2);
        }
        return StringUtil.replaceFirst(string, p1, p2);
    }

    public static int nelements(String string) {
        return StringUtil.nelements(string, ",");
    }

    public static int nelements(String string, char delim) {
        return StringUtil.nelements(string, String.valueOf(delim));
    }

    public static int nelements(String string, String delim) {
        int retval = 0;
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase("NULL")) {
            char[] charArray = new char[string.length()];
            char[] delimArray = new char[delim.length()];
            char[] subCharArray = new char[delim.length()];
            string.getChars(0, string.length(), charArray, 0);
            delim.getChars(0, delim.length(), delimArray, 0);
            int numDelims = 0;
            for (int i = 0; i <= charArray.length - delimArray.length; ++i) {
                if (charArray[i] != delimArray[0] || !Arrays.equals(subCharArray = Arrays.copyOfRange(charArray, i, i + delimArray.length), delimArray)) continue;
                ++numDelims;
            }
            retval = numDelims + 1;
        }
        return retval;
    }

    public static String range(String string, int p1, int p2) {
        p2 = p2 < 0 ? string.length() + p2 : ++p2;
        if (p1 < 0) {
            p1 = string.length() + p1 - 1;
        }
        if (p2 < p1 || p1 > string.length()) {
            return null;
        }
        p2 = Math.max(p1, Math.min(string.length(), p2));
        return string.substring(p1, p2);
    }

    public static String getStringInRange(String inString, int imin, int imax) {
        if (imin < 0) {
            imin = inString.length() + imin;
        }
        if (imax < 0) {
            imax = inString.length() + imax;
        }
        if (imin < 0 || ++imax > inString.length() || imin > imax || imax < 0 || imin > inString.length()) {
            return "";
        }
        return inString.substring(imin, imax);
    }

    public static int select(String inString, String subString) {
        int retVal = Parser.find(inString, subString, -1);
        if (retVal > 0) {
            --retVal;
        }
        return retVal;
    }

    public static String pad(String string, int newLen, String dir, String padStr) {
        char pad = ' ';
        if (padStr != null && padStr.length() != 0) {
            pad = padStr.charAt(0);
        }
        String outString = null;
        outString = dir.startsWith("PADL") || dir.equals("LEFT") ? StringUtil.padLeft(string, newLen, pad) : (dir.startsWith("PADB") || dir.equals("BOTH") || dir.equals("CENTER") ? StringUtil.padBoth(string, newLen, pad) : StringUtil.padRight(string, newLen, pad));
        return outString;
    }

    public static int getOccurrenceOf(String inString, String subString, int n) {
        int index = inString.indexOf(subString);
        for (int i = 0; i < n - 1; ++i) {
            if ((index = inString.indexOf(subString, index + subString.length())) <= inString.length() && index >= 0) continue;
            index = -1;
            break;
        }
        return index;
    }

    public static int selectElement(String inString, String subString) {
        return Parser.find(inString, subString, -1);
    }

    public static int length(String string, int index) {
        if (index < 0) {
            return string.length();
        }
        Parser p = new Parser(string);
        int ls = p.lengthd(0);
        for (int i = 1; i < index + 1; ++i) {
            ++ls;
            ls += p.lengthd(ls);
        }
        return ls;
    }

    public static int lengthElement(String string, int index) {
        if (index <= 0) {
            return string.length();
        }
        Parser p = new Parser(string);
        int ls = p.lengthd(0);
        for (int i = 1; i < index; ++i) {
            ++ls;
            ls += p.lengthd(ls);
        }
        return ls;
    }

    public static String nform(double dval, String pattern) {
        Data D = new Data(dval);
        return D.toString(pattern);
    }

    public static String parse(String string, int element, String delim, boolean clean) {
        if (delim == null || delim.length() == 0) {
            return StringUtil.getParsedElement(string, element, clean);
        }
        return StringUtil.getParsedElement(string, element, delim.charAt(0), clean);
    }

    public static String[] parseAll(String string, int elements, String delim, boolean clean) {
        if (delim == null || delim.length() == 0) {
            return StringUtil.parseString(string, elements, clean);
        }
        return StringUtil.parseString(string, elements, delim.charAt(0), clean);
    }

    @InternalUseOnly
    public static boolean containsCommonCharacter(String s1, String s2) {
        for (int i = 0; i < s1.length(); ++i) {
            char s = s1.charAt(i);
            if (s2.indexOf(s) < 0) continue;
            return true;
        }
        return false;
    }

    private static final class SynchronizedFormat
    extends Format {
        private static final long serialVersionUID = -2343446153995335036L;
        private final Format form;

        SynchronizedFormat(Format form) {
            this.form = form;
        }

        @Override
        public synchronized StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return this.form.format(obj, toAppendTo, pos);
        }

        @Override
        public synchronized AttributedCharacterIterator formatToCharacterIterator(Object obj) {
            return this.form.formatToCharacterIterator(obj);
        }

        @Override
        public synchronized Object parseObject(String source) throws ParseException {
            return this.form.parseObject(source);
        }

        @Override
        public synchronized Object parseObject(String source, ParsePosition pos) {
            return this.form.parseObject(source, pos);
        }

        public int hashCode() {
            return this.form.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof SynchronizedFormat && this.form.equals(((SynchronizedFormat)obj).form);
        }

        @Override
        public Object clone() {
            return super.clone();
        }
    }
}

