/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasThread;

public class SocketResource
extends IOResource
implements Runnable {
    public static final int UNTANGLE = 1;
    public static final int CLOSED = -1;
    public static final int REOPEN = -2;
    InputStream sis;
    OutputStream sos;
    ServerSocket server;
    Socket socketToMe;
    String host;
    int port;
    long skip;
    int timeout;
    long soffset;

    @Override
    public boolean exists() {
        return this.dir < 0;
    }

    @Override
    public boolean isStream() {
        return true;
    }

    @Override
    public void setURL(String str) {
        super.setURL(str);
        if (str.startsWith("stp://")) {
            str = str.substring(6);
        } else if (str.startsWith("stp:/")) {
            str = str.substring(5);
        } else if (str.startsWith("stp:")) {
            str = str.substring(4);
        }
        int i = str.indexOf(":");
        this.host = str.substring(0, i);
        this.port = Convert.s2l(str.substring(i + 1));
    }

    @Override
    public boolean open() {
        block6: {
            this.isOpen = false;
            double t = this.qualTable == null ? 0.0 : this.qualTable.getD("TIMEOUT", 0.0);
            this.timeout = (int)(t * 1000.0);
            if (t > 0.0 && this.timeout <= 0) {
                this.timeout = 1;
            }
            try {
                if (this.dir > 0) {
                    this.server = new ServerSocket(this.port);
                    this.server.setSoTimeout(this.timeout);
                    this.sos = this.getOutputStream(false);
                } else if (this.dir <= 0) {
                    this.sis = this.getInputStream(false);
                }
                this.isOpen = true;
            }
            catch (Exception e) {
                if (!this.M.debug(256)) break block6;
                this.M.warning("SocketResource - exception during open()" + e);
            }
        }
        this.soffset = 0L;
        return this.isOpen;
    }

    @Override
    public boolean close() {
        try {
            if (this.sis != null) {
                this.sis.close();
                this.sis = null;
            }
            if (this.sos != null) {
                this.sos.close();
                this.sos = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            this.isOpen = false;
        }
        catch (IOException e) {
            this.isOpen = true;
        }
        return this.isOpen;
    }

    @Override
    public InputStream getInputStream() {
        return this.getInputStream(true);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getOutputStream(true);
    }

    protected InputStream getInputStream(boolean indefinite) {
        while (this.isOpen && this.sis == null) {
            try {
                Socket socket = new Socket(this.host, this.port);
                socket.setSoTimeout(this.timeout);
                this.sis = socket.getInputStream();
            }
            catch (SocketTimeoutException e) {
                if (indefinite) continue;
                return null;
            }
            catch (Exception e) {
                throw new MidasException("Error connecting to " + this.host + ":" + this.port + ": " + e, e);
            }
        }
        return this.sis;
    }

    protected OutputStream getOutputStream(boolean indefinite) {
        while (this.isOpen && this.sos == null) {
            try {
                Socket socket = this.server.accept();
                socket.setSoTimeout(this.timeout);
                this.sos = socket.getOutputStream();
            }
            catch (SocketTimeoutException e) {
                if (indefinite) continue;
                return null;
            }
            catch (Exception e) {
                throw new MidasException("Error connecting to port " + this.port + ": " + e, e);
            }
        }
        return this.sos;
    }

    @Override
    public boolean seek(long off) {
        boolean ok = off >= this.soffset;
        this.offset = off;
        return ok;
    }

    @Override
    public long seek() {
        return this.offset;
    }

    @Override
    public long avail() {
        if (this.sis == null) {
            return 0L;
        }
        try {
            return (long)this.sis.available() + this.soffset - this.offset;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int togo = bytes;
        try {
            while (this.offset < this.soffset && togo > 0) {
                buf[boff++] = 0;
                --togo;
                ++this.offset;
            }
            while (this.soffset < this.offset) {
                int skip = (int)Math.min(this.offset - this.soffset, (long)bytes);
                int num = this.getInputStream(true).read(buf, boff, skip);
                if (num >= 0) {
                    this.soffset += (long)num;
                    continue;
                }
                return -1;
            }
            while (togo > 0) {
                int num = this.getInputStream(true).read(buf, boff, togo);
                if (num >= 0) {
                    togo -= num;
                    boff += num;
                    this.offset += (long)num;
                    this.soffset = this.offset;
                    continue;
                }
                if (togo != bytes) break;
                return -1;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return bytes - togo;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        int togo = bytes;
        byte[] fbuf = null;
        try {
            while (this.offset < this.soffset && togo > 0) {
                ++boff;
                --togo;
                ++this.offset;
            }
            while (this.soffset < this.offset) {
                int fill;
                if (fbuf == null) {
                    fbuf = new byte[bytes];
                }
                int num = fill = (int)Math.min(this.offset - this.soffset, (long)bytes);
                this.getOutputStream(true).write(fbuf, 0, fill);
                if (num >= 0) {
                    this.soffset += (long)num;
                    continue;
                }
                return -1;
            }
            while (togo > 0) {
                int num = togo;
                this.getOutputStream(true).write(buf, boff, togo);
                if (num >= 0) {
                    togo -= num;
                    boff += num;
                    this.offset += (long)num;
                    this.soffset = this.offset;
                    continue;
                }
                if (togo != bytes) break;
                return -1;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return bytes - togo;
    }

    public Socket[] connectSockets(String host, int port, int nsock, int timeout, int flags) {
        this.host = host;
        this.port = port;
        Socket[] socks = new Socket[nsock];
        try {
            for (int i = 0; i < nsock; ++i) {
                MidasThread thread = new MidasThread(this.M, (Runnable)this);
                thread.start();
                thread.join(timeout);
                if (thread.isAlive()) {
                    thread.interrupt();
                    Thread.sleep(500L);
                    return null;
                }
                socks[i] = this.socketToMe;
            }
            if (nsock == 2 && (flags & 1) != 0) {
                byte[] bufi = new byte[16];
                byte[] bufo = new byte[16];
                socks[0].getInputStream().read(bufi);
                socks[1].getInputStream().read(bufo);
                if ((char)bufi[0] != 'S') {
                    Socket stmp = socks[0];
                    socks[0] = socks[1];
                    socks[1] = stmp;
                }
            }
            return socks;
        }
        catch (Exception e) {
            throw new MidasException("Connect Sockets", e);
        }
    }

    @Override
    public void run() {
        try {
            this.socketToMe = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            throw new MidasException("Socket connect", e);
        }
    }
}

