/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.XmUtil;

public class Registry {
    static Table stable = new Table();
    public static Table handlers = new Table();
    private final Map<Thread, Command> threads = Collections.synchronizedMap(new LinkedHashMap());
    public Table table = stable;

    public void put(String name, Object entry) {
        this.table.put(name, entry);
        if (entry instanceof Command) {
            Command cmd = (Command)entry;
            Thread thread = cmd.thread;
            if (thread != null) {
                this.threads.put(thread, cmd);
            }
        }
    }

    public synchronized String putInstance(String name, Object entry) {
        String instanceName = name;
        int i = 0;
        while (this.get(instanceName) != null) {
            instanceName = name + "_" + i;
            ++i;
        }
        this.put(instanceName, entry);
        return instanceName;
    }

    public Object get(String name) {
        return Registry.get(this.table, name, 0);
    }

    public Object get(String name, int wait) {
        return Registry.get(this.table, name, wait);
    }

    private static Object get(Table tbl, String name, int wait) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.equals("1")) {
            name = "MAIN";
        }
        Object entry = tbl.get(name);
        for (int i = wait * 10; entry == null && i > 0; --i) {
            Time.sleep(0.1);
            entry = tbl.get(name);
        }
        if (wait == -1 && entry == null) {
            throw new MidasException("Could not find REG." + name);
        }
        return entry;
    }

    public <T extends Command> T get(String name, Class<T> type, int wait) {
        Object entry = this.get(name, wait);
        if (type.isInstance(entry) || entry == null) {
            return (T)((Command)type.cast(entry));
        }
        throw new MidasException("Expected instance of " + type + " for REG." + name + " but found " + entry.getClass());
    }

    public Command getCommand(String name, int wait) {
        Object entry = this.get(name, wait);
        return entry instanceof Command ? (Command)entry : null;
    }

    public MessageHandler getMessageHandler(String name) {
        return this.getMessageHandler(name, 0);
    }

    public MessageHandler getMessageHandler(String name, int wait) {
        return this.getMessageHandler(name, wait, this.table);
    }

    private MessageHandler getMessageHandler(String name, int wait, Table initialRegTable) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("XM.")) {
            return XmUtil.getXmMessageHandler(name);
        }
        Table tbl = initialRegTable;
        if (name.startsWith("GLOBAL.")) {
            name = name.substring(7);
            tbl = stable;
        } else if (name.startsWith("PARENT.")) {
            Midas midas = Convert.ref2Midas(tbl.getO("MAIN"));
            if (midas != null && midas.parent != null) {
                name = name.substring(7);
                tbl = midas.parent.registry.table;
                if (name.startsWith("PARENT.")) {
                    return this.getMessageHandler(name, wait, tbl);
                }
            } else {
                name = name.substring(7);
                tbl = stable;
            }
        }
        Object entry = Registry.get(tbl, name, wait);
        return entry instanceof MessageHandler ? (MessageHandler)entry : null;
    }

    public void remove(String name) {
        this.table.remove(name);
        this.threads.remove(Thread.currentThread());
    }

    public void clear() {
        this.table.clear();
    }

    public Command getThreadOwner() {
        return this.threads.get(Thread.currentThread());
    }

    public static String getHandlerName(String key) {
        return (String)handlers.get(key);
    }

    public static Object getHandler(String key) {
        String className = Registry.getHandlerName(key);
        if (className == null) {
            return null;
        }
        return Shell.getInstanceForClassName(className);
    }
}

