/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import java.util.Vector;
import nxm.sys.inc.PropertyViewedListener;

public final class PropertyListeners {
    private final Object source;
    private final List<PropertyChangeListener> changeListeners;
    private final List<VetoableChangeListener> vetoListeners;
    private final List<PropertyViewedListener> viewedListeners;

    public PropertyListeners(Object source) {
        this.source = source;
        this.changeListeners = new Vector<PropertyChangeListener>();
        this.vetoListeners = new Vector<VetoableChangeListener>();
        this.viewedListeners = new Vector<PropertyViewedListener>();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners.add(listener);
    }

    public void addPropertyViewedListener(PropertyViewedListener listener) {
        this.viewedListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners.remove(listener);
    }

    public void removePropertyViewedListener(PropertyViewedListener listener) {
        this.viewedListeners.remove(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeListeners.toArray(new PropertyChangeListener[0]);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoListeners.toArray(new VetoableChangeListener[0]);
    }

    public PropertyViewedListener[] getPropertyViewedListeners() {
        return this.viewedListeners.toArray(new PropertyViewedListener[0]);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener changeListener : this.changeListeners) {
            changeListener.propertyChange(evt);
        }
    }

    public final void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
    }

    public void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        int i;
        try {
            for (i = 0; i < this.changeListeners.size(); ++i) {
                this.vetoListeners.get(i).vetoableChange(evt);
            }
        }
        catch (PropertyVetoException e) {
            PropertyChangeEvent revert = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), null, evt.getOldValue());
            for (i = 0; i >= 0; --i) {
                try {
                    this.vetoListeners.get(i).vetoableChange(revert);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            throw e;
        }
        this.firePropertyChange(evt);
    }

    public final void firePropertyView(String propertyName, Object oldValue) {
        this.firePropertyView(new PropertyViewedListener.PropertyViewEvent(this.source, propertyName, oldValue));
    }

    public void firePropertyView(PropertyViewedListener.PropertyViewEvent evt) {
        for (PropertyViewedListener viewedListener : this.viewedListeners) {
            viewedListener.propertyView(evt);
        }
    }

    public static class HasPropertyListeners {
        protected final PropertyListeners listeners = new PropertyListeners(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.addPropertyChangeListener(listener);
        }

        public void addVetoableChangeListener(VetoableChangeListener listener) {
            this.listeners.addVetoableChangeListener(listener);
        }

        public void addPropertyViewedListener(PropertyViewedListener listener) {
            this.listeners.addPropertyViewedListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.listeners.removePropertyChangeListener(listener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener listener) {
            this.listeners.removeVetoableChangeListener(listener);
        }

        public void removePropertyViewedListener(PropertyViewedListener listener) {
            this.listeners.removePropertyViewedListener(listener);
        }

        public PropertyChangeListener[] getPropertyChangeListeners() {
            return this.listeners.getPropertyChangeListeners();
        }

        public VetoableChangeListener[] getVetoableChangeListeners() {
            return this.listeners.getVetoableChangeListeners();
        }

        public PropertyViewedListener[] getPropertyViewedListeners() {
            return this.listeners.getPropertyViewedListeners();
        }
    }
}

