/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxm.sys.inc.Constants;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;
import nxm.sys.libm.Tolerance;

public class Position
implements Constants,
Keyable,
Cloneable,
Tablizable {
    private static final Map<String, String> SV_KEY_MAP = Stream.of({"ETIM", "TIME"}, {"POSX", "X"}, {"POSY", "Y"}, {"POSZ", "Z"}, {"VELX", "VX"}, {"VELY", "VY"}, {"VELZ", "VZ"}, {"ACCX", "AX"}, {"ACCY", "AY"}, {"ACCZ", "AZ"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    public static final int NORMAL = 0;
    public static final int GEODETIC = 1;
    public static final int GRAPH3D = 2;
    @InternalUseOnly
    public int referenceFrame = 0;
    @InternalUseOnly
    public double x;
    @InternalUseOnly
    public double y;
    @InternalUseOnly
    public double z;
    @InternalUseOnly
    public double r;
    @InternalUseOnly
    public double t;
    @InternalUseOnly
    public double lat;
    @InternalUseOnly
    public double lon;
    @InternalUseOnly
    public double alt;
    protected BaseFile inFile;
    protected Data db;
    protected int iPos;
    protected int iPosOff;
    protected List<Table> data;
    protected Transform transform;
    protected SVMode svMode;
    protected Time currentTime = new Time();
    private static boolean useEfficientSVKeywordCode = true;
    private static final Comparator<Map.Entry<String, Object>> SV_COMPARATOR = new Comparator<Map.Entry<String, Object>>(){

        @Override
        public int compare(Map.Entry<String, Object> a, Map.Entry<String, Object> b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return this.compareKeys(a.getKey(), b.getKey());
        }

        private int compareKeys(String a, String b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            try {
                Integer anum = Integer.valueOf(a.substring(4));
                Integer bnum = Integer.valueOf(b.substring(4));
                return anum.compareTo(bnum);
            }
            catch (NumberFormatException e) {
                return a.compareTo(b);
            }
        }
    };
    private static String[] keys = new String[]{"X", "Y", "Z", "R", "T", "LAT", "LON", "ALT", "FRAME"};

    public Position() {
    }

    public Position(int referenceFrame) {
        if (referenceFrame == 1) {
            this.setGeo(0.0, 0.0, 0.0);
        }
        this.referenceFrame = referenceFrame;
    }

    @Deprecated
    public Position(Object ref, Object name) {
        this.setFile(ref, name);
    }

    public Position(MidasReference ref, Object name) {
        this.setFile(ref, name);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public Position(BaseFile file) {
        this.setFile(file);
    }

    public Position copy() {
        return this.copyTo(new Position());
    }

    protected Position copyTo(Position p) {
        p.x = this.x;
        p.lon = this.lon;
        p.y = this.y;
        p.lat = this.lat;
        p.z = this.z;
        p.alt = this.alt;
        p.r = this.r;
        p.t = this.t;
        p.referenceFrame = this.referenceFrame;
        p.transform = this.transform;
        p.currentTime = this.currentTime;
        return p;
    }

    @Override
    public Table toTable() {
        Table tbl = new Table();
        tbl.put("LON", this.getLon());
        tbl.put("LAT", this.getLat());
        tbl.put("ALT", this.getAlt());
        tbl.put("X", this.getX());
        tbl.put("Y", this.getY());
        tbl.put("Z", this.getZ());
        tbl.put("R", this.getR());
        tbl.put("TIME", this.getTime());
        tbl.put("CURRENTTIME", (Object)this.getCurrentTime());
        return tbl;
    }

    public void setTransform(Transform xform) {
        this.transform = xform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setGeoALL(double[] all) {
        this.setGeo(all[0], all[1], all[2]);
    }

    public void setGeoLLA(double[] lla) {
        this.setGeo(lla[2], lla[1], lla[0]);
    }

    public void setGeo(double alt, double lat, double lon) {
        this.alt = alt;
        this.lat = lat;
        this.lon = lon;
        this.referenceFrame = 1;
        this.geo2car();
    }

    public double getAlt() {
        return this.alt;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setAlt(double val) {
        this.alt = val;
    }

    public void setLat(double val) {
        this.lat = val;
    }

    public void setLon(double val) {
        this.lon = val;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double val) {
        this.r = val;
    }

    public void setCar(double[] pos) {
        this.setCar(pos[0], pos[1], pos[2]);
    }

    public void setCar(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.referenceFrame = 0;
        this.car2geo();
    }

    public void setX(double val) {
        this.x = val;
    }

    public void setY(double val) {
        this.y = val;
    }

    public void setZ(double val) {
        this.z = val;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getVX() {
        return 0.0;
    }

    public double getVY() {
        return 0.0;
    }

    public double getVZ() {
        return 0.0;
    }

    public double getAX() {
        return 0.0;
    }

    public double getAY() {
        return 0.0;
    }

    public double getAZ() {
        return 0.0;
    }

    public double getVN() {
        return 0.0;
    }

    public double getVE() {
        return 0.0;
    }

    public double getVU() {
        return 0.0;
    }

    public double getAN() {
        return 0.0;
    }

    public double getAE() {
        return 0.0;
    }

    public double getAU() {
        return 0.0;
    }

    public double greatArc(Position q) {
        return Transform.greatArc(this, q);
    }

    public void geo2car() {
        Transform.geo2car(this);
    }

    @Deprecated
    public void geo2ecr() {
        Shell.getSharedMidasContext().deprecate("geo2ecr: Since NeXtMidas 2.3.0 use the geo2car method");
        this.geo2car();
    }

    public void car2geo() {
        Transform.car2geo(this);
    }

    @Deprecated
    public void ecr2geo() {
        Shell.getSharedMidasContext().deprecate("ecr2geo: Since NeXtMidas 2.3.0 use the car2geo method");
        this.car2geo();
    }

    public String toString(int refFrame) {
        if (refFrame == 1) {
            return "PosLonLatAlt(" + this.lon + "," + this.lat + "," + this.alt + ")";
        }
        return "PosXYZT(" + this.x + "," + this.y + "," + this.z + "," + this.t + ")";
    }

    public String toString() {
        return this.toString(this.referenceFrame);
    }

    public void setTime(double value) {
        if (this.db == null && this.data == null) {
            this.currentTime = new Time(value);
            this.t = value;
        } else if (value <= 3.16224E7) {
            this.setCurrentTime(this.getStartTime().addSec(value));
        } else {
            this.setCurrentTime(new Time(value));
        }
    }

    public double getTime() {
        return this.t;
    }

    public boolean setCurrentTime(Time value) {
        boolean ok;
        if (this.db == null && this.data == null) {
            this.currentTime = value;
            this.t = value.getSec();
            ok = false;
        } else {
            this.currentTime = value;
            this.t = value.diff(this.getStartTime());
            boolean bl = ok = value.compareTo(this.getStartTime()) >= 0 && value.compareTo(this.getEndTime()) <= 0;
        }
        if (this.inFile != null) {
            this.process();
        }
        return ok;
    }

    public Time getCurrentTime() {
        return this.currentTime;
    }

    public Time getStartTime() {
        if (this.db != null) {
            return ((DataFile)this.inFile).getTime();
        }
        if (this.data != null) {
            return Position.getTimeAt(this.data, 0);
        }
        return this.getCurrentTime();
    }

    public Time getEndTime() {
        if (this.db != null) {
            return ((DataFile)this.inFile).getTimeAt(this.db.getSize() - 1, null);
        }
        if (this.data != null) {
            return Position.getTimeAt(this.data, -1);
        }
        return this.getCurrentTime();
    }

    static Time getTimeAt(List<Table> data, int i) {
        if (i < 0) {
            i = data.size() + i;
        }
        return new Time(Time.toTime(data.get(i).getO("TIME")));
    }

    @Deprecated
    public final boolean setFile(Object ref, Object filename) {
        return this.setFile(ref, filename, 0, null) != null;
    }

    public final boolean setFile(MidasReference ref, Object filename) {
        return this.setFile(ref, filename, 0, null) != null;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public final boolean setFile(BaseFile file) {
        return this.setFile(file, 0, null) != null;
    }

    @Deprecated
    public final SVMode setFile(Object ref, Object filename, int flags, SVMode mode) {
        if (ref instanceof MidasReference) {
            return this.setFile((MidasReference)ref, filename, flags, mode);
        }
        return this.setFile(Convert.ref2Midas(ref), filename, flags, mode);
    }

    public final SVMode setFile(MidasReference ref, Object filename, int flags, SVMode mode) {
        return this.setFile(BaseFile.getInstanceFor(ref, filename), flags, mode);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.5.4")
    public final SVMode setFile(BaseFile file, int flags, SVMode mode) {
        boolean doOpen;
        this.inFile = file;
        this.db = null;
        this.data = null;
        this.svMode = null;
        boolean bl = doOpen = !this.inFile.isOpen();
        if (doOpen && !this.inFile.open(1 | flags)) {
            return null;
        }
        if (this.inFile instanceof DataFile) {
            DataFile df = (DataFile)this.inFile;
            if (mode == null) {
                if (this.setFileT5Data(df)) {
                    this.svMode = SVMode.T5Data;
                } else if (this.setFileT5Entries(df)) {
                    this.svMode = SVMode.T5Entries;
                } else if (this.setFileEntries(df)) {
                    this.svMode = SVMode.Entries;
                } else if (this.setFileKeywordsEph(df, false)) {
                    this.svMode = SVMode.KeywordsEph;
                } else if (this.setFileKeywordsVec(df)) {
                    this.svMode = SVMode.KeywordsVec;
                } else if (this.setFileKeywordsPlat(df)) {
                    this.svMode = SVMode.KeywordsPlat;
                } else if (this.setFileKeywordsLLA(df)) {
                    this.svMode = SVMode.KeywordsLLA;
                } else if (this.setFileKeywordsEph(df, true)) {
                    this.svMode = SVMode.KeywordsEph;
                }
            } else {
                switch (mode) {
                    case T5Data: {
                        if (!this.setFileT5Data(df)) break;
                        this.svMode = mode;
                        break;
                    }
                    case T5Entries: {
                        if (!this.setFileT5Entries(df)) break;
                        this.svMode = mode;
                        break;
                    }
                    case Entries: {
                        if (!this.setFileEntries(df)) break;
                        this.svMode = mode;
                        break;
                    }
                    case KeywordsEph: {
                        if (!this.setFileKeywordsEph(df, true)) break;
                        this.svMode = mode;
                        break;
                    }
                    case KeywordsVec: {
                        if (!this.setFileKeywordsVec(df)) break;
                        this.svMode = mode;
                        break;
                    }
                    case KeywordsPlat: {
                        if (!this.setFileKeywordsPlat(df)) break;
                        this.svMode = mode;
                        break;
                    }
                    case KeywordsLLA: {
                        if (!this.setFileKeywordsLLA(df)) break;
                        this.svMode = mode;
                    }
                }
            }
        } else if (this.inFile instanceof ListFile) {
            ListFile lf = (ListFile)((Object)this.inFile);
            if (mode == null) {
                if (this.setFileEntries(lf)) {
                    this.svMode = SVMode.Entries;
                }
            } else {
                switch (mode) {
                    case Entries: {
                        if (!this.setFileEntries(lf)) break;
                        this.svMode = mode;
                        break;
                    }
                }
            }
        }
        if (doOpen) {
            this.inFile.close();
        }
        if (this.svMode == null && (this.inFile.getFlags() & 0x20) == 0) {
            String msg = "Could not find Position/StateVector data in " + this.inFile.getName();
            if (mode == null) {
                throw new MidasException(msg);
            }
            throw new MidasException(msg + " matching " + (Object)((Object)mode));
        }
        this.process();
        return this.svMode;
    }

    protected boolean setFileT5Data(DataFile df) {
        if (df.getTypeCodeClass() != 5) {
            return false;
        }
        if (df.findRec("TIME") >= 0) {
            return false;
        }
        this.iPos = df.findRec("POS");
        int n = this.iPosOff = this.iPos < 0 ? -1 : (int)df.getCompOffset(this.iPos);
        if (this.iPos < 0 || this.iPosOff < 0) {
            return false;
        }
        if (!df.getRecFormat(this.iPos).equals("VD")) {
            return false;
        }
        this.db = df.getDataBuffer((int)df.getSize());
        df.read(this.db);
        this.referenceFrame = 1;
        this.transform = new Transform(df);
        return true;
    }

    protected boolean setFileT5Entries(DataFile df) {
        if (!this.setFileEntries(df)) {
            return false;
        }
        if (df.getTypeCodeClass() == 5) {
            this.referenceFrame = 1;
            this.transform = new Transform(df);
        }
        return true;
    }

    protected boolean setFileEntries(ListFile lf) {
        Table recDefs = lf.getRecordDefs();
        if (!recDefs.containsKey("POS")) {
            return false;
        }
        if (recDefs.containsKey("TIME")) {
            this.data = new ArrayList<Table>();
            int i = 0;
            while ((double)i < lf.getNumberOfRows()) {
                this.data.add(this.normalizeRow(lf.getDataTable(i), null));
                ++i;
            }
        } else if (lf instanceof PlotFile) {
            this.data = new ArrayList<Table>();
            PlotFile pf = (PlotFile)((Object)lf);
            int i = 0;
            while ((double)i < lf.getNumberOfRows()) {
                this.data.add(this.normalizeRow(lf.getDataTable(i), pf.getTimeAt(i)));
                ++i;
            }
        } else {
            return false;
        }
        this.referenceFrame = 1;
        this.transform = Transform.toTransform("ECR");
        return true;
    }

    protected boolean setFileKeywordsEph(DataFile df, boolean force) {
        boolean noETIM1;
        Keywords kw = df.getKeywordsObject();
        Double use_sv_keywords = kw.getD("USE_SV_KEYWORDS", null);
        boolean bl = noETIM1 = kw.find("ETIM1") == null;
        if (use_sv_keywords == null) {
            if (!force || noETIM1) {
                return false;
            }
        } else if (use_sv_keywords != 1.0) {
            if (!force || noETIM1) {
                return false;
            }
            Shell.warning("Reading KeywordsEph from " + df.getName() + " even though USE_SV_KEYWORDS=" + use_sv_keywords + ".");
        } else if (noETIM1) {
            Shell.warning("" + df.getName() + " has USE_SV_KEYWORDS=" + use_sv_keywords + " but ETIM1=null.");
            return false;
        }
        this.data = new ArrayList<Table>();
        if (useEfficientSVKeywordCode) {
            this.populateDataFromKeywords(df, kw, this.data);
        } else {
            this.populateDataFromKeywordsLegacy(kw, this.data);
        }
        this.transform = new Transform();
        this.transform.setECR();
        this.referenceFrame = 0;
        return true;
    }

    private void populateDataFromKeywords(DataFile df, Keywords kw, List<Table> data) {
        List kws = kw.getAll().stream().filter(entry -> this.isSVKeyword((String)entry.getKey())).sorted(SV_COMPARATOR).collect(Collectors.toList());
        Table row = null;
        int idx = 0;
        for (Map.Entry key : kws) {
            String name = (String)key.getKey();
            try {
                String nkey;
                int i = Integer.parseInt(name.substring(4));
                if (i != idx) {
                    if (i == idx + 1) {
                        row = Position.emptyRow();
                        data.add(row);
                        ++idx;
                    } else {
                        Position._warn(df, "Encountered unexpected SV keyword " + name + ", may be missing or out of order");
                    }
                }
                if ("TIME".equals(nkey = SV_KEY_MAP.get(name.substring(0, 4)))) {
                    row.put(nkey, (Object)Time.toTime(key.getValue()));
                    continue;
                }
                row.put(nkey, key.getValue());
            }
            catch (NumberFormatException e) {
                Position._error(df, "Encountered unexpected SV keyword " + name + ", maybe missing or out of order " + e);
            }
        }
    }

    private void populateDataFromKeywordsLegacy(Keywords kw, List<Table> data) {
        int i = 1;
        while (kw.get("ETIM" + i) != null) {
            Table row = new Table();
            data.add(row);
            row.put("TIME", (Object)Time.toTime(kw.get("ETIM" + i)));
            row.put("X", kw.get("POSX" + i));
            row.put("Y", kw.get("POSY" + i));
            row.put("Z", kw.get("POSZ" + i));
            row.put("VX", kw.get("VELX" + i));
            row.put("VY", kw.get("VELY" + i));
            row.put("VZ", kw.get("VELZ" + i));
            row.put("AX", kw.get("ACCX" + i));
            row.put("AY", kw.get("ACCY" + i));
            row.put("AZ", kw.get("ACCZ" + i));
            ++i;
        }
    }

    private boolean isSVKeyword(String name) {
        if (name != null && name.length() > 4) {
            return SV_KEY_MAP.keySet().contains(name.substring(0, 4));
        }
        return false;
    }

    private static final Table emptyRow() {
        Table row = new Table();
        SV_KEY_MAP.values().stream().forEach(k -> row.put((String)k, (Object)null));
        return row;
    }

    private static void _error(DataFile df, String msg) {
        if ((df.getFlags() & 0x20) == 0) {
            throw new MidasException(msg);
        }
        Position._warn(df, msg);
    }

    private static void _warn(DataFile df, String msg) {
        if (df.M != null) {
            df.M.warning(msg);
        } else {
            Shell.warning(msg);
        }
    }

    private void _checkUnit(DataFile df, Keywords kw, String name, int expUnit) {
        this._checkUnit(df, kw, name, expUnit, expUnit);
    }

    private void _checkUnit(DataFile df, Keywords kw, String name, int expUnit, int altUnit) {
        int unit = kw.getUnitsFor(name, expUnit);
        if (unit == expUnit) {
            return;
        }
        if (unit == altUnit) {
            return;
        }
        Position._error(df, "Found " + name + ".UNIT(S)=" + unit + " (" + DataFile.getUnitsVarName(unit) + ") but expected " + expUnit + " (" + DataFile.getUnitsVarName(expUnit) + ").");
    }

    private void _addDataEntries(String key, Keywords kw, String name, char type) {
        Object value = kw.get(name);
        if (value != null) {
            Data val = (Data)Convert.o2o(value, type, null);
            if (val.getSize() != this.data.size()) {
                throw new MidasException("Invalid value for " + name + " keyword, expected " + this.data.size() + " entries but found " + val.getSize());
            }
            for (int i = 0; i < val.getSize(); ++i) {
                this.data.get(i).put(key, (Object)val.getNumber(i));
            }
        }
    }

    protected boolean setFileKeywordsVec(DataFile df) {
        Keywords kw = df.getKeywordsObject();
        if (kw.find("ETIM_VEC") == null) {
            return false;
        }
        Data time = (Data)Convert.o2o(kw.get("ETIM_VEC"), 'D', null);
        this.data = new ArrayList<Table>();
        for (int i = 0; i < time.getSize(); ++i) {
            Table row = new Table();
            row.put("TIME", (Object)Time.toTime(time.getNumber(i)));
            this.data.add(row);
        }
        this._addDataEntries("X", kw, "POSX_VEC", 'D');
        this._addDataEntries("Y", kw, "POSY_VEC", 'D');
        this._addDataEntries("Z", kw, "POSZ_VEC", 'D');
        this._addDataEntries("VX", kw, "VELX_VEC", 'D');
        this._addDataEntries("VY", kw, "VELY_VEC", 'D');
        this._addDataEntries("VZ", kw, "VELZ_VEC", 'D');
        this._addDataEntries("AX", kw, "ACCX_VEC", 'D');
        this._addDataEntries("AY", kw, "ACCY_VEC", 'D');
        this._addDataEntries("AZ", kw, "ACCZ_VEC", 'D');
        this.transform = new Transform();
        this.transform.setECR();
        this.referenceFrame = 0;
        return true;
    }

    protected boolean setFileKeywordsPlat(DataFile df) {
        String prefix;
        Keywords kw = df.getKeywordsObject();
        if (kw.find((prefix = df.getQualifiers().getS("SVPREFIX", "EPH")) + ".TIME") == null) {
            return false;
        }
        int unit = kw.getUnitsFor(prefix + ".TIME", 32);
        Time timeEpoch = Time.toTime(kw.get("TIME_EPOCH"), 10);
        double timeDelta = Convert.o2d(kw.get("TIME_DELTA"), 0.0);
        if (timeEpoch == null) {
            return false;
        }
        if (timeDelta == 0.0) {
            return false;
        }
        this.data = new ArrayList<Table>();
        this._checkUnit(df, kw, prefix + ".TIME", 32, 1);
        this._checkUnit(df, kw, prefix + "_POS.X", 5);
        this._checkUnit(df, kw, prefix + "_POS.Y", 5);
        this._checkUnit(df, kw, prefix + "_POS.Z", 5);
        this._checkUnit(df, kw, prefix + "_VEL.X", 6);
        this._checkUnit(df, kw, prefix + "_VEL.Y", 6);
        this._checkUnit(df, kw, prefix + "_VEL.Z", 6);
        this._checkUnit(df, kw, prefix + "_ACC.X", 7);
        this._checkUnit(df, kw, prefix + "_ACC.Y", 7);
        this._checkUnit(df, kw, prefix + "_ACC.Z", 7);
        if (unit == 1) {
            Data time = (Data)Convert.o2o(kw.get(prefix + ".TIME"), 'D', null);
            for (int i = 0; i < time.getSize(); ++i) {
                Time ts = Time.toTime(time.getNumber(i)).addTime(timeEpoch);
                Table row = new Table();
                row.put("TIME", (Object)ts);
                this.data.add(row);
            }
        } else {
            Data time = (Data)Convert.o2o(kw.get(prefix + ".TIME"), 'X', null);
            for (int i = 0; i < time.getSize(); ++i) {
                Time ts = new Time(time.getNumber(i).longValue(), timeEpoch, timeDelta);
                Table row = new Table();
                row.put("TIME", (Object)ts);
                this.data.add(row);
            }
        }
        this._addDataEntries("X", kw, prefix + "_POS.X", 'D');
        this._addDataEntries("Y", kw, prefix + "_POS.Y", 'D');
        this._addDataEntries("Z", kw, prefix + "_POS.Z", 'D');
        this._addDataEntries("VX", kw, prefix + "_VEL.X", 'D');
        this._addDataEntries("VY", kw, prefix + "_VEL.Y", 'D');
        this._addDataEntries("VZ", kw, prefix + "_VEL.Z", 'D');
        this._addDataEntries("AX", kw, prefix + "_ACC.X", 'D');
        this._addDataEntries("AY", kw, prefix + "_ACC.Y", 'D');
        this._addDataEntries("AZ", kw, prefix + "_ACC.Z", 'D');
        this.transform = new Transform();
        this.transform.setECR();
        this.referenceFrame = 0;
        return true;
    }

    protected boolean setFileKeywordsLLA(DataFile df) {
        Keywords kw = df.getKeywordsObject();
        String prefix = df.getQualifiers().getS("SVPREFIX", null);
        if (prefix == null) {
            return false;
        }
        if (kw.find(prefix + ".LON") == null) {
            return false;
        }
        this.t = df.getTime().getSec();
        this.setGeo(Convert.o2d(kw.get(prefix + ".ALT")), Convert.o2d(kw.get(prefix + ".LAT")), Convert.o2d(kw.get(prefix + ".LON")));
        this._checkUnit(df, kw, prefix + ".ALT", 5, 63);
        this._checkUnit(df, kw, prefix + ".LAT", 34, 60);
        this._checkUnit(df, kw, prefix + ".LON", 34, 61);
        return true;
    }

    private Table normalizeRow(Tablizable t, Double time) {
        Table tbl = t.toTable();
        Table row = new Table();
        Time tc = Time.toTime(tbl.get("TIME", time));
        row.put("TIME", (Object)tc);
        this.normalizeEntry(row, tbl, "POS", "X", "Y", "Z");
        this.normalizeEntry(row, tbl, "VEL", "VX", "VY", "VZ");
        this.normalizeEntry(row, tbl, "ACC", "AX", "AY", "AZ");
        if (tbl.containsKey("LON")) {
            if (!tbl.containsKey("POS")) {
                double[] p = new double[]{tbl.getD("LON"), tbl.getD("LAT"), tbl.getD("ALT")};
                this.transform.fromLonLatAlt(p, 1);
                row.put("X", p[0]);
                row.put("Y", p[1]);
                row.put("Z", p[2]);
            }
            row.put("LON", tbl.getD("LON"));
            row.put("LAT", tbl.getD("LAT"));
            row.put("ALT", tbl.getD("ALT"));
        }
        return row;
    }

    private void normalizeEntry(Table row, Table tbl, String name, String x, String y, String z) {
        Table table = tbl.getTable(name, true);
        if (table != null) {
            row.put(x, table.getD("X"));
            row.put(y, table.getD("Y"));
            row.put(z, table.getD("Z"));
        } else {
            double[] da = Convert.o2da(tbl.getO(name));
            if (da != null) {
                row.put(x, da[0]);
                row.put(y, da[1]);
                row.put(z, da[2]);
            }
        }
    }

    public void process() {
        double[] d = new double[3];
        int mode = 0;
        if (this.db != null) {
            DataFile df = (DataFile)this.inFile;
            double offset = (this.t - df.getXStart()) / df.getXDelta();
            int off = Math.max(0, Math.min(this.db.size - 1, (int)offset));
            int kp = off * this.db.bpe + this.iPosOff;
            this.x = this.db.unpackD(kp + 0);
            this.y = this.db.unpackD(kp + 8);
            this.z = this.db.unpackD(kp + 16);
            d[0] = this.x;
            d[1] = this.y;
            d[2] = this.z;
        } else if (this.data != null) {
            int off = 0;
            while (off + 1 < this.data.size() && this.data.get(off + 1).getD("TIME") <= this.t) {
                ++off;
            }
            d[0] = this.data.get(off).getD("X");
            d[1] = this.data.get(off).getD("Y");
            d[2] = this.data.get(off).getD("Z");
        }
        if (mode != 1 && mode != 2) {
            this.transform.toLonLatAlt(d, 1);
        }
        this.lon = d[0];
        this.lat = d[1];
        this.alt = d[2];
    }

    public Position cloneOf() {
        Position pos = null;
        try {
            pos = (Position)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return pos;
    }

    @Override
    public String[] getKeys() {
        return keys;
    }

    @Override
    public Object setKey(String name, Object value) {
        if (name.equals("X")) {
            this.setX(Convert.o2d(value));
        } else if (name.equals("Y")) {
            this.setY(Convert.o2d(value));
        } else if (name.equals("Z")) {
            this.setZ(Convert.o2d(value));
        } else if (name.equals("R")) {
            this.setR(Convert.o2d(value));
        } else if (name.equals("T")) {
            this.setTime(Convert.o2d(value));
        } else if (name.equals("LAT")) {
            this.setLat(Convert.o2d(value));
        } else if (name.equals("LON")) {
            this.setLon(Convert.o2d(value));
        } else if (name.equals("ALT")) {
            this.setAlt(Convert.o2d(value));
        } else if (name.equals("FRAME")) {
            this.referenceFrame = Convert.o2l(value);
        } else {
            return null;
        }
        return value;
    }

    @Override
    public Object getKey(String name) {
        if (name.equals("X")) {
            return Convert.d2o(this.getX());
        }
        if (name.equals("Y")) {
            return Convert.d2o(this.getY());
        }
        if (name.equals("Z")) {
            return Convert.d2o(this.getZ());
        }
        if (name.equals("R")) {
            return Convert.d2o(this.getR());
        }
        if (name.equals("T")) {
            return Convert.d2o(this.getTime());
        }
        if (name.equals("LAT")) {
            return Convert.d2o(this.getLat());
        }
        if (name.equals("LON")) {
            return Convert.d2o(this.getLon());
        }
        if (name.equals("ALT")) {
            return Convert.d2o(this.getAlt());
        }
        if (name.equals("FRAME")) {
            return Convert.l2o(this.referenceFrame);
        }
        return null;
    }

    public static Position fromGeo(Table tbl) {
        double alt = tbl.getD("ALT", 0.0);
        double lat = tbl.getD("LAT", 0.0);
        double lon = tbl.getD("LON", 0.0);
        return Position.fromGeo(alt, lat, lon);
    }

    public static Position fromGeo(double alt, double lat, double lon) {
        Position pos = new Position();
        pos.setGeo(alt, lat, lon);
        return pos;
    }

    public double[] toLonLatAlt() {
        return new double[]{this.getLon(), this.getLat(), this.getAlt()};
    }

    public double[] toAltLatLon() {
        return new double[]{this.getAlt(), this.getLat(), this.getLon()};
    }

    public static Position fromLonLatAlt(double[] pos) {
        return Position.fromGeo(pos[2], pos[1], pos[0]);
    }

    public static Position fromAltLatLon(double[] pos) {
        return Position.fromGeo(pos[0], pos[1], pos[2]);
    }

    public double getHeading() {
        if (this.getVX() == 0.0 && this.getVY() == 0.0 && this.getVZ() == 0.0) {
            return 0.0;
        }
        Position p = new Position();
        p.setCar(this.getX() + this.getVX(), this.getY() + this.getVY(), this.getZ() + this.getVZ());
        Transform.car2geo(p);
        return Position.computeHeading(this.getLon(), this.getLat(), p.getLon(), p.getLat(), 0.0);
    }

    public double getHeadingGeodetic() {
        if (this.referenceFrame == 1) {
            if (this.getVU() == 0.0 && this.getVE() == 0.0 && this.getVN() == 0.0) {
                return 0.0;
            }
        } else {
            if (this.getVX() == 0.0 && this.getVY() == 0.0 && this.getVZ() == 0.0) {
                return 0.0;
            }
            Transform.car2geo(this);
        }
        return Position.computeHeadingPrecise(this.getLon(), this.getLat(), this.getLon() + this.getVE(), this.getLat() + this.getVN(), 0.0);
    }

    public static double getGreatArcInitialBearing(Position p, Position q) {
        if (p.getLat() == q.getLat() && p.getLon() == q.getLon()) {
            return 0.0;
        }
        return Position.computeHeadingPrecise(p.getLon(), p.getLat(), q.getLon(), q.getLat(), 0.0);
    }

    public double getSpeed() {
        if (this.getVX() == 0.0 && this.getVY() == 0.0 && this.getVZ() == 0.0) {
            return 0.0;
        }
        Position p = new Position();
        p.setCar(this.getX() + this.getVX(), this.getY() + this.getVY(), this.getZ() + this.getVZ());
        Transform.car2geo(p);
        double dLon = p.getLon() - this.getLon();
        double dLat = p.getLat() - this.getLat();
        double mLon = dLon * 111319.49079327358;
        double mLat = dLat * 111319.49079327358;
        double mAlt = p.getAlt() - this.getAlt();
        return Math.sqrt(mLon * mLon + mLat * mLat + mAlt * mAlt);
    }

    public double getGroundSpeed() {
        return this.getSpeed(0);
    }

    public double getHorizontalSpeed() {
        return this.getSpeed(1);
    }

    private double getSpeed(int mode) {
        if (this.referenceFrame == 1) {
            if (this.getVU() == 0.0 && this.getVE() == 0.0 && this.getVN() == 0.0) {
                return 0.0;
            }
        } else {
            if (this.getVX() == 0.0 && this.getVY() == 0.0 && this.getVZ() == 0.0) {
                return 0.0;
            }
            Transform.car2geo(this);
        }
        double ratio = mode == 0 ? 6378137.0 / (6378137.0 + this.getAlt()) : 1.0;
        return ratio * Math.sqrt(Math.pow(this.getVE(), 2.0) + Math.pow(this.getVN(), 2.0));
    }

    public static double computeHeading(Position pos1, Position pos2, double def) {
        return Position.computeHeading(pos1.getLon(), pos1.getLat(), pos2.getLon(), pos2.getLat(), def);
    }

    public static double computeHeading(double lon1, double lat1, double lon2, double lat2, double def) {
        if (lat1 == lat2 && lon1 == lon2) {
            return def;
        }
        double dlon = lon2 - lon1;
        double dlat = lat2 - lat1;
        double rad = Math.atan(dlon / dlat);
        double deg = Math.toDegrees(rad);
        if (dlat < 0.0 && dlon < 0.0) {
            deg = 180.0 + deg;
        } else if (dlat < 0.0) {
            deg = 180.0 + deg;
        } else if (dlon < 0.0) {
            deg = 360.0 + deg;
        }
        return deg;
    }

    public static double computeHeadingPrecise(Position pos1, Position pos2, double def) {
        return Position.computeHeadingPrecise(pos1.getLon(), pos1.getLat(), pos2.getLon(), pos2.getLat(), def);
    }

    public static double computeHeadingPrecise(double lon1, double lat1, double lon2, double lat2, double def) {
        if (lat1 == lat2 && lon1 == lon2) {
            return def;
        }
        double lat1rad = lat1 * (Math.PI / 180);
        double lat2rad = lat2 * (Math.PI / 180);
        double lon1rad = lon1 * (Math.PI / 180);
        double lon2rad = lon2 * (Math.PI / 180);
        double y = Math.sin(lon2rad - lon1rad) * Math.cos(lat2rad);
        double x = Math.cos(lat1rad) * Math.sin(lat2rad) - Math.sin(lat1rad) * Math.cos(lat2rad) * Math.cos(lon2rad - lon1rad);
        double deg = Math.atan2(y, x);
        deg = Math.toDegrees(deg);
        deg = (deg + 360.0) % 360.0;
        return deg;
    }

    public static boolean equals(Position p0, Position p1, double tolr) {
        return Tolerance.equalsWithTolerance(p0.alt, p1.alt, tolr) && Tolerance.equalsWithTolerance(p0.lat, p1.lat, tolr) && Tolerance.equalsWithTolerance(p0.lon, p1.lon, tolr);
    }

    @InternalUseOnly
    public static void setUseEfficientSVKeywordCode(boolean useEfficientSVKeywordCode) {
        Position.useEfficientSVKeywordCode = useEfficientSVKeywordCode;
    }

    @InternalUseOnly
    public static boolean getUseEfficientSVKeywordCode() {
        return useEfficientSVKeywordCode;
    }

    public static enum SVMode {
        T5Data,
        T5Entries,
        Entries,
        KeywordsEph,
        KeywordsVec,
        KeywordsLLA,
        KeywordsPlat;

    }
}

