/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.RmifInterface;
import nxm.sys.lib.Convert;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class MftpResource
extends IOResource
implements DataTypes {
    private DatagramSocket dsock;
    private byte[] buffi;
    private byte[] buffo;
    private DatagramPacket dpacki;
    private DatagramPacket dpacko;
    private String rhost;
    private String rname;
    private int port;
    private int rport;
    private InetAddress raddr;
    private int MAXPKTBUF = 65536;
    private int defaultMftpPort = 7070;
    private int lastMftpPort = 7080;
    private int timeOut = 2;
    private int pktlen = 8192;
    private int pktrate = 0;
    private long length = 0L;
    private boolean dbg = false;

    @Override
    public void setURL(String str) {
        super.setURL(str);
        if (str.startsWith("mftp://")) {
            str = str.substring(7);
        } else if (str.startsWith("mftp:/")) {
            str = str.substring(6);
        } else if (str.startsWith("mftp:")) {
            str = str.substring(5);
        }
        int i = str.indexOf("/");
        int j = str.indexOf(":");
        int k = str.indexOf("/", i + 1);
        if (i < j) {
            this.port = Convert.s2l(str.substring(0, i));
        } else {
            this.port = -1;
            k = i;
            i = -1;
        }
        this.rhost = str.substring(i + 1, j);
        this.rport = Convert.s2l(str.substring(j + 1, k));
        this.rname = str.substring(k + 1);
    }

    @Override
    public boolean exists() {
        this.sendMftpPacket("{FUNC=EXIST,NAME=" + this.rname + "}");
        String str = this.recvMftpPacket();
        if (str == null) {
            return false;
        }
        Table t = new Table(str);
        String s = t.getS("EXISTS");
        boolean exists = s != null && s.equals("Y");
        return exists;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        this.sendMftpPacket("{FUNC=OPEN,NAME=" + this.rname + "}");
        String str = this.recvMftpPacket();
        if (str == null) {
            return false;
        }
        Table t = new Table(str);
        this.length = (long)t.getD("LENGTH");
        this.isOpen = this.length >= 0L;
        this.pktlen = this.getQual("PKTLEN", this.pktlen);
        this.pktrate = this.getQual("PKTRATE", this.pktrate);
        return this.isOpen;
    }

    private int getQual(String name, int defval) {
        Object qo = this.getQualifier(name);
        return qo != null ? Convert.o2l(qo) : defval;
    }

    @Override
    public boolean close() {
        this.sendMftpPacket("{FUNC=CLOSE,NAME=" + this.rname + "}");
        if (this.dsock != null) {
            this.dsock.close();
        }
        return true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean seek(long offset) {
        this.offset = offset;
        return true;
    }

    @Override
    public long avail() {
        return this.length - this.offset;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        long foffset = this.offset;
        long loffset = this.offset + (long)bytes;
        block3: while (this.offset < loffset) {
            long noffset = this.offset;
            String cmd = "{FUNC=READ,NAME=" + this.rname + ",OFFSET=" + this.offset + ",LENGTH=" + bytes + ",PKTLEN=" + this.pktlen + "}";
            if (this.pktrate > 0) {
                cmd = cmd + "{RATE=" + this.pktrate + "}";
            }
            this.sendMftpPacket(cmd);
            String str = this.recvMftpPacket();
            if (str == null) {
                return -1;
            }
            Table t = new Table(str);
            bytes = t.getL("LENGTH");
            while (this.offset < loffset) {
                int status = 0;
                try {
                    this.dpacki.setLength(this.buffi.length);
                    this.dsock.receive(this.dpacki);
                    status = this.dpacki.getLength();
                }
                catch (SocketTimeoutException e) {
                    if (this.offset > noffset) {
                        Shell.warning("Mftp Packet TimeOut. Retrying ... ");
                        bytes = (int)(loffset - this.offset);
                        continue block3;
                    }
                }
                catch (IOException e) {
                    Shell.warning(e.toString());
                    return -1;
                }
                if (this.dbg) {
                    System.out.println("Get MFTP data packet Stat=" + status + " Bytes=" + bytes + " Func=" + RmifInterface.functionName(this.buffi[0]) + " offset=" + this.offset + " loffset=" + loffset);
                }
                if (status < 8 || this.buffi[0] != 112 || this.buffi[7] != 8) continue;
                long poffset = (long)Convert.unpackD(this.buffi, 8);
                if (poffset > this.offset) {
                    Shell.warning("Mftp Packet OutOfOrder. Retrying ... ");
                    bytes = (int)(loffset - this.offset);
                    continue block3;
                }
                if (poffset < foffset || poffset >= loffset) continue;
                int tbytes = status - 16;
                System.arraycopy(this.buffi, 16, buf, boff + (int)(poffset - foffset), tbytes);
                this.offset = poffset + (long)tbytes;
            }
        }
        return (int)(this.offset - foffset);
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        this.sendMftpPacket("{FUNC=WRITE,NAME=" + this.rname + ",OFFSET=" + this.offset + ",LENGTH=" + bytes + "}");
        this.offset += (long)bytes;
        return bytes;
    }

    private void getMftpSocket() {
        this.timeOut = this.getQual("PKTTO", this.timeOut);
        int p1 = this.defaultMftpPort;
        int p2 = this.lastMftpPort;
        if (this.port > 0) {
            p1 = p2 = this.port;
        }
        this.port = p1;
        while (this.port <= p2) {
            try {
                this.dsock = new DatagramSocket(this.port);
                this.dsock.setSoTimeout(this.timeOut * 1000);
                this.dsock.setReceiveBufferSize(0x100000);
                this.buffo = new byte[8 + this.MAXPKTBUF];
                this.dpacko = new DatagramPacket(this.buffo, this.buffo.length);
                this.raddr = InetAddress.getByName(this.rhost);
                this.dpacko.setAddress(this.raddr);
                this.dpacko.setPort(this.rport);
                this.buffi = new byte[8 + this.MAXPKTBUF];
                this.dpacki = new DatagramPacket(this.buffi, this.buffi.length);
                return;
            }
            catch (BindException bindException) {
            }
            catch (Exception e) {
                Shell.warning(e.toString());
            }
            ++this.port;
        }
        System.out.println("No Mftp ports available from " + p1 + " to " + p2);
    }

    private void sendMftpPacket(String str) {
        if (this.dbg) {
            System.out.println("Send MFTP packet " + str + " on " + this.port);
        }
        if (this.dsock == null) {
            this.getMftpSocket();
        }
        this.buffo[0] = 125;
        this.buffo[1] = 0;
        this.buffo[2] = 0;
        this.buffo[3] = 69;
        this.buffo[4] = -1;
        this.buffo[5] = 0;
        this.buffo[6] = 0;
        this.buffo[7] = 0;
        byte[] bstr = str.getBytes();
        System.arraycopy(bstr, 0, this.buffo, 8, bstr.length);
        this.dpacko.setLength(8 + bstr.length);
        try {
            this.dsock.send(this.dpacko);
        }
        catch (IOException e) {
            Shell.warning("Err sending MFTP message");
        }
    }

    private String recvMftpPacket() {
        if (this.dsock == null) {
            this.getMftpSocket();
        }
        int status = 0;
        while (status < 8 || this.buffi[0] != 125) {
            try {
                this.dpacki.setLength(this.buffi.length);
                this.dsock.receive(this.dpacki);
                status = this.dpacki.getLength();
            }
            catch (IOException e) {
                Shell.warning(e.toString());
                return null;
            }
        }
        String str = new String(this.buffi, 8, status - 8);
        return str;
    }
}

