/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Command;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class MessageQueue
implements MessageHandler {
    public Midas M;
    public Object owner;
    private Message first;
    private Message last;
    private Message lastOut;
    private int total;
    private int avail;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public static final int PEEK = 4;
    public static final int KEEP = 8;
    public static final int NAME = 16;
    public static final int FROM = 32;
    public static final int PASS = 64;

    public MessageQueue(Object owner) {
        this(null, owner);
    }

    public MessageQueue(Midas M, Object owner) {
        this.M = M;
        this.owner = owner;
        this.clear();
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.total = 0;
        this.avail = 0;
    }

    public int put(Message message, Object to) {
        return this.put(message, to, this.owner);
    }

    public int put(String name, int info) {
        return this.put(new Message(name, info, new Object(), this.owner, this.owner));
    }

    public int put(String name, int info, Object data) {
        return this.put(new Message(name, info, data, this.owner, this.owner));
    }

    public int put(String name, int info, Object data, Object to) {
        return this.put(new Message(name, info, data), to, this.owner);
    }

    public int put(String name, int info, Object data, Object to, Object from) {
        return this.put(new Message(name, info, data), to, from);
    }

    public int put(String name, int info, Object data, Object to, Object from, Object quals) {
        return this.put(new Message(name, info, data, quals), to, from);
    }

    public int put(Message message, Object to, Object from) {
        message.to = to;
        message.from = from;
        if (to instanceof String && this.M != null) {
            message.to = to = this.M.registry.getMessageHandler((String)to);
        }
        if (to == this.owner) {
            this.put(message);
        } else if (to instanceof Command) {
            ((Command)to).queue.put(message);
        } else if (to instanceof MessageQueue) {
            ((MessageQueue)to).put(message);
        } else if (to instanceof MessageHandler) {
            ((MessageHandler)to).processMessage(message);
        } else {
            if (this.M != null) {
                this.M.warning("Bad MessageQueue To Address: " + to + " From: " + from);
            } else {
                Shell.warning("Bad MessageQueue To Address: " + to + " From: " + from);
            }
            return -1;
        }
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        return this.put(msg);
    }

    public synchronized int put(Message message) {
        ++this.total;
        message.prev = this.last;
        message.next = null;
        if (this.last != null) {
            this.last.next = message;
        }
        this.last = message;
        if (this.first == null) {
            this.first = this.last;
        }
        return ++this.avail;
    }

    public synchronized Message get() {
        if (this.first == null) {
            return null;
        }
        Message msg = this.first;
        this.first = this.first.next;
        if (this.first == null) {
            this.last = null;
        }
        --this.avail;
        this.lastOut = msg;
        return msg;
    }

    public Message get(int flags, Message msgt, int timeout) {
        Message msgk = null;
        do {
            Message msg = this.first;
            while (msg != null) {
                if (!((flags & 0x10) != 0 && !msg.name.equals(msgt.name) || (flags & 0x20) != 0 && msg.from != msgt.from)) {
                    msgk = msg;
                    if ((flags & 4) == 0) {
                        this.remove(msg);
                    }
                    if ((flags & 2) == 0) {
                        return msg;
                    }
                }
                msg = msg.next;
            }
            if (timeout != 0) {
                Time.sleep(0.01);
            }
            if (timeout <= 0) continue;
            timeout = Math.max(0, timeout - 10);
        } while (timeout != 0);
        if (msgk == null && (flags & 0x40) != 0) {
            msgk = msgt;
        }
        this.lastOut = msgk;
        return msgk;
    }

    public synchronized int remove(String name) {
        int count = 0;
        Message msg = this.first;
        while (msg != null) {
            if (msg.name.equals(name)) {
                this.remove(msg);
                ++count;
            }
            msg = msg.next;
        }
        return count;
    }

    public synchronized void remove(Message msg) {
        if (msg.prev != null) {
            msg.prev.next = msg.next;
        }
        if (msg.next != null) {
            msg.next.prev = msg.prev;
        }
        if (msg == this.first) {
            this.first = msg.next;
        }
        if (msg == this.last) {
            this.last = msg.prev;
        }
        --this.avail;
    }

    public synchronized Message prune(Message match) {
        if (match == null) {
            return null;
        }
        Message msg = this.first;
        while (msg != null && msg.name.equals(match.name) && msg.from == match.from) {
            match = msg;
            this.remove(msg);
            msg = msg.next;
        }
        return match;
    }

    public synchronized Message replace(Message message) {
        if (message == null) {
            return null;
        }
        Message msg = null;
        msg = this.first;
        while (msg != null) {
            if (message.name.equals(msg.name) && message.from == msg.from) {
                if (msg.prev != null) {
                    msg.prev.next = message;
                }
                if (msg.next != null) {
                    msg.next.prev = message;
                }
                if (msg == this.first) {
                    this.first = message;
                }
                if (msg == this.last) {
                    this.last = message;
                }
                message.prev = msg.prev;
                message.next = msg.next;
                break;
            }
            msg = msg.next;
        }
        return msg;
    }

    public int avail() {
        return this.avail;
    }

    public int getAvail() {
        return this.avail;
    }

    public Message getLastOut() {
        return this.lastOut;
    }

    public int getTotal() {
        return this.total;
    }

    public String toString() {
        return "Message Queue:  Avail=" + this.avail + " Total=" + this.total;
    }
}

