/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MatLabZipResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

@ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
public class MatLabFile
extends DataFile {
    private static final int miINT8 = 1;
    private static final int miUINT8 = 2;
    private static final int miINT16 = 3;
    private static final int miUINT16 = 4;
    private static final int miINT32 = 5;
    private static final int miUINT32 = 6;
    private static final int miSINGLE = 7;
    private static final int miDOUBLE = 9;
    private static final int miINT64 = 12;
    private static final int miUINT64 = 13;
    private static final int miMATRIX = 14;
    private static final int miCOMPRESSED = 15;
    private static final int miUTF8 = 16;
    private static final int miUTF16 = 17;
    private static final int miUTF32 = 18;
    private static final int FHDR = 128;
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected boolean complex;
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected boolean compress;
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected long length;
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected long dataoff;
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected long csizeoff;
    private byte[] gbuf = null;
    private MatLabZipResource zio = null;
    private String version;

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getVersion() {
        return this.version;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getClassVersion() {
        return "MATL";
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected void readHeader() {
        this.ioh.read(this.hb, 0, 128, 0L);
        this.version = Convert.unpackS(this.hb, 0, 4);
        if (!this.version.equals("MATL")) {
            throw new MidasException("MatLabFile " + this.getURL() + " does not have a valid MatLab Header");
        }
        this.convertHeader();
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    protected int writeKeywords() {
        return 0;
    }

    private void convertHeader() {
        Table qt = this.getQualifiers();
        String aname = qt.getS("ARRAY");
        String text = Convert.unpackS(this.hb, 0, 124);
        this.dataoff = 128L;
        int hlen = 64;
        this.gbuf = new byte[hlen];
        int goff = 0;
        int glen = this.ioh.read(this.gbuf, 0, 64, this.dataoff);
        Tag tag = new Tag(this.gbuf, goff);
        goff += tag.hbytes;
        if (tag.type == 15) {
            this.compress = true;
            this.dataoff += (long)tag.hbytes;
            this.zio = new MatLabZipResource(this.ioh, this.dataoff, 0);
            this.io = this.zio;
            glen = this.io.read(this.gbuf, 0, hlen, this.dataoff);
            goff = 0;
            tag = new Tag(this.gbuf, goff);
            goff += tag.hbytes;
        }
        Tag array = tag;
        if (tag.type == 14) {
            Tag af = new Tag(this.gbuf, goff);
            this.complex = (af.getX(0) & 0x800L) != 0L;
            Tag ad = new Tag(this.gbuf, goff += af.tbytes);
            goff += ad.tbytes;
            int cols = ad.getL(0);
            int rows = ad.getL(1);
            if (cols > 1 && rows > 1 || ad.size / this.getBytes(ad.type) != 2) {
                throw new MidasException("MatLabFile " + this.getURL() + " cannot handle multiple dimensioned arrays");
            }
            this.length = cols == 1 ? (long)rows : (long)cols;
            Tag an = new Tag(this.gbuf, goff);
            aname = an.getS(an.size);
            tag = new Tag(this.gbuf, goff += an.tbytes);
            goff += tag.hbytes;
        } else {
            this.length = tag.size / this.getBytes(tag.type);
        }
        int bps = this.getBytes(tag.type);
        this.dataoff += (long)goff;
        if (this.complex) {
            int blength = (int)this.length * bps;
            byte[] rbuf = new byte[blength];
            byte[] ibuf = new byte[blength];
            byte[] cbuf = new byte[blength * 2];
            this.io.read(rbuf, 0, blength, this.dataoff);
            this.io.read(ibuf, 0, blength, this.dataoff + (long)blength + (long)tag.hbytes);
            int j = 0;
            for (int i = 0; i < blength; i += bps) {
                System.arraycopy(rbuf, i, cbuf, j, bps);
                System.arraycopy(ibuf, i, cbuf, j += bps, bps);
                j += bps;
            }
            if (this.zio == null) {
                this.zio = new MatLabZipResource(this.io, this.dataoff, 0);
                this.io = this.zio;
            }
            this.zio.setBuffer(cbuf, this.dataoff, blength * 2);
        }
        for (int i = 0; i < 512; ++i) {
            this.hb[i] = 0;
        }
        this.initMain();
        switch (tag.type) {
            case 1: 
            case 2: {
                this.setFormatType((byte)66);
                break;
            }
            case 3: 
            case 4: {
                this.setFormatType((byte)73);
                break;
            }
            case 5: 
            case 6: {
                this.setFormatType((byte)76);
                break;
            }
            case 12: 
            case 13: {
                this.setFormatType((byte)88);
                break;
            }
            case 7: {
                this.setFormatType((byte)70);
                break;
            }
            case 9: {
                this.setFormatType((byte)68);
                break;
            }
            case 16: {
                this.setFormatType((byte)65);
                break;
            }
            default: {
                throw new MidasException("MatLabFile: Unsupported MatLab data type: " + tag.type);
            }
        }
        int spa = this.complex ? 2 : 1;
        double rate = 1000000.0;
        if (spa == 1) {
            this.setFormatMode((byte)83);
        } else if (spa == 2) {
            this.setFormatMode((byte)67);
        } else if (spa == 3) {
            this.setFormatMode((byte)86);
        } else {
            throw new MidasException("MatLabFile: Unsupported data vertor dimensions: " + spa);
        }
        if (rate > 0.0) {
            this.setXDelta(1.0 / rate);
        }
        this.setXUnits(1);
        this.setDataStart(this.dataoff);
        this.setDataSize(this.length * (long)bps * (long)spa);
        this.keywords.putMain("ARRAY", aname, false);
        int t1 = text.indexOf("Created on: ");
        if (t1 > 0) {
            this.keywords.putMain("CREATED", text.substring(t1 + 12), false);
        }
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public void writeHeader() {
        if (this.gbuf != null) {
            return;
        }
        this.gbuf = new byte[512];
        int goff = this.createHeader(this.gbuf);
        this.setDataStart(goff);
        this.io.write(this.gbuf, 0, goff, 0L);
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public int createHeader(byte[] buf) {
        int array_type = this.getArrayType(this.getFormatType());
        int gstep = this.getBytes(array_type);
        int bps = this.getBPS();
        int bpe = (int)this.getBPE();
        int blength = (int)this.getSize() * bpe;
        int length = blength / gstep;
        int off = -1;
        Table qt = this.getQualifiers();
        this.compress = qt.getState("CMP");
        boolean bl = this.complex = this.getSPA() == 2;
        if (this.complex) {
            length /= 2;
        }
        Date date = new Date();
        String ts = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").format(new Timestamp(date.getTime()));
        String ostring = this.getOsString();
        String desc = String.format("MATLAB 5.0 MAT-file, Platform: %s, Created on: %s", ostring, ts);
        System.arraycopy(desc.getBytes(), 0, buf, 0, desc.length());
        for (int i = desc.length(); i < 124; ++i) {
            buf[i] = 32;
        }
        boolean be = Shell.rep == 73;
        buf[124] = 0;
        buf[125] = 1;
        buf[126] = (byte)(be ? 77 : 73);
        buf[127] = (byte)(be ? 73 : 77);
        off = 128;
        if (this.compress) {
            Convert.packL(buf, off, 15);
            this.csizeoff = off += 4;
            Convert.packL(buf, off, 0);
            this.dataoff = off += 4;
            this.zio = new MatLabZipResource(this.ioh, this.dataoff, 0);
            this.io = this.zio;
        }
        Convert.packL(buf, off, 14);
        int tag_size = this.complex ? blength + 56 : blength + 48;
        Convert.packL(buf, off += 4, tag_size);
        Convert.packL(buf, off += 4, 6);
        Convert.packL(buf, off += 4, 8);
        int class_type = this.getClassType(this.complex, array_type);
        Convert.packL(buf, off += 4, class_type);
        Convert.packL(buf, off += 4, 0);
        Convert.packL(buf, off += 4, 5);
        Convert.packL(buf, off += 4, 8);
        Convert.packL(buf, off += 4, 1);
        Convert.packL(buf, off += 4, length);
        off += 4;
        buf[off++] = 1;
        buf[off++] = 0;
        buf[off++] = 4;
        buf[off++] = 0;
        Convert.packS(buf, off, 4, "data");
        Convert.packL(buf, off += 4, array_type);
        Convert.packL(buf, off += 4, gstep * length);
        this.dataoff = off += 4;
        if (this.complex) {
            byte[] cbuf = new byte[blength];
            if (this.zio == null) {
                this.zio = new MatLabZipResource(this.io, this.dataoff, 0);
                this.io = this.zio;
            }
            this.zio.setBuffer(cbuf, this.dataoff, blength);
        }
        return off;
    }

    @Override
    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public synchronized void close() {
        if (this.isOutput && this.complex) {
            int gstep = this.getBPS();
            int blength = (int)this.getDataSize() / 2;
            byte[] rbuf = new byte[blength];
            byte[] ibuf = new byte[blength];
            byte[] cbuf = this.zio.getBuffer();
            int j = 0;
            for (int i = 0; i < blength; i += gstep) {
                System.arraycopy(cbuf, j, rbuf, i, gstep);
                System.arraycopy(cbuf, j += gstep, ibuf, i, gstep);
                j += gstep;
            }
            this.io = this.ioh;
            this.io.write(rbuf, 0, blength, this.dataoff);
            this.io.write(this.gbuf, (int)this.dataoff - 8, 8, this.dataoff + (long)blength);
            this.io.write(ibuf, 0, blength, this.dataoff + (long)blength + 8L);
        }
        if (this.isOutput && this.compress) {
            int csize = (int)(this.zio.getCompressedOffset() - this.csizeoff + 4L);
            Convert.packL(this.gbuf, (int)this.csizeoff, csize);
            this.ioh.write(this.gbuf, (int)this.csizeoff, 4, this.csizeoff);
        }
        super.close();
    }

    private int getBytes(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 16: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: {
                return 4;
            }
            case 9: 
            case 12: 
            case 13: {
                return 8;
            }
        }
        System.out.printf("Unhandled Data Type!\n", new Object[0]);
        return -1;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public String getOsString() {
        boolean x86;
        String osname = System.getProperty("os.name").toLowerCase();
        boolean bl = x86 = System.getProperty("os.arch").indexOf("64") < 0;
        if (osname.contains("linux")) {
            return x86 ? "GLNX86" : "GLNXA64";
        }
        if (osname.contains("win")) {
            return x86 ? "PCWIN" : "PCWIN64";
        }
        if (osname.contains("mac")) {
            return "MACI";
        }
        return x86 ? "GLNX86" : "GLNXA64";
    }

    private int getClassType(boolean complex, int dtype) {
        switch (dtype) {
            case 1: {
                return complex ? 2056 : 8;
            }
            case 3: {
                return complex ? 2058 : 10;
            }
            case 5: {
                return complex ? 2060 : 12;
            }
            case 12: {
                return complex ? 2062 : 14;
            }
            case 9: {
                return complex ? 2054 : 6;
            }
        }
        return complex ? 2054 : 6;
    }

    @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
    public int getArrayType(byte type) {
        int at = -1;
        switch (type) {
            case 66: {
                at = 1;
                break;
            }
            case 73: {
                at = 3;
                break;
            }
            case 76: {
                at = 5;
                break;
            }
            case 88: {
                at = 12;
                break;
            }
            case 68: {
                at = 9;
                break;
            }
            case 70: {
                at = 7;
                break;
            }
            case 65: {
                at = 16;
            }
        }
        return at;
    }

    private class Tag {
        int type;
        int size;
        int doff;
        int hbytes;
        int dbytes;
        int tbytes;
        byte[] buf;

        @ProvisionalUseOnly(value="Added in NeXtMidas 3.7.0")
        public Tag(byte[] buf, int off) {
            this.buf = buf;
            this.type = Convert.unpackL(buf, off);
            if ((this.type & 0xFFFF0000) != 0) {
                this.size = this.type >> 16;
                this.type &= 0xFFFF;
                this.hbytes = 4;
                this.dbytes = this.size + 3 & 0xFFFFFFFC;
            } else {
                this.size = Convert.unpackL(buf, off + 4);
                this.hbytes = 8;
                this.dbytes = this.size + 7 & 0xFFFFFFF8;
            }
            this.doff = off + this.hbytes;
            this.tbytes = this.hbytes + this.dbytes;
        }

        public long getX(int i) {
            return Convert.unpackX(this.buf, this.doff + i * 8);
        }

        public int getL(int i) {
            return Convert.unpackL(this.buf, this.doff + i * 4);
        }

        public String getS(int i) {
            return Convert.unpackS(this.buf, this.doff, i);
        }

        public String toString() {
            return "Tag Type=" + this.type + " Size=" + this.size + " hby=" + this.hbytes + " tby=" + this.tbytes;
        }
    }
}

