/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import nxm.sys.inc.MidasColor;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public abstract class MFormat
extends Format {
    private static final long serialVersionUID = 2012012600311L;
    private static final String ERROR_STRING = "--ERROR--";
    protected Format format;
    protected String name;

    protected MFormat(String name, Format format) {
        this.name = name;
        this.format = format;
    }

    public String toString() {
        return this.name;
    }

    public Color getColor(Object obj) {
        return null;
    }

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        String str = null;
        try {
            if (obj instanceof Data) {
                Object[] array = ((Data)obj).toVector().toArray();
                str = array.length == 1 ? this.doFormat(array[0]) : this.doFormat(array);
            } else if (obj instanceof Object[]) {
                str = this.doFormat((Object[])obj);
            } else if (obj != null && obj.getClass().isArray()) {
                Object[] array = new Object[Array.getLength(obj)];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = Array.get(obj, i);
                }
                str = this.doFormat(array);
            } else {
                str = this.doFormat(obj);
            }
        }
        catch (Exception e) {
            str = ERROR_STRING;
        }
        return toAppendTo.append(str);
    }

    @Override
    public final Object parseObject(String source, ParsePosition pos) {
        try {
            pos.setIndex(source.length());
            return this.doParseObject(source);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected String doFormat(Object[] array) {
        StringBuilder str = new StringBuilder();
        if (array != null) {
            str.append('(');
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    str.append(", ");
                }
                str.append(this.doFormat(array[i]));
            }
            str.append(')');
        }
        return str.toString();
    }

    protected String doFormat(Object obj) {
        String str = null;
        str = this.format != null ? this.format.format(obj) : (obj != null ? obj.toString() : "");
        return str;
    }

    protected Object doParseObject(String source) throws ParseException {
        if (this.format != null) {
            return this.format.parseObject(source);
        }
        return source;
    }

    public static MFormat getNumberFormatFor(String pattern) {
        return MFormat.getNumberFormatFor(pattern, true);
    }

    public static MFormat getNumberFormatFor(String pattern, boolean trim) {
        return MFormat.getNumberFormatFor(pattern, 'D', trim);
    }

    public static MFormat getNumberFormatFor(char type) {
        return MFormat.getNumberFormatFor("SCI", type, true);
    }

    public static MFormat getNumberFormatFor(String pattern, String fmt, boolean trim) {
        char numType = fmt != null && fmt.length() == 2 ? fmt.charAt(1) : (char)'D';
        return MFormat.getNumberFormatFor(pattern, numType, trim);
    }

    public static MFormat getNumberFormatFor(String pattern, char type, boolean trim) {
        if (pattern.indexOf(38) < 0) {
            String name = pattern.toUpperCase();
            if (name.equals("GEN")) {
                return new VisualFormat("General ", 0.001, 1.0E15, type);
            }
            if (name.equals("VIS")) {
                return new VisualFormat("Visual ", 0.001, 1.0E7, type);
            }
            if (name.equals("SCI")) {
                pattern = MFormat.getSciStringFor(type, trim);
            }
            if (name.equals("ENG")) {
                pattern = "##" + MFormat.getSciStringFor(type, trim);
            }
            if (name.equals("MAN")) {
                pattern = "0";
            }
            if (name.equals("DMS")) {
                return new DmsFormat(null);
            }
            if (name.equals("LAT")) {
                return new DmsFormat("NS");
            }
            if (name.equals("LON")) {
                return new DmsFormat("EW");
            }
            int tfmt = Parser.find("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", name, -1);
            if (tfmt > 0) {
                return new TimeFormat(tfmt);
            }
            if (name.equals("NET")) {
                return new NetworkFormat();
            }
            return new NumericalFormat(pattern);
        }
        return new ArrayFormat(pattern.split("&"), trim);
    }

    public static final MFormat getDateFormatFor(String pattern) {
        return MFormat.getDateFormatFor(pattern, "UTC", -1);
    }

    public static final MFormat getDateFormatFor(String pattern, String timeZone) {
        return MFormat.getDateFormatFor(pattern, timeZone, -1);
    }

    public static final MFormat getDateFormatFor(String pattern, int dp) {
        return MFormat.getDateFormatFor(pattern, "UTC", dp);
    }

    public static MFormat getDateFormatFor(String pattern, String timeZone, int dp) {
        String name = pattern.toUpperCase();
        int tfmt = Parser.find("Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime", name, -1);
        if (tfmt > 0) {
            return new TimeFormat(tfmt, dp);
        }
        return new DateFormat(pattern, timeZone);
    }

    public static MFormat getAngleFormatFor(String pattern) {
        String name = pattern.toUpperCase();
        if (name.equals("DMS")) {
            return new DmsFormat(null);
        }
        if (name.equals("LAT")) {
            return new DmsFormat("NS");
        }
        if (name.equals("LON")) {
            return new DmsFormat("EW");
        }
        return new AngleFormat(pattern);
    }

    public static MFormat getStringFormat() {
        return new StringFormat();
    }

    public static MFormat getAsciiFormat(int length) {
        return new AsciiFormat(length);
    }

    public static MFormat getByteFormat() {
        return new BinaryFormat();
    }

    public static MFormat getEnumFormat(String[] values, String[] labels, Color[] colors) {
        return new EnumFormat(values, labels, colors);
    }

    public static MFormat getEnumFormat(Table tbl) {
        String[] keys = tbl.getKeys();
        String[] values = new String[keys.length];
        String[] labels = new String[keys.length];
        Color[] colors = new Color[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = tbl.getS(keys[i] + ".VALUE");
            labels[i] = tbl.getS(keys[i] + ".LABEL");
            colors[i] = MFormat.getColor(tbl.getS(keys[i] + ".COLOR"));
        }
        return new EnumFormat(values, labels, colors);
    }

    public static String convertFortranPattern(String pattern) {
        int comma;
        String jpattern = null;
        if ((pattern = pattern.trim().toUpperCase()).startsWith("(") && pattern.endsWith(")")) {
            pattern = pattern.substring(1, pattern.length() - 1).trim();
        }
        if ((comma = pattern.indexOf(44)) > 0) {
            jpattern = MFormat.convertFortranPattern(pattern.substring(0, comma)) + "&" + MFormat.convertFortranPattern(pattern.substring(comma + 1));
        } else if (pattern.length() > 2 && pattern.charAt(0) >= '0' && pattern.charAt(0) <= '9') {
            int i = 1;
            while (pattern.length() > i + 1 && pattern.charAt(i) >= '0' && pattern.charAt(i) <= '9') {
                ++i;
            }
            int mult = Convert.o2l(pattern.substring(0, i));
            String pat = pattern.substring(i);
            if (pat.startsWith("P")) {
                jpattern = MFormat.convertFortranPattern(pat.substring(1));
            } else {
                String jpat;
                jpattern = jpat = MFormat.convertFortranPattern(pat);
                for (int j = 1; j < mult; ++j) {
                    jpattern = jpattern + "&" + jpat;
                }
            }
        } else {
            int dot = pattern.indexOf(46);
            int exp = pattern.indexOf(69, 1);
            int w = 0;
            int m = 1;
            int d = -1;
            int e = -1;
            if (pattern.startsWith("I")) {
                if (dot < 0) {
                    w = Convert.o2l(pattern.substring(1));
                } else {
                    w = Convert.o2l(pattern.substring(1, dot));
                    m = Convert.o2l(pattern.substring(dot + 1));
                }
            } else if (pattern.startsWith("F")) {
                if (dot < 0) {
                    w = Convert.o2l(pattern.substring(1));
                } else {
                    w = Convert.o2l(pattern.substring(1, dot));
                    d = Convert.o2l(pattern.substring(dot + 1));
                }
            } else if (pattern.startsWith("E") || pattern.startsWith("G")) {
                if (exp > 0) {
                    w = Convert.o2l(pattern.substring(1, dot));
                    d = Convert.o2l(pattern.substring(dot + 1, exp));
                    e = Convert.o2l(pattern.substring(exp + 1));
                } else {
                    w = Convert.o2l(pattern.substring(1, dot));
                    d = Convert.o2l(pattern.substring(dot + 1));
                    e = 2;
                }
            }
            String whole = StringUtil.padLeft("", m, '0');
            String fract = "";
            String expon = "";
            if (d >= 0) {
                fract = "." + StringUtil.padLeft("", d, '0');
            }
            if (e >= 0) {
                expon = "E" + StringUtil.padLeft("", e, '0');
            }
            jpattern = whole + fract + expon;
            if (e < 0) {
                jpattern = StringUtil.padLeft(jpattern, w, '#');
            }
        }
        return jpattern;
    }

    private static boolean isIntType(char type) {
        return type == 'X' || type == 'L' || type == 'I' || type == 'B' || type == 'U' || type == 'V' || type == 'J';
    }

    private static String getSciStringFor(char type, boolean trim) {
        String fmt = null;
        fmt = MFormat.isIntType(type) ? (type == 'X' ? (trim ? "0.000000E000" : "0") : "0") : (type == 'F' ? (trim ? "0.000000E00" : "0.0000000000000000E00") : (trim ? "0.000000E000" : "0.0000000000000000E000"));
        return fmt;
    }

    private static Color getColor(String str) {
        return StringUtil.isNull(str) ? null : MidasColor.getColor(str);
    }

    private static class AngleFormatText
    extends AngleFormatCode {
        private static final long serialVersionUID = 2022101415503L;
        private final String text;
        private final boolean ignoreCase;

        public AngleFormatText(char c) {
            this(String.valueOf(c), false);
        }

        public AngleFormatText(String text, boolean ignoreCase) {
            this.text = text;
            this.ignoreCase = ignoreCase;
        }

        @Override
        public String format(double deg) {
            return this.text;
        }

        @Override
        public double parse(String str, ParsePosition pos) throws ParseException {
            int start = pos.getIndex();
            int end = start + this.text.length();
            boolean ok = false;
            if (str.length() >= end) {
                String txt = str.substring(start, end);
                boolean bl = ok = txt.equals(this.text) || this.ignoreCase && txt.equalsIgnoreCase(this.text);
            }
            if (!ok) {
                throw new ParseException("AngleFormat: Expected '" + this.text + "' at i=" + start + " in '" + str + "'", start);
            }
            pos.setIndex(end);
            return 0.0;
        }
    }

    private static class AngleFormatSign
    extends AngleFormatCode {
        private static final long serialVersionUID = 2022101415502L;
        private final char pos;
        private final char neg;
        private final char posU;
        private final char negU;
        private final char posL;
        private final char negL;

        public AngleFormatSign(char pos, char neg) {
            this.pos = pos;
            this.neg = neg;
            this.posU = Character.toUpperCase(pos);
            this.negU = Character.toUpperCase(neg);
            this.posL = Character.toLowerCase(pos);
            this.negL = Character.toLowerCase(neg);
        }

        @Override
        public String format(double deg) {
            char c = deg < 0.0 ? this.neg : this.pos;
            return String.valueOf(c);
        }

        @Override
        public double parse(String str, ParsePosition position) throws ParseException {
            int index = position.getIndex();
            boolean ok = false;
            double deg = Double.NaN;
            if (str.length() > index) {
                char c = str.charAt(index);
                if (c == this.posU || c == this.posL) {
                    deg = Double.POSITIVE_INFINITY;
                    ok = true;
                } else if (c == this.negU || c == this.negL) {
                    deg = Double.NEGATIVE_INFINITY;
                    ok = true;
                }
            }
            if (!ok) {
                throw new ParseException("AngleFormat: Expected '" + this.pos + "' or '" + this.neg + "' at i=" + index + " in '" + str + "'", index);
            }
            position.setIndex(index + 1);
            return deg;
        }
    }

    private static class AngleFormatCode
    implements Serializable {
        private static final long serialVersionUID = 2022101415501L;
        protected final DecimalFormat format;
        protected final char type;
        protected final boolean floor;
        protected final int length;
        protected boolean fixLen;

        protected AngleFormatCode() {
            this.format = null;
            this.type = (char)32;
            this.floor = false;
            this.length = -1;
            this.fixLen = false;
        }

        public AngleFormatCode(String pattern, char type) {
            this.format = new DecimalFormat(pattern);
            this.type = type;
            this.floor = pattern.indexOf(46) < 0;
            this.length = pattern.length();
            this.fixLen = false;
        }

        public boolean isNumber() {
            return this.length != -1;
        }

        public void setFixLen(boolean f) {
            this.fixLen = f;
        }

        public String format(double deg) {
            if (deg < 0.0) {
                deg = -deg;
            }
            double val = Double.NaN;
            int d = (int)deg;
            double min = (deg - (double)d) * 60.0;
            int m = (int)min;
            double sec = (min - (double)m) * 60.0;
            int s = (int)sec;
            if (this.floor) {
                switch (this.type) {
                    case 'd': {
                        val = d;
                        break;
                    }
                    case 'm': {
                        val = m;
                        break;
                    }
                    case 's': {
                        val = s;
                    }
                }
            } else {
                switch (this.type) {
                    case 'd': {
                        val = deg;
                        break;
                    }
                    case 'm': {
                        val = min;
                        break;
                    }
                    case 's': {
                        val = sec;
                    }
                }
            }
            return this.format.format((Object)val);
        }

        public double parse(String str, ParsePosition pos) throws ParseException {
            double val = 0.0;
            double deg = 0.0;
            if (!this.fixLen) {
                val = Convert.o2d(this.format.parseObject(str, pos));
            } else {
                int index = pos.getIndex();
                if (str.length() < index + this.length) {
                    throw new ParseException("AngleFormat: Expected " + this.length + "-digit value at i=" + index + " in '" + str + "'", index);
                }
                val = Convert.o2d(this.format.parse(str.substring(index, index + this.length)));
                pos.setIndex(index + this.length);
            }
            switch (this.type) {
                case 'd': {
                    deg = val;
                    break;
                }
                case 'm': {
                    deg = val / 60.0;
                    break;
                }
                case 's': {
                    deg = val / 3600.0;
                }
            }
            return deg;
        }
    }

    private static class AngleFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020700311L;
        static final AngleFormatCode[] EMPTY_ANGLEFORMATCODE_ARRAY = new AngleFormatCode[0];
        private AngleFormatCode[] parts;

        public AngleFormat(String pattern) {
            super("Angle Format (" + pattern + ")", null);
            this.parts = this.applyPattern(pattern);
        }

        @Override
        public String doFormat(Object obj) {
            StringBuilder sb = new StringBuilder();
            double deg = Convert.o2d(obj);
            for (int i = 0; i < this.parts.length; ++i) {
                sb.append(this.parts[i].format(deg));
            }
            return sb.toString();
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            ParsePosition pos = new ParsePosition(0);
            double sec = 0.0;
            boolean neg = false;
            for (int i = 0; i < this.parts.length; ++i) {
                double val = this.parts[i].parse(source, pos);
                if (val == Double.POSITIVE_INFINITY) {
                    neg = false;
                    continue;
                }
                if (val == Double.NEGATIVE_INFINITY) {
                    neg = true;
                    continue;
                }
                sec += val;
            }
            return neg ? Double.valueOf(-sec) : Double.valueOf(sec);
        }

        private AngleFormatCode[] applyPattern(String pattern) {
            ArrayList<AngleFormatText> parts = new ArrayList<AngleFormatText>();
            int len = pattern.length();
            for (int i = 0; i < len; ++i) {
                AngleFormatCode fmt = null;
                char c = pattern.charAt(i);
                if (c == 'd' || c == 'm' || c == 's') {
                    StringBuilder subPattern = new StringBuilder("0");
                    while (i + 1 < len && c == pattern.charAt(i + 1)) {
                        subPattern.append('0');
                        ++i;
                    }
                    if (i + 2 < len && '.' == pattern.charAt(i + 1) && c == pattern.charAt(i + 2)) {
                        subPattern.append('.');
                        ++i;
                        while (i + 1 < len && c == pattern.charAt(i + 1)) {
                            subPattern.append('0');
                            ++i;
                        }
                    }
                    fmt = new AngleFormatCode(subPattern.toString(), c);
                } else if (c == '\'') {
                    int end = pattern.indexOf(39, i + 1);
                    if (end == i + 1) {
                        fmt = new AngleFormatText('\'');
                    } else if (end > 0) {
                        fmt = new AngleFormatText(pattern.substring(i + 1, end), false);
                    }
                    i = end;
                } else {
                    switch (c) {
                        case 'N': {
                            fmt = new AngleFormatSign('N', 'S');
                            break;
                        }
                        case 'E': {
                            fmt = new AngleFormatSign('E', 'W');
                            break;
                        }
                        case '+': {
                            fmt = new AngleFormatSign('+', '-');
                            break;
                        }
                        case '-': {
                            fmt = new AngleFormatSign(' ', '-');
                            break;
                        }
                        case 'o': {
                            fmt = new AngleFormatText('\u00b0');
                            break;
                        }
                        case '.': {
                            fmt = null;
                            break;
                        }
                        default: {
                            AngleFormatText angleFormatText = fmt = Character.isLetterOrDigit(c) ? null : new AngleFormatText(c);
                        }
                    }
                }
                if (fmt == null) {
                    throw new IllegalArgumentException("AngleFormat: Invalid pattern '" + pattern + "'");
                }
                parts.add((AngleFormatText)fmt);
            }
            AngleFormatCode[] array = parts.toArray(EMPTY_ANGLEFORMATCODE_ARRAY);
            int i = 0;
            for (int j = 1; j < array.length; ++j) {
                if (array[i].isNumber() && array[j].isNumber()) {
                    array[i].setFixLen(true);
                    array[j].setFixLen(true);
                }
                ++i;
            }
            return array;
        }
    }

    private static class DateFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020600311L;

        public DateFormat(String pattern, String timeZone) {
            this("Date Format (" + pattern + ")", new SimpleDateFormat(pattern), StringUtil.isNull(timeZone) ? null : TimeZone.getTimeZone(timeZone));
        }

        public DateFormat(java.text.DateFormat dateFormat, TimeZone timeZone) {
            this("Custom Date Format", dateFormat, timeZone);
        }

        private DateFormat(String descr, java.text.DateFormat dateFormat, TimeZone timeZone) {
            super(descr, dateFormat);
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
        }

        @Override
        public String doFormat(Object obj) {
            Date date = Time.toTime(obj).toDateObject();
            return this.format.format(date);
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            double time = Double.NaN;
            try {
                Date date = (Date)this.format.parseObject(source);
                time = date.getTime() < 86401000L ? (double)date.getTime() / 1000.0 : Time.fromDateObject(date);
            }
            catch (Exception e) {
                throw new ParseException("Unable to parse '" + source + "' into a valid date.", 0);
            }
            return new Time(time);
        }
    }

    private static class NetworkFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020500311L;

        public NetworkFormat() {
            super("Network Format", null);
        }

        @Override
        public String doFormat(Object obj) {
            return StringUtil.getIpAddressString(Convert.o2l(obj));
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            int addr = 0;
            try {
                addr = StringUtil.getIpv4AddressNumber(source);
            }
            catch (Exception e) {
                throw new ParseException("Unable to parse '" + source + "' into a valid IPv4 address.", 0);
            }
            return addr;
        }
    }

    private static class EnumFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020400311L;
        private String[] values;
        private String[] labels;
        private Color[] colors;

        public EnumFormat(String[] values, String[] labels, Color[] colors) {
            super("Enum Format: LABELS=" + StringUtil.join(labels, ",") + " VALUES=" + StringUtil.join(values, ",") + " COLORS=" + StringUtil.join(colors, ","), null);
            this.values = values;
            this.labels = labels;
            this.colors = colors;
            if (values == null || labels == null) {
                throw new NullPointerException("MFormat: VALUES and LABELS must be non-null.");
            }
            if (values.length != labels.length) {
                throw new IllegalArgumentException("MFormat: VALUES and LABELS must have same length.");
            }
            if (colors != null && values.length != colors.length) {
                throw new IllegalArgumentException("MFormat: VALUES and COLORS must have same length.");
            }
        }

        @Override
        public Color getColor(Object obj) {
            int index = this.getIndex(obj.toString());
            return index < 0 ? null : this.colors[index];
        }

        @Override
        public String doFormat(Object obj) {
            int index = this.getIndex(obj.toString());
            return index < 0 ? obj.toString() : this.labels[index];
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            String val = source;
            for (int i = 0; i < this.labels.length; ++i) {
                if (!this.labels[i].equals(source)) continue;
                val = this.values[i];
                break;
            }
            return val;
        }

        private int getIndex(String str) {
            int index = -1;
            if (str != null) {
                for (int i = 0; index < 0 && i < this.values.length; ++i) {
                    if (this.values[i].equals(str)) {
                        index = i;
                        continue;
                    }
                    if (!StringUtil.isNumber(this.values[i]) || !StringUtil.isNumber(str) || Convert.o2d(this.values[i]) != Convert.o2d(str)) continue;
                    index = i;
                }
            }
            return index;
        }
    }

    private static class BinaryFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020300311L;

        private BinaryFormat() {
            super("Binary Time Format", new DecimalFormat("#.#"));
        }

        @Override
        public String doFormat(Object obj) {
            DecimalFormat dFormat = (DecimalFormat)this.format;
            long val = Convert.o2x(obj);
            String str = "";
            str = val >= 0x10000000000L ? dFormat.format(val / 0x10000000000L) + "T" : (val >= 0x40000000L ? dFormat.format(val / 0x40000000L) + "G" : (val >= 0x100000L ? dFormat.format(val / 0x100000L) + "M" : (val >= 1024L ? dFormat.format(val / 1024L) + "k" : Long.toString(val))));
            return str;
        }

        @Override
        public Object doParseObject(String source) {
            long mult = 1L;
            int index = source.length() - 1;
            if (source.endsWith("T")) {
                mult = 0x10000000000L;
                source = source.substring(0, index);
            } else if (source.endsWith("G")) {
                mult = 0x40000000L;
                source = source.substring(0, index);
            } else if (source.endsWith("M")) {
                mult = 0x100000L;
                source = source.substring(0, index);
            } else if (source.endsWith("K")) {
                mult = 1024L;
                source = source.substring(0, index);
            } else {
                mult = 1L;
            }
            return Convert.o2x(source) * mult;
        }
    }

    private static class TimeFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020200311L;
        private final int fmt;
        private final int dp;

        private TimeFormat(int fmt) {
            this(fmt, -1);
        }

        private TimeFormat(int fmt, int dp) {
            super(Time.getFormat(fmt) + " Time Format (dp=" + dp + ")", null);
            this.fmt = fmt;
            this.dp = dp;
        }

        @Override
        public String doFormat(Object obj) {
            return Time.toTime(obj).toString(this.fmt, this.dp);
        }

        @Override
        public Object doParseObject(String source) {
            return new Time(source, this.fmt);
        }
    }

    private static class DmsFormat
    extends MFormat {
        private static final long serialVersionUID = 2012020100311L;
        private String direction;

        private DmsFormat(String direction) {
            super("DMS Format", null);
            this.direction = direction;
        }

        @Override
        public String doFormat(Object obj) {
            String str = Convert.deg2dmsUnicode(Convert.o2d(obj));
            int degIndex = str.indexOf(176);
            if (this.direction == null) {
                if (str.startsWith("-")) {
                    if (degIndex == 2) {
                        str = "  " + str;
                    } else if (degIndex == 3) {
                        str = " " + str;
                    }
                } else {
                    str = degIndex == 1 ? "   " + str : (degIndex == 2 ? "  " + str : " " + str);
                }
            } else {
                str = str.startsWith("-") ? (degIndex == 2 ? "  " + str.substring(1) + this.direction.charAt(1) : (degIndex == 3 ? " " + str.substring(1) + this.direction.charAt(1) : "" + str.substring(1) + this.direction.charAt(1))) : (degIndex == 1 ? "  " + str + this.direction.charAt(0) : (degIndex == 2 ? " " + str + this.direction.charAt(0) : "" + str + this.direction.charAt(0)));
            }
            return str;
        }

        @Override
        public Object doParseObject(String source) {
            return Convert.dms2deg(source.trim());
        }
    }

    private static class VisualFormat
    extends MFormat {
        private static final long serialVersionUID = 2012013100311L;
        private final double lowerLimit;
        private final double upperLimit;
        private final MFormat expFormat;

        public VisualFormat(String name, double lower, double upper, char type) {
            super(name + " Format", VisualFormat.getVisNumFormat(type));
            this.expFormat = new NumericalFormat(MFormat.getSciStringFor(type, true));
            this.lowerLimit = lower;
            this.upperLimit = upper;
        }

        private static NumericalFormat getVisNumFormat(char type) {
            return MFormat.isIntType(type) ? new NumericalFormat("0") : new NumericalFormat("0.0000");
        }

        @Override
        public String doFormat(Object obj) {
            double absValue = Math.abs(Convert.o2d(obj));
            if (absValue == 0.0 || absValue > this.lowerLimit && absValue < this.upperLimit) {
                return this.format.format(obj);
            }
            return this.expFormat.format(obj);
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            if (source.indexOf(101) < 0) {
                return this.format.parseObject(source);
            }
            return this.expFormat.parseObject(source);
        }
    }

    private static class NumericalFormat
    extends MFormat {
        private static final long serialVersionUID = 2012013000311L;
        private static final Pattern unsignedExpNum = Pattern.compile("([0-9]+([.][0-9]+)?)([eE])([0-9]+.*)");
        private static final Pattern negExpNum = Pattern.compile("([0-9]+([.][0-9]+)?)([eE][-])([0-9]+.*)");
        private static final Pattern posExpNum = Pattern.compile("([0-9]+([.][0-9]+)?)([eE][+])([0-9]+.*)");

        public NumericalFormat(String format) {
            super("Numerical Format (" + format + ")", new DecimalFormat(format));
        }

        @Override
        public String doFormat(Object obj) {
            String str = null;
            if (obj == null) {
                str = "";
            } else if (obj instanceof Number) {
                str = this.format.format(obj);
            } else if (StringUtil.isNumber(obj.toString())) {
                obj = Convert.o2d(obj);
                str = this.format.format(obj);
            } else {
                str = obj.toString();
            }
            if (!negExpNum.matcher(str).matches()) {
                str = unsignedExpNum.matcher(str).replaceAll("$1$3+$4");
            }
            if (!str.startsWith("-")) {
                str = " " + str;
            }
            return str;
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            if (posExpNum.matcher(source).matches()) {
                source = posExpNum.matcher(source).replaceFirst("E");
            }
            return this.format.parseObject(source);
        }
    }

    private static class ArrayFormat
    extends MFormat {
        private static final long serialVersionUID = 2012012900311L;
        private final MFormat[] formats;

        public ArrayFormat(String[] patterns, boolean trim) {
            super("Format for an array of length " + patterns.length, null);
            this.formats = new MFormat[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                this.formats[i] = ArrayFormat.getNumberFormatFor(patterns[i], trim);
            }
        }

        @Override
        public String doFormat(Object[] array) {
            if (array.length == this.formats.length) {
                StringBuilder str = new StringBuilder();
                str.append('(');
                for (int i = 0; i < this.formats.length; ++i) {
                    if (i != 0) {
                        str.append(", ");
                    }
                    str.append(this.formats[i].format(array[i]));
                }
                str.append(')');
                return str.toString();
            }
            return MFormat.ERROR_STRING;
        }

        @Override
        public String doFormat(Object obj) {
            return MFormat.ERROR_STRING;
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            return source;
        }
    }

    private static class AsciiFormat
    extends StringFormat {
        private static final long serialVersionUID = 2012012800311L;
        private final int length;

        public AsciiFormat(int length) {
            super(length < 0 ? "Ascii Format" : "Ascii Format of Length " + length);
            this.length = length;
        }

        @Override
        public String doFormat(Object obj) {
            return obj != null ? StringUtil.toAsciiString(this.fixLength(obj.toString(), this.length)) : "";
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            return StringUtil.toAsciiString(this.fixLength(source, this.length));
        }

        private String fixLength(String str, int lgth) {
            if (lgth < 0) {
                return str;
            }
            if (str.length() > lgth) {
                return str.substring(0, lgth);
            }
            return str;
        }
    }

    private static class StringFormat
    extends MFormat {
        private static final long serialVersionUID = 2012012700311L;

        protected StringFormat(String name) {
            super(name, null);
        }

        public StringFormat() {
            this("String Format");
        }

        @Override
        public String doFormat(Object obj) {
            return obj != null ? obj.toString() : "";
        }

        @Override
        public Object doParseObject(String source) throws ParseException {
            return source;
        }
    }
}

