/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Time;

public class Logger {
    private Midas M;
    private DataFile lf;
    private Data lfd;
    private int size;
    private int textBPA = 80;
    private boolean firstCharacters = true;
    private static boolean autoSave = false;

    public static void setAutoSave(boolean state) {
        autoSave = state;
    }

    public Logger(Midas midas) {
        this.M = midas;
    }

    public void open(Object filename) {
        this.open(filename, "XA", true);
    }

    @InternalUseOnly
    public void open(Object filename, String format, boolean firstCharacters) {
        this.textBPA = Data.getBPA(format);
        this.firstCharacters = firstCharacters;
        this.lf = new DataFile();
        this.lf.init(this.M, filename, "3000", "NH", 0);
        this.lf.setExt("mlog");
        this.lf.setSubRecords("TIME|3A,TYPE|1A,TEXT|" + format + ",FROM|2A");
        this.lf.setTimeCode(Time.current());
        if (autoSave && this.lf.find(-1)) {
            this.saveOff();
        }
        this.lf.open(2);
        this.lfd = this.lf.getDataBuffer(1);
        this.size = 0;
    }

    public void flush() {
        this.lf.flush();
    }

    public void close() {
        this.lf.close();
    }

    public void saveOff() {
        DataFile lfs = new DataFile();
        lfs.init(this.M, (Object)this.lf.getURL(), "3000", "NH", 0);
        lfs.open(1);
        double time = lfs.getTimeCode();
        lfs.close();
        FileName fn = new FileName(lfs.getURL());
        String tag = Time.format(time, 7, 0);
        fn.setRoot(lfs.getFileName().getRoot() + "_" + tag);
        CoreIO.rename(lfs.getURL(), fn.getFullName());
    }

    public void processMessage(Message msg) {
        String from = "UNKNOWN";
        if (msg.from instanceof IDable) {
            from = ((IDable)msg.from).getID();
        }
        String type = "UNKNOWN";
        if (msg.info == 0) {
            type = "INFO";
        } else if (msg.info == 1) {
            type = "WARNING";
        } else if (msg.info == 2) {
            type = "ERROR";
        }
        this.processMessage(type, msg.data.toString(), from);
    }

    public void processMessage(CharSequence type, CharSequence text, CharSequence from) {
        if (this.lf == null || this.lfd == null) {
            return;
        }
        String time = Time.tag();
        if (type == null) {
            type = "TEXT";
        }
        if (text == null) {
            text = "";
        }
        if (from == null) {
            from = "";
        }
        this.lfd.packS(0, 24, time);
        this.lfd.packS(24, 8, type);
        if (!this.firstCharacters && text.length() > this.textBPA) {
            text = text.subSequence(text.length() - this.textBPA, text.length());
        }
        this.lfd.packS(32, this.textBPA, text);
        int locFrom = 32 + this.textBPA;
        this.lfd.packS(locFrom, 16, from);
        if ((this.M.debug & 1) == 0) {
            this.lf.write(this.lfd);
        }
        ++this.size;
    }

    public void processMessage(Midas midas, CharSequence type, CharSequence text, CharSequence from) {
        this.processMessage(type, text, from);
    }

    public int getSize() {
        return this.size;
    }
}

