/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import nxm.sys.inc.Indexable;
import nxm.sys.inc.Keyable;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class KeyVector
implements Keyable,
Indexable {
    private static final int DEFAULT_SIZE = 64;
    private String[] keys;
    private Object[] values;
    private int size = 0;
    private int size_expand = 64;
    private int lastGet = 0;
    private int lastPut = 0;

    public KeyVector() {
        this(64);
    }

    public KeyVector(int alloc) {
        this.keys = new String[alloc];
        this.values = new Object[alloc];
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public synchronized KeyVector copy() {
        KeyVector kv = new KeyVector();
        kv.keys = new String[this.keys.length];
        System.arraycopy(this.keys, 0, kv.keys, 0, this.size);
        kv.values = new Object[this.values.length];
        System.arraycopy(this.values, 0, kv.values, 0, this.size);
        kv.size = this.size;
        kv.size_expand = this.size_expand;
        kv.lastGet = this.lastGet;
        kv.lastPut = this.lastPut;
        return kv;
    }

    public synchronized void sortByKey(boolean reverse) {
        Object[] array = this.copy().getEntries();
        if (reverse) {
            Arrays.sort(array, Collections.reverseOrder());
        } else {
            Arrays.sort(array);
        }
        this.clear();
        for (int i = 0; i < array.length; ++i) {
            this.add((Map.Entry<String, Object>)array[i]);
        }
    }

    synchronized Map.Entry<String, Object>[] getEntries() {
        KeyVal[] array = new KeyVal[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = new KeyVal(this, i);
        }
        return array;
    }

    public synchronized void add(String key, Object value) {
        if (this.size >= this.keys.length) {
            this.expand(this.size_expand);
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
    }

    private final void add(Map.Entry<String, Object> e) {
        this.add(e.getKey(), e.getValue());
    }

    public synchronized void merge(Keyable keyable) {
        if (keyable instanceof KeyVector) {
            KeyVector kv = (KeyVector)keyable;
            int len = kv.size();
            this.expand(len);
            System.arraycopy(kv.keys, 0, this.keys, this.size, len);
            System.arraycopy(kv.values, 0, this.values, this.size, len);
            this.size += len;
        } else {
            String[] newKeys = keyable.getKeys();
            int len = newKeys.length;
            this.expand(len);
            System.arraycopy(newKeys, 0, this.keys, this.size, len);
            for (int i = 0; i < len; ++i) {
                this.values[this.size++] = keyable.getKey(newKeys[i]);
            }
        }
    }

    public Object put(String key, Object value) {
        int index = this.findKey(key);
        Object prevValue = this.get(index);
        if (index < 0) {
            this.add(key, value);
            this.lastPut = this.size - 1;
        } else {
            this.set(index, key, value);
            this.lastPut = index;
        }
        return prevValue;
    }

    public void put(int index, String key, Object value) {
        if (index < 0) {
            return;
        }
        for (int i = this.size; i <= index; ++i) {
            this.add("", null);
        }
        this.set(index, key, value);
    }

    public String getKey(int index) {
        return this.keys[index];
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        return this.values[index];
    }

    public Object get(String key) {
        return this.get(this.findKey(key));
    }

    @Override
    public Object getIndex(int index) {
        return this.get(index);
    }

    @Override
    public void setIndex(int index, Object value) {
        this.set(index, value);
    }

    public void set(int index, Object value) {
        if (index < 0 || index >= this.size) {
            return;
        }
        this.values[index] = value;
    }

    public void set(int index, String key, Object value) {
        if (index < 0 || index >= this.size) {
            return;
        }
        this.keys[index] = key;
        this.values[index] = value;
    }

    public void set(String key, Object value) {
        this.set(this.findKey(key), key, value);
    }

    public synchronized void remove(int index) {
        if (index < 0 || index >= this.size) {
            return;
        }
        --this.size;
        for (int i = index; i < this.size; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
        }
        this.keys[this.size] = null;
        this.values[this.size] = null;
    }

    public synchronized void remove(String key) {
        this.remove(this.findKey(key));
    }

    public synchronized void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public int find(String key) {
        return this.findKey(key);
    }

    public int findKey(String key) {
        int index = -1;
        if (key == null || key.isEmpty() || this.keys == null || this.keys.length == 0) {
            return index;
        }
        if (this.lastGet < this.size && key.equals(this.keys[this.lastGet])) {
            index = this.lastGet;
        }
        if (this.lastPut < this.size && key.equals(this.keys[this.lastPut])) {
            index = this.lastPut;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            this.lastGet = index = i;
            break;
        }
        return index;
    }

    public int findValue(Object value) {
        for (int i = 0; i <= this.size; ++i) {
            if (value != this.values[i]) continue;
            return i;
        }
        return -1;
    }

    public void rename(String key, String newKey) {
        int index = this.findKey(key);
        if (index >= 0) {
            this.keys[index] = newKey;
        }
    }

    synchronized void expand(int expand) {
        int alloc = this.keys.length + expand;
        String[] nkeys = new String[alloc];
        Object[] nvalues = new Object[alloc];
        System.arraycopy(this.keys, 0, nkeys, 0, this.size);
        System.arraycopy(this.values, 0, nvalues, 0, this.size);
        this.keys = nkeys;
        this.values = nvalues;
    }

    @Override
    public String[] getKeys() {
        int num = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] == null) continue;
            ++num;
        }
        String[] array = new String[num];
        if (num == this.size) {
            System.arraycopy(this.keys, 0, array, 0, this.size);
        } else {
            int j = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.keys[i] == null) continue;
                array[j++] = this.keys[i];
            }
        }
        return array;
    }

    @Override
    public Object getKey(String key) {
        if (key.equals("SIZE")) {
            Shell.deprecate("KeyVector.getKey('SIZE') is deprecated since NeXtMidas 2.7.1, use getKey('GETSIZE')");
            return this.size();
        }
        if (key.equals("GETSIZE")) {
            return this.size();
        }
        if (key.equals("GETPREV")) {
            return null;
        }
        if (key.equals("GETKEYS")) {
            return this.getKeys();
        }
        if (key.equals("GETLIST")) {
            return this.getKeyList();
        }
        return this.get(key);
    }

    @Override
    public Object setKey(String key, Object value) {
        this.put(key, value);
        return value;
    }

    public String getKeyList() {
        return this.getKeyList(0, this.size);
    }

    public String getKeyList(int i1, int i2) {
        String list3 = "";
        for (int i = i1; i < i2; ++i) {
            if (list3.length() > 0) {
                list3 = list3 + ",";
            }
            if (this.keys[i] == null) continue;
            list3 = list3 + this.keys[i];
        }
        return list3;
    }

    public void dump() {
        for (int i = 0; i < this.size; ++i) {
            System.out.println("Index=" + i + " Key=" + this.keys[i] + " Value=" + this.values[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        int flagsPlusDisableEscape = Table.getDefaultFlagsInt() | 0x100;
        Table.toStringBuffer((Object)this, sb, flagsPlusDisableEscape);
        return sb.toString();
    }

    public static KeyVector fromString(String str) {
        Table t = new Table(2);
        t.fromBytes(str.getBytes());
        return (KeyVector)t.getCore();
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    private static class KeyVal
    implements Comparable<Object>,
    Map.Entry<String, Object> {
        final KeyVector kv;
        final int index;

        KeyVal(KeyVector kv, int index) {
            this.kv = kv;
            this.index = index;
        }

        @Override
        public String getKey() {
            return this.kv.getKey(this.index);
        }

        @Override
        public Object getValue() {
            return this.kv.get(this.index);
        }

        public String toString() {
            return "" + this.getKey() + "=" + this.getValue();
        }

        @Override
        public Object setValue(Object v) {
            Object old = this.getValue();
            this.kv.set(this.index, v);
            return old;
        }

        @Override
        public int compareTo(Object obj) {
            KeyVal other = (KeyVal)obj;
            String k1 = this.getKey();
            String k2 = other.getKey();
            if (k1 == null) {
                return k2 == null ? 0 : -1;
            }
            if (k2 == null) {
                return 1;
            }
            String s1 = k1.toString();
            String s2 = k2.toString();
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            KeyVal e1 = this;
            Map.Entry e2 = (Map.Entry)obj;
            return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            KeyVal e = this;
            return (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
        }
    }

    public class Iterator {
        public KeyVector kv;
        public String[] keys;
        public Object[] values;
        public int offset;
        public int size;
        public String key;
        public Object value;

        public Iterator(KeyVector kv) {
            this.kv = kv;
            this.size = kv.size();
            this.keys = new String[this.size];
            this.values = new Object[this.size];
            this.offset = 0;
            System.arraycopy(kv.keys, 0, this.keys, 0, this.size);
            System.arraycopy(kv.values, 0, this.values, 0, this.size);
        }

        public boolean hasNext() {
            return this.offset < this.size;
        }

        public boolean getNext() {
            if (this.offset >= this.size) {
                return false;
            }
            this.next();
            return true;
        }

        public Object next() {
            this.key = this.keys[this.offset];
            this.value = this.values[this.offset];
            ++this.offset;
            return this.key;
        }

        public void remove() {
            this.kv.remove(this.key);
        }
    }
}

