/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nxm.sys.inc.Installation;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.MidasIOException;
import nxm.sys.lib.Shell;

public class JarResource
extends IOResource {
    private URL url;
    private BufferedInputStream in;
    private Boolean existCachedResult = null;

    public String toString() {
        return "JarResource: " + this.getURL();
    }

    @Override
    public void setURL(String urlstr) {
        String prev_urlstr = this.getURL();
        if (!urlstr.equals(prev_urlstr)) {
            urlstr = urlstr.replace("\\", "/");
            super.setURL("jar:", ".jar", new String[]{"!/"}, urlstr);
            try {
                this.url = new URI(this.getURL()).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new MidasException("JarResource: Error accessing JAR file URL=" + this.getURL(), e);
            }
            this.existCachedResult = null;
        }
    }

    @InternalUseOnly
    protected JarURLConnection getConnection() throws MidasException {
        URLConnection conn = null;
        try {
            conn = this.url.openConnection();
            if (this.getStateQualifier("DISABLEUSECACHES")) {
                conn.setUseCaches(false);
            }
            return (JarURLConnection)conn;
        }
        catch (ClassCastException e) {
            throw new MidasException("JarResource: Unable to convert " + conn.getClass() + " to JarURLConnection when given URL=" + this.url, e);
        }
        catch (Exception e) {
            throw new MidasException("JarResource: Error connecting to URL=" + this.url, e);
        }
    }

    @InternalUseOnly
    protected JarEntry getEntry() {
        try {
            JarURLConnection conn = this.getConnection();
            return conn != null ? conn.getJarEntry() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @InternalUseOnly
    protected JarFile getFile() {
        try {
            JarURLConnection conn = this.getConnection();
            return conn != null ? conn.getJarFile() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean exists() {
        if (this.existCachedResult != null) {
            return this.existCachedResult;
        }
        JarFile jarFile = this.getFile();
        this.existCachedResult = jarFile != null;
        if (this.existCachedResult.booleanValue() && !Installation.ApplyBugFix.JARRESOURCE_ICEDTEA_WEB_WORKAROUND) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                if (this.M != null) {
                    this.M.printStackTrace(e);
                }
                Shell.printStackTrace(e);
            }
        }
        return this.existCachedResult;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        try {
            long startOffset = this.offset;
            JarURLConnection conn = this.getConnection();
            if (this.dir <= 0) {
                this.in = new BufferedInputStream(conn.getInputStream());
            }
            if (this.dir >= 0) {
                throw new MidasException("JarResource: Output not supported at this time, URL=" + this.url);
            }
            this.offset = 0L;
            this.isOpen = true;
            this.seek(startOffset);
        }
        catch (Exception e) {
            this.isOpen = false;
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        boolean stat = this.closeIO(this.in);
        this.isOpen = false;
        this.in = null;
        return stat;
    }

    private void reopenAtOffset(long off) {
        this.offset = off;
        this.close();
        this.open();
    }

    @Override
    public long getLength() {
        JarEntry entry = this.getEntry();
        return entry != null ? entry.getSize() : 0L;
    }

    @Override
    public boolean seek(long off) {
        if (!this.isOpen) {
            this.offset = off;
        } else if (off != this.offset) {
            if (off > this.offset) {
                try {
                    long toSkip = off - this.offset;
                    long numSkip = this.in.skip(toSkip);
                    if (numSkip != toSkip) {
                        if (this.in.available() == 0) {
                            if (this.M.io.isOptionSet(CoreIO.IOOptions.FileIONoAbort)) {
                                this.M.info("JarResource: seek location beyond end of file offset=" + off + " URL=" + this.url);
                                return false;
                            }
                            throw new MidasIOException("JarResource: seek location beyond end of file offset=" + off + " URL=" + this.url);
                        }
                        this.reopenAtOffset(off);
                    }
                }
                catch (IOException e) {
                    if (e.getMessage().equals("Stream closed")) {
                        this.M.warnStackTrace("Reopening " + this.url + ". JarResource.seek resulted in", e);
                        this.reopenAtOffset(off);
                    }
                    throw new MidasException("JarResource: Unable to seek to " + off + " URL=" + this.url, e);
                }
                this.offset = off;
            } else {
                this.reopenAtOffset(off);
            }
        }
        return true;
    }

    @Override
    public long avail() {
        if (this.in == null) {
            return 0L;
        }
        try {
            return this.in.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        int totRead = 0;
        int reopenCount = 0;
        while (bytes > 0) {
            try {
                int numRead = this.in.read(buf, boff, bytes);
                if (numRead < 0) {
                    return totRead > 0 ? totRead : numRead;
                }
                this.offset += (long)numRead;
                boff += numRead;
                totRead += numRead;
                bytes -= numRead;
            }
            catch (IOException e) {
                if (e.getMessage().equals("Stream closed")) {
                    if (reopenCount == 1024) {
                        Shell.warning("JarResource: Connection to " + this.url + " closed, unable to complete read(..) call");
                        return totRead > 0 ? totRead : -3;
                    }
                    this.reopenAtOffset(this.offset);
                    ++reopenCount;
                    continue;
                }
                return totRead > 0 ? totRead : -3;
            }
        }
        return totRead;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        throw new MidasException("JarResource: Output not supported at this time, URL=" + this.url);
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        int lenEntName;
        JarURLConnection conn = this.getConnection();
        ArrayList<String> list3 = new ArrayList<String>();
        JarFile jarFile = this.getFile();
        Enumeration<JarEntry> entries = jarFile != null ? jarFile.entries() : null;
        String entryName = conn.getEntryName();
        if (entryName == null) {
            entryName = "";
            lenEntName = 0;
        } else {
            lenEntName = entryName.length();
        }
        while (entries != null && entries.hasMoreElements()) {
            String fname;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(entryName) || (fname = name.substring(lenEntName)).length() <= 0 || fname.indexOf(47) >= 0 || !filter.accept(null, fname)) continue;
            list3.add(fname);
        }
        Object[] files = list3.toArray(EMPTY_STRING_ARRAY);
        Arrays.sort(files);
        return files;
    }

    @Override
    public long lastModified() {
        long utcSecs = 0L;
        JarEntry jarEntry = this.getEntry();
        if (jarEntry != null && (utcSecs = jarEntry.getTime()) < 0L) {
            utcSecs = 0L;
        }
        return utcSecs;
    }
}

