/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Position;
import nxm.sys.lib.ShapeFile;
import nxm.sys.lib.TMatrix;
import nxm.sys.lib.Table;
import nxm.sys.lib.Transform;

public final class GeodeticUtil {
    public static final int MODE_TDOA = 1;
    public static final int MODE_FDOA = 2;
    private static ShapeFile countries;
    private static boolean insidePolyFix;

    private GeodeticUtil() {
    }

    public static boolean insidePolygon(Position p, int dim, double[] outer, double[] ... inner) {
        if (inner != null) {
            for (double[] in : inner) {
                if (!GeodeticUtil.insidePolygon(p, dim, in)) continue;
                return false;
            }
        }
        return GeodeticUtil.insidePolygon(p, dim, outer);
    }

    @ProvisionalUseOnly(value="limited testing")
    public static boolean insidePolygon(Position point, List<Position> polygon) {
        boolean a = false;
        boolean b = false;
        boolean pole = false;
        double pointLat = point.getLat();
        double pointLon = point.getLon();
        Position p0 = polygon.get(0);
        double priorLat = p0.getLat();
        double priorLon = p0.getLon();
        double maxLat = Math.max(priorLat, 0.0);
        double minLat = Math.min(priorLat, 0.0);
        for (int n = 1; n < polygon.size(); ++n) {
            double thisLon;
            Position pN = polygon.get(n);
            double thisLat = pN.getLat();
            double origThisLon = thisLon = pN.getLon();
            double lastLat = priorLat;
            double lastLon = priorLon;
            double thisLastDiff = thisLon - lastLon;
            if (thisLastDiff > 180.0) {
                boolean bl = pole = !pole;
                if (pointLon > thisLon) {
                    lastLon += 360.0;
                } else {
                    thisLon -= 360.0;
                }
            } else if (thisLastDiff < -180.0) {
                boolean bl = pole = !pole;
                if (pointLon > lastLon) {
                    thisLon += 360.0;
                } else {
                    lastLon -= 360.0;
                }
            }
            if (thisLat == pointLat && thisLon == pointLon) {
                return true;
            }
            if (thisLon == pointLon && thisLon == lastLon) {
                if (thisLat <= pointLat && pointLat <= lastLat || lastLat <= pointLat && pointLat <= thisLat) {
                    return true;
                }
            } else if (thisLat == pointLat && thisLat == lastLat) {
                if (thisLon <= pointLon && pointLon <= lastLon || lastLon <= pointLon && pointLon <= thisLon) {
                    return true;
                }
            } else if (lastLon >= pointLon != thisLon >= pointLon) {
                if (pointLat > (thisLat - lastLat) * (pointLon - lastLon) / (thisLon - lastLon) + lastLat) {
                    a = !a;
                } else {
                    b = !b;
                }
            }
            maxLat = Math.max(thisLat, maxLat);
            minLat = Math.min(thisLat, minLat);
            priorLat = thisLat;
            priorLon = origThisLon;
        }
        if (!pole) {
            return a;
        }
        if (maxLat > -minLat) {
            return a;
        }
        return b;
    }

    public static boolean insidePolygon(Position p, int dim, double[] polygon) {
        boolean a = false;
        boolean b = false;
        boolean crossing = false;
        double maxy = 0.0;
        double miny = 0.0;
        int i = 0;
        int j = 0;
        int length = polygon.length / dim;
        double py = p.getLat();
        double px = p.getLon();
        px = GeodeticUtil.normalizeLongitude(px);
        double[] polygonCopy = (double[])polygon.clone();
        for (i = 0; i < polygonCopy.length / dim; ++i) {
            double lon = polygonCopy[i * dim];
            polygonCopy[i * dim] = GeodeticUtil.normalizeLongitude(lon);
        }
        i = 0;
        j = length - 1;
        while (i < length) {
            double pix = polygonCopy[i * dim];
            double pjx = polygonCopy[j * dim];
            double piy = polygonCopy[i * dim + 1];
            double pjy = polygonCopy[j * dim + 1];
            maxy = Math.max(piy, maxy);
            miny = Math.min(piy, miny);
            double pijdiff = pix - pjx;
            if (pix > 90.0 && pjx < -90.0 || insidePolyFix && pijdiff > 180.0) {
                boolean bl = crossing = !crossing;
                if (px > pix) {
                    pjx += 360.0;
                } else {
                    pix -= 360.0;
                }
            } else if (pix < -90.0 && pjx > 90.0 || insidePolyFix && pijdiff < -180.0) {
                boolean bl = crossing = !crossing;
                if (px > pjx) {
                    pix += 360.0;
                } else {
                    pjx -= 360.0;
                }
            }
            if (pjy == py && pjx == px) {
                return true;
            }
            if (pjx == px && pjx == pix) {
                if (pjy <= py && py <= piy || piy <= py && py <= pjy) {
                    return true;
                }
            } else if (pjy == py && pjy == piy) {
                if (pjx <= px && px <= pix || pix <= px && px <= pjx) {
                    return true;
                }
            } else if (pix >= px != pjx >= px) {
                if (py > (pjy - piy) * (px - pix) / (pjx - pix) + piy) {
                    boolean bl = a = !a;
                }
                if (py <= (pjy - piy) * (px - pix) / (pjx - pix) + piy) {
                    b = !b;
                }
            }
            j = i++;
        }
        boolean north = maxy > -miny;
        return a && !crossing || a && crossing && north || b && crossing && !north;
    }

    public static double normalizeLongitude(double lon) {
        if (lon < -180.0) {
            lon = -((-lon + 180.0) % 360.0 - 180.0);
        } else if (lon > 180.0) {
            lon = (lon + 180.0) % 360.0 - 180.0;
        }
        return lon;
    }

    private static double predictPair(Position p1, Position p2, Position t1, int mode, double soi_freq) {
        double xta = p1.getX() - t1.getX();
        double yta = p1.getY() - t1.getY();
        double zta = p1.getZ() - t1.getZ();
        double xtb = p2.getX() - t1.getX();
        double ytb = p2.getY() - t1.getY();
        double ztb = p2.getZ() - t1.getZ();
        double rta = Math.sqrt(xta * xta + yta * yta + zta * zta);
        double rtai = 1.0 / rta;
        double rtb = Math.sqrt(xtb * xtb + ytb * ytb + ztb * ztb);
        double rtbi = 1.0 / rtb;
        double rrta = (xta * p1.getVX() + yta * p1.getVY() + zta * p1.getVZ()) * rtai;
        double rrtb = (xtb * p2.getVX() + ytb * p2.getVY() + ztb * p2.getVZ()) * rtbi;
        double cci = 3.3356409519815204E-9;
        if (mode == 1) {
            return cci * (rtb - rta);
        }
        return -cci * (soi_freq * (rrtb - rrta));
    }

    private static boolean isBetween(double test, double a, double b) {
        return test > a && test < b || test < a && test > b;
    }

    @Deprecated
    public static double computeDistance(Position p1, Position p2) {
        double lat1 = p1.lat;
        double lat2 = p2.lat;
        double lon1 = p1.lon;
        double lon2 = p2.lon;
        return 6378137.0 * Math.acos(Math.sin(Math.PI / 180 * lat1) * Math.sin(Math.PI / 180 * lat2) + Math.cos(Math.PI / 180 * lat1) * Math.cos(Math.PI / 180 * lat2) * Math.cos(Math.PI / 180 * lon1 - Math.PI / 180 * lon2));
    }

    public static double computeDistanceMeters(Position position1, Position position2) {
        return Transform.greatArc(position1, position2);
    }

    public static double computeDistanceDeg(Position p, Position q) {
        return 8.983152841195214E-6 * Transform.greatArc(p, q);
    }

    public static double[] drawLOPLL(Position p1, Position p2, Position t, double soi_freq, int mode, int aRes, double[] vRes) {
        double tPoint = GeodeticUtil.predictPair(p1, p2, t, mode, soi_freq);
        double[] pointsArray = new double[aRes];
        double div = 360.0 / (double)aRes;
        Position cp = t.copy();
        double[] buf = new double[5000];
        if (vRes == null) {
            vRes = new double[]{100000.0, 500.0, 1000000.0, 10000.0, 4000000.0, 50000.0, Double.MAX_VALUE, 400000.0};
        }
        double distRes = vRes[1];
        buf[0] = cp.lon;
        buf[1] = cp.lat;
        int j = 2;
        int l = 0;
        double distToT = 0.0;
        while (!(2.0 * vRes[1] > distToT && j > 10 || j > buf.length - 10)) {
            double closestValue = Double.MAX_VALUE;
            int closest = 0;
            boolean found = false;
            double angle = 0.0;
            for (int i = 0; i < vRes.length; i += 2) {
                if (!(distToT < vRes[i])) continue;
                distRes = vRes[i + 1];
                break;
            }
            int previousPoint = (l + aRes) % aRes;
            pointsArray[previousPoint] = GeodeticUtil.predictPair(p1, p2, GeodeticUtil.computePosition(cp, div * (double)previousPoint, distRes), mode, soi_freq);
            for (int i = 0; i < aRes; ++i) {
                int pPoint;
                int currentPoint;
                if (i % 2 == 0) {
                    currentPoint = (l + i / 2 + 1) % aRes;
                    pPoint = (currentPoint + aRes - 1) % aRes;
                } else {
                    currentPoint = (l + aRes - i / 2 - 1) % aRes;
                    pPoint = (currentPoint + 1) % aRes;
                }
                pointsArray[currentPoint] = GeodeticUtil.predictPair(p1, p2, GeodeticUtil.computePosition(cp, div * (double)currentPoint, distRes), mode, soi_freq);
                if (GeodeticUtil.isBetween(tPoint, pointsArray[currentPoint], pointsArray[pPoint])) {
                    angle = pointsArray[currentPoint] >= pointsArray[pPoint] && currentPoint > pPoint || pointsArray[currentPoint] <= pointsArray[pPoint] && currentPoint < pPoint ? div * (double)currentPoint + div * Math.abs(tPoint - pointsArray[pPoint]) / (pointsArray[currentPoint] - pointsArray[pPoint]) : div * (double)currentPoint + div * Math.abs(pointsArray[pPoint] - tPoint) / (pointsArray[pPoint] - pointsArray[currentPoint]);
                    found = true;
                    l = currentPoint;
                    break;
                }
                if (!(Math.abs(tPoint - pointsArray[currentPoint]) < closestValue)) continue;
                closestValue = Math.abs(tPoint - pointsArray[currentPoint]);
                closest = currentPoint;
            }
            if (!found) {
                angle = div * (double)closest;
                l = closest;
            }
            Position np = GeodeticUtil.computePosition(cp, angle, distRes);
            l = np.lat >= 90.0 ? aRes / 2 : (np.lat <= -90.0 ? 0 : ((int)(GeodeticUtil.computeCourse(np, cp) * (double)aRes / 360.0) + aRes / 2) % aRes);
            cp = np;
            distToT = GeodeticUtil.computeDistance(cp, t);
            buf[j++] = cp.lon;
            buf[j++] = cp.lat;
        }
        buf[j++] = buf[0];
        buf[j++] = buf[1];
        double[] returnArray = new double[j];
        System.arraycopy(buf, 0, returnArray, 0, j);
        return returnArray;
    }

    public static double computeCourse(Position p1, Position p2) {
        double p1lonrad = p1.lon * (Math.PI / 180);
        double p2lonrad = p2.lon * (Math.PI / 180);
        double p1latrad = p1.lat * (Math.PI / 180);
        double p2latrad = p2.lat * (Math.PI / 180);
        double tc = Math.atan2(Math.sin(p2lonrad - p1lonrad) * Math.cos(p2latrad), Math.cos(p1latrad) * Math.sin(p2latrad) - Math.sin(p1latrad) * Math.cos(p2latrad) * Math.cos(p2lonrad - p1lonrad));
        tc = 57.29577951308232 * (tc % (Math.PI * 2));
        return (tc + 360.0) % 360.0;
    }

    public static double computeElevation(Position p, Position q, double def) {
        Transform tp = new Transform();
        Transform tq = new Transform();
        tp.setTOP(p.alt, p.lat, p.lon);
        tq.setTOP(q.alt, q.lat, q.lon);
        double[] qpos = new double[3];
        Transform.top2top(qpos, 1, 1, tp, tq);
        double x = qpos[0];
        double y = qpos[1];
        double z = qpos[2];
        if (z == 0.0) {
            return def;
        }
        double r1 = Math.sqrt(x * x + y * y);
        return Math.toDegrees(Math.atan(z / r1));
    }

    public static Position computePosition(Position p, double h, double d) {
        if (d == 0.0) {
            return Position.fromGeo(0.0, p.getLat(), p.getLon());
        }
        if (p.getLat() >= 90.0 || p.getLat() <= -90.0) {
            double distDegLat = d / 4.007501668557849E7 * 360.0;
            return Position.fromGeo(0.0, p.getLat() >= 90.0 ? 90.0 - distDegLat : -90.0 + distDegLat, h);
        }
        double hRad = h * (Math.PI / 180);
        double dRad = d / 6378137.0;
        double lat1Rad = Math.PI / 180 * p.getLat();
        double lon1Rad = Math.PI / 180 * p.getLon();
        double cosD = Math.cos(dRad);
        double sinD = Math.sin(dRad);
        double sinLat1 = Math.sin(lat1Rad);
        double cosLat1 = Math.cos(lat1Rad);
        double cosH = Math.cos(hRad);
        double sinH = Math.sin(hRad);
        double latrad = Math.asin(sinLat1 * cosD + cosLat1 * sinD * cosH);
        double dlonrad = Math.atan2(sinH * sinD * cosLat1, cosD - sinLat1 * Math.sin(latrad));
        double lonrad = (lon1Rad + dlonrad + Math.PI) % (Math.PI * 2) - Math.PI;
        double latdeg = 57.29577951308232 * latrad;
        double londeg = 57.29577951308232 * lonrad;
        londeg = londeg > 180.0 ? londeg - 360.0 : (londeg < -180.0 ? londeg + 360.0 : londeg);
        return Position.fromGeo(0.0, latdeg, londeg);
    }

    public static double computeDistance(double alt, double elev) {
        double e = Math.PI / 180 * elev + 1.5707963267948966;
        double r = 6378137.0;
        double d = alt + r;
        double a = Math.asin(Math.sin(e) * 6378137.0 / d);
        double b = Math.PI - a - e;
        return 6378137.0 * b;
    }

    public static double computeHorizonDistance(double alt) {
        double r = 6378137.0;
        double d = alt + r;
        double w = Math.asin(r / d);
        return 90.0 - Math.toDegrees(w);
    }

    public static double[] computeHorizonLL(Position pos, int div) {
        double radius = GeodeticUtil.computeHorizonDistance(pos.getAlt());
        return GeodeticUtil.computeCircleLL(pos.getLon(), pos.getLat(), radius, div);
    }

    public static double[] computeHorizonLL(double lon, double lat, double alt, int div) {
        double radius = GeodeticUtil.computeHorizonDistance(alt);
        return GeodeticUtil.computeCircleLL(lon, lat, radius, div);
    }

    public static double[] computeCircleLL(Position pos, double radius, int div) {
        return GeodeticUtil.computeCircleLL(pos.getLon(), pos.getLat(), radius, div);
    }

    public static double[] computeCircleLL(double lon, double lat, double radius, int div) {
        if (div == -1) {
            div = 90;
        }
        int len = (div + 1) * 2;
        double[] buf = new double[len];
        double ang = 0.0;
        if (lat >= 90.0) {
            int ii = 0;
            int jj = 0;
            while (ii < buf.length) {
                buf[ii] = 180.0 - (double)jj * 360.0 / (double)div;
                if (buf[ii] < -180.0) {
                    int n = ii;
                    buf[n] = buf[n] + 360.0;
                }
                if (buf[ii] > 180.0) {
                    int n = ii;
                    buf[n] = buf[n] - 360.0;
                }
                buf[ii + 1] = 90.0 - radius;
                ii += 2;
                ++jj;
            }
        } else if (lat <= -90.0) {
            int ii = 0;
            int jj = 0;
            while (ii < buf.length) {
                buf[ii] = 0.0 + (double)jj * 360.0 / (double)div;
                if (buf[ii] < -180.0) {
                    int n = ii;
                    buf[n] = buf[n] + 360.0;
                }
                if (buf[ii] > 180.0) {
                    int n = ii;
                    buf[n] = buf[n] - 360.0;
                }
                buf[ii + 1] = radius - 90.0;
                ii += 2;
                ++jj;
            }
        } else {
            double w = Math.PI * 2 / (double)div;
            double latRad = Math.toRadians(lat);
            double sinLat = Math.sin(latRad);
            double cosLat = Math.cos(latRad);
            double d = Math.toRadians(radius);
            double cosD = Math.cos(d);
            double sinD = Math.sin(d);
            int i = 0;
            while (i < len) {
                double yRad = Math.asin(sinLat * cosD + cosLat * sinD * Math.cos(ang));
                double xRad = Math.atan2(Math.sin(ang) * sinD * cosLat, cosD - sinLat * Math.sin(yRad));
                buf[i + 0] = GeodeticUtil.normalizeLongitude(Math.toDegrees(xRad) + lon);
                buf[i + 1] = Math.toDegrees(yRad);
                i += 2;
                ang += w;
            }
        }
        buf[len - 2] = buf[0];
        buf[len - 1] = buf[1];
        return buf;
    }

    public static double[] computeConeLLA(Position p, Position q, double angle, int div) {
        return GeodeticUtil.computeConeLLA(p, q, angle, div, 0.0, 1);
    }

    public static double[] computeConeLLA(Position p, Position q, double angle, int div, double range, int mode) {
        return GeodeticUtil.computeConeLLA(p, q, angle, div, range, mode, false);
    }

    @InternalUseOnly
    public static double[] computeConeLLA(Position p, Position q, double angle, int div, double range, int mode, boolean trimToGeosurface) {
        double cz;
        if (div == -1) {
            div = 90;
        }
        int npts = div + 1;
        double rclip = 6388137.0;
        double[] tdata = new double[3];
        double[] vdata = new double[3];
        double[] cidata = new double[3];
        double[] cdata = new double[npts * 3];
        Transform ctp = new Transform();
        Transform ctq = new Transform();
        if (p.referenceFrame != 1) {
            p.car2geo();
        }
        if (q.referenceFrame != 1) {
            q.car2geo();
        }
        ctp.setTOP(p.alt, p.lat, p.lon);
        ctq.setTOP(q.alt, q.lat, q.lon);
        Transform.top2top(tdata, 1, 1, ctq, ctp);
        double x = tdata[0];
        double y = tdata[1];
        double z = tdata[2];
        double r = Math.sqrt(x * x + y * y + z * z);
        double azim = 0.0;
        double elev = x == 0.0 && z == 0.0 ? 0.0 : 57.29577951308232 * Math.atan2(-x, z);
        double roll = r == 0.0 ? 0.0 : 57.29577951308232 * Math.asin(Math.min(1.0, Math.max(-1.0, -y / r)));
        ctp.setTOP(p.alt, p.lat, p.lon, azim, elev, roll);
        if (range > 0.0) {
            r = range;
        }
        double dtheta = Math.PI * 2 / (double)div;
        double cr = r * Math.tan(Math.PI / 180 * angle);
        cidata[2] = cz = range < 0.0 ? 0.0 : r;
        int j = 0;
        for (int i = 0; i < div; ++i) {
            double theta = (double)i * dtheta;
            cdata[j++] = cr * Math.cos(theta);
            cdata[j++] = cr * Math.sin(theta);
            cdata[j++] = cz;
        }
        vdata[2] = range < 0.0 ? r : 0.0;
        Transform.top2ecr(cidata, 1, 1, ctp);
        Transform.top2ecr(vdata, 1, 1, ctp);
        Transform.top2ecr(cdata, 1, div, ctp);
        x = cidata[0];
        y = cidata[1];
        z = cidata[2];
        r = Math.sqrt(x * x + y * y + z * z);
        if (r < rclip) {
            Transform.clipAtEarth(cdata, 0, npts, vdata, mode, trimToGeosurface, p, angle);
        }
        Transform.car2geo(cdata, 1, div);
        Transform.all2lla(cdata, div);
        System.arraycopy(cdata, 0, cdata, div * 3, 3);
        return cdata;
    }

    public static double[] computeMapEllipse(double lon, double lat, double semiMajor, double semiMinor, double tilt, int div) {
        return GeodeticUtil.computeEllipseLL(lon, lat, semiMajor, semiMinor, 90.0 - tilt, div);
    }

    public static double[] computeEllipseLL(double lon, double lat, double semiMajor, double semiMinor, double tilt, int div) {
        int i;
        if (div == -1) {
            div = 90;
        }
        int elen = (div + 1) * 3;
        double[] edata = new double[elen];
        Transform et = new Transform();
        et.setTOP(0.0, lat, lon, tilt, 0.0, 0.0);
        double a2i = 1.0 / (semiMajor * semiMajor);
        double b2i = 1.0 / (semiMinor * semiMinor);
        double dtheta = Math.PI * 2 / (double)div;
        int j = 0;
        for (i = 0; i < div; ++i) {
            double theta = (double)i * dtheta;
            double ctheta = Math.cos(theta);
            double stheta = Math.sin(theta);
            double r = Math.sqrt(1.0 / (a2i * ctheta * ctheta + b2i * stheta * stheta));
            edata[j++] = r * ctheta;
            edata[j++] = r * stheta;
            edata[j++] = 0.0;
        }
        Transform.top2ecr(edata, 1, div, et);
        Transform.car2geo(edata, 1, div);
        Transform.all2lla(edata, div);
        for (i = 0; i < 3; ++i) {
            edata[j++] = edata[i];
        }
        return GeodeticUtil.fromLLAToLL(edata);
    }

    public static double[] fixAltitudeLLA(double[] points) {
        for (int i = 2; i < points.length; i += 3) {
            if (!(points[i] < 5.0E-4)) continue;
            points[i] = 0.0;
        }
        return points;
    }

    public static double[] zeroAltitudeLLA(double[] points) {
        for (int i = 2; i < points.length; i += 3) {
            points[i] = 0.0;
        }
        return points;
    }

    public static double[] fromLLAToLL(double[] points) {
        double[] data = new double[points.length * 2 / 3];
        int j = 0;
        for (int i = 0; i < points.length; i += 3) {
            data[j++] = points[i + 0];
            data[j++] = points[i + 1];
        }
        return data;
    }

    public static double[] fromLLToALL(double[] ll) {
        int llLength = ll.length;
        double[] all = new double[llLength * 3 / 2];
        int j = 0;
        for (int i = 0; i < llLength; i += 2) {
            all[j++] = 0.0;
            all[j++] = ll[++i];
            all[j++] = ll[--i];
        }
        return all;
    }

    public static double[] getCenterECEFGeo(double[] perimeterECEFGeo) {
        double[] crudeCenterEG = GeodeticUtil.getCenterOfBoundingBoxECEFGeo(perimeterECEFGeo);
        TMatrix tm = new TMatrix();
        tm.rotate(90.0 - crudeCenterEG[2], 1);
        tm.rotate(-crudeCenterEG[1], 3);
        tm.rotate(-90.0, 1);
        double[] perimeterEGO = Transform.ecefGeo2ecefGeo(tm, perimeterECEFGeo);
        double[] fineCenterEGO = GeodeticUtil.getCenterOfBoundingBoxECEFGeo(perimeterEGO);
        tm.transpose();
        return Transform.ecefGeo2ecefGeo(tm, fineCenterEGO);
    }

    public static double[] getCenterECRGeo(double[] perimeterECRGeo) {
        return GeodeticUtil.getCenterECEFGeo(perimeterECRGeo);
    }

    public static double[] getCircleOfLatitudeECEFGeo(double lat, int numSidesForShape) {
        double[] circle = new double[(numSidesForShape + 1) * 3];
        double lon = 0.0;
        double lonInc = 360.0 / (double)numSidesForShape;
        int ii = 0;
        for (int jj = 0; jj < numSidesForShape; ++jj) {
            circle[ii++] = 0.0;
            circle[ii++] = lat;
            circle[ii++] = lon;
            if (!((lon += lonInc) > 180.0)) continue;
            lon -= 360.0;
        }
        circle[ii++] = 0.0;
        circle[ii++] = lat;
        circle[ii] = 0.0;
        return circle;
    }

    public static double[] getCircleOfLatitudeECRGeo(double lat, int numSidesForShape) {
        return GeodeticUtil.getCircleOfLatitudeECEFGeo(lat, numSidesForShape);
    }

    private static double[] getCenterOfBoundingBoxECEFGeo(double[] perimeterECEFGeo) {
        int LENGTH = perimeterECEFGeo.length / 3 * 3;
        double xMax = -1.7976931348623157E308;
        double xMin = Double.MAX_VALUE;
        double yMax = -1.7976931348623157E308;
        double yMin = Double.MAX_VALUE;
        double zMax = -1.7976931348623157E308;
        double zMin = Double.MAX_VALUE;
        int ii = 0;
        while (ii < LENGTH) {
            double alt = perimeterECEFGeo[ii++];
            double lat = Math.toRadians(perimeterECEFGeo[ii++]);
            double lon = Math.toRadians(perimeterECEFGeo[ii++]);
            double clat = Math.cos(lat);
            double x = Math.cos(lon) * clat;
            double y = Math.sin(lon) * clat;
            double z = Math.sin(lat);
            xMax = Math.max(x, xMax);
            xMin = Math.min(x, xMin);
            yMax = Math.max(y, yMax);
            yMin = Math.min(y, yMin);
            zMax = Math.max(z, zMax);
            zMin = Math.min(z, zMin);
        }
        double xCenter = (xMax + xMin) / 2.0;
        double yCenter = (yMax + yMin) / 2.0;
        double zCenter = (zMax + zMin) / 2.0;
        double[] centerECRGeo = new double[3];
        centerECRGeo[0] = 0.0;
        if (zCenter >= 1.0) {
            centerECRGeo[1] = 90.0;
            centerECRGeo[2] = 0.0;
        } else if (zCenter <= -1.0) {
            centerECRGeo[1] = -90.0;
            centerECRGeo[2] = 0.0;
        } else if (xCenter == 0.0 && yCenter == 0.0) {
            centerECRGeo[1] = zCenter > 0.0 ? 90.0 : -90.0;
            centerECRGeo[2] = 0.0;
        } else {
            centerECRGeo[1] = Math.toDegrees(Math.asin(zCenter));
            centerECRGeo[2] = Math.toDegrees(Math.atan2(yCenter, xCenter));
        }
        return centerECRGeo;
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> toPositions(ArrayForm format, double[] points) {
        switch (format) {
            case LonLatAlt: {
                ArrayList<Position> pts = new ArrayList<Position>(points.length / 3 + 1);
                for (int i = 0; i < points.length; i += 3) {
                    pts.add(Position.fromGeo(points[i + 2], points[i + 1], points[i]));
                }
                return pts;
            }
            case LonLat: {
                ArrayList<Position> pts = new ArrayList<Position>(points.length / 2 + 1);
                for (int i = 0; i < points.length; i += 2) {
                    pts.add(Position.fromGeo(0.0, points[i + 1], points[i]));
                }
                return pts;
            }
            case LatLonAlt: {
                ArrayList<Position> pts = new ArrayList<Position>(points.length / 3 + 1);
                for (int i = 0; i < points.length; i += 3) {
                    pts.add(Position.fromGeo(points[i + 2], points[i], points[i + 1]));
                }
                return pts;
            }
            case LatLon: {
                ArrayList<Position> pts = new ArrayList<Position>(points.length / 2 + 1);
                for (int i = 0; i < points.length; i += 2) {
                    pts.add(Position.fromGeo(0.0, points[i], points[i + 1]));
                }
                return pts;
            }
            case AltLatLon: {
                ArrayList<Position> pts = new ArrayList<Position>(points.length / 3 + 1);
                for (int i = 0; i < points.length; i += 3) {
                    pts.add(Position.fromGeo(points[i], points[i + 1], points[i + 2]));
                }
                return pts;
            }
        }
        throw new AssertionError((Object)("Invalid format: " + (Object)((Object)format)));
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static double[] toPoints(ArrayForm format, List<Position> points) {
        int j = 0;
        switch (format) {
            case LonLatAlt: {
                double[] pts = new double[points.size() * 3];
                for (Position p : points) {
                    pts[j++] = p.getLon();
                    pts[j++] = p.getLat();
                    pts[j++] = p.getAlt();
                }
                return pts;
            }
            case LonLat: {
                double[] pts = new double[points.size() * 2];
                for (Position p : points) {
                    pts[j++] = p.getLon();
                    pts[j++] = p.getLat();
                }
                return pts;
            }
            case LatLonAlt: {
                double[] pts = new double[points.size() * 3];
                for (Position p : points) {
                    pts[j++] = p.getLat();
                    pts[j++] = p.getLon();
                    pts[j++] = p.getAlt();
                }
                return pts;
            }
            case LatLon: {
                double[] pts = new double[points.size() * 2];
                for (Position p : points) {
                    pts[j++] = p.getLat();
                    pts[j++] = p.getLon();
                }
                return pts;
            }
            case AltLatLon: {
                double[] pts = new double[points.size() * 3];
                for (Position p : points) {
                    pts[j++] = p.getAlt();
                    pts[j++] = p.getLat();
                    pts[j++] = p.getLon();
                }
                return pts;
            }
        }
        throw new AssertionError((Object)("Invalid format: " + (Object)((Object)format)));
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> closeShape(List<Position> pts) {
        if (pts.size() < 3) {
            throw new IllegalArgumentException("Can not create polygon with less than 3 distinct points");
        }
        Position first = pts.get(0);
        Position last = pts.get(pts.size() - 1);
        if (first.getLat() != last.getLat() || first.getLon() != last.getLon() || first.getAlt() != last.getAlt()) {
            pts.add(first);
        }
        if (pts.size() < 4) {
            throw new IllegalArgumentException("Can not create polygon with less than 3 distinct points");
        }
        return pts;
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> computeEllipse(double lon, double lat, double semiMajor, double semiMinor, double tilt, int div) {
        double[] points = GeodeticUtil.computeEllipseLL(lon, lat, semiMajor, semiMinor, 90.0 - tilt, div);
        List<Position> positions = GeodeticUtil.toPositions(ArrayForm.LonLat, points);
        Collections.reverse(positions);
        return GeodeticUtil.closeShape(positions);
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> computeCircle(Position pos, double radius, int div) {
        return GeodeticUtil.computeEllipse(pos.getLon(), pos.getLat(), radius, radius, 0.0, div);
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> computeCircle(double lon, double lat, double radius, int div) {
        return GeodeticUtil.computeEllipse(lon, lat, radius, radius, 0.0, div);
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> computeCone(Position p, Position q, double angle, int div) {
        return GeodeticUtil.computeCone(p, q, angle, div, 0.0, 1);
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static List<Position> computeCone(Position p, Position q, double angle, int div, double range, int mode) {
        double[] points = GeodeticUtil.computeConeLLA(p, q, angle, div, range, mode, true);
        List<Position> positions = GeodeticUtil.toPositions(ArrayForm.LonLatAlt, points);
        return GeodeticUtil.closeShape(positions);
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static double getBeamWidth(double d, double rf) {
        return 1.9300638446040005E10 / rf / d;
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static synchronized ShapeFile getCountryShapeFile() {
        if (countries == null) {
            countries = new ShapeFile(null, (Object)"classpath:nxm/sys/dat/world.shp");
            countries.open(1);
        }
        return countries;
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static void setCountryShapeFile(MidasReference ref, Object fileName) {
        GeodeticUtil.setCountryShapeFile(new ShapeFile(ref, fileName));
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static synchronized void setCountryShapeFile(ShapeFile f) {
        if (f != null && !f.isOpen()) {
            f.open(1);
        }
        countries = f;
    }

    private static List<ShapeFile.Shape> getCountryShape(Position pos, double radius) {
        if (pos.getAlt() >= 100000.0) {
            return Collections.emptyList();
        }
        List<ShapeFile.Shape> shapes = GeodeticUtil.getCountryShapeFile().getShapesContaining(pos);
        if (radius < 0.0) {
            radius = 22200.0;
        }
        if (shapes.isEmpty() && radius > 0.0) {
            shapes = GeodeticUtil.getCountryShapeFile().getShapesNear(pos, radius);
        }
        return shapes;
    }

    public static List<Table> getCountryInfo(double alt, double lat, double lon) {
        return GeodeticUtil.getCountryInfo(Position.fromGeo(alt, lat, lon), -1.0);
    }

    public static List<Table> getCountryInfo(Position pos) {
        return GeodeticUtil.getCountryInfo(pos, -1.0);
    }

    public static List<Table> getCountryInfo(double alt, double lat, double lon, double radius) {
        return GeodeticUtil.getCountryInfo(Position.fromGeo(alt, lat, lon), radius);
    }

    public static List<Table> getCountryInfo(Position pos, double radius) {
        List<ShapeFile.Shape> shapes = GeodeticUtil.getCountryShape(pos, radius);
        ArrayList<Table> info = new ArrayList<Table>(8);
        if (shapes != null) {
            shapes.forEach(s -> {
                if (s != null) {
                    info.add(s.getDataTable());
                }
            });
        }
        return info;
    }

    public static List<String> getCountryInfo(String field, double alt, double lat, double lon) {
        return GeodeticUtil.getCountryInfo(field, Position.fromGeo(alt, lat, lon), -1.0);
    }

    public static List<String> getCountryInfo(String field, Position pos) {
        return GeodeticUtil.getCountryInfo(field, pos, -1.0);
    }

    public static List<String> getCountryInfo(String field, double alt, double lat, double lon, double radius) {
        return GeodeticUtil.getCountryInfo(field, Position.fromGeo(alt, lat, lon), radius);
    }

    public static List<String> getCountryInfo(String field, Position pos, double radius) {
        return GeodeticUtil.getCountryShape(pos, radius).stream().map(s -> s.getDataTable().getS(field)).collect(Collectors.toList());
    }

    @ProvisionalUseOnly(value="Not adequately tested")
    public static double eep2cep(double sig_smaj_95, double sig_smin_95) {
        double sig_smaj_245 = sig_smaj_95 / 2.4477468306808166;
        double sig_smin_245 = sig_smin_95 / 2.4477468306808166;
        double m = Math.pow(sig_smaj_245, 2.0) + Math.pow(sig_smin_245, 2.0);
        double mm9 = 9.0 * m * m;
        double v = 2.0 * (Math.pow(sig_smaj_245, 4.0) + Math.pow(sig_smin_245, 4.0));
        double cep = Math.sqrt(m * Math.pow(1.6447 * Math.sqrt(v / mm9) + (1.0 - v / mm9), 3.0));
        return Double.isNaN(cep) ? 0.0 : cep;
    }

    @InternalUseOnly
    public static double[][][] computeXYZEllipsoidCrossSections(double semiMajor, double semiMinor, double semiMedian, int slices) {
        double sliceJump = 0.4;
        int axes = 3;
        int crossSecDirections = 3;
        boolean x = false;
        boolean y = true;
        int z = 2;
        double[] semi = new double[]{semiMajor, semiMinor, semiMedian};
        double[][][] xyzCrossSections = new double[crossSecDirections][slices][axes];
        xyzCrossSections[0][0] = new double[]{0.0, semiMinor, semiMedian};
        xyzCrossSections[1][0] = new double[]{semiMajor, 0.0, semiMedian};
        xyzCrossSections[2][0] = new double[]{semiMajor, semiMinor, 0.0};
        for (int direction = 0; direction < crossSecDirections; ++direction) {
            int slice = 1;
            int index = 1;
            while (slice < slices / 2 + 1) {
                xyzCrossSections[direction][index] = new double[axes];
                xyzCrossSections[direction][index + 1] = new double[axes];
                double ratio = (double)slice * sliceJump;
                double crossLngth = semi[direction] * ratio;
                for (int axis = 0; axis < axes; ++axis) {
                    if (axis == direction) {
                        xyzCrossSections[direction][index][axis] = crossLngth;
                        xyzCrossSections[direction][index + 1][axis] = -crossLngth;
                        continue;
                    }
                    xyzCrossSections[direction][index][axis] = semi[axis] * Math.sqrt(1.0 - Math.pow(ratio, 2.0));
                    xyzCrossSections[direction][index + 1][axis] = semi[axis] * Math.sqrt(1.0 - Math.pow(ratio, 2.0));
                }
                ++slice;
                index += 2;
            }
        }
        return xyzCrossSections;
    }

    @InternalUseOnly
    public static double[][] getZYXRotationTMatrix(double zRotation, double yRotation, double xRotation) {
        double[][] zyxRotationMatrix = new double[3][3];
        zyxRotationMatrix[0][0] = Math.cos(zRotation) * Math.cos(yRotation);
        zyxRotationMatrix[0][1] = Math.cos(zRotation) * Math.sin(yRotation) * Math.sin(xRotation) - Math.sin(zRotation) * Math.cos(xRotation);
        zyxRotationMatrix[0][2] = Math.cos(zRotation) * Math.sin(yRotation) * Math.cos(xRotation) + Math.sin(zRotation) * Math.sin(xRotation);
        zyxRotationMatrix[1][0] = Math.sin(zRotation) * Math.cos(yRotation);
        zyxRotationMatrix[1][1] = Math.sin(zRotation) * Math.sin(yRotation) * Math.sin(xRotation) + Math.cos(zRotation) * Math.cos(xRotation);
        zyxRotationMatrix[1][2] = Math.sin(zRotation) * Math.sin(yRotation) * Math.cos(xRotation) - Math.cos(zRotation) * Math.sin(xRotation);
        zyxRotationMatrix[2][0] = -Math.sin(yRotation);
        zyxRotationMatrix[2][1] = Math.cos(yRotation) * Math.sin(xRotation);
        zyxRotationMatrix[2][2] = Math.cos(yRotation) * Math.cos(xRotation);
        return zyxRotationMatrix;
    }

    public static void setinsidePolyFix(boolean useFix) {
        insidePolyFix = useFix;
    }

    static {
        insidePolyFix = true;
    }

    public static enum ArrayForm {
        LonLat,
        LonLatAlt,
        LatLon,
        LatLonAlt,
        AltLatLon;

    }
}

