/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.AsciiMap;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;

public class Generate
implements AsciiMap {
    @Deprecated
    public Generate() {
    }

    public static int genExplainFromComments(String fullSourceName, String fullExpName, boolean overWrite) {
        int status = -1;
        FileName fnFullSourceName = new FileName(fullSourceName, FileName.FNCase.KeepCase);
        TextFile tfi = new TextFile(fnFullSourceName);
        if (tfi.open(33)) {
            FileName fnFullExpName = new FileName(fullExpName, FileName.FNCase.KeepCase);
            TextFile tfo = new TextFile(fnFullExpName);
            if (!overWrite && tfo.find(-1)) {
                status = -2;
            } else if (tfo.open(34)) {
                String line;
                boolean foundStart = false;
                boolean foundEnd = false;
                while ((line = tfi.read()) != null) {
                    if (line.trim().startsWith("/**")) {
                        foundStart = true;
                        int iEndComment = line.indexOf("*/");
                        if (iEndComment < 0) continue;
                        tfo.writeln(line.substring(3, line.indexOf("*/")));
                        break;
                    }
                    if (!foundStart) continue;
                    if (line.trim().startsWith("*/")) break;
                    tfo.writeln(line);
                }
                status = 1;
                tfo.close();
            }
            tfi.close();
        }
        return status;
    }

    public static int genExplainFromSource(String fullSourceName, String cmdName, String fullExpName, boolean overWrite, boolean warn) {
        String switchesString = null;
        String tagsString = null;
        String rxMsgString = null;
        String sendMsgString = null;
        int status = -1;
        FileName fnFullSourceName = new FileName(fullSourceName, FileName.FNCase.KeepCase);
        TextFile tfi = new TextFile(fnFullSourceName);
        if (tfi.open(33)) {
            FileName fnFullExpName = new FileName(fullExpName, FileName.FNCase.KeepCase);
            TextFile tfo = new TextFile(fnFullExpName);
            if (!overWrite && tfo.find(-1)) {
                status = -2;
            } else if (tfo.open(34)) {
                String line;
                while ((line = tfi.read()) != null) {
                    String msgstr;
                    String tagName;
                    int iMA = line.indexOf("MA.");
                    int iMSG = line.indexOf("msg.name.equals");
                    int iMSGSend = line.indexOf("MQ.put");
                    if (iMA >= 0) {
                        String mastring = line.substring(iMA);
                        tagName = Generate.getTagNameFromString(mastring);
                        if (tagName == null) {
                            if (warn) {
                                Shell.warning("could not find param tag in string '" + mastring + "'");
                            }
                            tagName = "UNKNOWN";
                        }
                        if (tagName.startsWith("/")) {
                            if (switchesString == null) {
                                switchesString = tagName;
                            } else if (switchesString.indexOf(tagName) < 0) {
                                switchesString = switchesString + "," + tagName;
                            }
                        } else if (tagsString == null) {
                            tagsString = tagName;
                        } else if (tagsString.indexOf(tagName) < 0) {
                            tagsString = tagsString + "," + tagName;
                        }
                    }
                    if (iMSG >= 0) {
                        msgstr = line.substring(iMSG);
                        tagName = Generate.getTagNameFromString(msgstr);
                        if (tagName == null) {
                            if (warn) {
                                Shell.warning("could not find msg tag in string '" + msgstr + "'");
                            }
                            tagName = "UNKNOWN";
                        }
                        if (rxMsgString == null) {
                            rxMsgString = tagName;
                        } else if (rxMsgString.indexOf(tagName + ",") < 0) {
                            rxMsgString = rxMsgString + "," + tagName;
                        }
                    }
                    if (iMSGSend < 0) continue;
                    msgstr = line.substring(iMSGSend);
                    tagName = Generate.getTagNameFromString(msgstr);
                    if (tagName == null) {
                        if (warn) {
                            Shell.warning("could not find msg tag in string '" + msgstr + "'");
                        }
                        tagName = "UNKNOWN";
                    }
                    if (sendMsgString == null) {
                        sendMsgString = tagName;
                        continue;
                    }
                    if (sendMsgString.indexOf(tagName + ",") >= 0) continue;
                    sendMsgString = sendMsgString + "," + tagName;
                }
                String[] tags = StringUtil.cleanSplit(tagsString, ",");
                String[] rxMsgs = StringUtil.cleanSplit(rxMsgString, ",");
                String[] sendMsgs = StringUtil.cleanSplit(sendMsgString, ",");
                String[] switches = StringUtil.cleanSplit(switchesString, ",");
                Generate.makeExpStub(tfo, cmdName, tags, rxMsgs, sendMsgs, switches);
                status = 1;
                tfo.close();
            }
            tfi.close();
        }
        return status;
    }

    public static void makeExpStub(TextFile tfo, String cmdName, String[] tags, String[] rxMsgs, String[] sendMsgs, String[] switches) {
        int i;
        String line = cmdName.toUpperCase() + " - short explanation here";
        tfo.writeln(line);
        if (tags != null && tags.length > 0) {
            line = "";
            tfo.writeln(line);
            for (i = 0; i < tags.length; ++i) {
                line = tags[i].length() < 6 ? "<" + tags[i] + ">\t\t - Tag description" : "<" + tags[i] + ">\t - Tag description";
                tfo.writeln(line);
            }
        }
        line = "";
        tfo.writeln(line);
        line = "Body - Detailed description here";
        tfo.writeln(line);
        if (rxMsgs != null && rxMsgs.length > 0) {
            line = "";
            tfo.writeln(line);
            line = "Messages:";
            tfo.writeln(line);
            line = "  Receive:";
            tfo.writeln(line);
            for (i = 0; i < rxMsgs.length; ++i) {
                line = rxMsgs[i].length() < 6 ? "    " + rxMsgs[i] + "  \t - Msg description" : "    " + rxMsgs[i] + "\t - Msg description";
                tfo.writeln(line);
            }
        }
        if (sendMsgs != null && sendMsgs.length > 0) {
            line = "  Send:";
            tfo.writeln(line);
            for (i = 0; i < sendMsgs.length; ++i) {
                line = sendMsgs[i].length() < 6 ? "    " + sendMsgs[i] + "  \t - Msg description" : "    " + sendMsgs[i] + "\t - Msg description";
                tfo.writeln(line);
            }
        }
        line = "";
        tfo.writeln(line);
        line = "Examples:";
        tfo.writeln(line);
        if (switches != null && switches.length > 0) {
            line = "";
            tfo.writeln(line);
            line = "Switches:";
            tfo.writeln(line);
            for (i = 0; i < switches.length; ++i) {
                line = "  " + switches[i] + " - Switch description";
                tfo.writeln(line);
            }
        }
    }

    public static String getTagNameFromString(String mastring) {
        int iQuote2;
        String betweenParens;
        int iQuote1;
        String tagName = null;
        int iLParen = mastring.indexOf("(");
        int iRParen = mastring.indexOf(")");
        if (iLParen >= 0 && iRParen > iLParen && (iQuote1 = (betweenParens = mastring.substring(iLParen + 1, iRParen)).indexOf("\"")) >= 0 && (iQuote2 = betweenParens.substring(iQuote1 + 1).indexOf(34)) >= 0) {
            tagName = betweenParens.substring(iQuote1 + 1, iQuote2 + 1);
        }
        return tagName;
    }
}

