/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;

public class FileName
implements AsciiMap,
Cloneable {
    private static FNCase defaultFNCase = FNCase.AutoCase;
    private static final Pattern DOT_PATTERN = Pattern.compile("[.]");
    public static final int OS_UNKNOWN = -1;
    public static final int OS_LOCAL = 1;
    public static final int OS_UNIX = 2;
    public static final int OS_DOS = 3;
    public static final int OS_VMS = 4;
    public static final String LOCAL_PATH_DELIM = File.separator;
    public static final String DOS_PATH_DELIM = "\\";
    public static final String UNIX_PATH_DELIM = "/";
    public static final String VMS_PATH_DELIM = ".";
    private String path;
    private String root;
    private String ext;
    private String tag;
    private transient String fullname;
    private String trimmers;
    private String qualifiers;
    private transient Table qualTable;

    public FileName(String filename) {
        this(filename, null);
    }

    public FileName(String inpath, String inroot, String inext) {
        this(inpath, inroot, inext, null);
    }

    public FileName(String[] pathList, String inroot, String inext) {
        this(pathList, inroot, inext, false);
    }

    @InternalUseOnly
    private FileName(String filename, FNCase fnCase, boolean resolve) {
        this.parseName(filename, fnCase, resolve);
    }

    public FileName(String filename, FNCase fnCase) {
        this(filename, fnCase, true);
    }

    public FileName(String inpath, String inroot, String inext, FNCase fnCase) {
        this(FileName.addPathRootExt(inpath, inroot, inext), fnCase);
    }

    public FileName(File file) {
        this(file.toString(), FNCase.KeepCase);
    }

    public FileName(String filename, boolean keepCase) {
        this(filename, keepCase ? FNCase.KeepCase : null);
    }

    public FileName(FileName context, String fname, boolean keepCase) {
        this(context._relativeTo(fname).getFullName(), keepCase);
    }

    public FileName(String inpath, String inroot, String inext, boolean keepCase) {
        this(FileName.addPathRootExt(inpath, inroot, inext), keepCase ? FNCase.KeepCase : null);
    }

    public FileName(String[] pathList, String inroot, String inext, boolean keepCase) {
        FNCase fnCase = keepCase ? FNCase.KeepCase : null;
        boolean isClasspath = pathList[0].equalsIgnoreCase("classpath:");
        int startPos = 0;
        startPos = isClasspath && pathList.length > 1 ? 2 : 1;
        String inpath = pathList[startPos - 1];
        for (int i = startPos; i < pathList.length; ++i) {
            inpath = FileName.addPathDir(inpath, pathList[i]);
        }
        if (isClasspath) {
            URL fileURL = Thread.currentThread().getContextClassLoader().getResource(inpath);
            inpath = fileURL != null ? "jar:" + fileURL.getPath() : pathList[0];
        }
        this.parseName(FileName.addPathRootExt(inpath, inroot, inext), fnCase, true);
    }

    @InternalUseOnly
    @Deprecated
    public void parseName(String filename) {
        this.parseName(filename, false);
    }

    @InternalUseOnly
    @Deprecated
    public void parseName(String filename, boolean keepCase) {
        this.parseName(filename, keepCase ? FNCase.KeepCase : FNCase.AutoCase, true);
    }

    private void reset() {
        this.path = "";
        this.root = "";
        this.ext = "";
        this.tag = "";
        this.fullname = null;
        this.qualifiers = null;
        this.trimmers = null;
        this.qualTable = null;
    }

    @InternalUseOnly
    private void parseName(String filename, FNCase fnCase, boolean resolve) {
        Object fnCaseQual;
        int iBang;
        int iSemi;
        int iTrim;
        int iQual;
        boolean quoted;
        this.reset();
        if (filename == null || filename.isEmpty() || filename.equals("NULL")) {
            return;
        }
        boolean bl = quoted = filename.charAt(0) == '\"';
        if (quoted) {
            int i = filename.lastIndexOf(34);
            if (i <= 0) {
                i = filename.length();
            }
            filename = filename.substring(1, i);
        }
        if ((iQual = FileName.getQualifiersIndex(filename)) >= 0) {
            this.qualifiers = filename.substring(iQual);
            filename = filename.substring(0, iQual);
        }
        if ((iTrim = FileName.getTrimmersIndex(filename)) >= 0) {
            this.trimmers = filename.substring(iTrim);
            filename = filename.substring(0, iTrim);
        }
        if ((iSemi = filename.lastIndexOf(59)) >= 0) {
            filename = filename.substring(0, iSemi);
        }
        int urlSep = filename.indexOf("://");
        int iSlash = filename.lastIndexOf(47);
        if (urlSep > 0 && iSlash < urlSep + 3) {
            iSlash = -1;
        }
        if (iSlash < 0) {
            iSlash = filename.lastIndexOf(92);
        }
        if (iSlash < 0) {
            iSlash = filename.lastIndexOf(93);
        }
        if (iSlash < 0) {
            iSlash = filename.lastIndexOf(58);
        }
        if ((iBang = filename.lastIndexOf(33)) > iSlash) {
            iSlash = iBang;
        }
        if (urlSep > 0 && iSlash < urlSep + 3) {
            iSlash = -1;
        }
        if (iSlash < 0 && urlSep > 0) {
            iSlash = urlSep + 2;
        }
        String filenameLC = filename.toLowerCase();
        int lastDot = filename.lastIndexOf(46);
        if (iSlash < 0 && filenameLC.startsWith("nxm.aux.") && lastDot > 9) {
            Shell.deprecate("Since NeXtMidas 3.3.1: Use of nxm.aux. syntax for files is deprecated (given '" + filename + "'), use AUX= qualifier in place of this.");
            int ii = filename.indexOf(46, 8);
            if (ii > 0) {
                this.path = resolve ? Shell.getAuxPath(filename.substring(8, ii)) : "";
                this.root = lastDot > ii ? filename.substring(ii + 1, lastDot) : filename.substring(lastDot + 1);
                this.ext = lastDot > ii ? filename.substring(lastDot + 1) : "";
            }
        } else if (iSlash < 0 && filenameLC.startsWith("nxm.") && lastDot > 4) {
            String[] parts = DOT_PATTERN.split(filename);
            if (parts.length == 4) {
                parts = Arrays.copyOf(parts, 5);
                parts[4] = "";
            }
            this.path = resolve ? Shell.getOptPath(parts[1], null) : "";
            this.root = parts[parts.length - 2];
            this.ext = parts[parts.length - 1];
            if (resolve) {
                for (int n = 2; n < parts.length - 2; ++n) {
                    String subdir = parts[n].toLowerCase();
                    this.path = FileName.addPathDir(this.path, subdir);
                }
            }
        } else {
            this.path = iSlash >= 0 ? filename.substring(0, iSlash + 1) : "";
            int j = filename.lastIndexOf(46);
            if (j >= 0 && j > iSlash + 1) {
                this.root = filename.substring(iSlash + 1, j);
                this.ext = filename.substring(j + 1);
            } else {
                this.root = filename.substring(iSlash + 1);
                this.ext = "";
            }
        }
        if (this.qualifiers != null) {
            this.qualifiers = Parser.toUpperCaseWithQuotes(this.qualifiers);
        }
        if (this.trimmers != null) {
            this.trimmers = Parser.toUpperCaseWithQuotes(this.trimmers);
        }
        if (this.tag == null || this.tag.isEmpty()) {
            this.tag = this.root.toUpperCase();
        }
        if (fnCase == null) {
            fnCase = FileName.getDefaultFNCase();
        }
        if ((fnCaseQual = this.getQualifier("FNCASE")) != null) {
            fnCase = Util.valueOf(FNCase.class, fnCaseQual.toString());
        } else if (fnCase == FNCase.AutoCase && (quoted || this.path.endsWith("/RPF/"))) {
            fnCase = FNCase.KeepCase;
        }
        switch (fnCase) {
            case LowerCase: {
                this.path = this.path.toLowerCase();
                this.root = this.root.toLowerCase();
                this.ext = this.ext.toLowerCase();
                break;
            }
            case KeepCase: {
                break;
            }
            case AutoCase: {
                this.path = FileName.autoCase(this.path);
                this.root = FileName.autoCase(this.root);
                this.ext = FileName.autoCase(this.ext);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown option " + (Object)((Object)fnCase)));
            }
        }
    }

    private static String autoCase(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c < 'a' || c > 'z') continue;
            return name;
        }
        return name.toLowerCase();
    }

    public String getFullName() {
        if (this.fullname == null) {
            this.fullname = this.path + this.root;
            if (this.ext.length() > 0) {
                this.fullname = this.fullname + VMS_PATH_DELIM + this.ext;
            }
        }
        return this.fullname;
    }

    public String getAllName() {
        String s = this.getFullName();
        if (this.hasTrimmers()) {
            s = s + this.getTrimmers();
        }
        if (this.hasQualifiers()) {
            s = s + this.getQualifiers();
        }
        return s;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
        this.fullname = null;
    }

    public String[] getPathElements() {
        String fname = this.getFullName();
        String delim = UNIX_PATH_DELIM;
        if (fname.indexOf(92) >= 0) {
            delim = DOS_PATH_DELIM;
        }
        return StringUtil.cleanSplit(fname, delim);
    }

    public static String getRoot(String path) {
        if (path == null) {
            return path;
        }
        String root = FileName.getBasename(path);
        int ii = root.lastIndexOf(46);
        if (ii >= 0) {
            root = root.substring(0, ii);
        }
        return root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String value) {
        this.root = value;
        this.fullname = null;
    }

    public static String getExt(String name) {
        if (name == null) {
            return name;
        }
        int pos = name.lastIndexOf(46);
        return pos >= 0 ? name.substring(pos + 1) : "";
    }

    @Deprecated
    public static String getExtLegacy(String name) {
        int pos = name.lastIndexOf(46);
        return pos >= 0 ? name.substring(pos + 1) : null;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String value) {
        this.ext = value;
        this.fullname = null;
    }

    public static String getBasename(String path) {
        int iBang;
        if (path == null) {
            return path;
        }
        String basename = path;
        int ii = path.lastIndexOf(47);
        if (ii < 0) {
            ii = path.lastIndexOf(92);
        }
        if ((iBang = path.lastIndexOf(33)) > ii) {
            ii = iBang;
        }
        if (ii >= 0) {
            basename = path.substring(ii + 1);
        } else if (path.startsWith("nxm.") || path.startsWith("NXM.")) {
            int iLastDot = path.lastIndexOf(46);
            ii = path.lastIndexOf(46, iLastDot - 1);
            if (ii >= 0) {
                basename = path.substring(ii + 1);
            }
            return basename;
        }
        return basename;
    }

    public String getBasename() {
        return this.root + (this.ext != null && this.ext.length() > 0 ? '.' + this.ext : "");
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String value) {
        this.tag = value;
    }

    public boolean hasQualifiers() {
        return !this.getQualifierTable().isEmpty();
    }

    public String getQualifiers() {
        Table quals = this.getQualifierTable();
        return quals.isEmpty() ? null : quals.toString();
    }

    public Table getQualifierTable() {
        if (this.qualTable != null) {
            return this.qualTable;
        }
        if (this.qualifiers == null) {
            this.qualTable = new Table();
            return this.qualTable;
        }
        if (this.qualifiers.charAt(0) == '{') {
            this.qualTable = new Table(this.qualifiers);
        } else if (this.qualifiers.charAt(0) == '(') {
            int i;
            this.qualTable = new Table();
            int pos = 0;
            while ((i = this.qualifiers.indexOf(40, pos)) >= 0) {
                int j = this.qualifiers.indexOf(61, i);
                int k = StringUtil.getClosingFensePos(this.qualifiers, "()", i);
                if (j > i && j < k) {
                    this.qualTable.put(this.qualifiers.substring(i + 1, j), (Object)this.qualifiers.substring(j + 1, k));
                }
                pos = k;
            }
        }
        return this.qualTable;
    }

    public void setQualifiers(String quals) {
        this.qualifiers = quals;
        this.qualTable = null;
    }

    public void setQualifier(String key, Object value) {
        this.getQualifierTable().put(key, value);
        this.qualifiers = null;
    }

    public Object getQualifier(String key) {
        return this.getQualifierTable().get(key);
    }

    public Object getQualifier(String key, Object defValue) {
        return this.getQualifierTable().get(key, defValue);
    }

    public boolean setDefaultQualifier(String key, Object value) {
        return this.getQualifierTable().addIfNotPresent(key, value);
    }

    public boolean setDefaultQualifiers(Map<String, Object> defQualsMap) {
        return this.getQualifierTable().addIfNotPresent(defQualsMap);
    }

    public boolean hasTrimmers() {
        return this.trimmers != null;
    }

    public String getTrimmers() {
        return this.trimmers;
    }

    @InternalUseOnly
    public void append(String filename) {
        int i = FileName.getQualifiersIndex(filename);
        if (i >= 0) {
            Table newQuals = Convert.o2t(filename.substring(i));
            this.getQualifierTable().merge(newQuals);
            filename = filename.substring(0, i);
        }
        if ((i = FileName.getTrimmersIndex(filename)) >= 0) {
            this.trimmers = filename.substring(i);
        }
    }

    @InternalUseOnly
    private String toDebugString() {
        return "FileName\n  Path          : " + this.getPath() + "\n  Root          : " + this.getRoot() + "\n  Ext           : " + this.getExt() + "\n  Full          : " + this.getFullName() + "\n  Trim          : " + this.getTrimmers() + "\n  Tag           : " + this.getTag() + "\n  Qual (String) : " + this.getQualifiers() + "\n  Qual (Table)  : " + this.getQualifierTable();
    }

    @InternalUseOnly
    public void dump() {
        System.out.println(this.toDebugString());
    }

    public String toString() {
        String tmp = this.getFullName();
        if (this.trimmers != null) {
            tmp = tmp + this.trimmers;
        }
        if (this.qualifiers != null) {
            tmp = tmp + this.qualifiers;
        }
        return tmp;
    }

    public String toLocalFileName(int dir) throws MalformedURLException {
        return FileUtil.toLocalFileName(this.toURL(dir));
    }

    public String toLocalFileName() throws MalformedURLException {
        return FileUtil.toLocalFileName(this.toURL());
    }

    public static FileName toFileName(Object obj) {
        FileName fn = obj instanceof FileName ? (FileName)obj : new FileName(Convert.o2s(obj));
        return fn;
    }

    public static URL toURL(Object ref, Object obj, int dir) throws MalformedURLException {
        if (obj instanceof URL) {
            return (URL)obj;
        }
        if (obj instanceof URI) {
            return ((URI)obj).toURL();
        }
        BaseFile bf = new BaseFile(Convert.ref2Midas(ref), obj);
        String url = bf.findResource(dir).getURL();
        URL newURL = null;
        try {
            newURL = new URI(url).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return newURL;
    }

    public URL toURL(int dir) throws MalformedURLException {
        return FileName.toURL(null, this, dir);
    }

    public URL toURL() throws MalformedURLException {
        return this.toURL(0);
    }

    public FileName relativeTo(String name) throws MalformedURLException {
        String retval;
        String context = this.getFullName();
        String[] fields = StringUtil.cleanSplit(name, " ");
        String nmroot = Shell.getNmRoot();
        if (nmroot == null) {
            nmroot = "";
        }
        switch (fields.length) {
            case 2: {
                String _path = FileName.getOptionPath(nmroot, "sys", fields[1]);
                URL newUrl = FileUtil.toURL(_path + fields[0]);
                retval = newUrl.toString();
                break;
            }
            case 3: {
                String _path = FileName.getOptionPath(nmroot, fields[2], fields[1]);
                URL newUrl = FileUtil.toURL(_path + fields[0]);
                retval = newUrl.toString();
                break;
            }
            default: {
                URL newUrl = FileUtil.toURL(context, name);
                retval = newUrl.getFile();
            }
        }
        FileName retfn = new FileName(retval, true);
        String retext = retfn.getExt();
        if (retext == null || retext.isEmpty()) {
            retfn.setExt(this.getExt());
        }
        return retfn;
    }

    private static String convertDOSpath(String path) {
        if (path == null) {
            return null;
        }
        String newPath = FileName.separatorsToSystem(path);
        int indexFirstColon = newPath.indexOf(":");
        if (newPath.contains(UNIX_PATH_DELIM) && indexFirstColon == 1) {
            newPath = "file:/" + newPath;
        }
        return newPath;
    }

    private static String separatorsToSystem(String path) {
        if (path == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return path.replace('\\', '/');
        }
        return path;
    }

    private FileName _relativeTo(String name) {
        try {
            return this.relativeTo(name);
        }
        catch (MalformedURLException e) {
            throw new MidasException("Error getting relative name", e);
        }
    }

    @InternalUseOnly
    public FileName cloneOf() {
        try {
            FileName fn = (FileName)this.clone();
            fn.qualifiers = this.getQualifiers();
            fn.qualTable = null;
            return fn;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Clone of FileName failed");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ext == null ? 0 : this.ext.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.qualifiers == null ? 0 : this.qualifiers.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.trimmers == null ? 0 : this.trimmers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileName other = (FileName)obj;
        if (this.ext == null ? other.ext != null : !this.ext.equals(other.ext)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.qualifiers == null ? other.qualifiers != null : !this.qualifiers.equals(other.qualifiers)) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
            return false;
        }
        return !(this.trimmers == null ? other.trimmers != null : !this.trimmers.equals(other.trimmers));
    }

    public static FNCase getDefaultFNCase() {
        return defaultFNCase;
    }

    public static void setDefaultFNCase(FNCase fnCase) {
        defaultFNCase = fnCase != null ? fnCase : FNCase.AutoCase;
    }

    public static void setDefaultFNCase(String fnCase) {
        String val = Convert.o2s(fnCase);
        if (StringUtil.isNull(val)) {
            FileName.setDefaultFNCase((FNCase)null);
        } else {
            FileName.setDefaultFNCase(Util.valueOf(FNCase.class, val));
        }
    }

    public static FileName getFileName(String opt, String area, String name, String ext, FNCase fnCase) {
        String path = opt.equalsIgnoreCase("AUX") ? Shell.getAuxPath(area) : Shell.getOptPath(opt, area);
        return new FileName(path, name, ext, fnCase);
    }

    public static String terminatePath(String inpath) {
        return FileUtil.terminatePath(inpath);
    }

    private static int[] getQualIndex(String url) {
        if (url == null) {
            return null;
        }
        if ((url = StringUtil.rtrim(url)).length() == 0) {
            return null;
        }
        if (!url.endsWith("}") && !url.endsWith(")")) {
            return null;
        }
        int end = url.length();
        int index = -1;
        while (url.length() > 0) {
            int i = -1;
            if (url.endsWith("}")) {
                i = StringUtil.getOpeningFensePos(url, "{}", url.length() - 1);
            } else if (url.endsWith(")") && (i = url.lastIndexOf(40)) > 0 && url.substring(i).indexOf(61) < 0) {
                i = -1;
            }
            if (i < 0) break;
            index = i;
            url = url.substring(0, i);
        }
        return new int[]{index, end};
    }

    public static int getQualifiersIndex(String url) {
        int[] index = FileName.getQualIndex(url);
        return index == null ? -1 : index[0];
    }

    public static String getQualifierString(String url) {
        int[] index = FileName.getQualIndex(url);
        return index == null ? null : url.substring(index[0], index[1]);
    }

    public static int getTrimmersIndex(String url) {
        int index = FileName.getQualifiersIndex(url = StringUtil.rtrim(url));
        if (index > 0) {
            url = url.substring(0, index);
        }
        if (!url.endsWith(")")) {
            return -1;
        }
        int i = url.lastIndexOf(40);
        if (i > 0 && url.substring(i).indexOf(58) < 0) {
            i = -1;
        }
        return i;
    }

    public static String getOptionPath(String rootpath, String opt, String area) {
        if (rootpath == null) {
            throw new IllegalArgumentException("rootpath cannot be null!");
        }
        String path = FileName.addPathDir(rootpath, "nxm");
        if (opt != null) {
            path = FileName.addPathDir(path, opt.toLowerCase());
        }
        if (area != null) {
            path = FileName.addPathDir(path, area.toLowerCase());
        }
        return path;
    }

    public static String addPathDir(String path, String dir) {
        if (dir == null || dir.length() == 0) {
            return path;
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null!");
        }
        int lp = path.length();
        if (lp == 0) {
            throw new IllegalArgumentException("path cannot be blank!");
        }
        char term = path.charAt(lp - 1);
        path = term == '/' ? path + dir + '/' : (term == ']' ? path.substring(0, lp - 1) + '.' + dir + ']' : (term == '\\' ? path + dir + '\\' : (path.indexOf(92) >= 0 ? path + '\\' + dir + '\\' : path + '/' + dir + '/')));
        return path;
    }

    public static String addPathRoot(String path, String root) {
        if (root == null || root.length() == 0) {
            return path;
        }
        int lp = path.length();
        if (lp == 0) {
            return root;
        }
        char term = path.charAt(lp - 1);
        path = term == '/' ? path + root : (term == ']' ? path + root : (term == '\\' ? path + root : (path.indexOf(92) >= 0 ? path + '\\' + root : path + '/' + root)));
        return path;
    }

    public static String addPathExt(String path, String ext) {
        if (ext == null || ext.length() == 0) {
            return path;
        }
        return path + '.' + ext;
    }

    public static String addPathRootExt(String path, String root, String ext) {
        return FileName.addPathExt(FileName.addPathRoot(path, root), ext);
    }

    public static enum FNCase {
        LowerCase,
        KeepCase,
        AutoCase;

    }
}

