/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Dictionary {
    public String[] entry = new String[1024];
    public int size = 0;
    public Table hotlist;
    private int[] alpha = new int[27];
    private int inc = 128;

    public Dictionary() {
        this.hotlist = new Table();
    }

    public void append(String string) {
        if (this.size >= this.entry.length) {
            this.expand(this.inc);
        }
        this.entry[this.size++] = string;
    }

    public int place(String string) {
        int lena = string.indexOf(59);
        String tmpa = string.substring(0, lena);
        for (int i = 0; i < this.size; ++i) {
            String tmpb = this.entry[i];
            int lenb = tmpb.indexOf(59);
            if ((tmpb = tmpb.substring(0, lenb)).compareTo(tmpa) < 0) continue;
            return i;
        }
        return this.size;
    }

    public void insert(String string, int desiredIndex) {
        String cmdName = string.substring(0, string.indexOf(58) + 1);
        if (desiredIndex >= this.entry.length) {
            this.expand(this.inc);
        }
        if (this.entry == null || this.entry[desiredIndex] == null || !this.entry[desiredIndex].startsWith(cmdName)) {
            if (this.size >= this.entry.length) {
                this.expand(this.inc);
            }
            for (int i = this.size; i > desiredIndex; --i) {
                this.entry[i] = this.entry[i - 1];
            }
            ++this.size;
        }
        if (desiredIndex == this.size) {
            ++this.size;
        }
        this.entry[desiredIndex] = string;
    }

    public void insert(String string) {
        int desiredIndex = this.place(string);
        this.insert(string, desiredIndex);
    }

    public void expand(int inc) {
        int newlen = this.entry.length + inc;
        String[] newentry = new String[newlen];
        for (int i = 0; i < this.size; ++i) {
            newentry[i] = this.entry[i];
        }
        this.entry = newentry;
    }

    public void clear() {
        this.hotlist.clear();
        this.size = 0;
    }

    public static String[] findPercentMacros(Midas midas) {
        String homepath = midas.getResults().getS("AUX.HOMEPATH");
        Object[] files = midas.io.listFiles(homepath, "*", "mm");
        if (files == null) {
            files = StringUtil.EMPTY_STRING_ARRAY;
            midas.warning("Unable to find percent macros at invalid HOMEPATH: " + homepath);
        } else {
            for (int i = 0; i < files.length; ++i) {
                files[i] = "%" + ((String)files[i]).substring(0, ((String)files[i]).indexOf(".mm")).toUpperCase();
            }
            Arrays.sort(files);
        }
        return files;
    }

    List<String> findMatches(Midas midas, String match) {
        ArrayList<String> matches = new ArrayList<String>();
        if (match.startsWith("%")) {
            String[] macros = Dictionary.findPercentMacros(midas);
            for (int i = 0; i < macros.length; ++i) {
                if (!macros[i].startsWith(match)) continue;
                matches.add(macros[i]);
            }
        } else {
            int len = match.length();
            if (len <= 0) {
                return matches;
            }
            int ia = match.charAt(0) - 65;
            if (ia < 0 || ia > 25) {
                return matches;
            }
            for (int i = this.alpha[ia]; i < this.alpha[ia + 1]; ++i) {
                int lgth = this.entry[i].indexOf(58);
                if (!this.entry[i].startsWith(match) || lgth <= 0) continue;
                matches.add(this.entry[i].substring(0, lgth));
            }
        }
        return matches;
    }

    public int findMatch(String match) {
        int len = match.length();
        if (len <= 0) {
            return -1;
        }
        int ia = match.charAt(0) - 65;
        if (ia < 0 || ia > 25) {
            return -1;
        }
        for (int i = this.alpha[ia]; i < this.alpha[ia + 1]; ++i) {
            if (!this.entry[i].startsWith(match)) continue;
            int i2 = this.entry[i].indexOf(44);
            int i1 = this.entry[i].indexOf(58);
            int la = Integer.valueOf(this.entry[i].substring(i1 + 1, i2));
            if (len < la) continue;
            return i;
        }
        return -1;
    }

    @InternalUseOnly
    public boolean isDictionaryEntry(String match) {
        int len = match.length();
        if (len <= 0) {
            return false;
        }
        int ia = match.charAt(0) - 65;
        if (ia < 0 || ia > 25) {
            return false;
        }
        for (int i = this.alpha[ia]; i < this.alpha[ia + 1]; ++i) {
            int lengthCmdName;
            if (!this.entry[i].startsWith(match) || (lengthCmdName = this.entry[i].indexOf(";")) != len) continue;
            return true;
        }
        return false;
    }

    public Parser findParser(String match) {
        Object obj = this.hotlist.get(match);
        if (obj != null) {
            return (Parser)obj;
        }
        int i = this.findMatch(match);
        if (i < 0) {
            return null;
        }
        Parser parser = new Parser(this.entry[i]);
        this.hotlist.put(match, (Object)parser);
        return parser;
    }

    public String findName(String match) {
        Parser parser = this.findParser(match);
        if (parser == null) {
            return null;
        }
        String name = parser.get(1);
        int i = name.indexOf(59);
        name = name.substring(0, i);
        return name;
    }

    public final String get(int i) {
        return this.entry[i];
    }

    public final Table getEntry(int i) {
        Table tbl = new Table();
        String entry = this.get(i);
        Parser parser = new Parser(entry);
        String nameOptAbbr = parser.get(1);
        int indexColon = nameOptAbbr.indexOf(58);
        int indexSemi = nameOptAbbr.indexOf(59);
        int abbrLen = Convert.s2l(nameOptAbbr.substring(indexColon + 1));
        String name = nameOptAbbr.substring(0, indexSemi);
        String abbr = nameOptAbbr.substring(0, abbrLen);
        tbl.put("NAME", (Object)name);
        tbl.put("OPT", (Object)nameOptAbbr.substring(indexSemi + 1, indexColon));
        tbl.put("ABBR", (Object)abbr);
        tbl.put("CMD", (Object)(abbr + "*" + name.substring(abbrLen)));
        tbl.put("SUP", (Object)parser.get(2));
        tbl.put("NARGS", (Object)parser.get(3));
        int arg = 1;
        while (arg + 3 <= parser.elements()) {
            tbl.put("DEF" + arg, (Object)parser.get(arg + 3));
            ++arg;
        }
        return tbl;
    }

    public final String getSyntax(String name) {
        int iname = this.findMatch(name);
        String syntax = null;
        if (iname >= 0) {
            String entry = this.get(iname);
            Parser parser = new Parser(entry);
            String nameOptAbbr = parser.get(1);
            int indexColon = nameOptAbbr.indexOf(58);
            String nargs = parser.get(3);
            syntax = nameOptAbbr.substring(0, indexColon);
            int arg = 1;
            while (arg + 3 <= parser.elements()) {
                String param = parser.get(arg + 3);
                int eq = param.indexOf("=");
                syntax = eq < 0 ? syntax + " <P" + arg + ">" : syntax + " <" + param.substring(0, eq) + ">";
                ++arg;
            }
            if (nargs.indexOf("+") > 0) {
                syntax = syntax + " ...";
            }
        }
        return syntax;
    }

    public final int getSize() {
        return this.size;
    }

    public void genAlpha() {
        int ia;
        for (ia = 0; ia < 27; ++ia) {
            this.alpha[ia] = this.size;
        }
        for (int i = 0; i < this.size; ++i) {
            ia = this.entry[i].charAt(0) - 65;
            if (ia < 0 || ia > 26 || i >= this.alpha[ia]) continue;
            this.alpha[ia] = i;
        }
        for (ia = 25; ia >= 0; --ia) {
            if (this.alpha[ia] != this.size) continue;
            this.alpha[ia] = this.alpha[ia + 1];
        }
    }

    public void fromArray(String[] entry) {
        this.entry = entry;
        this.size = 0;
        while (this.size < entry.length && entry[this.size] != null) {
            ++this.size;
        }
        this.genAlpha();
    }

    public String getList() {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.entry[i]);
            sb.append("\n");
        }
        return sb.toString();
    }
}

