/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.ArrayList;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class Timelineisvalid
extends Intrinsic {
    private DataFile inFile;
    private DataFile outFile;
    private TextFile csvFile;
    private TextFile reportFile;
    private String resultsName;
    private boolean making5000;
    private boolean makingCSV;
    private boolean makingReport;
    private boolean validTimeline;
    private Data outData;
    private String rframe = "ECR";
    private double tdelta;
    private double bpe;
    private double tolr;
    private double size;
    private long offset;
    private int correctFirstOffset;
    private ArrayList<Double> offsets;
    private ArrayList<Time> times;
    private ArrayList<String> timeStrings;
    private static final String BASE_SAMPLE_NAME = "TCSAMPLE_";
    private static final String BASE_TC_WHOLE = "TC_WHOLE_";
    private static final String BASE_TC_FRAC = "TC_FRAC_";
    private static final String DEFAULT_RES_NAME = "TL_VALIDATOR_RESULT";
    private static final int DECIMAL_PLACES = 12;
    private static final char timeStrMode = '4';
    private static final char expTimeStrMode = '4';
    private static final char nameMode = '4';
    private static final char noteMode = '6';
    private static final char textType = 'A';

    @Override
    public int open() {
        this.offsets = new ArrayList();
        this.times = new ArrayList();
        this.timeStrings = new ArrayList();
        this.validTimeline = true;
        this.inFile = this.MA.getDataFile("IN");
        this.inFile.open();
        Time startTime = this.inFile.getTimeAtStart();
        this.tdelta = this.inFile.getDelta();
        this.bpe = this.inFile.getBPE();
        int offNum = 1;
        Keywords kw = this.inFile.getKeywordsObject();
        Object offObj = kw.get(BASE_SAMPLE_NAME + offNum);
        if (offObj != null) {
            this.tolr = 2.5E-10;
            this.correctFirstOffset = 1;
            while (offObj != null) {
                String wholeKey = BASE_TC_WHOLE + offNum;
                Object wholeObj = kw.get(wholeKey);
                String fracKey = BASE_TC_FRAC + offNum;
                Object fracObj = kw.get(fracKey);
                double offset = Double.valueOf(offObj.toString());
                double whole = Double.valueOf(wholeObj.toString());
                double frac = Double.valueOf(fracObj.toString());
                Time offsetTime = new Time(whole, frac);
                this.offsets.add(offset);
                this.times.add(offsetTime);
                this.timeStrings.add(offsetTime.toString("STD", 12));
                offObj = this.inFile.getKeyWord(BASE_SAMPLE_NAME + ++offNum);
            }
        } else {
            Data tld = (Data)kw.get("TIMELINE");
            this.correctFirstOffset = 0;
            if (tld != null) {
                int j = 0;
                this.tdelta = tld.getD(j++);
                this.tolr = tld.getD(j++);
                int size = (tld.size * tld.spa - 2) / 2;
                for (int i = 0; i < size; ++i) {
                    double byteOff = tld.getD(j++);
                    double elemOff = byteOff / this.bpe;
                    this.offsets.add(elemOff);
                    double dtime = tld.getD(j++);
                    Time offsetTime = new Time(dtime);
                    this.times.add(offsetTime);
                    this.timeStrings.add(offsetTime.toString("STD", 12));
                }
            }
        }
        this.making5000 = this.MA.find("OUT");
        if (this.making5000) {
            int size = offNum - 1;
            this.outFile = this.MA.getDataFile("OUT");
            this.outFile.setComponents("POS/VD/6/5,ENTRY/SL/0/0,ELEM/SD/0/0,TIME/SD/0/0,TIMESTR/4A/0/0,EXP_TIME/SD/0/0,EXP_TIMESTR/4A/0/0,ACT_TDELTA/SD/0/0,FILE_TDELTA/SD/0/0,TOLR/SD/0/0,NAME/4A/0/0,NOTE/6A/0/0");
            this.outFile.setSize(size);
            this.outFile.open(2);
            this.outFile.setTime(startTime);
            this.outFile.setDelta(this.tdelta);
            this.outFile.setReferenceFrame(this.rframe);
            this.outData = this.outFile.getDataBuffer(1);
        }
        this.makingCSV = this.MA.find("CSVOUT");
        if (this.makingCSV) {
            String csvName = this.MA.getCS("CSVOUT");
            if (csvName.indexOf(46) == -1) {
                csvName = csvName + ".csv";
            }
            this.csvFile = new TextFile(this.M, (Object)csvName);
            this.csvFile.open(2);
            this.csvFile.writeln("ENTRY,ELEM,TIME,TIMESTR,EXP_TIME,EXP_TIMESTR,ACT_TDELTA,FILE_TDELTA,TOLR,NAME,NOTE");
        }
        this.makingReport = this.MA.find("REPORT");
        if (this.makingReport) {
            this.reportFile = this.MA.getTextFile("REPORT");
            this.reportFile.open(2);
            this.reportFile.writeln("Timeline Keywords Report for " + this.inFile.fn);
            if (!this.offsets.isEmpty() && this.offsets.get(0) > (double)this.correctFirstOffset) {
                this.validTimeline = false;
                this.reportFile.writeln("");
                if (this.correctFirstOffset == 1) {
                    this.reportFile.writeln("BAD INITIAL OFFSET: TCSAMPLE_1 should always be 1, but was " + this.offsets.get(0));
                } else {
                    this.reportFile.writeln("BAD INITIAL OFFSET: TIMELINE(2) should always be 0, but was " + this.offsets.get(0));
                }
                this.reportFile.writeln("This indicates a wrapped timeline. Time hacks were lost and only the last ones remain.");
                this.reportFile.writeln("This gives the file a 'start time' of 0, even though 'abscissa start' indicates a start time of " + Time.toString(this.inFile.getStart(), "STD", 12));
                double effectiveDelta = this.calcEffectiveDelta(0);
                String tdeltaMsg = "    file header tdelta:" + this.tdelta + ", effective tdelta to first TC entry:" + effectiveDelta;
                if (this.inFile.isAutoCorrectEnabled()) {
                    this.reportFile.writeln("Auto-correction is currently on, so the first element will be assigned the abscissa start value");
                } else {
                    this.reportFile.writeln("Auto-correction is currently off, so all the elements up to the first time hack will be assigned a time of 0");
                    this.reportFile.writeln("Turn off CoreIO.IOOptionsDisableTimeLineAutoCorrectNoOffset0 to enable auto-correct");
                }
                this.reportFile.writeln(tdeltaMsg);
            }
        }
        this.resultsName = this.MA.getS("RESULT", DEFAULT_RES_NAME);
        if (this.resultsName.trim().isEmpty()) {
            this.resultsName = DEFAULT_RES_NAME;
        }
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        double lastOffset = 0.0;
        Time lastTime = new Time(0.0);
        int timeStrLen = Data.getBPA("4A");
        int expTimeStrLen = Data.getBPA("4A");
        int nameLen = Data.getBPA("4A");
        int noteLen = Data.getBPA("6A");
        for (int i = 0; i < this.offsets.size(); ++i) {
            double thisOffset = this.offsets.get(i);
            Time thisTime = this.times.get(i);
            boolean badOffset = thisOffset < lastOffset;
            boolean badTime = thisTime.compareTo(lastTime) < 0;
            boolean badEntry = badOffset || badTime;
            int entry = i + 1;
            double elem = thisOffset;
            double time = thisTime.getSec();
            String timeStr = this.timeStrings.get(i);
            Time expectedTime = this.calcExpectedTime(i);
            String expTimeStr = expectedTime.toString(12);
            double effectiveDelta = this.calcEffectiveDelta(i);
            String name = this.timeStrings.get(i);
            String note = !Double.valueOf(effectiveDelta).equals(Double.NaN) ? "TC based tdelta:" + effectiveDelta : "Header tdelta:" + this.tdelta;
            this.validTimeline &= !badEntry;
            if (this.makingReport && badEntry) {
                this.reportFile.writeln("");
                this.reportFile.writeln("INVALID TC ENTRY " + (i + 2) + " : Byte offsets and sample times must be >= previous entry");
                this.reportFile.writeln("    offset[" + (i + 1) + "]:" + lastOffset + " time[" + i + "]" + lastTime);
                this.reportFile.writeln("    offset[" + (i + 2) + "]:" + thisOffset + " time[" + (i + 1) + "]" + thisTime);
                if (badOffset) {
                    this.reportFile.writeln("    INVALID OFFSET");
                }
                if (badTime) {
                    this.reportFile.writeln("    INVALID TIME");
                }
            }
            if (this.making5000) {
                this.outData.packD(0, entry);
                this.outData.packD(8, elem);
                this.outData.packD(16, time);
                this.outData.packL(24, entry);
                this.outData.packD(28, elem);
                this.outData.packD(36, time);
                this.outData.packS(44, timeStrLen, timeStr);
                this.outData.packD(76, expectedTime.getSec());
                this.outData.packS(84, expTimeStrLen, expTimeStr);
                this.outData.packD(116, effectiveDelta);
                this.outData.packD(124, this.tdelta);
                this.outData.packD(132, this.tolr);
                this.outData.packS(140, nameLen, name);
                this.outData.packS(172, noteLen, note);
                this.outFile.write(this.outData);
            }
            if (this.makingCSV) {
                this.csvFile.write("" + (i + 1) + ",");
                this.csvFile.write("" + thisOffset + ",");
                this.csvFile.write("" + thisTime.getSec() + ",");
                this.csvFile.write("" + this.timeStrings.get(i) + ",");
                this.csvFile.write("" + expectedTime.getSec() + ",");
                this.csvFile.write("" + expectedTime.toString(12) + ",");
                this.csvFile.write("" + effectiveDelta + ",");
                this.csvFile.write("" + this.tdelta + ",");
                this.csvFile.write("" + this.tolr + ",");
                this.csvFile.write("" + name + ",");
                this.csvFile.writeln("\"" + note + "\"");
            }
            lastOffset = thisOffset;
            ++this.offset;
        }
        return (double)this.offset < this.size ? status : 9;
    }

    private Time calcExpectedTime(int index) {
        Time expectedTime = this.times.get(index);
        if (index == 0) {
            if (this.offsets.get(0) > (double)this.correctFirstOffset) {
                double expectedElapsedTime = (this.offsets.get(index) - (double)this.correctFirstOffset) * this.tdelta;
                expectedTime = Time.add(this.inFile.getStart(), expectedElapsedTime);
            }
        } else {
            double expectedElapsedTime = (this.offsets.get(index) - this.offsets.get(index - 1)) * this.tdelta;
            expectedTime = Time.add(this.times.get(index - 1), expectedElapsedTime);
        }
        return expectedTime;
    }

    private double calcEffectiveDelta(int index) {
        double effectiveDelta = this.tdelta;
        if (index == 0) {
            if (this.offsets.get(0) > (double)this.correctFirstOffset) {
                effectiveDelta = (this.times.get(index).getSec() - this.inFile.getStart()) / (this.offsets.get(0) - (double)this.correctFirstOffset);
            }
        } else {
            effectiveDelta = this.times.get(index).diff(this.times.get(index - 1)) / (this.offsets.get(index) - this.offsets.get(index - 1));
        }
        return effectiveDelta;
    }

    @Override
    public int close() {
        if (this.inFile != null) {
            this.inFile.close();
        }
        if (this.outFile != null) {
            this.outFile.close();
        }
        if (this.csvFile != null) {
            this.csvFile.close();
        }
        if (this.reportFile != null) {
            if (this.validTimeline) {
                this.reportFile.writeln("PASSED TIMELINE VERIFICATION CHECK");
            }
            this.reportFile.close();
        }
        this.MR.putx(this.resultsName, this.validTimeline);
        return 0;
    }

    public static String getCSVColumnNames() {
        return "COLUMNNAMES=\"L:ENTRY,D:ELEM,D:TIME,TIMESTR,D:EXP_TIME,EXP_TIMESTR,D:ACT_TDELTA,D:FILE_TDELTA,D:TOLR,NAME,NOTE\"";
    }
}

