/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Command;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Dictionary;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;

public class Menu
extends Intrinsic {
    private static final int COLUMN_WIDTH = 26;
    private static final String actList = "LIST,PREFER,ENABLE,DISABLE";
    private static final int LIST = 1;
    private static final int PREFER = 2;
    private static final int ENABLE = 3;
    private static final int DISABLE = 4;
    private DataFile df;
    private Data db;
    private boolean showOption = true;
    private int act;
    private String names;
    private String supports;
    private String options;

    @Override
    public int process() {
        this.act = this.MA.getSelectionIndex("FUNC", actList, 1);
        this.names = this.MA.getU("NAME");
        this.supports = this.MA.getU("SUP");
        this.options = this.MA.getU("OPT");
        this.showOption = this.MA.getState("/OPT", this.showOption);
        if (this.MA.find("/F")) {
            this.showOption = this.MA.getState("/OPT", false);
            FileName filename = this.MA.getFileName("/F", "menu.tmp", "menu.tmp");
            String format = this.MA.getFormat("/FORMAT", "XA", "#A");
            this.df = new DataFile(this.M, (Object)filename, "1000", format, 0);
            this.df.open(2);
            this.db = this.df.getDataBuffer(1);
            if (this.verbose) {
                this.M.info(" ... writing to " + this.df.getURL());
            }
        } else {
            this.M.terminal.more(1);
        }
        if (this.names.equals("ALL")) {
            this.names = "*";
        }
        if (this.supports.equals("ALL")) {
            this.supports = "*";
        }
        if (this.options.equals("ALL")) {
            this.options = "*";
        }
        for (int i = 0; i < this.M.dictionary.getSize(); ++i) {
            Parser command = new Parser(this.M.dictionary.get(i));
            String name = command.get(1);
            int lname = name.indexOf(59);
            int lendName = name.indexOf(58);
            if (lendName < 0) {
                lendName = name.length();
            }
            this.processCommand(name.substring(0, lname), name.substring(lname + 1, lendName), command.get(2));
        }
        if (this.supports.equals("*") || StringUtil.containsCommonCharacter(this.supports, "%")) {
            String[] percentMacros;
            for (String percentMacro : percentMacros = Dictionary.findPercentMacros(this.M)) {
                this.processCommand(percentMacro, null, "%");
            }
        }
        if (this.df != null) {
            this.df.close();
        } else {
            this.M.terminal.more(9);
        }
        return 9;
    }

    private void processCommand(String name, String option, String support) {
        int width = 26;
        if (!this.supports.equals("*") && !StringUtil.containsCommonCharacter(this.supports, support)) {
            return;
        }
        if (!this.options.equals("*") && option != null && !this.options.equals(option)) {
            return;
        }
        if (!Menu.matchName(this.names + "*", name)) {
            return;
        }
        switch (this.act) {
            case 1: {
                String cmdName;
                boolean showOpt = this.showOption && option != null && !option.equalsIgnoreCase("SYS");
                String string = cmdName = showOpt ? name + ";" + option : name;
                if (this.df != null) {
                    this.db.fromString(cmdName);
                    this.df.write(this.db);
                    break;
                }
                this.M.more(" " + cmdName + "-" + support, width);
                break;
            }
            case 2: {
                this.M.warning("MENU: Support for FUNC=PREFER not implemented.");
                break;
            }
            case 3: {
                this.M.warning("MENU: Support for FUNC=ENABLE not implemented.");
                break;
            }
            case 4: {
                this.M.warning("MENU: Support for FUNC=DISABLE not implemented.");
            }
        }
    }

    private static boolean matchName(String pattern, String name) {
        if (!pattern.startsWith("%") && name.startsWith("%")) {
            name = name.substring(1);
        }
        return StringUtil.isWildcardMatch(pattern, name);
    }

    public static String[] getCommands(Midas midas, String names, String supports, String options, boolean showOption, boolean showSupport) {
        return Command.getMenuCommands(midas, names, supports, options, showOption, showSupport);
    }
}

