/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.libg.Theme;

public final class Lookandfeel
extends Intrinsic {
    private int currentStatus;
    private PlafChooser plafChooser;

    @Override
    public int open() {
        this.currentStatus = -1;
        String lookAndFeel = this.MA.getS("LAF", "").trim();
        if (!this.MA.getState("/GUI")) {
            if (lookAndFeel.trim().length() == 0) {
                String[] themeNames = Theme.getThemeNames();
                this.M.type("Current Theme:     " + Theme.getGlobalTheme());
                this.M.type("Available Themes:");
                for (String themeName : themeNames) {
                    String description = Theme.getTheme(themeName).getDescr();
                    this.M.type("  " + StringUtil.padRight(themeName, 10) + " - " + description);
                }
                return 9;
            }
            this.setLookAndFeel(lookAndFeel);
            return 9;
        }
        this.pollTime = this.args.getD("/POLL", 0.25);
        Theme.initialize();
        this.plafChooser = new PlafChooser();
        this.plafChooser.setVisible(true);
        return 0;
    }

    @Override
    public int process() {
        return this.currentStatus;
    }

    private void setLookAndFeel(String name) {
        try {
            Theme.setGlobalTheme(name);
            if (this.MA.getState("/GUI")) {
                this.plafChooser.setThemeColorPanel();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new MidasException("The '" + name + "' Look & Feel is not supported on this platform.");
        }
        catch (Exception e) {
            throw new MidasException("Unable to set Look & Feel to '" + name + "': " + e);
        }
    }

    private class PlafChooser
    extends JFrame
    implements ActionListener,
    WindowListener {
        private ArrayList<String> warnings;
        private JButton doneBtn;
        private JButton jButton2;
        private JCheckBox jCheckBox1;
        private JComboBox jComboBox2;
        private JLabel jLabel1;
        private JPanel jPanel0;
        private JPanel samplejPanel;
        private JRadioButton jRadioButton1;
        private JTextField jTextField1;
        private JComboBox lookAndFeels;
        private ThemeColorTypeJPanel themeColor_cbg;
        private ThemeColorTypeJPanel themeColor_cfg;
        private ThemeColorTypeJPanel themeColor_cwbg;
        private ThemeColorTypeJPanel themeColor_cwfg;
        private ThemeColorTypeJPanel themeColor_cwti;
        private ThemeColorTypeJPanel themeColor_cwfh;
        private ThemeColorTypeJPanel themeColor_cwbh;
        private ThemeColorTypeJPanel themeColor_cwts;
        private ThemeColorTypeJPanel themeColor_cwbs;
        private ThemeColorTypeJPanel themeColor_cwms;
        private ThemeColorTypeJPanel themeColor_cbgx;
        private JPanel themeColorJPanel;
        private JTextArea twLabel;
        private JPanel warningJPanel;

        public PlafChooser() {
            super("Choose a Look & Feel");
            this.warnings = new ArrayList();
            this.warnings.clear();
            this.initComponents();
            this.checkVisibilityTollerance();
            this.lookAndFeels.setModel(new DefaultComboBoxModel<String>(Theme.getThemeNames()));
            this.lookAndFeels.addActionListener(this);
            this.doneBtn.addActionListener(this);
            this.addWindowListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.lookAndFeels) {
                String lookAndFeel = this.lookAndFeels.getSelectedItem().toString();
                try {
                    this.warnings.clear();
                    this.twLabel.setText("");
                    Lookandfeel.this.setLookAndFeel(lookAndFeel);
                    this.checkVisibilityTollerance();
                    SwingUtilities.updateComponentTreeUI(this);
                    this.pack();
                }
                catch (Exception e) {
                    String msg = "Error setting Look & Feel: " + e;
                    Lookandfeel.this.M.warnStackTrace("Error setting Look & Feel " + lookAndFeel, e);
                    JOptionPane.showMessageDialog(this, msg, "Error", 0);
                }
            } else if (evt.getSource() == this.doneBtn) {
                this.setVisible(false);
                this.dispose();
                Lookandfeel.this.currentStatus = 9;
            }
        }

        public void setThemeColorPanel() {
            Theme gblTheme = (Theme)Theme.getTheme(Theme.getGlobalTheme());
            this.themeColor_cbg.updateColor(gblTheme.cbg);
            this.themeColor_cfg.updateColor(gblTheme.cfg);
            this.themeColor_cwbg.updateColor(gblTheme.cwbg);
            this.themeColor_cwfg.updateColor(gblTheme.cwfg);
            this.themeColor_cwti.updateColor(gblTheme.cwti);
            this.themeColor_cwfh.updateColor(gblTheme.cwfh);
            this.themeColor_cwbh.updateColor(gblTheme.cwbh);
            this.themeColor_cwts.updateColor(gblTheme.cwts);
            this.themeColor_cwbs.updateColor(gblTheme.cwbs);
            this.themeColor_cwms.updateColor(gblTheme.cwms);
            this.themeColor_cbgx.updateColor(gblTheme.cbgx);
        }

        private void checkVisibilityTollerance() {
            Theme curTheme = (Theme)Theme.getTheme(Theme.getGlobalTheme());
            List<String> themeWarnings = curTheme.warnThemeColorVisibility(Lookandfeel.this.M, true);
            for (String warning : themeWarnings) {
                this.addWarning(warning);
            }
        }

        private void addWarning(String newWarning) {
            this.warnings.add(newWarning);
            StringBuilder sb = new StringBuilder();
            for (String warning : this.warnings) {
                sb.append(warning + "\n");
            }
            if (this.twLabel != null) {
                this.twLabel.setText(sb.toString());
            }
        }

        private void initComponents() {
            this.getContentPane().setPreferredSize(new Dimension(400, 620));
            this.jPanel0 = new JPanel();
            this.jPanel0.setBounds(new Rectangle(2, 2, 324, 40));
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(0, 0, 110, 30);
            this.lookAndFeels = new JComboBox();
            this.lookAndFeels.setBounds(110, 0, 210, 30);
            this.samplejPanel = new JPanel();
            this.samplejPanel.setBounds(10, 50, 380, 120);
            this.themeColorJPanel = new JPanel();
            this.themeColorJPanel.setBounds(10, 190, 380, 260);
            this.warningJPanel = new JPanel();
            this.warningJPanel.setBounds(10, 460, 380, 120);
            this.doneBtn = new JButton();
            this.doneBtn.setBounds(168, 585, 68, 25);
            this.jButton2 = new JButton();
            this.jButton2.setBounds(10, 20, 130, 25);
            this.jButton2.setToolTipText("a tool tip for a text button (JButton)");
            this.jCheckBox1 = new JCheckBox();
            this.jCheckBox1.setBounds(170, 20, 103, 23);
            this.jCheckBox1.setToolTipText("a tool tip for a check box (JCheckBox)");
            this.jRadioButton1 = new JRadioButton();
            this.jRadioButton1.setBounds(170, 50, 150, 23);
            this.jRadioButton1.setToolTipText("a tool tip for a radio button (JRadioButton)");
            this.jComboBox2 = new JComboBox();
            this.jComboBox2.setBounds(10, 50, 130, 24);
            this.jTextField1 = new JTextField();
            this.jTextField1.setBounds(10, 80, 130, 20);
            this.jTextField1.setToolTipText("a tool tip for a text field (JTextField)");
            this.setDefaultCloseOperation(2);
            this.setResizable(false);
            this.getContentPane().setLayout(null);
            this.doneBtn.setText("Done");
            this.getContentPane().add(this.doneBtn);
            this.jPanel0.setLayout(null);
            this.jLabel1.setText("Look And Feel:");
            this.jPanel0.add(this.jLabel1);
            this.jPanel0.add(this.lookAndFeels);
            this.getContentPane().add(this.jPanel0);
            this.initSampleJPanel();
            this.initThemeColorJPanel();
            this.twLabel = new JTextArea();
            this.twLabel.setBounds(10, 20, 360, 90);
            this.twLabel.setWrapStyleWord(true);
            this.twLabel.setLineWrap(true);
            this.twLabel.setText("");
            this.warningJPanel.setBorder(new TitledBorder("Warnings"));
            this.warningJPanel.setLayout(null);
            this.warningJPanel.add(this.twLabel);
            this.getContentPane().add(this.warningJPanel);
            this.pack();
        }

        private void initSampleJPanel() {
            this.samplejPanel.setBorder(new TitledBorder("Sample"));
            this.samplejPanel.setLayout(null);
            this.jButton2.setText("A Button");
            this.samplejPanel.add(this.jButton2);
            this.jCheckBox1.setText("A Check Box");
            this.samplejPanel.add(this.jCheckBox1);
            this.jRadioButton1.setText("A Radio Button");
            this.samplejPanel.add(this.jRadioButton1);
            this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"A Combo Box"}));
            this.samplejPanel.add(this.jComboBox2);
            this.jTextField1.setText("A Text Field");
            this.samplejPanel.add(this.jTextField1);
            this.getContentPane().add(this.samplejPanel);
        }

        private void initThemeColorJPanel() {
            this.themeColorJPanel.setBorder(new TitledBorder("Colors"));
            this.themeColorJPanel.setLayout(null);
            int tcWidth = 360;
            this.themeColor_cbg = new ThemeColorTypeJPanel("cbg");
            this.themeColor_cbg.setBounds(10, 20, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cbg);
            this.themeColor_cfg = new ThemeColorTypeJPanel("cfg");
            this.themeColor_cfg.setBounds(10, 40, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cfg);
            this.themeColor_cwbg = new ThemeColorTypeJPanel("cwbg");
            this.themeColor_cwbg.setBounds(10, 60, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwbg);
            this.themeColor_cwfg = new ThemeColorTypeJPanel("cwfg");
            this.themeColor_cwfg.setBounds(10, 80, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwfg);
            this.themeColor_cwti = new ThemeColorTypeJPanel("cwti");
            this.themeColor_cwti.setBounds(10, 100, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwti);
            this.themeColor_cwfh = new ThemeColorTypeJPanel("cwfh");
            this.themeColor_cwfh.setBounds(10, 120, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwfh);
            this.themeColor_cwbh = new ThemeColorTypeJPanel("cwbh");
            this.themeColor_cwbh.setBounds(10, 140, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwbh);
            this.themeColor_cwts = new ThemeColorTypeJPanel("cwts");
            this.themeColor_cwts.setBounds(10, 160, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwts);
            this.themeColor_cwbs = new ThemeColorTypeJPanel("cwbs");
            this.themeColor_cwbs.setBounds(10, 180, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwbs);
            this.themeColor_cwms = new ThemeColorTypeJPanel("cwms");
            this.themeColor_cwms.setBounds(10, 200, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cwms);
            this.themeColor_cbgx = new ThemeColorTypeJPanel("cbgx");
            this.themeColor_cbgx.setBounds(10, 220, tcWidth, 20);
            this.themeColorJPanel.add(this.themeColor_cbgx);
            this.getContentPane().add(this.themeColorJPanel);
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Lookandfeel.this.currentStatus = 9;
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        class MyCanvas
        extends JComponent {
            MyCanvas() {
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        class ThemeColorTypeJPanel
        extends JPanel {
            public JLabel typeLabel = new JLabel();
            public JLabel hexLabel = new JLabel();
            public MyCanvas dispColor = new MyCanvas();

            public ThemeColorTypeJPanel(String themeComponent) {
                Theme gblTheme = (Theme)Theme.getTheme(Theme.getGlobalTheme());
                Color clr = gblTheme.getColor(themeComponent);
                String label = gblTheme.getComponentDescription(themeComponent);
                this.setLayout(null);
                this.typeLabel.setText(label);
                this.updateColor(clr);
                this.typeLabel.setBounds(0, 0, 240, 20);
                this.hexLabel.setBounds(250, 0, 80, 20);
                this.dispColor.setBounds(340, 5, 10, 10);
                this.add(this.typeLabel);
                this.add(this.hexLabel);
                this.add(this.dispColor);
            }

            public void updateColor(Color clr) {
                try {
                    this.hexLabel.setText(String.format("#%06X", 0xFFFFFF & clr.getRGB()));
                }
                catch (Exception e) {
                    PlafChooser.this.addWarning("No color found for " + this.typeLabel.getText());
                }
                this.dispColor.setForeground(clr);
            }
        }
    }
}

