/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import nxm.sys.lib.HttpResource;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.Table;
import nxm.sys.libg.MJPopup;
import nxm.sys.net.HttpAuthenticator;

public class Httpauth
extends Intrinsic {
    @Override
    public int open() {
        boolean showStatus = this.verbose;
        HttpAuthenticator authenticator = HttpAuthenticator.getInstance();
        String func = this.MA.getS("FUNC");
        String url = this.MA.getCS("URL");
        String user = this.MA.getCS("USERNAME");
        String pass = this.MA.getCS("PASSWORD");
        if (this.MA.isPresent("/GUI")) {
            LoginPromptGUI callback = null;
            boolean enableGUI = this.MA.getState("/GUI", false);
            if (enableGUI) {
                callback = LoginPromptGUI.INSTANCE;
                callback.defaultUsername = this.MA.getCS("/DEFAULTUSER", this.MR.getS("ENV.USER"));
                callback.setTitle(this.MA.getCS("/TITLE", null));
                authenticator.enable(true);
            }
            authenticator.setCallback(callback);
        }
        if (func.startsWith("ADD")) {
            if (user == null || user.length() == 0) {
                this.M.error("HTTPAUTH: ADD entry requires USERNAME to be set");
            }
            if (pass == null || pass.length() == 0) {
                this.M.error("HTTPAUTH: ADD entry requires PASSWORD to be set");
            }
            authenticator.put(url, user, pass);
            try {
                URL testUrl = new URI(url).toURL();
                URL testUrl2 = HttpResource.createURLWithPort(testUrl);
                if (testUrl2 != testUrl) {
                    authenticator.put(testUrl2.toString(), user, pass);
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.M.warning("unable to add user/pass to the default port");
            }
        } else if (func.startsWith("REM")) {
            authenticator.remove(url);
        } else if (func.startsWith("CLEAR")) {
            authenticator.clear();
        } else if (func.equals("ENABLE")) {
            authenticator.enable(true);
        } else if (func.equals("DISABLE")) {
            authenticator.enable(false);
        } else if (func.equals("STATUS")) {
            showStatus = true;
        } else if (func.length() > 0) {
            this.M.error("HTTPAUTH: Unknown function [" + func + "] specified!");
        }
        if (this.MA.isPresent("/ENABLE")) {
            authenticator.enable(this.MA.getState("/ENABLE", false));
        }
        if (this.MA.getState("/STATUS", showStatus)) {
            this.M.info("HTTPAUTH: status of " + authenticator);
        }
        return 9;
    }

    static class LoginPromptGUI
    implements HttpAuthenticator.CallbackIF {
        public static final LoginPromptGUI INSTANCE = new LoginPromptGUI();
        String defaultUsername = null;
        static final String DEF_TITLE = "Authorization Required";
        private String title = "Authorization Required";

        private LoginPromptGUI() {
        }

        void setTitle(String newTitle) {
            this.title = newTitle == null || newTitle.length() == 0 ? DEF_TITLE : newTitle;
        }

        @Override
        public PasswordAuthentication authenticate(String host, InetAddress addr, int port, String protocol, String prompt, String scheme, URL url, Authenticator.RequestorType reqType) {
            int messageType = 3;
            String message = "<html><b>Realm:</b> " + prompt + "<br><b>Url:</b> " + url + "<br></html>";
            Table userpass = MJPopup.showLogin(null, this.title, messageType, message, this.defaultUsername);
            if (userpass != null) {
                String user = userpass.getS("USER");
                String pass = userpass.getS("PASS");
                if (user.length() > 0 && pass.length() > 0) {
                    return new PasswordAuthentication(user, pass.toCharArray());
                }
            }
            return null;
        }

        public String toString() {
            return "LoginPromptGUI(" + this.defaultUsername + ")";
        }
    }
}

