/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JSplitPane;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MJBrowser;
import nxm.sys.libg.MJFrame;
import nxm.sys.libg.MJHelp;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.HTMLDocument;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import tools.BuildProps;

abstract class HelpSwap
extends Intrinsic {
    BuildProps sysBuildProps;
    boolean debug = false;
    private Searcher searcher;
    private static final Pattern PRE_OPEN_REGEX = Pattern.compile("(?i)<pre>");
    private static final Pattern PRE_CLOSE_REGEX = Pattern.compile("(?i)</pre>");
    private MJFrame helpGUIFrame;
    private MJHelp mjhelp;
    private int defaultCloseOp;
    boolean isOneShot;
    private boolean liteGUIRunning;

    HelpSwap() {
    }

    @Override
    public int open() {
        this.helpGUIFrame = null;
        this.mjhelp = null;
        this.searcher = null;
        this.liteGUIRunning = false;
        this.isOneShot = Shell.isOneShot();
        this.defaultCloseOp = (this.MA.getState("/GUI") || this.MA.getState("/LITEGUI")) && this.isOneShot ? 3 : 2;
        if (this.isOneShot) {
            this.pollTime = this.args.getD("/POLL", 0.25);
        }
        return 0;
    }

    int runLuceneIndex() {
        String moreDirs;
        String filter = this.MA.getCS("/FILTER", null);
        if (!this.indexFiles(filter, moreDirs = this.MA.getCS("/MOREDIRS", null))) {
            this.M.error("Run of Help Indexer failed!");
        }
        return 9;
    }

    int runLuceneGUI() {
        if (this.helpGUIFrame == null) {
            this.helpGUI();
        }
        if (this.isOneShot) {
            return -1;
        }
        return 9;
    }

    int runLuceneLiteGUI() {
        if (!this.liteGUIRunning) {
            try {
                String indexPath = this.sysBuildProps.getPath("help.index.dir");
                MJHelp.runAsApplication("NeXtMidas Search", indexPath, 500, 400, this.defaultCloseOp);
                this.liteGUIRunning = true;
            }
            catch (Exception e) {
                this.M.error("Aborted run of Lite HelpGUI (MJHelp). " + e);
            }
        }
        if (this.isOneShot) {
            return -1;
        }
        return 9;
    }

    void runLuceneSearchInteraction() {
        String queryStr = this.MA.getU("NAME", "");
        this.doSearchInteraction(queryStr);
    }

    @Override
    public int close() {
        if (this.helpGUIFrame != null) {
            this.mjhelp = null;
            this.helpGUIFrame = null;
        }
        return 0;
    }

    private void initHelpGUIComponents(String indexPath) {
        this.helpGUIFrame = new MJFrame("NeXtMidas Search", new MBox(20, 30, 800, 600));
        JSplitPane jSplitPane = new JSplitPane();
        this.mjhelp = new MJHelp();
        MJBrowser browser = new MJBrowser();
        this.mjhelp.setViewer(browser);
        jSplitPane.setDividerLocation(220);
        jSplitPane.setDividerSize(8);
        jSplitPane.setLeftComponent(this.mjhelp);
        jSplitPane.setRightComponent(browser);
        this.helpGUIFrame.getContentPane().add((Component)jSplitPane, "Center");
        this.helpGUIFrame.pack();
        this.helpGUIFrame.setDefaultCloseOperation(this.defaultCloseOp);
        this.mjhelp.setIndexPath(indexPath);
    }

    private void helpGUI() {
        try {
            if (this.helpGUIFrame == null) {
                this.initHelpGUIComponents(this.sysBuildProps.getPath("help.index.dir"));
            }
            this.helpGUIFrame.setVisible(true);
            this.mjhelp.requestFocusForSearch();
        }
        catch (Throwable t) {
            throw new MidasException("Aborted run of HelpGUI.", t);
        }
    }

    private void listResults(List<Document> list3, String query) {
        boolean showpath = this.MA.getState("/SHOWPATH");
        int len = list3.size();
        String statusMessage = len + " result";
        statusMessage = len == 0 || len == 1 ? statusMessage + " found for: " : statusMessage + "s found for: ";
        this.M.more(1);
        this.M.more(statusMessage + query);
        for (int i = 0; i < len && this.M.more(); ++i) {
            String filename;
            Document obj = list3.get(i);
            if (!(obj instanceof Document)) continue;
            Document doc = obj;
            String doctitle = doc.get("title");
            String path = doc.get("path");
            String pathFromNMROOT = filename = path.substring(path.lastIndexOf(47) + 1);
            String nmroot = Shell.getNmRoot();
            int nmrootIndex = path.indexOf(nmroot);
            if (nmrootIndex != -1) {
                pathFromNMROOT = path.substring(nmroot.length());
            }
            doctitle = doctitle == null || doctitle.equals("") ? pathFromNMROOT : (showpath ? doctitle + " (" + pathFromNMROOT + ")" : doctitle + " (" + filename + ")");
            String index = " " + i + ") ";
            if (i < 10) {
                index = " " + index;
            }
            this.M.more(index + " " + doctitle);
        }
        this.M.more(9);
    }

    private void doSearchInteraction(String queryStr) {
        if ((queryStr == null || queryStr.trim().length() == 0) && (queryStr = this.M.terminal.getInput("Enter search string: ", "").trim()).length() == 0) {
            return;
        }
        List<Document> results = this.searchIndex(queryStr);
        int len = results.size();
        if (len > 1) {
            this.listResults(results, queryStr);
        }
        for (int ilist = 0; ilist < len; ++ilist) {
            String text;
            Document doc;
            String docPath;
            TextFile tf;
            String ans = "N";
            if (len > 1) {
                ans = this.M.terminal.getInput("Enter item number or [N]ext/Quit/List ?: ", "");
            }
            if (this.M.terminal.getInterrupt() > 0 || (ans = ans.length() == 0 ? "N" : ans.trim().toUpperCase()).startsWith("Q")) break;
            if (ans.startsWith("L")) {
                this.listResults(results, queryStr);
                --ilist;
                continue;
            }
            if (ans.startsWith("N")) {
                if (ilist == len) {
                    break;
                }
            } else {
                try {
                    ilist = Integer.parseInt(ans);
                }
                catch (NumberFormatException nfe) {
                    --ilist;
                    continue;
                }
            }
            if (ilist >= len) break;
            Document obj = results.get(ilist);
            if (!(obj instanceof Document) || !(tf = new TextFile(this.M, (Object)(docPath = (doc = obj).get("path")))).open(32)) continue;
            this.M.more(1);
            this.M.more("Displaying file: " + docPath);
            boolean insidePreTag = false;
            while (this.M.more() && (text = tf.read()) != null) {
                if (!insidePreTag && PRE_OPEN_REGEX.matcher(text).matches()) {
                    insidePreTag = true;
                }
                if (insidePreTag && PRE_CLOSE_REGEX.matcher(text).matches()) {
                    insidePreTag = false;
                }
                text = StringUtil.html2Text(text);
                if (!insidePreTag && text.trim().length() == 0) continue;
                this.M.more(text);
            }
            this.M.more(9);
            tf.close();
            this.M.println("For better formatting of the contents, view the following in your browser.\n " + docPath);
        }
    }

    private List<Document> searchIndex(String queryStr) {
        List<Document> results = new ArrayList<Document>(0);
        if (this.searcher == null) {
            String indexPath = this.sysBuildProps.getPath("help.index.dir");
            if (indexPath == null || indexPath.length() == 0) {
                this.M.error("help.index.dir not set in build.props!");
            }
            try {
                this.searcher = new Searcher(indexPath);
            }
            catch (IOException ioe) {
                this.M.warning("Cannot initialize help index search. " + ioe);
            }
        }
        try {
            if (this.searcher != null) {
                results = this.searcher.query(queryStr, 100);
            }
        }
        catch (ParseException pe) {
            String message = "Invalid search string. " + pe.getMessage();
            this.M.warning(message);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean indexFiles(String filter, String additionalDirs) {
        result = false;
        indexPath = this.sysBuildProps.getPath("help.index.dir");
        maxFieldLength = Integer.parseInt(this.sysBuildProps.getProperty("help.maxFieldLength", "100000"));
        numDocs = 0;
        locations = this.sysBuildProps.getProperty("help.index.locations");
        useParentDirs = this.sysBuildProps.getProperty("help.index.useparent");
        filter = this.sysBuildProps.getProperty("help.index.filter", filter);
        if (indexPath == null || indexPath.length() == 0) {
            this.M.error("help.index.dir not set in build.props!");
        }
        if (additionalDirs != null) {
            locations = locations + "|" + additionalDirs;
        }
        this.M.info("Creating help index at " + indexPath + " filter=" + filter + "\nThis may take a minute or two...");
        startTime = System.currentTimeMillis();
        indexer = null;
        try {
            indexer = new Indexer(indexPath, true, maxFieldLength, filter);
            Indexer.access$102(indexer, this.debug);
            if (locations != null && locations.length() > 0) {
                Indexer.access$200(indexer, filter);
                if (this.debug) {
                    this.M.info("indexing dirs = " + locations + "  -  useparentDirs = " + useParentDirs);
                }
                for (String dir : dirs = locations.split("[|]")) {
                    if ((dir = dir.trim()).length() <= 0) continue;
                    useParentDir = useParentDirs.indexOf(dir) != -1;
                    Indexer.access$300(indexer, new File(dir), true, useParentDir);
                }
            }
            numDocs = Indexer.access$400(indexer);
            result = true;
            ** if (indexer == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                this.M.warning("Problem trying to index documents for help! " + e);
                if (this.debug) {
                    e.printStackTrace();
                }
                ** if (indexer == null) goto lbl-1000
            }
            catch (Throwable var18_19) {
                if (indexer != null) {
                    Indexer.access$500(indexer);
                    indexer = null;
                }
                throw var18_19;
            }
lbl-1000:
            // 1 sources

            {
                Indexer.access$500(indexer);
                indexer = null;
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Indexer.access$500(indexer);
            indexer = null;
        }
lbl-1000:
        // 2 sources

        {
        }
        endTime = System.currentTimeMillis();
        this.M.info("Help index created. Indexed " + numDocs + " files in " + (endTime - startTime) / 1000L + " seconds.");
        return result;
    }

    private static class CustomAnalyzer
    extends StandardAnalyzer {
        static final Version LUCENE_VERSION = Version.LUCENE_30;
        private static final Set<?> stopWords = StopFilter.makeStopSet((String[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"});

        public CustomAnalyzer() {
            super(LUCENE_VERSION, stopWords);
        }
    }

    public static class Searcher {
        private IndexSearcher searcher;
        private QueryParser queryParser;
        private static final String[] search_fields = new String[]{"midas", "explain", "title", "contents"};

        public Searcher(String indexPath) throws IOException {
            HashMap<String, Float> boost = new HashMap<String, Float>();
            boost.put("explain", Float.valueOf(6.0f));
            boost.put("midas", Float.valueOf(4.0f));
            boost.put("title", Float.valueOf(2.0f));
            this.queryParser = new MultiFieldQueryParser(CustomAnalyzer.LUCENE_VERSION, search_fields, Indexer.analyzer, boost);
            this.queryParser.setDefaultOperator(QueryParser.Operator.AND);
            this.queryParser.setAllowLeadingWildcard(true);
            this.setIndexPath(indexPath);
            BooleanQuery.setMaxClauseCount((int)2048);
        }

        void displayMessage(String msg, Exception ex) {
            if (Shell.getNmRoot() != null) {
                if (ex != null) {
                    Shell.printStackTrace(msg, ex);
                } else {
                    Shell.info(msg);
                }
            } else {
                String prepend = ex != null ? "WARN: " : "INFO: ";
                System.out.println(prepend + msg);
                if (ex != null) {
                    ex.printStackTrace();
                }
            }
        }

        private void setIndexPath(String indexDir) throws IOException {
            this.displayMessage("HELP: setting indexPath to " + indexDir, null);
            try {
                FSDirectory directory = FSDirectory.open((File)new File(indexDir));
                this.searcher = new IndexSearcher((Directory)directory, true);
            }
            catch (IOException e) {
                String msg = "Could not initialize help for index path='" + indexDir + "'. Did you run 'HELP/index' or do you have the appropriate file/dir permissions? " + e;
                this.displayMessage(msg, e);
                throw e;
            }
        }

        @Deprecated
        public List<Document> query(String queryString) throws ParseException {
            return this.query(queryString, 100);
        }

        public List<Document> query(String queryString, int maxResults) throws ParseException {
            ArrayList<Document> list3 = new ArrayList<Document>();
            int AUTO_WILDCARD_LEN = 5;
            StringBuilder querySB = new StringBuilder(64);
            if (queryString != null && queryString.length() > 0) {
                if (queryString.indexOf(" ") == -1 && !queryString.endsWith("~") && !queryString.endsWith("^")) {
                    String term1 = queryString.length() < 5 ? queryString : queryString + "*";
                    querySB.append(term1).append(" || explain:").append(queryString).append("* || midas:").append(queryString).append('*');
                } else {
                    String[] terms;
                    for (String term : terms = queryString.split("\\s")) {
                        if (term.length() >= 5 && !term.endsWith("~") && !term.endsWith("^")) {
                            querySB.append(term).append("* ");
                            continue;
                        }
                        querySB.append(term).append(' ');
                    }
                }
                try {
                    Query query = this.queryParser.parse(querySB.toString());
                    if (maxResults <= 0) {
                        maxResults = Integer.MAX_VALUE;
                    }
                    TopDocs topDocHits = this.searcher.search(query, maxResults);
                    int length = topDocHits.totalHits;
                    list3.ensureCapacity(length);
                    for (ScoreDoc hit : topDocHits.scoreDocs) {
                        int docId = hit.doc;
                        Document doc = this.searcher.doc(docId);
                        float score = hit.score;
                        doc.add((Fieldable)new Field("score", Float.toString(score), Field.Store.NO, Field.Index.NOT_ANALYZED));
                        list3.add(doc);
                    }
                }
                catch (Exception ioe) {
                    this.displayMessage("Caught Exception while searching for '" + queryString + "' ", ioe);
                }
            }
            return list3;
        }
    }

    private static class Indexer {
        private IndexWriter writer;
        private FileUtil.FnFilter fnFilter;
        private static Analyzer analyzer = new CustomAnalyzer();
        private boolean debug = false;

        private Indexer(String indexPath, boolean overwrite, int maxFieldLength, String filter) throws IOException {
            FSDirectory directory = FSDirectory.open((File)new File(indexPath));
            this.writer = new IndexWriter((Directory)directory, analyzer, overwrite, new IndexWriter.MaxFieldLength(maxFieldLength));
            this.fnFilter = FileUtil.createFnFilter(filter, "*.html|*.htm|*.txt");
        }

        private void close() {
            if (this.writer != null) {
                try {
                    this.writer.optimize();
                    this.writer.close();
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (Exception e) {
                    Shell.printStackTrace("Exception caught in Help.Indexer.close() ", e);
                }
            }
        }

        private void setFilter(String filter) {
            this.fnFilter = FileUtil.createFnFilter(filter, "");
        }

        private int getDocCount() throws AlreadyClosedException {
            int count = 0;
            if (this.writer != null) {
                count = this.writer.maxDoc();
            }
            return count;
        }

        private void indexDocs(File file, boolean recursive, boolean useParentDir) throws Exception {
            if (file.isDirectory()) {
                Object[] files = file.list();
                Arrays.sort(files);
                for (Object filestr : files) {
                    File afile = new File(file, (String)filestr);
                    if (file.isDirectory() && recursive) {
                        this.indexDocs(afile, recursive, useParentDir);
                        continue;
                    }
                    if (!this.fnFilter.accept(afile)) continue;
                    this.addDocToIndex(afile, useParentDir);
                }
            } else if (this.fnFilter.accept(file)) {
                this.addDocToIndex(file, useParentDir);
            }
        }

        private final void addDocToIndex(File file, boolean useParentDir) throws IOException, InterruptedException {
            int expIndex;
            int dotIndex;
            if (this.debug) {
                System.out.println("Help.Indexer: parsing " + file);
            }
            Document doc = HTMLDocument.Document((File)file);
            String path = file.getPath();
            String name = file.getName();
            if (useParentDir) {
                String fileInParentDir;
                File fileInParent;
                int pos = path.lastIndexOf(File.separatorChar);
                int n = pos = pos <= 0 ? -1 : path.lastIndexOf(File.separatorChar, pos - 1);
                if (pos != -1 && (fileInParent = new File(fileInParentDir = path.substring(0, pos + 1) + name)).exists()) {
                    String newValue = fileInParentDir.replace(File.separatorChar, '/');
                    doc.removeField("path");
                    doc.add((Fieldable)new Field("path", newValue, Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
            }
            if ((dotIndex = name.lastIndexOf(46)) != -1) {
                name = name.substring(0, dotIndex);
            }
            if ((expIndex = name.indexOf("_exp_")) != -1) {
                name = name.substring(expIndex + "_exp_".length());
                doc.add((Fieldable)new Field("explain", name, Field.Store.YES, Field.Index.ANALYZED));
            }
            doc.add((Fieldable)new Field("midas", name, Field.Store.YES, Field.Index.ANALYZED));
            if (this.debug) {
                System.out.println("Help.Indexer: adding " + path);
            }
            this.writer.addDocument(doc);
        }

        static /* synthetic */ boolean access$102(Indexer x0, boolean x1) {
            x0.debug = x1;
            return x0.debug;
        }

        static /* synthetic */ void access$200(Indexer x0, String x1) {
            x0.setFilter(x1);
        }

        static /* synthetic */ void access$300(Indexer x0, File x1, boolean x2, boolean x3) throws Exception {
            x0.indexDocs(x1, x2, x3);
        }

        static /* synthetic */ int access$400(Indexer x0) throws AlreadyClosedException {
            return x0.getDocCount();
        }

        static /* synthetic */ void access$500(Indexer x0) {
            x0.close();
        }
    }
}

