/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.Installation;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.JarFile;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import tools.BuildProps;

public class Generate
extends Intrinsic
implements AsciiMap {
    private static final Attributes.Name NAME_BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    private static String[] BASELINE_OPTION_TREES = new String[]{"audio", "database", "dsp", "hwc", "nettest", "sys", "ucl", "vnc", "webvnc", "xbc"};
    private static final MaskValue<SkipOptions> DEF_SKIP_OPTIONS = MaskValue.constant(SkipOptions.class, (Enum[])new SkipOptions[0]);
    private boolean doWarn = true;
    private boolean debug = false;
    private boolean waitingOnGui = false;
    private Map<String, Table> optInfoCache = new HashMap<String, Table>();

    @Override
    public int open() {
        String nmrootJarsDir = FileName.terminatePath(Shell.getNmRoot() + "jars");
        String func = this.MA.getU("FUNC");
        String name = this.MA.getU("NAME");
        String ffilt = this.MA.getCS("/FFILT");
        String root = this.MA.getCS("/ROOT", null);
        String os = this.MA.getCS("/OS", null);
        String arch = this.MA.getCS("/ARCH", null);
        boolean noTest = this.MA.getState("/NOTEST", false);
        boolean noDocs = this.MA.getState("/NODOCS", false);
        boolean noGraphics = this.MA.getState("/NOGRAPHICS", false);
        this.doWarn = this.MA.getState("/WARN", this.doWarn);
        this.debug = this.MA.getState("/DEBUG", this.debug);
        String skipDirs = "";
        if (noTest) {
            skipDirs = skipDirs + "|-test/*";
        }
        if (noDocs) {
            skipDirs = skipDirs + "|-docs/*";
        }
        if (noGraphics) {
            skipDirs = skipDirs + "|-libg/*|-prim/*|-intr/*|-dat/*|-net/*|-host/*|-mcr/*|-osgi/*";
            String string = skipDirs = noTest ? skipDirs : skipDirs + this.filterTestNotJunit() + "|-test/junit/libg/*|-test/junit/net/*|-test/junit/prim/*";
        }
        if (this.MA.isPresent("/SIGN") || this.MA.isPresent("/KEEP")) {
            this.M.deprecate("The /KEEP and /SIGN switches were deprecated in NeXtMidas 2.5 and removed in NeXtMidas 3.3. Please remove them from your macro as they may be repurposed in the future.");
        }
        if (func.startsWith("JNLP")) {
            name = this.MA.getCS("NAME");
            if (func.equals("JNLP/GUI") || func.equals("JNLP/TABLE")) {
                Table table = this.MA.getTable("P3");
                if (func.indexOf("/GUI") >= 0) {
                    Class<?> mjGenerateJnlpClass = null;
                    Method createJnlpFileMethod = null;
                    try {
                        mjGenerateJnlpClass = Class.forName("nxm.sys.libg.MJGenerateJnlp");
                        createJnlpFileMethod = mjGenerateJnlpClass.getDeclaredMethod("createJnlpFile", Generate.class, String.class, String.class, Table.class);
                        createJnlpFileMethod.invoke(null, this, name, null, table);
                        this.waitingOnGui = true;
                        this.pollTime = this.args.getD("/POLL", 0.25);
                    }
                    catch (Exception ex) {
                        this.M.error("GENERATE JNLP/GUI not supported without lib class MJGenerateJnlp");
                    }
                } else {
                    this.writeJnlpFile(name, null, table);
                }
            } else {
                String opts = this.MA.getCS("P3", "SYS");
                String dest = this.MA.getCS("P4", nmrootJarsDir);
                String codebase = this.MA.getCS("P5", "http://localhost/nmroot/jars");
                String href = this.MA.getCS("P6", null);
                this.doJnlp(name.toLowerCase(), opts, dest, codebase, href);
            }
        } else if (func.equals("JARS")) {
            MaskValue<SkipOptions> skipMask;
            String dest = this.MA.getCS("P3", "jars");
            Table keystoreCfg = this.MA.getTable("P4", null);
            String moreJarsignerOptions = this.MA.getCS("/SIGNOPTIONS", null);
            String versionQualifier = null;
            if (dest.equals("jars")) {
                dest = nmrootJarsDir;
            }
            if (!(skipMask = this.args.getMaskValue("/SKIP", null, DEF_SKIP_OPTIONS)).isSet(SkipOptions.JARSTANDARD)) {
                this.doJarFile(name, dest, ffilt, JarOption.JAR_STANDARD, root, os, arch, skipDirs, keystoreCfg, moreJarsignerOptions, versionQualifier);
            }
            if (!skipMask.isSet(SkipOptions.JARNATIVE)) {
                this.doJarFile(name, dest, ffilt, JarOption.JAR_NATIVE, root, os, arch, skipDirs, keystoreCfg, moreJarsignerOptions, versionQualifier);
            }
            if (!skipMask.isSet(SkipOptions.COPYJARS)) {
                this.copyJarFiles(name, dest, keystoreCfg, moreJarsignerOptions, this.debug);
            }
        } else if (func.equals("SIGN")) {
            Table keystoreCfg = this.MA.getTable("P3", null);
            String moreJarsignerOptions = this.MA.getCS("/SIGNOPTIONS", null);
            String opt = null;
            JarFile.signJarFile(this.M, this.MA.getFileName("NAME"), opt, keystoreCfg, moreJarsignerOptions, this.debug);
        } else if (func.equals("OPER")) {
            String path = this.M.io.name("libm", "", "", "SYS");
            nxm.sys.libm.Generate.doOpers(path, name, true);
        } else if (func.startsWith("EXP")) {
            Args targs = Shell.parseCommand(this.M, name);
            boolean doStub = func.indexOf("/S") > 0;
            String expName = this.MA.getCS("P3", null);
            boolean edit = this.MA.getState("/EDIT");
            this.doExplain(targs.name.toLowerCase(), expName, targs, doStub, edit);
        } else if (func.startsWith("BUN")) {
            MaskValue<SkipOptions> skipMask;
            String dest = this.MA.getCS("P3", "bundle");
            Table keystoreCfg = this.MA.getTable("P4", null);
            String moreJarsignerOptions = this.MA.getCS("/SIGNOPTIONS", null);
            String versionQualifier = this.MA.getCS("/QUALVER", null);
            if (dest.equals("bundle")) {
                dest = FileName.terminatePath(Shell.getNmRoot() + "bundle");
            } else if (dest.equals("jars")) {
                dest = nmrootJarsDir;
            }
            File file = new File(dest);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(skipMask = this.args.getMaskValue("/SKIP", null, DEF_SKIP_OPTIONS)).isSet(SkipOptions.BUNSTANDARD)) {
                this.doJarFile(name, dest, ffilt, JarOption.BUNDLE_STANDARD, root, os, arch, skipDirs, keystoreCfg, moreJarsignerOptions, versionQualifier);
            }
            if (!skipMask.isSet(SkipOptions.BUNNATIVE)) {
                this.doJarFile(name, dest, ffilt, JarOption.BUNDLE_NATIVE, root, os, arch, skipDirs, keystoreCfg, moreJarsignerOptions, versionQualifier);
            }
            if (!skipMask.isSet(SkipOptions.BUNSOURCE)) {
                this.doJarFile(name, dest, ffilt, JarOption.BUNDLE_SOURCE, root, os, arch, skipDirs, keystoreCfg, moreJarsignerOptions, versionQualifier);
            }
        } else {
            throw new MidasException("GENERATE: Unknown function FUNC='" + func + "'.");
        }
        return 0;
    }

    private String filterTestNotJunit() {
        char i;
        String filter = "";
        char start = 'a';
        int last = 122;
        for (i = start; i <= last; i = (char)((char)(i + 1))) {
            if (i == 'j') continue;
            filter = filter + "|-test/" + i + "*";
        }
        start = 'A';
        last = 90;
        for (i = start; i <= last; i = (char)(i + '\u0001')) {
            if (i == 'J') continue;
            filter = filter + "|-test/" + i + "*";
        }
        return filter;
    }

    @Override
    public int process() {
        return this.waitingOnGui ? -1 : 9;
    }

    private void doExplain(String name, String expName, Args targs, boolean doStub, boolean edit) {
        int status;
        String opt = targs.option.toLowerCase();
        String editor = this.MR.getString("ENV.EDITOR");
        String source = new FileName(targs.getDefaultSourceName()).toString();
        boolean overWrite = this.MA.getState("/NEW");
        if (expName == null) {
            expName = this.M.io.name("exp", name.toLowerCase(), "exp", opt);
        }
        if ((status = doStub ? nxm.sys.lib.Generate.genExplainFromSource(source, name, expName, overWrite, this.doWarn) : nxm.sys.lib.Generate.genExplainFromComments(source, expName, overWrite)) < 0) {
            if (status == -2) {
                if (this.doWarn) {
                    this.M.warning("Explain file for " + name + " exists. Use /NEW switch to overwrite");
                }
            } else if (this.doWarn) {
                this.M.warning("Unable to create explain file for " + name + " ,status = " + status);
            }
        }
        if (edit) {
            Shell.runCommand(this.M, editor + " " + source);
        }
    }

    public void writeJnlpFile(String fileName, String templateName, Table table) {
        if (fileName == null && templateName == null) {
            this.M.info("No file written.");
        }
        String propPrefix = "";
        if (Installation.ApplyBugFix.GENERATE_JNLP_PREPEND_JNLP_TO_PROPERTIES) {
            propPrefix = "jnlp.";
        }
        if (fileName != null) {
            String codebase = table.getS("CODEBASE");
            String href = table.getS("JNLPHREF");
            String command = table.getS("COMMAND");
            boolean useNative = table.getState("USENATIVE", false);
            String opts = table.getS("OPTS", "SYS");
            String title = table.getS("TITLE", "MyApp");
            String descr = table.getS("DESCR", title);
            String shortDescr = table.getS("SHORTDESCR", descr);
            String vendor = table.getS("VENDOR", "ICE");
            String homepage = table.getS("HOMEPAGE", "nextmidas.html");
            String javaVer = table.getS("JAVAVER", "1.8+");
            try {
                String[] optionTrees = opts.split("[|]");
                ArrayList<File> jars = new ArrayList<File>();
                File jarDir = new File(Shell.getNmRoot(), "jars");
                jars.add(new File(jarDir, "nxm-sys.jar"));
                if (useNative) {
                    jars.add(new File(jarDir, "nxm-sys-all.jar"));
                }
                jars.addAll(Arrays.asList(OptionTree.getJarFiles("SYS")));
                for (int i = 0; i < optionTrees.length; ++i) {
                    String opt = optionTrees[i].toLowerCase().trim();
                    if (opt.equals("sys") || opt.length() <= 0) continue;
                    jars.add(new File(jarDir, "nxm-" + opt + ".jar"));
                    if (useNative) {
                        jars.add(new File(jarDir, "nxm-" + opt + "-all.jar"));
                    }
                    jars.addAll(Arrays.asList(OptionTree.getJarFiles(opt)));
                }
                File file = new File(fileName);
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                out.println("<!-- This file is generated using NeXtMidas 4.1.4 -->");
                out.println("<jnlp spec=\"1.0+\" href=\"" + href + "\"");
                out.println("      codebase=\"" + codebase + "\">");
                out.println();
                out.println("  <information>");
                out.println("    <title>" + title + "</title>");
                out.println("    <vendor>" + vendor + "</vendor>");
                out.println("    <homepage href=\"" + homepage + "\"/>");
                out.println("    <description>" + descr + "</description>");
                out.println("    <description kind=\"short\">" + shortDescr + "</description>");
                out.println("    <offline-allowed/>");
                out.println("  </information>");
                out.println();
                out.println("  <!-- Set the permissions that we'll request from the host. -->");
                out.println("  <security>");
                out.println("    <all-permissions/>");
                out.println("  </security>");
                out.println();
                out.println("  <resources>");
                out.println("    <j2se version=\"" + javaVer + "\"/>");
                for (File jarfile : jars) {
                    if ("nxm-sys.jar".equals(jarfile.getName())) {
                        out.println("    <jar href=\"" + jarfile + "\" main=\"true\"/>");
                        continue;
                    }
                    out.println("    <jar href=\"" + jarfile + "\"/>");
                }
                out.println("    <property name=\"" + propPrefix + "OPTS\" value=\"" + opts + "\"/>");
                out.println("    <property name=\"" + propPrefix + "NONATIVE\" value=\"" + useNative + "\"/>");
                out.println("  </resources>");
                out.println();
                out.println("  <application-desc main-class=\"nxm.sys.lib.Webstart\">");
                out.println("    <argument>" + command + "</argument>");
                out.println("  </application-desc>");
                out.println("</jnlp>");
                out.close();
                this.M.info("JNLP file written to " + file.getCanonicalPath());
            }
            catch (Exception e) {
                throw new MidasException("Error writing file " + fileName, e);
            }
        }
        if (templateName != null) {
            this.M.warning("WRITING OF TEMPLATE TO FILE NOT IMPLEMENTED");
        }
        this.waitingOnGui = false;
    }

    private void doJnlp(String cmdname, String optStr, String dest, String codebase, String jnlphref) {
        String auxStr = "HOME HOME|RAM|DAT";
        this.msg("Generating JNLP files for " + cmdname + " in " + dest);
        File destFile = new File(dest);
        if (!destFile.exists()) {
            destFile.mkdir();
        }
        String propPrefix = "";
        if (Installation.ApplyBugFix.GENERATE_JNLP_PREPEND_JNLP_TO_PROPERTIES) {
            propPrefix = "jnlp.";
        }
        String jnlpName = cmdname + ".jnlp";
        FileName jnlpPath = new FileName(dest, cmdname, "jnlp");
        String href = jnlphref == null ? codebase + "/" + jnlpName : jnlphref;
        boolean hasHref = href.trim().length() > 0;
        String[] opts = StringUtil.cleanSplit(optStr, "|");
        this.msg("Writing " + jnlpPath);
        try {
            PrintWriter jnlp = new PrintWriter(new FileWriter(jnlpPath.getFullName()));
            jnlp.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            jnlp.println("<!-- This file was autogenerated using NeXtMidas's GENERATE JNLP -->");
            jnlp.println("<jnlp spec=\"1.0+\" codebase=\"" + codebase + "\"" + (!hasHref ? ">" : ""));
            if (hasHref) {
                jnlp.println("      href=\"" + href + "\">");
            }
            jnlp.println("");
            jnlp.println("  <information>");
            jnlp.println("    <title>" + cmdname + "</title>");
            jnlp.println("    <vendor>ICE</vendor>");
            jnlp.println("    <homepage href=\"../htdocs/index.html\"/>");
            jnlp.println("    <description>Run " + cmdname + "</description>");
            jnlp.println("    <description kind=\"short\"> Run " + cmdname + " </description>");
            jnlp.println("    <offline-allowed/>");
            jnlp.println("  </information>");
            jnlp.println("");
            jnlp.println("  <security>");
            jnlp.println("    <all-permissions/>");
            jnlp.println("  </security>");
            jnlp.println("");
            jnlp.println("  <resources>");
            jnlp.println("    <j2se version=\"1.8+\"/>");
            jnlp.println("    <jar href=\"nxm-sys.jar\" main=\"true\"/>");
            boolean doNative = false;
            if (doNative) {
                jnlp.println("    <nativelib href=\"nxm-sys-all.jar\"/>");
            }
            for (String optname : opts) {
                String[] jarFiles = this.getJarFiles(optname);
                if (jarFiles != null) {
                    for (String file : jarFiles) {
                        jnlp.println("    <jar href=\"" + file + "\" download=\"lazy\"/>");
                    }
                }
                if ("SYS".equalsIgnoreCase(optname)) continue;
                String jarname = "nxm-" + optname.toLowerCase() + ".jar";
                jnlp.println("    <jar href=\"" + jarname + "\" download=\"lazy\"/>");
                String njarname = "nxm-" + optname.toLowerCase() + "-all.jar";
                if (!doNative) continue;
                jnlp.println("    <nativelib href=\"" + njarname + "\"/>");
            }
            jnlp.println("    <property name=\"" + propPrefix + "NONATIVE\" value=\"" + !doNative + "\"/>");
            jnlp.println("    <property name=\"" + propPrefix + "OPTS\" value=\"" + optStr + "\"/>");
            jnlp.println("    <property name=\"" + propPrefix + "AUX\" value=\"" + auxStr + "\"/>");
            jnlp.println("  </resources>");
            jnlp.println("");
            jnlp.println("  <application-desc main-class=\"nxm.sys.lib.Webstart\">");
            jnlp.println("    <argument>" + cmdname + "</argument>");
            jnlp.println("  </application-desc>");
            jnlp.println("</jnlp>");
            jnlp.close();
        }
        catch (IOException e) {
            throw new MidasException("GENERATE: Error writing JNLP file.", e);
        }
    }

    private String[] getJarFiles(String opt) {
        ArrayList<String> filesList = new ArrayList<String>();
        File f = new File(Shell.getOptPath(opt, null) + "/jars/");
        ArrayList<Object> list3 = new ArrayList();
        try {
            list3 = new ArrayList<String>(Arrays.asList(f.list()));
        }
        catch (NullPointerException npe) {
            return null;
        }
        if (list3.isEmpty()) {
            return null;
        }
        for (Object file : list3) {
            String str = (String)file;
            if (!str.endsWith("jar")) continue;
            filesList.add(str);
        }
        return filesList.toArray(new String[filesList.size()]);
    }

    private Manifest loadManifest(FileName fname) {
        BaseFile bf;
        Manifest manifest = null;
        if (fname != null && (bf = new BaseFile(this.M, (Object)fname)).exists()) {
            try {
                if (bf.open()) {
                    manifest = new Manifest(bf.getResource().getInputStream());
                    bf.close();
                }
            }
            catch (Exception e) {
                this.M.printStackTrace("Unable to read manifest file '" + bf.getName() + "', using default manifest.", e);
            }
        }
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        return manifest;
    }

    private File[] listJarFiles(String opt) {
        opt = opt.toLowerCase();
        File dir = new File(OptionTree.getOptPath(opt, "jars"));
        FileUtil.FnFilter filt = FileUtil.createFnFilter(null, "*.jar", null);
        return FileUtil.findFiles(dir, filt);
    }

    private void copyJarFiles(String opt, String dest, Table customKeystoreCfg, String customJarsignerOptions, boolean debug) {
        File[] jars;
        for (File file : jars = this.listJarFiles(opt)) {
            String fname = file.getName();
            FileName inName = new FileName(file.getPath(), true);
            FileName outName = new FileName(dest, fname, null, true);
            if (this.verbose) {
                this.M.info("Copying & Signing " + opt + "'s " + fname + " to " + outName);
            }
            FileUtil.copyBaseFile(this.M, inName, outName);
            JarFile.signJarFile(this.M, outName, opt, customKeystoreCfg, customJarsignerOptions, debug);
        }
    }

    private String toClasspath(File[] jars) {
        StringBuilder jarFiles = new StringBuilder();
        for (File jar : jars) {
            jarFiles.append(jar.getName()).append(' ');
        }
        return jarFiles.toString();
    }

    private void doJarFile(String opt, String dest, String filter, JarOption type, String root, String os, String arch, String skipDirs, Table customKeystoreCfg, String customJarsignerOptions, String customVersionQualifier) {
        String jarFiles;
        String jarName;
        opt = opt.toLowerCase();
        String separator = ",";
        if (this.M.io.getOptions().indexOf("UseSemiColonsInGenerateManifest") > -1) {
            separator = ";";
        }
        if (os == null || os.isEmpty()) {
            os = Util.getOSName(null);
        }
        if (arch == null || arch.isEmpty()) {
            arch = Util.getArchName(null);
        }
        if (root == null || root.isEmpty()) {
            root = OptionTree.getOptPath(opt, null);
        }
        if (skipDirs == null) {
            skipDirs = "";
        }
        Manifest manifest = this.loadManifest(new FileName("nxm." + opt + ".cfg.manifest.mf"));
        Attributes mfMainAttributes = manifest.getMainAttributes();
        Table optInfo = this.getCachedOptInfo(opt);
        String version = optInfo.getS("VERSION");
        String defFilter = BuildProps.getPropFor(opt, "jnlp.file_filter", Shell.getCurrent());
        String bundleVendor = mfMainAttributes.getValue(NAME_BUNDLE_VENDOR);
        if (bundleVendor == null && Arrays.binarySearch(BASELINE_OPTION_TREES, opt) != -1) {
            Manifest sysManifest = this.loadManifest(new FileName("nxm.sys.cfg.manifest.mf"));
            bundleVendor = sysManifest.getMainAttributes().getValue(NAME_BUNDLE_VENDOR);
        }
        version = OptionTree.replaceVersionQualifier(version, customVersionQualifier);
        switch (type) {
            case JAR_STANDARD: {
                jarName = "nxm-" + opt + ".jar";
                defFilter = BuildProps.getPropFor(opt, "jnlp.file_filter", Shell.getCurrent());
                jarFiles = this.toClasspath(this.listJarFiles(opt));
                break;
            }
            case BUNDLE_STANDARD: {
                jarName = "nxm." + opt + "_" + version + ".jar";
                defFilter = BuildProps.getPropFor(opt, "jnlp.file_filter", Shell.getCurrent());
                jarFiles = null;
                break;
            }
            case JAR_NATIVE: {
                manifest = this.loadManifest(null);
                mfMainAttributes = manifest.getMainAttributes();
                String savedImplVendor = mfMainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                this.putIfNotPresent(mfMainAttributes, Attributes.Name.IMPLEMENTATION_VENDOR, savedImplVendor);
                jarName = "nxm-" + opt + "-native-" + os + "-" + arch + ".jar";
                defFilter = "*" + Shell.getSharedObjExt();
                jarFiles = null;
                break;
            }
            case BUNDLE_NATIVE: {
                manifest = this.loadManifest(null);
                mfMainAttributes = manifest.getMainAttributes();
                jarName = "nxm." + opt + "." + os + "." + arch + "_" + version + ".jar";
                defFilter = "*" + Shell.getSharedObjExt();
                jarFiles = null;
                break;
            }
            case BUNDLE_SOURCE: {
                manifest = this.loadManifest(null);
                mfMainAttributes = manifest.getMainAttributes();
                jarName = "nxm." + opt + ".source_" + version + ".jar";
                defFilter = "*.java|*.h|*.c";
                jarFiles = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown JAR type '" + (Object)((Object)type) + "'");
            }
        }
        defFilter = defFilter + skipDirs;
        FileUtil.FnFilter filt = FileUtil.createFnFilter(root, filter, defFilter);
        if (jarFiles != null) {
            String manifestClasspath = mfMainAttributes.getValue(Attributes.Name.CLASS_PATH);
            String classpath = manifestClasspath == null ? jarFiles : manifestClasspath + " " + jarFiles;
            mfMainAttributes.put(Attributes.Name.CLASS_PATH, classpath);
        }
        this.putIfNotPresent(mfMainAttributes, Attributes.Name.IMPLEMENTATION_VERSION, version);
        this.putIfNotPresent(mfMainAttributes, "Permissions", "all-permissions");
        this.putIfNotPresent(mfMainAttributes, "Codebase", "*");
        this.putIfNotPresent(mfMainAttributes, "Application-Name", "NeXtMidas");
        if (type.isOSGIBundle()) {
            this.putIfNotPresent(mfMainAttributes, "Bundle-ManifestVersion", "2");
            this.putIfNotPresent(mfMainAttributes, "Bundle-Version", version);
            String symname = this.putIfNotPresent(mfMainAttributes, "Bundle-SymbolicName", "nxm." + opt);
            int iSemicolon = symname.indexOf(59);
            if (iSemicolon > 0) {
                symname = symname.substring(0, iSemicolon);
            }
            this.putIfNotPresent(mfMainAttributes, "Bundle-Description", optInfo.getS("DESCRIPTION"));
            this.putIfNotPresent(mfMainAttributes, "Bundle-Name", "NeXtMidas Option Tree (" + (Object)((Object)type) + ") - " + opt.toUpperCase());
            this.putIfNotPresent(mfMainAttributes, "Bundle-ActivationPolicy", "lazy");
            this.putIfNotPresent(mfMainAttributes, NAME_BUNDLE_VENDOR, bundleVendor);
            if (type == JarOption.BUNDLE_NATIVE || type == JarOption.BUNDLE_SOURCE) {
                String fragmentBSN;
                if (type == JarOption.BUNDLE_NATIVE) {
                    fragmentBSN = symname + "." + os + "." + arch;
                    mfMainAttributes.putValue("Bundle-SymbolicName", fragmentBSN);
                    mfMainAttributes.putValue("Fragment-Host", symname + "; bundle-version=\"" + version + "\"");
                    mfMainAttributes.putValue("Eclipse-PlatformFilter", "(&(osgi.os=" + os + ")(osgi.arch=" + arch + "))");
                } else if (type == JarOption.BUNDLE_SOURCE) {
                    fragmentBSN = symname + ".source";
                    mfMainAttributes.putValue("Bundle-SymbolicName", fragmentBSN);
                    mfMainAttributes.putValue("Eclipse-SourceBundle", symname + "; version=\"" + version + "\"; roots:=\".\"");
                }
            }
        }
        FileName jarFile = new FileName(dest, jarName, null);
        File dir = new File(root);
        File[] files = FileUtil.findFiles(dir, filt);
        ArrayList<String> namesInJar = new ArrayList<String>(files.length);
        ArrayList<FileName> fnames = new ArrayList<FileName>(files.length);
        StringBuilder nativeCode = new StringBuilder();
        StringBuilder exportPackages = new StringBuilder();
        if (!type.isNative()) {
            namesInJar.add("nxm/");
            fnames.add(null);
            namesInJar.add("nxm/" + opt + "/");
            fnames.add(null);
            exportPackages.append("nxm.").append(opt);
        }
        for (File file : files) {
            fnames.add(new FileName(file));
            if (!type.isNative()) {
                String relDir = FileUtil.getRelativeDir(dir, file.getParentFile()).replace('\\', '/');
                int isDir = file.isDirectory();
                if (isDir != 0) {
                    namesInJar.add("nxm/" + opt + "/" + relDir + file.getName() + "/");
                    exportPackages.append(separator + " nxm.").append(opt).append(".").append(file.getName());
                    continue;
                }
                namesInJar.add("nxm/" + opt + "/" + relDir + file.getName());
                continue;
            }
            String filename = file.getName();
            if (filename.endsWith(".so") && filename.endsWith(Shell.getSharedObjExt())) {
                filename = "lib" + filename;
            }
            namesInJar.add(filename);
            if (type != JarOption.BUNDLE_NATIVE) continue;
            nativeCode.append(filename).append("; ");
        }
        if ("sys".equals(opt) && !type.isNative()) {
            File[] toolsFiles;
            namesInJar.add("tools/");
            fnames.add(null);
            File toolsDir = new File(Shell.getNmRoot() + "tools/");
            String fnFilter = type == JarOption.BUNDLE_SOURCE ? "BuildProps*.java" : null;
            for (File file : toolsFiles = FileUtil.findFiles(toolsDir, FileUtil.createFnFilter(fnFilter, "BuildProps*.class"))) {
                fnames.add(new FileName(file));
                namesInJar.add("tools/" + file.getName());
            }
            if (skipDirs.contains("|-test/") && !skipDirs.contains("|-test/junit")) {
                File[] junitFiles;
                namesInJar.add("nxm/sys/test/junit/");
                fnames.add(null);
                File file = new File(Shell.getNmRoot() + "nxm/sys/test/junit/");
                for (File file2 : junitFiles = FileUtil.findFiles(file, FileUtil.createFnFilter(fnFilter, "NMTestCase*.class"))) {
                    fnames.add(new FileName(file2));
                    namesInJar.add("nxm/sys/test/junit/" + file2.getName());
                }
            }
        }
        if (type == JarOption.BUNDLE_STANDARD) {
            File[] jarfiles;
            this.putIfNotPresent(mfMainAttributes, "Export-Package", exportPackages.toString());
            if ("sys".equals(opt)) {
                mfMainAttributes.putValue("Eclipse-BuddyPolicy", "registered");
            } else {
                mfMainAttributes.putValue("Eclipse-RegisterBuddy", "nxm.sys");
                this.putIfNotPresent(mfMainAttributes, "Import-Package", "nxm.sys.inc" + separator + " nxm.sys.lib" + separator + " nxm.sys.libg" + separator + " nxm.sys.libm" + separator + " nxm.sys.net" + separator + " nxm.sys.test.junit; resolution:=optional");
            }
            this.putIfNotPresent(mfMainAttributes, "DynamicImport-Package", "*");
            if (this.MA.getState("/EMBEDJARS", true) && (jarfiles = this.listJarFiles(opt)).length > 0) {
                StringBuilder bundleClasspath = new StringBuilder(".");
                for (File jarfile : jarfiles) {
                    String jarfilename = jarfile.getName();
                    if ("sys".equals(opt) && "osgi.core.jar".equals(jarfilename)) continue;
                    fnames.add(new FileName(jarfile));
                    namesInJar.add(jarfilename);
                    bundleClasspath.append(',').append(jarfilename);
                }
                mfMainAttributes.putValue("Bundle-ClassPath", bundleClasspath.toString());
            }
        } else if (type == JarOption.BUNDLE_NATIVE && nativeCode.length() > 0) {
            nativeCode.append("osname=").append(os).append("; ");
            nativeCode.append("processor=").append(arch);
            mfMainAttributes.putValue("Bundle-NativeCode", nativeCode.toString());
        }
        boolean makeEmptyNativeJar = this.MA.getState("/ALLOWEMPTYNATIVEJAR", false);
        if (namesInJar.isEmpty() && makeEmptyNativeJar && type == JarOption.JAR_NATIVE) {
            fnames.add(null);
            namesInJar.add(".keepme");
        } else if (files.length == 0) {
            if (this.verbose) {
                this.M.info("Skipping " + (Object)((Object)type) + " (no files found) for " + opt.toUpperCase());
            }
            return;
        }
        if (this.verbose) {
            this.M.info("Creating " + (Object)((Object)type) + " file " + jarFile);
            if (this.debug) {
                this.M.info("  file filter      : " + filt);
                this.M.info("  number of files  : " + namesInJar.size());
            }
        }
        String[] nameArray = namesInJar.toArray(StringUtil.EMPTY_STRING_ARRAY);
        FileName[] fnameArray = fnames.toArray(new FileName[0]);
        boolean bl = this.debug;
        JarFile.createJarFile(this.M, jarFile, manifest, nameArray, fnameArray, bl, true, opt, customKeystoreCfg, customJarsignerOptions, this.debug);
    }

    private String putIfNotPresent(Attributes mfAttributes, String name, String value) {
        String currentVal = mfAttributes.getValue(name);
        if (currentVal == null && value != null) {
            mfAttributes.putValue(name, value);
            return value;
        }
        return currentVal;
    }

    private String putIfNotPresent(Attributes mfAttributes, Attributes.Name name, String value) {
        String currentVal = mfAttributes.getValue(name);
        if (currentVal == null && value != null) {
            mfAttributes.put(name, value);
            return value;
        }
        return currentVal;
    }

    private synchronized Table getCachedOptInfo(String opt) {
        Table optInfo = this.optInfoCache.get(opt);
        if (optInfo == null) {
            optInfo = OptionTree.getInfo(opt, this.M, this.verbose, this.doWarn);
            this.optInfoCache.put(opt, optInfo);
        }
        return optInfo;
    }

    private void msg(String txt) {
        if (this.debug || this.verbose) {
            this.M.info(txt);
        }
    }

    private static enum JarOption {
        JAR_STANDARD("standard JAR", false, false),
        JAR_NATIVE("native   JAR", true, false),
        BUNDLE_STANDARD("standard bundle", false, true),
        BUNDLE_NATIVE("native   bundle", true, true),
        BUNDLE_SOURCE("source   bundle", false, true);

        private final String description;
        private final boolean nativeJAR;
        private final boolean osgiBundle;

        private JarOption(String description, boolean nativeJAR, boolean osgiBundle) {
            this.description = description;
            this.nativeJAR = nativeJAR;
            this.osgiBundle = osgiBundle;
        }

        public String toString() {
            return this.description;
        }

        public boolean isOSGIBundle() {
            return this.osgiBundle;
        }

        public boolean isNative() {
            return this.nativeJAR;
        }
    }

    private static enum SkipOptions {
        JARSTANDARD,
        JARNATIVE,
        COPYJARS,
        BUNSTANDARD,
        BUNNATIVE,
        BUNSOURCE;

    }
}

