/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import nxm.sys.intr.Macrofunc;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.SortedIteration;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class Foreach
extends Intrinsic {
    private Enumeration<?> enumeration;
    private Iterator<?> iterator;
    private Keywords.Iterator kwi;
    private KeyVector.Iterator kvi;
    private DataFile df;
    private TextFile tf;
    private Object[] array;
    private Parser list;
    private String item;
    private Map<?, ?> map;
    private boolean reverse;
    private Data data;
    private int index;
    private int size;
    private boolean doValues;

    @Override
    public int process() {
        this.enumeration = null;
        this.iterator = null;
        this.kwi = null;
        this.kvi = null;
        this.df = null;
        this.tf = null;
        this.array = null;
        this.list = null;
        this.map = null;
        this.data = null;
        this.index = 0;
        this.size = 0;
        this.index = 0;
        if (this.M.macro == null) {
            String cmd = Macrofunc.enterIntrMacroText(this.M, "%foreach", this.MA.getRaw(), "endfor");
            Shell.runCommand(this.M, cmd);
            return 9;
        }
        String func = this.MA.getU("FUNC");
        boolean sort2 = this.MA.getState("/SORT");
        this.item = this.MA.getU("ITEM");
        this.reverse = this.MA.getState("/REV");
        boolean bl = this.doValues = func.indexOf("/V") >= 0 || this.MA.getState("/VAL");
        if (func.startsWith("INTA")) {
            Object obj = this.MA.getO("IN");
            if (obj instanceof KeyVector) {
                this.kvi = ((KeyVector)obj).iterator();
            } else {
                Table tab = this.MA.getTable("IN");
                if (tab == null) {
                    this.M.error("No table found for INTAB option");
                }
                Collection<Object> col = this.doValues ? tab.values() : tab.keySet();
                this.iterator = sort2 ? new SortedIteration(col) : col.iterator();
            }
        } else if (func.startsWith("INDF") || func.startsWith("INF")) {
            this.df = this.MA.getDataFile("IN");
            this.df.open();
            this.data = this.df.getDataBuffer(1);
        } else if (func.startsWith("INTF")) {
            this.tf = this.MA.getTextFile("IN");
            this.tf.open(8192);
        } else if (func.startsWith("INLI")) {
            this.list = new Parser(this.MA.getS("IN"));
            this.list.setUseSpaceDelimiter(false);
            this.size = this.list.elements();
            this.index = this.reverse ? this.size : 0;
        } else if (func.startsWith("INSI")) {
            this.size = this.MA.getL("IN");
            this.index = this.reverse ? this.size : 0;
        } else if (func.startsWith("INKW")) {
            this.df = this.MA.getDataFile("IN");
            this.df.open();
            String scope = this.MA.getU("/SCOPE");
            if (scope.length() > 0 && this.df.keywords.setScope(scope) == 0) {
                this.M.error("Could not set scope to " + scope);
            }
            this.kwi = this.df.keywords.iterator();
            this.df.close();
            this.df = null;
        } else if (func.startsWith("IN")) {
            Vector<Object> obj = this.MA.getO("IN");
            if (obj instanceof Data) {
                obj = ((Data)((Object)obj)).toVector();
            }
            if (obj instanceof Map) {
                Vector<Object> vector = obj = this.doValues ? ((Map)((Object)obj)).values() : ((Map)((Object)obj)).keySet();
            }
            if (obj instanceof Collection) {
                obj = ((Collection)obj).iterator();
            }
            if (obj instanceof Iterator) {
                this.iterator = (Iterator)((Object)obj);
            } else if (obj instanceof Object[]) {
                this.array = (Object[])obj;
            } else if (obj instanceof Enumeration) {
                this.enumeration = (Enumeration)((Object)obj);
            } else {
                this.M.error("FOREACH: Type not supported with IN function.");
            }
            if (this.array != null) {
                this.index = this.reverse ? this.array.length : 0;
            }
        } else {
            this.M.error("Unsupported function: " + func);
        }
        if (!this.doNext()) {
            this.M.macro.nextIndex = this.nextIndex + 1;
        }
        return 9;
    }

    public boolean doNext() {
        String line;
        if (this.enumeration != null && this.enumeration.hasMoreElements()) {
            Object key = this.enumeration.nextElement();
            if (this.doValues) {
                this.MR.put(this.item, this.map.get(key));
            } else {
                this.MR.put(this.item, key);
            }
        } else if (this.iterator != null && this.iterator.hasNext()) {
            this.MR.put(this.item, this.iterator.next());
        } else if (this.kvi != null && this.kvi.getNext()) {
            if (this.doValues) {
                this.MR.put(this.item, this.kvi.value);
            } else {
                this.MR.put(this.item, (Object)this.kvi.key);
            }
        } else if (this.kwi != null && this.kwi.getNext()) {
            this.MR.put(this.item, (Object)this.kwi);
        } else if (this.df != null && this.df.read(this.data) > 0) {
            this.MR.put(this.item, (Object)this.data);
        } else if (this.tf != null && (line = this.tf.readProper()) != null) {
            this.MR.put(this.item, (Object)line);
        } else if (this.list != null && !this.reverse && this.index < this.size) {
            this.MR.put(this.item, (Object)this.list.get(++this.index));
        } else if (this.list != null && this.reverse && this.index > 0) {
            this.MR.put(this.item, (Object)this.list.get(this.index--));
        } else if (this.array != null && !this.reverse && this.index < this.array.length) {
            this.MR.put(this.item, this.array[this.index++]);
        } else if (this.array != null && this.reverse && this.index > 0) {
            this.MR.put(this.item, this.array[--this.index]);
        } else if (this.size > 0 && !this.reverse && this.index < this.size) {
            this.MR.put(this.item, this.index++);
        } else if (this.size > 0 && this.reverse && this.index > 0) {
            this.MR.put(this.item, --this.index);
        } else {
            if (this.df != null) {
                this.df.close();
            }
            if (this.tf != null) {
                this.tf.close();
            }
            return false;
        }
        return true;
    }

    public String autoTerminate() {
        return "ENDFOR";
    }
}

