/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class Defaults
extends Intrinsic {
    @Override
    public int open() {
        String name = this.MA.getS("NAME");
        String option = this.MA.getS("OPTION");
        String type = this.MA.getS("TYPE");
        int isemi = name.indexOf(59);
        if (isemi > 0) {
            String opt = name.substring(isemi + 1);
            if (option.length() > 0 && !option.equals(opt)) {
                this.M.warning("Conflicting specification of option name OPTION=" + option + " and ;" + opt + " both used, using " + opt + ".");
            }
            name = name.substring(0, isemi);
            option = opt;
        }
        boolean matchFound = false;
        for (int i = 0; i < this.M.dictionary.getSize(); ++i) {
            Table entry = this.M.dictionary.getEntry(i);
            String cmdName = entry.getS("NAME");
            String command = entry.getS("CMD");
            String cmdOpt = entry.getS("OPT");
            String cmdSup = entry.getS("SUP");
            String nargs = entry.getS("NARGS");
            String nameOpt = cmdName + ";" + cmdOpt;
            if (name.length() > 0 && !nameOpt.startsWith(name) || type.length() > 0 && type.lastIndexOf(cmdSup) <= -1 || option.length() > 0 && !cmdOpt.equals(option)) continue;
            String value = StringUtil.padRight(command + ";" + cmdOpt + " ", 20) + StringUtil.padRight(cmdSup + "," + nargs + " ", 8) + ",";
            int index = 1;
            String def = null;
            while ((def = entry.getS("DEF" + index)) != null) {
                value = value + def + ",";
                ++index;
            }
            this.M.info(value);
            matchFound = true;
        }
        if (!matchFound) {
            this.M.warning("No command dictionary entry matching NAME=" + name + ", OPTION=" + option + ", TYPE=" + type);
        }
        return 9;
    }
}

