/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.lang.reflect.Method;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.intr.Results;
import nxm.sys.lib.Intrinsic;

public class Debug
extends Intrinsic
implements nxm.sys.inc.Debug {
    @Override
    public int open() {
        String result = "OLDDEBUGMODE";
        int len = this.MA.getLength("/SAVE");
        if (len >= 0) {
            if (len > 0) {
                result = this.MA.getU("/SAVE");
            }
            this.MR.put(result, (Object)this.M.getDebug());
            if (this.verbose) {
                this.M.info("Saved DEBUG mode to '" + result + "'");
            }
            return 9;
        }
        len = this.MA.getLength("/LOAD");
        if (len >= 0) {
            if (len > 0) {
                result = this.MA.getU("/LOAD");
            }
            this.M.setDebug(this.MR.getS(result));
            nxm.sys.inc.Debug.saveGlobalDebugSettings(this.MR, this.M.debug);
            if (this.verbose) {
                this.M.info("Loaded DEBUG mode from '" + result + "'");
                this.displayCurrentSettings();
            }
            return 9;
        }
        if (!this.MA.find("STATE")) {
            this.displayCurrentSettings();
            return 9;
        }
        boolean state = this.MA.getZ("STATE");
        String func = this.MA.getS("FUNC");
        if (func.indexOf(".") > -1) {
            this.M.info("Turning on debug for " + this.MA.getQ("FUNC"));
            this.setStaticDebug(this.MA.getQ("FUNC"), state);
            return 9;
        }
        if (state) {
            this.M.setDebug("+" + func);
        } else {
            this.M.setDebug("-" + func);
        }
        nxm.sys.inc.Debug.saveGlobalDebugSettings(this.MR, this.M.debug);
        if (this.verbose) {
            this.displayCurrentSettings();
        }
        return 0;
    }

    private final void displayCurrentSettings() {
        Results.listSingleResult(this.M, this.M.results, "ENV.DEBUG", 0, false);
    }

    public boolean setStaticDebug(String className, boolean state) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("setDebug", Boolean.TYPE);
            if (method != null) {
                method.invoke(null, state);
            }
            return true;
        }
        catch (Exception excep) {
            this.M.warning(excep.toString());
            return false;
        }
    }

    @InternalUseOnly
    @Deprecated
    public static void saveGlobalDebugSettings(nxm.sys.lib.Results MR, int debugMask) {
        nxm.sys.inc.Debug.saveGlobalDebugSettings(MR, debugMask);
    }
}

