/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Archiver;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.VRTPacket;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class sourceice
extends Primitive
implements Keyable {
    public static String replayList = "-NShot,File,Stopped,OneShot,Continuous,StopTop,StopNow,Spin,Archive,Restart,Abort";
    public static int rFILE = -1;
    public static int rSTOPPED = 0;
    public static int rONESHOT = 1;
    public static int rCONTINUOUS = 2;
    public static int rSTOPTOP = 3;
    public static int rSTOPNOW = 4;
    public static int rSPIN = 5;
    public static int rARCHIVE = 6;
    public static int rRESTART = 7;
    public static int rABORT = 8;
    private static int replayListOffset = -3;
    public static String ptList = "NONE,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    public static int ICE = 1;
    public static int SDDS = 2;
    public static int VRT = 3;
    public static int VRTL = 4;
    public static int VRTW = 5;
    public static int VRTX = 6;
    public static int VRTD = 7;
    public static String pkthdrList = "Strip,Copy,Attach,Detach,Create";
    public static int STRIP = 1;
    public static int COPY = 2;
    public static int ATTACH = 3;
    public static int DETACH = 4;
    public static int CREATE = 5;
    public static String sourceList = "Net,File,RtFile,DevIce";
    public static int NET = 1;
    public static int FILE = 2;
    public static int RTFILE = 3;
    public static int DEVICE = 4;
    private NetIO nio;
    private Data data;
    private DataFile hi;
    private DataFile ho;
    private DataFile hm;
    private Archiver ha;
    private ICEPacket opkh = null;
    private ICEPacket ipkh = new ICEPacket();
    private VRTPacket vpkh = new VRTPacket();
    private SDDSPacket spkh = new SDDSPacket();
    private boolean swap;
    private boolean wrap;
    private boolean net;
    private boolean usenat;
    private boolean check;
    private boolean attach;
    private boolean detach;
    private boolean skipframe;
    private boolean hasMon;
    private int replay;
    private int pt;
    private int bxoff;
    private int bxall;
    private int bxfer;
    private int bpa;
    private int bpe;
    private int errors;
    private int pkthdr;
    private int skip;
    private int iskip;
    private int frame;
    private int nper;
    private int stats;
    private int sbytes;
    private int scyc;
    private int spin;
    private int ispin;
    private int source;
    private int cons;
    private int mcs = 0;
    private int chan = 0;
    private int cena = -1;
    private double done;
    private double todo;
    private double drate;
    private double rtinbyte = 0.0;
    private double rtoutbyte;
    private double rtbufsize;
    private double timer;
    private double timetop;
    private String format;
    private byte[] bdata;
    private Table keys = new Table();
    private Time time = new Time();
    int total = 0;
    int nextseq = -1;

    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "S#,C#", 0);
        this.net = this.hi.getURL().startsWith("udp:");
        this.source = this.MA.getSelectionIndex("/SOURCE", sourceList, this.net ? NET : FILE);
        this.net = this.source == NET || this.source == DEVICE;
        this.format = this.MA.getFormat("FORMAT", "S#,C#");
        this.drate = this.MA.getD("RATE");
        this.pt = this.MA.getState("/SDDS") ? SDDS : ICE;
        this.pt = this.MA.getChoice("/PT", ptList, this.pt + 1) - 1;
        this.check = this.MA.getState("/SEQCHECK");
        this.usenat = this.MA.getState("/NATIVE", true);
        this.hasMon = this.MA.isPresent("/MON");
        this.mcs = this.MA.getL("/MCS", 0);
        this.todo = this.MA.getD("/MAXOUT");
        this.frame = this.MA.getL("/FRAME", 0);
        this.spin = this.MA.getL("/SPIN");
        this.wrap = this.MA.getState("/WRAP");
        this.pkthdr = this.MA.getSelectionIndex("/PKTHDR", pkthdrList, this.mcs > 0 ? CREATE : STRIP);
        if (this.source == NET) {
            this.nio = new NetIO(this.usenat);
            if (this.verbose) {
                this.M.info((CharSequence)("Opening ICE formatted network stream URL=" + this.hi.getURL()));
            }
            if (this.nio.open(this.hi.getURL(), 0, NetIO.INPUT) <= 0) {
                this.M.error("Problem opening ICE formatted network stream URL=" + this.hi.getURL());
            }
            this.ho = this.MA.getDataFile("OUT", "1000", this.format, 0);
            this.bpa = this.hi.bpa;
            this.ho.setXDelta(1.0 / this.drate);
            this.ho.setXUnits(1);
            this.ho.setSize(Math.max(this.todo, (double)(4096 / this.bpa)));
            this.xfer = this.MA.getL("/TL", this.frame > 0 ? 1 : 4096 / this.bpa);
            if (this.frame > 0) {
                this.xfer *= this.frame;
            }
            this.xfer = this.MA.getL("/PKTLEN", this.xfer * this.bpa) / this.bpa;
        } else if (this.source != DEVICE) {
            this.hi.open();
            this.bpa = this.hi.bpa;
            this.drate = this.hi.getRate();
            this.ho = this.MA.getDataFile("OUT", this.hi, 0);
            this.ho.setSize(Math.max(this.todo, this.hi.getSize()));
            PacketHandler packetHandler = this.ho.getPacketHandler();
            if (packetHandler != null) {
                String string = this.ho.getPacket();
                int n = string.indexOf("/DET");
                if (this.pkthdr == STRIP) {
                    this.ho.setPacketHandler(null);
                } else if (this.pkthdr == ATTACH && n >= 0) {
                    this.ho.setPacket(string.substring(0, n));
                } else if (this.pkthdr == DETACH && n < 0) {
                    this.ho.setPacket("/DET");
                }
                if (this.pt == ICE) {
                    this.xfer = ((ICEPacket)packetHandler).getSize();
                }
                if (this.pt >= VRT) {
                    this.xfer = ((VRTPacket)packetHandler).getSize();
                }
                if (this.pt == SDDS) {
                    this.xfer = ((SDDSPacket)packetHandler).getSize();
                }
            } else {
                this.xfer = this.MA.getL("/TL", this.frame > 0 ? 1 : 4096 / this.bpa);
                if (this.frame > 0) {
                    this.xfer *= this.frame;
                }
            }
        }
        this.cons = this.MA.getL("/CL", this.xfer);
        this.setProgressFeed(this.ho, "SOURCEICE " + this.hi.getURL() + " to " + this.ho.getURL());
        if (this.source == RTFILE) {
            this.resyncRTFile(false);
            this.ho.setTime(this.hi.getTimeAt(this.rtoutbyte / (double)this.bpa, null));
        }
        this.skip = 1;
        if (this.frame > 0) {
            double d = this.MA.getD("/MONRATE", 10.0);
            this.skip = (int)(this.drate / ((double)this.frame * d));
            this.skip = this.MA.getL("/SKIP", this.skip);
            this.ho.setFS(this.frame);
            this.ho.setYUnits(1);
            this.ho.setYDelta((double)this.frame / this.drate);
        }
        if (this.pkthdr == CREATE) {
            int n = 3;
            this.opkh = new ICEPacket(this.format, this.xfer, n);
            this.ho.setPacketHandler((PacketHandler)this.opkh);
        }
        if (this.skip > 1 && !this.hasMon) {
            this.ho.setYDelta((double)(this.skip * this.frame) / this.drate);
        }
        this.ho.open(64);
        this.ho.setDFS(0);
        this.hm = this.MA.getDataFile("/MON", this.ho, 0);
        if (this.skip > 1 && this.hasMon) {
            this.hm.setYDelta((double)(this.skip * this.frame) / this.drate);
        }
        this.hm.open(64);
        this.hm.setDFS(0);
        if (this.pt == SDDS) {
            this.bxoff = 56;
            this.xfer = 1024 / this.bpa;
        } else if (this.pt == ICE) {
            this.bxoff = 64;
        } else if (this.pt == VRT) {
            this.M.error("VRT with trailer not supported");
        } else {
            this.bxoff = this.pt > VRT ? (this.pt == VRTD ? 28 : 24) : 0;
        }
        this.bpe = this.bpa * this.xfer;
        this.bxall = this.bxoff + this.bpe;
        this.data = this.hm.getDataBuffer(this.bxall / this.bpa);
        this.bdata = this.data.buf;
        this.swap = this.MA.getState("/SWAP", this.pt == SDDS && this.bpa >= 2);
        this.nper = this.frame > 0 ? this.frame / this.xfer : 1;
        this.skip *= this.nper;
        this.iskip = -1;
        this.skipframe = this.skip > 1 || this.frame > 0;
        this.replay = this.M.pipeMode == 1 ? rCONTINUOUS : rFILE;
        this.replay = this.MA.getSelectionIndex("/REPLAY", replayList, this.replay, replayListOffset);
        this.time.fromCurrent();
        this.startArchiver();
        this.stats = this.MA.getL("/STATS");
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int process() {
        int n = 0;
        int n2 = 0;
        if (this.replay == rABORT) {
            return 9;
        }
        if (this.replay == rSTOPPED) {
            return -1;
        }
        if (this.source == NET) {
            n = this.pkthdr == STRIP ? this.bxoff : 0;
            n2 = this.nio.recv(0, this.bdata, 0, this.bxall, 0);
        } else if (this.source == RTFILE) {
            if (this.rtoutbyte + (double)this.bpe > this.rtinbyte) {
                this.hi.ioh.read(this.hi.hb, 0, 512, 0L);
                this.rtinbyte = this.hi.getInByte();
                if (this.rtoutbyte + (double)this.bpe > this.rtinbyte) {
                    return -1;
                }
            }
            double d = this.rtoutbyte % this.rtbufsize / (double)this.bpa;
            n2 = this.hi.read(this.data, d, this.xfer);
            if (this.cons > this.xfer) {
                n2 = this.xfer;
                this.rtoutbyte += (double)(this.cons * this.bpa);
            } else {
                this.rtoutbyte += (double)(n2 * this.bpa);
            }
        } else {
            n2 = this.hi.read(this.data, this.xfer);
        }
        if (n2 > 0) {
            boolean bl;
            this.sbytes += n2;
            this.ispin = this.spin;
            if (this.check) {
                this.checkPacket();
            }
            if (this.mcs > 0) {
                int n3 = this.getMCSchn(this.bdata);
                if ((1 << n3 - 1 & this.cena) == 0) {
                    return 0;
                }
                this.opkh.setChannel(n3);
            }
            if (this.swap) {
                Convert.swap2((byte[])this.bdata, (int)64, (int)512);
            }
            if (this.ha != null) {
                if (!this.net) {
                    this.ha.setPktHeader((ICEPacket)this.hi.getPacketHandler());
                }
                this.ha.write(0L, this.bdata, 0, n2, 0);
            }
            if (++this.iskip >= this.skip) {
                this.iskip = 0;
            }
            boolean bl2 = bl = this.skipframe && this.iskip >= this.nper;
            if (this.hm.isOpen && !bl) {
                this.hm.write(this.data, n2);
            }
            if (this.ho.isOpen && (this.hasMon || !bl)) {
                if (this.net) {
                    this.ho.write(this.bdata, n, n2 - n);
                } else {
                    this.ho.write(this.data, n2);
                }
            }
        } else if (n2 < 0) {
            if (!this.wrap) return 9;
            this.hi.seek(0.0);
        } else {
            if (this.spin <= 0 || --this.ispin >= 0) return -1;
            return -1;
        }
        this.done += (double)this.xfer;
        this.timer = Time.current();
        if (this.stats > 0 && this.timer - this.timetop > (double)this.stats) {
            float f = (float)(1.0E-6 * (double)this.sbytes / Math.max(0.01, this.timer - this.timetop));
            this.M.info((CharSequence)("SourceIce STATS={CYC=" + this.scyc + ",MBPS=" + f + ",SEQERR=" + this.errors + "}"));
            this.timetop = this.timer;
            this.sbytes = 0;
            ++this.scyc;
        }
        if (!(this.todo > 0.0) || !(this.done > this.todo)) return 0;
        return 9;
    }

    public int close() {
        if (this.nio != null) {
            this.nio.close();
        }
        this.hi.close();
        this.hm.close();
        this.ho.close();
        if (this.ha != null) {
            this.ha.close();
        }
        if (this.check) {
            this.M.info((CharSequence)("Transfer addr=" + this.hi.getURL() + " size=" + this.done + " errors=" + this.errors));
        }
        return 0;
    }

    public void setReplay(String string) {
        int n;
        if (string.equalsIgnoreCase("STOP")) {
            string = "STOPNOW";
        }
        if (string.equalsIgnoreCase("START")) {
            string = "CONTINUOUS";
        }
        if ((n = Parser.find((String)replayList, (String)string, (int)this.replay, (int)replayListOffset)) > replayListOffset) {
            this.setReplay(n);
        } else {
            this.M.warning((CharSequence)("Illegal replay mode: " + string));
        }
    }

    private void setReplay(int n) {
        if (n == this.replay) {
            return;
        }
        this.replay = n == 0 && this.replay != 0 ? rSTOPNOW : (n == rRESTART && this.replay == 0 ? rCONTINUOUS : (n == rONESHOT && this.replay == rCONTINUOUS ? rSTOPTOP : n));
        if (n == rCONTINUOUS || n == rONESHOT) {
            this.timetop = Time.current();
            if (this.source == RTFILE) {
                this.resyncRTFile(true);
            }
        }
        if (n == rCONTINUOUS && this.stats > 0) {
            this.M.info((CharSequence)"SourceIce START");
        }
        if (n == rSTOPNOW && this.stats > 0) {
            this.M.info((CharSequence)"SourceIce STOP");
        }
        if (this.replay == rSTOPNOW || this.replay == rSTOPTOP) {
            this.replay = rSTOPPED;
        }
    }

    private String getReplay(int n) {
        return Parser.get((String)replayList, (int)(n - replayListOffset));
    }

    public String getReplay() {
        return this.getReplay(this.replay);
    }

    public int getCycle() {
        return 0;
    }

    public double getOffset() {
        return this.ha.isOpen ? this.ha.getOffset() : this.ho.getOffset();
    }

    private void resyncRTFile(boolean bl) {
        if (bl) {
            this.hi.ioh.read(this.hi.hb, 0, 512, 0L);
        }
        this.rtinbyte = this.hi.getInByte();
        this.rtbufsize = this.hi.getDataSize();
        this.rtoutbyte = Math.round(this.rtinbyte / (double)this.bpe) * (long)this.bpe;
    }

    private void checkPacket() {
        int n;
        if (this.pt == SDDS) {
            this.spkh.setBuffer(this.bdata, 0);
            n = this.spkh.getCount();
        } else if (this.pt >= VRT) {
            this.vpkh.setBuffer(this.bdata, 0);
            n = this.vpkh.getCount();
        } else {
            this.ipkh.setBuffer(this.bdata, 0);
            n = this.ipkh.getCount();
        }
        if (this.nextseq > 0 && n != this.nextseq && ++this.errors < 20) {
            this.M.warning((CharSequence)("Sequence gap curr=" + n + " next=" + this.nextseq));
        }
        if (++this.total % 100 == 0 && this.stats <= 0) {
            this.M.info((CharSequence)("Packet total=" + this.total + " samples=" + this.total * this.xfer));
        }
        this.nextseq = n + 1;
        if (this.pt == SDDS) {
            if ((this.nextseq & 0x1F) == 31) {
                ++this.nextseq;
            }
            this.nextseq &= 0xFFFF;
        } else if (this.pt >= VRT) {
            this.nextseq &= 0xF;
        }
    }

    public void setGain(int n) {
    }

    private int getMCSchn(byte[] byArray) {
        int n = ((byArray[0] & 1) << 0) + ((byArray[2] & 1) << 1) + ((byArray[4] & 1) << 2) + ((byArray[6] & 1) << 3);
        if (++n > this.mcs) {
            n = this.mcs;
        }
        return n;
    }

    public void setChan(int n) {
        this.chan = n;
    }

    public void setEnable(int n) {
        int n2 = 1 << this.chan - 1;
        this.cena = n == 0 ? (this.cena &= ~n2) : (this.cena |= n2);
    }

    private void startArchiver() {
        String string = this.MA.getS("/ARCH");
        int n = this.MA.getL("/NCHAN", 0);
        if (StringUtil.isNullOrEmpty((Object)string)) {
            return;
        }
        ICEPacket iCEPacket = new ICEPacket(this.ho.getFormat(), this.xfer, 0);
        this.ha = new Archiver();
        this.ha.init((MidasReference)this, string, this.ho, 0);
        this.ha.setPacketHandler(iCEPacket);
        this.ha.setNChan(n);
        this.ha.setFS(0);
        this.ha.open(0x80 | 0x40);
        if (!this.ha.isOpen) {
            this.ha = null;
        }
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public Object setKey(String string, Object object) {
        if (!this.thisIsMe()) {
            this.MQ.put("SET." + string, 0, object);
        } else if (string.equals("REPLAY")) {
            this.setReplay(Convert.o2s((Object)object));
        } else if (!(string.equals("VLAN") || string.equals("IPVLAN") || string.equals("JOIN") || string.equals("IPCONN"))) {
            return null;
        }
        return object;
    }

    public Object getKey(String string) {
        if (string.equals("TIME")) {
            return this.time;
        }
        if (string.equals("CYCLE")) {
            return new Data(0);
        }
        if (string.equals("STATUS")) {
            return new Data(this.replay);
        }
        return null;
    }
}

