/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.io.File;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.MDevIce;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.WidgetPanel;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Logger;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidget;

public class iceutil
extends Primitive {
    public static Logger logger;
    private static String[] rowlabel;
    String outline = "";
    static double e2m;
    static String form;
    int evalcrc;

    public int open() {
        String string = this.MA.getU("FUNC");
        if (this.verbose) {
            this.M.info((CharSequence)("IceUtil f=" + string + " p1=" + this.MA.getCS("P1") + " p2=" + this.MA.getCS("P2")));
        }
        if (string.equals("GC")) {
            System.gc();
        } else if (string.equals("TTF2M")) {
            this.ttf2m();
        } else if (string.equals("BIT2M")) {
            this.bit2m();
        } else if (string.equals("FSTATS")) {
            this.fstats();
        } else if (string.equals("TSTATS")) {
            this.tstats();
        } else if (string.equals("DSTATS")) {
            this.dstats();
        } else if (string.equals("RBF2M")) {
            this.rbf2m();
        } else if (string.equals("ELF2M")) {
            this.elf2m();
        } else if (string.equals("STR2IP")) {
            this.str2ip();
        } else if (string.equals("IPX2IP")) {
            this.ipx2ip();
        } else if (string.equals("SETKEYS")) {
            this.setkeys();
        } else if (string.equals("MASK")) {
            this.mask();
        } else if (string.equals("CARETS")) {
            this.carets();
        } else if (string.equals("BUTTON")) {
            this.button();
        } else if (string.equals("RUN")) {
            this.runit();
        } else if (string.equals("JVM2XBR")) {
            this.jvm2xbr();
        } else if (string.equals("M2XBR")) {
            this.m2xbr();
        } else if (string.equals("M2VBR")) {
            this.m2vbr();
        } else if (string.equals("M2MIF")) {
            this.m2mif();
        } else if (string.equals("MBTST")) {
            this.mbtst();
        } else if (string.equals("JTAG2M")) {
            this.jtag2m();
        } else if (string.equals("LST2CSP")) {
            this.lst2csp();
        } else if (string.equals("SYM2PART")) {
            this.sym2part();
        } else if (string.equals("NET2UCF")) {
            this.net2ucf();
        } else if (string.equals("ENET2UCF")) {
            this.enet2ucf();
        } else if (string.equals("QNET2UCF")) {
            this.qnet2ucf();
        } else if (string.equals("VPP")) {
            this.vppflow();
        } else if (string.equals("TPP")) {
            this.tppflow();
        } else if (string.equals("UCF2XDC")) {
            this.ucf2xdc();
        } else if (string.equals("GERBER")) {
            this.gerber();
        } else if (string.equals("CRCGEN")) {
            this.crcgen();
        } else if (string.equals("MODARGS")) {
            this.modargs();
        } else if (string.equals("COMPRESS")) {
            this.compress(1);
        } else if (string.equals("UNCOMPRESS")) {
            this.compress(-1);
        } else if (string.equals("GETID")) {
            this.getid();
        } else if (string.equals("GREP")) {
            this.grep();
        } else if (string.equals("REPTBL")) {
            this.reptbl();
        } else if (string.equals("LOGGER")) {
            this.logger();
        } else if (string.equals("GETFILE")) {
            this.getfile();
        } else if (string.equals("DBGFILE")) {
            this.dbgfile();
        } else if (string.equals("TPUT")) {
            this.tput();
        } else if (string.equals("SCANUP")) {
            this.scanup();
        } else if (string.equals("GREPLOG")) {
            this.greplog();
        } else if (string.equals("KVI")) {
            this.kvi();
        } else {
            this.M.error("Unsupported function: " + string);
        }
        return 9;
    }

    private void getfile() {
        String string = this.MA.getCS("P1");
        File file = new File(string);
        if (file.exists()) {
            System.out.println("Exists " + new File(string).exists());
        } else {
            System.out.println("NExists " + string);
        }
    }

    private void logger() {
        String string = this.MA.getS("P1");
        if (string.equals("PAUSE")) {
            logger = this.M.setLogger(null);
        }
        if (string.equals("RESUME")) {
            this.M.setLogger(logger);
        }
    }

    private void mask() {
        String string = this.MA.getS("P1");
        String string2 = this.MA.getS("P2");
        String string3 = this.MA.getU("P3");
        this.MR.put(string3, Parser.mask((String)string, (String)string2, (int)0));
    }

    private void carets() {
        String string = this.MA.getS("P1");
        String string2 = this.MA.getU("P2");
        this.MR.put(string2, (Object)this.MA.evaluateCarets(string));
    }

    private void reptbl() {
        Table table = this.MA.getTable("P1");
        String string = this.MA.getS("P2");
        table.clear();
        table.append(string);
    }

    private void button() {
        String string = this.MA.getCS("P1");
        String string2 = this.MA.getCS("P2");
        int n = 2294273;
        GMenu gMenu = new GMenu(null, "", string2, 0, n, (MessageHandler)this.M.macro);
        gMenu.setMidas(this.M);
        gMenu.setLabel(string);
        WidgetPanel widgetPanel = (WidgetPanel)this.M.registry.get("PANEL");
        widgetPanel.addWidget((GWidget)gMenu);
    }

    private void runit() {
        String string = this.MA.getRawArgs().trim().substring(4);
        Shell.runCommand((Midas)this.M, (String)string);
    }

    private void setkeys() {
        Object object = this.MA.getO("P1");
        Table table = this.MA.getTable("P2");
        KeyObject.setKeys((Object)object, (Table)table);
    }

    private void dbgfile() {
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "SL", 0);
        dataFile.open(1);
        Data data = dataFile.getDataBuffer(4);
        int n = this.MA.getL("/TRIG", 20);
        int n2 = this.MA.getL("/WIND", 10);
        boolean bl = this.MA.getState("/TOTALS");
        boolean bl2 = this.MA.getState("/COMPS");
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while ((double)n9 < dataFile.getSize()) {
            int n10;
            dataFile.read(data);
            int n11 = data.getL(0);
            int n12 = data.getL(1);
            int n13 = data.getL(2);
            int n14 = data.getL(3);
            if (n8 == 0) {
                n8 = n14;
            }
            int n15 = n14 - n8 >> 4 & 0xFFFFFFF;
            n6 += n15;
            if (n15 > n && !bl2) {
                if (n3 < 0) {
                    System.out.printf("... wtot %d    rtot %d    ttot %d   pass %d ...\n", n4, n5, n6, n7);
                }
                if (n3 < 0) {
                    n6 = 0;
                    n4 = 0;
                    n5 = 0;
                    ++n7;
                }
                n3 = n2;
            }
            int n16 = -1;
            String string = null;
            String string2 = "     ";
            if ((n14 & 1) != 0) {
                n16 = n13 >> 11 & 0x1F;
                string = n16 == 0 ? "mrd" : (n16 == 1 ? "mwr" : (n16 == 12 ? "msg" : null));
                n10 = (n13 & 0x7FF) * 4;
                if (n12 == 2048) {
                    string2 = "cque0";
                }
                if (n12 == 2304) {
                    string2 = "cque1";
                }
                if (n12 == 2560) {
                    string2 = "sque0";
                }
                if (n12 == 3072) {
                    string2 = "sque1";
                }
                if (n12 == 4096) {
                    string2 = "bram ";
                }
                if (n12 == 8192) {
                    string2 = "xmem ";
                }
                if (n12 == 8192 && n16 == 1) {
                    n4 += n10;
                }
                if (n12 == 8192 && n16 == 0) {
                    n5 += n10;
                }
                if (n12 == 2304 && bl2) {
                    System.out.printf("Comp ... wtot %d    rtot %d    ttot %d   pass %d ...\n", n4, n5, n6, n7);
                    n6 = 0;
                    n4 = 0;
                    n5 = 0;
                    ++n7;
                }
            } else {
                string = "cpl";
                n10 = (n12 & 0x3FF) * 4;
            }
            if (string == null) {
                System.out.printf("Dbg [ %08x %08x %08x %08x ]   unknown Op\n", n11, n12, n13, n14);
            }
            if (n3 > 0 && !bl) {
                System.out.printf("Dbg [ %08x %08x %08x %08x ]    %s   %s   %4d   %d\n", n11, n12, n13, n14, string, string2, n10, n15);
            }
            --n3;
            n8 = n14;
            n9 += 4;
        }
        dataFile.close();
    }

    private void ttf2m() {
        String string;
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("ttf");
        textFile.open(1);
        DataFile dataFile = this.MA.getDataFile("P2", "1000", "SB", 0);
        dataFile.setComment("ICEPIC IOC Load Program");
        dataFile.open(2);
        byte[] byArray = new byte[128];
        while ((string = textFile.read()) != null) {
            int n = (string.length() + 1) / 4;
            if (n > 128) {
                this.M.error("Bad TTF line length");
            }
            for (int i = 0; i < n; ++i) {
                int n2 = Convert.s2l((String)string.substring(i * 4, i * 4 + 3));
                byArray[i] = n2 > 127 ? (byte)(n2 - 256) : (byte)n2;
            }
            dataFile.write(byArray, 0, n);
        }
        textFile.close();
        dataFile.close();
    }

    private boolean chk(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void dstats() {
        String string = this.MA.getS("P1");
        String string2 = this.MA.getU("P2");
        String string3 = this.M.io.getAuxPath(string);
        try {
            IOResource iOResource = IOResource.getInstance((Midas)this.M, (int)0, (String)string3, (int)0, null);
            Table table = iOResource.getStatFS();
            this.MR.put(string2, (Object)table);
        }
        catch (Exception exception) {
            this.M.warning((CharSequence)("Unable to get disk statistics for AUX=" + string + " at path=" + string3 + " cause=" + exception.getMessage()));
        }
    }

    private void fstats() {
        DataFile dataFile = this.MA.getDataFile("P1");
        dataFile.setExt("mlog");
        dataFile.open(1);
        int n = (int)dataFile.getSize();
        DataFile dataFile2 = this.MA.getDataFile("P2", "3000", "NH", 0, 0.0, null);
        dataFile2.setSubRecords("FAVG|SL,FMIN|SL,FMAX|SL");
        Data data = dataFile2.getDataBuffer(1);
        dataFile2.open(2);
        String string = this.MA.getS("P3");
        for (int i = 0; i < n; ++i) {
            int n2;
            Table table = dataFile.getDataTable((double)i);
            if (table == null) continue;
            String string2 = table.getS("FROM");
            String string3 = table.getS("TYPE");
            String string4 = table.getS("TEXT");
            if (string2 == null || !string2.equals(string) || !string3.equals("INFO") || (n2 = string4.indexOf("STATS=")) <= 0) continue;
            boolean bl = string4.indexOf("FMIN=") > 0;
            Table table2 = new Table(string4.substring(n2 + 6));
            int n3 = table2.getL("FAVG");
            int n4 = bl ? table2.getL("FMIN") : n3;
            int n5 = bl ? table2.getL("FMAX") : n3;
            data.packL(0, n3);
            data.packL(4, n4);
            data.packL(8, n5);
            dataFile2.write(data);
        }
        dataFile.close();
        dataFile2.close();
    }

    private byte getTemp(String string, String string2) {
        int n = string.indexOf(string2 + "=");
        if (n < 0) {
            return -1;
        }
        int n2 = (string = string.substring(n + string2.length() + 1)).indexOf(" ");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        return (byte)Convert.s2l((String)string);
    }

    private void tstats() {
        DataFile dataFile = this.MA.getDataFile("P1");
        dataFile.setExt("mlog");
        dataFile.open(1);
        int n = (int)dataFile.getSize();
        DataFile dataFile2 = this.MA.getDataFile("P2", "3000", "NH", 0, 0.0, null);
        dataFile2.setSubRecords("XBAR|SB,IOM1|SB,PM1|SB,PM2|SB,ARX|SB");
        Data data = dataFile2.getDataBuffer(1);
        dataFile2.open(2);
        String string = this.MA.getS("P3");
        double d = 0.0;
        double d2 = 60.0;
        for (int i = 0; i < n; ++i) {
            Table table = dataFile.getDataTable((double)i);
            if (table == null) continue;
            if (d == 0.0) {
                d = table.getD("TIME");
            }
            String string2 = table.getS("FROM");
            String string3 = table.getS("TYPE");
            String string4 = table.getS("TEXT");
            if (!string3.equals("INFO")) continue;
            int n2 = string4.indexOf("Temps:");
            if (n2 > 0) {
                data.buf[0] = this.getTemp(string4, "XBar");
                data.buf[1] = this.getTemp(string4, "IOM1");
                data.buf[2] = this.getTemp(string4, "PM1");
                data.buf[3] = this.getTemp(string4, "PM2");
            }
            if ((n2 = string4.indexOf("AR26=")) <= 0) continue;
            data.buf[4] = this.getTemp(string4, "Temp1");
            dataFile2.write(data);
        }
        dataFile2.setXStart(d);
        dataFile2.setXDelta(d2);
        dataFile2.setXUnits(1);
        dataFile.close();
        dataFile2.close();
    }

    private void bit2m() {
        int n;
        int n2;
        int n3;
        BaseFile baseFile = this.MA.getBaseFile("P1");
        baseFile.setExt("bit");
        baseFile.open(1);
        int n4 = (int)baseFile.getSize();
        int n5 = this.MA.getL("/FLASH");
        int n6 = this.MA.getL("/NOSYNC");
        byte[] byArray = new byte[n4 + 16];
        byte[] byArray2 = new byte[]{-1, -1, -1, -1, -86, -103, 85, 102};
        if (n6 >= 0) {
            baseFile.read(byArray, 0, n4);
            baseFile.close();
        } else {
            n3 = 0;
            while (true) {
                for (n2 = 0; n2 < 7; ++n2) {
                    byArray[n2] = byArray[n2 + 1];
                }
                byArray[7] = baseFile.readByte();
                --n4;
                if (this.chk(byArray, byArray2, 8)) break;
                if (n3 > 256) {
                    this.M.error("No sync found");
                }
                ++n3;
            }
            baseFile.read(byArray, 8, n4 -= 4);
            n4 += 8;
            baseFile.close();
        }
        n3 = n4 / 4;
        if (n6 < 0) {
            Convert.swap4((byte[])byArray, (int)0, (int)n3);
        }
        while (n3 % 4 != 0) {
            System.arraycopy(byArray, n4 - 4, byArray, n4, 4);
            ++n3;
            n4 += 4;
        }
        n2 = 0;
        for (n = 0; n < n4; n += 4) {
            n2 = this.crc32(n2, Convert.unpackL((byte[])byArray, (int)n), 32);
        }
        for (n = n4; n < n5; n += 4) {
            n2 = this.crc32(n2, -1, 32);
        }
        DataFile dataFile = this.MA.getDataFile("P2", "1000", "SL", 0, (double)n3, null);
        dataFile.setComment("ICE XILINX FPGA Load Program");
        dataFile.keywords.putMain("CRC", Convert.l2x((int)n2), false);
        dataFile.open(2);
        dataFile.write(byArray, 0, n4);
        dataFile.close();
    }

    private void compress(int n) {
        int n2;
        byte[] byArray;
        MDevIce mDevIce = new MDevIce();
        mDevIce.load();
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "SB,SL", 0);
        dataFile.open();
        DataFile dataFile2 = this.MA.getDataFile("P2", dataFile, 0);
        dataFile2.open();
        int n3 = (int)(dataFile.size * dataFile.getBPE());
        byte[] byArray2 = new byte[n3];
        dataFile.read(byArray2, 0, n3);
        dataFile.close();
        if (n > 0) {
            int n4 = n3 + 512;
            byte[] byArray3 = new byte[n4];
            byArray = byArray2;
            int n5 = mDevIce.compress(byArray2, n3, byArray3, n4, 1);
            n2 = mDevIce.compress(byArray3, n5, byArray, n4, 1);
            dataFile2.keywords.putMain("ICSZ", "" + n3, false);
            dataFile2.keywords.putMain("ICSZM", "" + n5, false);
            String string = dataFile2.keywords.getMain("CRC");
            int n6 = dataFile2.keywords.getL("CRC", 0);
            if (string == null && n6 != 0) {
                dataFile2.keywords.delete("CRC");
                dataFile2.keywords.putMain("CRC", Convert.l2x((int)n6), false);
            }
            dataFile2.setFormat("SB");
        } else {
            n2 = dataFile2.keywords.getL("ICSZ", 0);
            int n7 = dataFile2.keywords.getL("ICSZM", 0);
            int n8 = n2 + 512;
            byte[] byArray4 = new byte[n8];
            byArray = new byte[n8];
            mDevIce.compress(byArray2, n3, byArray4, n7, -1);
            mDevIce.compress(byArray4, n7, byArray, n2, -1);
            dataFile2.keywords.deleteMain("ICSZ");
            dataFile2.keywords.deleteMain("ICSZM");
            String string = dataFile2.getComment();
            if (string.indexOf("XILINX") > 0) {
                dataFile2.setFormat("SL");
            }
        }
        dataFile2.write(byArray, 0, n2);
        dataFile2.close();
    }

    private int crc32(int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = (n2 >> i ^ n >> 31) & 1;
            n = n << 1 & 0xFFFFFFFE | n4;
            if (n4 == 0) continue;
            n ^= 0xEDB88320;
        }
        return n;
    }

    private int crc32r(int n, int n2, int n3) {
        for (int i = n3; i >= 0; --i) {
            int n4 = (n2 >> i ^ n >> 31) & 1;
            n = n << 1 & 0xFFFFFFFE | n4;
            if (n4 == 0) continue;
            n ^= 0xEDB88320;
        }
        return n;
    }

    private void rbf2m() {
        int n;
        int n2;
        BaseFile baseFile = this.MA.getBaseFile("P1");
        int n3 = 64448;
        int n4 = this.MA.getL("P3");
        baseFile.setExt("rbf");
        baseFile.open(1);
        byte[] byArray = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = -1;
        }
        int n5 = n2 = n4 == 1 ? 22 : 0;
        int n6 = n4 == 2 ? 1048 : (n4 == 4 ? 396 : (n = n4 == 5 ? 32768 : 0));
        int n7 = n4 == 2 ? 4 : (n4 == 3 ? 1094 : (n4 == 4 ? 16 : 0));
        System.out.println("Padding for Stratix type=" + n4 + " word=" + n2 + " front=" + n + " back=" + n7);
        int n8 = (int)baseFile.getSize();
        int n9 = n8 + 3 & 0xFFFFFFFC;
        int n10 = n9 - n8;
        byte[] byArray2 = new byte[n8];
        baseFile.read(byArray2, 0, n8);
        baseFile.close();
        DataFile dataFile = this.MA.getDataFile("P2", "1000", "SB", 0, (double)n9, null);
        dataFile.setComment("ALTERA FPGA Load Program");
        dataFile.keywords.putMain("CRC", Convert.l2x((int)0), false);
        dataFile.open(2);
        dataFile.write(byArray, 0, n);
        dataFile.write(byArray, 0, n10 + n2);
        dataFile.write(byArray2, 0, n8);
        if (n4 == 2) {
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[0] = 0;
            byArray[1] = 4;
        }
        dataFile.write(byArray, 0, n7);
        dataFile.close();
    }

    private void elf2m() {
        BaseFile baseFile = this.MA.getBaseFile("P1");
        baseFile.setExt("elf");
        baseFile.open(1);
        int n = (int)baseFile.getSize();
        byte[] byArray = new byte[n];
        baseFile.read(byArray, 0, n);
        baseFile.close();
        DataFile dataFile = this.MA.getDataFile("P2", "1000", "SB", 0, (double)n, null);
        dataFile.setComment("ICE XILINX PPC Load Program");
        dataFile.open(2);
        dataFile.write(byArray, 0, n);
        dataFile.close();
        byte[] byArray2 = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            byArray2[i] = 0;
        }
        byte[] byArray3 = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            byArray3[i] = 0;
        }
        Convert.swap4((byte[])byArray, (int)20, (int)5);
        Convert.swap2((byte[])byArray, (int)40, (int)6);
        String string = Convert.unpackS((byte[])byArray, (int)0, (int)16);
        int n2 = Convert.unpackI((byte[])byArray, (int)44);
        int n3 = Convert.unpackL((byte[])byArray, (int)28);
        short s = Convert.unpackI((byte[])byArray, (int)42);
        this.M.info((CharSequence)("Ident=" + string + " PSECs=" + n2 + " Off=" + n3 + " Size=" + s));
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 + i * s;
            Convert.swap4((byte[])byArray, (int)n4, (int)8);
            int n5 = Convert.unpackL((byte[])byArray, (int)(n4 + 8));
            int n6 = Convert.unpackL((byte[])byArray, (int)(n4 + 16));
            int n7 = Convert.unpackL((byte[])byArray, (int)(n4 + 20));
            int n8 = Convert.unpackL((byte[])byArray, (int)(n4 + 4));
            this.M.info((CharSequence)("Sec=" + i + " Vaddr=" + Convert.l2x((int)n5) + " Offst=" + Convert.l2x((int)n8) + " FilSz=" + Convert.l2x((int)n6) + " MemSz=" + Convert.l2x((int)n7)));
            if ((n5 & 0xFFFF0000) == -65536) {
                System.arraycopy(byArray, n8, byArray3, n5 & 0xFFF, n6);
            }
            if ((n5 & 0xFFFF0000) != -50331648) continue;
            System.arraycopy(byArray, n8, byArray2, n5 & 0xFFF, n6);
        }
        this.writeRamInit("nxm.ice.xfer.ppccode.h", byArray3, 0, 4096, 3, 2, 4);
        this.writeRamInit("nxm.ice.xfer.ppcdata.h", byArray2, 0, 4096, 1, 2, 2);
        this.writeMemInit("nxm.ice.xfer.ppccode.mem", byArray3, 0, 4096, -4096);
        this.writeMemInit("nxm.ice.xfer.ppcdata.mem", byArray2, 0, 4096, -50331648);
    }

    private void mbtst() {
        int n;
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "SB,SI,SL", 0);
        dataFile.open();
        int n2 = (int)dataFile.getSize();
        Data data = dataFile.getDataBuffer(n2);
        dataFile.read(data);
        dataFile.close();
        int n3 = dataFile.getBPA() * 8;
        int[] nArray = new int[32];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (n3 == 8) {
                n4 = data.getB(n);
            }
            if (n3 == 16) {
                n4 = data.getI(n);
            }
            if (n3 == 32) {
                n4 = data.getL(n);
            }
            int n5 = 0;
            int n6 = 1;
            while (n5 < 16) {
                if ((n4 & n6) != 0) {
                    int n7 = n5;
                    nArray[n7] = nArray[n7] + 1;
                }
                ++n5;
                n6 <<= 1;
            }
        }
        this.MT.writeln((CharSequence)("Analysis of " + n2 + " samples from URL=" + dataFile.getURL()));
        for (n = 0; n < n3; ++n) {
            float f = (float)nArray[n] / (float)n2;
            this.MT.writeln((CharSequence)("Bit Number=" + n + " Average=" + f));
        }
    }

    private void str2ip() {
        String string = this.MA.getS("P1");
        String string2 = this.MA.getU("P2");
        String string3 = this.MA.getU("P3");
        String string4 = "";
        int n = string.indexOf(":");
        if (n > 0) {
            string = string.substring(0, n);
        }
        int n2 = string.indexOf(".");
        string4 = string4 + Convert.l2x((int)Convert.s2l((String)string.substring(0, n2))).substring(8);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(".");
        string4 = string4 + Convert.l2x((int)Convert.s2l((String)string.substring(0, n2))).substring(8);
        string = string.substring(n2 + 1);
        n2 = string.indexOf(".");
        string4 = string4 + Convert.l2x((int)Convert.s2l((String)string.substring(0, n2))).substring(8);
        string = string.substring(n2 + 1);
        string4 = string4 + Convert.l2x((int)Convert.s2l((String)string)).substring(8);
        this.MR.put(string2, (Object)string4);
        this.MR.put(string3, (Object)("1c:e0:" + string4.substring(0, 2) + ":" + string4.substring(2, 4) + ":" + string4.substring(4, 6) + ":" + string4.substring(6, 8)));
    }

    private void ipx2ip() {
        int n;
        String string = this.MA.getS("P1");
        int n2 = this.MA.getL("P2");
        String string2 = this.MA.getU("P3");
        String string3 = string;
        int n3 = string.indexOf("X");
        int n4 = n = n3 > 0 ? (int)string.charAt(n3 - 1) : 46;
        if (n3 >= 0) {
            if (n == 43 || n == 124) {
                int n5;
                for (n5 = n3 - 2; n5 >= 0 && string.charAt(n5) != '.'; --n5) {
                }
                int n6 = Convert.s2l((String)string.substring(n5 + 1, n3 - 1));
                if (n == 43) {
                    n6 += n2;
                }
                if (n == 124) {
                    n6 |= n2;
                }
                string3 = string.substring(0, n5 + 1) + n6 + string.substring(n3 + 1);
            } else {
                string3 = string.replaceAll("X", "" + n2);
            }
        }
        this.MR.put(string2, (Object)string3);
    }

    private void m2xbr() {
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        dataFile.open();
        int n = (int)dataFile.getDataSize();
        byte[] byArray = new byte[n];
        dataFile.read(byArray, 0, n);
        dataFile.close();
        boolean bl = this.MA.getState("/ENUM");
        boolean bl2 = this.MA.getState("/ENUM2");
        boolean bl3 = this.MA.getState("/SPECIAL");
        String string = this.MA.getCS("/PREFIX");
        string = StringUtil.isNullOrEmpty((Object)string) ? "" : string + ".";
        TextFile textFile = this.MA.getTextFile("P2");
        textFile.open(2);
        int n2 = this.MA.getL("/BANKS", 1);
        int n3 = this.MA.getL("/BPA", dataFile.bpa);
        int n4 = n3 * 2 / n2;
        int n5 = n2 * 256 / 8;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n) {
            String string2 = Convert.l2x((int)n7).substring(8);
            String string3 = Convert.bb2hex((byte[])byArray, (int)n6, (int)n5);
            for (int i = 0; i < n2; ++i) {
                String string4 = "";
                int n8 = 0;
                for (int j = i * n4; j < n5 * 2; j += n2 * n4) {
                    int n9 = 2 + n5 * 2 - j - n4;
                    if (n8 > 0 && n8 % 8 == 0) {
                        string4 = "_" + string4;
                    }
                    string4 = string3.substring(n9, n9 + n4) + string4;
                    n8 += n4;
                }
                if (bl) {
                    textFile.writeln("defparam " + string + "dpw[" + i + "].sdr.inst.ram.INIT_" + string2 + " = 256'h" + string4 + ";");
                    continue;
                }
                if (bl2) {
                    textFile.writeln("defparam " + string + "ram" + i + ".INIT_" + string2 + " = 256'h" + string4 + ";");
                    continue;
                }
                if (bl3) {
                    textFile.writeln("defparam " + string + "INIT_" + string2 + " = 256'h" + string4 + ";");
                    continue;
                }
                textFile.writeln("defparam " + string + "ram" + i + ".INIT_" + string2 + " = 256'h" + string4 + ";");
            }
            n6 += n5;
            ++n7;
        }
        textFile.close();
    }

    private void m2vbr() {
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        dataFile.open();
        int n = (int)dataFile.getDataSize();
        byte[] byArray = new byte[n];
        dataFile.read(byArray, 0, n);
        dataFile.close();
        String string = this.MA.getCS("/RAM", "ram");
        TextFile textFile = this.MA.getTextFile("P2");
        textFile.open(2);
        int n2 = this.MA.getL("/BPA", dataFile.bpa);
        int n3 = n2 * 8;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            String string2 = "  assign " + string + "[" + n5 + "] = " + n3 + "'h";
            string2 = string2 + Convert.bb2hex((byte[])byArray, (int)n4, (int)n2).substring(2);
            textFile.writeln(string2 + ";");
            n4 += n2;
            ++n5;
        }
        textFile.close();
    }

    private void m2mif() {
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        dataFile.open();
        int n = (int)dataFile.getDataSize();
        byte[] byArray = new byte[n];
        dataFile.read(byArray, 0, n);
        int n2 = this.MA.getL("/BPA", dataFile.bpa);
        int n3 = n / n2;
        int n4 = n2 * 8;
        dataFile.close();
        TextFile textFile = this.MA.getTextFile("P2");
        textFile.open(2);
        textFile.writeln("WIDTH=" + n4 + ";");
        textFile.writeln("DEPTH=" + n3 + ";");
        textFile.writeln("ADDRESS_RADIX=UNS;");
        textFile.writeln("DATA_RADIX=HEX;");
        textFile.writeln("CONTENT BEGIN");
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            textFile.writeln("  " + n6 + " : " + Convert.bb2hex((byte[])byArray, (int)n5, (int)n2).substring(2) + ";");
            n5 += n2;
            ++n6;
        }
        textFile.writeln("END;");
        textFile.close();
    }

    private void jvm2xbr() {
        String string;
        DataFile dataFile = this.MA.getDataFile("P1", "1000", "SI", 0);
        dataFile.open();
        int n = (int)dataFile.getDataSize();
        int n2 = 32;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n2];
        dataFile.read(byArray, 0, n);
        dataFile.close();
        String string2 = this.MA.getCS("/PREFIX", "inst") + ".";
        int n3 = this.MA.getL("/SIZE");
        TextFile textFile = this.MA.getTextFile("P2");
        textFile.open(2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            int n7 = 0;
            while (n7 < n2) {
                byArray2[n7] = n5 < n ? byArray[n5] : (byte)0;
                ++n7;
                n5 += 2;
            }
            String string3 = Convert.bb2hex((byte[])byArray2, (int)0, (int)n2);
            string = Convert.l2x((int)n6).substring(8);
            textFile.writeln("defparam " + string2 + "INIT_" + string + " = 256'h" + string3.substring(2) + ";");
            n4 += n2;
            ++n6;
        }
        n4 = 256;
        n5 = 0;
        n6 = 1;
        int n8 = 0;
        while (n5 < n3) {
            int n9;
            for (n9 = 0; n9 < n2; ++n9) {
                byArray2[n9] = 0;
            }
            n9 = 0;
            while (n9 < n4) {
                if (n6 < n && byArray[n6] == 1) {
                    int n10 = n9 >> 3;
                    byArray2[n10] = (byte)(byArray2[n10] | 1 << (n9 & 7));
                }
                ++n9;
                n6 += 2;
            }
            string = Convert.bb2hex((byte[])byArray2, (int)0, (int)n2);
            String string4 = Convert.l2x((int)n8).substring(8);
            textFile.writeln("defparam " + string2 + "INITP_" + string4 + " = 256'h" + string.substring(2) + ";");
            n5 += n4;
            ++n8;
        }
        textFile.close();
    }

    private void getid() {
        String string = this.MA.getCS("P1");
        int n = FileIO.fopen(string, -1, 0);
        long l = 0L;
        if (n > 0) {
            l = FileIO.fid(n);
            FileIO.fclose(n);
        }
        System.out.printf("GetFileId file=%s fd=%d fid=%x\n", string, n, l);
    }

    private void grep() {
        String string;
        String string2 = "NULL";
        String string3 = this.MA.getCS("P1");
        TextFile textFile = this.MA.getTextFile("P2");
        textFile.open(1);
        while (string2.equals("NULL") && (string = textFile.read()) != null) {
            if (string.indexOf(string3) < 0) continue;
            string2 = string;
        }
        textFile.close();
        this.MR.put(this.MA.getU("P3"), (Object)string2);
    }

    private void writeRamInit(String string, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        TextFile textFile = new TextFile(string);
        textFile.open(2);
        int n6 = 32;
        Convert.swap4((byte[])byArray, (int)n, (int)(n2 / 4));
        int n7 = 0;
        int n8 = 0;
        while (n7 < n2) {
            String string2 = Convert.l2x((int)n8).substring(8);
            for (int i = n3; i < n3 + n4; ++i) {
                String string3 = "";
                for (int j = i - n3; j < 2 * n6 / n5; j += 2) {
                    string3 = Convert.bb2hex((byte[])byArray, (int)(n + n7 + j * n5), (int)n5).substring(2) + string3;
                    string3 = "_" + string3;
                }
                string3 = string3.substring(1);
                textFile.writeln("defparam ppe.ram" + i + ".INIT_" + string2 + " = 256'h" + string3 + ";");
            }
            n7 += 2 * n6;
            ++n8;
        }
        Convert.swap4((byte[])byArray, (int)n, (int)(n2 / 4));
        textFile.close();
    }

    private void writeMemInit(String string, byte[] byArray, int n, int n2, int n3) {
        TextFile textFile = new TextFile(string);
        textFile.open(2);
        int n4 = 8;
        Convert.swap4((byte[])byArray, (int)n, (int)(n2 / 4));
        textFile.writeln("@" + Convert.l2x((int)n3).substring(2));
        for (int i = 0; i < n2; i += n4 * 4) {
            String string2 = "";
            for (int j = i; j < i + n4 * 4; j += 4) {
                string2 = string2 + Convert.bb2hex((byte[])byArray, (int)(n + j), (int)4).substring(2);
                string2 = string2 + " ";
            }
            textFile.writeln(string2);
        }
        Convert.swap4((byte[])byArray, (int)n, (int)(n2 / 4));
        textFile.close();
    }

    private void lst2csp() {
        int n;
        int n2;
        String string;
        int n3 = this.MA.getL("/ROWS");
        int n4 = this.MA.getL("/COLS", n3);
        int n5 = this.MA.getL("/PINS", n4 * n3);
        boolean bl = this.MA.getState("/REORDER");
        if (n5 < 0 || n3 < 0) {
            this.M.error("Must specify /ROWS= and /PINS=");
        }
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("lst");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        TextFile textFile2 = this.MA.getTextFile("P1");
        textFile2.fn.setRoot("symbolpre");
        textFile2.setExt("csa");
        if (!textFile2.open(1)) {
            this.M.error("Couldnt open " + textFile2.getURL());
        }
        TextFile textFile3 = this.MA.getTextFile("P1");
        textFile3.setExt("csa");
        if (!textFile3.open(2)) {
            this.M.error("Couldnt open " + textFile3.getURL());
        }
        TextFile textFile4 = this.MA.getTextFile("P1");
        textFile4.setExt("lib");
        if (!textFile4.open(2)) {
            this.M.error("Couldnt open " + textFile4.getURL());
        }
        String string2 = textFile.fn.getRoot().toUpperCase();
        String[] stringArray = new String[n5 + 1];
        String[] stringArray2 = new String[n5 + 1];
        int n6 = 0;
        while ((string = textFile.read()) != null) {
            n2 = string.indexOf(61);
            n = bl ? Convert.s2l((String)string.substring(0, n2)) - 1 : n6;
            stringArray[n] = string.substring(0, n2);
            stringArray2[n] = string.substring(n2 + 1);
            ++n6;
        }
        if (n6 != n5) {
            this.M.warning((CharSequence)("Number lines=" + n6 + " != mnumber pins=" + n5));
            n5 = n6;
        }
        n2 = 254000;
        n = n2 / 2;
        int n7 = n5 / 2;
        int n8 = 10;
        int n9 = n8 + 40;
        int n10 = n8 + 2;
        int n11 = 10;
        int n12 = n11 + n7 + 4;
        textFile4.writeln(string2);
        while ((string = textFile2.read()) != null && !string.equals("XXXX")) {
            textFile3.writeln(string);
        }
        textFile3.writeln("  (SYMDEF L0 \"" + string2 + "\" \"\" (PT " + n10 * n2 + " " + (n12 - 1) * n2 + ")");
        textFile3.writeln("   (FIGURE FIG0 LC25 NO_SHEET (OPENSHAPE");
        textFile3.writeln("    (PT " + n8 * n2 + " " + n12 * n2 + ")");
        textFile3.writeln("    (PT " + n9 * n2 + " " + n12 * n2 + ")");
        textFile3.writeln("    (PT " + n9 * n2 + " " + n11 * n2 + ")");
        textFile3.writeln("    (PT " + n8 * n2 + " " + n11 * n2 + ")");
        textFile3.writeln("    (PT " + n8 * n2 + " " + n12 * n2 + ")");
        textFile3.writeln("   ))");
        textFile3.writeln("   (TEXTLOC SYMBOL_NAME TC2 (PT " + n10 * n2 + " " + (n12 - 2) * n2 + "))");
        textFile3.writeln("   (TEXTLOC PART_NAME TC2 (PT " + n10 * n2 + " " + (n12 - 3) * n2 + "))");
        for (int i = 0; i < n5; ++i) {
            int n13 = i + 1;
            int n14 = i < n7 ? n8 : n9;
            int n15 = i < n7 ? n14 + 1 : n14 - 12;
            int n16 = i < n7 ? n11 + (n7 - i) : n11 + 1 + (i - n7);
            textFile3.writeln("   (TERMINAL " + n13 + " TC0 (PT " + n14 * n2 + " " + n16 * n2 + "))");
            textFile3.writeln("   (TEXT TX" + n13 + " \"" + stringArray2[i] + "\" TC2 NO_SHEET (PT " + n15 * n2 + " " + (n16 * n2 - n) + "))");
            int n17 = n4 == 1 ? i : this.getPinNumber(stringArray[i], n3, n4);
            this.addLine(textFile4, "" + n17 + ".0");
        }
        textFile3.writeln("  )");
        while ((string = textFile2.read()) != null) {
            textFile3.writeln(string);
        }
        this.flushLine(textFile4);
        textFile.close();
        textFile2.close();
        textFile3.close();
        textFile4.close();
    }

    private void sym2part() {
        String string;
        Object object;
        Parser parser;
        String string2;
        int n;
        boolean bl = this.MA.getState("/V4");
        boolean bl2 = this.MA.getState("/V5");
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt(bl2 ? "pkg" : (bl ? "txt" : "pins"));
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        if ((n = this.MA.getL("/ROWS")) <= 0) {
            this.M.error("You must specify /ROWS=n for this part up to " + rowlabel.length);
        }
        this.M.info((CharSequence)("Part Rows=" + n));
        int n2 = n * n;
        String[] stringArray = new String[n2 + 1];
        while ((string2 = textFile.read()) != null) {
            parser = new Parser(string2);
            object = parser.get(bl2 ? 3 : (bl ? 6 : 2));
            string = parser.get(bl2 ? 1 : (bl ? 4 : 3));
            int n3 = this.getPinNumber(string, n, n);
            if (stringArray[n3] != null) {
                this.M.error("Got Lpin=" + n3 + " Pin=" + string + " Label=" + (String)object);
            }
            stringArray[n3] = object;
        }
        textFile.close();
        object = this.MA.getTextFile("P1");
        object.setExt("sym");
        if (!object.open(1)) {
            this.M.error("Couldnt open " + object.getURL());
        }
        textFile = this.MA.getTextFile("P1");
        textFile.setExt("lib");
        if (!textFile.open(2)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        while ((string2 = object.read()) != null) {
            int n4;
            parser = new Parser(string2);
            if (parser.elements() <= 0) continue;
            this.M.info((CharSequence)("Process " + string2));
            string = parser.get(1);
            if (string.equals("GLOBAL")) {
                String string3 = parser.get(2);
                this.flushLine(textFile);
                this.addLine(textFile, parser.get(3));
                for (n4 = 0; n4 <= n2; ++n4) {
                    if (!string3.equals(stringArray[n4])) continue;
                    this.addLine(textFile, "" + n4 + ".0");
                }
                this.flushLine(textFile);
                continue;
            }
            if (string.startsWith("PINS")) {
                for (int i = 2; i <= parser.elements(); ++i) {
                    String string4 = parser.get(i);
                    int n5 = this.findPin(string4, stringArray);
                    if (n5 <= 0) {
                        this.M.error("Signal " + string4 + " not found");
                    }
                    this.addLine(textFile, "" + n5 + ".0");
                }
                continue;
            }
            if (!string.startsWith("IOBANK")) continue;
            String string5 = parser.get(2);
            for (n4 = 3; n4 <= parser.elements(); ++n4) {
                String string6 = parser.get(n4);
                int n6 = this.findPin("IO_L" + string6 + "N_" + string5, stringArray);
                int n7 = this.findPin("IO_L" + string6 + "P_" + string5, stringArray);
                int n8 = this.findPin("IO_L" + string6 + "_" + string5, stringArray);
                if (n8 > 0) {
                    this.addLine(textFile, "" + n8 + ".0");
                }
                if (n6 > 0) {
                    this.addLine(textFile, "" + n6 + ".0");
                }
                if (n7 > 0) {
                    this.addLine(textFile, "" + n7 + ".0");
                }
                if (n8 < 0 && n6 < 0) {
                    this.M.error("No pin " + string6 + " in bank " + string5);
                }
                if (n8 > 0 && n6 > 0) {
                    this.M.error("Bad pin " + string6 + " in bank " + string5);
                }
                if (n6 <= 0 || n7 >= 0) continue;
                this.M.error("Mismatch pin " + string6 + " in bank " + string5);
            }
        }
        textFile.close();
        object.close();
    }

    private int getPinNumber(String string, int n, int n2) {
        int n3 = n;
        for (n3 = n - 1; n3 >= 0 && !string.startsWith(rowlabel[n3]); --n3) {
        }
        if (n3 < 0) {
            return -1;
        }
        int n4 = 0;
        for (int i = rowlabel[n3].length(); i < string.length(); ++i) {
            n4 = 10 * n4 + (string.charAt(i) - 48);
        }
        return n4 += n3 * n2;
    }

    private String getSPinNumber(int n, int n2) {
        int n3 = (n - 1) / n2;
        int n4 = n - n3 * n2;
        return rowlabel[n3] + n4;
    }

    private void addLine(TextFile textFile, String string) {
        if (this.outline.length() > 73) {
            textFile.writeln(this.outline + "&");
            this.outline = "";
        }
        this.outline = this.outline + string + " ";
    }

    private void flushLine(TextFile textFile) {
        if (this.outline.length() > 0) {
            textFile.writeln(this.outline);
        }
        this.outline = "";
    }

    private void net2ucf() {
        String string;
        int n;
        String string2;
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("frs");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        TextFile textFile2 = this.MA.getTextFile("P1");
        textFile2.setExt("ucfx");
        if (!textFile2.open(2)) {
            this.M.error("Couldnt open " + textFile2.getURL());
        }
        if ((string2 = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        if ((n = this.MA.getL("/ROWS")) <= 0) {
            this.M.error("You must specify /ROWS=n for this part up to " + rowlabel.length);
        }
        this.M.info((CharSequence)("Part=" + string2 + "  Rows=" + n));
        int n2 = n * n;
        String string3 = null;
        while ((string = textFile.read()) != null) {
            String string4;
            if (string.length() == 0) continue;
            if (string.charAt(0) != '.') {
                string = ".TER " + string;
            }
            Parser parser = new Parser(string);
            parser.clean();
            String string5 = parser.get(1);
            if (string5.equals(".ADD_TER")) {
                string3 = parser.get(4);
                string3 = string3.substring(1, string3.length() - 1);
                int n3 = 0;
                int n4 = string3.length();
                char c = string3.charAt(string3.length() - 2);
                if (n4 > 1 && string3.charAt(n4 - 1) >= '0' && string3.charAt(n4 - 1) <= '9') {
                    n3 = 1;
                }
                if (n3 > 0 && n4 > 2 && string3.charAt(n4 - 2) >= '0' && string3.charAt(n4 - 2) <= '9') {
                    n3 = 2;
                }
                if (n3 != 0) {
                    string3 = string3.substring(0, n4 - n3) + "<" + string3.substring(n4 - n3, n4) + ">";
                }
                int n5 = string3.indexOf("<0");
                if (n3 == 2 && n5 > 0) {
                    string3 = string3.substring(0, n5 + 1) + string3.substring(n5 + 2);
                }
                string5 = ".TER";
            }
            if (!string5.equals(".TER") || !(string4 = parser.get(2)).equals(string2)) continue;
            String string6 = parser.get(3);
            String string7 = this.getSPinNumber(Convert.s2l((String)string6), n);
            this.M.info((CharSequence)("Terminal " + string4 + " " + string6 + " " + string3));
            textFile2.writeln("NET \"" + string3.toLowerCase() + "\" LOC = \"" + string7.toLowerCase() + "\" ;");
        }
        textFile.close();
        textFile2.close();
    }

    private int findPin(String string, String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            if (!this.matchPin(string, stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean matchPin(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string2.indexOf(string) >= 0;
    }

    private void qnet2ucf() {
        String string;
        String string2;
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("qnet");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        TextFile textFile2 = this.MA.getTextFile("P1");
        textFile2.setExt("ucfx");
        if (!textFile2.open(2)) {
            this.M.error("Couldnt open " + textFile2.getURL());
        }
        if ((string2 = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        this.M.info((CharSequence)("Part=" + string2));
        String string3 = null;
        while ((string = textFile.read()) != null) {
            String string4;
            if (string.length() == 0) continue;
            Parser parser = new Parser(string);
            parser.clean();
            String string5 = parser.get(1);
            if (string5.equals("NET_NAME")) {
                string3 = null;
                string4 = string = textFile.read();
                if ((string4 = string4.substring(1, string4.length() - 1)).indexOf(".") > 0 || string4.startsWith("VCC") || string4.startsWith("GND") || string4.equals("NC")) continue;
                string3 = this.convertNet(string4);
            }
            if (string3 == null || !string5.equals("NODE_NAME") || !(string4 = parser.get(2)).equals(string2)) continue;
            String string6 = parser.get(3);
            this.M.info((CharSequence)("Terminal " + string4 + " " + string6 + " " + string3));
            textFile2.writeln("NET \"" + string3.toLowerCase() + "\" LOC = \"" + string6.toLowerCase() + "\" ;");
        }
        textFile.close();
        textFile2.close();
    }

    private void enet2ucf() {
        String string;
        String string2;
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("enet");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        TextFile textFile2 = this.MA.getTextFile("P1");
        textFile2.setExt("ucfx");
        if (!textFile2.open(2)) {
            this.M.error("Couldnt open " + textFile2.getURL());
        }
        if ((string2 = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        this.M.info((CharSequence)("Part=" + string2));
        String string3 = null;
        for (int i = 0; i < 8; ++i) {
            textFile.read();
        }
        while ((string = textFile.read()) != null) {
            int n;
            if (string.length() < 43) {
                string3 = null;
                continue;
            }
            String string4 = string.substring(0, 16).trim();
            String string5 = string.substring(16, 25).trim();
            String string6 = string.substring(25, 34).trim();
            String string7 = string.substring(34, 43).trim();
            if (string4.length() == 0) {
                string4 = string3;
            }
            string3 = string4;
            if (!string5.equals(string2) || string4.indexOf(".") >= 0 || string7.indexOf("VCC") >= 0 || string7.indexOf("VOUT") >= 0 || string7.indexOf("GND") >= 0) continue;
            boolean bl = (string4 = string4.toLowerCase()).endsWith("_n") || string4.endsWith("_p");
            int n2 = bl ? string4.length() - 2 : string4.length();
            boolean bl2 = string4.charAt(n2 - 1) >= '0' && string4.charAt(n2 - 1) <= '9';
            boolean bl3 = string4.charAt(n2 - 2) >= '0' && string4.charAt(n2 - 2) <= '9';
            int n3 = n = bl2 ? n2 - 1 : n2;
            if (bl3) {
                --n;
            }
            if (bl) {
                string4 = string4.substring(0, n) + string4.charAt(n2 + 1) + string4.substring(n, n2);
            }
            if (bl) {
                ++n;
                ++n2;
            }
            if (bl2) {
                string4 = string4.substring(0, n) + '<' + string4.substring(n, n2) + '>';
            }
            this.M.info((CharSequence)("Terminal " + string2 + " " + string6 + " " + string4));
            textFile2.writeln("NET \"" + string4.toLowerCase() + "\" LOC = \"" + string6.toLowerCase() + "\" ;");
        }
        textFile.close();
        textFile2.close();
    }

    private String[] getSA(Parser parser) {
        int n = parser.elements();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = parser.get(i + 1);
            if (string.length() > 0 && string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    private String subS(String string, String string2) {
        return StringUtil.replaceFirst((String)string, (String)"^", (String)string2);
    }

    private String subS(String string, String string2, String string3) {
        return this.subS(this.subS(string, string2), string3);
    }

    private String subS(String string, String string2, String string3, String string4) {
        return this.subS(this.subS(this.subS(string, string2), string3), string4);
    }

    private void ucf2xdc() {
        String string;
        String[] stringArray = null;
        TextFile textFile = this.MA.getTextFile("P1");
        textFile.setExt("ucf");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        TextFile textFile2 = this.MA.getTextFile("P1");
        textFile2.setExt("xdc");
        if (!textFile2.open(2)) {
            this.M.error("Couldnt open " + textFile2.getURL());
        }
        Object var6_4 = null;
        boolean bl = false;
        Table table = new Table();
        block0: while ((string = textFile.read()) != null) {
            String string2;
            int n;
            if ((string = string.trim()).length() == 0) continue;
            int n2 = string.indexOf(59);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            while (string.indexOf("  ") >= 0) {
                string = StringUtil.replaceAll((String)string, (String)"  ", (String)" ");
            }
            string = StringUtil.replaceAll((String)string, (String)"<", (String)"[");
            string = StringUtil.replaceAll((String)string, (String)">", (String)"]");
            Parser parser = new Parser(string);
            String[] stringArray2 = this.getSA(parser);
            int n3 = stringArray2.length;
            if (!(stringArray == null || stringArray2[0].equals("TIMESPEC") && stringArray2[3].equals("PERIOD"))) {
                textFile2.writeln(this.subS("create_generated_clock -name ^ [get_nets ^]", (String)stringArray[4], (String)stringArray[1]));
            }
            stringArray = null;
            if (stringArray2[0].equals("##XDC##")) {
                textFile2.writeln(string.substring(8));
                continue;
            }
            if (stringArray2[0].equals("##XDCON##")) {
                bl = true;
                continue;
            }
            if (stringArray2[0].equals("##XDCOFF##")) {
                bl = false;
                continue;
            }
            if (bl) {
                textFile2.writeln(string);
                continue;
            }
            if (stringArray2[0].startsWith("##")) {
                textFile2.writeln(string.substring(1));
                continue;
            }
            if (stringArray2[1].equals("DCI_CASCADE")) {
                String string3 = stringArray2[3];
                n = string3.indexOf(" ");
                textFile2.writeln(this.subS("set_property DCI_CASCADE {^} [get_iobanks ^]", string3.substring(0, n), string3.substring(n + 1)));
                continue;
            }
            if (stringArray2[2].equals("TNM_NET")) {
                table.put(stringArray2[4], (Object)stringArray2[1]);
                stringArray = stringArray2;
                continue;
            }
            if (stringArray2[0].equals("TIMESPEC") && stringArray2[3].equals("PERIOD")) {
                double d = Convert.s2d((String)stringArray2[5], (Object)this.M);
                String string4 = Convert.d2s((double)(1000.0 / d), (int)0, (String)"##.###");
                string2 = table.getS(stringArray2[4]);
                textFile2.writeln(this.subS("create_clock -name ^ -period ^ [get_nets ^]", stringArray2[4], string4, string2));
                this.MR.put(stringArray2[1], d);
                continue;
            }
            if (stringArray2[0].equals("TIMESPEC") && stringArray2[3].equals("FROM") && stringArray2[5].equals("TO") && stringArray2[7].equals("TIG")) {
                textFile2.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", stringArray2[4], stringArray2[6]));
                continue;
            }
            if (stringArray2[0].equals("TIMESPECS") && stringArray2[3].equals("FROM") && stringArray2[5].startsWith("TO")) {
                boolean bl2 = stringArray2[5].equals("TOFR");
                n = stringArray2[7].equals("MAX") ? 1 : 0;
                boolean bl3 = stringArray2[7].equals("TIG");
                string2 = new Parser(stringArray2[4]);
                Parser parser2 = new Parser(stringArray2[6]);
                for (int i = 1; i <= string2.elements(); ++i) {
                    String string5 = string2.get(i);
                    for (int j = 1; j <= parser2.elements(); ++j) {
                        String string6 = parser2.get(j);
                        if (string6.equals(string5)) continue;
                        if (bl3) {
                            textFile2.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", string5, string6));
                        }
                        if (n != 0) {
                            textFile2.writeln(this.subS("set_max_delay -from [get_clocks ^] -to [get_clocks ^] ^", string5, string6, stringArray2[8]));
                        }
                        if (!bl2) continue;
                        if (bl3) {
                            textFile2.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", string6, string5));
                        }
                        if (n == 0) continue;
                        textFile2.writeln(this.subS("set_max_delay -from [get_clocks ^] -to [get_clocks ^] ^", string6, string5, stringArray2[8]));
                    }
                }
                continue;
            }
            if (stringArray2[0].equals("NET") && stringArray2[2].equals("LOC")) {
                textFile2.writeln(this.subS("set_property PACKAGE_PIN ^ [get_ports ^]", stringArray2[4].toUpperCase(), stringArray2[1]));
                int n4 = 5;
                while (n4 < n3) {
                    if (!stringArray2[n4].equals("|")) {
                        System.out.println("Bad NET format: " + string + "  //  " + n4 + " " + stringArray2[n4]);
                        continue block0;
                    }
                    n = stringArray2[n4 + 1].indexOf(61);
                    if (n > 0) {
                        textFile2.writeln(this.subS("set_property ^ ^ [get_ports ^]", stringArray2[n4 + 1].substring(0, n), stringArray2[n4 + 1].substring(n + 1), stringArray2[1]));
                        n4 += 2;
                        continue;
                    }
                    if (n4 + 2 < n3 && stringArray2[n4 + 2].equals("=")) {
                        textFile2.writeln(this.subS("set_property ^ ^ [get_ports ^]", stringArray2[n4 + 1], stringArray2[n4 + 3], stringArray2[1]));
                        n4 += 4;
                        continue;
                    }
                    textFile2.writeln(this.subS("set_property ^ TRUE [get_ports ^]", stringArray2[n4 + 1], stringArray2[1]));
                    n4 += 2;
                }
                continue;
            }
            if (stringArray2[0].equals("NET") && stringArray2[2].equals("TIG")) {
                if (stringArray2[1].indexOf(42) < 0) {
                    textFile2.writeln(this.subS("set_false_path -through [get_nets -match_style ucf ^]", stringArray2[1]));
                    continue;
                }
                textFile2.writeln(this.subS("set_false_path -through [get_nets -match_style ucf ^]", stringArray2[1]));
                continue;
            }
            if (stringArray2[0].equals("NET") && stringArray2[2].equals("USELOWSKEWLINES")) {
                textFile2.writeln("##UCF? " + string);
                continue;
            }
            if (stringArray2[0].equals("NET")) {
                int n5 = stringArray2[2].indexOf(61);
                if (n5 > 0) {
                    textFile2.writeln(this.subS("set_property ^ ^ [get_nets ^]", stringArray2[2].substring(0, n5), stringArray2[2].substring(n5 + 1), stringArray2[1]));
                    continue;
                }
                textFile2.writeln(this.subS("set_property ^ ^ [get_nets ^]", stringArray2[2], stringArray2[3], stringArray2[1]));
                continue;
            }
            if (stringArray2[0].equals("INST") && stringArray2[2].equals("LOC")) {
                textFile2.writeln(this.subS("set_property LOC ^ [get_cells ^]", stringArray2[4], stringArray2[1]));
                continue;
            }
            if (stringArray2[0].equals("INST") && stringArray2[2].equals("AREA_GROUP")) {
                textFile2.writeln(this.subS("create_pblock ^", stringArray2[4]));
                textFile2.writeln(this.subS("add_cells_to_pblock [get_pblocks ^] [get_cells -quiet [list ^]]", stringArray2[4], stringArray2[1]));
                continue;
            }
            if (stringArray2[0].equals("AREA_GROUP") && stringArray2[2].equals("RANGE")) {
                textFile2.writeln(this.subS("resize_pblock [get_pblocks ^] -add {^}", stringArray2[1], stringArray2[4]));
                continue;
            }
            if (stringArray2[0].equals("INST") && stringArray2[2].equals("RANGE")) {
                textFile2.writeln(this.subS("set_property RANGE ^ [get_cells ^]", stringArray2[4], stringArray2[1]));
                continue;
            }
            System.out.print("SA [ ");
            for (int i = 0; i < n3; ++i) {
                System.out.print(stringArray2[i] + " ");
            }
            System.out.println("]");
            textFile2.writeln("##UCF? " + string);
        }
        textFile.close();
        textFile2.close();
    }

    private String convertNet(String string) {
        char c;
        int n;
        boolean bl;
        int n2 = string.length();
        boolean bl2 = bl = string.charAt(n2 - 2) >= '0' && string.charAt(n2 - 2) <= '9';
        if (string.endsWith("+") || string.endsWith("P") && bl) {
            string = string.substring(0, n2 - 2) + "P" + string.charAt(n2 - 2);
        }
        if (string.endsWith("-") || string.endsWith("N") && bl) {
            string = string.substring(0, n2 - 2) + "N" + string.charAt(n2 - 2);
        }
        for (n = n2; n > 0 && (c = string.charAt(n - 1)) >= '0' && c <= '9'; --n) {
        }
        if (n != n2 && n2 - n < 4) {
            string = string.substring(0, n) + "<" + string.substring(n) + ">";
        }
        if (string.startsWith("DDR2_")) {
            string = "M" + string.substring(5);
        }
        return string;
    }

    boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    boolean isAlphaP(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '!';
    }

    boolean isAlphaN(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '!' || c >= '0' && c <= '9';
    }

    boolean compare(KeyVector keyVector, String string, String string2, String string3) {
        Object object;
        Object object2 = keyVector.get(string);
        if (object2 != null) {
            string = object2.toString();
        }
        if ((object = keyVector.get(string3)) != null) {
            string3 = object.toString();
        }
        if (string2.equals("==")) {
            return string.equals(string3);
        }
        if (string2.equals("!=")) {
            return !string.equals(string3);
        }
        if (string2.equals(">=")) {
            return Convert.s2d((String)string) >= Convert.s2d((String)string3);
        }
        if (string2.equals("<=")) {
            return Convert.s2d((String)string) <= Convert.s2d((String)string3);
        }
        if (string2.equals(">")) {
            return Convert.s2d((String)string) > Convert.s2d((String)string3);
        }
        if (string2.equals("<")) {
            return Convert.s2d((String)string) < Convert.s2d((String)string3);
        }
        this.M.warning((CharSequence)("Illegal test in VPP define: " + string + " " + string2 + " " + string3));
        return false;
    }

    boolean isDefine(KeyVector keyVector, String string, String string2) {
        Parser parser = null;
        int n = 1;
        if (string2 != null) {
            parser = new Parser(string + " " + string2, true, false);
            n = parser.elements();
        }
        boolean bl = false;
        for (int i = 1; i <= n; ++i) {
            boolean bl2;
            boolean bl3;
            String string3 = parser == null ? string : parser.get(i);
            boolean bl4 = bl3 = string3.startsWith("!") && !string3.equals("!=");
            if (bl3) {
                string3 = string3.substring(1);
            }
            if (bl2 = this.isAlpha(string3.charAt(0))) {
                bl = keyVector.findKey(string3) >= 0 ^ bl3;
                continue;
            }
            if (string3.equals("||") || string3.equals("|")) {
                if (!bl) continue;
                break;
            }
            if (string3.equals("&&") || string3.equals("&")) {
                if (bl) continue;
                break;
            }
            bl = this.compare(keyVector, parser.get(i - 1), string3, parser.get(i + 1));
            ++i;
        }
        return bl;
    }

    private void vppfile(KeyVector keyVector, TextFile textFile, TextFile textFile2) {
        boolean bl = textFile2 != null;
        FileName fileName = textFile.getFileName();
        boolean bl2 = fileName.getExt().equals("v");
        if (!textFile.open(1)) {
            this.M.error("Couldnt open " + textFile.getURL());
        }
        if (bl) {
            if (!textFile2.open(2)) {
                this.M.error("Couldnt open " + textFile2.getURL());
            }
        }
        String string = null;
        int n = 0;
        int[] nArray = new int[16];
        nArray[0] = 1;
        while ((string = textFile.read()) != null) {
            int n2 = 32;
            int n3 = string.length();
            int n4 = string.indexOf("//");
            boolean bl3 = false;
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                if (n4 >= 0 && i >= n4) break;
                if (this.isAlpha(c)) {
                    int n5 = i++;
                    while (i < n3 && this.isAlphaN(string.charAt(i))) {
                        ++i;
                    }
                    String string2 = string.substring(n5, i);
                    if (n2 == 96 || n2 == 35) {
                        String string3;
                        int n6;
                        int n7;
                        bl3 = true;
                        for (n7 = i; n7 < n3 && !this.isAlphaP(string.charAt(n7)); ++n7) {
                        }
                        for (n6 = n7; n6 < n3 && this.isAlphaN(string.charAt(n6)); ++n6) {
                        }
                        String string4 = n6 > n7 ? string.substring(n7, n6) : "";
                        String string5 = string3 = n6 < n3 ? string.substring(n6).trim() : null;
                        if (string2.equals("define") && string3 == null && n2 == 35) {
                            string3 = "NULL";
                        }
                        int n8 = nArray[n];
                        if (string2.equals("define")) {
                            if (nArray[n] == 1 && string3 != null) {
                                keyVector.put(string4, (Object)(string3.equals("NULL") ? "" : string3));
                            }
                        } else if (string2.equals("undef")) {
                            if (nArray[n] == 1) {
                                keyVector.remove(string4);
                            }
                        } else if (string2.equals("if")) {
                            nArray[++n] = n8 <= 0 ? -1 : (this.isDefine(keyVector, string4, string3) ? 1 : 0);
                        } else if (string2.equals("ifdef")) {
                            nArray[++n] = n8 <= 0 ? -1 : (this.isDefine(keyVector, string4, string3) ? 1 : 0);
                        } else if (string2.equals("ifndef")) {
                            nArray[++n] = n8 <= 0 ? -1 : (!this.isDefine(keyVector, string4, string3) ? 1 : 0);
                        } else if (string2.equals("else")) {
                            nArray[n] = nArray[n] == 0 ? 1 : 0;
                        } else if (string2.equals("elif")) {
                            nArray[n] = nArray[n] != 0 ? -1 : (this.isDefine(keyVector, string4, string3) ? 1 : 0);
                        } else if (string2.equals("elsif")) {
                            nArray[n] = nArray[n] != 0 ? -1 : (this.isDefine(keyVector, string4, string3) ? 1 : 0);
                        } else if (string2.equals("endif")) {
                            --n;
                        } else {
                            bl3 = false;
                        }
                        if (string2.equals("include") && nArray[n] > 0 && string.indexOf("mdefs_user") > 0) {
                            String string6 = fileName.getFullName().replace("mdefs", "mdefs_user");
                            this.vppfile(keyVector, new TextFile(string6), null);
                        }
                    } else {
                        Object object;
                        Object object2 = keyVector.get(string2);
                        Object object3 = object = object2 == null ? null : keyVector.get(object2.toString());
                        if (object2 != null && object == null && (!bl3 || string2.endsWith("_CPP"))) {
                            string = string.substring(0, n5) + object2 + string.substring(i);
                            n3 = string.length();
                            i = n5 + object2.toString().length();
                        }
                        if (string2.equals("CARD_CPP") && object == null) {
                            string = string + "\n`define " + string2.replace("CARD_CPP", "ICE_CARD") + " \"" + object2 + "\"";
                        }
                    }
                    n2 = 32;
                    continue;
                }
                if (c == ' ') continue;
                n2 = c;
            }
            if (!bl || !bl2 && (bl3 || nArray[n] != 1)) continue;
            textFile2.writeln(string);
        }
        if (textFile != null) {
            textFile.close();
        }
        if (textFile2 != null) {
            textFile2.close();
        }
    }

    private void vppflow() {
        KeyVector keyVector = KeyVector.fromString((String)this.MA.getCS("/PREDEFS"));
        if (this.MA.isPresent("/MDEFS")) {
            this.vppfile(keyVector, this.MA.getTextFile("/MDEFS"), null);
        }
        this.vppfile(keyVector, this.MA.getTextFile("P1"), this.MA.getTextFile("P2"));
    }

    private void tppflow() {
        KeyVector keyVector = KeyVector.fromString((String)this.MA.getCS("/DEFINES"));
        keyVector.add("NMVERSION", (Object)this.MR.getS("ENV.NMVERSION"));
        keyVector.add("HOSTNAME", (Object)this.MR.getS("ENV.HOSTNAME"));
        keyVector.add("USER", (Object)this.MR.getS("ENV.USER"));
        boolean bl = this.MA.getState("/DEBUG");
        TextFile textFile = new TextFile(bl ? "/tmp/snapapp_pp" : "ram:snapapp_pp");
        this.vppfile(keyVector, this.MA.getTextFile("P1"), textFile);
        this.MR.put(this.MA.getU("P2"), (Object)new Table(textFile));
        if (!bl) {
            this.M.pipes.remove("snapapp_pp");
        }
    }

    private void jtag2m() {
        int n;
        int n2 = 32768;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 21;
        boolean bl = this.MA.getState("/OOT");
        boolean bl2 = this.MA.getState("/TOT");
        BaseFile baseFile = this.MA.getBaseFile("P1");
        baseFile.open(1);
        byte[] byArray = new byte[n2];
        DataFile dataFile = this.MA.getDataFile("P2", "1000", "5L", 0);
        dataFile.open(2);
        Data data = dataFile.getDataBuffer(1);
        DataFile dataFile2 = this.MA.getDataFile("P3", "1000", "SL", 0);
        dataFile2.open(2);
        Data data2 = dataFile2.getDataBuffer(n2);
        DataFile dataFile3 = this.MA.getDataFile("P4", "1000", "SL", 0);
        dataFile3.open(2);
        Data data3 = dataFile3.getDataBuffer(n2);
        for (int i = (int)baseFile.getSize(); i > 0; i -= n) {
            n = Math.min(n2, i);
            baseFile.read(byArray, 0, n);
            for (int j = 0; j < n; ++j) {
                byte by = byArray[j];
                boolean bl3 = (by & 1) != 0;
                boolean bl4 = (by & 2) != 0;
                boolean bl5 = (by & 4) != 0;
                n8 >>>= 1;
                if (bl3) {
                    n8 |= Integer.MIN_VALUE;
                }
                n9 >>>= 1;
                if (bl4) {
                    n9 |= Integer.MIN_VALUE;
                }
                if (++n4 == 32) {
                    data2.setL(n6, n8);
                    ++n6;
                    n4 = 0;
                }
                if (++n5 == 32) {
                    data3.setL(n7, n9);
                    ++n7;
                    n5 = 0;
                }
                switch (n10) {
                    case 0: {
                        if (!bl5) break;
                        ++n10;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (bl5) {
                            ++n10;
                            break;
                        }
                        n10 += 10;
                        break;
                    }
                    case 3: {
                        if (bl5) break;
                        n10 = 0;
                        break;
                    }
                    case 11: 
                    case 12: {
                        n7 = 0;
                        n6 = 0;
                        n5 = 0;
                        n4 = 0;
                        n9 = 0;
                        n8 = 0;
                        if (bl) {
                            n5 = -1;
                        }
                        if (bl2) {
                            n4 = -1;
                        }
                        n10 += 10;
                        break;
                    }
                    case 21: 
                    case 22: {
                        int n11;
                        if (!bl5) break;
                        if (n4 != 0) {
                            n11 = 32 - n4;
                            n8 >>>= n11;
                        }
                        if (n5 != 0) {
                            n11 = 32 - n5;
                            n9 >>>= n11;
                        }
                        data.setL(0, n10 - 20);
                        data.setL(1, n4);
                        data.setL(2, n6);
                        data.setL(3, n8);
                        data.setL(4, n9);
                        dataFile.write(data);
                        if (n6 > 0) {
                            dataFile2.write(data2, n6);
                        }
                        if (n7 > 0) {
                            dataFile3.write(data3, n7);
                        }
                        n10 = -3;
                        break;
                    }
                    case -3: {
                        n10 = 0;
                        break;
                    }
                    default: {
                        this.M.error("Illegal State " + n10 + " at " + n3);
                    }
                }
                ++n3;
            }
        }
        baseFile.close();
        dataFile.close();
        dataFile2.close();
        dataFile3.close();
    }

    public void gerber() {
        String string;
        TextFile textFile = this.MA.getTextFile("P1");
        if (!textFile.open(1)) {
            this.M.error("Opening input URL=" + textFile.getURL());
        }
        this.M.info((CharSequence)("Opened gerber input URL=" + textFile.getURL()));
        TextFile textFile2 = this.MA.getTextFile("P2");
        if (!textFile2.open(2)) {
            this.M.error("Opening output URL=" + textFile2.getURL());
        }
        textFile2.writeln("! GAPFile Version 1.0");
        textFile2.writeln("! Created by: NeXtMidas 4.1.4");
        textFile2.writeln("GAPFile    Version 1.0    (c) 1991 CAD Solutions, Inc.");
        textFile2.writeln("!     Type            Width          Length     Rotate   Offset      Swap  Tool      Size      Legend");
        textFile2.writeln("!                English  Metric English  Metric     English  Metric Code  No. English  Metric");
        textFile2.writeln("|-----------------------+---------------+-------------------+-------------------------+--------------");
        while ((string = textFile.read()) != null) {
            char c;
            Parser parser = new Parser(string, true);
            String string2 = parser.get(1);
            if (string2 == null || string2.length() == 0 || (c = string2.charAt(0)) < '0' || c > '9') continue;
            String string3 = parser.get(2);
            String string4 = parser.get(3);
            double d = Convert.s2d((String)parser.get(4));
            int n = Convert.s2l((String)parser.get(5));
            double d2 = Convert.s2d((String)parser.get(6));
            if (string3.equals("CIRCLE")) {
                string3 = "ROUND";
            }
            if (string3.equals("ANNULUS")) {
                string3 = "DONUT";
                d2 = n;
                n = 0;
            }
            if (string3.equals("FINGER")) {
                string3 = "OBLONG";
            }
            if (string3.equals("BULLET")) {
                string3 = "OBLONG";
            }
            if (string3.equals("DIAMOND")) {
                string3 = "SQUARE";
            }
            if (string3.equals("RECTANGLE") || string3.equals("OBLONG")) {
                d2 += d;
                if (n == 0 || n == 180) {
                    double d3 = d;
                    d = d2;
                    d2 = d3;
                }
            }
            String string5 = "D" + string2;
            Double d4 = d;
            Double d5 = d * e2m;
            Double d6 = d2;
            Double d7 = d2 * e2m;
            Integer n2 = 0;
            Integer n3 = 0;
            Double d8 = 0.0;
            Object[] objectArray = new Object[]{string5, string3, d4, d5, d6, d7, n2, d8, d8, string5, n3, d8, d8, n3};
            String string6 = String.format(form, objectArray);
            System.out.println(string6);
            textFile2.writeln(string6);
        }
        textFile.close();
        textFile2.close();
        this.M.info((CharSequence)("Closed GAP output URL=" + textFile2.getURL()));
    }

    private void crcgen() {
        int n;
        int n2;
        int n3 = this.MA.getL("P1", 32);
        int n4 = this.MA.getL("P2", 79764919);
        int n5 = this.MA.getL("P3", -1);
        int n6 = this.MA.getL("P4", 32);
        int n7 = this.MA.getL("P5", 0);
        String string = this.MA.getU("P6");
        boolean bl = this.MA.getState("/FLIP");
        boolean bl2 = this.MA.getState("/COMP");
        boolean bl3 = this.MA.getState("/EQN");
        boolean bl4 = this.MA.getState("/RED");
        String[] stringArray = new String[n3];
        int n8 = n5;
        int n9 = n3 - 1;
        int n10 = n3 == 32 ? -1 : (1 << n3) - 1;
        int n11 = n10 & 0xFFFFFFFE;
        int n12 = n4 & 0xFFFFFFFE;
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = "C" + n2;
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n = (n7 >> n2 ^ n8 >> n9) & 1;
            n8 = n8 << 1 & n11 | n;
            if (n != 0) {
                n8 ^= n12;
            }
            if (!bl3) continue;
            String string2 = stringArray[n9] + "^D" + n2;
            for (int i = n9; i > 0; --i) {
                stringArray[i] = stringArray[i - 1];
                if ((n4 >> i & 1) == 0) continue;
                int n13 = i;
                stringArray[n13] = stringArray[n13] + "^" + string2;
            }
            stringArray[0] = string2;
        }
        if (bl) {
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                if ((n8 >> n & 1) == 0) continue;
                n2 |= 1 << (n ^ 7);
            }
            n8 = n2;
        }
        if (bl2) {
            n8 ^= n10;
        }
        this.MT.writeln((CharSequence)("CRC size=" + n3 + " mask=" + Convert.l2x((int)n11) + " polym=" + Convert.l2x((int)n12)));
        this.MT.writeln((CharSequence)("CRC in=" + Convert.l2x((int)n5) + " data=" + Convert.l2x((int)n7) + " out=" + Convert.l2x((int)n8)));
        this.MR.put(string, n8);
        this.evalcrc = 0;
        if (bl4) {
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = this.reduceEqs(n6, n7, stringArray[n2], n2);
            }
        }
        if (bl3) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.MT.writeln((CharSequence)("crc[" + n2 + "]<=" + stringArray[n2]));
            }
        }
        if (bl4) {
            this.MT.writeln((CharSequence)("CRC eval=" + Convert.l2x((int)this.evalcrc)));
        }
    }

    private String reduceEqs(int n, int n2, String string, int n3) {
        int n4;
        string = string + "^";
        int n5 = 0;
        for (n4 = 0; n4 < string.length(); ++n4) {
            if (string.charAt(n4) != 'C') continue;
            ++n5;
        }
        String string2 = "C" + n5 % 2;
        int n6 = n5;
        for (int i = 0; i < n; ++i) {
            String string3 = "D" + i + "^";
            int n7 = string3.length();
            n5 = 0;
            for (n4 = 0; n4 < string.length(); ++n4) {
                if (!string.regionMatches(n4, string3, 0, n7)) continue;
                ++n5;
            }
            if (n5 % 2 == 1) {
                string2 = string2 + "^d[" + i + "]";
            }
            if (n5 % 2 != 1 || (n2 >> i & 1) != 1) continue;
            ++n6;
        }
        if (n6 % 2 == 1) {
            this.evalcrc |= 1 << n3;
        }
        return string2 + ";";
    }

    private void modargs() {
        Args args = Args.parseCommand((Midas)this.M, (String)this.MA.getS(2));
        Args args2 = (Args)this.MA.getO(3);
        args2.getKV().clear();
        args2.getKV().merge((Keyable)args.getKV());
        args2.nargs = args.nargs;
        args2.nargsx = args.nargsx;
    }

    private void tput() {
        Table table = this.MA.getTable("P1");
        DataFile dataFile = this.MA.getDataFile("P2");
        dataFile.open(1027);
        Table.Iterator iterator = table.iterator();
        while (iterator.getNext()) {
            dataFile.keywords.put(iterator.key, iterator.value);
        }
        dataFile.close();
    }

    private void scanup() {
        DataFile dataFile = this.MA.getDataFile("P1");
        DataFile dataFile2 = this.MA.getDataFile("P2");
        dataFile.open(1);
        dataFile2.open(3);
        int n = (int)dataFile.getSize();
        int n2 = (int)dataFile.getBPE();
        int n3 = (int)dataFile2.getSize();
        int n4 = (int)dataFile2.getBPE();
        double d = dataFile.keywords.getD("RFCF", -1.0);
        double d2 = dataFile.keywords.getD("RFBW", -1.0);
        double d3 = d2 * 0.4;
        Data data = dataFile.getDataBuffer(n);
        Data data2 = dataFile2.getDataBuffer(n3);
        dataFile.read(data);
        dataFile2.read(data2);
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            int n5 = i * n4;
            float f = Convert.unpackF((byte[])data2.buf, (int)(n5 + 4));
            float f2 = Convert.unpackF((byte[])data2.buf, (int)(n5 + 8));
            float f3 = f2 * 0.4f;
            boolean bl2 = bl = (double)f > d - d3 && (double)f < d + d3;
            if (!bl) continue;
            int n6 = Convert.unpackL((byte[])data2.buf, (int)(n5 + 0));
            int n7 = 0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            for (int j = 0; j < n && n7 == 0; ++j) {
                int n8 = j * n2;
                f5 = Convert.unpackF((byte[])data.buf, (int)(n8 + 4));
                f6 = Convert.unpackF((byte[])data.buf, (int)(n8 + 8));
                f4 = Convert.unpackF((byte[])data.buf, (int)(n8 + 12));
                if (!(f5 > f - f3) || !(f5 < f + f3)) continue;
                n7 = 1;
            }
            Convert.packL((byte[])data2.buf, (int)(n5 + 0), (int)n7);
            if (n7 > 0) {
                Convert.packF((byte[])data2.buf, (int)(n5 + 12), (float)f4);
            }
            if (n7 == n6) continue;
            this.M.info((CharSequence)("Track INDX=" + i + " FREQ=" + f + " BW=" + f2 + " SNR=" + f4 + " UP=" + n7));
        }
        dataFile2.seek(0.0);
        dataFile2.write(data2);
        dataFile2.close();
        dataFile.close();
    }

    private void greplog() {
        DataFile dataFile = this.MA.getDataFile("P1");
        dataFile.open();
        DataFile dataFile2 = this.MA.getDataFile("P2", dataFile, 0);
        dataFile2.open();
        String string = this.MA.getS("P3");
        Data data = dataFile.getDataBuffer(1);
        int n = (int)dataFile.getSize();
        for (int i = 0; i < n; ++i) {
            dataFile.read(data);
            String string2 = Convert.unpackS((byte[])data.buf, (int)24, (int)8);
            if (string.indexOf(string2) < 0) continue;
            dataFile2.write(data);
        }
        dataFile2.close();
        dataFile.close();
    }

    private void kvi() {
        KeyVector keyVector = (KeyVector)this.MA.getTable("P1").getCore();
        int n = this.MA.getL("P2");
        String string = this.MA.getU("P3");
        this.MR.put(string, keyVector.getIndex(n));
    }

    static {
        rowlabel = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "R", "T", "U", "V", "W", "Y", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AJ", "AK", "AL", "AM", "AN", "AP", "AR", "AT", "AU", "AV", "AW", "AY", "BA", "BB"};
        e2m = 0.0254;
        form = "%-6s%-10s%8.2f%8.3f%8.2f%8.3f%4d%8.2f%8.3f  %-6s%2d%8.2f%8.3f  D%1d";
    }
}

