/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.TimeCode;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.SDDSPacket;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class icetc
extends Primitive {
    private final String funcList = "Top,Extract,Insert,Select";
    private final int TOP = 1;
    private final int EXTRACT = 2;
    private final int INSERT = 3;
    private final int SELECT = 4;
    private DataFile hi;
    private DataFile ho;
    private ICEPacket pkt;
    private ICEPacket hpkt;
    private SDDSPacket spkt;
    private Data dbi;
    private Data dbo;
    private int func;
    private int nchn;
    private int ichn;
    private TimeCode tc = new TimeCode();
    private Time time = new Time();
    private Time timeTop = new Time();
    private Time timeZero;
    private int ndo;
    private int hack;
    private int xper;
    private int tag;
    private int ltag;
    private int seq;
    private int nseq = -1;
    private int seqerr = 0;
    private double delta;
    private double tolr;
    private boolean test;
    private boolean nopkt;
    private boolean gap;
    private boolean tic;
    private double exprate = 1.0;
    private double drift = 0.0;
    private double driftOffset = 0.0;
    private static final double tag2time = 1.4992503748125937E-8;
    private final String selList = "MinMax,NearLE,NearGE";
    private final int MINMAX = 1;
    private final int NEARLE = 2;
    private final int NEARGE = 3;
    private int selMode;
    private static final int TCS = 11;
    private static final int TCO = 12;
    private static final int TCWS = 13;

    public int open() {
        this.func = this.MA.getSelectionIndex("FUNC", "Top,Extract,Insert,Select", 0);
        this.nchn = this.MA.getL("/NCHN", 1);
        this.ichn = this.MA.getL("/ICHN");
        this.test = this.MA.getState("/TEST");
        this.gap = this.MA.getState("/GAP");
        this.tic = this.MA.getState("/TIC");
        this.verbose = this.MA.getState("/VERBOSE");
        this.selMode = this.MA.getSelectionIndex("/SELMODE", "MinMax,NearLE,NearGE", 0);
        this.hi = this.MA.getDataFile("IN", "1000,3000", "SB,SI,CI,NH", 0);
        this.hi.open(1);
        String string = this.MA.getS("MODE");
        if (string.equals("SDDS")) {
            this.spkt = (SDDSPacket)this.hi.getPacketHandler();
        } else if (!string.equals("ICE")) {
            this.tc.setMode(string);
        } else if (this.hi.typeClass == 3) {
            this.hpkt = new ICEPacket();
        } else {
            this.pkt = (ICEPacket)this.hi.getPacketHandler();
        }
        this.nopkt = this.pkt == null && this.hpkt == null && this.spkt == null;
        this.xfer = 8192;
        if (this.hpkt != null) {
            this.xfer = 1;
        }
        if (this.pkt != null) {
            this.xfer = this.pkt.getFixedSize();
        }
        if (this.spkt != null) {
            this.xfer = 1024 / this.hi.getBPS();
        }
        this.xper = this.xfer = this.MA.getL("/TL", this.xfer);
        this.delta = this.hi.getDelta();
        if (this.hpkt != null) {
            String string2 = this.hi.keywords.getMain("FS");
            if (string2 != null) {
                this.xper = Convert.s2l((String)string2);
            }
            this.delta /= (double)this.xper;
        }
        this.delta = this.MA.getD("/DELTA", this.delta);
        this.dbi = this.hi.getDataBuffer(this.xfer);
        this.hack = this.tc.getHack(this.delta);
        this.tolr = this.MA.getD("/TOLR", 1.0E-7);
        if (this.func == 3) {
            this.ho = this.MA.getDataFile("OUT", this.hi, 0);
            this.ho.open(2);
            this.time = this.MA.getTime("TIME", this.hi.getTime());
            this.tc.setTime(this.time);
            this.ho.setTime(this.time);
            this.ndo = this.tc.nextHack(this.delta);
        } else if (this.func == 4) {
            this.ho = this.MA.getDataFile("OUT", this.hi, 0);
            this.ho.open(2);
            this.time = this.MA.getTime("TIME");
            this.tc.setTime(this.time);
            this.ho.setTime(this.time);
        } else {
            this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
            this.ho.setSubRecords("OFF|SD,WSEC|SD,FSEC|SD,DIFF|SD");
            if (this.gap) {
                this.ho.setSubRecords("+GAP|SD");
            }
            this.ho.setXDelta(this.delta * (double)this.xper);
            this.ho.open(2 | 0x40);
            this.MR.put(this.MA.getU("TIME"), (Object)this.time);
            this.dbo = this.ho.getDataBuffer(1);
            this.ndo = this.xfer;
        }
        return 0;
    }

    public int process() {
        int n = 0;
        if (this.func == 3) {
            if (this.ndo == 0) {
                n = this.hi.read(this.dbi, 128);
                if (n < 0) {
                    return 9;
                }
                this.tc.setTimeCodeWords(this.dbi.buf, 0, n);
                this.ndo = this.tc.nextHack(this.delta) - n;
                this.ho.write(this.dbi, n);
            }
            if ((n = this.hi.read(this.dbi, Math.min(this.ndo, this.xfer))) < 0) {
                return 9;
            }
            this.tc.setFillWords(this.dbi.buf, 0, n);
            this.ho.write(this.dbi, n);
            this.ndo -= n;
        } else {
            if (this.func == 4) {
                double d = this.time.toJ1950();
                int n2 = (int)this.hi.getNumberOfRows();
                int n3 = this.determineFileMin(0, n2 - 1);
                if (n3 < 0) {
                    throw new MidasException("Error! The input file has no valid times");
                }
                int n4 = this.determineFileMax(n3, n2 - 1);
                double d2 = this.getTimeFile(n3);
                double d3 = this.getTimeFile(n4);
                boolean bl = d > d2 && d < d3;
                int n5 = -1;
                switch (this.selMode) {
                    case 2: {
                        if (!bl) {
                            this.M.warning((CharSequence)"****************************************************************");
                            this.M.warning((CharSequence)"** Start time is not inside the file boundaries!");
                            this.M.warning((CharSequence)("** File range: " + this.timeString(d2) + " -> " + this.timeString(d3)));
                            this.M.warning((CharSequence)"** Defaulting to the first valid index! ");
                            this.M.warning((CharSequence)"** Use /SELMODE=MINMAX  with icetc to determine valid times!");
                            this.M.warning((CharSequence)"****************************************************************");
                            n5 = n3;
                        } else {
                            n5 = this.searchRec(d, n3, n4);
                        }
                        Table table = this.hi.getDataTable((double)n5);
                        this.ho.setData(0.0, table);
                        break;
                    }
                    case 3: {
                        if (!bl) {
                            this.M.warning((CharSequence)"****************************************************************");
                            this.M.warning((CharSequence)"** End time is not inside the file boundaries!");
                            this.M.warning((CharSequence)("** File range: " + this.timeString(d2) + " -> " + this.timeString(d3)));
                            this.M.warning((CharSequence)"** Defaulting to the last valid index! ");
                            this.M.warning((CharSequence)"** Use /SELMODE=MINMAX  with icetc to determine valid times!");
                            this.M.warning((CharSequence)"****************************************************************");
                            n5 = n4;
                        } else {
                            n5 = this.searchRec(d, n3, n4) + 1;
                        }
                        Table table = this.hi.getDataTable((double)n5);
                        this.ho.setData(0.0, table);
                        break;
                    }
                    default: {
                        Table table = this.hi.getDataTable((double)n3);
                        this.ho.setData(0.0, table);
                        table = this.hi.getDataTable((double)n4);
                        this.ho.setData(1.0, table);
                    }
                }
                return 9;
            }
            double d = this.hi.getOffset();
            n = this.hi.read(this.dbi, this.xfer);
            if (n < 0) {
                return 9;
            }
            if (this.nchn > 0) {
                d /= (double)this.nchn;
            }
            if (this.hpkt != null) {
                System.arraycopy(this.dbi.buf, 0, this.hpkt.buf, 0, 64);
                int n6 = this.hpkt.getTC(this.tc.time, d, 0.0);
                int n7 = this.hpkt.getCount();
                int n8 = this.hpkt.getSize();
                int n9 = this.hpkt.getChannel();
                if (this.ichn >= 0 && n9 != this.ichn) {
                    return 0;
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.hpkt.listHeader());
                }
                if (n6 <= 0) {
                    return 0;
                }
                if (this.xper == 1) {
                    this.xper = n8;
                }
                if (n8 != this.xper) {
                    this.M.info((CharSequence)("Packet size=" + this.xper + " change to " + n8));
                    this.xper = n8;
                }
                if (n7 == 0 && d != 0.0) {
                    this.M.info((CharSequence)("Packet count restart at " + d));
                    this.drift = 0.0;
                    this.driftOffset = this.ho.getOffset();
                    this.timeZero = null;
                }
                d = this.hpkt.getTCO() + (double)n7 * (double)n8;
            } else if (this.pkt != null) {
                int n10 = this.pkt.getTC(this.tc.time, d, 0.0);
                int n11 = this.pkt.getChannel();
                if (this.ichn >= 0 && n11 != this.ichn) {
                    return 0;
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.pkt.listHeader());
                }
                if (n10 <= 0) {
                    return 0;
                }
                d += this.pkt.getTCO();
            } else if (this.spkt != null) {
                Time time = this.spkt.getTC();
                if (time != null) {
                    this.tc.time = time;
                } else {
                    this.tc.time.addSec((double)this.xfer * this.delta);
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.spkt.listHeader());
                }
                this.seq = this.spkt.getCount();
                if (this.test && this.seq != this.nseq && this.nseq >= 0) {
                    ++this.seqerr;
                    this.MT.writeln((CharSequence)("Sequence Error expect=" + this.nseq + "  got=" + this.seq + "  at=" + d));
                }
                this.nseq = this.seq + 1;
                if ((this.nseq & 0x1F) == 31) {
                    ++this.nseq;
                }
                this.nseq &= 0xFFFF;
            } else {
                this.ndo = this.xfer;
                int n12 = this.tc.findTimeCodeWords(this.dbi.buf, 0, n);
                if (n12 < 0) {
                    this.ndo = this.xfer;
                    return 0;
                }
                d += (double)n12;
            }
            this.timeTop.fromTime(this.tc.time);
            this.timeTop.addSec(-this.delta * d);
            if (this.timeZero == null) {
                this.timeZero = new Time();
                this.timeZero.fromTime(this.timeTop);
            }
            double d4 = this.timeTop.diff(this.timeZero);
            if (this.ho.isOpen) {
                this.dbo.setD(0, d);
                this.dbo.setD(1, this.tc.time.getWSec());
                this.dbo.setD(2, this.tc.time.getFSec());
                this.dbo.setD(3, d4);
                if (this.gap) {
                    byte[] byArray = new byte[64];
                    this.spkt.getBuffer(byArray, 0);
                    this.tag = Convert.unpackL((byte[])byArray, (int)4);
                    double d5 = this.ltag == 0 ? (double)this.spkt.getSize() * this.delta : (double)(this.tag - this.ltag) * 1.4992503748125937E-8;
                    this.dbo.setD(4, d5);
                    this.ltag = this.tag;
                }
                this.ho.write(this.dbo, 1);
            }
            double d6 = Math.abs(d4);
            double d7 = d6 - this.drift;
            if (this.test && d7 > this.tolr) {
                this.M.warning((CharSequence)("TC=" + this.tc.time + " at index=" + d + " err=" + d4 + " tolr=" + this.tolr));
            }
            this.drift = this.exprate * d6 + (1.0 - this.exprate) * this.drift;
            if (this.func == 1) {
                this.time.fromTime(this.timeTop);
                if (!this.tic || !(d < 0.0)) {
                    return 9;
                }
            }
            if (this.nopkt) {
                this.hi.seek(d + (double)this.hack - 4.0);
            }
            this.ndo = 256;
            this.time.fromTime(this.tc.time);
        }
        return 0;
    }

    public int close() {
        this.hi.close();
        this.ho.close();
        double d = this.drift / ((this.ho.getOffset() - this.driftOffset) * this.delta * (double)this.xper);
        if (this.test) {
            this.M.info((CharSequence)("TC drift total= " + this.drift + " sec  Rate=" + d + " sec/sec"));
        }
        if (this.test && this.seqerr > 0) {
            this.M.info((CharSequence)("SDDS seq err total= " + this.seqerr));
        }
        if (this.func == 1 && !this.MA.isPresent("TIME")) {
            this.MT.writeln((CharSequence)("TopTime=" + this.time.toString(9)));
        }
        return 0;
    }

    private String timeString(double d) {
        Time time = new Time();
        time.fromJ1950(d);
        return time.toString();
    }

    private double getTimeFile(int n) {
        return this.hi.getData((double)n, 13).getD(0) - this.hi.getData((double)n, 12).getD(0) * this.delta;
    }

    private boolean getValidFile(int n) {
        return this.hi.getData((double)n, 11).getP(0) > 0;
    }

    private int determineFileMin(int n, int n2) {
        boolean bl = this.getValidFile(n);
        boolean bl2 = this.getValidFile(n2);
        if (!bl && !bl2) {
            return this.determineFileMinLinear(n2);
        }
        if (bl) {
            return n;
        }
        if (n2 - n <= 1) {
            if (bl2) {
                return n2;
            }
            return -1;
        }
        int n3 = n + (n2 - n) / 2;
        if (this.getValidFile(n3)) {
            return this.determineFileMin(n, n3);
        }
        return this.determineFileMin(n3, n2);
    }

    private int determineFileMinLinear(int n) {
        for (int i = 0; i <= n; ++i) {
            if (!this.getValidFile(i)) continue;
            return i;
        }
        return -1;
    }

    private int determineFileMax(int n, int n2) {
        boolean bl = this.getValidFile(n);
        boolean bl2 = this.getValidFile(n2);
        if (!bl && !bl2) {
            return this.determineFileMaxLinear(n, n2);
        }
        if (bl2) {
            return n2;
        }
        if (n2 - n <= 1) {
            if (bl) {
                return n;
            }
            return -1;
        }
        int n3 = n + (n2 - n) / 2;
        if (this.getValidFile(n3)) {
            return this.determineFileMax(n3, n2);
        }
        return this.determineFileMax(n, n3);
    }

    private int determineFileMaxLinear(int n, int n2) {
        for (int i = n2; i > n; --i) {
            if (!this.getValidFile(i)) continue;
            return i;
        }
        return n;
    }

    private int searchRec(double d, int n, int n2) {
        if (n2 - n <= 1) {
            return n;
        }
        int n3 = n + (n2 - n) / 2;
        double d2 = this.getTimeFile(n3);
        if (d2 < d) {
            return this.searchRec(d, n3, n2);
        }
        return this.searchRec(d, n, n3);
    }
}

