/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import nxm.ice.net.HArchive;
import nxm.ice.net.HDisplay;
import nxm.ice.net.HMessage;
import nxm.ice.net.HQuery;
import nxm.ice.net.HServer;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.net.Rmif;

public class icermif
extends Primitive
implements Chainable {
    protected Rmif rmif;
    protected HServer http;
    protected TextFile logfile;
    private boolean killForTestingOnly = false;

    public int open() {
        String string;
        Rmif.Remote remote;
        String string2;
        boolean bl;
        int n;
        int n2;
        block16: {
            String string3;
            n2 = this.MA.getL("PORT");
            n = this.MA.getL("/PRANGE", 1);
            bl = this.MA.getState("/REOPEN", true);
            string2 = this.MA.getS("/HOST", "");
            if (this.verbose && !"".equals(string2)) {
                this.M.info((CharSequence)("HOST SWITCH: " + string2));
            }
            if (!"".equals(string3 = this.MA.getS("/DEVICE", ""))) {
                if (this.verbose) {
                    this.M.info((CharSequence)("DEVICE SWITCH: " + string3));
                }
                try {
                    NetworkInterface networkInterface = NetworkInterface.getByName(string3);
                    if (networkInterface != null) {
                        remote = networkInterface.getInetAddresses();
                        while (remote.hasMoreElements()) {
                            InetAddress inetAddress = remote.nextElement();
                            if (!(inetAddress instanceof Inet4Address)) continue;
                            string2 = inetAddress.getHostAddress();
                            break block16;
                        }
                        break block16;
                    }
                    this.M.warning((CharSequence)("Network device [" + string3 + "] could not be resolved."));
                }
                catch (SocketException socketException) {
                    this.M.printStackTrace((CharSequence)("Unable to get network device to bind on for /DEVICE=" + string3), (Throwable)socketException);
                }
            }
        }
        this.openRmifConnection(this.getMessageHandler(), string2, n2, n);
        if (this.MA.find("/LOG")) {
            this.openLogFile(this.MA.getTextFile("/LOG"));
        }
        this.initRmifConnection(bl, this.MA.getTable("/PPT"));
        this.rmif.addProperty("Q:SET");
        this.rmif.addProperty("Q:GET");
        this.rmif.addProperty("Q:RET");
        this.rmif.addProperty("Q:ACK");
        String string4 = this.MA.getS("PROPS");
        while (string4.length() > 0) {
            int n3 = string4.indexOf(124);
            if (n3 < 0) {
                string = string4;
                string4 = "";
            } else {
                string = string4.substring(0, n3);
                string4 = string4.substring(n3 + 1);
            }
            this.rmif.addProperty(string);
        }
        int n4 = 1;
        while (n4 * 2 < this.MA.nargs) {
            string4 = this.MA.getS(n4 * 2 + 1);
            remote = this.rmif.openRemote(Convert.o2t((Object)string4));
            string4 = this.MA.getS(n4 * 2 + 2);
            while (string4.length() > 0) {
                int n5 = string4.indexOf(124);
                if (n5 < 0) {
                    string = string4;
                    string4 = "";
                } else {
                    string = string4.substring(0, n5);
                    string4 = string4.substring(n5 + 1);
                }
                this.rmif.addChannel(remote, -1, string);
            }
            ++n4;
        }
        if (this.MA.getState("/HTTP")) {
            this.openHttpServer("ICE Web Server", this.MA.getCS("/HOMEPAGE"), this.MA.getS("/AUXLIST"));
        }
        return 0;
    }

    public int process() {
        int n = 0;
        n += this.rmif.checkRemotes();
        if ((n += this.rmif.serveProperties()) == 0) {
            return -1;
        }
        return 0;
    }

    public int close() {
        if (this.http != null) {
            this.http.stopThread();
        }
        if (this.rmif != null) {
            if (this.killForTestingOnly) {
                this.rmif.hardKillForTestingOnly();
            } else {
                this.rmif.close();
            }
        }
        if (this.logfile != null) {
            this.logfile.writeln("RMIF log stopped at " + Time.tag());
            this.logfile.close();
        }
        return 0;
    }

    protected void openRmifConnection(MessageHandler messageHandler, int n, int n2) {
        this.openRmifConnection(messageHandler, "0.0.0.0", n, n2);
    }

    protected void openRmifConnection(MessageHandler messageHandler, String string, int n, int n2) {
        this.rmif = new Rmif(this.M, (MessageHandler)this, messageHandler);
        this.rmif.open(string, n, n2);
    }

    protected void openLogFile(TextFile textFile) {
        this.logfile = textFile;
        if (this.logfile.open(50)) {
            this.logfile.writeln("RMIF log started at " + Time.tag());
            this.rmif.setLogFile(this.logfile);
        } else {
            this.M.warning((CharSequence)("Could not open log at URL=" + this.logfile.getURL()));
        }
    }

    protected void initRmifConnection(boolean bl, Table table) {
        this.rmif.setVerbose(this.verbose);
        this.rmif.setReOpen(bl);
        if (table != null) {
            KeyObject.setKeys((Object)this.rmif, (Table)table);
        }
    }

    protected void openHttpServer(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        this.http = HServer.launch((Object)this, string, this.rmif.getPort(), string2, string3);
        this.http.addSource(new HDisplay("Display", this.M));
        this.http.addSource(new HArchive("Archive", this.M));
        this.http.addSource(new HMessage("Message", this.M));
    }

    public int getPartners() {
        return this.MA.getL("/PARTNERS", 0);
    }

    public HServer getServer() {
        return this.http;
    }

    public synchronized int processMessage(Message message) {
        if (!this.thisIsMe()) {
            this.MQ.put(message);
            return 0;
        }
        Rmif.Remote remote = null;
        int n = 0;
        Object object = message.getQuals();
        if (object instanceof Table) {
            String string = ((Table)object).getS("PROTOCOL");
            n = Parser.find((String)"RDP,UDP,TCP,IDP", (String)string, (int)0, (int)-1);
        }
        if (message.to instanceof Rmif.Remote) {
            remote = (Rmif.Remote)message.to;
        } else if (message.to instanceof Rmif.RemoteAddress) {
            remote = this.rmif.getRemoteForAddress((Rmif.RemoteAddress)message.to);
        }
        if (this.verbose) {
            this.M.info((CharSequence)("Processing msg: " + message.name));
        }
        if (message.name.startsWith("ADDR")) {
            remote = this.rmif.addRemote(Convert.o2t((Object)message.data));
        } else if (message.name.equals("OPEN")) {
            remote = this.rmif.openRemote(Convert.o2t((Object)message.data));
            if (this.http != null) {
                this.http.addSource(new HQuery(remote.getTag(), remote, null, 64));
            }
        } else if (message.name.startsWith("ADDC")) {
            int n2 = 0;
            if (message.name.indexOf("/M") > 0) {
                n2 = 1;
            }
            this.rmif.addChannel(remote, message.info, message.data.toString(), n2);
        } else if (message.name.startsWith("DELC")) {
            if (message.info > 0) {
                this.rmif.closeChannel(message.info);
            } else {
                this.rmif.closeChannel(message.data.toString());
            }
        } else if (message.name.equals("RADDR")) {
            if (message.data != null) {
                remote = this.rmif.getRemote(Convert.o2t((Object)message.data));
            }
            this.rmif.removeRemote(remote);
            if (this.http != null) {
                this.http.removeSource(remote.getTag());
            }
        } else if (message.name.startsWith("CLOSE")) {
            this.rmif.closeRemote(remote);
            if (message.name.indexOf("/R") > 0) {
                this.rmif.removeRemote(remote);
            }
            if (this.http != null) {
                this.http.removeSource(remote.getTag());
            }
        } else if (message.name.equals("SET")) {
            while (remote != null) {
                this.rmif.sendPacket((byte)101, message.info, Convert.o2ba((Object)message.data), remote, n);
                remote = remote.next;
            }
        } else if (message.name.equals("GET")) {
            while (remote != null) {
                this.rmif.sendPacket((byte)102, message.info, Convert.o2ba((Object)message.data), remote, n);
                remote = remote.next;
            }
        } else if (message.name.equals("RET")) {
            if (remote == null) {
                this.rmif.servePacket((byte)103, message.info, Convert.o2ba((Object)message.data), n);
            } else {
                this.rmif.sendPacket((byte)103, message.info, Convert.o2ba((Object)message.data), remote, n);
            }
        } else if (message.name.equals("ACK")) {
            if (remote == null) {
                this.rmif.servePacket((byte)104, message.info, Convert.o2ba((Object)message.data), n);
            } else {
                this.rmif.sendPacket((byte)104, message.info, Convert.o2ba((Object)message.data), remote, n);
            }
        } else if (message.name.equals("KEYS") || message.name.equals("PROPS")) {
            this.rmif.sendPacket((byte)121, message.info, remote, n);
        } else if (message.name.equals("PING")) {
            this.rmif.sendPacket((byte)109, 0, remote, n);
        } else if (message.name.equals("MODIFY")) {
            while (remote != null) {
                this.rmif.sendPacket((byte)114, message.info, Convert.o2ba((Object)message.data), remote, n);
                remote = remote.next;
            }
        } else if (message.name.equals("TESTLINK")) {
            this.rmif.testLink(remote, message.info);
        } else {
            if (message.name.equals("EXIT")) {
                return 9;
            }
            if (message.name.equals("KILL_FOR_TESTING_ONLY")) {
                this.M.warning((CharSequence)("RMIF: '" + this.getID() + "' killed by " + message.from));
                this.killForTestingOnly = true;
                return 9;
            }
        }
        return 0;
    }

    public KeyVector getRemotes() {
        return this.rmif.getRemotes();
    }

    public KeyVector getProps() {
        return this.rmif.getProperties();
    }

    public KeyVector getChans() {
        return this.rmif.getChannels();
    }

    public Object getNextLink() {
        return this.rmif;
    }

    public Object getPrevLink() {
        return null;
    }

    public Rmif getRmif() {
        return this.rmif;
    }

    public synchronized void setMessageHandler(MessageHandler messageHandler) {
        super.setMessageHandler(messageHandler);
        if (this.rmif != null) {
            this.rmif.setMessageHandler(messageHandler);
        }
    }
}

