/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;

public class icepa
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data dati;
    private Data dato;
    private int mode = 1;
    private int spb;
    private int hspb;
    private int spms;
    private int bufSize = 65536;
    private double xs;
    private double xd;
    private long offset;
    private byte[][] cmda = new byte[32][8];
    public static String protocolList = "USB2LS,USB2FS,USB2HS,USB3,DP,PCIe,AUX,TGbE";
    public static String usb2cmdList = "OUT,ACK,DATA0,PING,SOF,NYET,DATA2,SPLIT,IN,NAK,DATA1,PRE,SETUP,STALL,MDATA,SE0,RESET";
    public static String usb2smBits = "rsv,rx_recv,rx_dm,rx_dp,intr,tx_se0,tx_data,tx_en";
    public static int U2_IDLE = 0;
    public static int U2_SE0 = 16;
    public static int U2_RESET = 17;
    public static int U2_LAST = 18;
    int lbdr = 32;
    int state = 0;
    long start = 0L;
    int length = 0;
    int lcmd;
    byte[] bcmd = new byte[4096];
    byte[] bdata = new byte[256];

    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
        this.ho.setSubRecords("TIME|SD,RPT|SL,LEN|SL,TYPE|1A,DATA|1A");
        this.ho.open(2);
        this.mode = this.MA.getSelectionIndex("MODE", protocolList, this.mode);
        this.spb = this.mode == 2 ? 5 : 40;
        this.hspb = this.spb / 2;
        this.spms = 60000;
        this.setProgressFeed(this.hi, "IcePA " + this.hi.getURL() + " to " + this.ho.getURL());
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hi.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.dati = this.hi.getDataBuffer(this.xfer);
        this.dato = this.ho.getDataBuffer(1);
        this.xs = 0.0;
        this.xd = this.hi.getXDelta();
        this.offset = 0L;
        Parser parser = new Parser(usb2cmdList);
        for (int i = 0; i < U2_LAST; ++i) {
            String string;
            String string2 = string = i == 0 ? "IDLE" : parser.get(i);
            while (string.length() < 8) {
                string = string + " ";
            }
            this.cmda[i] = string.getBytes();
        }
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dati);
        if (n <= 0) {
            return 9;
        }
        this.processUSB(this.dati.buf, n);
        this.offset += (long)n;
        return 0;
    }

    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }

    void writeOut(long l, int n, int n2, int n3, byte[] byArray, int n4) {
        Convert.packD((byte[])this.dato.buf, (int)0, (double)(this.xs + this.xd * (double)l));
        Convert.packL((byte[])this.dato.buf, (int)8, (int)n);
        Convert.packL((byte[])this.dato.buf, (int)12, (int)n2);
        Convert.packA((byte[])this.dato.buf, (int)16, (int)8, (byte[])this.cmda[n3]);
        Convert.packA((byte[])this.dato.buf, (int)24, (int)n4, (byte[])byArray);
        this.ho.write(this.dato, 1);
    }

    void processUSBcmd() {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        while (n4 < this.lcmd) {
            boolean bl = this.bcmd[n4] == 0 ^ this.bcmd[n4 - 1] == 0;
            if (bl) {
                n5 = 0;
            } else if (++n5 == 6) {
                n5 = 0;
                bl = this.bcmd[++n4] == 0 ^ this.bcmd[n4 - 1] == 0;
            }
            int n6 = n3 & 7;
            if (n6 == 0) {
                this.bdata[n2] = 0;
            }
            if (!bl) {
                int n7 = n2;
                this.bdata[n7] = (byte)(this.bdata[n7] | 1 << n6);
            }
            if (n6 == 7) {
                ++n2;
            }
            if (n3 == 15) {
                n = this.bdata[1] & 0xF;
                n2 = 0;
            }
            ++n4;
            ++n3;
        }
        if (n2 > 4) {
            n2 = 4;
        }
        String string = Convert.bb2hex((byte[])this.bdata, (int)0, (int)n2).substring(2);
        while (string.length() < 8) {
            string = string + " ";
        }
        byte[] byArray = string.getBytes();
        int n8 = 1;
        this.writeOut(this.start, n8, n3, n, byArray, 8);
    }

    void processUSB(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            int n2 = by & 0x30;
            if (by < 0) continue;
            if (n2 != this.lbdr) {
                if (n2 == 0) {
                    if (this.state > 0 && this.lcmd > 0) {
                        this.processUSBcmd();
                    }
                    this.state = -1;
                    this.start = this.offset + (long)i;
                    this.length = 0;
                } else if (this.state < 0 && n2 != 0) {
                    int n3 = this.length / this.spms;
                    if (n3 > 0) {
                        this.writeOut(this.start, 1, n3, U2_RESET, byArray, 0);
                    }
                    this.state = 0;
                } else if (this.state == 0 && n2 == 16) {
                    this.state = 1;
                    this.start = this.offset + (long)i;
                    this.length = 0;
                    this.lcmd = 0;
                }
            }
            if (this.state > 0 && this.length % this.spb == this.hspb && this.lcmd < 4096) {
                if (n2 == 48) {
                    n2 = this.lbdr;
                    System.out.println("Bad BDR at " + this.offset + " " + i);
                }
                this.bcmd[this.lcmd++] = n2 == 16 ? (byte)1 : 0;
            }
            ++this.length;
            this.lbdr = n2;
        }
    }
}

