/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.GPrimitive;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.MWindow;

public class browse
extends GPrimitive
implements MouseListener,
MouseMotionListener,
HyperlinkListener {
    private int level = 0;
    private int status = 0;
    private boolean exiting;
    private JScrollPane jsp;
    private JEditorPane jep;
    private URL[] urls = new URL[10];
    private int[] scrolls = new int[10];
    private static final int MIDDLE_MOUSE_BUTTON = 2;
    private static final int RIGHT_MOUSE_BUTTON = 3;
    private static Desktop desktop;

    public int open() {
        URL uRL;
        String string = this.MA.getCS("URL");
        this.urls[this.level] = uRL = this.formURL(string);
        this.MW = new MWindow("Text/HTML Browser", (MessageHandler)this);
        this.MW.open();
        this.MW.addTo((Object)this);
        this.jep = new JEditorPane();
        this.jep.setContentType("text/html");
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(this);
        this.jep.addMouseMotionListener(this);
        this.jep.addMouseListener(this);
        this.showDoc(uRL);
        this.jsp = new JScrollPane();
        this.jsp.setViewportView(this.jep);
        Container container = this.MW.getPanel();
        container.setLayout(new BorderLayout());
        container.add(this.jsp);
        container.revalidate();
        return 0;
    }

    private void revalidate() {
        Container container = this.MW.getPanel();
        if (container == null || !container.isShowing()) {
            return;
        }
        Container container2 = container.getParent();
        if (container2 == null || !container2.isShowing()) {
            return;
        }
        container2.revalidate();
        container.revalidate();
    }

    private URL formURL(String string) {
        if (!string.startsWith("\"")) {
            string = "\"" + string + "\"";
        }
        FileName fileName = BaseFile.getFileNameFor((MidasReference)this, (String)string);
        string = fileName.getFullName();
        string = string.replaceAll("\\\\", "/");
        URL uRL = null;
        if (string.indexOf(":") != 4) {
            string = "file:" + string;
        }
        try {
            uRL = new URI(string).toURL();
        }
        catch (Exception exception) {
            System.out.println("Bad URL: " + exception);
        }
        return uRL;
    }

    private void showDoc(URL uRL) {
        try {
            Document document = this.jep.getDocument();
            if (document != null) {
                document.putProperty("stream", null);
            }
            this.jep.setPage(uRL);
        }
        catch (Exception exception) {
            System.out.println("Bad Document: " + exception);
        }
    }

    public int process() {
        if (this.exiting) {
            return 9;
        }
        return -1;
    }

    public int close() {
        this.MW.close();
        return 0;
    }

    public int processMessage(Message message) {
        block11 : switch (message.name) {
            case "PAINT": {
                break;
            }
            case "REFRESH": {
                this.MW.refresh();
                break;
            }
            case "RESIZE": {
                this.MW.resize(1);
                this.revalidate();
                break;
            }
            case "WINDOW": {
                if (message.info != 0) break;
                this.exiting = true;
                break;
            }
            case "SAVEFILE": {
                this.saveCurrent();
                break;
            }
            case "SAVEFILEAS": {
                this.saveCurrent(message.data.toString());
                break;
            }
            case "BUTTON": {
                if (message.info != 2) break;
                new GMenu((Object)this.MW, "Browse", "Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit", 0, 0, (MessageHandler)this);
                break;
            }
            case "OPENFILE": {
                URL uRL = this.formURL(message.data.toString());
                this.level = message.info < 0 ? ++this.level : message.info;
                this.urls[this.level] = uRL;
                this.showDoc(uRL);
                break;
            }
            case "BROWSE": {
                switch (message.data.toString()) {
                    case "BACK": {
                        if (this.level <= 0) break block11;
                        if (this.jep.isEditable()) {
                            this.verifyCurrent();
                            break block11;
                        }
                        this.showDoc(this.urls[--this.level]);
                        break block11;
                    }
                    case "FORWARD": {
                        if (this.urls[this.level + 1] == null) break block11;
                        if (this.jep.isEditable()) {
                            this.verifyCurrent();
                            break block11;
                        }
                        this.showDoc(this.urls[++this.level]);
                        break block11;
                    }
                    case "OPENBROWSER": {
                        this.openBrowser(this.urls[this.level]);
                        break block11;
                    }
                    case "OPENEDITOR": {
                        this.openEditor(this.urls[this.level]);
                        break block11;
                    }
                    case "SYNC": {
                        if (!this.jep.isEditable()) break block11;
                        this.saveCurrent();
                        break block11;
                    }
                    case "EDIT": {
                        this.jep.setEditable(true);
                        break block11;
                    }
                    case "SAVE": {
                        this.saveCurrent();
                        break block11;
                    }
                    case "SAVEAS": {
                        this.jep.setEditable(false);
                        new GFiles((Object)this.MW, "SaveFileAs", this.urls[this.level].toString(), "*.txt|java|jv|c|sv|v", null, this.M, 0, 0, 0, (MessageHandler)this);
                        break block11;
                    }
                    case "EXIT": {
                        this.exiting = true;
                        break block11;
                    }
                    default: {
                        this.M.warning((CharSequence)("Browse menu item=" + message.data + " not coded yet"));
                    }
                }
            }
        }
        return 0;
    }

    private void verifyCurrent() {
        new GAlert((Object)this.MW, "SaveFile", "Save current modifications? ", "Yes,No", 1, 0, (MessageHandler)this);
    }

    private void saveCurrent() {
        String string = this.urls[this.level].toString();
        this.saveCurrent(string);
    }

    private void saveCurrent(String string) {
        this.jep.setEditable(false);
        String string2 = this.jep.getText();
        TextFile textFile = new TextFile(string);
        this.M.info((CharSequence)("Saving file as: " + string));
        textFile.open(2);
        textFile.write(string2);
        textFile.close();
    }

    public boolean openBrowser(URL uRL) {
        boolean bl = false;
        if (desktop != null && uRL != null) {
            try {
                desktop.browse(new URI(uRL.toString()));
                bl = true;
            }
            catch (Exception exception) {
                Shell.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public boolean openEditor(URL uRL) {
        String string = this.MR.getString("ENV.EDITOR");
        String string2 = uRL.toString();
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        Foreign.runInternal((Midas)this.M, (String)(string + " " + string2));
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = browse.event2button(mouseEvent);
        if (n == 3 && this.level > 0) {
            this.showDoc(this.urls[--this.level]);
        }
        if (n == 2) {
            new GMenu((Object)this.MW, "Browse", "Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit", 0, 0, (MessageHandler)this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.MW.px = mouseEvent.getX();
        this.MW.py = mouseEvent.getY();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private static int event2button(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        int n2 = mouseEvent.getModifiersEx();
        if (n == 0) {
            n = (n2 & 0x400) != 0 ? 1 : ((n2 & 0x800) != 0 ? 2 : ((n2 & 0x1000) != 0 ? 3 : 1));
        } else if (n > 3) {
            n = 1;
        }
        return n;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                this.M.warning((CharSequence)"Frame hyperlink event");
            } else if (this.level >= this.urls.length - 1) {
                this.M.warning((CharSequence)"Too many hyperlinkevt.getURL() levels");
            } else {
                URL uRL = hyperlinkEvent.getURL();
                String string = uRL.toString();
                int n = string.indexOf(63);
                if (n < 0) {
                    this.urls[++this.level] = uRL;
                } else if (string.charAt(n - 1) == '/') {
                    string = this.urls[this.level].toString() + string.substring(n);
                    try {
                        uRL = new URI(string).toURL();
                    }
                    catch (Exception exception) {
                        System.out.println("Browse: " + exception);
                    }
                }
                this.showDoc(uRL);
            }
        }
    }

    static {
        try {
            desktop = Desktop.getDesktop();
        }
        catch (Exception exception) {
            Shell.warning((CharSequence)("Unable to get java.awt.Desktop instance for using browse(URI) method: " + exception));
        }
    }
}

